#pragma once
using namespace Digi21::SensorConico::Matematicas;

namespace Digi21{
namespace SensorConico{
namespace Pluggin{
	interface IInterna{
		virtual bool getEsVirtual() const=0;
		_declspec(property(get=getEsVirtual)) bool EsVirtual;

		virtual bool getCalculadaConImagenRotada() const = 0;
		_declspec(property(get=getCalculadaConImagenRotada)) bool CalculadaConImagenRotada;

		virtual MaxMinPixel getZonaCorrelable() const = 0;
		_declspec(property(get=getZonaCorrelable)) MaxMinPixel ZonaCorrelable;

		virtual CPuntoFiducial PixelAFiducial(const CPuntoPixel& pixel) const=0;
		virtual CPuntoPixel FiducialAPixel(const CPuntoFiducial& fiducial) const=0;
	};
	///	<summary>
	///		Este interface representa los mtodos que debe implementar un corrector de distorsiones en fotocoordenadas.
	///	</summary>
	interface ICamara: public IDestruible{
		virtual CPuntoFiducial getPuntoPrincipal() const = 0;
		__declspec(property(get=getPuntoPrincipal)) CPuntoFiducial PuntoPrincipal;

		virtual double getFocal() const = 0;
		__declspec(property(get=getFocal)) double Focal;

		virtual CPuntoFiducial FotoAFiducial(const CPuntoFoto& foto) const = 0;
		virtual CPuntoFoto FiducialAFoto(const CPuntoFiducial& fiducial) const = 0;
	};

	interface ICamaraDigital{
		virtual double PixelWidth(int imageWidth) const = 0;
		virtual double PixelHeight(int imageHeight) const = 0;
	};

	///	<summary>
	///		Este interface representa una fbrica de correctores de distorsiones.
	///	</summary>
	interface IFabricaCamaras{
		///	<summary>
		///		El sensor Digi3D.ConicSensor llamar a este mtodo para asignar un corrector de fotocoordenadas.
		///	</summary>
		///	<param name="ficheroint">Ruta al fichero de interna, normalmente con extensin .int.</param>
		///	<returns>NULL si no se pudo instanciar el corrector o un puntero al corrector recin instanciado.</returns>
		virtual ICamara* CreaCamara(const wchar_t* ficheroint) = 0;
	};
}}}
