//Compile with /J
#include "..\system.h"
#include <tchar.h>
#include <cstdlib>
#include <cmath>
#include <io.h>
#define interface struct
interface IDestruible{
	virtual void Delete() = 0;
};
#include "sdk/PuntoFiducial.h"	//Incluye PuntoFoto y PuntoPixel
#include "sdk/ICamara.h"
using namespace Digi21;
using namespace Digi21::SensorConico::Matematicas;
using namespace Digi21::SensorConico::Pluggin;

#include "..\distorsion.h"
#include ".\CamaraCalibra.h"

class FabricaCamarasCalibra : public IFabricaCamaras{
public:
	virtual ICamara* CreaCamara(const wchar_t* ficheroint);
};
FabricaCamarasCalibra g_sFabrica;

extern "C" __declspec(dllexport) IFabricaCamaras* GetFabricaCamaras(){ 
	return &g_sFabrica; 
}

void CamaraCalibra::Delete(){
	free_interna(&this->interna);
	delete this;
}

using namespace Digi21::SensorConico::Matematicas;

CPuntoFiducial CamaraCalibra::getPuntoPrincipal() const
{return CPuntoFiducial(this->interna.valI.x,this->interna.valI.y);}

double CamaraCalibra::getFocal() const
{return this->interna.valI.f;}

CPuntoFoto CamaraCalibra::FiducialAFoto(const CPuntoFiducial& fiducial) const
{
	Puntoxy_double p;
	OrientacionInterna in=this->interna;
	p.x=fiducial.x;	p.y=fiducial.y;
	if(this->bpixel) in.flags&=~1;
	medida_a_fotocoord(&p,&in);
	return CPuntoFoto(p.x, p.y);
}
CPuntoFiducial CamaraCalibra::FotoAFiducial(const CPuntoFoto& foto) const
{
	Puntoxy_double p;
	OrientacionInterna in=this->interna;
	p.x=foto.x;	p.y=foto.y;
	if(this->bpixel) in.flags&=~1;
	fotocoord_a_medida(&p,&in);
	return CPuntoFiducial(p.x, p.y);
}

bool CamaraCalibraConInterna::getEsVirtual() const
{
	return false;
}
bool CamaraCalibraConInterna::getCalculadaConImagenRotada() const
{
	return false;
}
MaxMinPixel CamaraCalibraConInterna::getZonaCorrelable() const
{
	MaxMinPixel c;
	CPuntoPixel p0,p1;
	p0.x=p0.y=0;
	p1.x=p1.y=0;

	uintptr_t *ptr=this->interna.info;
	if(ptr!=NULL){while(*ptr){
		uintptr_t t=*ptr++;
		if(t==1) p0.x=*(float*)ptr;
		else if(t==2) p1.x=*(float*)ptr;
		else if(t==3) p0.y=*(float*)ptr;
		else if(t==4) p1.y=*(float*)ptr;
		ptr++;
	}}
	c.TopLeft=p0;
	c.BottomRight=p1;
	return c;
}

CPuntoFiducial CamaraCalibraConInterna::PixelAFiducial(const CPuntoPixel& pixel) const
{
	if(!this->bpixel) return CPuntoFiducial(pixel.x, pixel.y);

	Puntoxy_double p;
	OrientacionInterna in=this->interna;

	p.x=pixel.x;	p.y=pixel.y;
	in.flags=1;
	medida_a_fotocoord(&p,&in);
	return CPuntoFiducial(p.x,p.y);
}
CPuntoPixel CamaraCalibraConInterna::FiducialAPixel(const CPuntoFiducial& fiducial) const
{
	if(!this->bpixel) return CPuntoPixel(fiducial.x, fiducial.y);

	Puntoxy_double p;
	OrientacionInterna in=this->interna;

	p.x=fiducial.x;	p.y=fiducial.y;
	in.flags=1;
	fotocoord_a_medida(&p,&in);
	return CPuntoPixel(p.x,p.y);
}

//#include <windows.h>

#define MAX_PATH 255
ICamara* FabricaCamarasCalibra::CreaCamara(const wchar_t* ficheroint){
	if(_waccess(ficheroint, 0)) return NULL;

	wchar_t mensaje[512];
	CamaraCalibra *pCamara=new CamaraCalibra;
	pCamara->interna.flags=0;
	zeroset(&pCamara->interna.distorsion,sizeof(Distorsion));	//asumes NULL=0

	{int nret=lee_ficheroint(ficheroint,0,&pCamara->interna,mensaje,0);
	if(nret && nret!=3 && nret!=4){
		//::MessageBeep(-1);
		pCamara->Delete();
		return NULL;
	}}

	pCamara->bpixel=0;
	Lineal2D_fl *ptr=&pCamara->interna.afin_1;
	if(!(pCamara->interna.flags &1) || (ptr->a*ptr->d-ptr->b*ptr->c)>=0) return pCamara;

	//::MessageBox(NULL,"point 2",NULL,0);

	CamaraCalibraConInterna *pCamaraI=new CamaraCalibraConInterna;
	memcpy(&pCamaraI->interna,&pCamara->interna,sizeof(OrientacionInterna));
	delete pCamara;
	pCamaraI->bpixel=1;
	return pCamaraI;
}
