Name Aerotri
!ifdef DEMO
OutFile Aerotri2012_${BITS}b_demo.exe
!else
!ifdef VISOR
OutFile Aerotri2012_${BITS}b_visor.exe
!else
!define COMPLETO
OutFile Aerotri2012_${BITS}b.exe
!endif
!endif
SetCompressor /SOLID lzma

InstallDir $PROGRAMFILES${BITS}\Aerotri
!include FileAssociations.nsi

LoadLanguageFile "${NSISDIR}\Contrib\Language files\English.nlf"
LoadLanguageFile "${NSISDIR}\Contrib\Language files\Spanish.nlf"
LoadLanguageFile "${NSISDIR}\Contrib\Language files\Italian.nlf"

VIProductVersion 3.10.2.0
VIAddVersionKey "ProductName" "Aerotri 2012"
VIAddVersionKey "Comments" "Productos de la familia Aerotri"
VIAddVersionKey "Autor" "Javier A. Mgica de Rivera"
VIAddVersionKey "LegalCopyright" " El autor, 2003-2019. Se permite su uso y distribucin libres / Grantes free use and redistribution"
VIAddVersionKey "FileDescription" "Instalador de Aerotri"
VIAddVersionKey "FileVersion" "3.10.2"

LangString AerotriDir ${LANG_SPANISH} "La carpeta Aerotri con el programa se instalar en el siguiente directorio. Para instalar en un directorio diferente presione Examinar y seleccione otro directorio"
LangString AerotriDir ${LANG_ENGLISH} "The Aerotri folder with the program will be installed in the following directory. To install in a different directory, click Browse and select another directory"
LangString AerotriDir ${LANG_ITALIAN} "La cartella Aerotri col programma sar istallata nel direttorio seguente. Per istallare in un direttorio diverso, seleziona Sfoglia e scegliene un altro"
DirText $(AerotriDir) "" "" ""

LangString Desinstalar ${LANG_SPANISH} "Existen ms versiones de Aerotri instaladas en este equipo.$\n Desea desinstalarlas?"
LangString Desinstalar ${LANG_ENGLISH} "There are other Aerotri versions installed on the system.$\n Do you want to remove them?"
LangString Desinstalar ${LANG_ITALIAN} "Ci sono pi verisioni di Aerotri installate in questo computer.$\n Vuoi rimuoverle?"
LangString FicherosMovidos0 ${LANG_SPANISH} "Parece ser que los ficheros se han movido de sitio desde que se instal el programa$\nSi pulsa S se borrar toda la carpeta: "
LangString FicherosMovidos1 ${LANG_SPANISH} "$\nSi pulsa No, se borrar toda la carpeta: "
LangString FicherosMovidos2 ${LANG_SPANISH} "$\nSi quiere detener la desinstalacin pulse Cancelar"
LangString FicherosMovidos0 ${LANG_ENGLISH} "It seems as if the files have been moved since the time the program was installed$\nIf you press Yes this whole folder will be deleted: "
LangString FicherosMovidos1 ${LANG_ENGLISH} "$\nIf you press No, this whole folder will be deleted: "
LangString FicherosMovidos2 ${LANG_ENGLISH} "$\nIf you want to cancel the uninstallation press Cancel"
LangString FicherosMovidos0 ${LANG_ITALIAN} "Pare che i file sono stati mossi sin dall'istallazione del programma$\nSe prema Si si eliminar tutta la cartella: "
LangString FicherosMovidos1 ${LANG_ITALIAN} "$\nSe prema Non, si eliminar tutta la cartella: "
LangString FicherosMovidos2 ${LANG_ITALIAN} "$\nSe vuoi cancelare la disistallazione premi Cancela"
LangString DesinstalarTodo ${LANG_SPANISH} "Desea desinstalar tambin las configuraciones de usuario? Se recomienda:$\n$\nS, si desea eliminar completamente Aerotri$\nNo, si volver a usar Aerotri en el futuro"
LangString DesinstalarTodo ${LANG_ENGLISH} "Would you like to remove alse the user settings? It is recomended:$\n$\nYes, if you want Aerotri to be completely removed from your computer.$\nNo, if you expect to use Aerotri again in the future"
LangString DesinstalarTodo ${LANG_ITALIAN} "Vuole disistallare anche le configurazioni di usuario? Si consiglia:$\n$\nSi, se vuole eliminare completamente Aerotri dal computer$\nNo, se pensa di usare Aerotri di nuovo in futuro"

LangString Programas_Ej ${LANG_SPANISH} "Programas y ejemplos"
LangString Programas_Ej ${LANG_ENGLISH} "Programs and example files"
LangString Programas_Ej ${LANG_ITALIAN} "Programmi ed esempi"
LangString Manuales ${LANG_SPANISH} "Manuales"
LangString Manuales ${LANG_ENGLISH} "Manuals"
LangString Manuales ${LANG_ITALIAN} "Manuali"

LangString Abrir ${LANG_SPANISH} "Abrir"
LangString Abrir ${LANG_ENGLISH} "Open"
LangString Abrir ${LANG_ITALIAN} "Apri"
LangString Aerotri.ftm ${LANG_SPANISH} "Fichero de fotogramas de Aerotri, marcado"
LangString Aerotri.ftm ${LANG_ENGLISH} "Photographs file from Aerotri, marked"
LangString Aerotri.ftm ${LANG_ITALIAN} "File di fotogrammi di Aerotri, segnato"
LangString Aerotri.pro ${LANG_SPANISH} "Processo de clculo de valores aproximados"
LangString Aerotri.pro ${LANG_ENGLISH} "Process of computation of approximate values"
LangString Aerotri.pro ${LANG_ITALIAN} "Processo di calcolo di valori approssimati"
LangString Aerotri.prm ${LANG_SPANISH} "Fichero de valores aproximados Aerotri"
LangString Aerotri.prm ${LANG_ENGLISH} "Approximate values file from Aerotri"
LangString Aerotri.prm ${LANG_ITALIAN} "File di valori approssimati di Aerotri"
LangString Aerotri.pym ${LANG_SPANISH} "Fichero de puntos de apoyo Aerotri, marcado"
LangString Aerotri.pym ${LANG_ENGLISH} "Control file from Aerotri, marked"
LangString Aerotri.pym ${LANG_ITALIAN} "File di punti di appoggio di Aerotri, segnato"
LangString Aerotri.gpm ${LANG_SPANISH} "Fichero de observaciones GPS e INS de Aerotri, marcado"
LangString Aerotri.gpm ${LANG_ENGLISH} "GPS and INS observation file from Aerotri, marked"
LangString Aerotri.gpm ${LANG_ITALIAN} "File di osservazioni GPS e INS di Aerotri, segnato"
LangString Aerotri.gpn ${LANG_SPANISH} "Fichero de observaciones GPS e INS de Aerotri, nuevo marcado"
LangString Aerotri.gpn ${LANG_ENGLISH} "GPS and INS observation file from Aerotri, new marked"
LangString Aerotri.gpn ${LANG_ITALIAN} "File di osservazioni GPS e INS di Aerotri, nuovo segnato"
LangString Aerotri.ajs ${LANG_SPANISH} "Fichero de valores ajustados de Aerotri"
LangString Aerotri.ajs ${LANG_ENGLISH} "Adjusted values file from Aerotri"
LangString Aerotri.ajs ${LANG_ITALIAN} "File di valori compensati di Aerotri"
LangString Aerotri.inf ${LANG_SPANISH} "Fichero de informacin del ajuste de Aerotri"
LangString Aerotri.inf ${LANG_ENGLISH} "File of adjustment information from Aerotri"
LangString Aerotri.inf ${LANG_ITALIAN} "File d'informazione della compensazione di Aerotri"
LangString Aerotri.int ${LANG_SPANISH} "Orientacin interna de una cmara"
LangString Aerotri.int ${LANG_ENGLISH} "Camera inner orientation"
LangString Aerotri.int ${LANG_ITALIAN} "Orientazione interna di una camera"
LangString Aerotri.gra ${LANG_SPANISH} "Grfico de Aerotri"
LangString Aerotri.gra ${LANG_ENGLISH} "Aerotri graphic"
LangString Aerotri.gra ${LANG_ITALIAN} "Grafico de Aerotri"
LangString Aerotri.bnf ${LANG_SPANISH} "Fichero binario de resultados de Aerotri"
LangString Aerotri.bnf ${LANG_ENGLISH} "Binary file containing the outcome from Aerotri"
LangString Aerotri.bnf ${LANG_ITALIAN} "File binario di risultati di Aerotri"
LangString Aerotri.art ${LANG_SPANISH} "Trabajo de Aerotri"
LangString Aerotri.art ${LANG_ENGLISH} "Aerotri work"
LangString Aerotri.art ${LANG_ITALIAN} "Lavoro di Aerotri"

Page directory
Page components
Page instfiles

UninstPage uninstConfirm
UninstPage instfiles

Var PreviousInst

Section "$(Programas_Ej)" Aerotri
	SectionIn RO

	;This is wrong at unistall time, so write it here to read it then
	WriteRegStr HKLM SOFTWARE\Aerotri UserData $APPDATA

	WriteRegStr HKLM SOFTWARE\Aerotri BaseDir $INSTDIR
	StrCpy $INSTDIR $INSTDIR\2012

	StrCmp $LANGUAGE ${LANG_ENGLISH} 0 +3
	  WriteRegDWORD HKLM SOFTWARE\Aerotri InstallLanguage 1
	  Goto fin_reg_lang
	StrCmp $LANGUAGE ${LANG_ITALIAN} 0 +3
	  WriteRegDWORD HKLM SOFTWARE\Aerotri InstallLanguage 2
	  Goto fin_reg_lang

	  WriteRegDWORD HKLM SOFTWARE\Aerotri InstallLanguage 0
	fin_reg_lang:

	CreateDirectory $INSTDIR\Configuraciones\Aerotri
	CreateDirectory $INSTDIR\Configuraciones\Grafico
	CreateDirectory $INSTDIR\Configuraciones\Calibracion
	CreateDirectory $APPDATA\Aerotri\Configuraciones\Calibracion
	CreateDirectory $APPDATA\Aerotri\Configuraciones\Grafico
	SetOutPath $INSTDIR
	SetShellVarContext all

	ReadRegStr $PreviousInst HKLM SOFTWARE\Aerotri Installdir
	ClearErrors
	StrCmpS $PreviousInst "" 0 ask_unistall
	StrCpy $0 0
	loop:
	  EnumRegKey $1 HKLM SOFTWARE\Aerotri $0
	  StrCmp $1 "" no_old
	  StrCmp $1 "2012" +3
	  StrCpy $1 $1 1 0
	  StrCmp $1 "2" ask_unistall
	  IntOp $0 $0 + 1
	  goto loop
	ask_unistall:
		MessageBox MB_YESNO "$(Desinstalar)" IDNO no_old
		Call UninstallAll
	no_old:

	WriteRegStr HKLM SOFTWARE\Aerotri\2012 "" $INSTDIR
	WriteRegDWORD HKLM SOFTWARE\Aerotri\2012 ReleaseVersion 20
	WriteRegStr HKLM SOFTWARE\Aerotri "" 2012

	; Write the uninstall keys for Windows
 	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Aerotri2012" DisplayName Aerotri2012
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Aerotri2012" UninstallString '"$INSTDIR\unAerotri2012.exe"'
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Aerotri2012" "DisplayVersion" "3.10.2"
	WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Aerotri2012" NoModify 1
	WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Aerotri2012" NoRepair 1

	WriteUninstaller $INSTDIR\unAerotri2012.exe

!define PROG_DIR ..\output\Win-${PROC}

	SetOutPath $INSTDIR\Configuraciones\Calibracion
	File ..\output\Common\Configuraciones\Calibracion\Fotocoordenadas.cfg
	File ..\output\Common\Configuraciones\Calibracion\Pixeles_mm.cfg
	File ..\output\Common\Configuraciones\Calibracion\Pixeles_micras.cfg
	File ..\output\Common\Configuraciones\Calibracion\Pixeles_pixeles.cfg

	SetOutPath $INSTDIR\Configuraciones\Grafico
	File ..\output\Common\Configuraciones\Grafico\*.cfg
	File ..\output\Common\Configuraciones\Grafico\formas.fdf
	File ..\output\Common\Configuraciones\Grafico\Formas.bmp

	SetOutPath $INSTDIR

	File "C:\Program Files (x86)\Microsoft Visual Studio\2017\Community\VC\Redist\MSVC\14.10.25017\onecore\amd64\Microsoft.VC150.CRT\vcruntime140.dll"
	File ${PROG_DIR}\ATcrt.dll
	File ${PROG_DIR}\AT2D3D.dll
	File ${PROG_DIR}\ATmatrices.dll
	File ${PROG_DIR}\ATsistemas.dll
	;
	File ${PROG_DIR}\Master.exe
	File ${PROG_DIR}\SubordinadaNative.dll
	File ${PROG_DIR}\SubordinadaForms.dll
	File ${PROG_DIR}\Aerotri.exe
	File ${PROG_DIR}\Calibracion.exe
	File ${PROG_DIR}\EditordeDatos.exe
	File ${PROG_DIR}\EditordeTexto.exe
	File ${PROG_DIR}\GraficoWin32.exe
	File ${PROG_DIR}\Modelos.exe
	File ${PROG_DIR}\Globales.dll
	File ${PROG_DIR}\Basicas.dll
	File ${PROG_DIR}\ControlesAt.dll
	File ${PROG_DIR}\PanelesSub.dll
	File ${PROG_DIR}\Aerotri.dll
	File ${PROG_DIR}\Calibracion.dll
	File ${PROG_DIR}\EditordeDatos.dll
	File ${PROG_DIR}\EditordeTexto.dll
	File ${PROG_DIR}\Modelos.dll
	File ${PROG_DIR}\*.master

	File ${PROG_DIR}\grafico_gen.dll
	File ${PROG_DIR}\configgra.dll
	File ${PROG_DIR}\grafico_cargar.dll
	File ${PROG_DIR}\graficos.dll
	File ${PROG_DIR}\BasicPiecesW32.dll
	File ${PROG_DIR}\VentanaPrincipal.dll
	File ${PROG_DIR}\PanelGraficoN.dll

	File ${PROG_DIR}\distorsion.dll
	File ${PROG_DIR}\lecturaf.dll
	File ${PROG_DIR}\escrituraf.dll
	File ${PROG_DIR}\infobinario.dll
	File ${PROG_DIR}\unitarios.dll
	File ${PROG_DIR}\relativa.dll
	File ${PROG_DIR}\transfficheros.dll
	File ${PROG_DIR}\transformacion.dll
	File ${PROG_DIR}\ajcalibracion.dll
	File ${PROG_DIR}\aerotri_trabajos.dll
	!ifndef VISOR
	    File ${PROG_DIR}\ajbloque.dll
	!endif
	File /r /x *_d.exe ..\Programas\Utilidades\Win-${PROC}\*.exe

	CreateDirectory $INSTDIR\tex
	SetOutPath $INSTDIR\tex
	File /r /x *.log /x *.bat /x *.pool /x Aerotripdftex.tex /x ncols.sty ..\tex\*.*

	CreateDirectory $INSTDIR\Iconos
	Delete $INSTDIR\Iconos\*.ico
	SetOutPath $INSTDIR\Iconos
	File ..\output\Common\Iconos\*.ico

	CreateDirectory $INSTDIR\Cursores
	Delete $INSTDIR\Iconos\*.cur
	SetOutPath $INSTDIR\Cursores
	File ..\output\Common\Cursores\*.cur

	SetOutPath $INSTDIR
	CreateDirectory "$SMPROGRAMS\Aerotri"
	RMdir /r "$SMPROGRAMS\Aerotri\Productos2012"
	Delete "$SMPROGRAMS\Aerotri\Aerotri Manager 2012.lnk"
	CreateDirectory "$SMPROGRAMS\Aerotri\2012"
	CreateShortCut "$SMPROGRAMS\Aerotri\2012\Aerotri.lnk"	$INSTDIR\Master.exe 'Aerotri EditordeDatos PanelGraficoN --args="-g Aerotri" EditordeTexto' $INSTDIR\Iconos\IconAerotri.ico
	CreateShortCut "$SMPROGRAMS\Aerotri\2012\Calibracin.lnk"	$INSTDIR\Master.exe 'Calibracion PanelGraficoN --args="-g Calibracin" EditordeTexto' $INSTDIR\Calibracion.exe
	CreateShortCut "$SMPROGRAMS\Aerotri\2012\Editor de Datos.lnk"	$INSTDIR\EditordeDatos.exe
	CreateShortCut "$SMPROGRAMS\Aerotri\2012\Editor de Texto.lnk"	$INSTDIR\EditordeTexto.exe
	CreateShortCut "$SMPROGRAMS\Aerotri\2012\Grfico.lnk"	$INSTDIR\GraficoWin32.exe
	CreateShortCut "$SMPROGRAMS\Aerotri\2012\Modelos.lnk"	$INSTDIR\Modelos.exe
	CreateShortCut "$SMPROGRAMS\Aerotri\Uninstall Aerotri 2012.lnk"	$INSTDIR\unAerotri2012.exe
	CreateShortCut "$SMPROGRAMS\Aerotri\2012\cmd.lnk"	cmd '/Q /K SET PATH=%PATH%;$INSTDIR'

	Call FileExtensions
SectionEnd

SectionGroup $(Manuales)
Section /o "Manuales en espaol" Man_html_esp
	CreateDirectory $INSTDIR\Manuales_html\esp
	SetOutPath $INSTDIR\Manuales_html\esp
	File /r ..\Manuales_html\esp\*.*
	File ..\Manuales_html\FormatoGrafico05.pdf
SectionEnd
;Los manuales en ingls estn desactualizados
Section /o "English user manuals" Man_html_eng
	CreateDirectory $INSTDIR\Manuales_html\eng
	SetOutPath $INSTDIR\Manuales_html\eng
	File /nonfatal /r ..\Manuales_html\eng\*.*
	File ..\Manuales_html\FormatoGrafico05.pdf
SectionEnd
; Los manuales en italiano estn muy obsoletos
;Section /o "Manuali in italiano" Man_html_it
;	CreateDirectory $INSTDIR\Manuales_html\it
;	SetOutPath $INSTDIR\Manuales_html\it
;	File /nonfatal /r ..\Manuales_html\it\*.*
;	File ..\Manuales_html\FormatoGrafico05.pdf
;SectionEnd
SectionGroupEnd

!macro EjemplosIdioma IDIOMA
	CreateDirectory $APPDATA\Aerotri\Ejemplos_Aerotri
	CreateDirectory $APPDATA\Aerotri\Ejemplos_Aerotri\principal
	SetOutPath $APPDATA\Aerotri\Ejemplos_Aerotri\principal
	File .\Ejemplos\ficheros_${IDIOMA}\ejemplo.*
	SetOutPath $APPDATA\Aerotri\Ejemplos_Aerotri
	File /r .\Ejemplos\Aerotri\*.*

	CreateDirectory $APPDATA\Aerotri\Ejemplo_Calibracion
	SetOutPath $APPDATA\Aerotri\Ejemplo_Calibracion
	File .\Ejemplos\ficheros_${IDIOMA}\imagen_px.ftm
	File .\Ejemplos\ficheros_${IDIOMA}\coordenadas.prm

	CreateDirectory $APPDATA\Aerotri\Ejemplo_Modelos
	SetOutPath $APPDATA\Aerotri\Ejemplo_Modelos
	File .\Ejemplos\ficheros_${IDIOMA}\modelo*.ajs
!macroend

Section /o "-Examples" Ej_eng
	!insertmacro EjemplosIdioma eng
SectionEnd
Section /o "-Esempi" Ej_it
	!insertmacro EjemplosIdioma it
SectionEnd
Section /o "-Ejemplos" Ej_esp
	!insertmacro EjemplosIdioma esp
SectionEnd

Function fileextensions
  !insertmacro EditorTfile .ftm Aerotri.ftm $(Aerotri.ftm)
  !insertmacro EditorTfile .pro Aerotri.pro $(Aerotri.pro)
  !insertmacro EditorTfile .prm Aerotri.prm $(Aerotri.prm)
  !insertmacro EditorTfile .pym Aerotri.pym $(Aerotri.pym)
  !insertmacro EditorTfile .gpm Aerotri.gpm $(Aerotri.gpm)
  !insertmacro EditorTfile .gpn Aerotri.gpn $(Aerotri.gpn)
  !insertmacro EditorTfile .ajs Aerotri.ajs $(Aerotri.ajs)
  !insertmacro EditorTfile .inf Aerotri.inf $(Aerotri.inf)
  !insertmacro EditorTfile .int Aerotri.int $(Aerotri.int)
  !insertmacro filewithargs .gra Aerotri.gra $(Aerotri.gra) "$INSTDIR\GraficoWin32.exe" "$INSTDIR\Iconos\IconGrafico.ico" Open $(Abrir) '"%1"'
  !insertmacro filewithargs .bnf Aerotri.bnf $(Aerotri.bnf) "$INSTDIR\EditordeDatos.exe" "$INSTDIR\Iconos\IconEditorD.ico" Open $(Abrir) '"%1"'
  !insertmacro filewithargs .art Aerotri.art $(Aerotri.art) "$INSTDIR\Master.exe" "$INSTDIR\Iconos\IconAerotri.ico" Open $(Abrir) '--args="\"%1\"" Aerotri EditordeDatos PanelGraficoN --args="-g Aerotri" EditordeTexto'
FunctionEnd

Function .onInit
	SetRegView ${BITS}
	ReadRegStr $0 HKLM "Software\Aerotri" BaseDir
	Strcmp $0 "" 0 +2
	  StrCpy $INSTDIR $PROGRAMFILES\Aerotri
	StrCmp ${PROC} "x86" +2 0
	  goto continue
	;Fix old install (only 32-bit olds)
	StrCmp $INSTDIR $PROGRAMFILES\Aerotri +5
	StrCmp $INSTDIR $PROGRAMFILES +3
	ReadRegStr $0 HKLM Software\Aerotri ""
	  StrCpy $INSTDIR $INSTDIR\Aerotri
	ClearErrors

  continue:
	SectionSetInstTypes ${Ej_esp} 0
	SectionSetInstTypes ${Ej_eng} 0
	SectionSetInstTypes ${Ej_it} 0
	;Language selection dialog

	Push ${LANG_Spanish}
	Push Espaol
	Push ${LANG_English}
	Push English
	Push ${LANG_Italian}
	Push Italiano
	Push 3
	LangDLL::LangDialog "Seleccin del idioma" "Seleccione el idioma predeterminado para los programas de Aerotri y para esta instalacin"

	Pop $LANGUAGE
	StrCmp $LANGUAGE "cancel" 0 +2
		Abort
	StrCmp $LANGUAGE ${LANG_ENGLISH} 0 +8
		SectionGetFlags ${Ej_eng} $0
		IntOp $0 $0 | 1
		SectionSetFlags ${Ej_eng} $0
		SectionGetFlags ${Man_html_eng} $0
		IntOp $0 $0 | 1
		SectionSetFlags ${Man_html_eng} $0
		Goto fin_idiomas
	;StrCmp $LANGUAGE ${LANG_ITALIAN} 0 +8
	;	SectionGetFlags ${Ej_it} $0
	;	IntOp $0 $0 | 1
	;	SectionSetFlags ${Ej_it} $0
	;	SectionGetFlags ${Man_html_it} $0
	;	IntOp $0 $0 | 1
	;	SectionSetFlags ${Man_html_it} $0
	;	Goto fin_idiomas

	SectionGetFlags ${Ej_esp} $0
	IntOp $0 $0 | 1
	SectionSetFlags ${Ej_esp} $0
	SectionGetFlags ${Man_html_esp} $0
	IntOp $0 $0 | 1
	SectionSetFlags ${Man_html_esp} $0
  fin_idiomas:
FunctionEnd

Function UninstallAll
	StrCmp $PreviousInst "" +2
	  Call UninstallOld
	StrCpy $0 0
	loop:
	  EnumRegKey $1 HKLM SOFTWARE\Aerotri $0
	  StrCmp $1 "" end
	  StrCmp $1 "2012" +4
	  StrCpy $2 $1 1 0 
	  StrCmp $2 "2" 0 +2
		 Call Uinstall_1
	  IntOp $0 $0 + 1
	goto loop
	end:
	RMDir /r "$SMPROGRAMS\Aerotri"
FunctionEnd

Function Uinstall_1
	Push $0
	ReadRegStr $3 HKLM SOFTWARE\Aerotri\$1 ""
	IntCmp $1 2012 0 0 +3
		StrCpy $2 $3\Configuraciones
		Call CopyConfigs
	RMDir /r $3
	DeleteRegKey HKLM "Software\Aerotri\$1"
	DeleteRegKey HKLM Software\Microsoft\Windows\CurrentVersion\Uninstall\Aerotri$1
	Pop $0
FunctionEnd

Function UninstallOld
	StrCpy $2 $PreviousInst\Configuraciones
	Call CopyConfigs
	RMDir /r $PreviousInst\Configuraciones
	RMDir /r $PreviousInst\Ejemplo_Aerotri
	RMDir /r $PreviousInst\Ejemplo_Calibracion
	RMDir /r $PreviousInst\Ejemplo_Modelos
	RMDir /r $PreviousInst\Iconos
	RMDir /r $PreviousInst\Manuales_html
	RMDir /r $PreviousInst\tex
	Delete $PreviousInst\*.*
	DeleteRegValue HKLM "SOFTWARE\Aerotri" InstallDir
	DeleteRegKey HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Aerotri"
FunctionEnd

Function CopyConfigs
	CopyFiles $2\Aerotri\* $INSTDIR\Configuraciones\Aerotri
	CopyFiles $2\Calibracion\* $INSTDIR\Configuraciones\Calibracion
	CopyFiles $2\Grafico\* $INSTDIR\Configuraciones\Grafico
FunctionEnd


Var Langnum
Var UserData

Section Uninstall
	!insertmacro deletekey ftm
	!insertmacro deletekey pro
	!insertmacro deletekey prm
	!insertmacro deletekey pym
	!insertmacro deletekey gpm
	!insertmacro deletekey gpn
	!insertmacro deletekey ajs
	!insertmacro deletekey inf
	!insertmacro deletekey int
	!insertmacro deletekey gra
	!insertmacro deletekey bnf
	!insertmacro deletekey art

	ReadRegStr $PreviousInst HKLM SOFTWARE\Aerotri\2012 ""
	StrCmp $INSTDIR $PreviousInst continue
	MessageBox MB_YESNOCANCEL "$(FicherosMovidos0)$INSTDIR$(FicherosMovidos1)$PreviousInst$(FicherosMovidos2)" IDYES continue IDCANCEL end
	Strcpy $INSTDIR $PreviousInst

	continue:
	ReadRegStr $UserData HKLM SOFTWARE\Aerotri UserData
	ReadRegDWORD $Langnum HKLM SOFTWARE\Aerotri InstallLanguage
	StrCmp $Langnum "1" 0 +3
	  StrCpy $LANGUAGE ${LANG_ENGLISH}
	  Goto fin_get_lang
	StrCmp $Langnum "2" 0 +3
	  StrCpy $LANGUAGE ${LANG_ITALIAN}
	  Goto fin_get_lang
	StrCpy $LANGUAGE ${LANG_SPANISH}
	
	fin_get_lang:
	SetShellVarContext all
	DeleteRegKey HKLM SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Aerotri2012
	DeleteRegKey HKLM SOFTWARE\Aerotri\2012
	SetOutPath $TEMP
	RMDir /r $INSTDIR
	Delete "$SMPROGRAMS\Aerotri\*2012.*"
	RMDir /r "$SMPROGRAMS\Aerotri\Productos2012"
	RMDir /r "$APPDATA\Aerotri"

	ReadRegStr $PreviousInst HKLM SOFTWARE\Aerotri Installdir
	StrCmpS $PreviousInst "" 0 remove_userdata
	EnumRegKey $1 HKLM SOFTWARE\Aerotri 0
	StrCmp $1 "" 0 remove_userdata

	DeleteRegKey HKLM SOFTWARE\Aerotri
	RmDir $INSTDIR\..
	RMDir /r "$SMPROGRAMS\Aerotri"

remove_userdata:
	MessageBox MB_YESNO "$(DesinstalarTodo)" IDNO end
	RMDir /r "$UserData\Aerotri"

	end:
	Return
SectionEnd
