﻿sinline u8int cuenta_bits(uint n){
	u8int i=0;
	while(n!=0){i+=(u8int)(n&1); n>>=1;}
	return i;
}

#define path_point4at(path,s) path_get_extension16(path,s);\
	if(*s!='.' || strlen16(s)>4){while(*s) s++;}

#define copy_filename16(ficheroorg,ficherocopia,c1,c2,c3) \
	{char16_t *ext;\
	u16int lof;\
	path_point4at((char16_t*)ficheroorg,ext);\
	lof=(u16int)(ext-ficheroorg);\
	aj_malloc_add(ficherocopia,char16_t,lof+5);\
	strcpy16(ficherocopia,ficheroorg);\
	ext=ficherocopia+lof;\
	*ext++='.'; *ext++=c1; *ext++=c2; *ext++=c3; *ext='\0';}

#ifdef ATFILEO_OPEN_UNKNOWN
//	1: none of the following
//	2: invalid path
//	3: cannot open more files
//	4: no permision for writing that file
static const char16_t* const TEXTOS_fileopen[][3]={\
	{u"",u"",u""}, //0
	{u"Error desconocido al intentar abrir el fichero",u"Unknown error when attempting to open the file",u"Errore sconosciuto al tentare di aprire il file"}, //1
	{u"Nombre de fichero no válido",u"Invalid file name",u"Nome di file no valido"}, //2
	{u"El sistema operativo no permite abrir más ficheros",u"The operating system does not allow the opening of more files",u"Il sistema operativo non permette di aprire più file"}, //3
	{u"No se permite (sobre)escribir este fichero",u"You are not allowed to (over)write this file",u"La (sovra)scritura di questo file non è permessa"}, //4
};
static const char16_t* const TEXTOS_fileoutput[][3]={\
	{u"El fichero ",u"The file ",u"Il file "}, //0
	{u" no se pudo abrir para escribir:\n",u"couldn't be opened for writing:\n",u" non a potuto essere aperto per scriverne:\n"}, //1
	{u"Hubo un error al escribir el fichero ",u"There was an error when trying to write the file ",u"È apparso un errore al scrivere il file "}, //2
	{u". El fichero generado no es correcto",u". The generated file is wrong",u". Il file generato non è corretto"}, //3
};
#define TEXTOS_fileoutput(n)	TEXTOS_fileoutput[n][idioma]
#define S_Elfichero				TEXTOS_fileoutput(0)
#define S_no_se_pudo_abrir_para_escribir		TEXTOS_fileoutput(1)
#define S_Hubo_un_error_al_escribir_el_fichero		TEXTOS_fileoutput(2)
#define S_El_fichero_generado_no_es_correcto		TEXTOS_fileoutput(3)
#endif

//Esta construcción la usan las funciones que abren un fichero para leer
#ifdef ATFILEI_UNKNOWN
void open_file_err_str16(int code,char16_t* s1,const char16_t* fichero,u8int _idioma){
	if(code==AT_NOMEM){
		switch(_idioma){
			case Id_Eng:	strbuild16(s1,u"The file: '",fichero,u"' is too big",NULL); break;
			case Id_It:	strbuild16(s1,u"Il file '",fichero,u"' è troppo  grande",NULL); break;
			default:		strbuild16(s1,u"El fichero '",fichero,u"' es demasiado grande",NULL);
		}
		return;
	}
	if(code==ATFILEI_BADPATH || code==ATFILEI_NOFILE || code==ATFILEI_NOTALLOWED){
		switch(_idioma){
			case Id_Eng:	strbuild16(s1,u"The file '",fichero,u"' doesn't exist or cannot be opened for reading",NULL); break;
			case Id_It:	strbuild16(s1,u"Non esiste il file '",fichero,u"' o non può essere aperto per leggere",NULL); break;
			default:		strbuild16(s1,u"No existe el fichero '",fichero,u"' o no puede ser abierto para leer",NULL);
		}
		return;
	}
	if(code==ATFILEI_NOMORE){
		switch(_idioma){
			case Id_Eng:	strbuild16(s1,u"The file '",fichero,u"' couldn't be opened beacuse the operating system cannot open more files",NULL); break;
			case Id_It:	strbuild16(s1,u"Il file '",fichero,u"' non si può aprire perché il sistema operativo non può aprire piú file",NULL); break;
			default:		strbuild16(s1,u"El fichero '",fichero,u"' no se puede abrir porque el sistema operativo no puede abrir más ficheros",NULL);
		}
		return;
	}
	switch(_idioma){
		case Id_Eng:	s1=strbuild16(s1,u"Unknown error while trying to open the file '",fichero,NULL); break;
		case Id_It:	s1=strbuild16(s1,u"Errore sconosciuto al tentare di apprire il file '",fichero,NULL); break;
		default:		s1=strbuild16(s1,u"Error desconocido al intentar abrir el fichero '",fichero,NULL);
	}
	*s1++='\''; *s1=u'\0';
}
#endif

void nomemopen_errstr(char16_t *message, const char16_t* ficherode,const char16_t* nombre,const char16_t* tipofichero,u8int _idioma){
	const char16_t *pfich;
	path_get_filename16(nombre,pfich);

	switch(_idioma){
		case Id_Eng:	strbuild16(message,u"The ",ficherode,u" file: '",pfich,u"' is too big. Is it surely a ",tipofichero,u" file ?",NULL); break;
		case Id_It:	message=strbuild16(message,u"Il file ",ficherode,u": '",pfich,u"' è troppo  grande. Sicuro che è un file di ",tipofichero,NULL); *message++='?'; *message=u'\0'; break;
		default:		message=strbuild16(message,u"El fichero ",ficherode,u": '",pfich,u"' es demasiado grande. ¿Seguro que es un fichero de ",tipofichero,NULL); *message++='?'; *message=u'\0';
	}
}

//Inserts preamble at beginning of message
void insert_message(const char16_t* preamble, char16_t* message){
	uint offset,n;
	char16_t *fwd, *msg;
	
	offset=strlen16(preamble);
	for(fwd=message;*fwd!='\0';fwd++);
	n=(pdif)(fwd-message)+1;
	msg=fwd;
	fwd+=offset;
	while(n) n--, *fwd--=*msg--;
	while(*preamble) *message++=*preamble++;
}

//Inserts two strings at beginning of message
void insert_str2(const char16_t* str1, char16_t* str2, char16_t* message){
	uint offset,n;
	char16_t *fwd, *msg;
	
	offset=strlen16(str1)+strlen16(str2);
	for(fwd=message;*fwd!='\0';fwd++);
	n=(pdif)(fwd-message)+1;
	msg=fwd;
	fwd+=offset;
	while(n) n--, *fwd--=*msg--;
	message=strpcpy16(message,str1);
	while(*str2) *message++=*str2++;
}
