﻿//Funciones de los ajuste parciales y estructuras necesarias para ellos
#pragma once
#include <ATcrt/ATsystem.h>
#include "Aerotri_defs.h"
#include "ClasesFotogrametria.h"
#include "ClaseModelo.h"
#include "resultado_parcial.h"

struct _Estimador;
typedef struct _Estimador Estimador;

//ajusmod es llamada por modfot y modmod, pero se puede llamar de manera independiente.
//Realiza un ajuste del modelo que se le pasa.

// n es el número de puntos comunes. Si se pasa 0 la función lo mira, en caso contrario se fia de que el valor pasado sea correcto
//Para vmin se puede pasar 0
//Valores especiales de n_force. Cuanto más alto mayor permisividad
#define N_FORCE_ZERO 0		//se acepta que las intersecciones sean en general agudas,\
										pero no una muy aguda
#define N_FORCE_BASE ((u16int)(-10))
#define N_FORCE_AGUDO (N_FORCE_BASE+1)	//se acepta un punto muy agudo
#define N_FORCE_ALTO (N_FORCE_BASE+2)		//se aceptan vv altos
#define N_FORCE_NEG	(N_FORCE_BASE+3)		//se aceptan puntos negativos
#define N_FORCE_ALL ((u16int)-1)	//se acepta todo

#define N_FORCE_is_strict(nforce) (ispos_u16(n_force) && (n_force)!=0)
Modelo fotfot(Resultado *result, Fotograma*, Fotograma*, u8int modo_toma, u16int n_force, float vmin, uint n);

void modfot(Resultado *result, Modelo*, Fotograma*, u16int maximof, u8int modo_toma, Estimador *estimador, float vmin);
void modmod(Resultado *result, Modelo*, Modelo*, u16int maximof, u8int modo_toma, Estimador *estimador, float vmin);
void ajusmod(Resultado* result, Modelo*, Estimador *estimador, float vvmin);
