﻿#include "Clases_pasadas.h"
typedef struct{
	CentroProy *n1, *n2;
	float f;
} ParDist;
#define Type ParDist
#define macro_lessthan(x,y) ((x)->f>(y)->f)
#define FUNCION_ordenarMmlimite
#include "ordenar.cod"
#undef Type
#include "epipolar.h"
#include "escrituraf.h"

//PARA EL EXTERIOR. ANCHOS EXACTOS
typedef union{
	uint8m Aerotri;	//0: sin marcar, 1: prm, 2: pym
	uint8m ori;		// 0/1
	uint8m IMaster;	//0: Pares a-b sólo, 1: pares a-b y b-a
} OpcionesFormato;

void gps_a_centroproy(PuntoGPSINS* gpss, uint ngps, CentroProy* centros, uint* ncp){
	*ncp=0;
	for(;ngps--;gpss++){
		if(gpss->tipoGPS==LEEGPS_TIPO_NODATA || gpss->tipoINS==LEEGPS_TIPO_NODATA) continue;
		centros->index=gpss->index;
		centros->b=gpss->bg!=0 && gpss->bi!=0;
		if(centros->b!=0){
			if(gpss->bg==1 && gpss->bi==1) centros->b=1;
			else centros->b=2;
		}
		centros->P=gpss->P;
		memcpy_double(centros->M[0],gpss->M[0],9);
		centros++;
		(*ncp)++;
	}
}
void gps_a_centroproya(PuntoGPSINS* gpss, CentroProy* centros, uint ncp){
	for(;ncp--;gpss++,centros++){
		centros->index=gpss->index;

		centros->gggppp2=centros->gggppp=0;
		if(gpss->bg==1) centros->gggppp=07;
		elif(gpss->bg!=0) centros->gggppp2=07;
		if(gpss->bi==1) centros->gggppp|=070;
		elif(gpss->bi!=0) centros->gggppp2|=070;

		if(centros->gggppp==077) centros->b=1;
		elif(gpss->bg!=0 && gpss->bi!=0) centros->b=2;
		else centros->b=0;
		centros->P=gpss->P;
		memcpy_double(centros->M[0],gpss->M[0],9);
		centros->peso=gpss->peso;
	}
}

void centroproya_a_gps(CentroProy* centros, PuntoGPSINS* gpss, uint ncp){
	PuntoGPSINS gps;
	char8_t b1,b2;
	default_values_GPS(gps);
	gps.grupo=0;
	gps.tipoGPS=0;
	gps.tipoINS=0;
	gps.t=0;
	for(;ncp--;gpss++,centros++){
		gps.index=centros->index;
		gps.bi=gps.bg=centros->b;
		gps.P=centros->P;
		memcpy_double(gps.M[0],centros->M[0],9);
		gps.peso=centros->peso;

		b1=centros->gggppp;
		b2=centros->gggppp2;
		if((b1&007)==007 && b2==0) gps.bg=1;
		elif( ((b1 | b2)&007)==007 ) gps.bg=2;
		else gps.bg=0;
		if((b1&070)==070 && b2==0) gps.bi=1;
		elif( ((b1 | b2)&070)==070 ) gps.bi=2;
		else gps.bi=0;
		*gpss=gps;
	}
}

int Trficheros_ccpp(char16_t* ficherof1,u8int apr1,bint signoins, char16_t* ficherof2,u8int apr2, OpcionesFormato opciones2, char16_t* mensaje, u8int idioma){
	int nret;
	Vector_CentroProy centros;
	Vector_PuntoGPSINS gpss;
	Vector_GrupoGPSINS grupos;
	char8_t *nombresCP;
	Vector_PesoCP pesoscp;
	Vector_PesoCP *ppesoscp;
	Vector_GrupoGPSextras gruposextras;
	s8int dec;

	{uint flag=0;
	if((apr1==CCPPFORMAT_Aerotriccpp || apr1==CCPPFORMAT_ΩΦΚ)
	  && (apr2==CCPPFORMAT_Aerotriccpp || apr2==CCPPFORMAT_ΩΦΚ)) flag=1;
	initialize(flag);}

	centros.ppio=NULL;
	grupos.ppio=NULL;
	gpss.ppio=NULL;
	gruposextras.ppio=NULL;
	pesoscp.ppio=NULL; pesoscp.n=0;
	if((apr2==CCPPFORMAT_Aerotriccpp || apr2==CCPPFORMAT_AerotriGPS)) ppesoscp=&pesoscp;
	else ppesoscp=NULL;

	switch(apr1){
	 case CCPPFORMAT_Aerotriccpp:
	 case CCPPFORMAT_ΩΦΚ:
	 case CCPPFORMAT_PATB:
		nret=lee_ficheroccpp(ficherof1,&apr1,0,&centros,&nombresCP,ppesoscp,&dec);
		ifunlike(nret){
			if(centros.ppio!=NULL){free(nombresCP); free(centros.ppio);}
			break;
		}
		{durchVectori(CentroProy,centros) ptri->nom=nombresCP+ptri->index;}
		break;
	 case CCPPFORMAT_AerotriGPS:
	 case CCPPFORMAT_MatchAT:
	 case CCPPFORMAT_TopoSys:
		nret=lee_ficherogps(ficherof1,&apr1,signoins,0,&grupos,&gpss,&nombresCP,ppesoscp,&gruposextras,&dec,-1,-1,-1,-1);
		ifunlike(nret){
			freeif(nombresCP);
			freeif(grupos.ppio);
			freeif(gpss.ppio);
			freeif(gruposextras.ppio);
			break;
		}
		{durchVectori(PuntoGPSINS,gpss) ptri->nom=nombresCP+ptri->index;}
		break;
	}
	ifunlike(nret){
		insert_message(S_(Error_deorigen),mensaje);
		freeif(pesoscp.ppio);
		return nret;
	}

	if(apr2!=CCPPFORMAT_AerotriGPS){
		if(gpss.ppio!=NULL){
			Vsetup(CentroProy,centros,gpss.n,goto salida);
			if(apr2==CCPPFORMAT_Aerotriccpp && opciones2.Aerotri==2) gps_a_centroproya(gpss.ppio,centros.ppio,gpss.n);
			else{gps_a_centroproy(gpss.ppio,gpss.n,centros.ppio,&centros.n);
				  centros.n=gpss.n;}
		}
		switch(apr2){
			case CCPPFORMAT_Aerotriccpp: nret=escribe_prmpym(ficherof2,centros.ppio,centros.n,pesoscp.ppio,NULL,0,NULL,2,dec,3, NULL, opciones2.Aerotri,0,-1,-1,-1,-1,-1,-1); break;
			case CCPPFORMAT_PATB: nret=escribeccpp_patb(ficherof2,centros.ppio,centros.n,opciones2.ori); break;
			case CCPPFORMAT_ΩΦΚ: nret=escribeccpp_eo(ficherof2,centros.ppio,centros.n,dec); break;
			case CCPPFORMAT_IMaster:
			{char16_t path2[SHRT_PATH], *nombre;
			uint nn;
			remove_filename(path2,SHRT_PATH,ficherof2,&nombre);

			nn=(centros.n*(centros.n-1))/2;
			ParDist *distancias=n_malloc(ParDist,nn);
			uint *orden_distancias=n_malloc(uint,nn);
			PuntoXYZ_double Pm, PM;
			ParDist dist_lim;
			PM.X=Pm.X=centros.ppio->P.X;
			PM.Y=Pm.Y=centros.ppio->P.Y;
			PM.Z=Pm.Z=centros.ppio->P.Z;

			//Obtención de coordenadas extremas (Pm y PM), escritura de los .ext,
			//dist_lim y cálculo distancias para todos los pares. dist_lim es solamente
			//un límite para la función que ordena; no se emplea como valor límite para escribir los ficheros.
			{ParDist *pdist=distancias;
			CentroProy *ptri=centros.ppio;
			for(cint i=centros.n; i; ptri++){ i--;
				char16_t *s;
				char8_t *pext, *pc;
				path_get_extension8(ptri->nom,pext);
				for(s=nombre, pc=ptri->nom; pc!=pext; *s++=*pc++);
				*s++='.'; *s++='e'; *s++='x'; *s++='t'; *s='\0';
				nret|=escribe_imaster_ext(path2,ptri);

				PuntoXYZ_double P=ptri->P;
				if(P.X<Pm.X) Pm.X=P.X;		else if(P.X>PM.X) PM.X=P.X;
				if(P.Y<Pm.Y) Pm.Y=P.Y;		else if(P.Y>PM.Y) PM.Y=P.Y;
				if(P.Z<Pm.Z) Pm.Z=P.Z;		else if(P.Z>PM.Z) PM.Z=P.Z;
				durchlaufej(CentroProy,ptri+1,i){
					PuntoXYZ_double Q;
					pdist->n1=ptri;
					pdist->n2=ptrj;
					P_op(Q,=,ptrj->P,-,P);
					pdist->f=(float)P_mod(Q);
					pdist++;
				}
			}}
			P_eq(PM,-=,Pm);
			dist_lim.f=(float)(P_mod(PM)*50.0/centros.n);
			ordenarMmlimite_ParDist(distancias,orden_distancias,nn,dist_lim);

			Bufferto8 fpair, fpairall;
			toopen_mixed(&fpair,ficherof2);
			strcpy16(nombre,u"pares_todos.pairlist");
			toopen_mixed(&fpairall,path2);
			towrite8_string(&fpair,"STEREOPAIRLIST_1.00\n");
			towrite8_string(&fpairall,"STEREOPAIRLIST_1.00\n");

			{uint *ptri=orden_distancias;
			for(cint i=8*centros.n; i;){ i--;
				uint k=*ptri++;
				CentroProy *cp1, *cp2;
				double N[3][3], N2[3][3];
				cp1=distancias[k].n1;
				cp2=distancias[k].n2;

				if(i>=centros.n<<1) towrite(&fpair,'s',cp1->nom,',', 's',cp2->nom, '\n',0);
				towrite(&fpairall,'s',cp1->nom,',', 's',cp2->nom, '\n',0);

				epipolar((PuntoXYZM_double*)&cp1->P,(PuntoXYZM_double*)&cp2->P,N);
				memcpy_double(N2[0],N[0],9);
				strbuild_mixed(nombre,'c',cp1->nom,'w',u"-",'c',cp2->nom, 'w',u".rel", 0);
				escribe_imaster_rel(path2,cp1->nom,cp2->nom,(PuntoXYZM_double*)&cp1->P,N,(PuntoXYZM_double*)&cp2->P,N2);

				if(opciones2.IMaster){
					towrite(&fpairall,'s',cp2->nom,',', 's',cp1->nom, '\n',0);
					epipolar((PuntoXYZM_double*)&cp2->P,(PuntoXYZM_double*)&cp1->P,N);
					memcpy_double(N2[0],N[0],9);
					strbuild_mixed(nombre,'c',cp2->nom,'w',u"-",'c',cp1->nom, 'w',u".rel", 0);
					escribe_imaster_rel(path2,cp2->nom,cp1->nom,(PuntoXYZM_double*)&cp2->P,N,(PuntoXYZM_double*)&cp1->P,N2);
				}
			}}

			toclose(&fpair);
			toclose(&fpairall);
			free(orden_distancias);
			free(distancias);
		}
			break;
		}
	}else{
		if(centros.ppio!=NULL){
			Vsetup(GrupoGPSINS,grupos,1,goto salida);
			Vsetup(PuntoGPSINS,gpss,centros.n,goto salida);

			grupos.n=1;
			default_values_GrupoGPS(*grupos.ppio);
			grupos.ppio->tipoINS=grupos.ppio->tipoGPS=254;
			grupos.ppio->offset.Z=grupos.ppio->offset.Y=grupos.ppio->offset.X=0;
			grupos.ppio->n=centros.n;

			centroproya_a_gps(centros.ppio,gpss.ppio,centros.n);
			gpss.n=centros.n;
		}
		nret=escribe_gpm(ficherof2,grupos.ppio,grupos.n,gpss.ppio,gpss.n,pesoscp.ppio,dec,2, -1,-1,-1,-1);
	}

salida:
	freeif(pesoscp.ppio);
	free(nombresCP);
	freeif(gruposextras.ppio);
	freeif(grupos.ppio);
	freeif(gpss.ppio);
	freeif(centros.ppio);

	return nret;
}
