s8int log10n_d(double x){
	s8int log;
	if(x==0) return -127;
	if(x<0) x=-x;

	/*s8int */log=0;
	while(x<1) x*=10,log--;
	if(x>10){double y; for(y=10; x>=y; y*=10,log++);}
	return log;
}
int Trficheros_camara(char16_t* ficherof1,u8int mar1, char16_t* ficherof2,u8int mar2, char16_t* mensaje, u8int idioma){
	int nret;
	OrientacionInterna interna;

	nret=lee_ficheroint(ficherof1,mar1,&interna,mensaje,idioma);
	ifunlike(nret){
		free_interna(&interna);
		return nret;
	}
	if(mar2==CAMFORMAT_Aerotri){
		u8int decim, decf;
		decf=6-log10n_d(interna.valI.f);
		if(!(interna.flags&CAL_FLAG_Transf1)) decim=decf;
		else decim=6-log10n_d(interna.valI.f/interna.afin_1.a);
		nret=escribe_ficheroint(ficherof2,&interna,decim,decf,mensaje,0);
		free_interna(&interna);
		ifunlike(nret) return nret;
		return 0;
	}

	InternaKPB mala;
	u8int inexacto;
	float despl;

	interna_kpb___Aerotri(&interna,&mala,&despl);
	free_interna(&interna);
	if(mala.inexacta>=8){
		const char16_t *s;
		mensaje=strpcpy16(mensaje,S_(El_fichero_de_cámara_de_Aerotri_no_se_puede_transformar)); *mensaje++='\n';
		if(mala.inexacta==8) s=S_(La_transformación_afín_es_demasiado_compleja);
		else s=S_(El_modelo_polinómico_ha_de_ser_Impar);
		strcpy16(mensaje,s);
		return 4;
	}
	inexacto=mala.inexacta;
	switch(mar2){
		case CAMFORMAT_cmr:
			if(mala.k[0]!=0 || mala.k[4]!=0 || mala.b1!=0 || mala.b2!=0) inexacto|=4;
			inexacto&=~2U; //No b2 in this model, hence this does not happen
			nret=escribe_ficheroint_cmr(ficherof2,&mala,mensaje,idioma);
			break;
		case CAMFORMAT_Digi:
			nret=escribe_ficheroint_Digi(ficherof2,&mala,mensaje,idioma); break;
		case CAMFORMAT_ini:
		default:
			nret=escribe_ficheroint_ini(ficherof2,&mala,NULL,mensaje,idioma);
	}
	ifunlike(nret) return nret;
	if(inexacto){
		uint t;
		if(inexacto<4){
			switch(inexacto){
				case 1: t=T_Transformación_exacta_Desplazado_pp; break;
				case 2: t=T_Transformación_exacta_Parámetro_b2; break;
				case 3: t=T_Transformación_exacta_pp_y_b2; break;
			}
			mensaje=strpcpy16(mensaje,LTEXTO(t));
		}else{
			mensaje=strpcpy16(mensaje,S_(Transformación_no_exacta));
			if(inexacto!=4){
				switch(inexacto&3){
					case 1: t=T_Necesario_desplazar_pp; break;
					case 2: t=T_Apareció_parámetro_b2; break;
					case 3: t=T_Además_pp_y_b2; break;
				}
				mensaje=strpcpy16(mensaje,LTEXTO(t));
			}
		}
		if(inexacto&3){
			*mensaje++='\n';
			strcpy16(mensaje,S_(Las_orientaciones_obtenidas_serán_distintas));
		}
		return 5;
	}
	return 0;
}
