﻿enum TextosRelativa_Cod{
	T_banner,
	T_Leyendo_fotogramas,
	T_Escribiendo_fotogramas,
	T_está_vacío,
	T_tiene_menos_de_3_puntos,
	T_El_fotograma,
	T_Leyendo_interna,
	T_Leyendo_gpsins,
	T_No_se_ha_podido_aprovechar_GPSINS,
	T_Se_han_podido_aprovechar_los_primeros,
	T_grupos_GPSINS,
	T_Pasos_previos,
	T_Se_han_unido_todos_los_fotogramas_GPS,
	T_Se_ha_formado_modelo_fotos_GPS,
	T_Mínimo_número_de_puntos_en_común,
	T_Parámetro_de_camino,
	T_linea_cabecera_pro,
	T_El_último_modelo_intentado_está_mal,
	T_El_proceso_diverge,
	T_Máximo_σ,
	T_No_se_puede_unir_en_un_bloque,
	T_Las_distintas_unidades_independientes,
	T_No_se_ha_encontrado_par_erróneo,
	T_Mire_información_de_puntos_erróneos,
	T_Es_posible,
	T_Es_muy_probable,
	T_posible,
	T_muy_probable,
	T_que_el_par_de_fotos,
	T_y,
	T_esté_mal,
	T_punto,
	T_pero_sólo_6_puntos_en_común,
	T_Es_posible_que_pares_mal,
	T_No_se_pudo_abrir_fichero_valores_calculados,
	T_Los_resultados_no_se_escriben,
	T_Escribiendo_el_fichero_de_valores_calculados,
	T_Error_escritura_fichero_valores_calculados,
	T_Es_probable_que_fichero_no_bien,
	T_Fin_de_la_escritura_últimos_pasos,
	T_Últimos_pasos,
	T_Programa_relativa_terminado_por,
	T_Programa_relativa_abortado,
	T_Programa_relativa_sin_memoria,
};

static const char8_t* const TEXTOS_relativa_esp[]={
	[T_banner]=u8"***Comienzo del programa 'relativa', v. 2.8, 16 de diciembre de 2013***",
	[T_Leyendo_fotogramas]=u8"Leyendo el fichero de fotogramas ",
	[T_Escribiendo_fotogramas]=u8"Escribiendo el fichero de fotogramas marcado: ",
	[T_está_vacío]=u8" está vacío",
	[T_tiene_menos_de_3_puntos]=u8" tiene menos de tres puntos",
	[T_El_fotograma]=u8"El fotograma ",
	[T_Leyendo_interna]=u8"Leyendo el fichero de cámara ",
	[T_Leyendo_gpsins]=u8"Leyendo el fichero de gps/ins ",
	[T_No_se_ha_podido_aprovechar_GPSINS]=u8"No se ha podido aprovechar ningún grupo GPS/INS",
	[T_Se_han_podido_aprovechar_los_primeros]=u8"Se han podido aprovechar los primeros ",
	[T_grupos_GPSINS]=u8" grupos GPS/INS",
	[T_Pasos_previos]=u8"Pasos previos al ajuste...",
	[T_Se_han_unido_todos_los_fotogramas_GPS]=u8"Se han unido todos los fotogramas en un único modelo mediante los datos GPS e INS",
	[T_Se_ha_formado_modelo_fotos_GPS]=u8"Se ha formado un modelo (m 1) mediante los datos GPS e INS con los siguientes fotogramas:",
	[T_Mínimo_número_de_puntos_en_común]=u8"Mínimo número de puntos en común para la orientación de dos fotogramas: ",
	[T_Parámetro_de_camino]=u8"Parámetro de camino: ",
	[T_linea_cabecera_pro]=u8"elemento primero  elemento segundo  resultado  nºp.  iter.  e.m.c.       |  pt. malo",
	[T_El_último_modelo_intentado_está_mal]=u8"El último modelo que se intentó formar está mal: f ",
	[T_El_proceso_diverge]=u8"El proceso diverge.",
	[T_Máximo_σ]=u8"El máximo valor de la desviación típica alcanzado en algún paso es ",
	[T_No_se_puede_unir_en_un_bloque]=u8"No se ha podido unir todos los fotogramas en un único bloque",
	[T_Las_distintas_unidades_independientes]=u8"A continuación se muestran las distintas unidades independientes\n que no han podido ser unidas entre sí",
	[T_No_se_ha_encontrado_par_erróneo]=u8"No se ha podido encontrar ningún par de fotos erróneo.",
	[T_Mire_información_de_puntos_erróneos]=u8"Mire la información sobre posibles puntos erróneos, antes de que el ajuste comenzase a ir mal o en el momento en que comenzó a ir mal.",
	[T_Es_posible]=u8"Es posible",
	[T_Es_muy_probable]=u8"Es muy probable",
	[T_posible]=u8"posible",
	[T_muy_probable]=u8"muy probable",
	[T_que_el_par_de_fotos]=u8" que el par formado por las fotos ",
	[T_y]=u8" y ",
	[T_esté_mal]=u8" esté mal,",
	[T_punto]=u8"punto ",
	[T_pero_sólo_6_puntos_en_común]=u8" (pero solamente hay 6 puntos en común)",
	[T_Es_posible_que_pares_mal]=u8"Es posible que los siguientes pares de fotos estén mal:",
	[T_No_se_pudo_abrir_fichero_valores_calculados]=u8"No se pudo abrir el fichero de valores calculados: ",
	[T_Los_resultados_no_se_escriben]=u8". ¡Los resultados no se escriben!",
	[T_Escribiendo_el_fichero_de_valores_calculados]=u8"Escribiendo el fichero de valores calculados: ",
	[T_Error_escritura_fichero_valores_calculados]=u8"Se produjo algún error al escribir el fichero de valores calculados.",
	[T_Es_probable_que_fichero_no_bien]=u8"Es probable que el fichero no se haya terminado de escribir correctamente.",
	[T_Fin_de_la_escritura_últimos_pasos]=u8"Fin de la escritura del fichero, últimos pasos.",
	[T_Últimos_pasos]=u8"Últimos pasos",
	[T_Programa_relativa_terminado_por]=u8"Programa 'relativa' terminado por: ",
	[T_Programa_relativa_abortado]=u8"Programa 'relativa' abortado por el usuario",
	[T_Programa_relativa_sin_memoria]=u8"Programa 'relativa' abortado por memoria insuficiente",
};
static const char8_t* const TEXTOS_relativa_eng[]={
	[T_banner]=u8"***Beginning of the program 'relativa', v. 2.8, 16th December, 2013***",
	[T_Leyendo_fotogramas]=u8"Reading the photographs file ",
	[T_Escribiendo_fotogramas]=u8"Writing the marked photographs file: ",
	[T_está_vacío]=u8" is empty",
	[T_tiene_menos_de_3_puntos]=u8" has less than three points",
	[T_El_fotograma]=u8"The photograph ",
	[T_Leyendo_interna]=u8"Reading the camera file ",
	[T_Leyendo_gpsins]=u8"Reading the gps/ins file ",
	[T_No_se_ha_podido_aprovechar_GPSINS]=u8"No GPS/INS group could be used for the comptation",
	[T_Se_han_podido_aprovechar_los_primeros]=u8"The ",
	[T_grupos_GPSINS]=u8" first GPS/INS groups could be used",
	[T_Pasos_previos]=u8"Steps previous to the adjustment...",
	[T_Se_han_unido_todos_los_fotogramas_GPS]=u8"All the photographs have been joined together into a single model by means of the GPS and INS data",
	[T_Se_ha_formado_modelo_fotos_GPS]=u8"A model (m 1) was formed by means of the GPS and INS data. It includes the following photographs:",
	[T_Mínimo_número_de_puntos_en_común]=u8"Minimum number of common points to orientate two photographs: ",
	[T_Parámetro_de_camino]=u8"Path parameter: ",
	[T_linea_cabecera_pro]=u8"first element    second element     result     nºp.  iter.  e.m.c.       |  bad pt.",
	[T_El_último_modelo_intentado_está_mal]=u8"The last model to be built is wrong: f ",
	[T_El_proceso_diverge]=u8"The process diverges.",
	[T_Máximo_σ]=u8"The highest value reached by the standard deviation in any of the steps is ",
	[T_No_se_puede_unir_en_un_bloque]=u8"It hasn't been possible to join all photographs together in a single block",
	[T_Las_distintas_unidades_independientes]=u8"Here follows the list of independent units that couldn't be put together",
	[T_No_se_ha_encontrado_par_erróneo]=u8"No wrong pairs of photographs could be detected.",
	[T_Mire_información_de_puntos_erróneos]=u8"Look at the information about possible wrong points, before the adjustment started to behave badly or at the moment when it started to go wrong.\n",
	[T_Es_posible]=u8"It is possible",
	[T_Es_muy_probable]=u8"It is very likely",
	[T_posible]=u8"possible",
	[T_muy_probable]=u8"very likely",
	[T_que_el_par_de_fotos]=u8" that the pair of photographs ",
	[T_y]=u8" and ",
	[T_esté_mal]=u8" be wrong,",
	[T_punto]=u8"point ",
	[T_pero_sólo_6_puntos_en_común]=u8" (but there are just 6 common points)",
	[T_Es_posible_que_pares_mal]=u8"It is possible that the following pairs of photographs be wrong.",
	[T_No_se_pudo_abrir_fichero_valores_calculados]=u8"The computed values file could not be opened; ",
	[T_Los_resultados_no_se_escriben]=u8". The results are not being written!",
	[T_Escribiendo_el_fichero_de_valores_calculados]=u8"Writing the computed values file: ",
	[T_Error_escritura_fichero_valores_calculados]=u8"An error arose while writing the computed values file.",
	[T_Es_probable_que_fichero_no_bien]=u8"The file is likely to have not been finished properly.",
	[T_Fin_de_la_escritura_últimos_pasos]=u8"The writing of the file ended, performing last steps.",
	[T_Últimos_pasos]=u8"Last steps",
	[T_Programa_relativa_terminado_por]=u8"Program 'relativa' finished because of: ",
	[T_Programa_relativa_abortado]=u8"Program 'relativa' aborted by the user",
	[T_Programa_relativa_sin_memoria]=u8"Program 'relativa' aborted for want of memory",
};
static const char8_t* const TEXTOS_relativa_it[]={
	[T_banner]=u8"***Inizio del programma 'relativa', v. 2.8, 16 dicembre 2013***",
	[T_Leyendo_fotogramas]=u8"Leggendo il file di fotogrammi",
	[T_Escribiendo_fotogramas]=u8"Scrivendo il file di fotogrammi segnato: ",
	[T_está_vacío]=u8" è vuoto",
	[T_tiene_menos_de_3_puntos]=u8" ha meno di tre punti",
	[T_El_fotograma]=u8"Il fotogramma ",
	[T_Leyendo_interna]=u8"Leggendo il file di camera ",
	[T_Leyendo_gpsins]=u8"Leggendo il file di gps/ins ",
	[T_No_se_ha_podido_aprovechar_GPSINS]=u8"Nessun gruppo GPS/INS ha potuto essere usato",
	[T_Se_han_podido_aprovechar_los_primeros]=u8"Si hanno potuto usare i primi ",
	[T_grupos_GPSINS]=u8" gruppi GPS/INS",
	[T_Pasos_previos]=u8"Passi prima del calcolo...",
	[T_Se_han_unido_todos_los_fotogramas_GPS]=u8"Si sono uniti tutti i fotogrammi in un unico modello per mezzo dei dati GPS e INS",
	[T_Se_ha_formado_modelo_fotos_GPS]=u8"Si è formato un modello (m 1) per mezzo dei dati GPS e INS; è costituito dai seguenti fotogrammi:",
	[T_Mínimo_número_de_puntos_en_común]=u8"Minimo numero di punti comuni per l'orientazione di due fotogrammi: ",
	[T_Parámetro_de_camino]=u8"Parametro di cammino: ",
	[T_linea_cabecera_pro]=u8"primo elemento   secondo elemento   risultato  nºp.  iter.  e.m.c.       |  pt. malo",
	[T_El_último_modelo_intentado_está_mal]=u8"L'ultimo modelo che si cercò di formare è erroneo: f ",
	[T_El_proceso_diverge]=u8"Il processo diverge.",
	[T_Máximo_σ]=u8"Il massimo valore raggiunto dalla deviazione standard in un'iterazione è ",
	[T_No_se_puede_unir_en_un_bloque]=u8"Non si è riuscito a unire tutti i fotogrammi in un unico blocco",
	[T_Las_distintas_unidades_independientes]=u8"Vi ci sono le diverse unità independenti, che non sono potute essere unite tra loro",
	[T_No_se_ha_encontrado_par_erróneo]=u8"Non si è potuto trovare nessuna coppia di fotogrammi erronea.",
	[T_Mire_información_de_puntos_erróneos]=u8"Consulte l'informazione interessante ai punti erronei, prima che la compensazione cominciasse a essere erronea o nel momento nel quale cominciò a andare mal.",
	[T_Es_posible]=u8"È possibile",
	[T_Es_muy_probable]=u8"È molto probabile",
	[T_posible]=u8"possibile",
	[T_muy_probable]=u8"molto probabile",
	[T_que_el_par_de_fotos]=u8" che la coppia formata dalle fotografie ",
	[T_y]=u8" e ",
	[T_esté_mal]=u8" sia mal,",
	[T_punto]=u8"punto ",
	[T_pero_sólo_6_puntos_en_común]=u8" (ma ci sono soltanto 6 punti comuni)",
	[T_Es_posible_que_pares_mal]=u8"È possibile che le copie di fotografie che vi si mostrano siano mal:",
	[T_No_se_pudo_abrir_fichero_valores_calculados]=u8"Il file di valori calcolati non ha potuto essere aperto: ",
	[T_Los_resultados_no_se_escriben]=u8". I resultati non vengono scritti!",
	[T_Escribiendo_el_fichero_de_valores_calculados]=u8"Escrivendo il file di valori calcolati: ",
	[T_Error_escritura_fichero_valores_calculados]=u8"È apparso un errore nella scritura del file di valori calcolati.",
	[T_Es_probable_que_fichero_no_bien]=u8"È probabile che il file non si sia finito di scrivere correttamente.",
	[T_Fin_de_la_escritura_últimos_pasos]=u8"Fine della scritura del file, ultimi passi.",
	[T_Últimos_pasos]=u8"Ultimi passi",
	[T_Programa_relativa_terminado_por]=u8"Programma 'relativa' finito per: ",
	[T_Programa_relativa_abortado]=u8"Programma 'relativa' abortito dall'usuario",
	[T_Programa_relativa_sin_memoria]=u8"Programma 'relativa' abortito per memoria insuficente",
};

static const char16_t* const LTEXTOS_relativa_esp[]={
	u"No se pudo abrir el fichero de proceso. Se para inmediatamente",
	u"El fichero de fotogramas sólo contiene un fotograma",
	u"El fotograma ",
	u" está repetido",
	u" está vacío",
	u" tiene menos de tres puntos",
	u"En el fotograma ",
	u", el punto ",
	u"No hay ningún par de fotogramas con suficiente número de puntos en común (5)",
	u"El último modelo que se intentó formar está mal: f ",
	u"El proceso diverge. No se ha podido completar el cálculo.",
	u"No se ha podido unir todos los fotogramas en un único bloque",
	u"Algún ajuste llegó a divergir. Es posible que los valores obtenidos no sean válidos como valores aproximados.",
	u"Cálculo terminado",
	u"Memoria insuficiente para el cálculo",
	u"Una vez eliminados los fotogramas vacíos o con pocos puntos ",
	u"no queda ningún fotograma",
	u"sólo queda un fotograma",
	u"No existe el directorio '",
	u"' en el que se ha indicado que está el fichero de fotogramas",
	u"Error en el fichero de fotogramas: ",
	u"de fotogramas",
	u"Error en el fichero de cámara: ",
	u"de cámara",
	u"Error en el fichero de gps/ins: ",
	u"de gps/ins",
};
static const char16_t* const LTEXTOS_relativa_eng[]={
	u"The process file could not be opened. Aborting immediately",
	u"There is just one photo in the photographs file",
	u"The photograph ",
	u" appears twice",
	u" is empty",
	u" has less than three points",
	u"In the photograph ",
	u", the point",
	u"There isn't any pair of photographs with enough common points (5)",
	u"The last model to be built is wrong: f ",
	u"The process diverges. The calculation couldn't be finished.",
	u"It hasn't been possible to join all photographs together in a single block",
	u"One or more adjustments diverged. It is possible that the computed values not be valid as approximate values.",
	u"Calculation finished",
	u"Not enough memory for the adjustment",
	u"Once the empty photographs and those with few points were removed ",
	u"there remains no photograph",
	u"there only remains one photograph",
	u"The directory '",
	u"' where the photographs file should lie does not exist",
	u"Error in the photographs file: ",
	u"photographs",
	u"Error in the camera file: ",
	u"camera",
	u"Error in the gps/ins file: ",
	u"gps/ins",
};
static const char16_t* const LTEXTOS_relativa_it[]={
	u"Non è stato possibile aprire il file di processo. Si ferma subito",
	u"Il file di fotogrammi ha soltanto un fotogramma",
	u"Il fotogramma ",
	u" compare due volte",
	u" è vuoto",
	u" ha meno di tre punti",
	u"Nel fotogramma ",
	u", il punto",
	u"Non c'è nessuna coppia di fotogrammi con punti comuni abbastanza (5)",
	u"L'ultimo modelo che si cercò di formare è erroneo: f ",
	u"Il processo diverge. Il calcolo non ha potuto essere portato a termino.",
	u"Non si è riuscito a unire tutti i fotogrammi in un unico blocco",
	u"Qualche compensazione diverge. È possibile che i valori ottenuti non siano adeguati come valori approssimati.",
	u"Calcolo finito",
	u"Memoria insuficente per il calcolo",
	u"Una volta eliminati i fotogrammi vuoti o con pochi punti ",
	u"non rimane nessun fotogramma",
	u"soltanto è rimasto un fotogramma",
	u"Non esiste il direttorio '",
	u"' in cui si dovrebbe trovare il file di fotogrammi",
	u"Errore nel file di fotogrammi: ",
	u"di fotogrammi",
	u"Errore nel file di camera: ",
	u"di camera",
	u"Errore nel file di gps/ins: ",
	u"di gps/ins",
};

#define MAX_IDIOMA Id_It
static const char8_t* const* TEXTOS_relativa[3]={
	TEXTOS_relativa_esp,
	TEXTOS_relativa_eng,
	TEXTOS_relativa_it
};
static const char16_t* const* LTEXTOS_relativa[3]={
	LTEXTOS_relativa_esp,
	LTEXTOS_relativa_eng,
	LTEXTOS_relativa_it
};

/*TEXTOS debe de hacerse igual a o definirse como TEXTOS_relativa[idioma]
análogamente LTEXTOS*/

#define TEXTO_lecturaf(n)		TEXTOS[n]
#define S_(s) TEXTO_lecturaf(T_##s)

#define SS_Es_posible_probable(i) TEXTOS[T_Es_posible+i]
#define SS_posible_probable(i) TEXTOS[T_posible+i]

#define L_No_se_pudo_abrir_el_fichero_de_proceso LTEXTOS[0]
#define L_Sólo_un_fotograma LTEXTOS[1]
#define L_El_fotograma LTEXTOS[2]
#define L_está_repetido LTEXTOS[3]
#define L_está_vacío LTEXTOS[4]
#define L_tiene_menos_de_tres_puntos LTEXTOS[5]
#define L_En_el_fotograma LTEXTOS[6]
#define L_el_punto LTEXTOS[7]
#define L_No_hay_ningún_par_con_suficientes_puntos_en_común LTEXTOS[8]
#define L_El_último_modelo_está_mal LTEXTOS[9]
#define L_El_proceso_diverge LTEXTOS[10]
#define L_No_se_ha_podido_unir_todos_los_fotogramas LTEXTOS[11]
#define L_Algún_ajuste_llegó_a_divergir LTEXTOS[12]
#define L_Cálculo_terminado LTEXTOS[13]
#define L_Memoria_insuficiente LTEXTOS[14]
#define L_Una_vez_eliminados_los_fotogramas_vacíos LTEXTOS[15]
#define L_no_queda_ningún_fotograma LTEXTOS[16]
#define L_sólo_queda_un_fotograma LTEXTOS[17]
#define L_No_existe_el_directorio LTEXTOS[18]
#define L_del_fichero_de_fotogramas LTEXTOS[19]
#define L_error_en_el_fichero_de_fotogramas LTEXTOS[20]
#define L_defotogramas LTEXTOS[21]
#define L_error_en_el_fichero_de_cámara LTEXTOS[20]
#define L_decámara LTEXTOS[21]
#define L_error_en_el_fichero_de_gps LTEXTOS[22]
#define L_degps LTEXTOS[23]
