/*Las siguientes funciones suponen que las coordenadas del c.p. primero son (0,0,0) y la M1 la matriz identidad*/
float secrr3_ap_den(Puntoxy_double a1,double (*M)[3], Puntoxy_double a2){
	PuntoXYZ_double d;
	float m,p;

	d.X=a2.x*M[0][0]+a2.y*M[1][0]-M[2][0];
	d.Y=a2.x*M[0][1]+a2.y*M[1][1]-M[2][1];
	d.Z=1/(a2.x*M[0][2]+a2.y*M[1][2]-M[2][2]);
	d.X*=d.Z;
	d.Y*=d.Z;
	m=(float)(d.X+a1.x);
	p=(float)(d.Y+a1.y);
	return m*m+p*p;
}
float secrr3_ap_foto(Puntoxy_double a1,PuntoXYZ_double c,double (*M)[3], Puntoxy_double a2, PuntoXYZ_double *P){
	PuntoXYZ_double d;
	double sxz,syz;
	double m,n,p,q,Zc;
	double den;

	d.X=a2.x*M[0][0]+a2.y*M[1][0]-M[2][0];
	d.Y=a2.x*M[0][1]+a2.y*M[1][1]-M[2][1];
	d.Z=1/(a2.x*M[0][2]+a2.y*M[1][2]-M[2][2]);
	sxz=d.X*d.Z;
	syz=d.Y*d.Z;

	m=sxz+a1.x;
	n=-c.Z*sxz+c.X;
	p=syz+a1.y;
	q=-c.Z*syz+c.Y;

	den=m*m+p*p;
	if(den<1.0E-20F) den=1.0E-20F;
	P->Z=-(m*n+p*q)/den;
	Zc=P->Z-c.Z;
	P->X=-a1.x*P->Z;
	P->X+=sxz*Zc+c.X;
	P->X/=2;
	P->Y=-a1.y*P->Z;
	P->Y+=syz*Zc+c.Y;
	P->Y/=2;
	return (float)den;
}
//devuelve 0000bb. El bit bajo está a 1 si el punto queda por detrás del c.p. en una foto y por delante en la otra.
//Si el bit bajo está a cero, el segundo bit está a cero si en las dos fotos está por delante, y a 1 si está por detrás.
u8int secrr3_ap_signo(Puntoxy_double a1,PuntoXYZ_double c,double (*M)[3], Puntoxy_double a2){
	PuntoXYZ_double d;
	double sxz,syz;
	double m,n,p,q;
	u8int bb=0;

	d.X=a2.x*M[0][0]+a2.y*M[1][0]-M[2][0];
	d.Y=a2.x*M[0][1]+a2.y*M[1][1]-M[2][1];
	d.Z=1/(a2.x*M[0][2]+a2.y*M[1][2]-M[2][2]);
	sxz=d.X*d.Z;
	syz=d.Y*d.Z;

	m=sxz+a1.x;
	n=-c.Z*sxz+c.X;
	p=syz+a1.y;
	q=-c.Z*syz+c.Y;
	if(m*n+p*q<0) bb=1;

	d.X=a1.x*M[0][0]+a1.y*M[0][1]-M[0][2];
	d.Y=a1.x*M[1][0]+a1.y*M[1][1]-M[1][2];
	d.Z=1/(a1.x*M[2][0]+a1.y*M[2][1]-M[2][2]);
	sxz=d.X*d.Z;
	syz=d.Y*d.Z;

	double aux=c.X*M[2][0]+c.Y*M[2][1]+c.Z*M[2][2];
	m=sxz+a2.x;
	n=aux*sxz-(c.X*M[0][0]+c.Y*M[0][1]+c.Z*M[0][2]);
	p=syz+a1.y;
	q=aux*syz-(c.X*M[1][0]+c.Y*M[1][1]+c.Z*M[1][2]);
	if(m*n+p*q<0) bb^=3;

	return bb;
}

float secrr3_ap_foto_vv(Puntoxy_double a1,PuntoXYZ_double c,double (*M)[3], Puntoxy_double a2, PuntoXYZ_double *P, float *vv){
	PuntoXYZ_double d;
	double sxz,syz;
	double m,n,p,q,Zc;
	double den;

	d.X=a2.x*M[0][0]+a2.y*M[1][0]-M[2][0];
	d.Y=a2.x*M[0][1]+a2.y*M[1][1]-M[2][1];
	d.Z=1/(a2.x*M[0][2]+a2.y*M[1][2]-M[2][2]);
	sxz=d.X*d.Z;
	syz=d.Y*d.Z;

	m=sxz+a1.x;
	n=-c.Z*sxz+c.X;
	p=syz+a1.y;
	q=-c.Z*syz+c.Y;

	den=m*m+p*p;
	if(den<1.0E-20F) den=1.0E-20F;
	P->Z=-(m*n+p*q)/den;
	Zc=P->Z-c.Z;

	double aux, auxb;
	float faux;
	aux=-a1.x*P->Z;
	auxb=sxz*Zc+c.X;
	P->X=0.5*(aux+auxb);
	faux=(float)(aux-auxb); *vv+=0.5F*faux*faux;
	//
	aux=-a1.y*P->Z;
	auxb=syz*Zc+c.Y;
	P->Y=0.5*(aux+auxb);
	faux=(float)(aux-auxb); *vv+=0.5F*faux*faux;
	return (float)(den/(2.0+den));
}

float secrr3_foto_vv(Puntoxy_double a1,PuntoXYZ_double c,double (*M)[3], Puntoxy_double a2, PuntoXYZ_double *P, float *vv){
	double B[6], N[9], L[3];
	double aux;
	float faux;

	//Ecuación de colinealidad pasando el denominador al otro lado para linealizar
	B[0]=M[2][0]*a2.x+M[0][0];	B[1]=M[2][1]*a2.x+M[0][1];	B[2]=M[2][2]*a2.x+M[0][2];
	B[3]=M[2][0]*a2.y+M[1][0];	B[4]=M[2][1]*a2.y+M[1][1];	B[5]=M[2][2]*a2.y+M[1][2];

	aux=B[0]*B[0]+B[3]*B[3];	N[0]=1+aux;			L[0]=aux*c.X;
	aux=B[0]*B[1]+B[3]*B[4];	N[1]=aux;			L[0]+=aux*c.Y;	L[1]=aux*c.X;
	aux=B[0]*B[2]+B[3]*B[5];	N[2]=a1.x+aux;		L[0]+=aux*c.Z;	L[2]=aux*c.X;

	aux=B[1]*B[1]+B[4]*B[4];	N[4]=1+aux;			L[1]+=aux*c.Y;
	aux=B[1]*B[2]+B[4]*B[5];	N[5]=a1.y+aux;		L[1]+=aux*c.Z;	L[2]+=aux*c.Y;

	aux=B[2]*B[2]+B[5]*B[5];	N[8]=a1.x*a1.x+a1.y*a1.y+aux;	L[2]+=aux*c.Z;

	ATinvsim3_dbl(N);
	{double *pN=N;
	P->X=*pN++*L[0];	P->X+=*pN++*L[1];	P->X+=*pN++*L[2];
	P->Y=*pN++*L[0];	P->Y+=*pN++*L[1];		P->Y+=*pN++*L[2];
	P->Z=*pN++*L[0];	P->Z+=*pN++*L[1];		P->Z+=*pN*L[2];}

	aux=P->Z*a1.x+P->X;	faux=(float)aux;	*vv+=faux*faux;
	aux=P->Z*a1.y+P->Y;	faux=(float)aux;	*vv+=faux*faux;
	aux=B[0]*(P->X-c.X)+B[1]*(P->Y-c.Y)+B[2]*(P->Z-c.Z);
	faux=(float)aux;	*vv+=faux*faux;
	aux=B[3]*(P->X-c.X)+B[4]*(P->Y-c.Y)+B[5]*(P->Z-c.Z);
	faux=(float)aux;	*vv+=faux*faux;

	float den=(float)(N[0]+N[4]+N[8]);
	return 1.0F/den;
}
/*Fin funciones con origen del sistema en la foto 1*/

/*la precisión en las coordenadas calculadas es mucho peor que la corrección*/
///*m,n,p,q ya no hacen falta*/\
	double e;\
	if(den<0.00001){\
		m=rxz*Za+a.X-(sxz*Zc+c.X);\
		p=ryz*Za+a.Y-(syz*Zc+c.Y);\
		e=(m*m+p*p)/((Za+Zc)*den);\
		P->Z+=e;\
		Za+=e;	Zc+=e;\
	}

#define calculo_interseccion(a,c) \
	m=sxz-rxz;\
	n=-c.Z*sxz+a.Z*rxz+c.X-a.X;\
	p=syz-ryz;\
	q=-c.Z*syz+a.Z*ryz+c.Y-a.Y;\
\
	den=m*m+p*p;\
	if(den<1.0E-20F) den=1.0E-20F;\
	P->Z=-(m*n+p*q)/den;\
	Za=P->Z-a.Z;\
	Zc=P->Z-c.Z;\
	/*double e; ... aquí estaba*/ \
	P->X=rxz*Za+a.X;\
	P->X+=sxz*Zc+c.X;\
	P->X/=2;\
	P->Y=ryz*Za+a.Y;\
	P->Y+=syz*Zc+c.Y;\
	P->Y/=2;

float secrr3_ap_matriz1(PuntoXYZM_double *C1,Puntoxy_double a1,double f1, PuntoXYZ_double C2,double cosk,double sink,Puntoxy_double a2,double f2, PuntoXYZ_double *P){
	PuntoXYZ_double b;
	double rxz,ryz,sxz,syz;
	double m,n,p,q,Za,Zc;
	double den;

	b.X=a1.x*C1->M[0][0]+a1.y*C1->M[1][0]-f1*C1->M[2][0];
	b.Y=a1.x*C1->M[0][1]+a1.y*C1->M[1][1]-f1*C1->M[2][1];
	b.Z=1/(a1.x*C1->M[0][2]+a1.y*C1->M[1][2]-f1*C1->M[2][2]);
	rxz=b.X*b.Z;
	ryz=b.Y*b.Z;

	b.X=a2.x*cosk+a2.y*sink;
	b.Y=-a2.x*sink+a2.y*cosk;
	sxz=-b.X/f2;
	syz=-b.Y/f2;

	calculo_interseccion(C1->P,C2)
	return (float)(den/(2.0+den));
}

float secrr3_ap(PuntoXYZM_double *C1,Puntoxy_double a1,double f1, PuntoXYZM_double *C2,Puntoxy_double a2,double f2, PuntoXYZ_double *P){
	PuntoXYZ_double b;
	double rxz,ryz,sxz,syz;
	double m,n,p,q,Za,Zc;
	double den;

	b.X=a1.x*C1->M[0][0]+a1.y*C1->M[1][0]-f1*C1->M[2][0];
	b.Y=a1.x*C1->M[0][1]+a1.y*C1->M[1][1]-f1*C1->M[2][1];
	b.Z=1/(a1.x*C1->M[0][2]+a1.y*C1->M[1][2]-f1*C1->M[2][2]);
	rxz=b.X*b.Z;
	ryz=b.Y*b.Z;

	b.X=a2.x*C2->M[0][0]+a2.y*C2->M[1][0]-f2*C2->M[2][0];
	b.Y=a2.x*C2->M[0][1]+a2.y*C2->M[1][1]-f2*C2->M[2][1];
	b.Z=1/(a2.x*C2->M[0][2]+a2.y*C2->M[1][2]-f2*C2->M[2][2]);
	sxz=b.X*b.Z;
	syz=b.Y*b.Z;

	calculo_interseccion(C1->P,C2->P)
	return (float)(den/(2.0+den));
}

float secrr3_vv(PuntoXYZM_double *C1,Puntoxy_double a1, PuntoXYZM_double *C2,Puntoxy_double a2, PuntoXYZ_double *P, float *vv){
	double B[6], A[6], N[9], L[3];
	double aux;
	float faux;

	//Ecuación de colinealidad pasando el denominador al otro lado para linealizar
	B[0]=C2->M[2][0]*a2.x+C2->M[0][0];	B[1]=C2->M[2][1]*a2.x+C2->M[0][1];	B[2]=C2->M[2][2]*a2.x+C2->M[0][2];
	B[3]=C2->M[2][0]*a2.y+C2->M[1][0];	B[4]=C2->M[2][1]*a2.y+C2->M[1][1];	B[5]=C2->M[2][2]*a2.y+C2->M[1][2];

	aux=B[0]*B[0]+B[3]*B[3];	N[0]=aux;	L[0]=aux*C2->P.X;
	aux=B[0]*B[1]+B[3]*B[4];	N[1]=aux;		L[0]+=aux*C2->P.Y;	L[1]=aux*C2->P.X;
	aux=B[0]*B[2]+B[3]*B[5];	N[2]=aux;		L[0]+=aux*C2->P.Z;	L[2]=aux*C2->P.X;

	aux=B[1]*B[1]+B[4]*B[4];	N[4]=aux;	L[1]+=aux*C2->P.Y;
	aux=B[1]*B[2]+B[4]*B[5];	N[5]=aux;		L[1]+=aux*C2->P.Z;		L[2]+=aux*C2->P.Y;

	aux=B[2]*B[2]+B[5]*B[5];	N[8]=aux;	L[2]+=aux*C2->P.Z;

	A[0]=C1->M[2][0]*a1.x+C1->M[0][0];		A[1]=C1->M[2][1]*a1.x+C1->M[0][1];	A[2]=C1->M[2][2]*a1.x+C1->M[0][2];
	A[3]=C1->M[2][0]*a1.y+C1->M[1][0];		A[4]=C1->M[2][1]*a1.y+C1->M[1][1];	A[5]=C1->M[2][2]*a1.y+C1->M[1][2];

	aux=A[0]*A[0]+A[3]*A[3];	N[0]+=aux;	L[0]+=aux*C1->P.X;
	aux=A[0]*A[1]+A[3]*A[4];	N[1]+=aux;	L[0]+=aux*C1->P.Y;		L[1]+=aux*C1->P.X;
	aux=A[0]*A[2]+A[3]*A[5];	N[2]+=aux;	L[0]+=aux*C1->P.Z;		L[2]+=aux*C1->P.X;

	aux=A[1]*A[1]+A[4]*A[4];	N[4]+=aux;	L[1]+=aux*C1->P.Y;
	aux=A[1]*A[2]+A[4]*A[5];	N[5]+=aux;	L[1]+=aux*C1->P.Z;		L[2]+=aux*C1->P.Y;

	aux=A[2]*A[2]+A[5]*A[5];	N[8]+=aux;	L[2]+=aux*C1->P.Z;

	ATinvsim3_dbl(N);
	{double *pN=N;
	P->X=*pN++*L[0];	P->X+=*pN++*L[1];	P->X+=*pN++*L[2];
	P->Y=*pN++*L[0];	P->Y+=*pN++*L[1];		P->Y+=*pN++*L[2];
	P->Z=*pN++*L[0];	P->Z+=*pN++*L[1];		P->Z+=*pN*L[2];}

	faux=(float)(A[0]*(P->X-C1->P.X)+A[1]*(P->Y-C1->P.Y)+A[2]*(P->Z-C1->P.Z));	*vv=faux*faux;
	faux=(float)(A[3]*(P->X-C1->P.X)+A[4]*(P->Y-C1->P.Y)+A[5]*(P->Z-C1->P.Z));	*vv+=faux*faux;
	faux=(float)(B[0]*(P->X-C2->P.X)+B[1]*(P->Y-C2->P.Y)+B[2]*(P->Z-C2->P.Z));	*vv+=faux*faux;
	faux=(float)(B[3]*(P->X-C2->P.X)+B[4]*(P->Y-C2->P.Y)+B[5]*(P->Z-C2->P.Z));	*vv+=faux*faux;

	float den=(float)(N[0]+N[4]+N[8]);
	return 1.0F/den;
}
