﻿static const char8_t* const cadenas_comunes[]={"","X","Y","XY","Z","XZ","YZ","XYZ",
	"  --  ", //8
}; //XYZ es, en ResporPunto, f2_fotograma.
#define S_S cadenas_comunes[0]

sinline void write_residuo(ATFormatter *buf, float aux, char8_t sres[12]){
	to_reset(buf);
	towrite8_float(buf,aux); *buf->ptr='\0';
	memcpy_char8(sres,buf->base,12); sres[11]='\0';
}
void ordenar_uint(uint* v, uint* ind, uint n){
	uint* punT=v;
	for(uint i=0;i<n;i++,punT++){
		uint a=0, b=i;
		while(a!=b){
			uint r=(a+b-1)>>1;
			if(*punT<v[ind[r]]) b=r;
			else a=r+1;
		}
		arrayinsert1_uint(ind+a,i,i-a);
	}
}
//0, AT_NOMEM.
int rellena_res_porfotos(BnfTabla_ResporFoto *tabla, s8int dec, bint llena_nombres, uint ncp,const uint* orden_cp, const uint* p_cp_acum,const int4* mafp, const CentroProy* centros,const PuntoM* puntosM, const float* L,const float* L_norm,const uint* pm_ppios, const PuntoM* puntosA){
	PLIST plist;
	uint lll;
	uint* comienzos;
	float* L_max;
	float* L_norm_max;
	uint* orden_L;
	uint* orden_L_norm;
	BnfFila_ResporFoto *pfila;
	ATFormatter buf;
	const BnfFila_ResporFoto filafoto_base={NULL,S_S,{'\0'},{'\0'},{'\0'},0,0,{'\0'},0,0};

	tabla->filas=NULL;
	tabla->nfilas=0;
	plist=get_new_plist();

	ifunlike(SetupFormatter(&buf)!=0) goto salida_outofmem;
	setbuf_scientific(&buf);
	setbuf_nolimpio(&buf);
	if(dec<=0){buf.prec.absol=-dec; setbuf_absolute(&buf);}
	else{buf.prec.signi=(u8int)dec; setbuf_relative(&buf);}

	aj_malloc_add(comienzos,uint,ncp+1);
	aj_malloc_add(L_max,float,ncp);
	aj_malloc_add(L_norm_max,float,ncp);
	aj_malloc_add(orden_L,uint,ncp);
	aj_malloc_add(orden_L_norm,uint,ncp);
	tabla->nfilas=p_cp_acum[ncp-1]+ncp;
	aj_malloc_n(tabla->filas,BnfFila_ResporFoto,tabla->nfilas);

	lll=0;
	pfila=tabla->filas;
	uint ib; for(ib=0;ib<ncp;ib++){
		uint i,l,ll;
		float max,maxn;
		const int4 *pint4;
		const float *pL, *pLnorm;
		char8_t* cp_nom;

		i=orden_cp[ib];
		if(i) l=p_cp_acum[i-1];
		else l=0;
		ll=p_cp_acum[i];
		if(l==ll){
			comienzos[ib]=lll;
			L_max[ib]=-1.0F;
			L_norm_max[ib]=-1.0F;
			tabla->nfilas--;
			continue;
		}
		*pfila=filafoto_base;
		cp_nom=centros[i].nom;
		pfila->f1_fotograma=cp_nom;
		pfila->v_orden_def=lll;
		comienzos[ib]=lll;
		pfila++, lll++;

		max=maxn=0;
		pint4=mafp+l;
		pL=L+(l<<1);
		pLnorm=L_norm+(l<<1);
		dontimes(ll-l,(pint4++,pfila++)){
			uint k,pa,naux;
			float aux;

			k=pint4->n1;
			if(llena_nombres) pfila->f1_fotograma=cp_nom;
			pfila->f1_fotograma=S_S;
			pfila->f2_punto=puntosM[k].nom;

			aux=*pL++;
			pfila->v_resx=aux;
			write_residuo(&buf,aux,pfila->f3_resx);
			if(fabsf(aux)>max) max=fabsf(aux);
			aux=*pL++;
			pfila->v_resy=aux;
			write_residuo(&buf,aux,pfila->f4_resy);
			if(fabsf(aux)>max) max=fabsf(aux);

			pfila->f5_tipo[0]=pfila->f5_tipo[1]=pfila->f5_tipo[2]=' ';
			pfila->f5_tipo[3]='\0';
			if((pa=pint4->n2)!=Я){
				pa=puntosA[pa].bbb;
				if(pa&1) pfila->f5_tipo[0]='X';
				if(pa&2) pfila->f5_tipo[1]='Y';
				if(pa&4) pfila->f5_tipo[2]='Z';
			}
			aux=fabsf(*pLnorm++);		pfila->f6_res_norm_x=aux;	if(aux>maxn) maxn=aux;
			aux=fabsf(*pLnorm++);		pfila->f7_res_norm_y=aux;	if(aux>maxn) maxn=aux;
			naux=pm_ppios[k+1]-pm_ppios[k]-1;

			if(naux==1 || (naux==2 && (pa==Я || pa==1 || pa==2 || pa==4))){
				pfila->f8_aviso[0]='!';
				pfila->f8_aviso[1]='\0';
				if(naux==1){pfila->f8_aviso[1]='!'; pfila->f8_aviso[2]='\0';}
			}else{
				pfila->f8_aviso[0]='\0';
			}

			pfila->v_orden_def=lll++;
		}
		L_max[ib]=max;
		L_norm_max[ib]=maxn;
	}
	comienzos[ncp]=lll;

	//Ordenar por L y L_norm
	ordenar_float(L_max,orden_L,ncp);
	ordenar_float(L_norm_max,orden_L_norm,ncp);
	lll=0;
	fordown(i,ncp,){
		uint ib,l,ll,j;
		ib=orden_L[i];
		l=comienzos[ib];
		ll=comienzos[ib+1];
		for(j=l;j<ll;j++){
			tabla->filas[j].v_orden_res=lll++;
		}
	}
	lll=0;
	fordown(i,ncp,){
		uint ib,l,ll,j;
		ib=orden_L_norm[i];
		l=comienzos[ib];
		ll=comienzos[ib+1];
		for(j=l;j<ll;j++){
			tabla->filas[j].v_orden_res_norm=lll++;
		}
	}

	toclose(&buf);
	free_plist(plist);
	return 0;

salida_outofmem:
	free_plist(plist);
	toclose(&buf);	//Si se abrió mal esta función no hace nada
	return AT_NOMEM;
}
int rellena_res_porpuntos(BnfTabla_ResporPunto *tabla, s8int dec, bint llena_nombres, uint npm,const uint* orden_pm, const uint* pm_ppios,const int2* p_en_cp, const int4* mafp, uint ntot, const CentroProy* centros,const PuntoM* puntosM, const float* L,const float* L_norm, const PuntoM* puntosA){
	PLIST plist;
	uint lll;
	uint* comienzos;
	float* L_max;
	float* L_norm_max;
	uint* orden_L;
	uint* orden_L_norm;
	uint* nfotos, *nfotos_orden;
	uint nreserv_fot;
	BnfFila_ResporPunto *pfila;
	ATFormatter buf;
	const BnfFila_ResporPunto filapunto_base={NULL,S_S,{'\0'},{'\0'},0,0,0,0};

	tabla->filas=NULL;
	tabla->nfilas=0;
	plist=get_new_plist();

	ifunlike(SetupFormatter(&buf)!=0) goto salida_outofmem;
	setbuf_scientific(&buf);
	setbuf_nolimpio(&buf);
	if(dec<=0){buf.prec.absol=-dec; setbuf_absolute(&buf);}
	else{buf.prec.signi=(u8int)dec; setbuf_relative(&buf);}

	aj_malloc_add(comienzos,uint,npm+1);
	aj_malloc_add(L_max,float,npm);
	aj_malloc_add(L_norm_max,float,npm);
	aj_malloc_add(orden_L,uint,npm);
	aj_malloc_add(orden_L_norm,uint,npm);
	aj_malloc_add_ind(nfotos,uint,12);
	aj_malloc_add_ind(nfotos_orden,uint,12);
	nreserv_fot=12;
	tabla->nfilas=ntot+npm;
	aj_malloc_n(tabla->filas,BnfFila_ResporPunto,tabla->nfilas);

	lll=0;
	pfila=tabla->filas;
	{uint ib; for(ib=0;ib<npm;ib++){
		uint i,l,ll;
		uint pa;
		float max,maxn;
		char8_t* pm_nom;

		i=orden_pm[ib];
		l=pm_ppios[i];
		ll=pm_ppios[i+1]-1;
		if(l==ll){
			comienzos[ib]=lll;
			L_max[ib]=L_norm_max[ib]=-1.0F;
			tabla->nfilas--;
			continue;
		}
		*pfila=filapunto_base;
		pa=p_en_cp[l].n1;
		pm_nom=puntosM[i].nom;
		pfila->f1_punto=pm_nom;
		if((pa=mafp[pa].n2)!=Я){
			pa=puntosA[pa].bbb;
			pfila->f2_fotograma=cadenas_comunes[pa&7];
		}
		if(ll-l==1 || (ll-l==2 && (pa==Я || pa==1 || pa==2 || pa==4))){
			pfila->f3_resx[0]='!';
			pfila->f3_resx[1]='\0';
			if(ll-l==1){pfila->f3_resx[1]='!'; pfila->f3_resx[2]='\0';}
		}
		pfila->v_orden_def=lll;
		comienzos[ib]=lll;
		pfila++, lll++;

		if(ll-l>nreserv_fot){
			nreserv_fot=ll-l;
			free(nfotos); aj_malloc_n(nfotos,uint,nreserv_fot);
			free(nfotos_orden); aj_malloc_n(nfotos_orden,uint,nreserv_fot);
		}
		{uint *ptr=nfotos;	//ANSI
		{uint j; for(j=l;j<ll;j++) *ptr++=mafp[p_en_cp[j].n1].n3;}	//ordenado según el orden de los nombres en el fichero de fotogramas
		ordenar_uint(nfotos,nfotos_orden,ll-l);
		}
		max=maxn=0;
		ll-=l;
		{uint j; for(j=0;j<ll;j++,pfila++){
			uint k,kk;
			float aux;

			k=p_en_cp[l+nfotos_orden[j]].n1;
			kk=k<<1;
			if(llena_nombres) pfila->f1_punto=pm_nom;
			else pfila->f1_punto=S_S;
			pfila->f2_fotograma=centros[mafp[k].n3].nom;

			aux=L[kk];
			pfila->v_resx=aux;
			write_residuo(&buf,aux,pfila->f3_resx);
			if(fabsf(aux)>max) max=fabsf(aux);

			aux=L[kk+1];
			pfila->v_resy=aux;
			write_residuo(&buf,aux,pfila->f4_resy);
			if(fabsf(aux)>max) max=fabsf(aux);

			aux=fabsf(L_norm[kk]);		pfila->f5_res_norm_x=aux;	if(aux>maxn) maxn=aux;
			aux=fabsf(L_norm[kk+1]);		pfila->f6_res_norm_y=aux;	if(aux>maxn) maxn=aux;
			pfila->v_orden_def=lll++;
		}}
		L_max[ib]=max;
		L_norm_max[ib]=maxn;
	}}
	comienzos[npm]=lll;

	//Ordenar por L y L_norm
	ordenar_float(L_max,orden_L,npm);
	ordenar_float(L_norm_max,orden_L_norm,npm);
	lll=0;
	fordown(i,npm,){
		uint ib,l,ll,j;
		ib=orden_L[i];
		l=comienzos[ib];
		ll=comienzos[ib+1];
		for(j=l;j<ll;j++){
			tabla->filas[j].v_orden_res=lll++;
		}
	}
	lll=0;
	fordown(i,npm,){
		uint ib,l,ll,j;
		ib=orden_L_norm[i];
		l=comienzos[ib];
		ll=comienzos[ib+1];
		for(j=l;j<ll;j++){
			tabla->filas[j].v_orden_res_norm=lll++;
		}
	}

	toclose(&buf);
	free_plist(plist);
	return 0;

salida_outofmem:
	free_plist(plist);
	toclose(&buf);	//Si se abrió mal esta función no hace nada
	return AT_NOMEM;
}
int rellena_res_apoyo(BnfTabla_ResApoyo *tabla, s8int dec, const PuntoM* punpmA, uint npy, bint fijas,const uint* pA_a_pM, const float* Lp,const float* Lp_norm, const PuntoM* punpmC,uint npc,const uint* pC_a_pM, const float* Lpc, const float* Lpc_norm){
	PLIST plist;
	uint lll;
	uint npyb,npcb,k;
	float* L_max;
	float* L_norm_max;
	uint* orden_L;
	uint* orden_L_norm;
	float* Lc_max;
	float* Lc_norm_max;
	uint* orden_Lc;
	uint* orden_Lc_norm;
	BnfFila_ResApoyo *pfila;
	ATFormatter buf;

	tabla->filas=NULL;
	tabla->nfilas=0;
	plist=get_new_plist();

	ifunlike(SetupFormatter(&buf)!=0) goto salida_outofmem;
	setbuf_scientific(&buf);
	setbuf_nolimpio(&buf);
	if(dec<=0){buf.prec.absol=-dec; setbuf_absolute(&buf);}
	else{buf.prec.signi=(u8int)dec; setbuf_relative(&buf);}

	if(!fijas || pA_a_pM==NULL) npy=0;
	if(pC_a_pM==NULL) npc=0;
	if(npy){
		aj_malloc_add(L_max,float,npy);
		aj_malloc_add(L_norm_max,float,npy);
		aj_malloc_add(orden_L,uint,npy);
		aj_malloc_add(orden_L_norm,uint,npy);
	}
	if(npc){
		aj_malloc_add(Lc_max,float,npc);
		aj_malloc_add(Lc_norm_max,float,npc);
		aj_malloc_add(orden_Lc,uint,npc);
		aj_malloc_add(orden_Lc_norm,uint,npc);
	}
	tabla->nfilas=npy+npc;
	if(npc) tabla->nfilas++;
	aj_malloc_n(tabla->filas,BnfFila_ResApoyo,tabla->nfilas);

	npyb=0;
	pfila=tabla->filas;
	{uint j;
	const float *pL, *pLnorm;
	float *pLmax, *pLmax_n;
	pL=Lp, pLnorm=Lp_norm;
	pLmax=L_max, pLmax_n=L_norm_max;
	for(j=0;j<npy;j++,punpmA++){
		u8int bk;
		float max;
		if(pA_a_pM[j]==Я){pL+=3, pLnorm+=3; continue;}

		pfila->f1_punto=punpmA->nom;
		bk=punpmA->bbb;
		max=-1.0F;
		if(bk&1){
			float aux=*pL;
			pfila->v_resx=aux;
			write_residuo(&buf,aux,pfila->f2_resx);
			max=fabsf(aux);
		}else{
			strcpy8(pfila->f2_resx,cadenas_comunes[8]);
			pfila->v_resx=0;
		}
		pL++;
		if(bk&2){
			float aux=*pL;
			pfila->v_resy=aux;
			write_residuo(&buf,aux,pfila->f3_resy);
			if(fabsf(aux)>max) max=fabsf(aux);
		}else{
			strcpy8(pfila->f3_resy,cadenas_comunes[8]);
			pfila->v_resy=0;
		}
		pL++;
		if(bk&4){
			float aux=*pL;
			pfila->v_resz=aux;
			write_residuo(&buf,aux,pfila->f4_resz);
			if(fabsf(aux)>max) max=fabsf(aux);
		}else{
			strcpy8(pfila->f4_resz,cadenas_comunes[8]);
			pfila->v_resz=0;
		}
		pL++;
		*pLmax++=max;

		max=0;
		{float aux=fabsf(*pLnorm++);	pfila->f5_res_norm_x=aux;	max=aux;}
		{float aux=fabsf(*pLnorm++);	pfila->f6_res_norm_y=aux;	if(aux>max) max=aux;}
		{float aux=fabsf(*pLnorm++);	pfila->f7_res_norm_z=aux;	if(aux>max) max=aux;}
		*pLmax_n++=max;

		pfila->v_orden_def=npyb++;
		pfila++;
	}}
	k=npyb;
	if(npc){
		BnfFila_ResApoyo f_aux={S_S,{'\0'},{'\0'},{'\0'},0,0,0, 0,0,0,k,k,k}; k++;
		*pfila++=f_aux;
	}
	//puntos de Control
	if(npc){
	 uint j;
	 const float *pL, *pLnorm;
	 float *pLmax, *pLmax_n;
	 pL=Lpc, pLnorm=Lpc_norm;
	 pLmax=Lc_max, pLmax_n=Lc_norm_max;
	 for(j=0;j<npc;j++,punpmC++){
		uint l;
		u8int bk;
		float max;
		l=pC_a_pM[j];
		if(l==Я){pL+=3, pLnorm+=3; continue;}

		pfila->f1_punto=punpmC->nom;
		bk=punpmC->bbb;
		max=-1.0F;
		if(bk&1){
			float aux=*pL;
			write_residuo(&buf,aux,pfila->f2_resx);
			max=fabsf(aux);
		}else strcpy8(pfila->f2_resx,cadenas_comunes[8]);
		pL++;
		if(bk&2){
			float aux=*pL;
			write_residuo(&buf,aux,pfila->f3_resy);
			if(fabsf(aux)>max) max=fabsf(aux);
		}else  strcpy8(pfila->f3_resy,cadenas_comunes[8]);
		pL++;
		if(bk&4){
			float aux=*pL;
			write_residuo(&buf,aux,pfila->f4_resz);
			if(fabsf(aux)>max) max=fabsf(aux);
		}else  strcpy8(pfila->f4_resz,cadenas_comunes[8]);
		pL++;
		*pLmax++=max;

		max=0;
		{float aux=fabsf(*pLnorm++);	pfila->f5_res_norm_x=aux;	max=aux;}
		{float aux=fabsf(*pLnorm++);	pfila->f6_res_norm_y=aux;	if(aux>max) max=aux;}
		{float aux=fabsf(*pLnorm++);	pfila->f7_res_norm_z=aux;	if(aux>max) max=aux;}
		*pLmax_n++=max;

		pfila->v_orden_def=k++;
		pfila++;
	 }
	 npcb=k-npyb-1;
	}else{
		npcb=0;
	}

	tabla->nfilas=npyb;
	if(npyb){
		ordenar_float(L_max,orden_L,npyb);
		ordenar_float(L_norm_max,orden_L_norm,npyb);
	}
	if(npcb){
		tabla->nfilas+=npcb+1;
		ordenar_float(Lc_max,orden_Lc,npcb);
		ordenar_float(Lc_norm_max,orden_Lc_norm,npcb);
	}

	lll=0;
	fordown(i,npyb,){
		tabla->filas[orden_L[i]].v_orden_res=lll;
		tabla->filas[orden_L_norm[i]].v_orden_res_norm=lll++;
	}
	if(npcb){
		tabla->filas[npyb].v_orden_res=lll;
		tabla->filas[npyb].v_orden_res_norm=lll++;
		npyb++;
		fordown(i,npcb,){
			tabla->filas[npyb+orden_Lc[i]].v_orden_res=lll;
			tabla->filas[npyb+orden_Lc_norm[i]].v_orden_res_norm=lll++;
		}
	}

	toclose(&buf);
	free_plist(plist);
	return 0;

salida_outofmem:
	free_plist(plist);
	toclose(&buf);
	return AT_NOMEM;
}
int rellena_res_gpsins(BnfTabla_ResGPS* tabla, s8int decgps, s8int decins, const GrupoGPSINS* grupos, uint ngrupos, const uint* grupos_acum, const PuntoGPSINS* gpss, const float* Lgps, const float* Lgps_norm, const float* Lins, const float* Lins_norm, float fccpi){
	PLIST plist;
	uint i,ll;
	const float *pLins, *pLins_n;
	BnfFila_ResGPS *pfila;
	ATFormatter buf;
	const BnfFila_ResGPS filagrupo_base={NULL,S_S,{'\0'},{'\0'},{'\0'},{'\0'},{'\0'},{'\0'},0,0,0,0,0,0};

	tabla->filas=NULL;
	tabla->nfilas=0;
	plist=get_new_plist();
	{durchlaufei(const GrupoGPSINS,grupos,ngrupos){
		if(!grupos->bg && !grupos->bi) continue;
		tabla->nfilas+=ptri->n+1;
	}}
	checked_malloc_n(tabla->filas,BnfFila_ResGPS,tabla->nfilas, return AT_NOMEM);
	ifunlike(SetupFormatter(&buf)!=0){free_null(tabla->filas); tabla->nfilas=0; return AT_NOMEM;}
	setbuf_scientific(&buf);
	setbuf_nolimpio(&buf);
	if(decins==-127){
		if(fccpi>50) decins=-4;
		elif(fccpi>5) decins=-5;
		else decins=-6;
	}

	setbuf_scientific(&buf);
	setbuf_nolimpio(&buf);

	pLins=Lins;
	pLins_n=Lins_norm;
	ll=0;
	pfila=tabla->filas;
	for(i=0;i<ngrupos;i++,grupos++){
		uint l;
		bint bi;
		l=ll;
		bi=grupos->bi;
		ll=grupos_acum[i];	//Coming from Aerotri l==ll is impossible
		if(l==ll || (!grupos->bg && !grupos->bi)){gpss+=ll-l; continue;}

		*pfila=filagrupo_base;
		pfila->f1_grupo=gpss->nom;	//nombre del primer cc.pp.
		pfila++;

		const float *pLgps=Lgps+3*l,
					   *pLgps_n=Lgps_norm+3*l;
		dontimes(ll-l,(gpss++, pfila++)){
			pfila->f1_grupo=S_S;
			pfila->f2_centroproy=gpss->nom;
			if(!gpss->bg){
				strcpy8(pfila->f3_resx,cadenas_comunes[8]);
				strcpy8(pfila->f4_resy,cadenas_comunes[8]);
				strcpy8(pfila->f5_resz,cadenas_comunes[8]);
				pfila->f9_res_norm_x=0;
				pfila->f10_res_norm_y=0;
				pfila->f11_res_norm_z=0;
				pLgps+=3, pLgps_n+=3;
			}else{
				if(decgps<=0){buf.prec.absol=-decgps; setbuf_absolute(&buf);}
				else{buf.prec.signi=(u8int)decgps; setbuf_relative(&buf);}
				write_residuo(&buf,*pLgps++,pfila->f3_resx);
				write_residuo(&buf,*pLgps++,pfila->f4_resy);
				write_residuo(&buf,*pLgps++,pfila->f5_resz);

				pfila->f9_res_norm_x=fabsf(*pLgps_n++);
				pfila->f10_res_norm_y=fabsf(*pLgps_n++);
				pfila->f11_res_norm_z=fabsf(*pLgps_n++);
			}
			if(!gpss->bi){
				strcpy8(pfila->f6_resw,cadenas_comunes[8]);
				strcpy8(pfila->f7_resfi,cadenas_comunes[8]);
				strcpy8(pfila->f8_resk,cadenas_comunes[8]);
				pfila->f12_res_norm_w=0;
				pfila->f13_res_norm_fi=0;
				pfila->f14_res_norm_k=0;
				if(bi) pLins+=3, pLins_n+=3;
			}else{
				if(decins<=0){buf.prec.absol=-decins; setbuf_absolute(&buf);}
				else{buf.prec.signi=(u8int)decins; setbuf_relative(&buf);}
				write_residuo(&buf,*pLins++*fccpi,pfila->f6_resw);
				write_residuo(&buf,*pLins++*fccpi,pfila->f7_resfi);
				write_residuo(&buf,*pLins++*fccpi,pfila->f8_resk);

				pfila->f12_res_norm_w=fabsf(*pLins_n++);
				pfila->f13_res_norm_fi=fabsf(*pLins_n++);
				pfila->f14_res_norm_k=fabsf(*pLins_n++);
			}
		}
	}
	tabla->nfilas=(pdif)(pfila-tabla->filas);

	toclose(&buf);
	free_plist(plist);
	return 0;
}
#undef S_S

void free_filas(void* filas){
	freeif(filas); filas=NULL;
}
