﻿bint find_invalid_char(const char16_t* nombre){
	char16_t c;
	whilenz(c=*nombre){ nombre++;
		const char16_t *ps=STR16_invalidpathchars;
		while(*ps && *ps!=c) ps++;
		if(*ps) return 1;
	}
	return 0;
}
#define ANAPREC_NOVAL 1
#define ANAPREC_BADCHARS 2
#define ANAPREC_ZERO 3
#define ANPREC_NEG 4
int analiza_precision(float f){
	if(!isfinite(f)) return ANAPREC_NOVAL;	//El texto estaba en blanco. Valor vacío
	elifunlike(f==ATCRT_BAD_FVALUE) return ANAPREC_BADCHARS; //Valor con cacaterres erróneos
	elifunlike(f==0) return ANAPREC_ZERO;
	elifunlike(f<0) return ANPREC_NEG;
	return 0;
}

int analiza_ficherof(const TrabajoAerotri *trabajo, u8int *mar){
	if(trabajo->ficheros.fotos==NULL) return 1;
	if(find_invalid_char(trabajo->ficheros.fotos)) return 2;
	if(trabajo->tiposf.tfot!=0){ //FOTOSFORMAT_Aerotri
		const char16_t *s;
		path_get_extension16(trabajo->ficheros.fotos,s); if(!strcmp16(s,u".ftm")) return 3;
	}
	if(trabajo->tiposf.tfot>=2 && trabajo->ficheros.camara==NULL) return 4;
	*mar=trabajo->tiposf.tfot;
	return 0;
}

int analiza_ficheroint(const TrabajoAerotri *trabajo, u8int *inm){
	if(trabajo->ficheros.camara!=NULL){
		if(find_invalid_char(trabajo->ficheros.camara)) return 1;
		*inm=trabajo->tiposf.tint;
	}
	return 0;
}

int analiza_ficheroapr(const TrabajoAerotri *trabajo, u8int *prm){
	if(trabajo->ficheros.aproximadas!=NULL){
		if(find_invalid_char(trabajo->ficheros.aproximadas)) return 1;
		*prm=trabajo->tiposf.tapr;
	}
	return 0;
}

int analiza_ficheroapy(const TrabajoAerotri *trabajo, u8int *pym){
	if(trabajo->ficheros.apoyo!=NULL){
		if(find_invalid_char(trabajo->ficheros.apoyo)) return 1;
		*pym=trabajo->tiposf.tapy;
	}
	return 0;
}

int analiza_ficherogps(const TrabajoAerotri *trabajo, u8int *gpm){
	if(trabajo->ficheros.gpsins!=NULL){
		if(find_invalid_char(trabajo->ficheros.gpsins)) return 1;
		*gpm=trabajo->tiposf.tgps;
	}
	return 0;
}

int prepara_trabajo_relativa(const TrabajoAerotri *trabajo, struct strRelativaParams *params){
	int nret;

	if(trabajo->configsalida.ficheros.log && trabajo->salidatrabajo.log_ajuste!=0) params->log_level=1;
	else params->log_level=0;
	params->modo_toma=trabajo->modos.modo_toma;
	params->modo_medida=trabajo->modos.modo_medida;

	params->fichero=trabajo->ficheros.fotos;
		nret=analiza_ficherof(trabajo,&params->mar);
		if(nret) return nret-1 +ATPreparaRel_ficherof_null;
	params->ficheroint=trabajo->ficheros.camara;
		nret=analiza_ficheroint(trabajo,&params->inm);
		if(nret) return nret-1 +ATPreparaRel_ficheroint_invalidchar;
	params->ficherogps=trabajo->ficheros.gpsins;
		nret=analiza_ficherogps(trabajo,&params->gpm);
		if(nret) return nret-1 +ATPreparaRel_ficherogps_invalidchar;
	params->signoins=trabajo->datosgps.signoins;

	nret=analiza_precision(trabajo->apriori.im);
		if(nret!=0 && nret!=ANAPREC_NOVAL) return nret-1 +ATPreparaRel_precf_null;
	params->vmin=trabajo->apriori.im;

	if(trabajo->datosgps.tdgps==255) params->tdgps=1;
	else params->tdgps=trabajo->datosgps.tdgps;
	if(trabajo->datosgps.tdins==255) params->tdins=1;
	else params->tdins=trabajo->datosgps.tdins;

	if(trabajo->sistema.nsistema==10){
		if(trabajo->sistema.valoressistemas.LatLong!=0) params->bgeograficas=2;
		else params->bgeograficas=1;
	}else{
		params->bgeograficas=0;
	}
	params->param=trabajo->valoresaproximados;
	params->uni=trabajo->opciones.unigiros;

	return 0;
}

void setup_sistema(SistemaDefinicion *sis, const Trabajo_Sistema *sistr);
int prepara_trabajo_absoluta(const TrabajoAerotri *trabajo, struct strAbsolutaCallData *params, bint allow_empty){
	int nret;

	params->P.log_level=trabajo->salidatrabajo.log_level;
	params->P.modo_ajuste=trabajo->modos.modo_ajuste;
	params->P.modo_toma=trabajo->modos.modo_toma;
	params->P.modo_medida=trabajo->modos.modo_medida;

	params->P.ficherof=trabajo->ficheros.fotos;
		nret=analiza_ficherof(trabajo,&params->P.mar);
		if(nret) return nret-1 +ATPreparaAbs_ficherof_null;
	params->P.ficheroint=trabajo->ficheros.camara;
		nret=analiza_ficheroint(trabajo,&params->P.inm);
		if(nret) return nret-1 +ATPreparaAbs_ficheroint_invalidchar;
	if(trabajo->ficheros.aproximadas==NULL) return ATPreparaAbs_ficheroapr_null;
	params->P.ficheroapr=trabajo->ficheros.aproximadas;
		nret=analiza_ficheroapr(trabajo,&params->P.prm);
		if(nret) return nret-1 +ATPreparaAbs_ficheroapr_invalidchar;
	params->P.ficheroapy=trabajo->ficheros.apoyo;
		nret=analiza_ficheroapy(trabajo,&params->P.pym);
		if(nret) return nret-1 +ATPreparaAbs_ficheroapy_invalidchar;
	params->P.ficherogps=trabajo->ficheros.gpsins;
		nret=analiza_ficherogps(trabajo,&params->P.gpm);
		if(nret) return nret-1 +ATPreparaAbs_ficherogps_invalidchar;

	params->P.tdapr=trabajo->tiposf.tdapr;
	params->P.signoins=trabajo->datosgps.signoins;
	if(trabajo->datosgps.tdgps==ATTrabajo_TDGPS_Offset){params->P.tdgps=0; params->P.boffgps=1;}
	else{params->P.tdgps=trabajo->datosgps.tdgps; params->P.boffgps=0;}
	if(trabajo->datosgps.tdins==ATTrabajo_TDGPS_Offset){params->P.tdins=0; params->P.boffins=1;}
	else{params->P.tdins=trabajo->datosgps.tdins; params->P.boffins=0;}
	params->P.bgirok=trabajo->opciones.bgirok;
	params->P.flags_generate=trabajo->ficheros.generar;

	nret=analiza_precision(trabajo->apriori.im);
		if(nret!=0){
			if(nret!=ANAPREC_NOVAL || !allow_empty) return nret-1 +ATPreparaAbs_precf_null;
		}
	if(trabajo->ficheros.apoyo!=NULL){
		nret=analiza_precision(trabajo->apriori.pXY);
		if(nret){
			if(nret!=ANAPREC_NOVAL || !allow_empty) return nret-1 +ATPreparaAbs_precpXY_null;
		}
		nret=analiza_precision(trabajo->apriori.pZ);
		if(nret){
			if(nret!=ANAPREC_NOVAL || !allow_empty) return nret-1 +ATPreparaAbs_precpZ_null;
		}
	}
	if(trabajo->ficheros.gpsins!=NULL){
		nret=analiza_precision(trabajo->apriori.gpsXY);
		if(nret){
			if(nret!=ANAPREC_NOVAL || !allow_empty) return nret-1 +ATPreparaAbs_precgpsXY_null;
		}
		nret=analiza_precision(trabajo->apriori.gpsZ);
		if(nret){
			if(nret!=ANAPREC_NOVAL || !allow_empty) return nret-1 +ATPreparaAbs_precgpsZ_null;
		}
		if(trabajo->tiposf.tgps>=3 || isfinite(trabajo->apriori.insΩΦ)){	//Si no se indicó valor de precisión para el INS y el formato del fichero
			nret=analiza_precision(trabajo->apriori.insΩΦ);			//permite que no haya datos INS no obligamos a que se indique el valor de precisión.
			if(nret){																	//Si después realmente hay, el programa tomará un valor por defecto que puede no estar bien.
				if(nret!=ANAPREC_NOVAL || !allow_empty) return nret-1 +ATPreparaAbs_precinsWF_null;
			}
			nret=analiza_precision(trabajo->apriori.insK);
			if(nret){
				if(nret!=ANAPREC_NOVAL || !allow_empty) return nret-1 +ATPreparaAbs_precinsK_null;
			}
		}
	}
	params->P.apriori=trabajo->apriori;
	if(!isfinite(params->P.apriori.insΩΦ)) params->P.apriori.insK=params->P.apriori.insΩΦ=0;

	params->P.conjuntas=trabajo->conjuntas;
	if(trabajo->opciones.estimador==0){
		params->P.estimador.tipo_usuario=0;
		params->P.estimador.estimadores[0]._f_dens=0;
		params->P.estimador.estimadores[0]._peso1=0;
	}else switch(trabajo->opciones.estimador){
	default:
		params->P.estimador.tipo_usuario=3;
		params->P.estimador.estimadores[0]._f_dens=1;
		params->P.estimador.estimadores[0]._peso1=4;
		params->P.estimador.estimadores[0].divide_r=1;
	}
	params->P.estimador.estimadores[0].def_tau=-1;

	params->P.estimador.estimadores[1]=params->P.estimador.estimadores[0];
	params->P.estimador.estimadores[2]=params->P.estimador.estimadores[0];
	params->P.estimador.estimadores[3]=params->P.estimador.estimadores[0];

	params->P.profundidades.elim.ff=255;	//Dejar que lo escoja la función
	params->P.profundidades.elim.f3=255;
	params->P.profundidades.elim.u33=255;
	params->P.profundidades.inverso=params->P.profundidades.directo=params->P.profundidades.elim;

	params->P.auto_calib=trabajo->autocalib.existe;
	params->auxiliar.configcalib.f=trabajo->autocalib.selected.f;
	params->auxiliar.configcalib.x=trabajo->autocalib.selected.pp;
	params->auxiliar.configcalib.y=params->auxiliar.configcalib.x;
	params->auxiliar.configcalib.config_dist=trabajo->autocalib.config_dist;
	{bint b=trabajo->autocalib.selected.distorsion;
	if(!b) params->auxiliar.configcalib.config_dist.modelo_poli=0;
	if(!b || !trabajo->autocalib.selected.componentes.radsim) params->auxiliar.configcalib.config_dist.param_radsim=0;
	if(!b || !trabajo->autocalib.selected.componentes.tansim) params->auxiliar.configcalib.config_dist.param_tansim=0;
	if(!b || !trabajo->autocalib.selected.componentes.asimetricas){
		params->auxiliar.configcalib.config_dist.modelo_asim=0;
		params->auxiliar.configcalib.config_dist.param_asim1=0;
		params->auxiliar.configcalib.config_dist.param_asim2=0;
	}}
	params->P.pInterna=&params->auxiliar.configcalib;
	params->P.flags0=0;
	if(trabajo->opciones.fijas) params->P.flags0|=1;
	if(trabajo->opciones.completo) params->P.flags0|=2;
	if(trabajo->opciones.reescribe_cpp) params->P.flags0|=4;
	//if(0) params->P.flags0|=8;	//permitir semilibre
	setup_sistema(&params->auxiliar.sis.sis,&trabajo->sistema);
	params->auxiliar.sis.infor.datum_and_projection_name=NULL;
	NOTFINITE_f(params->auxiliar.sis.infor.linear_units);
	params->auxiliar.sis.infor.linear_units_abr=NULL;
	if(trabajo->sistema.elipsoide==0) params->auxiliar.sis.infor.elip=sEsfera;
	elif(trabajo->sistema.elipsoide>=2 && trabajo->sistema.elipsoide<7) params->auxiliar.sis.infor.elip=ElipsoidesValores[trabajo->sistema.elipsoide-2].nombre;
	else params->auxiliar.sis.infor.elip=NULL;
	params->P.sis=&params->auxiliar.sis;
	params->P.uni=trabajo->opciones.unigiros;

	params->P.Salida=trabajo->configsalida;
	if(params->P.Salida.fich_Digi.rutarel==NULL) params->P.Salida.fich_Digi.rutarel=rutas_fijas[0];
	if(params->P.Salida.fich_Digi.rutaf==NULL) params->P.Salida.fich_Digi.rutaf=rutas_fijas[0];
	if(params->P.Salida.fich_Imaster.rutarel==NULL) params->P.Salida.fich_Imaster.rutarel=rutas_fijas[0];
	if(params->P.Salida.fich_Imaster.rutaf==NULL) params->P.Salida.fich_Imaster.rutaf=rutas_fijas[0];

	params->P.pfnumero=NULL;
	memcpy_float(params->auxiliar.limites,trabajo->opciones.residuos_escala,20);
	params->P.flimites=&params->auxiliar.limites[0];
	params->P.fill_gps=trabajo->opciones.interp_gps;
	params->P.interp_resgps=trabajo->opciones.interp_resgps;

	return 0;
}

void setup_sistema(SistemaDefinicion *sis, const Trabajo_Sistema *sistr){
	sis->proy=(umint)sistr->nsistema;
	if(sistr->nsistema==SIS_Rectangular) return;

	sis->ond=sistr->ondulacion;
	sis->Λ0=0;
	if(sistr->nsistema==SIS_Conforme){
		sis->a=sistr->tierra.N;
		sis->e=sistr->tierra.rho;
		sis->param1.conv0=sistr->tierra.conv;
		sis->k0=sistr->tierra.k;
		return;
	}
	switch(sistr->nsistema){
		case SIS_Mercator: sis->param1.φ0=0; goto Lambert;
		case SIS_Estereográfica: sis->param1.φ0=90; goto Lambert;
		case SIS_Lambert:
			sis->param1.φ0=sistr->valoressistemas.Phi0Lambert;
		Lambert:
			sis->k0=sistr->valoressistemas.kLambert;
			sis->xO=sistr->valoressistemas.XLambert;
			sis->yS=sistr->valoressistemas.YLambert;
			break;
		case SIS_Mercator_Transversa:
			sis->k0=sistr->valoressistemas.kUTM;
			sis->xO=sistr->valoressistemas.XUTM;
			sis->yS=sistr->valoressistemas.YUTM;
			break;
		case SIS_Geograficas:
			sis->param1.orden_λφ=sistr->valoressistemas.LatLong; break;
	}

	if(sistr->elipsoide==0){	//Esfera
		sis->a=(sistr->tierra.N+sistr->tierra.rho)*0.5;
		sis->e=0;
	}else if(sistr->elipsoide==1){	//otro
		sis->a=sistr->elipsoideotro.a;
		sis->e=sistr->elipsoideotro.ee;
	}else{
		u8int n;
		const double (*p)[2];
		n=sistr->elipsoide-2; if(n>=N_ElipsoideValores) n=1;
		p=&ElipsoidesValores[n].ae;
		sis->a=(double)(*p)[0]; sis->e=(double)(*p)[1];
	}
}

void change_absparams(struct strAbsolutaCallData *params,uint kind,uintptr_t valor){
	switch(kind){
		case APARAMS_flags0_Semilibre:
			if(valor!=0) params->P.flags0 |=8;
			else params->P.flags0 &=~8U;
	}
}
