﻿#pragma once
#if COMPILER_ID==MSC_ID
	#pragma warning(disable: 4305)	//double constants converted to float
#elif COMPILER_ID==CLANG_ID
	#pragma clang diagnostic ignored "-Wconversion"
#endif

//Revisar (char8_t)(i+'1') si SIM_N pasa de 9
#define SIM_N 5U		//número de componentes simétricas programadas = nº de polinomios p.
#define POLIPQ_N 9U	//número de polinomios p+q programados
#define ASIM_N 12U	//number of programmed components for the asym.
//Cantidades para un fotograma con proporción raiz(3)/1 para los impares y 4/3 para los completos, pero prácticamente no varía
static const float Cantidad_p[2][7]={	//Polinomios que empiezan en r
	{0, 0.58, 0.26, 0.14, 0.093, 0.069, 0.055},	//i
	{0, 0.58, 0.28, 0.17, 0.13, 0.096, 0.077}	//c
};
/*const float Cantidad_q[2][6]={	//Polinomios que empiezan en r^2
	{0,	0.41, 0.20, 0.11, 0.080, 0.061}, //i
	{0,	0.40, 0.22, 0.14, 0.10, 0.082}	//c
};*/
static const float Cantidad_pq[2][12]={	//p y q intercalados
	{0, 0.58, 0.41, 0.26, 0.20, 0.14, 0.11, 0.093, 0.080, 0.069, 0.061, 0.055}, //i
	{0, 0.58, 0.40, 0.28, 0.22, 0.17, 0.14, 0.13, 0.10, 0.096, 0.082, 0.077}	//c
};
static const u8int poli_asim[13]={//Polinomio correspondiente al término i de una base asimétrica
	0, 2,2,4,4,1,1,6,6,3,3,2,2		//Si es impar es un p, si par es un q
};
static const s8int S_asim[13]={//valor de k de cos(kθ) o sin(kθ). Positivo si es coseno, negativo si seno
	0,		//Para el modelo de los vectores, (1-k)t en la serie1, (1+k)t en la serie 2. Positivo si x=cos,y=sin; negativo si x=-sin,y=cos.
	1,-1,1,-1,2,-2,1,-1,2,-2,3,-3	//sin embargo, para i=1,2, los parámetros han de ser necesariamente los del modelo rad/tan
};

//unreferenced formal parameter
#if COMPILER_ID==MSC_ID
#define unref_parameter 4100
#elif COMPILER_ID==GCC_ID || COMPILER_ID==CLANG_ID
#define unref_parameter "-Wunused-parameter"
#else
#define unref_parameter
#endif

Pragma_Warnings_pushignore(unref_parameter)
float rsin3θ(float x, float y, float _r2){return y*(3*x*x-y*y)*_r2;}//r sin3θ
float sin2θ(float x, float y, float _r2){return 2*x*y*_r2;}//sin 2θ
float rsinθ(float x, float y, float _r2){return y;}//r sinθ
//NULL;
float rcosθ(float x, float y, float _r2){return x;}//r cosθ
float cos2θ(float x, float y, float _r2){return (x*x-y*y)*_r2;}//cos2θ
float rcos3θ(float x, float y, float _r2){return x*(x*x-3*y*y)*_r2;}//cos3θ
Pragma_Warnings_pop

static float (*const Skθ_base[])(float x, float y, float _r2)={
	&rsin3θ, &sin2θ, &rsinθ,
	NULL,
	&rcosθ, &cos2θ, &rcos3θ
};
static float (*const * Skθ)(float x, float y, float _r2)=&Skθ_base[3];

static const u8int NN_1[]={0, 1, 3, 6, 10, 15};
static const u8int Npq_i[POLIPQ_N]={0,1,2,4,6,9,12,16,20};
//Los términos se ordenan de mayor a menor grado
static const float coef_p_ic[]={
	1,
	2, -1,
	4.8, -4.7, 0.9,
	12.8, -19.1, 8.2, -0.9,
	38.4, -76.2, 50.5, -12.6, 0.9,
};
static const float coef_p_cc[]={
	1,
	3, -2,
	9, -11.4, 3.4,
	29.2, -53.1, 30.1, -5.2,
	95.8, -225.4, 187.1, -63.9, 7.4,
	320.3, -922.1, 1004.9, -511.4, 119.2, -9.9,
};
static const float coef_p_ic_fwd[]={
	1,
	-1, 2,
	0.9, -4.7, 4.8,
	-0.9, 8.2, -19.1, 12.8,
	0.9, -12.6, 50.5, -76.2, 38.4,
};
static const float coef_p_cc_fwd[]={
	1,
	-2, 3,
	3.4, -11.4, 9,
	-5.2, 30.1, -53.1, 29.2,
	7.4, -63.9, 187.1, -225.4, 95.8,
	-9.9, 119.2, -511.4, 1004.9, -922.1, 320.3,
};
static const float coef_polis_ic[]={	//Polinomios p y q intercalados
	1,		//p1
	1,		//q1
	2, -1,
	2.5, -1.5, //q2
	4.8, -4.7, 0.9,
	6.4, -7.2, 1.8, //q3
	12.8, -19.1, 8.2, -0.9,
	19.1, -31.6, 15.7, -2.2, //q4
	38.4, -76.2, 50.5, -12.6, 0.9,
};
static const float coef_polis_cc[]={
	1,		//p1
	1,		//q1
	3, -2,
	4, -3,	//q2
	9, -11.4, 3.4,
	14.5, -20.3, 6.8, //q3
	29.2, -53.1, 30.1, -5.2,
	53.5, -107.8, 69.5, -14.2, //q4
	95.8, -225.4, 187.1, -63.9, 7.4,
};
#if COMPILER_ID==MSC_ID
	#pragma warning(default: 4305)
#elif COMPILER_ID==CLANG_ID
	#pragma clang diagnostic warning "-Wconversion"
#endif

static const char8_t* const polinomios_p[][2]={
	{NULL,NULL},
	{"s","s"},
	{"(2s^3 -s)","(3s^2 -2s)"},
	{"(4.8s^5 -4.7s^3 +0.9s)","(9s^3 -11.4s^2 +3.4s)"},
	{"(12.8s^7 -19.1s^5 +8.2s^3 -0.9s)","(29.2s^4 -53.1s^3 +30.1s^2 -5.2s)"},
	{"(38.4s^9 -76.2s^7 +50.5s^5 -12.6s^3 +0.9s)","(95.8s^5 -225.4s^4 +187.1s^3 -63.9s^2 +7.4s)"},
	{"(119.5s^11 -296.7s^9 +268s^7 -106.5s^5 +17.6s^3 -0.9s)","(320.3s^6 -922.1s^5 +1004.9s^4 -511.4s^3 +119.2s^2 -9.9s)"}
};
static const char8_t* const polinomios_pq[][2]={
	{NULL,NULL},
	{"s","s"},
	{"s^2","s^2"},
	{"(2s^3 -s)","(3s^2 -2s)"},
	{"(2.5s^4 -1.5s^2)","(4s^3 -3s^2)"},
	{"(4.8s^5 -4.7s^3 +0.9s)","(9s^3 -11.4s^2 +3.4s)"},
	{"(6.4s^6 -7.2s^4 +1.8s^2)","(14.5s^4 -20.3s^3 +6.8s^2)"},
	{"(12.8s^7 -19.1s^5 +8.2s^3 -0.9s)","(29.2s^4 -53.1s^3 +30.1s^2 -5.2s)"},
	{"(19.1s^8 -31.6s^6 +15.7s^4 -2.2s^2)","(53.5s^5 -107.8s^4 +69.5s^3 -14.2s^2)"},
	{"(38.4s^9 -76.2s^7 +50.5s^5 -12.6s^3 +0.9s)","(95.8s^5 -225.4s^4 +187.1s^3 -63.9s^2 +7.4s)"},
};

typedef struct{
	float (*poli_p_r)(u8int i, float r2);
	Puntoxy_float (*asim1)(u8int modelo_poli, u8int i, float x, float y, float r2);
	Puntoxy_float (*asim2)(u8int modelo_poli, u8int i, float x, float y, float r2);
} Componentes_distorsion;

float poli_p_impar_entre_r(u8int i, float r2){
	float poli;
	const float *coef;

	if(i>SIM_N) return 0;
	coef=coef_p_ic+NN_1[--i];
	poli=*coef++;
	while(i){i--; poli*=r2; poli+=*coef++;}
	return poli;
}
float poli_p_completo_entre_r(u8int i, float r2){
	float poli;
	const float *coef;

	if(i>SIM_N) return 0;
	r2=sqrtf(r2);
	coef=coef_p_cc+NN_1[--i];
	poli=*coef++;
	while(i){i--; poli*=r2; poli+=*coef++;}
	return poli;
}
#if COMPILER_ID==MSC_ID
	#pragma auto_inline(off)
#endif
float poli_impar_r(u8int i, float r2){	// p/r ó q/r^2
	float poli;
	const float *coef;

	if(i>POLIPQ_N) return 0;
	coef=coef_polis_ic+Npq_i[--i];
	i>>=1;
	poli=*coef++;
	while(i){i--; poli*=r2; poli+=*coef++;}
	return poli;
}
float poli_completo_r(u8int i, float r2){	// p/r ó q/r^2
	float poli;
	const float *coef;

	if(i>POLIPQ_N) return 0;
	r2=sqrtf(r2);
	coef=coef_polis_cc+Npq_i[--i];
	i>>=1;
	poli=*coef++;
	while(i){i--; poli*=r2; poli+=*coef++;}
	return poli;
}
#if COMPILER_ID==MSC_ID
	#pragma auto_inline(on)
#endif
sinline float polinomio_r(u8int modelo, u8int i, float r2){
	if(modelo==CAL_MODPOL_IMPAR) return poli_impar_r(i,r2);
	elif(modelo==CAL_MODPOL_COMPLETO) return poli_completo_r(i,r2);
	else return 0;
}

#if COMPILER_ID==MSC_ID
	#pragma auto_inline(off)
#endif
float Simetrica_r(u8int modelo, u16int parametros,float* Xradsim, float r2){
	const float *coef;
	float Dist;
	u8int i;
	u16int l;

	if(modelo==CAL_MODPOL_IMPAR){
		coef=coef_p_ic;
	}elif(modelo==CAL_MODPOL_COMPLETO){
		coef=coef_p_cc;
		r2=sqrtf(r2);
	}else{
		return 0;
	}

	Dist=0;
	for(i=1,l=1;i<=SIM_N;i++,l<<=1){
		float poli;
		if(!(parametros&l)){coef+=i; continue;}
		poli=*coef++;
		{dontimes(i-1,){poli*=r2; poli+=*coef++;}}
		Dist+=Xradsim[i-1]*poli;
	}
	return Dist;
}
#if COMPILER_ID==MSC_ID
	#pragma auto_inline(on)
#endif
sinline float RadTansim(u8int modelo, u16int parametros,float* Xradsim, float r){return r*Simetrica_r(modelo,parametros,Xradsim,r*r);}

float asim_radtan_entre_r(u8int modelo_poli, u8int i, float x, float y, float r2){
	float f;
	s8int k=S_asim[i];

	f=polinomio_r(modelo_poli,poli_asim[i],r2);	//entre_r2 si es par
	if(k==1) f*=x;
	elif(k==-1) f*=y;
	else f*=Skθ[k](x,y,1.0F/r2);
	return f;
}
sinline Puntoxy_float asim_radial(u8int modelo_poli, u8int i, float x, float y, float r2){
	Puntoxy_float p;
	p.x=asim_radtan_entre_r(modelo_poli,i,x,y,r2);
	p.y=p.x*y;
	p.x*=x;
	return p;
}
sinline Puntoxy_float asim_tangencial(u8int modelo_poli, u8int i, float x, float y, float r2){
	Puntoxy_float p;
	p.x=asim_radtan_entre_r(modelo_poli,i,x,y,r2);
	p.y=p.x*x;
	p.x*=-y;
	return p;
}

Puntoxy_float asim_uvmenos(u8int modelo_poli, u8int i, float x, float y, float r2){
	float f,rad,tan;
	s8int k=S_asim[i];
	Puntoxy_float p;
	p.x=p.y=0;
	if(i<3) return asim_radial(modelo_poli,i,x,y,r2);

	f=polinomio_r(modelo_poli,poli_asim[i],r2);
	r2=1.0F/r2;
	rad=f*Skθ[k](x,y,r2);
	tan=f*Skθ[-k](x,y,r2);
	if(k>=0) tan=-tan;
	p.x=rad*x-tan*y;
	p.y=rad*y+tan*x;
	return p;
}
Puntoxy_float asim_uvmas(u8int modelo_poli, u8int i, float x, float y, float r2){
	float f,rad,tan;
	s8int k=S_asim[i];
	Puntoxy_float p;
	p.x=p.y=0;
	if(i<3) return asim_tangencial(modelo_poli,i,x,y,r2);

	f=polinomio_r(modelo_poli,poli_asim[i],r2);
	r2=1.0F/r2;
	rad=f*Skθ[k](x,y,r2);
	tan=f*Skθ[-k](x,y,r2);
	if(k<0) rad=-rad;
	p.x=rad*x-tan*y;
	p.y=rad*y+tan*x;
	return p;
}
float Asim_radtan_entre_r(u8int modelo_poli, u16int parametros,float* Xserie1, float x, float y){
	u8int i;
	u16int l;
	float r2, Dist;

	r2=x*x+y*y;
	Dist=0;
	for(i=1,l=1;i<=ASIM_N;i++,l<<=1){
		if(!(parametros&l)) continue;
		Dist+=Xserie1[i-1]*asim_radtan_entre_r(modelo_poli,i,x,y,r2);
	}
	return Dist;
}
sinline Puntoxy_float Asim_radial(u8int modelo, u16int parametros,float* Xserie1, float x, float y){
	 Puntoxy_float p;
	 p.x=Asim_radtan_entre_r(modelo,parametros,Xserie1,x,y);
	 p.y=p.x*y;
	 p.x*=x;
	 return p;
}
sinline Puntoxy_float Asim_tangencial(u8int modelo, u16int parametros,float* Xserie2, float x, float y){
	 Puntoxy_float p;
	 p.x=Asim_radtan_entre_r(modelo,parametros,Xserie2,x,y);
	 p.y=p.x*x;
	 p.x*=-y;
	 return p;
}
Puntoxy_float Asim_uvmenos(u8int modelo_poli, u16int parametros,float* Xserie1, float x, float y){
	u8int i;
	u16int l;
	Puntoxy_float p;
	float r2;

	r2=x*x+y*y;
	p.x=p.y=0;
	if(parametros&3){
		float aux;
		aux=Xserie1[0]*asim_radtan_entre_r(modelo_poli,1,x,y,r2);
		aux+=Xserie1[1]*asim_radtan_entre_r(modelo_poli,2,x,y,r2);
		p.x=x*aux;
		p.y=y*aux;
	}
	for(i=3,l=4;i<=ASIM_N;i++,l<<=1){
		Puntoxy_float q;
		if(!(parametros&l)) continue;
		q=asim_uvmenos(modelo_poli,i,x,y,r2);
		p.x+=Xserie1[i-1]*q.x;
		p.y+=Xserie1[i-1]*q.y;
	}
	return p;
}
Puntoxy_float Asim_uvmas(u8int modelo_poli, u16int parametros,float* Xserie2, float x, float y){
	u8int i;
	u16int l;
	Puntoxy_float p;
	float r2;

	r2=x*x+y*y;
	p.x=p.y=0;
	if(parametros&3){
		float aux;
		aux=Xserie2[0]*asim_radtan_entre_r(modelo_poli,1,x,y,r2);
		aux+=Xserie2[1]*asim_radtan_entre_r(modelo_poli,2,x,y,r2);
		p.x=-y*aux;
		p.y=x*aux;
	}
	for(i=3,l=4;i<=ASIM_N;i++,l<<=1){
		Puntoxy_float q;
		if(!(parametros&l)) continue;
		q=asim_uvmas(modelo_poli,i,x,y,r2);
		p.x+=Xserie2[i-1]*q.x;
		p.y+=Xserie2[i-1]*q.y;
	}
	return p;
}

sinline Puntoxy_float Asim_serie1(u8int modelo, u8int modelo_poli, u16int parametros,float* Xserie1, float x, float y){
	switch(modelo){
	  case CAL_MODASIM_VECTOR: return Asim_uvmenos(modelo_poli,parametros,Xserie1,x,y);
	  default: return Asim_radial(modelo_poli,parametros,Xserie1,x,y); /*CAL_MODASIM_RADTAN*/
	}
}
sinline Puntoxy_float Asim_serie2(u8int modelo, u8int modelo_poli, u16int parametros,float* Xserie2, float x, float y){
	switch(modelo){
	  case CAL_MODASIM_VECTOR: return Asim_uvmas(modelo_poli,parametros,Xserie2,x,y);
	  default: return Asim_tangencial(modelo_poli,parametros,Xserie2,x,y); /*CAL_MODASIM_RADTAN*/
	}
}

float maxr(u8int modelo, u16int parametros, float* Xradsim, float* rM){
	float maxr,aux,r,d;
	float R;

	R=r=0; d=0.05F;
	maxr=0;
	dontimes(19,r+=0.05F){
		aux=RadTansim(modelo,parametros,Xradsim,r);
		if(aux>maxr){R=r;maxr=aux;}
	}
	r=1;	//Para asegurar que la última iteración se produce exactamente en r=1
	aux=RadTansim(modelo,parametros,Xradsim,r);
	if(aux>maxr){R=r;maxr=aux;}

	if(R==0 || R==1){*rM=R; return maxr;}
	dontimes(8,){
		d*=0.6F;
		r=R-d;
		aux=RadTansim(modelo,parametros,Xradsim,r);
		if(aux>maxr){R=r;maxr=aux;}
		else{
			r=R+d;
			aux=RadTansim(modelo,parametros,Xradsim,r);
			if(aux>maxr){R=r;maxr=aux;}
		}
	}
	*rM=R;
	return maxr;
}
float minr(u8int modelo, u16int parametros, float* Xradsim, float* rM){
	float minr,aux,r,d;
	float R;

	R=r=0; d=0.05F;
	minr=0;
	dontimes(19,r+=0.05F){
		aux=RadTansim(modelo,parametros,Xradsim,r);
		if(aux<minr){R=r;minr=aux;}
	}
	r=1;
	aux=RadTansim(modelo,parametros,Xradsim,r);
	if(aux<minr){R=r;minr=aux;}

	if(R==0 || R==1){*rM=R; return minr;}
	dontimes(8,){
		d*=0.6F;
		r=R-d;
		aux=RadTansim(modelo,parametros,Xradsim,r);
		if(aux<minr){R=r;minr=aux;}
		else{
			r=R+d;
			aux=RadTansim(modelo,parametros,Xradsim,r);
			if(aux<minr){R=r;minr=aux;}
		}
	}
	*rM=R;
	return minr;
}

void colapsa_serie_p(u8int modelo, const float a[], float k[]){
	float f;
	const float *ctes;

	k[0]=0; k[1]=0; k[2]=0; k[3]=0; k[4]=0;
	if(modelo==CAL_MODPOL_IMPAR) ctes=coef_p_ic_fwd;
	elif(modelo==CAL_MODPOL_COMPLETO) ctes=coef_p_cc_fwd;
	else return;

	k[0]=*a++**ctes++;
	f=*a++;	k[0]+=f**ctes++;		k[1]=f**ctes++;
	f=*a++;	k[0]+=f**ctes++;		k[1]+=f**ctes++;		k[2]=f**ctes++;
	f=*a++;	k[0]+=f**ctes++;		k[1]+=f**ctes++;		k[2]+=f**ctes++;		k[3]=f**ctes++;
	if((f=*a++)!=0){k[0]+=f**ctes++;	k[1]+=f**ctes++;	k[2]+=f**ctes++;	k[3]+=f**ctes++;	k[4]=f**ctes++;}
	else ctes+=5;
}

void elabora_poli_p(u8int modelo, float a[], const float k[]){
	float f;
	const float *ctes;

	if(modelo==CAL_MODPOL_IMPAR) ctes=coef_p_ic_fwd;
	elif(modelo==CAL_MODPOL_COMPLETO) ctes=coef_p_cc_fwd;
	else return;
	ctes+=NN_1[SIM_N]-1;
	memcpy_float(a,k,SIM_N);

	//a va guardando el coeficiente de r^i hasta que le toque su turno y entonces se convierte en el coeficiente del poli[i]
	if(a[4]!=0){f=a[4]/=*ctes--;		a[3]-=f**ctes--;	a[2]-=f**ctes--;	a[1]-=f**ctes--;	a[0]-=f**ctes--;}
	else ctes-=5;
	f=a[3]/=*ctes--;		a[2]-=f**ctes--;	a[1]-=f**ctes--;	a[0]-=f**ctes--;
	f=a[2]/=*ctes--;		a[1]-=f**ctes--;	a[0]-=f**ctes--;
	f=a[1]/=*ctes--;		a[0]-=f**ctes--;
	a[0]/=*ctes;
}
