#ifndef POLINOMIO3_INCLUDED
#ifndef TypeR
	#define polinomio3mn Addsufijo(polinomio3mn,suf)
	#define polinomio3 Addsufijo(polinomio3,suf)

	#define TypeR float
	#define suf fl
	#define TGMATH_TYPE TGMATH_TYPE_FLOAT
		#include <ATcrt/pmtgmath.h>
		#include __FILE__
	#undef TypeR
	#undef suf
	#undef TGMATH_TYPE

	#define TypeR double
	#define suf dbl
		#include <ATcrt/pmtgmath.h>
		#include __FILE__
	#undef TypeR
	#undef suf

	#undef polinomio3mn
	#undef polinomio3
	#define POLINOMIO3_INCLUDED
#else
//Si sólo hay una raíz real se almacena en r1, y la parte real de las otras dos raíces en r2 y r3.
//En algunos problemas, si la parte imaginaria es muy pequeña
//puede deberse a errores por la precisión de los números
void polinomio3mn(TypeR m,TypeR n, TypeR *r1,TypeR *r2,TypeR *r3){
	TypeR rad,cub1,cub2;
	TypeR s,p;
	if(m==0){	//Si las 3 raíces son reales m es positivo
		if(n>0){
			cub1=log(n)/(TypeR)3;
			cub1=exp(cub1);
		}else{
			cub1=log(-n)/(TypeR)3;
			cub1=-exp(cub1);
		}
		*r1=cub1;
		*r3=*r2=-cub1*(TypeR)0.5;
		return;
	}
	n/=2;	//Si n es positivo el elipsoide es alargado,
	m/=3;	//y si es negativo el elipsoide es achatado.
	rad=n*n-m*m*m;
	if(rad>0){	//Sólo si una única raíz es real
		rad=sqrt(rad);
		cub1=n+rad;
		if(cub1>0){
			cub1=log(cub1)/(TypeR)3;
			cub1=exp(cub1);
		}else{
			cub1=log(-cub1)/(TypeR)3;
			cub1=-exp(cub1);
		}
		cub2=n-rad;
		if(cub2>0){
			cub2=log(cub2)/(TypeR)3;
			cub2=exp(cub2);
		}else{
			cub2=log(-cub2)/(TypeR)3;
			cub2=-exp(cub2);
		}
		*r1=cub1+cub2;
		*r3=*r2=-*r1/(TypeR)2;
		return;
	}else{	//Si se llega aquí las tres raíces son reales
		rad=-rad;	//Único caso que se da en las varianzas
		TypeR mod;
		TypeR arg;
		mod=n*n+rad;
		mod=sqrt(mod);
		arg=atan2(sqrt(rad),n);
		mod=log(mod)/(TypeR)3;
		mod=exp(mod);
		arg/=3;
		*r1=mod*cos(arg)*2;	//Las tres raíces se obtienen
	}
	p=2*n/ *r1;
	s=-*r1;
	p=s*s-4*p;
	if(p<=0) p=0; else p=sqrt(p);
	*r2=(s+p)/2;			//ordenadas
	*r3=(s-p)/2;			//de mayor a menor
}
void polinomio3(TypeR a,TypeR b,TypeR c, TypeR *r1,TypeR *r2,TypeR *r3){
	if(b==0 && c==0){
		*r2=0;
		if(a<0){*r1=-a; *r3=0;}
		else{*r1=0; *r3=a;}
		return;
	}

	a/=3;
	TypeR aa=a*a;
	c-=a*b;
	c+=2*a*aa;
	b-=3*aa;

	polinomio3mn(-b,-c,r1,r2,r3);
	*r1-=a; *r2-=a; *r3-=a;
}
#endif
#endif
