﻿#include "modelogps.h"
#include <ATcrt/ATmem.h>
#include <ATcrt/ATmemstr.h>
#include <AT2D3D/AT2D3D.h>
#include <ATsistemas/ATsistemas.h>
#include <malloc.h>
#include "Aerotri_defs_internal.h"
#define NO_ZERO_CHECK
#include "secrr3_ap.h"
#include "trans_Hel3D.h"
#include "Resuelve_sistema.h"
#include "Modelo.h"

#define _inserth_puntom _inserth_puntom2
#define rehash_puntom rehash_puntom2
#define htype puntom
#define field nom
#define funchash_puntom funchash_uintbased	//Los números de punto suelen ser consecutivos
#define HASH_ALREADY_DECL
#include "hash_fielduint.cod"
#undef HASH_ALREADY_DECL
#define Addh_puntom(hash,nom,npunto,where) \
	{puntom _pm={nom,Я,npunto,where}; ifunlike(addh_puntom(hash,&_pm)==AT_NOMEM) goto salida_outofmem;}
#define inserth_puntom(hash,nom,npunto,where) \
	{puntom _pm={nom,Я,npunto,where}; _inserth_puntom(hash,&_pm);}

struct Per_group_data{
	PuntoXYZ_double Pref;
	double nsa,nsb,nsc,ts0,ts1,ts2, tsl;
	uint n;
};

int mod_gpsins(Modelo* mod1, u8int modo_medida, Sistema *sis, Fotograma* fotogramas, uint nf, GrupoGPSINS* grupos, PuntoGPSINS* gpss, uint ngrupos, uint ngps, uint* gps_a_f, Array_uint pfs,Array_int2 pm_en_f, uint npuntos, float vang_min){
	uint ncp,ntot;
	uint* f_a_cp;
	uint* cp_a_gps;
	PLIST plist=get_new_plist();

	SetupModelo(*mod1,nf*4,nf*4);
	aj_malloc_add(f_a_cp,uint,nf);
	aj_malloc_add(cp_a_gps,uint,ngps);
	vang_min*=vang_min;

	if(sis->sis.proy==SIS_Geograficas){
		sis->local.proy.y=sis->local.proy.x=0;
		uint naux=0;
		durchlaufei(PuntoGPSINS,gpss,ngps){
			 if(!ptri->bg) continue;
			 sis->local.proy.x+=ptri->P.X;
			 sis->local.proy.y+=ptri->P.Y;
			 naux++;
		 }
		 sis->local.proy.x/=naux;
		 sis->local.proy.y/=naux;
		 XYZlocal___proy_PM((PuntoXYZM_double*)&gpss->P,usizeof(PuntoGPSINS),ngps,sis);
	}

	ncp=0;
	oneset_uint(f_a_cp,nf);
	for(uint i=0,ll=0;i<ngrupos;i++){
		uint l=ll;
		ll+=grupos[i].n;
		if(!grupos[i].bg || !grupos[i].bi) continue;
		//Lo hago incodicionalmente para detectar +-180 en tipo0
		Puntoxy_double* comun12;
		{uint k=0;
		durchlaufej(uint,gps_a_f+l,ll-l){
			uint k2=(fotogramas+*ptrj)->puntos.n;
			if(k2>k) k=k2;
		}
		aj_malloc_n(comun12,Puntoxy_double,k<<1);
		}
		double c,s;
		Fotograma *fot1, *fot2;
		s=c=0;
		fot2=fotogramas+gps_a_f[l];
		for(uint j=l+1;j<ll;j++){
			fot1=fot2;
			fot2=fotogramas+gps_a_f[j];

			Puntof *punpf1, *punpf2;
			uint k1,k2;
			punpf1=fot1->puntos.ppio;
			punpf2=fot2->puntos.ppio;
			k1=fot1->puntos.n;
			k2=fot2->puntos.n;

			uint n=0;
			Puntoxy_double *ppunto=comun12;
			for(uint ib=0;ib<k1;ib++){
				uint nom=punpf1[ib].index;
				for(uint jb=0;jb<k2;jb++){
					if(punpf2[jb].index==nom){
						*ppunto++=fot1->puntos.ppio[ib].p;
						*ppunto++=fot2->puntos.ppio[jb].p;
						n++;
						break;
				}	}
			}
			if(n<2) continue;

			if(fot1->focal!=fot2->focal){
				double aux=fot2->focal/fot1->focal;
				Durchlaufei(Puntoxy_double,comun12+1,n){
					ptri->x*=aux; ptri->y*=aux;
					ptri+=2;
			}	}

			Hel2D_dbl trans;
			double cost1,sint1,cosb,sinb;
			double (*iM)[3];

			trans=Hel2D___p_dbl(comun12,n);
			{double p=1.0-1.0/n;
			PuntoXYZ_double P; P_op(P,=,gpss[j].P,-,gpss[j-1].P);
			cost1=p*(P.X*trans.Tx+P.Y*trans.Ty);		//Kappa1
			sint1=p*(P.X*trans.Ty-P.Y*trans.Tx);}
			iM=gpss[j-1].M;
			c+=iM[1][1]*cost1-iM[0][1]*sint1;		//guardo correcciones
			s+=iM[1][1]*sint1+iM[0][1]*cost1;
			//
			iM=gpss[j].M;
			cosb=iM[1][1]*cost1-iM[0][1]*sint1;
			sinb=iM[1][1]*sint1+iM[0][1]*cost1;
			c+=cosb*trans.cosg-sinb*trans.sing;
			s+=sinb*trans.cosg+cosb*trans.sing;
		}
		free(comun12);

		{double r=1/sqrt(c*c+s*s);
		c*=r; s*=r;}
		bint b3=true;
		/*if(grupos[i].tipoINS==0){*/	//La estimación de kappa es muy mala. Mejor quedarse con 0/180.
			if(c>0.5) b3=false;
			elif(c<-0.5){c=-1.0; s=0;}
			elif(s>0){c=0; s=1.0;}
			else{c=0; s=-1.0;}
		/*}*/
		//
		CentroProy CP;
		default_values_CP(CP);
		for(uint j=l;j<ll;j++){
			uint k=gps_a_f[j];
			CP.fot=fotogramas+k;
			CP.P=gpss[j].P;
			memcpy_double(&CP.M[0][0],&gpss[j].M[0][0],9);
			if(b3){
				double (*iM)[3]=gpss[j].M;
				CP.M[0][0]=c*iM[0][0]-s*iM[1][0];		CP.M[0][1]=c*iM[0][1]-s*iM[1][1];		CP.M[0][2]=c*iM[0][2]-s*iM[1][2];
				CP.M[1][0]=s*iM[0][0]+c*iM[1][0];		CP.M[1][1]=s*iM[0][1]+c*iM[1][1];		CP.M[1][2]=s*iM[0][1]+c*iM[1][2];
			}
			Vadd(mod1->centros,CentroProy,CP,goto salida_outofmem);
			f_a_cp[k]=ncp;
			cp_a_gps[ncp]=j;
			ncp++;
		}
	}

	ntot=pfs.ppios[nf];
	aj_decl_alloc_add(umint,p_encontrado,ntot);
	zeroset(p_encontrado,ntot);

	aj_decl_alloc_add(double,AtLx,ngrupos);
	aj_decl_alloc_add(double,AtLy,ngrupos);
	aj_decl_alloc_add(double,AtLz,ngrupos);
	aj_decl_alloc_add(double,N,(ngrupos*(ngrupos+1))>>1);
	zeroset_double(AtLx,ngrupos);
	zeroset_double(AtLy,ngrupos);
	zeroset_double(AtLz,ngrupos);
	zeroset_double(N,(ngrupos*(ngrupos+1))>>1);
	aj_decl_alloc_add(uint,grupos_found,ngrupos+1);
	aj_decl_alloc_add(struct Per_group_data,per_group,ngrupos);
	aj_decl_alloc_add(PuntoXYZ_double,punto_locales,ngrupos);
	aj_decl_alloc_add(double,sigma_locales,ngrupos);

	PuntoMrel PM;
	{int2 *ptri=pm_en_f.v;
	for(uint k=0;k<npuntos;k++){
		double nsa,nsb,nsc,ts0,ts1,ts2;
		uint n;
		Puntoff pfv;

		nsa=nsb=nsc=ts0=ts1=ts2=0;
		n=0;
		zeroset_uint(per_group,ngrupos*uintsizeof(struct Per_group_data));
		for(;ptri->n1!=Я;ptri++){
			uint n_cp;
			struct Per_group_data *pgrupo;
			CentroProy *puncp;
			PuntoXYZ_double a,b;
			Puntoxy_double paux;
			Fotograma *punf;
			double aux,auxb;

			n_cp=f_a_cp[ptri->n1];
			if(n_cp==Я) continue;
			pgrupo=per_group+gpss[cp_a_gps[n_cp]].grupo;
			puncp=mod1->centros.ppio+n_cp;
			punf=puncp->fot;
			a=puncp->P;
			if(pgrupo->n==0){
				pgrupo->Pref=a;
				a.Z=a.Y=a.X=0;
			}else{
				P_eq(a,-=,pgrupo->Pref);
			}
			paux=punf->puntos.ppio[ptri->n2].p;
			b.Z=-punf->focal;
			b.X=paux.x;
			b.Y=paux.y;
			AutoGiraPunto_inv_dbl(&b,puncp->M);

			pfv.f=ptri->n1;
			pfv.p=ptri->n2;
			n++;					pgrupo->n++;
			aux=b.X/b.Z;
			nsa+=aux*aux;		pgrupo->nsa+=aux*aux;
			nsb-=aux;			pgrupo->nsb-=aux;
			auxb=a.X-aux*a.Z;
			ts0-=aux*auxb;	pgrupo->ts0-=aux*auxb;
			ts1+=auxb;			pgrupo->ts1+=auxb;
									pgrupo->tsl+=auxb*auxb;
			aux=b.Y/b.Z;
			nsa+=aux*aux;		pgrupo->nsa+=aux*aux;
			nsc-=aux;			pgrupo->nsc-=aux;
			auxb=a.Y-aux*a.Z;
			ts0-=aux*auxb;	pgrupo->ts0-=aux*auxb;
			ts2+=auxb;			pgrupo->ts2+=auxb;
									pgrupo->tsl+=auxb*auxb;
		}
		ptri++;

		PM.vv=1.0F;
		if(n==1){
			Addh_puntom(&mod1->hpuntos,k,mod1->fpuntosf.n,at_fpuntosf);
			pfv.nom=k;
			Vadd(mod1->fpuntosf,Puntoff,pfv,goto salida_outofmem);
		}else{
			Addh_puntom(&mod1->hpuntos,k,mod1->puntos.n,at_puntos);
			PM.index=k;

			{uint *pfound=grupos_found;
			struct Per_group_data *ptr=per_group;
			for(uint k1=0;k1<ngrupos;k1++,ptr++)
				if(ptr->n>=2) *pfound++=k1;
			*pfound=Я;
			if(pfound==grupos_found) PM.vv=0;	//dejar marcados los que se calcularán en global
			}
			Vadd(mod1->puntos,PuntoMrel,PM,goto salida_outofmem);
			zeroset_uint(punto_locales,uintsizeof(*punto_locales)*ngrupos);
			zeroset_double(sigma_locales,ngrupos);

			uint *ptr=grupos_found;
			while(*ptr!=Я){
				uint k1=*ptr;
				uint posN=k1*ngrupos- ((k1*(k1-1))>>1);
				double den,nsa,nsb,nsc,ts0,ts1,ts2, nsd,nse,nsf;
				struct Per_group_data *per=per_group+k1;

				den=per->nsa*per->n*per->n -(per->nsb*per->nsb +per->nsc*per->nsc)*per->n;
				den=1.0/den;
				nsd=per->nsa*per->n-per->nsc*per->nsc;
				nse=per->nsb*per->nsc;
				nsf=per->nsa*per->n-per->nsb*per->nsb;
				nsa=per->n*per->n;
				nsb=-per->nsb*(double)per->n;
				nsc=-per->nsc*(double)per->n;
				ts0=per->ts0*den;
				ts1=per->ts1*den;
				ts2=per->ts2*den;

				PuntoXYZ_double P;
				double σ1;
				P.Z=nsa*ts0 +nsb*ts1 +nsc*ts2;
				P.X=nsb*ts0 +nsd*ts1 +nse*ts2;
				P.Y=nsc*ts0 +nse*ts1 +nsf*ts2;
				σ1=per->tsl-2*(per->ts0*P.Z+per->ts1*P.X+per->ts2*P.Y);
				σ1+=per->nsa*P.Z*P.Z+per->n*(P.X*P.X+P.Y*P.Y);
				σ1+=2*P.Z*(per->nsb*P.X+per->nsc*P.Y);
				{double aux=vang_min*P_mod(P);
				if(σ1<aux) σ1=aux;}
				σ1/=((double)per->n-1.99);	//casi eliminar puntos medidos solo en dos fotos
				P_eq(P,+=,per->Pref);
				punto_locales[k1]=P;
				sigma_locales[k1]=σ1;

				uint *ptrb=grupos_found;
				while(ptrb!=ptr){
					uint k2=*ptrb++;
					PuntoXYZ_double dif; P_op(dif,=,P,-,punto_locales[k2]);
					double peso=1.0/(σ1+sigma_locales[k2]);
					peso*=peso;	//eliminar puntos con diferencia grande
					{double aux=peso*dif.X;	AtLx[k1]+=aux;		AtLx[k2]-=aux;}
					{double aux=peso*dif.Y;	AtLy[k1]+=aux;		AtLy[k2]-=aux;}
					{double aux=peso*dif.Z;	AtLz[k1]+=aux;		AtLz[k2]-=aux;}

					uint posb=k2*ngrupos- ((k2*(k2-1))>>1);
					N[posN]+=peso;
					N[posb]+=peso;

					if(k1<k2) N[posN+(k2-k1)]-=peso;
					else N[posb+(k1-k2)]-=peso;
				}
				ptr++;
			}
		}
	}}

	aj_decl_alloc_add(bint,enlazado,ngrupos);
	aj_decl_alloc_add(bint,cabecera,ngrupos);
	aj_decl_alloc_add(bint,revisado,ngrupos);
	zeroset_bint(enlazado,ngrupos);
	zeroset_bint(cabecera,ngrupos);
	zeroset_bint(revisado,ngrupos);
	{double *pN=N;
	for(cint i=ngrupos;i;){
		if(*pN==0){
			*pN=1.0;
			uint j=ngrupos-i;
			enlazado[j]=1;
			cabecera[j]=1;
			revisado[j]=1;
		}
		pN+=i--;
	}}
	do{
		uint ng0;
		double *N0;
		bint *enlazado0;
		bint *revisado0;
		for(ng0=0;ng0<ngrupos;ng0++){if(!enlazado[ng0]) break;}
		if(ng0==ngrupos) break;
		enlazado[ng0]=1;
		cabecera[ng0]=1;
		if(ng0==ngrupos-1) break;
		enlazado0=enlazado+ng0;
		revisado0=revisado+ng0;
		N0=N+ng0*ngrupos-((ng0*(ng0-1))>>1);
		ng0=ngrupos-ng0;
		bint bk;
		do{
			bk=0;
			double *pN=N0;
			bint *pbint=enlazado0;
			bint *prev=revisado0;
			for(cint i=ng0;i--;pbint++,prev++){
				pN++;
				if(*prev){pN+=i; continue;}
				if(!*pbint){
					bint *pbj=pbint+1;
					double *pNb=pN;
					dontimes(i,(pNb++,pbj++)){
						if(*pNb!=0 && *pbj){*pbint=1; bk=1; break;}
					}
				}
				if(!*pbint){pN+=i; continue;}
				bint *pbj=pbint+1;
				dontimes(i,(pN++,pbj++)){
					if(*pN!=0 && *pbj==0){*pbj=1; bk=1;}
				}
				*prev=1;
			}
		}while(bk);
	}while(1);
	{bint *ptri=cabecera;
	double *pN=N;
	for(cint i=ngrupos;i;ptri++){
		if(*ptri){
			{uint j=ngrupos-i--;
			AtLx[j]=0;	AtLy[j]=0;	AtLz[j]=0;}
			*pN++=1.0;
			inner_loop0(i,*pN++=0);
		}else{
			pN+=i--;
		}
	}}
	Free_remove(revisado);
	Free_remove(cabecera);
	Free_remove(enlazado);

	invsim_1_t_double(N,ngrupos);
	inv_vector12_t_double(N,ngrupos,AtLx);
	inv_vector12_t_double(N,ngrupos,AtLy);
	inv_vector12_t_double(N,ngrupos,AtLz);
	Free_remove(N);

#if defined(_DEBUG) && 0
	{Bufferto8 fpas;
	toopen_mixed(u"despl_gps.txt",&fpas);
	fpas.prec.absol=3;
	for(uint i=0;i<ngrupos;i++){
		towrite8(&fpas,'s',"Grupo ", 'u',i+1, 's',": ",0);
		towrite8_aligned_float(&fpas,AtLx[i],10); toput_char(&fpas,' ');
		towrite8_aligned_float(&fpas,AtLy[i],10); toput_char(&fpas,' ');
		towrite8_aligned_float(&fpas,AtLz[i],10); toput_char(&fpas,'\n');
	}
	toclose(&fpas);
	}
#endif

	{durchVectori(CentroProy,mod1->centros){
		uint k=cp_a_gps[ptri-mod1->centros.ppio];
		k=gpss[k].grupo;
		ptri->P.X-=AtLx[k];
		ptri->P.Y-=AtLy[k];
		ptri->P.Z-=AtLz[k];
	}}

	zeroset(p_encontrado,ntot);
	//Calcular todos los puntos
	PuntoMrel *punpm=mod1->puntos.ppio;
	{int2 *ptri=pm_en_f.v;
	dontimes(npuntos,punpm++){
		double nsa,nsb,nsc,ts0,ts1,ts2;
		uint n;
		PuntoXYZ_double Pref;	//para puntos que se calculan en global

		nsa=nsb=nsc=ts0=ts1=ts2=0;
		n=0;
		zeroset_uint(per_group,ngrupos*uintsizeof(struct Per_group_data));
		for(;ptri->n1!=Я;ptri++){
			uint n_cp;
			struct Per_group_data *pgrupo;
			CentroProy *puncp;
			PuntoXYZ_double a,b;
			Puntoxy_double paux;
			Fotograma *punf;
			double aux,auxb;

			n_cp=f_a_cp[ptri->n1];
			if(n_cp==Я) continue;
			pgrupo=per_group+gpss[cp_a_gps[n_cp]].grupo;
			puncp=mod1->centros.ppio+n_cp;
			punf=puncp->fot;
			a=puncp->P;

			if(n>0 && punpm->vv==0){	//n>0 porque si no punpm puede que no apunte a nada
				P_eq(a,-=,Pref);
			}else{
				if(pgrupo->n==0){
					pgrupo->Pref=a;
					if(n==0) Pref=a;	//Por si acaso hará falta
					a.Z=a.Y=a.X=0;
				}else{
					P_eq(a,-=,pgrupo->Pref);
				}
			}
			b.Z=-punf->focal;
			paux=punf->puntos.ppio[ptri->n2].p;
			b.X=paux.x;
			b.Y=paux.y;
			AutoGiraPunto_inv_dbl(&b,puncp->M);

			n++;					pgrupo->n++;
			aux=b.X/b.Z;
			nsa+=aux*aux;		pgrupo->nsa+=aux*aux;
			nsb-=aux;			pgrupo->nsb-=aux;
			auxb=a.X-aux*a.Z;
			ts0-=aux*auxb;	pgrupo->ts0-=aux*auxb;
			ts1+=auxb;			pgrupo->ts1+=auxb;
									pgrupo->tsl+=auxb*auxb;
			aux=b.Y/b.Z;
			nsa+=aux*aux;		pgrupo->nsa+=aux*aux;
			nsc-=aux;			pgrupo->nsc-=aux;
			auxb=a.Y-aux*a.Z;
			ts0-=aux*auxb;	pgrupo->ts0-=aux*auxb;
			ts2+=auxb;			pgrupo->ts2+=auxb;
									pgrupo->tsl+=auxb*auxb;
		}
		ptri++;

		if(n<2){punpm--; continue;}

		uint kg;
		{uint *pfound=grupos_found;
		struct Per_group_data *ptr=per_group;
		for(uint k1=0;k1<ngrupos;k1++,ptr++)
			if(ptr->n>=2) *pfound++=k1;
		*pfound=Я;
		kg=(pdif)(pfound-grupos_found);
		}
		if(kg==0){
			double den,nsd,nse,nsf;
			den=nsa*n*n-nsb*nsb*n-nsc*nsc*n;
			den=1.0/den;
			nsd=nsa*n-nsc*nsc;
			nse=nsb*nsc;
			nsf=nsa*n-nsb*nsb;
			nsa=n*n;
			nsb*=-(double)n;
			nsc*=-(double)n;
			ts0*=den; ts1*=den; ts2*=den;

			punpm->vv=1.0;
			punpm->P=Pref;
			punpm->P.Z+=nsa*ts0+nsb*ts1+nsc*ts2;
			punpm->P.X+=nsb*ts0+nsd*ts1+nse*ts2;
			punpm->P.Y+=nsc*ts0+nse*ts1+nsf*ts2;
			continue;
		}
		zeroset_double(sigma_locales,ngrupos);

		uint *ptr=grupos_found;
		while(*ptr!=Я){
			uint k1=*ptr;
			double den,nsa,nsb,nsc,ts0,ts1,ts2, nsd,nse,nsf;
			struct Per_group_data *per=per_group+k1;

			den=per->nsa*per->n*per->n -(per->nsb*per->nsb +per->nsc*per->nsc)*per->n;
			den=1.0/den;
			nsd=per->nsa*per->n-per->nsc*per->nsc;
			nse=per->nsb*per->nsc;
			nsf=per->nsa*per->n-per->nsb*per->nsb;
			nsa=per->n*per->n;
			nsb=-per->nsb*(double)per->n;
			nsc=-per->nsc*(double)per->n;
			ts0=per->ts0*den;
			ts1=per->ts1*den;
			ts2=per->ts2*den;

			PuntoXYZ_double P;
			P.Z=nsa*ts0 +nsb*ts1 +nsc*ts2;
			P.X=nsb*ts0 +nsd*ts1 +nse*ts2;
			P.Y=nsc*ts0 +nse*ts1 +nsf*ts2;
			P_op(punto_locales[k1],=,per->Pref,+,P);
			if(kg==2){
				double sigma1;
				sigma1=per->tsl-2*(per->ts0*P.Z+per->ts1*P.X+per->ts2*P.Y);
				sigma1+=per->nsa*P.Z*P.Z+per->n*(P.X*P.X+P.Y*P.Y);
				sigma1+=2*P.Z*(per->nsb*P.X+per->nsc*P.Y);
				sigma1/=(double)(per->n-1);
				sigma_locales[k1]=sigma1;
			}else{
				P_eq(P,+=,per->Pref);
				uint *ptrb=grupos_found;
				while(ptrb!=ptr){
					uint k2=*ptrb++;
					PuntoXYZ_double dif; P_op(dif,=,P,-,punto_locales[k2]);
					double aux=P_mod(dif);
					sigma_locales[k1]+=aux*per_group[k2].n;
					sigma_locales[k2]+=aux*per->n;
				}
			}
			ptr++;
		}

		double min;
		uint kmax;
		kmax=grupos_found[0];
		min=sigma_locales[kmax];
		ptr=grupos_found+1;
		while(*ptr!=Я){
			uint k1=*ptr++;
			double aux=sigma_locales[k1];
			if(aux<min){
				min=aux;
				kmax=k1;
		}	}
		punpm->P=punto_locales[kmax];
	}}

	remove_from_delete_Modelo(mod1);
	return_ATplist 0;
salida_outofmem:
	return_ATplist AT_NOMEM;
}

void escala_modelo(Modelo* mod){
	double H;
	CentroProy *puncP;
	puncP=mod->centros.ppio;

	H=0;
	{durchVectori(PuntoMrel,mod->puntos) H+=ptri->P.Z;}
	H/=mod->puntos.n;
	H-=puncP->P.Z;
	H=-puncP->fot->focal/H;

	{durchVectori(PuntoMrel,mod->puntos) P_mul(ptri->P,H);}
	{durchVectori(CentroProy,mod->centros) P_mul(ptri->P,H);}
}
