#pragma once
#include <math.h>
#include "PI.h"

sinline s8int log10n_d(double x){
	if(x==0) return -127;
	if(x<0) x=-x;

	s8int log=0;
	while(x<1) x*=10,log--;
	if(x>=10){double y=10; do y*=10,log++; while(x>=y);}
	return log;
}
sinline s8int log10n_f(float x){
	if(x==0) return -127;
	if(x<0) x=-x;

	s8int log=0;
	while(x<1) x*=10,log--;
	if(x>=10){float y=10; do y*=10,log++; while(x>=y);}
	return log;
}

#define decimales_d(x) (-log10n_d(x/7))
#define decimales_f(x) (-log10n_f(x/7))
#define log10n log10n_f

sinline float pow10f(s8int d){
	static const float potencias[60]={
		1.0E-30F, 1.0E-29F, 1.0E-28F, 1.0E-27F, 1.0E-26F,
		1.0E-25F, 1.0E-24F, 1.0E-23F, 1.0E-22F, 1.0E-21F,
		1.0E-20F, 1.0E-19F, 1.0E-18F, 1.0E-17F, 1.0E-16F,
		1.0E-15F, 1.0E-14F, 1.0E-13F, 1.0E-12F, 1.0E-11F,
		1.0E-10F, 1.0E-9F, 1.0E-8F, 1.0E-7F, 1.0E-6F,
		1.0E-5F, 1.0E-4F, 0.001F, 0.01F, 0.1F,
		1.0F, 10.0F, 100.0F, 1000.0F, 1.0E+4F,
		1.0E+5F, 1.0E+6F, 1.0E+7F, 1.0E+8F, 1.0E+9F,
		1.0E+10F, 1.0E+11F, 1.0E+12F, 1.0E+13F, 1.0E+14F,
		1.0E+15F, 1.0E+16F, 1.0E+17F, 1.0E+18F, 1.0E+19F,
		1.0E+20F, 1.0E+21F, 1.0E+22F, 1.0E+23F, 1.0E+24F,
		1.0E+25F, 1.0E+26F, 1.0E+27F, 1.0E+28F, 1.0E+29F
	};
	if(d<-30) return potencias[0];
	if(d>=30) return potencias[59];
	return potencias[d+30];
}

#define semieje_BODY \
	TypeR t,d,disc;\
	d=x*y-xy*xy;\
	t=x+y;\
	disc=t*t-4*d;\
	if(disc<0) disc=0;\
	disc=SQRT(disc);\
	return 0.5F*(t+disc);

#define TypeR float
#define SQRT sqrtf
TypeR semieje_fl(TypeR x, TypeR y, TypeR xy){
	semieje_BODY
}
#undef SQRT
#undef TypeR
#define TypeR double
#define SQRT sqrt
TypeR semieje_dbl(TypeR x, TypeR y, TypeR xy){
	semieje_BODY
}
#undef SQRT
#undef TypeR
#define semieje semieje_fl
