﻿Puntoxy_float calcula_distorsion(Puntoxy_double* calc, const OrientacionInterna *interna){
	Puntoxy_float fcalc,dp, dp2;
	float dist, r2,theta;

	{float aux=1/interna->SDIAG;
	fcalc.x=(float)calc->x*aux;
	fcalc.y=(float)calc->y*aux;}
	r2=fcalc.x*fcalc.x+fcalc.y*fcalc.y;
	theta=atan2f(fcalc.y,fcalc.x);
	dp.y=dp.x=0;
	if(interna->flags&CAL_FLAG_RadSim){
		dist=Simetrica_r(interna->MODELOp, interna->distorsion.config.param_radsim, interna->RS, r2);
		dp.x+=dist*fcalc.x;
		dp.y+=dist*fcalc.y;
	}
	if(interna->flags&CAL_FLAG_TanSim){
		dist=Simetrica_r(interna->MODELOp, interna->distorsion.config.param_tansim, interna->TS, r2);
		dp.x-=dist*fcalc.y;
		dp.y+=dist*fcalc.x;
	}
	r2=sqrtf(r2);
	if(interna->flags&CAL_FLAG_Asim1){
		dp2=Asim_serie1(interna->distorsion.config.modelo_asim, interna->MODELOp, interna->distorsion.config.param_asim1, interna->ASIM1, fcalc.x,fcalc.y);
		dp.x+=dp2.x;
		dp.y+=dp2.y;
	}
	if(interna->flags&CAL_FLAG_Asim2){
		dp2=Asim_serie2(interna->distorsion.config.modelo_asim, interna->MODELOp, interna->distorsion.config.param_asim2, interna->ASIM2, fcalc.x,fcalc.y);
		dp.x+=dp2.x;
		dp.y+=dp2.y;
	}
	return dp;
}
Puntoxy_float calcula_distorsion_inversa(Puntoxy_double* ob, const OrientacionInterna *interna){
	Puntoxy_double calc;
	Puntoxy_float dp;

	/*if(interna->flags&CAL_FLAG_Radsim){
		Puntoxy_float fob;
		float r,theta, dist;
		r=1/interna->SDIAG;
		fob.x=(float)ob->x*r;
		fob.y=(float)ob->y*r;
		r=sqrtf(fob.x*fob.x+fob.y*fob.y);
		theta=atan2f(fob.y,fob.x);
		dp.y=dp.x=0;
		dist=Radsim_inv(interna->MODELOp, interna->distorsion.config.param_radsim, interna->RS, r,true);
		calc.x=ob->x-dist*fob.x;
		calc.y=ob->y-dist*fob.y;
	}*/
	calc=*ob;
	dp=calcula_distorsion(&calc, interna);
	calc.x=ob->x-dp.x;	calc.y=ob->y-dp.y;
	dp=calcula_distorsion(&calc, interna);
	calc.x=ob->x-dp.x;	calc.y=ob->y-dp.y;
	dp=calcula_distorsion(&calc, interna);
	return dp;
}
//1: aplicar la distorsión
//0: corregirla
inline void corrige_distorsion(Puntoxy_double* ob, const OrientacionInterna *interna, bint sentido){
	Puntoxy_float dp;
	if(sentido){
		dp=calcula_distorsion(ob,interna);
		ob->x+=dp.x;
		ob->y+=dp.y;
	}else{
		dp=calcula_distorsion_inversa(ob,interna);
		ob->x-=dp.x;
		ob->y-=dp.y;
	}
}
void medida_a_fotocoord(Puntoxy_double* ob, const OrientacionInterna *interna){
	if(interna->flags&CAL_FLAG_Transf1){
		double aux;
		ob->x-=interna->afin_1.Tx;
		ob->y-=interna->afin_1.Ty;
		aux=interna->afin_1.a*ob->x+interna->afin_1.b*ob->y;
		ob->y=interna->afin_1.c*ob->x+interna->afin_1.d*ob->y;
		ob->x=aux;
	}
	if(interna->flags&CAL_FLAG_pp){
		ob->x-=interna->valI.x;
		ob->y-=interna->valI.y;
	}
	if(interna->flags&CAL_FLAG_Distorsiones){
		corrige_distorsion(ob,interna,0);
	}
}
void fotocoord_a_medida(Puntoxy_double* ob, const OrientacionInterna *interna){
	if(interna->flags&CAL_FLAG_Distorsiones){
		corrige_distorsion(ob,interna,1);
	}
	if(interna->flags&CAL_FLAG_pp){
		ob->x+=interna->valI.x;
		ob->y+=interna->valI.y;
	}
	if(interna->flags&CAL_FLAG_Transf1){
		if(interna->afin_1.b==0 && interna->afin_1.c==0){
			ob->x/=interna->afin_1.a;
			ob->y/=interna->afin_1.d;
		}else{
			Lineal2D_dbl ainv;
			double aux;
			aux=interna->afin_1.a*interna->afin_1.d-interna->afin_1.b*interna->afin_1.c;
			aux=1.0/aux;
			ainv.a=interna->afin_1.d*aux;
			ainv.b=-interna->afin_1.b*aux;
			ainv.c=-interna->afin_1.c*aux;
			ainv.d=interna->afin_1.a*aux;
			aux=ainv.a*ob->x+ainv.b*ob->y;
			ob->y=ainv.c*ob->x+ainv.d*ob->y;
			ob->x=aux;
		}
		ob->x+=interna->afin_1.Tx;
		ob->y+=interna->afin_1.Ty;
	}
}
void medida_a_fotocoord_Foto(Fotograma* punf, const OrientacionInterna* interna){
	Puntof* punpf;
	uint j;

	punpf=punf->puntos.ppio;
	for(j=(uint)punf->puntos.n;j--;punpf++){
		medida_a_fotocoord(&punpf->p,interna);
	}
}

void elimina_a1(OrientacionInterna *interna){
	float alpha;

	if(!CAL_FLAGS_HayRadSim(interna->flags) || interna->MODELOp==0) return;
	alpha=interna->RS[0];
	if(alpha!=0){
		alpha=1.0F+alpha/interna->SDIAG;
		interna->valI.f*=alpha;
		interna->SDIAG*=alpha;
		interna->RS[0]=0;
	}
}

void multiplica_por_alpha_asim(float *val, uint *params, float alpha, u8int modelo);
void multiplica_por_alpha(OrientacionInterna *interna, float alpha, bint omite_radsim){
	float k[SIM_N];
	u8int modelo;
	float paso;
	modelo=interna->MODELOp;

	if(!(interna->flags&CAL_FLAG_Distorsiones) || modelo==0 || modelo>2) return;
	if(modelo==CAL_MODPOL_IMPAR) paso=alpha*alpha;
	elif(modelo==CAL_MODPOL_COMPLETO) paso=alpha;

	if(!omite_radsim && (interna->flags&CAL_FLAG_RadSim)){
		float beta=alpha;
		colapsa_serie_p(modelo,interna->RS,k);
		{u8int i; for(i=0;i<SIM_N;i++,beta*=paso) k[i]*=beta;}
		elabora_poli_p(modelo,interna->RS,k);
		{u16int l=1;
		float *ptri=interna->RS;
		interna->distorsion.config.param_radsim=0;
		{dontimes(SIM_N,(l<<=1,ptri++)) if(*ptri!=0) interna->distorsion.config.param_radsim|=l;}}
	}
	if(interna->flags&CAL_FLAG_TanSim){
		float beta=alpha;
		colapsa_serie_p(modelo,interna->TS,k);
		{u8int i; for(i=0;i<SIM_N;i++,beta*=paso) k[i]*=beta;}
		elabora_poli_p(modelo,interna->TS,k);
		{u16int l=1;
		float *ptri=interna->TS;
		interna->distorsion.config.param_tansim=0;
		{dontimes(SIM_N,(l<<=1,ptri++)) if(*ptri!=0) interna->distorsion.config.param_tansim|=l;}}
	}
	if(interna->flags&CAL_FLAG_Asim1) multiplica_por_alpha_asim(interna->ASIM1,&interna->distorsion.config.param_asim1,alpha,modelo);
	if(interna->flags&CAL_FLAG_Asim2) multiplica_por_alpha_asim(interna->ASIM2,&interna->distorsion.config.param_asim2,alpha,modelo);
}
void multiplica_por_alpha_asim(float *val, uint *params, float alpha, u8int modelo){
	float a[SIM_N], k[SIM_N];
	float beta,paso;
	beta=alpha*alpha;
	if(modelo==CAL_MODPOL_COMPLETO) paso=alpha;
	else paso=alpha*alpha;
	*params=0;

	a[0]=val[4]; a[1]=val[8]; {uint i; for(i=2;i<SIM_N;i++) a[i]=0;}
	colapsa_serie_p(modelo,a,k);
	k[0]*=alpha; k[1]*=alpha*paso;
	elabora_poli_p(modelo,a,k);
	val[4]=a[0]; val[8]=a[1];
	if(val[4]!=0) *params|=1<<4;
	if(val[8]!=0) *params|=1<<8;
	//
	a[0]=val[5]; a[1]=val[9]; {uint i; for(i=2;i<SIM_N;i++) a[i]=0;}
	colapsa_serie_p(modelo,a,k);
	k[0]*=alpha; k[1]*=alpha*paso;
	elabora_poli_p(modelo,a,k);
	val[5]=a[0]; val[9]=a[1];
	if(val[5]!=0) *params|=1<<5;
	if(val[9]!=0) *params|=1<<9;
	//
	a[0]=val[0]; a[1]=val[2]; a[2]=val[6]; {uint i; for(i=3;i<SIM_N;i++) a[i]=0;}
	colapsa_serie_p(modelo,a,k);
	k[0]*=beta; k[1]*=beta*paso; k[2]*=beta*paso*paso;
	elabora_poli_p(modelo,a,k);
	val[0]=a[0]; val[2]=a[1]; val[6]=a[3];
	if(val[0]!=0) *params|=1;
	if(val[2]!=0) *params|=1<<2;
	if(val[6]!=0) *params|=1<<6;
	//
	a[0]=val[1]; a[1]=val[3]; a[2]=val[7]; {uint i; for(i=3;i<SIM_N;i++) a[i]=0;}
	colapsa_serie_p(modelo,a,k);
	k[0]*=beta; k[1]*=beta*paso; k[2]*=beta*paso*paso;
	elabora_poli_p(modelo,a,k);
	val[1]=a[0]; val[3]=a[1]; val[7]=a[3];
	if(val[1]!=0) *params|=1<<1;
	if(val[3]!=0) *params|=1<<3;
	if(val[7]!=0) *params|=1<<7;
	//
	if(val[10]!=0){val[10]*=beta; *params|=1<<10;}
	if(val[11]!=0){val[11]*=beta; *params|=1<<11;}
}

void elimina_a1_semidiag(OrientacionInterna *interna){
	float k[SIM_N];
	u8int modelo;
	float min;
	double f0;

	modelo=interna->MODELOp;
	if(!CAL_FLAGS_HayRadSim(interna->flags) || modelo==0 || modelo>2) return;

	f0=interna->valI.f;
	do{
		float alpha, paso;
		min=fabsf(interna->RS[0]);
		if(min==0) break;

		alpha=1.0F+interna->RS[0]/interna->SDIAG;
		interna->valI.f*=alpha;
		alpha=1/alpha;
		if(modelo==CAL_MODPOL_IMPAR) paso=alpha*alpha;
		elif(modelo==CAL_MODPOL_COMPLETO) paso=alpha;

		colapsa_serie_p(modelo,interna->RS,k);
		k[0]-=interna->RS[0];
		{u8int i; for(i=0;i<SIM_N;i++,alpha*=paso) k[i]*=alpha;}
		elabora_poli_p(modelo,interna->RS,k);
	}while(fabsf(interna->RS[0])<min);

	multiplica_por_alpha(interna, (float)(interna->valI.f/f0), true);
}
void cambia_semidiag(OrientacionInterna *interna, float nuevo){
	float alpha;
	alpha=nuevo/interna->SDIAG;
	interna->SDIAG=nuevo;
	multiplica_por_alpha(interna, alpha, false);
}

//0: todo bien
//AT_NOMEM
//1: la segunda interna incluye una transformación previa
//2: Los valores de semidiagonal son muy distintos
//3: Los modelos polinómicos no coinciden. Aún así las distorsiones se combinan, pero el resultado no es exacto
int combina_internas(const OrientacionInterna* interna1, const OrientacionInterna* interna2, OrientacionInterna* combinada){
	int nret;
	nret=0;
	setup_interna(combinada);

	if(interna2->flags&CAL_FLAG_Transf1) return CAL_COMBINA_AFIN2;	//la segunda interna no puede incluir una transformación previa
	combinada->flags=interna1->flags | interna2->flags;
	if(interna1->flags&CAL_FLAG_Transf1) combinada->afin_1=interna1->afin_1;
	combinada->valI.x=interna1->valI.x+interna2->valI.x;
	combinada->valI.y=interna1->valI.y+interna2->valI.y;
	combinada->valI.f=interna2->valI.f;
	{KeyVal *ptr_orig=NULL;
	if(interna1->flags&CAL_FLAG_Transf1 || interna2->info==NULL) ptr_orig=interna1->info;
	else ptr_orig=interna2->info;
	if(ptr_orig!=NULL){
		KeyVal *ptr_c;
		checked_malloc_n(combinada->info,KeyVal,5, return AT_NOMEM);
		ptr_c=combinada->info;
		while(ptr_orig->key!=0){
			if(ptr_orig->key<=4){
				*ptr_c++=*ptr_orig++;
				if(ptr_c-combinada->info==4) break;
			}
		}
		ptr_c->key=0; ptr_c->val.ptr=NULL;
	}}

	if(!(combinada->flags&CAL_FLAG_Distorsiones)) return 0;
	if(combinada->flags&CAL_FLAG_RadSim){checked_malloc_n(combinada->RS,float,16, return AT_NOMEM);}
	if(combinada->flags&CAL_FLAG_TanSim){checked_malloc_n(combinada->TS,float,16, return AT_NOMEM);}
	if(combinada->flags&CAL_FLAG_Asim1){checked_malloc_n(combinada->ASIM1,float,16, return AT_NOMEM);}
	if(combinada->flags&CAL_FLAG_Asim2){checked_malloc_n(combinada->ASIM2,float,16, return AT_NOMEM);}

	//Los enteros param_radsim, etc. tienen que estar bien (e.d., =0) aunque flags&8 sea =0.
	combinada->distorsion.config=interna1->distorsion.config;
	if(interna1->flags&CAL_FLAG_RadSim){memcpy_float(combinada->RS,interna1->RS,8);}
		elif(combinada->flags&CAL_FLAG_RadSim) zeroset_float(combinada->RS,8);
	if(interna1->flags&CAL_FLAG_TanSim){memcpy_float(combinada->TS,interna1->TS,8);}
		elif(combinada->flags&CAL_FLAG_TanSim) zeroset_float(combinada->TS,8);
	if(interna1->flags&CAL_FLAG_Asim1){memcpy_float(combinada->ASIM1,interna1->ASIM1,16);}
		elif(combinada->flags&CAL_FLAG_Asim1) zeroset_float(combinada->ASIM1,16);
	if(interna1->flags&CAL_FLAG_Asim2){memcpy_float(combinada->ASIM2,interna1->ASIM2,16);}
		elif(combinada->flags&CAL_FLAG_Asim2) zeroset_float(combinada->ASIM2,16);

	if(interna1->flags&CAL_FLAG_Distorsiones && interna2->flags&CAL_FLAG_Distorsiones){
		u8int bmodelo_poli;
		double prod;
		float dif;

		combinada->SDIAG=interna2->SDIAG;
		prod=interna1->SDIAG*interna2->valI.f;
		dif=(float)(interna2->SDIAG*interna1->valI.f-prod);
		if(fabsf(dif)>(float)(2.0E-6*prod)){
			if(4*fabsf(dif)>(float)prod) return CAL_COMBINA_DISTINTAS;
			combinada->SDIAG=(float)(prod/interna1->valI.f);
			cambia_semidiag(combinada,interna2->SDIAG);
		}
		if(interna1->MODELOp!=interna2->MODELOp){
			nret=CAL_COMBINA_DISTINTOS_MODELOS;
			if(!(interna2->flags&CAL_FLAG_RadSim)) bmodelo_poli=1;
			elif(!(interna1->flags&CAL_FLAG_RadSim)) bmodelo_poli=2;
			elif(fabsf(interna1->RS[0])>=fabsf(interna2->RS[0])) bmodelo_poli=1;
			else bmodelo_poli=2;
		}else{
			bmodelo_poli=1;
		}
		if(bmodelo_poli==2) combinada->MODELOp=interna2->MODELOp;
	}elif(!(interna1->flags&CAL_FLAG_Distorsiones)){
		combinada->MODELOp=interna2->MODELOp;
		combinada->SDIAG=interna2->SDIAG;
	}

	if(interna2->flags&CAL_FLAG_RadSim){
		combinada->distorsion.config.param_radsim|=interna2->distorsion.config.param_radsim;
		{durchlaufe2(float,combinada->RS,8,float,interna2->RS) *ptr+=*ptr_b;}
	}
	if(interna2->flags&CAL_FLAG_TanSim){
		combinada->distorsion.config.param_tansim|=interna2->distorsion.config.param_tansim;
		{durchlaufe2(float,combinada->TS,8,float,interna2->TS) *ptr+=*ptr_b;}
	}
	if(interna2->flags&CAL_FLAG_Asimetricas){
		combinada->distorsion.config.param_asim1|=interna2->distorsion.config.param_asim1;
		combinada->distorsion.config.param_asim2|=interna2->distorsion.config.param_asim2;
		if(!(interna1->flags&CAL_FLAG_Asimetricas)) combinada->distorsion.config.modelo_asim=interna2->distorsion.config.modelo_asim;
		if(combinada->distorsion.config.modelo_asim==interna2->distorsion.config.modelo_asim){
			if(interna2->flags&CAL_FLAG_Asim1){durchlaufe2(float,combinada->ASIM1,16,float,interna2->ASIM1) *ptr+=*ptr_b;}
			if(interna2->flags&CAL_FLAG_Asim2){durchlaufe2(float,combinada->ASIM2,16,float,interna2->ASIM2) *ptr+=*ptr_b;}
		}else{
			u16int *pbasim1, *pbasim2;
			if(!(combinada->flags&CAL_FLAG_Asim1)){
				checked_malloc_n(combinada->ASIM1,float,16, return AT_NOMEM);
				zeroset_float(combinada->ASIM1,16);
			}
			if(!(combinada->flags&CAL_FLAG_Asim2)){
				checked_malloc_n(combinada->ASIM2,float,16, return AT_NOMEM);
				zeroset_float(combinada->ASIM2,16);
			}
			combinada->flags|=CAL_FLAG_Asimetricas;

			combinada->distorsion.config.param_asim1=interna2->distorsion.config.param_asim1
				| (interna1->distorsion.config.param_asim1&3);
			combinada->distorsion.config.param_asim2=interna2->distorsion.config.param_asim2
				| (interna1->distorsion.config.param_asim2&3);

			pbasim1=&combinada->distorsion.config.param_asim1,
			pbasim2=&combinada->distorsion.config.param_asim2;
			if(interna2->distorsion.config.modelo_asim==1){	//Cambiar la distorsión de interna1 al modelo 1
				u16int bparams1, bparams2, l;
				u8int i;
				bparams1=(interna1->distorsion.config.param_asim1&0xFFFF)>>2;
				bparams2=(interna1->distorsion.config.param_asim2&0xFFFF)>>2;
				l=4;
				i=2;
				while((bparams1 | bparams2)!=0){
					float x1,x2,y1,y2;
					if(bparams1&1){
						x1=combinada->ASIM1[i];
						*pbasim1|=l;
						*pbasim2|=l<<1;
					}else x1=0;
					if(bparams1&2){
						x2=combinada->ASIM1[i+1];
						*pbasim1|=l<<1;
						*pbasim2|=l;
					}else x2=0;
					if(bparams2&1){
						y1=combinada->ASIM2[i];
						*pbasim1|=l;
						*pbasim2|=l<<1;
					}else y1=0;
					if(bparams2&2){
						y2=combinada->ASIM2[i+1];
						*pbasim1|=l<<1;
						*pbasim2|=l;
					}else y2=0;
					combinada->ASIM1[i]=x1+y1;
					combinada->ASIM1[i+1]=x2-y2;
					combinada->ASIM2[i]=x2+y2;
					combinada->ASIM2[i+1]=-x1+y1;

					bparams1>>=2, bparams2>>=2;
					l<<=2, i+=2;
				}
			}else{	//Cambiar la distorsión de interna1 al modelo 2
				u16int bparams1, bparams2, l;
				u8int i;
				bparams1=(interna1->distorsion.config.param_asim1&0xFFFF)>>2;
				bparams2=(interna1->distorsion.config.param_asim2&0xFFFF)>>2;
				l=4;
				i=2;
				while((bparams1 | bparams2)!=0){
					float x1,x2,y1,y2;
					if(bparams1&1){
						*pbasim1|=l;
						*pbasim2|=l;
						x1=0.5F*combinada->ASIM1[i];
					}else x1=0;
					if(bparams1&2){
						*pbasim1|=l<<1;
						*pbasim2|=l<<1;
						x2=0.5F*combinada->ASIM1[i+1];
					}else x2=0;
					if(bparams2&1){
						*pbasim1|=l<<1;
						*pbasim2|=l<<1;
						y1=0.5F*interna1->ASIM2[i];
					}else y1=0;
					if(bparams2&2){
						*pbasim1|=l;
						*pbasim2|=l;
						y2=0.5F*interna1->ASIM2[i+1];
					}else y2=0;
					combinada->ASIM1[i]=x1-y2;
					combinada->ASIM1[i+1]=x2+y1;
					combinada->ASIM2[i]=x1+y2;
					combinada->ASIM2[i+1]=-x2+y1;

					bparams1>>=2, bparams2>>=2;
					l<<=2, i+=2;
				}
			}
			if(interna2->flags&CAL_FLAG_Asim1){durchlaufe2(float,combinada->ASIM1,16,float,interna2->ASIM1) *ptr+=*ptr_b;}
			if(interna2->flags&CAL_FLAG_Asim2){durchlaufe2(float,combinada->ASIM2,16,float,interna2->ASIM2) *ptr+=*ptr_b;}
		}
	}

	return nret;
}


s8int log10n_d(double x){
	if(x==0) return -127;
	if(x<0) x=-x;

	s8int log=0;
	while(x<1) x*=10,log--;
	if(x>10){for(double y=10; x>=y; y*=10,log++);}
	return log;
}
static const float pot20[9]={0.002F,0.02F,0.2F,2.0F,20.0F,200.0F,2000.F,20000.F,200000.F};
int interna_Aerotri___kpb(const InternaKPB *mala, OrientacionInterna *interna, bint bfocal, bint bpp){
	float semi2;
	float a[5];

	setup_interna(interna);
	interna->afin_1.c=interna->afin_1.b=0;
	interna->afin_1.a=mala->pixels.px;
	interna->afin_1.d=-mala->pixels.py;
	interna->afin_1.Tx=mala->pixels.cx;
	interna->afin_1.Ty=mala->pixels.cy;
	interna->valI.x=mala->x;
	interna->valI.y=mala->y;
	interna->valI.f=mala->f;

	interna->flags=CAL_FLAG_Transf1;
	if(mala->x!=0 || mala->y!=0) interna->flags|=CAL_FLAG_pp;
	if(mala->k[0]==0 && mala->k[1]==0 && mala->k[2]==0 && mala->k[3]==0 && mala->k[4]==0
		&& mala->p1==0 && mala->p2==0 && mala->b1==0 && mala->b2==0) return 0;

	aj_malloc_return(interna->RS,float,8);
	zeroset_float(interna->RS,8);
	if(mala->p1!=0 || mala->p2!=0 || bpp ||  mala->b1!=0 || mala->b2!=0){
		aj_malloc_return(interna->ASIM1,float,16);	zeroset_float(interna->ASIM1,16);
		aj_malloc_return(interna->ASIM2,float,16);	zeroset_float(interna->ASIM2,16);
	}
	interna->flags|=CAL_FLAG_Distorsiones | CAL_FLAG_RadSim;
	interna->MODELOp=CAL_MODPOL_IMPAR;

	{float faux, fauxb;
	faux=(float)(interna->afin_1.Tx*mala->pixels.px);
	fauxb=(float)(interna->afin_1.Ty*mala->pixels.py);
	interna->SDIAG=sqrtf(faux*faux+fauxb*fauxb);}
	if(interna->SDIAG*20.0F<mala->f) interna->SDIAG=(float)mala->f; //Tx & Ty do not hold half the photograph's dimensions
	if(!bfocal){//Redondear semidiag
		int k; float faux;
		k=log10n_d((double)interna->SDIAG)-1;
		ifunlike(k<-3) k=-3;
		elif(k>5) k=5;
		faux=pot20[k+5];
		interna->SDIAG*=faux;
		interna->SDIAG=(float)((int)interna->SDIAG+1);
		interna->SDIAG/=faux;
	}
	semi2=interna->SDIAG*interna->SDIAG;

	{double faux=interna->SDIAG;	//double. this model used to be called mala for something
	durchlaufe2(float,a,5,const float,mala->k){	//ANSI
		*ptr=(float)(*ptr_b*faux);
		faux*=semi2;
	}}
	if(mala->b1!=0){
		interna->distorsion.config.param_asim1|=0x10;
		interna->distorsion.config.param_asim2|=0x20;
		a[0]+=interna->ASIM1[4]=0.5F*mala->b1*interna->SDIAG;
		interna->ASIM2[5]=-interna->ASIM1[4];
	}
	if(mala->b2!=0){
		aj_malloc_return(interna->TS,float,8);
		zeroset_float(interna->TS,8);
		interna->flags|=CAL_FLAG_TanSim;
		interna->distorsion.config.param_tansim=1;
		interna->distorsion.config.param_asim1|=0x20;
		interna->distorsion.config.param_asim2|=0x10;
		interna->TS[0]=interna->ASIM2[4]=interna->ASIM1[5]=0.5F*mala->b2*interna->SDIAG;
	}
	elabora_poli_p(CAL_MODPOL_IMPAR,interna->RS,a);
	if(mala->p1!=0 || mala->p2!=0){
		interna->distorsion.config.param_asim1|=3;
		interna->distorsion.config.param_asim2|=3;
		interna->ASIM1[0]=-3.0F*(interna->ASIM2[1]=-semi2*mala->p1);
		interna->ASIM1[1]=3.0F*(interna->ASIM2[0]=semi2*mala->p2);
	}

	if(bfocal){
		float aux=1+interna->RS[0]/interna->SDIAG;
		interna->valI.f*=aux;
		interna->SDIAG*=aux;
		semi2*=aux*aux;
		interna->RS[0]=0;
	}
	if(bpp && (interna->distorsion.config.param_asim1&3)){
		float faux=(float)(interna->valI.f*interna->valI.f)/semi2;
		interna->valI.x-=interna->ASIM1[0]*faux;		interna->ASIM1[0]=0;
		interna->valI.y-=interna->ASIM1[1]*faux;		interna->ASIM1[1]=0;
		interna->distorsion.config.param_asim1&=~3U;
	}

	#define R interna->distorsion.config.param_radsim
	if(interna->RS[0]!=0) R|=1;
	if(interna->RS[1]!=0) R|=2;	if(interna->RS[2]!=0) R|=4;
	if(interna->RS[3]!=0) R|=8;	if(interna->RS[4]!=0) R|=16;
	#undef R

	if(interna->distorsion.config.param_asim1!=0){
		interna->flags|=CAL_FLAG_Asim1;
		interna->distorsion.config.modelo_asim=CAL_MODASIM_RADTAN;
	}
	if(interna->distorsion.config.param_asim2!=0){
		interna->flags|=CAL_FLAG_Asim2;
		interna->distorsion.config.modelo_asim=CAL_MODASIM_RADTAN;
	}
	return 0;
}

int interna_kpb___Aerotri(const OrientacionInterna *interna, InternaKPB *mala, float *desplaz){
	float _semi, _semi2,_semi4;
	float κ0; //Valor κ[0] de la DTS que habría que escribir en mala.

	if(CAL_FLAGS_HayRadSim(interna->flags) && interna->MODELOp!=CAL_MODPOL_IMPAR) return 9;

	if(interna->flags&CAL_FLAG_Transf1){
		if(interna->afin_1.b!=0 || interna->afin_1.c!=0 || interna->afin_1.a<=0 || interna->afin_1.d>=0) return 8;
		mala->pixels.cx=interna->afin_1.Tx;
		mala->pixels.cy=interna->afin_1.Ty;
		mala->pixels.px=interna->afin_1.a;
		mala->pixels.py=-interna->afin_1.d;
	}else{
		mala->pixels.cy=mala->pixels.cx=0;
		mala->pixels.py=mala->pixels.px=1;
	}
	mala->f=interna->valI.f;
	mala->x=interna->valI.x;
	mala->y=interna->valI.y;
	zeroset_float(mala->k,SIM_N);
	mala->p1=mala->p2=0;
	mala->b1=mala->b2=0;
	κ0=0;
	if(desplaz!=NULL) *desplaz=0;
	if(!(interna->flags&CAL_FLAG_Distorsiones)) return 0;

	mala->inexacta=0;
	_semi=1.0F/interna->SDIAG;
	_semi2=_semi*_semi;
	_semi4=_semi2*_semi2;
	if(interna->flags&CAL_FLAG_RadSim){
		colapsa_serie_p(CAL_MODPOL_IMPAR,interna->RS,mala->k);

		mala->k[0]*=_semi;
		mala->k[1]*=_semi*_semi2;
		mala->k[2]*=_semi*_semi4;
		mala->k[3]*=_semi*_semi4*_semi2;
		mala->k[4]*=_semi*_semi4*_semi4;
	}
	if(interna->distorsion.config.modelo_asim!=0){
		float c1,c2;
		float faux, fdesp;
		if(interna->distorsion.config.param_asim1){
			c1=interna->ASIM1[0];
			c2=interna->ASIM1[1];
		}else{
			c2=c1=0;
		}
		if(interna->distorsion.config.param_asim2){
			float d1,d2;
			d1=interna->ASIM2[0];
			d2=-interna->ASIM2[1];
			mala->p1=d2*_semi2;
			mala->p2=d1*_semi2;
			c1-=3.0F*d2;
			c2-=3.0F*d1;
		}
		faux=(float)(mala->f*mala->f)*_semi2;
		c1*=faux;	c2*=faux;
		mala->x-=c1;
		mala->y-=c2;
		if(fabsf(c1)>=fabsf(c2)) fdesp=fabsf(c1); else fdesp=fabsf(c2);
		if(fdesp*_semi>=8.0E-6F) mala->inexacta|=1;
		if(desplaz!=NULL) *desplaz=fdesp;

		if((interna->distorsion.config.param_asim1|interna->distorsion.config.param_asim2)&0x30){ //5,6
			float α, β, γ, δ;
			if(interna->distorsion.config.modelo_asim==CAL_MODASIM_VECTOR){
				α=interna->ASIM1[4];		β=interna->ASIM2[4];
				γ=interna->ASIM1[5];		δ=interna->ASIM2[5];
			}else{
				α=0.5F*(interna->ASIM1[4]-interna->ASIM2[5]);
				β=0.5F*(interna->ASIM1[5]+interna->ASIM2[4]);
				γ=0.5F*(interna->ASIM1[4]+interna->ASIM2[5]);
				δ=-0.5F*(interna->ASIM1[5]-interna->ASIM2[4]);
			}
			if(interna->flags&CAL_FLAG_TanSim) κ0=interna->TS[0];
			mala->k[0]-=α*_semi;  //Fit to the 'y' coordinate. El término b1 añade un escalado medio de α*_semi
			mala->b1=2.0F*α*_semi;
			κ0-= β; //Fit to the 'y' coordinate. El término b2 añade una rotación media de β*_semi
			mala->b2=2.0F*β*_semi; // =-2.0F*Δκ;
			if(fabsf(κ0)*_semi>=4.0E-6F) mala->inexacta|=2;
			if((γ*γ+δ*δ)*_semi2>=1.6E-11F) mala->inexacta|=4;
		}
		if((interna->distorsion.config.param_asim1|interna->distorsion.config.param_asim2)&~0x33U) mala->inexacta|=4;
	}

	if(interna->flags&CAL_FLAG_TanSim && interna->distorsion.config.param_tansim!=1) mala->inexacta|=4;
	if(interna->flags&CAL_FLAG_RadSim){ //Eliminar k0 para los programas que no lo acepten
			float faux,_f2;							//Supongo que si un programa no admite k0 tampoco admite b1,
			faux=mala->k[0]+0.5F*mala->b1; //entonces no eliminaremos k0 completamente
			mala->k[0]-=faux;					//sino que dejaremos el que anule el efecto DRS de b1
			mala->f*=1+faux;
			faux=1.0F/(1+faux);
			_f2=faux*faux;

			mala->k[0]*=faux;
			mala->b1*=faux;
			mala->b2*=faux;
			faux*=_f2;
			mala->k[1]*=faux;	faux*=_f2;
			mala->k[2]*=faux;	faux*=_f2;
			mala->k[3]*=faux;	faux*=_f2;
			mala->k[4]*=faux;
			mala->p1*=_f2;
			mala->p2*=_f2;
	}
	return (int)mala->inexacta;
}
