#include <ATcrt/ATsystem.h>
#include <ATcrt/ATmem.h>
#include "interop.h"
#include "clases_mainabsoluta.h"
#include <ATcrt/ATfileoutput.h>
#include "Aerotri_defs.h"

typedef struct{
	bool8 f;
	bool8 x,y;
	Config_distorsion config_dist;	//V. clase_distorsion.h
} AjbloqueConfigInterna;

/*
hwnd_main: Puntero a una ventana de Windows para enviar mensajes de progreso. Si se pasa NULL se ignora
log_code:	El código de mensaje para los mensajes de progreso que se envíen. El texto es un char16_t* en lParam
log_file:		Estructura Bufferto8 de ATcrt que apunta a un fichero de log ya abierto en que la función escribirá, o bien NULL
log_level:	Nivel de información escrita por la función al fichero de log, en caso de que log_file!=NULL
modo_ajuste:	v. Aerotri_defs
modo_toma:		v. Aerotri_defs
modo_medida	v. Aerotri_defs

	En los siguientes nombres de ficheros, si el fichero no existe de ha de pasar NULL:
ficherof:		Nombre del fichero de fotogramas. Los de Aerotri suelen tener extensión .fmt
ficheroapr:	Fichero de valores aproximados. Suelen tener extensión .prm, o bien .ajs si se trata
					de los valores ajustados de un ajuste anterior.
ficheroapy:	Fichero con los puntos de apoyo.
ficherogps:	Fichero con datos gps e inerciales.
ficheroint:	Fichero de cámara
mar,prm,pym,gpn,int:		Formato de los ficheros anteriores. Véase lecturaf.h para sus posibles valores.
									Todos los ficheros son opcionales salvo el de fotogramas y el de valores aproximados.
tdapr:			Tipo de valores aproximados. 0=unos cualesquiera; 1=ajustados;
													 2=ajustados, procedentes de un ajuste configurado igual que el actual.
signoins:		Criterio signo para las rotaciones: 0/1. Suele ser siempre 1.
tdgps:			Tipo de datos gps, según los errores sistemáticos de cada pasada: 0=sin error; 1=error constante;
																								2=error lineal (deriva)
tdins:			Tipo de datos ins, según los errores sistemáticos de cada pasada: 0=sin error; 1=error constante;
																								2=error lineal (deriva);
boffgps:		Calcular un valor de desplazamiento único para el gps para todos los conjuntos
boffins:		Calcular un valor de desplazamiento único para el ins para todos los conjuntos

apriori			Precisiones a priori de los distintos conjuntos de datos. Si se pasa Infinity o NaN el programa asignará un valor por defecto
conjuntas		Véase clases_mainabsoluta.h
estimador		Véase clases_estimadores.h
profundidades	Algo muy técnico. Pásese 255 en todos los valores para que la función escoja los valores que considere oportuno
auto_calib:		0/1. Si se calculan o no parámetros de autocalibración
pInterna			Puntero a una estructura que indica qué parámetros de autocalibración calcular.
flags0				Se corresponden con opciones del archivo de trabajo. Pásese (8 | 2 | 1) en caso de duda.

sis:				Puntero a una estructura Sistema que define el sistema de coordenadas del apoyo y datos GPS/INS
uni:			Unidades de los giros: 0=radianes; 1=grados centesimales; 2=grados sexagesimales
Salida:		Estructura que indicá qué ficheros de salida se quieren y qué información se incluye en ellos
pfnúmero:	Función que toma un residuo normalizado y devuelve un valor desde 0 (residuo pequeño) hasta un valor máximo (por ejemplo, 10),
				según lo grande que es el residuo. Puede pasarse NULL, en cuyo caso se emplea en lugar de la función el array flimites
flimites		Array de límites para los distintos grupos de residuos normalizados, de acuerdo a lo grande que sean. Ha de cerrarse con un valor
				INFTY o NAN. Véanse ejemplos en predefined_limites, en ClaseTrabajo.h (pero ahí falta el NAN que lo cierre)
fill_gps		Si se aplican los parámetros de desviación (deriva) del gps/ins a fotocentros que aparecen en el fichero de gps pero que no
				se corresponden con fotografías calculadas (por ejemplo, porque solamente se midió una de cada dos fotos). Se calcula la corrección
				a aplicar y se escribe el valor ajustado en los distintos ficheros de valores ajustados.
				0: no interpolar; 1: interpolar; 2: interpolar y extrapolar, a fotocentros anteriores al primero o posteriores al último medidos, en cada pasada.
interp_resgps	Si además de lo anterior se suma una corrección resultado de interpolar los residuos de los fotocentros más próximos. En principio
					no se debería hacer.

pinfo:			Puntero a una estructura que la función rellenará con los resultados del ajuste. Se escribe cuando el valor
					devuelo es 0 o >=100.
					Posteriormente es necesario liberar la memoria. Para ello hay que llamar a free_plist(pinfo->plist);
mensaje:		Pasar un char16_t[512]. Si el valor devuelo es -1 mensaje puede contener cualquier cosa,
					así que en estos casos no se debe mostrar.
idioma:		Idioma para el mensaje de error. v. Aerotri_defs

For the return values, see clases_mainabsoluta.h
*/
#ifdef __cplusplus
extern "C"
#endif
int OUTSIDE_CALL mainabsoluta(Handler hwnd_main, int log_code, Bufferto8 *log_file,u16int log_level, u8int modo_ajuste, u8int modo_toma,u8int modo_medida,
											const char16_t* ficherof,u8int mar, const char16_t* ficheroapr,u8int prm, u8int tdapr, const char16_t* ficheroapy,u8int pym, const char16_t* ficherogps,u8int gpm,bint signoins, u8int tdgps,bint boffgps, u8int tdins,bint boffins, bint bgirok, const char16_t* ficheroint,u8int inm, u8int flags_generate,
											Precisiones apriori, EstimacionConjuntas conjuntas, Estimador_complejo estimador, Profundidades profundidades, bint auto_calib, AjbloqueConfigInterna* pInterna, uint flags0,
											Sistema* sis, s8int uni, AjbloqueConfigSalida Salida, u8int (*pfnumero)(float), float* flimites, u8int fill_gps, bint interp_resgps,
											FicheroBnf *pinfo, char16_t* mensaje, u8int idioma);
