﻿void texto_error_caracter(char16_t *pterror, uint grupo_n, char8_t *nombre, int cod_error, char8_t bad_char){
	if(cod_error<0){
		pterror=strpcpy16(pterror,S_(Engrupo));
		pterror=str16___uint(pterror,grupo_n);
		pterror=strbuild16(pterror,S_(Mientras),TEXTO_lecturaf(-cod_error),S_(seencontro),NULL);
	}else{
		pterror=strbuild_mixed(pterror,'w',S_(Enpunto),'c',nombre,'w',S_(Mientras),'w',TEXTO_lecturaf(cod_error),'w',S_(seencontro),0);
	}
	*pterror++=bad_char; strcpy16(pterror,S_(wasfound));
}

#define NO_HAY LEEGPS_TIPO_NODATA
#define Tipo_DEFAULT  LEEGPS_TIPO_DEFAULT
#undef if_inline_all
#define if_inline_all(x,cod) iflike_moreinl(buffer){ifnot_get_double_inline(buffer,x){cod_error=cod; goto error_caracter;}}

#define leegps_defaultgrupo(g) \
	default_values_GrupoGPS(g);\
	(g).tipoGPS=(g).tipoINS=Tipo_DEFAULT

#define leegps_defaultgps(g) \
	default_values_GPS(g);\
	(g).tipoGPS=(g).tipoINS=Tipo_DEFAULT

#define buffer (*pbuffer)
int lee_ficherogps_eo(Bufferti8 *pbuffer, int nchars, char16_t* pterror, Vector_GrupoGPSINS *grupos, Vector_PuntoGPSINS *gpss,Growing_char *nombres){
	int cod_error;
	GrupoGPSINS grupo;
	PuntoGPSINS GPS;
	Giro3D_double G;
	double ccpi_1;
	uint nguess;

	ccpi_1=-CCPI_1[ATUNIGIROS_Sex];

	leegps_defaultgrupo(grupo);
	leegps_defaultgps(GPS);

	advance(buffer);
	while(*buffer.pc=='#' || *buffer.pc==';' || *buffer.pc=='-' || *buffer.pc=='%') finishline_advance(buffer);
	if(*buffer.pc=='\0'){
		strbuild16(pterror,S_(Nocontienedatos),NULL);
		return ATREAD_NODATOS;
	}

	nguess=(nchars-(pdif)(buffer.pc-buffer.B.base))/138; //140
	Vsetup(PuntoGPSINS,*gpss,nguess,goto no_mem0);
	Vsetup(GrupoGPSINS,*grupos,4,goto no_mem1);
	advance_next(buffer);
	nguess*=(pdif)(buffer.next-buffer.pc)+1;
	nguess&=~31U; nguess+=32;		GC_initialize(*nombres,nguess,goto no_mem3);

	grupo.n=0;
	GPS.grupo=0;
	GPS.t=0;
	while(*buffer.pc!='\0'){
		get_stringGC_advanceinline(buffer,*nombres,GPS.index);
		if_inline_all(GPS.P.X,T_coorX);	if_inline_all(GPS.P.Y,T_coorY);	if_inline_all(GPS.P.Z,T_coorZ);
		if_inline_all(G.ω,T_Omega);		if_inline_all(G.φ,T_Phi);			if_inline_all(G.κ,T_Kappa)
		else{strbuild_mixed(pterror,'w',S_(Enpunto),'c',nombres->ppio+GPS.index,'w',S_(Faltancampos), 'w',u"X Y Z Ω Φ Kappa",0);
				return ATREAD_LINEA;}
		P_mul(G,ccpi_1);
		MatrizRot_ωφκ(G,GPS.M);
		Vadd(*gpss,PuntoGPSINS,GPS,goto salida_outofmem);
		grupo.n++;
		finishline_advance(buffer);
	}
	Vadd(*grupos,GrupoGPSINS,grupo,goto salida_outofmem);

	return 0;

error_caracter:
	texto_error_caracter(pterror,grupos->n+1,nombres->ppio+GPS.index,cod_error,*buffer.pc);
	return ATREAD_CARACTER;

	no_mem3:
free(grupos->ppio);		no_mem1:
free(gpss->ppio);			no_mem0:
gpss->ppio=NULL;
salida_outofmem:
	return AT_NOMEM;
}

int lee_ficherogps_TopoSys(Bufferti8 *pbuffer, int nchars, char16_t* pterror, Vector_GrupoGPSINS *grupos, Vector_PuntoGPSINS *gpss,Growing_char *nombres){
	int cod_error;
	GrupoGPSINS grupo;
	PuntoGPSINS GPS;
	Giro3D_double G;
	double ccpi_1;
	uint nguess;

	ccpi_1=CCPI_1[ATUNIGIROS_Sex];

	leegps_defaultgrupo(grupo);
	leegps_defaultgps(GPS);

	advance(buffer);
	while(*buffer.pc=='#') finishline_advance(buffer);
	if(*buffer.pc=='\0'){
		strbuild16(pterror,S_(Nocontienedatos),NULL);
		return ATREAD_NODATOS;
	}

	nguess=(nchars-(pdif)(buffer.pc-buffer.B.base))/144;	//148
	Vsetup(PuntoGPSINS,*gpss,nguess,goto no_mem0);
	Vsetup(GrupoGPSINS,*grupos,4,goto no_mem1);
	advance_next(buffer);
	nguess*=(pdif)(buffer.next-buffer.pc)+1;
	nguess&=~31U; nguess+=32;		GC_initialize(*nombres,nguess,goto no_mem3);

	grupo.n=0;
	GPS.grupo=0;
	while(*buffer.pc!='\0'){
		get_stringGC_advanceinline(buffer,*nombres,GPS.index);
		iflike_moreinl(buffer){ignore_advanceinline(buffer);}	//ID
		if_inline_all(GPS.t,T_tiempo);
		iflike_moreinl(buffer){ignore_advanceinline(buffer);}	//XGeoc
		iflike_moreinl(buffer){ignore_advanceinline(buffer);}	//YGeoc
		iflike_moreinl(buffer){ignore_advanceinline(buffer);}	//ZGeoc
		if_inline_all(G.ω,T_Roll);		if_inline_all(G.φ,T_Pitch);			if_inline_all(G.κ,T_Heading);
		if_inline_all(GPS.P.X,T_coorX);	//φ
		if_inline_all(GPS.P.Y,T_coorY);	//λ
		if_inline_all(GPS.P.Z,T_coorZ)	//H elipsóidica
		else{strbuild_mixed(pterror,'w',S_(Enpunto),'c',nombres->ppio+GPS.index,'w',S_(Faltancampos), 'w',u"\nNombre nº evento Xgeoc. Ygeoc. Zgeoc. Roll Pitch Heading Lat. Long. h",0);
				return ATREAD_LINEA;}
		P_mul(G,ccpi_1);
		MatrizRot_imu_r(G,GPS.M);
		Vadd(*gpss,PuntoGPSINS,GPS,goto salida_outofmem);
		grupo.n++;
		finishline_advance(buffer);
	}
	Vadd(*grupos,GrupoGPSINS,grupo,goto salida_outofmem);

	return 0;

error_caracter:
	texto_error_caracter(pterror,grupos->n+1,nombres->ppio+GPS.index,cod_error,*buffer.pc);
	return ATREAD_CARACTER;

	no_mem3:
free(grupos->ppio);		no_mem1:
free(gpss->ppio);			no_mem0:
gpss->ppio=NULL;
salida_outofmem:
	return AT_NOMEM;
}

int lee_ficherogps_MatchAT(Bufferti8 *pbuffer, int nchars, char16_t* pterror, Vector_GrupoGPSINS *grupos, Vector_PuntoGPSINS *gpss,Growing_char *nombres){
	int cod_error;
	GrupoGPSINS grupo;
	PuntoGPSINS GPS;
	Giro3D_double G;
	double ccpi_1;
	uint nguess;

	ccpi_1=-CCPI_1[ATUNIGIROS_Sex];
	leegps_defaultgrupo(grupo);
	leegps_defaultgps(GPS);
	GPS.t=0;

	char8_t* s;
	advance(buffer);
	for(;;buffer.pc=strseek8(buffer.pc,'\n')){
		const char8_t *ss;
		while(*buffer.pc!='\0' && *buffer.pc!=';' && *buffer.pc!='#') buffer.pc++;
		if(*buffer.pc=='\0') goto no_marca;
		if(*(buffer.pc-1)!='\n') continue;
		if(*buffer.pc!=';') break;
		ss="; Angular Units: ";
		while(*buffer.pc==*ss && *ss) buffer.pc++,ss++;
		if(!*ss){
			//Relies on 'D'!='G'!='R'
			ss="Degree "; while(*buffer.pc==*ss && *ss) buffer.pc++,ss++;		if(!*ss){ccpi_1=-CCPI_1[ATUNIGIROS_Sex]; break;}
			ss="Gon "; while(*buffer.pc==*ss && *ss) buffer.pc++,ss++;			if(!*ss){ccpi_1=-CCPI_1[ATUNIGIROS_Gon]; break;}
			ss="Radian "; while(*buffer.pc==*ss && *ss) buffer.pc++,ss++;		if(!*ss){ccpi_1=-CCPI_1[ATUNIGIROS_Rad]; break;}
		}
	}
	buffer.pc=get_codigo8(buffer.pc,"# LINE");
	if(*buffer.pc=='\0'){
no_marca:
		strbuild16(pterror,S_(Faltamarca),u"# LINE",S_(queindica),S_(delos_grupos),NULL);
		return ATREAD_NODATOS;
	}

	nguess=(nchars-(pdif)(buffer.pc-buffer.B.base))/83;
	s=buffer.pc-7;
	while(s!=buffer.B.base && (*s!='E' || *(s+1)!='v')) s--;
	if(s!=buffer.B.base){
		uint t;
		while(s!=buffer.B.base && (*--s<'0' || *s>'9')); s[1]='\0';
		while(*--s>='0' && *s<='9'); s++;
		t=uint___str8(cast_pc_addr(s));
		if(5*t<6*nguess) nguess=t;
	}

	for(;;){
		GPS.grupo=grupos->n;
		grupo.n=0;
		finishline_advance(buffer);
		if(gpss->ppio==NULL && *buffer.pc!='#' && *buffer.pc!='\0'){
			uint t=nguess&~7U; t+=8;		Vsetup(PuntoGPSINS,*gpss,t,goto no_mem0);
			t=nguess/20; t&=~3U; t+=4;		Vsetup(GrupoGPSINS,*grupos,t,goto no_mem1);
			advance_next(buffer);
			nguess*=(pdif)(buffer.next-buffer.pc)+1;
			nguess&=~31U; nguess+=32;		GC_initialize(*nombres,nguess,goto no_mem3);
		}
		while(*buffer.pc!='#' && *buffer.pc!='\0'){
			get_stringGC_advanceinline(buffer,*nombres,GPS.index);
			if_inline_all(GPS.P.X,T_coorX);	if_inline_all(GPS.P.Y,T_coorY);	if_inline_all(GPS.P.Z,T_coorZ);
			if_inline_all(G.ω,T_Omega);		if_inline_all(G.φ,T_Phi);			if_inline_all(G.κ,T_Kappa)
			else{strbuild_mixed(pterror,'w',S_(Enpunto),'c',nombres->ppio+GPS.index,'w',S_(Faltancampos), 'w',u"X Y Z Ω Φ Kappa",0);
					return ATREAD_LINEA;}
			P_mul(G,ccpi_1);
			MatrizRot_ωφκ(G,GPS.M);
			Vadd(*gpss,PuntoGPSINS,GPS,goto salida_outofmem);
			grupo.n++;
			finishline_advance(buffer);
		}
		if(grupo.n){
			Vadd(*grupos,GrupoGPSINS,grupo,goto salida_outofmem);
		}
		buffer.pc=get_codigo8(buffer.pc,"# LINE");
		if(*buffer.pc=='\0') break;
	}
	return 0;

no_mem3:
free(grupos->ppio); no_mem1:
free(gpss->ppio); no_mem0:
gpss->ppio=NULL;
salida_outofmem:
	return AT_NOMEM;

error_caracter:
	texto_error_caracter(pterror,grupos->n+1,nombres->ppio+GPS.index,cod_error,*buffer.pc);
	return ATREAD_CARACTER;
}

int lee_ficherogps_Aerotri(Bufferti8 *pbuffer, int nchars, char16_t* pterror, Vector_GrupoGPSINS *grupos, Vector_PuntoGPSINS *gpss,Growing_char *nombres, bint signoins, u8int limpio, Vector_PesoCP *pesos, Vector_GrupoGPSextras *gruposextras, float σgpsXY,float σgpsZ, float σinsΩΦ,float σinsK){
	int cod_error;
	bint nohayins;
	GrupoGPSINS grupo;
	PuntoGPSINS GPS;
	Giro3D_double G;
	PuntoXYZ_double offset;
	double ccpi_1;
	bint modoins;	//0 ins, 1 imuuint	//Global para usar en los casos de error
	GrupoGPSextras grupoextra, gdefault={Я,Я,0,0};
	uint nguess;

	nohayins=(bint)(σinsΩΦ==0 || σinsK==0);
	σinsΩΦ*=(float)CCPI[ATUNIGIROS_Sex];
	σinsK*=(float)CCPI[ATUNIGIROS_Sex];
	ccpi_1=CCPI_1[ATUNIGIROS_Sex];

	if(signoins) ccpi_1=-ccpi_1;
	default_values_GrupoGPS(grupo);
	default_values_GPS(GPS);

	buffer.pc--;
	do{
		bint b;
		finishline_advance(buffer); prepare_string(buffer);
		if(*buffer.pc=='\0'){
			strbuild16(pterror,S_(Ningunamarca),u"-gps, -gpsins, -gpsimu, -ins, -imu",S_(queindican),S_(delos_grupos),NULL);
			return ATREAD_NODATOS;
		}
		b=(bint)(strcmp8(buffer.pc,"-gps") && strcmp8(buffer.pc,"-gpsins") && strcmp8(buffer.pc,"-gpsimu") && strcmp8(buffer.pc,"-ins") && strcmp8(buffer.pc,"-imu"));
		*buffer.next=buffer.savedchar;
		if(!b) break;
	}while(1);

	nguess=nchars-(pdif)(buffer.pc-buffer.B.base);
	nguess=(uint)(nguess*0.0087F);

	for(;;){
		if(*buffer.pc=='\0') break;
		GPS.grupo=grupos->n;
		prepare_string(buffer);
		if(strcmp8(buffer.pc,"-gps") && nohayins){
			const char16_t *s;
			switch(idioma){
				case 1:  s=u"Precision values for the INS must be specified"; break;
				case 2:  s=u"Deve indicare i valori di precisione dell'INS"; break;
				default:s=u"Debe indicar los valores de precisión del INS";
			}
			strcpy16(mensaje,s);
			goto salida_otro;
		}
		{bint b=0;
		if(strcmp8(buffer.pc,"-ins")==0 || strcmp8(buffer.pc,"-imu")==0){
			b=1; grupo.tipoINS=Tipo_DEFAULT;
			grupo.tipoGPS=NO_HAY;
			if(strcmp8(buffer.pc,"-ins")==0) modoins=0;
			else modoins=1;
		}else{
			grupo.tipoGPS=Tipo_DEFAULT;
			if(strcmp8(buffer.pc,"-gps")==0){b=1; grupo.tipoINS=NO_HAY;}
			elif(strcmp8(buffer.pc,"-gpsins")==0){b=1; grupo.tipoINS=Tipo_DEFAULT; modoins=0;}
			elif(strcmp8(buffer.pc,"-gpsimu")==0){b=1; grupo.tipoINS=Tipo_DEFAULT; modoins=1;}
		}
		if(!b){
			resume(buffer);
			do{ finishline_advance(buffer);
			}while(*buffer.pc!='\0' && *buffer.pc!='-');
			continue;
		}}
		resume_advance(buffer);

		grupoextra=gdefault;
		offset.X=offset.Y=offset.Z=0;
		for(;;){
			const char8_t *s;
			//los formatos antiguos tenían el offset de antena escrito aquí
			//y puedo suponer que alguno de esos valores empieza por 0 -- 9
			//(total, oficialmente ya no se soportan)
			if(*buffer.pc>='0' && *buffer.pc<='9') break;
			s=buffer.pc;
			key_advance(&buffer);
			if(*buffer.pc=='\0') break;
			if(strcmp8(s,"gpsoffset")==0){
				if(*buffer.pc=='?'){
					grupoextra.calculaoffsetGPS=1;
					ignore_advance(buffer);
				}else{
					ifnot_get_double(buffer,offset.X){cod_error=-T_offsetX; goto error_caracter;}
					ifnot_get_double(buffer,offset.Y){cod_error=-T_offsetY; goto error_caracter;}
					ifnot_get_double(buffer,offset.Z){cod_error=-T_offsetZ; goto error_caracter;}
				}
			}elif(strcmp8(s,"insoffset")==0 || strcmp8(s,"imuoffset")==0 ){
				if(*buffer.pc=='?'){
					grupoextra.calculaoffsetINS=1;
					ignore_advance(buffer);
				}else{
					ignore_advance(buffer);	ignore_advance(buffer);	ignore_advance(buffer);
				}
			}elif(strcmp8(s,"tipogps")==0){
				if(grupo.tipoGPS!=NO_HAY){
					ifnot_get_advance(buffer,grupo.tipoGPS,(umint)uint___str8){cod_error=-T_tipogps; goto error_caracter;}
					if(grupo.tipoGPS>2){buffer.pc=buffer.next-1; cod_error=-T_Tipogpsentre;	goto error_valor;}
				}else{
					ignore_advance(buffer);
				}
			}elif(strcmp8(s,"tipoins")==0){
				if(grupo.tipoINS!=NO_HAY){
					ifnot_get_advance(buffer,grupo.tipoINS,(umint)uint___str8){cod_error=-T_tipoins; goto error_caracter;}
					if(grupo.tipoINS>2){buffer.pc=buffer.next-1; cod_error=-T_Tipoinsentre;	goto error_valor;}
				}else{
					ignore_advance(buffer);
				}
			}elif(strcmp8(s,"grupogps")==0){	//-2 significa el mismo que el anterior
				if(grupo.tipoGPS!=NO_HAY){
					ifnot_get_advance(buffer,grupoextra.insiemegps,uint___str8){cod_error=-T_grupogps; goto error_caracter;}
				}else{
					ignore_advance(buffer);
				}
			}elif(strcmp8(s,"grupoins")==0 || strcmp8(s,"grupoimu")==0){
				if(grupo.tipoINS!=NO_HAY){
					ifnot_get_advance(buffer,grupoextra.insiemeins,uint___str8){cod_error=-T_grupoins; goto error_caracter;}
				}else{
					ignore_advance(buffer);
				}
			}else{
				ignore_advance(buffer);
			}
			if(*buffer.pc=='\0') break;
		}
		if(*buffer.pc=='\0') goto eof_in_grupo;

		GPS.tipoGPS=grupo.tipoGPS;
		GPS.tipoINS=grupo.tipoINS;
		GPS.offset=grupo.offset=offset;

		grupo.bg=grupo.tipoGPS==NO_HAY? 0:1;
		grupo.bi=grupo.tipoINS==NO_HAY? 0:1;
		if(1){
			umint naux, nauxb;
			naux=*buffer.pc++;
			if(*buffer.pc!='\n' && *buffer.pc!=' ' && *buffer.pc!='\t') naux=NO_HAY;
			if(naux!='0' && naux!='1'){cod_error=-T_Lamarca0o1;	goto error_valor;}
			if(grupo.tipoGPS!=NO_HAY && grupo.tipoINS!=NO_HAY){
				advance(buffer);
				if(*buffer.pc=='\0') goto eof_in_grupo;
				nauxb=*buffer.pc++;
				if(*buffer.pc!='\n' && *buffer.pc!=' ' && *buffer.pc!='\t') nauxb=NO_HAY;
				if(nauxb!='0' && nauxb!='1'){cod_error=-T_Lamarca0o1;	goto error_valor;}
			}else{nauxb='0';}

			if(grupo.tipoGPS!=NO_HAY){
				grupo.bg=naux&1;
				if(grupo.tipoINS!=NO_HAY)
					grupo.bi=nauxb&1;
			}else{
				grupo.bi=naux&1;
			}
		}
		grupo.n=0;
		grupo.peso=0;
		advancecare(buffer);
		if(grupo.bg==0 && grupo.bi==0 && limpio){
			ifinline_finishline(buffer); advance(buffer);
			while(*buffer.pc!='\0' && *buffer.pc!='-'){finishline_advance(buffer);}
			continue;
		}
		if(*buffer.pc==';') goto h_g_peso;
	back_g_peso:
		ifinline_finishline_advance_toname(buffer);

		if(gpss->ppio==NULL && *buffer.pc!='-' && *buffer.pc!='\0'){
			uint t=nguess&~7U; t+=8;		Vsetup(PuntoGPSINS,*gpss,t,goto no_mem0);
			t=nguess/20; t&=~3U; t+=4;		Vsetup(GrupoGPSINS,*grupos,t,goto no_mem1);
													Vsetup(GrupoGPSextras,*gruposextras,t,goto no_mem2);
			advance_next(buffer);
			nguess*=(pdif)(buffer.next-buffer.pc)+1;
			nguess&=~31U; nguess+=32;
			GC_initialize(*nombres,nguess,return AT_NOMEM);
		}
		while(*buffer.pc!='\0' && *buffer.pc!='-'){
			get_stringGC_advance(buffer,*nombres,GPS.index);
			if(GPS.tipoGPS!=NO_HAY){
				ifnot_get_double(buffer,GPS.P.X){cod_error=T_coorX; goto error_caracter;}
				ifnot_get_double(buffer,GPS.P.Y){cod_error=T_coorY; goto error_caracter;}
				ifnot_get_double(buffer,GPS.P.Z){cod_error=T_coorZ; goto error_caracter;}
			}
			if(GPS.tipoINS!=NO_HAY){
				ifnot_get_double(buffer,G.ω){cod_error=T_Omega; goto error_caracter;}
				ifnot_get_double(buffer,G.φ){cod_error=T_Phi; goto error_caracter;}
				ifnot_get_double(buffer,G.κ){cod_error=T_Kappa; goto error_caracter;}
				double aux;
				if(modoins==0 || !signoins) aux=ccpi_1;
				else aux=-ccpi_1;	//deshacer el cambio
				P_mul(G,aux);
				if(modoins==0) MatrizRot_ωφκ(G,GPS.M);
				else MatrizRot_imu_r(G,GPS.M);
			}
			ifnot_get_stay(buffer,GPS.t,vfdouble___str8){cod_error=T_tiempo; goto error_caracter;}
			if(1) advance(buffer);
			if(*buffer.pc=='\0') goto eof_in_punto;
			GPS.bg=GPS.tipoGPS==NO_HAY? 0:1;
			GPS.bi=GPS.tipoINS==NO_HAY? 0:1;
			if(1){
				umint naux,nauxb;
				naux=*buffer.pc++;
				if(*buffer.pc!='\n' && *buffer.pc!=' ' && *buffer.pc!='\t') naux=255;
				if(naux!='0' && naux!='1'){cod_error=T_Lamarca0o1;	goto error_valor;}
				if(grupo.tipoGPS!=NO_HAY && grupo.tipoINS!=NO_HAY){
					advance(buffer);
					if(*buffer.pc=='\0') goto eof_in_punto;
					nauxb=*buffer.pc++;
					if(*buffer.pc!='\n' && *buffer.pc!=' ' && *buffer.pc!='\t') nauxb=255;
					if(nauxb!='0' && nauxb!='1'){cod_error=T_Lamarca0o1;	goto error_valor;}
				}else{nauxb='0';}

				if(GPS.tipoGPS!=NO_HAY){
					GPS.bg=naux&1;
					if(GPS.tipoINS!=NO_HAY)
						GPS.bi=nauxb&1;
				}else{
					GPS.bi=naux&1;
				}
			}
			GPS.peso=grupo.peso;
			advancecare(buffer);
			if(limpio>1 && (GPS.bg<grupo.bg || GPS.bi<grupo.bi) &&
				(limpio>2 || ((GPS.bg&grupo.bg)==0 && (GPS.bi&grupo.bi)==0)) ){
				ifinline_finishline_advance_toname(buffer); continue;
			}
			if(*buffer.pc==';') goto h_peso;
		back_peso:
			Vadd(*gpss,PuntoGPSINS,GPS,goto salida_outofmem);
			grupo.n++;
			ifinline_finishline_advance_toname(buffer);
		}
		if(grupo.n){
			Vadd(*grupos,GrupoGPSINS,grupo,goto salida_outofmem);
			Vadd(*gruposextras,GrupoGPSextras,grupoextra,goto salida_outofmem);
		}
	}
	return 0;

h_g_peso:
	if(pesos!=NULL){
		if(pesos->ppio==NULL){
			Vsetup(PesoCP,*pesos,4,goto salida_outofmem);
			NOTFINITE_f(pesos->ppio->p.X); NOTFINITE_f(pesos->ppio->p.Y); NOTFINITE_f(pesos->ppio->p.Z);
			pesos->ppio->g=pesos->ppio->p;
			pesos->n=1;
		}
		{PesoCP *ppeso;
		uint k;
		Venlarge_one(*pesos,PesoCP,ppeso,goto salida_outofmem);
		defaultvalues_pesoCP(*ppeso);

		k=-1;
		while(*buffer.pc==';'){
			while(*buffer.pc==';'){
				k++;
				buffer.pc++;
				advancecare(buffer);
			}
			if(*buffer.pc=='\0') goto eof_in_grupo;
			ifnlpassed(buffer) goto no_peso_grupo;

			float faux;
			ifnot_get_peso(buffer,faux){cod_error=-T_unaprec; goto error_caracter;}
			switch(k){
			case 0:
				if(grupo.tipoGPS!=NO_HAY) ppeso->p.Y=ppeso->p.X=faux/σgpsXY;
				else ppeso->g.ω=ppeso->g.φ=faux/σinsΩΦ;
				break;
			case 1:
				if(grupo.tipoGPS!=NO_HAY) ppeso->p.Z=faux/σgpsZ;
				else ppeso->g.κ=faux/σinsK;
				break;
			case 2:
				if(grupo.tipoGPS==NO_HAY || grupo.tipoINS==NO_HAY) k=100;
				else ppeso->g.ω=ppeso->g.φ=faux/σinsΩΦ;
				break;
			case 3:
				if(grupo.tipoGPS==NO_HAY || grupo.tipoINS==NO_HAY) k=100;
				else ppeso->g.κ=faux/σinsK;
				break;
			default:
				k=100;
			}
			ifunlike(k==100){
				pterror=strpcpy16(pterror,S_(Engrupo));
				pterror=str16___uint(pterror,grupos->n+1);
				strcpy16(pterror,S_(Demasiadosptc));
				return ATREAD_BADFORMAT;
			}
			if(P_iseq(ppeso->p,==,(ppeso-1)->p) && P_iseq(ppeso->g,==,(ppeso-1)->g)) pesos->n--;
			grupo.peso=pesos->n-1;
			advancecare(buffer);
		}}
	}else{
		skip_pesos(buffer);
	}
goto back_g_peso;

h_peso:
	if(pesos!=NULL){
		PesoCP *ppeso;
		uint k;
		if(pesos->ppio==NULL){
			Vsetup(PesoCP,*pesos,4,goto salida_outofmem);
			NOTFINITE_f(pesos->ppio->p.X); NOTFINITE_f(pesos->ppio->p.Y); NOTFINITE_f(pesos->ppio->p.Z);
			pesos->ppio->g=pesos->ppio->p;
			pesos->n=1;
		}
		Venlarge_one(*pesos,PesoCP,ppeso,goto salida_outofmem);
		defaultvalues_pesoCP(*ppeso);

		k=-1;
		while(*buffer.pc==';'){
			while(*buffer.pc==';'){
				k++;
				buffer.pc++;
				advancecare(buffer);
			}
			if(*buffer.pc=='\0') goto eof_in_punto;
			ifnlpassed(buffer) goto no_peso;

			float faux;
			ifnot_get_peso(buffer,faux){cod_error=T_unaprec; goto error_caracter;}
			switch(k){
			case 0:
				if(GPS.tipoGPS!=NO_HAY) ppeso->p.Y=ppeso->p.X=faux/σgpsXY;
				else ppeso->g.ω=ppeso->g.φ=faux/σinsΩΦ;
				break;
			case 1:
				if(GPS.tipoGPS!=NO_HAY) ppeso->p.Z=faux/σgpsZ;
				else ppeso->g.κ=faux/σinsK;
				break;
			case 2:
				if(GPS.tipoGPS==NO_HAY || GPS.tipoINS==NO_HAY) k=100;
				else ppeso->g.ω=ppeso->g.φ=faux/σinsΩΦ;
				break;
			case 3:
				if(GPS.tipoGPS==NO_HAY || GPS.tipoINS==NO_HAY) k=100;
				else ppeso->g.κ=faux/σinsK;
				break;
			default:
				k=100;
			}
			if(k==100){
				strbuild_mixed(pterror,'w',S_(Enpunto),'c',nombres->ppio+GPS.index,'w',S_(Demasiadosptc),0);
				return ATREAD_BADFORMAT;
			}
			if(grupo.peso!=pesos->n-2 && (P_iseq(ppeso->p,==,(ppeso-1)->p) && P_iseq(ppeso->g,==,(ppeso-1)->g)) ) pesos->n--;
			GPS.peso=pesos->n-1;
			advancecare(buffer);
		}
	}else{
		skip_pesos(buffer);
	}
goto back_peso;

/*long_name:
	buffer.pc[21]='.'; buffer.pc[22]='.'; buffer.pc[23]='.'; buffer.pc[24]='\0';
	strbuild_mixed(pterror,'w',S_(Nombregpslargo),'c',buffer.pc,0);
	goto salida_otro;*/
eof_in_grupo:
	pterror=strbuild16(pterror,SS_Eof_in_grupo,NULL);
	pterror=str16___uint(pterror,grupos->n+1);
	strpcpy16(pterror,S_(eof_header));
	return ATREAD_EOF;
eof_in_punto:
	strbuild_mixed(pterror,'w',wSS_Eof_in_punto,'c',nombres->ppio+GPS.index,0);
	return ATREAD_EOF;
error_caracter:
	if(cod_error>0){
		if(modoins && cod_error>=T_Omega && cod_error<=T_Kappa) cod_error+=T_Roll-T_Omega;
	}
	texto_error_caracter(pterror,grupos->n+1,nombres->ppio+GPS.index,cod_error,*buffer.pc);
	return ATREAD_CARACTER;
error_valor:
	isolate_word(buffer);
	if(cod_error<0){
		pterror=strpcpy16(pterror,S_(Engrupo));
		pterror=str16___uint(pterror,grupos->n+1);
		cod_error=-cod_error;
	}else{
		pterror=strbuild_mixed(pterror,'w',S_(Enpunto),'c',nombres->ppio+GPS.index,0);
	}
	pterror=strbuild_mixed(pterror,'w',TEXTO_lecturaf(cod_error),'w',S_(ensulugar),'c',buffer.pc,0);
	return ATREAD_RANGE;
no_peso_grupo:
	pterror=strpcpy16(pterror,S_(Engrupo));
	pterror=str16___uint(pterror,grupos->n+1);
	strbuild16(pterror,S_(Finaldelinea),S_(buscaba_unaprec),NULL);
	return ATREAD_LINEA;
no_peso:
	strbuild_mixed(pterror,'w',S_(Enpunto),'c',nombres->ppio+GPS.index,'w',S_(Finaldelinea),'w',S_(buscaba_unaprec),0);
	return ATREAD_LINEA;

salida_otro: return 8;

no_mem2:
free(grupos->ppio);		no_mem1:
free(gpss->ppio);			no_mem0:
gpss->ppio=NULL;
salida_outofmem:
return AT_NOMEM;
}
#undef buffer

int lee_ficherogps(const char16_t* ficherogps, u8int *gpm, bint signoins, u8int limpio, Vector_GrupoGPSINS *grupos, Vector_PuntoGPSINS *gpss,char8_t* *pnombres,Vector_PesoCP *pesos, Vector_GrupoGPSextras *gruposextras, s8int *dec, float σgpsXY,float σgpsZ, float σinsΩΦ,float σinsK){
	int nret;
	Bufferti8 buffer;
	int nchars;
	char16_t* pterror;
	Growing_char nombres;

	gpss->ppio=NULL;
	grupos->ppio=NULL;
	grupos->n=gpss->n=0;
	if(pesos!=NULL){pesos->ppio=NULL; pesos->n=0;}
	nombres.ppio=NULL;
	if(gruposextras!=NULL){gruposextras->ppio=NULL; gruposextras->n=0;}
	if(dec!=NULL) *dec=0;

	{const char16_t *pfich;
	path_get_filename16(ficherogps,pfich);
	nchars=tiopen_mixed(&buffer,ficherogps);
	ifunlike(nchars<0){
		ifunlike(nchars==AT_NOMEM) return ATREAD_NOOPEN_MEM;
		open_file_err_str16(nchars,mensaje,pfich,idioma);
		return ATREAD_NOOPEN;
	}
	pterror=strbuild16(mensaje,pfich,u"\n\n",NULL);
	}

	switch(*gpm){
		case CCPPFORMAT_AerotriGPS: nret=lee_ficherogps_Aerotri(&buffer,nchars,pterror,grupos,gpss,&nombres,signoins, limpio, pesos, gruposextras, σgpsXY,σgpsZ,σinsΩΦ,σinsK); break;
		case CCPPFORMAT_ΩΦΚ: nret=lee_ficherogps_eo(&buffer,nchars,pterror,grupos,gpss,&nombres); break;
		case CCPPFORMAT_TopoSys: nret=lee_ficherogps_TopoSys(&buffer,nchars,pterror,grupos,gpss,&nombres); break;
		case CCPPFORMAT_MatchAT: nret=lee_ficherogps_MatchAT(&buffer,nchars,pterror,grupos,gpss,&nombres); break;
		default: strcpy16(pterror,S_(Formatodesconocido)); nret=ATREAD_UNKNOWNFORMAT;
	}
	ticlose(buffer);

	if(gpss->ppio!=NULL){
		*nombres.next='\0'; *pnombres=nombres.ppio;
		if(dec!=NULL){
			PuntoGPSINS* ptr=gpss->ppio;
			dontimes((gpss->n+7)>>3,ptr+=8){
				s8int sa;
				if((sa=ndecimales_P(ptr->P))>*dec) *dec=sa;
		}	}
	}
	if(gruposextras!=NULL && *gpm!=CCPPFORMAT_AerotriGPS && grupos->n!=0){
		Vsetup(GrupoGPSextras,*gruposextras,grupos->n,return AT_NOMEM);
		gruposextras->n=grupos->n;
		durchVectori(GrupoGPSextras,*gruposextras){
			*ptri=(GrupoGPSextras){Я,Я,0,0};
		}
	}
	return nret;
}

void escribe_pesosgps(Bufferto8 *fo, umint tipoGPS,umint tipoINS, PesoCP *ppeso, float σgpsXY,float σgpsZ, float σinsΩΦ,float σinsK);
#define fo (&_fo)
int escribe_gpm(const char16_t* ficherogps, GrupoGPSINS* grupos,uint ngrupos, PuntoGPSINS* gpss,uint _unused(ngps), PesoCP *pesos, s8int decp, u8int marca, float σgpsXY, float σgpsZ, float σinsΩΦ, float σinsK){
	int nret;
	Bufferto8 _fo;
	double ccpi;
	s8int decg;
	GrupoGPSINS* pungrupo;
	PuntoGPSINS* pungps;

	ccpi=CCPI[ATUNIGIROS_Sex];
	σinsΩΦ*=(float)ccpi;
	σinsK*=(float)ccpi;

	decg=5;
	if(ccpi>50) decg=4;
	elif(ccpi<5) decg=6;

	nret=toopen_mixed(fo,ficherogps);
	ifunlike(nret){
		char16_t* pc=strbuild16(mensaje,S_Elfichero,ficherogps,S_no_se_pudo_abrir_para_escribir,NULL);
		strcpy16(pc,TEXTOS_fileopen[nret][idioma]);
		return nret;
	}
	fo->prec.absol=decg;
	pungrupo=grupos;
	pungps=gpss;
	dontimes(ngrupos,pungrupo++){
		{u8int k;
		const char8_t *s;
		k=0;
		if(pungrupo->tipoGPS!=NO_HAY) k=1;
		if(pungrupo->tipoINS!=NO_HAY) k|=2;
		switch(k){
			case 3: s="-gpsins "; break;
			case 2: s="-ins "; break;
			case 1: default: s="-gps "; break;
		}
		towrite8_string(fo,s);
		}
		{PuntoXYZ_double P=pungrupo->offset;
		if(P.X!=0 || P.Y!=0 || P.Z!=0){
			towrite8_string(fo,"gpsoffset=");
			towrite_aligned_double(fo,P.X,9);
			toput_char(fo,' '); towrite_aligned_double(fo,P.Y,9);
			toput_char(fo,' '); towrite_aligned_double(fo,P.Z,9);
		}}
		if(pungrupo->tipoGPS<Tipo_DEFAULT){
			towrite8_string(fo,"  tipogps=");
			towrite_uint(fo,pungrupo->tipoGPS);
		}
		if(pungrupo->tipoINS<Tipo_DEFAULT){
			towrite8_string(fo,"  tipoins=");
			towrite_uint(fo,pungrupo->tipoINS);
		}
		if(marca){
			towrite8_string(fo,"  ");
			if(pungrupo->tipoGPS!=NO_HAY){toput_char(fo,' '); toput_char(fo,'0'+pungrupo->bg);}
			if(pungrupo->tipoINS!=NO_HAY){toput_char(fo,' '); toput_char(fo,'0'+pungrupo->bi);}
		}

		if(pesos!=NULL && pungrupo->peso!=0){
			setbuf_relative(fo); setbuf_limpio(fo); fo->prec.signi=3;
			escribe_pesosgps(fo,pungrupo->tipoGPS,pungrupo->tipoINS,pesos+pungrupo->peso,σgpsXY,σgpsZ,σinsΩΦ,σinsK);
			setbuf_absolute(fo); setbuf_nolimpio(fo);
		}
		toput_char(fo,'\n');
		dontimes(pungrupo->n,pungps++){
			towrite8_aligned_string(fo,pungps->nom,9); toput_char(fo,' ');
			if(pungps->tipoGPS!=NO_HAY){
				fo->prec.absol=decp;
				towrite8_aligned_double(fo,pungps->P.X,13); toput_char(fo,' ');
				towrite8_aligned_double(fo,pungps->P.Y,13); toput_char(fo,' ');
				towrite8_aligned_double(fo,pungps->P.Z,13); toput_char(fo,' ');
			}
			if(pungps->tipoINS!=NO_HAY){
				Giro3D_double G=Gmatriz_ωφκ_seg(pungps->M);
				P_mul(G,ccpi);
				fo->prec.absol=decg;
				towrite8_aligned_double(fo,G.ω,13); toput_char(fo,' ');
				towrite8_aligned_double(fo,G.φ,13); toput_char(fo,' ');
				towrite8_aligned_double(fo,G.κ,13); toput_char(fo,' ');
			}
			fo->prec.absol=4;
			towrite_aligned_double(fo,pungps->t,13);
			if(marca){
				towrite8_string(fo,"  ");
				if(pungps->tipoGPS!=NO_HAY){toput_char(fo,' '); toput_char(fo,'0'+pungps->bg);}
				if(pungps->tipoINS!=NO_HAY){toput_char(fo,' '); toput_char(fo,'0'+pungps->bi);}
			}

			if(pesos!=NULL && pungps->peso!=pungrupo->peso){
				setbuf_relative(fo); setbuf_limpio(fo); fo->prec.signi=3;
				escribe_pesosgps(fo,pungrupo->tipoGPS,pungrupo->tipoINS,pesos+pungps->peso,σgpsXY,σgpsZ,σinsΩΦ,σinsK);
				setbuf_absolute(fo); setbuf_nolimpio(fo);
			}
			toput_char(fo,'\n');
		}
	}
	toclose(fo);
	ifunlike(fo->error_code){
		strbuild16(mensaje,S_Hubo_un_error_al_escribir_el_fichero,ficherogps,S_El_fichero_generado_no_es_correcto,NULL);
	}
	return fo->error_code;
}
#undef fo

void escribe_pesosgps(Bufferto8 *fo, umint tipoGPS,umint tipoINS, PesoCP *ppeso, float σgpsXY,float σgpsZ, float σinsΩΦ,float σinsK){
	u8int k=0;
	if(tipoGPS!=NO_HAY && (ppeso->p.X!=1 || ppeso->p.Z!=1)){
		toput_char(fo,' ');
		if(ppeso->p.X!=1){towrite8_string(fo," ;"); towrite8_float(fo,ppeso->p.X*σgpsXY); k=1;}
		if(ppeso->p.Z!=1){
			if(!k) towrite8_string(fo," ;");
			towrite8_string(fo," ;"); towrite8_float(fo,ppeso->p.Z*σgpsZ);
			k=2;
		}
	}
	if(tipoINS!=NO_HAY && (ppeso->g.ω!=1 || ppeso->g.κ!=1)){
		if(tipoGPS!=NO_HAY){
			if(k==0) toput_char(fo,' ');
			for(;k<2;k++) towrite8_string(fo," ;");
		}
		toput_char(fo,' ');
		if(ppeso->g.ω!=1){towrite8_string(fo," ;"); towrite8_float(fo,ppeso->g.ω*σinsΩΦ); k=3;}
		if(ppeso->g.κ!=1){
			if(k!=3) towrite8_string(fo," ;");
			towrite8_string(fo," ;"); towrite8_float(fo,ppeso->g.κ*σinsK);
			k=4;
		}
	}
}
#undef NO_HAY
#undef Tipo_DEFAULT
