﻿typedef struct{
	u8int _idioma;
	const char16_t* const *_LTEXTOS;
	char16_t* _mensaje;
	uint _flags0;	//thre is currently just one flag. If the lowest bit is set, when reading rotations the three values are stored as they are
					//in the first row of the matrix, and when written they are taken from there. Also, the value of ccpi is not applied to σΩΦ, K
	const char8_t* _keyvals[16];	//up to seven pairs (eighth must be NULL)
	void* stuff1;
	void* stuff2;
} LecturafGlobal;

#define idioma global._idioma
#define mensaje global._mensaje
#define flags0 global._flags0
#define keyvals global._keyvals
#define NKEYPAIRS 7

static _Thread_local LecturafGlobal global;

void lecturaf_set_globals(u8int _idioma, char16_t* _mensaje, uint _flags0){
	if(_idioma>MAX_IDIOMA) _idioma=0;
	global._idioma=_idioma;
	global._LTEXTOS=LTEXTOS_lecturaf[_idioma];
	global._mensaje=_mensaje;
	global._flags0=_flags0;
}
