#ifdef __cplusplus
extern "C"{
#endif

	/*Busca str2 en cp y devuelve la posición en la que está, o un puntero al '\0' del final si str2 no se encuentra*/
char8_t* strstr8(iconst char8_t* cp,const char8_t* str2);
char16_t* strstr16(iconst char16_t * cp,const char16_t * str2);

/*Busca la cadena "marca" al comienzo de una línea y el valor devuelto apunta al comienzo de la palabra siguiente.
Si en la línea no hay ninguna palabra tras la marca apuntará al '\n' del final de línea. Si la marca "marca" no está
en el fichero el valor devuelo apuntará al '\0' del final de fichero.*/
char8_t* get_codigo8(iconst char8_t* pc,const char8_t* marca);
char16_t* get_codigo16(iconst char16_t* pc,const char16_t* marca);

/*Prepares a key in a key/val pair. The line syntax must be

<key>[blanks]=[blanks]<value(s)>

blanks on either side of the equal sign are optional. When passed to this function, buf->pc
must point to the beginning of <key>.

c_char: This is the file's comment char. If there is none, '\n' should be passed in this parameter.

<key> must be composed of a single word, viz. without blanks within it. If several
blank-separated words appear in the line before an '=' sign the function will not
work properly. Just don't do that.

    If there is no '=' sign in the line (before any instance of a c_char) the function does nothing
and returns NULL. Otherwise it returns a pointer to the name of the key, which is left
'\0'-terminated, and leaves buf->pc pointing to the value, i.e., the first word after the '=' sign.
If there is no such word buf->pc will point to a '\n' or a c_char.*/
char8_t* codigo_advance(iconst char8_t* pc,const char8_t* marca, const int nw);
char8_t* prepare_key8(Bufferti8 *buf, const char8_t c_char);
char16_t* prepare_key16(Bufferti16 *buf, const char16_t c_char);
void key_advance(Bufferti8 *buffer);

#ifdef __cplusplus
}
#endif

/*************--------      Inline functions      --------*************/

/*Como prepare_key8 pero no permite un valor vacío; es decir, que tras el signo '='
no haya nada. Si esto sucede devuelve NULL y (al igual que en la función prepare_key8)
buf->pc quedará apuntando al '\n' o c_char que cierra la línea.*/
static inline const char8_t* prepare_key8_noempty(Bufferti8 *buf, const char8_t c_char){
	const char8_t *ptr=prepare_key8(buf,c_char);
	if(ptr==NULL || *buf->pc==c_char || *buf->pc=='\n') return NULL;
	return ptr;
}

/*Como prepare_key16 pero no permite un valor vacío; es decir, que tras el signo '='
no haya nada. Si esto sucede devuelve NULL y (al igual que en la función prepare_key16)
buf->pc quedará apuntando al '\n' o c_char que cierra la línea.*/
static inline const char16_t* prepare_key16_noempty(Bufferti16 *buf, const char16_t c_char){
	const char16_t *ptr=prepare_key16(buf,c_char);
	if(ptr==NULL || *buf->pc==c_char || *buf->pc=='\n') return NULL;
	return ptr;
}
