﻿#include "ClasesGPS.h" //Includes 3D, etc.
#include <ATsistemas/ClaseSistema.h>

#define copy_pointline(buffer,to) const char8_t *s=buffer.pc; ignore_advanceinline(buffer); ignore_advanceinline(buffer);\
	if(*buffer.pc=='\n'){cod_error=1; goto error_fo;} prepare_string(buffer); towrite8_string(&to,s); resume(buffer); finishline_advance(buffer);

//definiciones para las funciones exportadas de la dll lecturaf.dll, library lecturaf.lib
static const double CCPI[3]={1.0, 63.6619772368, 57.2957795131};
static const double CCPI_1[3]={1.0, 0.01570796326795, 0.01745329252};

//Códigos devueltos por las funciones:
//Ver códigos comunes en Aerotri_defs.h

/*Se permiten nombres repetidos siempre y cuando solamente uno de los elementos no esté eliminado,
salvo que no se permiten nombres repetidos en ningún caso en los puntos de un fotograma y entre puntos
de conjuntos GPS/INS que no estén eliminados (incluyendo puntos del mismo conjunto).
Las funciones que simplemente lean, transformen o escriban los datos pueden ignorar esto.
*/

/*En las funciones cuyo nombre empieza por lee_ el parámetro de tipo u8int tras el nombre del fichero
es el tipo de fichero. Se pasa por referencia porque la función puede deducir el tipo de fichero a partir
de su contendio, y el tipo deducido lo escribirá en dicha variable. De momento solo deduce si el fichero
de puntos de apoyo es de Aerotri u otro X,Y,Z genérico. Las funciones que escriben ficheros de Aerotri
tienen un parámetro que indica si se han de escribir marcas 0/1 al final de cada registro.

Las funciones que escriben escriben solamente ficheros de formato de Aerotri. El parámetro marca indica
si se han de escribir las marcas 0/1 al final de cada registro.

Se indica a continuación los posibles valores para el formato cada una de las clases de ficheros
*/

//ftm
#define FOTOSFORMAT_Aerotri 0
#define FOTOSFORMAT_PATB 1
#define FOTOSFORMAT_IMaster 2
#define FOTOSFORMAT_EMosaic 3

//prm
//CCPPFORMAT_Aerotriccpp (definido más abajo)

//pym
#define PUNTOSFORMAT_XYZ 0
#define PUNTOSFORMAT_Aerotri 1
//Si se pasa 0 se deduce si es 0 o 1

//gpm Los marcados con * de entre los valores siguientes
#define CCPPFORMAT_Aerotriccpp 1
#define CCPPFORMAT_ΩΦΚ 2 //*
#define CCPPFORMAT_PATB 3
#define CCPPFORMAT_IMaster 4
#define CCPPFORMAT_AerotriGPS 5 //*
#define CCPPFORMAT_MatchAT 6 //*
#define CCPPFORMAT_TopoSys 7 //*

/*El parámetro limpio indica si los elementos cuya marca esté a 0 deben directamente quitarse de los elementos leidos.
Si vale 0 se lee todo; en caso contrario su significado según las distintas funciones es el siguiente:

	lee_ficherof:  1: se quitan fot.b=0;  2: se quita también p.bb!=3
	lee_ficheroapr[_...]:  1: se eliminan los que tengan toda la marca a 0;  2: se eliminan los que tengan alguna marca a 0
	lee_ficherogps:  1: se eliminan los conjuntos con 0 0;  2: se eliminan además los puntos con 0 0 (incluyendo los 0 0
		que surgen al heredar) 3: se eliminan además los puntos cuya marca sea "menor" que la del conjunto;
*/
#ifdef __cplusplus
extern "C"{
#endif
void lecturaf_set_globals(u8int _idioma, char16_t* _mensaje, uint _flags0);

/*Transforma ficheros que no son de Aerotri a formato Aerotri, marcado
si ficherof2!=NULL se emplea el nombre de ficherof2
si ficherof2==NULL  ==>  se genera el nombre con la extensión .ftm.
	Si ext=NULL se busca la extensión en ficherof, y si no se supone que ext apunta
	a donde tiene que ir el '.' dentro de ficherof.*/
int transforma_ftm(const char16_t* ficherof,u8int ftm, char16_t* ficherof2, const char16_t* ext);
sinline int transforma_ftm_simple(const char16_t* ficherof,u8int ftm){
	return  transforma_ftm(ficherof,ftm,NULL,NULL);
}
/*En lo devuelto,
	nombresf y nombres terminan en un doble '\0'
	puntos será un array de int, de manera que nombres+puntos[i] es donde empieza el nombre i.
	Si el valor devuelto para nombresf es NULL no se ha llegado a reservar memoria
ext sólo se emplea si hay que llamar a transforma_ftm (e.d., si el fichero no es de Aerotri).
Puede ser NULL (v. supra)*/
int lee_ficherof(const char16_t* ficherof, u8int *ftm, const char16_t* ext, u8int limpio, Vector_Fotograma *fotogramas,char8_t* *pnombresf, Vector_Pesopf *pesos, char8_t* *pnombres, uint* *ppuntos, uint *npuntos, float sigmaf);
int escribe_ftm(const char16_t* ficherof, Fotograma* fotogramas,char8_t* nombres,uint* puntos, uint nf, Pesopf* pesos, uint npesos, float sigmaf, u8int marca);
int escribe_fpatb(const char16_t* ficherof, Fotograma *fot,char8_t* nombres,uint* puntos);
int escribe_fimaster(const char16_t* ficherof, Fotograma *fot,char8_t* nombres,uint* puntos, float maxx, float maxy);
int lee_ficheroapr(const char16_t* ficheroapr, u8int * _unused(prm), u8int limpio, Vector_CentroProy *centros,char8_t* *pnombresCP,Vector_PesoCP *pesoscp, Vector_PuntoM *puntosM,char8_t* *pnombresM,Vector_PesoP *pesosp, s8int *deccp,s8int *decp, float sigmacpXY, float sigmacpZ, float sigmapXY, float sigmapZ, float sigmacpΩΦ, float sigmacpK);
sinline int lee_ficheroapr_noprec(const char16_t* ficheroapr, u8int *prm, u8int limpio, Vector_CentroProy *centros,char8_t* *pnombresCP, Vector_PuntoM *puntosM,char8_t* *pnombresM, s8int *deccp,s8int *decp){
	return lee_ficheroapr(ficheroapr,prm,limpio,centros,pnombresCP,NULL,puntosM,pnombresM,NULL,deccp,decp,-1,-1,-1,-1,-1,-1);
}
int lee_ficheroccpp(const char16_t* ficheroccpp, u8int *prm, u8int limpio, Vector_CentroProy *centros,char8_t* *pnombres, Vector_PesoCP *pesos, s8int *dec);
#ifdef __cplusplus
}
#endif

#define NOTFOUND 65536.0
typedef struct _GrupoGPSextras{
	uint insiemegps;
	uint insiemeins;
	bint calculaoffsetGPS;
	bint calculaoffsetINS;
} GrupoGPSextras;
defineVector(GrupoGPSextras)

/*Para lee_ficheroapr_all y sus llamadas sencillas cada tipo de información se corresponde con un bit
en ciertas variables de tipo entero. Las definiciones de cada bit son las que siguen.
Las variables que se interpretan como estas flags son las siguientes:
	flags: (Devuelve) de lo que se ha llegado a leer al menos un bloque sin error.
	flags_doonerror: (Indica) si pararse en caso de error. Un valor de 0xFFFF indica pararse en cualquier error
*/
#define LEEAPRALL_KEYVALS 1
#define LEEAPRALL_PP 2
#define LEEAPRALL_CCPP 4
#define LEEAPRALL_GRUPOSGI 8
#define LEEAPRALL_UNI 0x10
#define LEEAPRALL_SISTEMA 0x20
/*Los vectores se inicializan a .ppio=NULL y .n=0,
Los punteros a NULL
Los float y double a NAN
Los enteros no se inicializan. Deben venir con valores por defecto
o con valores imposibles, de manera que su vuelta modificados signifique que se han leído,
lo que el que llama prefiera*/

#ifdef __cplusplus
extern "C"{
#endif
int lee_ficheroapr_all(const char16_t* ficheroapr, u8int * _unused(prm), u8int limpio, Vector_CentroProy *centros,char8_t* *pnombresCP,Vector_PesoCP *pesoscp, Vector_PuntoM *puntosM,char8_t* *pnombresM,Vector_PesoP *pesosp, Vector_GrupoGPSINS *grupos, Vector_uint *grupos_giro, Vector_GrupoGPSextras *gextras, char8_t* *pnombresgf, float* vv,u8int *tipo, Sistema *sis, char16_t* *pfichero_int, u16int *flags, u16int *flags_errors, u16int flags_doonerror, s8int *deccp,s8int *decp, float sigmacpXY, float sigmacpZ, float sigmapXY, float sigmapZ, float sigmacpΩΦ, float sigmacpK);
sinline int lee_ficheroapr_all_noprec(const char16_t* ficheroapr, u8int *prm, u8int limpio, Vector_CentroProy *centros,char8_t* *pnombresCP, Vector_PuntoM *puntosM, char8_t* *pnombresM, Vector_GrupoGPSINS *grupos, Vector_uint *grupos_giro, Vector_GrupoGPSextras *gextras, char8_t* *pnombresgf, float* vv, u8int *tipo, Sistema* sis, char16_t* *pfichero_int, u16int* flags, u16int* flags_errors, u16int flags_doonerror, s8int *deccp, s8int *decp){
	return lee_ficheroapr_all(ficheroapr,prm,limpio, centros,pnombresCP,NULL,puntosM,pnombresM,NULL,grupos,grupos_giro,gextras,pnombresgf,vv,tipo,sis,pfichero_int,flags,flags_errors,flags_doonerror,deccp,decp,-1,-1,-1,-1,-1,-1);
}
sinline int lee_ficheroapr_noprec_sis(const char16_t* ficheroapr, u8int *prm, u8int limpio, Vector_CentroProy *centros,char8_t* *pnombresCP, Vector_PuntoM* puntosM, char8_t* *pnombresM, u16int* flags, u16int* flags_errors, u16int flags_doonerror, s8int *decf, s8int *decp, Sistema* sis){
	return lee_ficheroapr_all(ficheroapr,prm,limpio, centros,pnombresCP,NULL,puntosM,pnombresM,NULL,NULL,NULL,NULL,NULL,NULL,NULL,sis,NULL,flags,flags_errors,flags_doonerror,decf,decp,-1,-1,-1,-1,-1,-1);
}

int lee_ficheroapy(const char16_t* ficheroapy, u8int *pym, u8int limpio, Vector_PuntoM *puntosA,char8_t* *pnombres,Vector_PesoP *pesos, float sigmaXY, float sigmaZ, s8int *dec);
/* marca:
0: No se escriben marcas
1: Se escribe 0/1
2: Se escribe 000, 1111, etc. (como en los ficheros de apoyo)
3: Crea un archivo XYZ puro: No se escribe marca ni el código -pp.
*/
int escribe_prmpym(const char16_t* ficheroprm, CentroProy* centros,uint ncp,PesoCP *pesoscp, PuntoM* puntosM,uint npm,PesoP *pesosp, s8int uni, s8int deccp, s8int decp, Sistema* sis, u8int marca, u8int modoccpp, float sigmacpXY, float sigmacpZ, float sigmapXY, float sigmapZ, float sigmacpΩΦ, float sigmacpK);
int escribe_prm(const char16_t* ficheroprm, CentroProy* centros, uint ncp, PuntoM* puntosM, uint npm, s8int uni, s8int deccp, s8int decp, u8int marca);

/*En el campo tipogps o tipoins de cada grupo, en caso de que no se indique ningún
 tipogps o tipoins para el grupo en su cabecera (lo habitual) se almacenará el valor
 LEEGPS_TIPO_DEFAULT. En caso de que el grupo no incluya datos de ese tipo (gps o ins)
 se almacenara LEEGPS_TIPO_NODATA e implica bg=0 o bi=0.
 Para los PuntosGPSINS se guarda en tipogps, tipoins los mismos valores que para el
 grupo. */
#define LEEGPS_TIPO_NODATA 255
#define LEEGPS_TIPO_DEFAULT 254

int lee_ficherogps(const char16_t* ficherogps, u8int *gpm, bint signoins, u8int limpio, Vector_GrupoGPSINS *grupos, Vector_PuntoGPSINS *gpss,char8_t* *pnombresCP,Vector_PesoCP *pesos, Vector_GrupoGPSextras *gruposextras, s8int *dec, float sigmagpsXY,float sigmagpsZ, float sigmainsΩΦ,float sigmainsK);
int escribe_gpm(const char16_t* ficherogps, GrupoGPSINS* grupos,uint ngrupos, PuntoGPSINS* gpss,uint _unused(ngps), PesoCP* pesos, s8int decp, u8int marca, float sigmagpsXY, float sigmagpsZ, float sigmainsΩΦ, float sigmainsK);
int lee_ficheroori_patb(const char16_t* ficheroori, Vector_CentroProy *centros,char8_t* *pnombresCP);
int lee_ficheromod(const char16_t* ficheromod, PuntoXYZ_double *P1, PuntoXYZ_double *P2, Vector_PuntoM *puntosM,char8_t* *pnombres);
int escribeccpp_patb(const char16_t* ficheroori, CentroProy* centros, uint ncp, u8int modo); //0, 1
int escribeccpp_eo(const char16_t* ficheroprm, CentroProy* centros, uint ncp, s8int deccp);
#ifdef __cplusplus
}
#endif

sinline int escribe_prmpym_simple(const char16_t* ficheroprm, CentroProy* centros,uint ncp,PesoCP *pesoscp, PuntoM* puntosM,uint npm,PesoP *pesosp, s8int uni, s8int deccp, s8int decp){
	return escribe_prmpym(ficheroprm,centros,ncp,pesoscp,puntosM,npm,pesosp,uni,deccp,decp,NULL,1,2,-1,-1,-1,-1,-1,-1);
}
