﻿#undef COMMENT_CHAR
#define COMMENT_CHAR '\n'

#define bufreturn(n) *pbuffer=buffer; return n

int lee_keyvals(Bufferti8 *pbuffer){
	Bufferti8 buffer=*pbuffer;
	const char8_t* *ptr=keyvals, **upperlimit=keyvals+NKEYPAIRS+NKEYPAIRS;
	while(*buffer.pc!='\0' && *buffer.pc!='-'){
		prepare_string(buffer);
		*ptr=buffer.pc; ptr++;
		buffer.pc=buffer.next+1;
		if(buffer.savedchar!='n') advanceinline(buffer);
		if(buffer.savedchar=='n' || *buffer.pc=='\n' || *buffer.pc=='\0') *ptr=NULL;
		else{
			Prepare_line(buffer);
			*ptr=buffer.pc;
			buffer.pc=buffer.next+1;
		}
		ptr++;
		advance(buffer);
		if(ptr==upperlimit) break;
	}
	*ptr++=NULL; *ptr=NULL;

	bufreturn(0);
}

//Las siguientes funciones actualizan los valores pasados por referencia, que tienen que venir inicializados.
//Si quiere que los bloques se lean como independientes simplemente pase variables distintas cada vez
int lee_centros(Bufferti8 *pbuffer,char16_t* pterror, u8int limpio, Vector_CentroProy *centros,Growing_char *pnombres,Vector_PesoCP *pesoscp,uint sugg_num, double ccpi, s8int *dec, float σXY, float σZ, float σΩΦ, float σK){
	Bufferti8 buffer=*pbuffer;
	int cod_error;
	u8int mar;
	CentroProy CP;
	Giro3D_double G;
	Growing_char nombres;
	uint n_prev;
	int nret=0;

	double ccpi_1=1.0/ccpi;
	if(!(flags0&1)){
		σΩΦ*=(float)ccpi;
		σK*=(float)ccpi;
	}
	default_values_CP(CP);

	advance_next(buffer);
	if(centros->ppio==NULL){
		uint k;
		if(sugg_num<4) sugg_num=4;
		Vsetup(CentroProy,*centros,sugg_num,bufreturn(AT_NOMEM));
		k=(pdif)(buffer.next-buffer.pc)+1; if(k<5) k=5; if(k>16) k=16;
		k*=sugg_num;
		k&=~31U; k+=32;
		GC_initialize(nombres,k,free(centros->ppio); centros->ppio=NULL; bufreturn(AT_NOMEM));
	}else{
		nombres=*pnombres;
	}
	n_prev=centros->n;

	{char8_t* oldpc=buffer.pc;
	ignore_advance(buffer);	//nombre
	ignore_advance(buffer);	//X
	ignore_advance(buffer);	//Y
	ignore_advance(buffer);	//Z
	ignore_advance(buffer);	//W
	ignore_advance(buffer);	//Phi
	ignore_advanceinline(buffer); //Kappa
	if(*buffer.pc>='0' && *buffer.pc<='3'){
		ignore_advanceinline(buffer);
		if(*buffer.pc>='0' && *buffer.pc<='3') mar=2;
		else mar=1;
	}else{
		mar=0;
	}
	buffer.pc=oldpc;
	}

	while(*buffer.pc!='\0' && *buffer.pc!='-'){
		get_stringGC_advance(buffer,nombres,CP.index);
		ifnot_get_double(buffer,CP.P.X){cod_error=T_coorX; goto error_caracter;}
		ifnot_get_double(buffer,CP.P.Y){cod_error=T_coorY; goto error_caracter;}
		ifnot_get_double(buffer,CP.P.Z){cod_error=T_coorZ; goto error_caracter;}
		ifnot_get_double(buffer,G.ω){cod_error=T_Omega; goto error_caracter;}
		ifnot_get_double(buffer,G.φ){cod_error=T_Phi; goto error_caracter;}
		ifnot_get_stay(buffer,G.κ,vfdouble___str8){cod_error=T_Kappa; goto error_caracter;}
		if(mar){advance(buffer);}
		if(*buffer.pc=='\0'){
eof_in_ccpp:	strbuild_mixed(pterror,'w',wSS_Eof_in_ccpp,'c',nombres.ppio+CP.index,0);
			nret=ATREAD_EOF; goto salida_mala;
		}
		if(flags0&1) *(Giro3D_double*)CP.M[0]=G;
		else{P_mul(G,ccpi_1); MatrizRot_ωφκ(G,CP.M);}
		if(mar){
			if(mar==1){
				umint naux=*buffer.pc++;
				if(*buffer.pc!='\n' && *buffer.pc!=' ' && *buffer.pc!='\t') naux=255;
				if(naux<'0' || naux>'2'){	//El 3 es incompatible con las precisiones particulares
					isolate_word(buffer);
					strbuild_mixed(pterror,'w',S_(Enccpp),'c',nombres.ppio+CP.index,'w',S_(Lamarcaentre), 'w',u"0 y 2", 'w',S_(ensulugar),'c',buffer.pc,0);
					resume(buffer);
					nret=ATREAD_RANGE; goto salida_mala;
				}
				CP.b=naux-'0';
				CP.gggppp2=CP.gggppp=0;
				switch(naux){
					case '1': CP.gggppp=077; break;
					case '2': CP.gggppp2=077; break;
				}
			}else{//mar==2
				buffer.pc++;
				if(*buffer.pc==' ' || *buffer.pc=='\t' || *buffer.pc=='\n'){
					umint naux=*(buffer.pc-1);
					if(naux<'0' || naux>'2'){	//El 3 es incompatible con las precisiones particulares
						isolate_word(buffer);
						strbuild_mixed(pterror,'w',S_(Enccpp),'c',nombres.ppio+CP.index,'w',S_(Lamarcaentre), 'w',u"0 y 2", 'w',S_(ensulugar),'c',buffer.pc,0);
						resume(buffer);
						nret=ATREAD_RANGE; goto salida_mala;
					}
					switch(naux){
						case '0': CP.gggppp=CP.gggppp2=0; break;
						case '1': CP.gggppp2=0; CP.gggppp=007; break;
						case '2': CP.gggppp2=007; CP.gggppp=0;
					}
				}else{
					uint naux;
					buffer.pc--;
					ifnot_get_marca2(buffer,naux) naux=~0U;
					CP.gggppp=(umint)(naux&0xFFFF);
					CP.gggppp2=(umint)(naux>>16);
					if(CP.gggppp>07 || CP.gggppp2>07){
						isolate_word(buffer);
						strbuild_mixed(pterror,'w',S_(Enccpp),'c',nombres.ppio+CP.index,'w',S_(Lamarcaentre), 'w',u"000 y 222", 'w',S_(ensulugar),'c',buffer.pc,0);
						resume(buffer);
						nret=ATREAD_RANGE; goto salida_mala;
					}
				}
				advance(buffer);
				buffer.pc++;
				if(*buffer.pc==' ' || *buffer.pc=='\t' || *buffer.pc=='\n'){
					umint naux;
					naux=*(buffer.pc-1);
					if(naux<'0' || naux>'2'){	//El 3 es incompatible con las precisiones particulares
						isolate_word(buffer);
						strbuild_mixed(pterror,'w',S_(Enccpp),'c',nombres.ppio+CP.index,'w',S_(Lamarcaentre), 'w',u"0 y 2", 'w',S_(ensulugar),'c',buffer.pc,0);
						resume(buffer);
						nret=ATREAD_RANGE; goto salida_mala;
					}
					switch(naux){
						case '1': CP.gggppp|=070; break;
						case '2': CP.gggppp2|=070;
					}
				}else{
					uint naux;
					buffer.pc--;
					ifnot_get_marca2(buffer,naux) naux=~0U;
					CP.gggppp|=(naux&0xFFFF)<<3;
					CP.gggppp2|=(naux>>16)<<3;
					if(CP.gggppp>077 || CP.gggppp2>077){
						isolate_word(buffer);
						strbuild_mixed(pterror,'w',S_(Enccpp),'c',nombres.ppio+CP.index,'w',S_(Lamarcaentre), 'w',u"000 y 222", 'w',S_(ensulugar),'c',buffer.pc,0);
						resume(buffer);
						nret=ATREAD_RANGE; goto salida_mala;
					}
				}
				if(CP.gggppp==077) CP.b=1;
				elif((CP.gggppp | CP.gggppp2)==077) CP.b=2;
				else CP.b=0;
			}
		}//Fin if(mar)

		CP.peso=0;
		advancecare(buffer);
		if(*buffer.pc==';') goto h_peso;
	back_peso:
		if(CP.b || limpio==0 || (limpio==1 && (CP.gggppp&CP.gggppp2)!=0)){
			Vadd(*centros,CentroProy,CP,goto salida_outofmem);
		}
		ifinline_finishline_advance_toname(buffer);
	}
nret=0; goto salida;

h_peso:
	if(pesoscp!=NULL){
		PesoCP *ppeso;
		uint k;
		if(pesoscp->ppio==NULL){
			Vsetup(PesoCP,*pesoscp,4,goto salida_outofmem);
			NOTFINITE_f(pesoscp->ppio->p.X); NOTFINITE_f(pesoscp->ppio->p.Y); NOTFINITE_f(pesoscp->ppio->p.Z);
			pesoscp->ppio->g=pesoscp->ppio->p;
			pesoscp->n=1;
		}
		Venlarge_one(*pesoscp,PesoCP,ppeso,goto salida_outofmem);
		defaultvalues_pesoCP(*ppeso);

		k=-1;
		while(*buffer.pc==';'){
			while(*buffer.pc==';'){
				k++;
				buffer.pc++;
				advancecare(buffer);
			}
			if(k>3){
				strbuild_mixed(pterror,'w',S_(Enccpp),'c',nombres.ppio+CP.index,'w',S_(Demasiadosptc),0);
				nret=ATREAD_BADFORMAT; goto salida_mala;
			}
			if(*buffer.pc=='\0') goto eof_in_ccpp;
			ifnlpassed(buffer){
				strbuild_mixed(pterror,'w',S_(Enccpp),'c',nombres.ppio+CP.index,'w',S_(Finaldelinea),'w',S_(buscaba_unaprec),0);
				nret=ATREAD_LINEA; goto salida_mala;
			}
			{float faux;
			ifnot_get_peso(buffer,faux){cod_error=T_unaprec; goto error_caracter;}
			switch(k){
				case 0: ppeso->p.Y=ppeso->p.X=faux/σXY; break;
				case 1: ppeso->p.Z=faux/σZ; break;
				case 2: ppeso->g.φ=ppeso->g.ω=faux/σΩΦ; break;
				case 3: ppeso->g.κ=faux/σK; break;
			}}
			advancecare(buffer);
		}
		if(P_iseq(ppeso->p,==,(ppeso-1)->p) && P_iseq(ppeso->g,==,(ppeso-1)->g)) pesoscp->n--;
		CP.peso=pesoscp->n-1;
	}else{
		skip_pesos(buffer);
	}
goto back_peso;

salida_outofmem:
	nret=AT_NOMEM; goto salida_mala;
/*long_name:
	buffer.pc[21]='.'; buffer.pc[22]='.'; buffer.pc[23]='.'; buffer.pc[24]='\0';
	strbuild_mixed(pterror,'w',S_(Nombrecplargo),'c',buffer.pc,0);
	goto salida_otro;*/
error_caracter:
	pterror=strbuild_mixed(pterror,'w',S_(Enccpp),'c',nombres.ppio+CP.index,'w',S_(Mientras),'w',TEXTO_lecturaf(cod_error),'w',S_(seencontro),0);
	*pterror++=*buffer.pc; strcpy16(pterror,S_(wasfound));
	nret=ATREAD_CARACTER; goto salida_mala;

//salida_otro: nret=8;
salida_mala:
salida:
	if(dec!=NULL && centros->n!=n_prev){
		uint i=(centros->n-n_prev+7)>>3;
		CentroProy *ptr=centros->ppio+n_prev;
		while(i--){
			s8int sa;
			if((sa=ndecimales_P(ptr->P))>*dec) *dec=sa;
			ptr+=8;
		}
	}
	*nombres.next='\0'; *pnombres=nombres;
	bufreturn(nret);
}
int lee_puntosM(Bufferti8 *pbuffer,char16_t* pterror, u8int limpio, Vector_PuntoM *puntosM,Growing_char *pnombres,Vector_PesoP *pesosp, uint sugg_num, s8int *dec, float σXY, float σZ){
	Bufferti8 buffer=*pbuffer;
	int cod_error;
	u8int mar;
	PuntoM PM;
	Growing_char nombres;
	uint n_prev;
	int nret=0;

	default_values_PM(PM);

	advance_next(buffer);
	if(puntosM->ppio==NULL){
		uint k;
		if(sugg_num<4) sugg_num=4;
		Vsetup(PuntoM,*puntosM,sugg_num,bufreturn(AT_NOMEM));
		k=(pdif)(buffer.next-buffer.pc)+1; if(k<5) k=5; if(k>16) k=16;
		k*=sugg_num;
		k&=~31U; k+=32;
		GC_initialize(nombres,k,free(puntosM->ppio); puntosM->ppio=NULL; bufreturn(AT_NOMEM));
	}else{
		nombres=*pnombres;
	}
	n_prev=puntosM->n;

	{char8_t* oldpc=buffer.pc;
	ignore_advance(buffer);	//nombre
	ignore_advance(buffer);	//X
	ignore_advance(buffer);	//Y
	ignore_advanceinline(buffer);	//Z
	if(*buffer.pc>='0' && *buffer.pc<='3'){
		buffer.pc++;
		if(*buffer.pc==' ' || *buffer.pc=='\t' || *buffer.pc=='\n') mar=1;
		else mar=2;
	}else{
		mar=0;
	}
	buffer.pc=oldpc;
	}

	while(*buffer.pc!='\0' && *buffer.pc!='-'){
		get_stringGC_advance(buffer,nombres,PM.index);
		ifnot_get_double(buffer,PM.P.X){cod_error=T_coorX; goto error_caracter;}
		ifnot_get_double(buffer,PM.P.Y){cod_error=T_coorY; goto error_caracter;}
		ifnot_get_stay(buffer,PM.P.Z,vfdouble___str8){cod_error=T_coorZ; goto error_caracter;}
		if(mar){advance(buffer);}
		if(*buffer.pc=='\0'){
eof_in_punto:	strbuild_mixed(pterror,'w',wSS_Eof_in_punto,'c',nombres.ppio+PM.index,0);
			nret=ATREAD_EOF; goto salida_mala;
		}
		if(mar){
			if(mar==1){
				umint naux=*buffer.pc++;
				if(*buffer.pc!='\n' && *buffer.pc!=' ' && *buffer.pc!='\t') naux=255;
				if(naux<'0' || naux>'2'){	//El 3 es incompatible con las precisiones particulares
					isolate_word(buffer);
					strbuild_mixed(pterror,'w',S_(Enpunto),'c',nombres.ppio+PM.index,'w',S_(Lamarcaentre), 'w',u"0 y 2", 'w',S_(ensulugar),'c',buffer.pc,0);
					resume(buffer);
					nret=ATREAD_RANGE; goto salida_mala;
				}
				switch(naux){
					case '0': PM.bbb=0; break;
					case '1': PM.bbb=7; break;
					case '2': PM.bbb=070;
					//case '3': PM.bbb=0107;
				}
			}else{//mar==2
				uint naux,k;
				ifnot_get_marca2(buffer,naux) naux=~0U;
				k=naux>>16;
				naux&=0xFFFF;
				if(k>07 || naux>07){
					isolate_word(buffer);
					strbuild_mixed(pterror,'w',S_(Enpunto),'c',nombres.ppio+PM.index,'w',S_(Lamarcaentre), 'w',u"000 y 222", 'w',S_(ensulugar),'c',buffer.pc,0);
					resume(buffer);
					nret=ATREAD_RANGE; goto salida_mala;
				}
				PM.bbb=(umint)(naux | (k<<3));
			}
		}
		PM.peso=0;
		advancecare(buffer);
		if(*buffer.pc==';') goto h_peso;
	back_peso:
		{u8int naux=((PM.bbb>>3) | PM.bbb)&7;
		if(naux==0x7 || limpio==0 || (limpio==1 && PM.bbb!=0)){
			Vadd(*puntosM,PuntoM,PM,goto salida_outofmem);
		}}
		ifinline_finishline_advance_toname(buffer);
	}
nret=0; goto salida;

h_peso:
	if(pesosp!=NULL){
		PesoP *ppeso;
		uint k;
		if(pesosp->ppio==NULL){
			Vsetup(PesoP,*pesosp,4,goto salida_outofmem);
			NOTFINITE_f(pesosp->ppio->X); NOTFINITE_f(pesosp->ppio->Y); NOTFINITE_f(pesosp->ppio->Z);
			pesosp->n=1;
		}
		Venlarge_one(*pesosp,PesoP,ppeso,goto salida_outofmem);
		defaultvalues_pesoP(*ppeso);

		k=-1;
		while(*buffer.pc==';'){
			while(*buffer.pc==';'){
				k++;
				buffer.pc++;
				advancecare(buffer);
			}
			if(k>1){
				strbuild_mixed(pterror,'w',S_(Enpunto),'c',nombres.ppio+PM.index,'w',S_(Demasiadosptc),0);
				nret=ATREAD_BADFORMAT; goto salida_mala;
			}
			if(*buffer.pc=='\0') goto eof_in_punto;
			ifnlpassed(buffer){
				strbuild_mixed(pterror,'w',S_(Enpunto),'c',nombres.ppio+PM.index,'w',S_(Finaldelinea),'w',S_(buscaba_unaprec),0);
				nret=ATREAD_LINEA; goto salida_mala;
			}
			{float faux;
			ifnot_get_peso(buffer,faux){cod_error=T_unaprec; goto error_caracter;}
			if(k==0) ppeso->Y=ppeso->X=faux/σXY;
			else ppeso->Z=faux/σZ;}
			advancecare(buffer);
		}
		if(P_iseq(*ppeso,==,*(ppeso-1))) pesosp->n--;
		PM.peso=pesosp->n-1;
	}else{
		skip_pesos(buffer);
	}
goto back_peso;

salida_outofmem:
	nret=AT_NOMEM; goto salida_mala;
/*long_name:
	buffer.pc[21]='.'; buffer.pc[22]='.'; buffer.pc[23]='.'; buffer.pc[24]='\0';
	strbuild_mixed(pterror,'w',S_(Nombrepuntolargo),'c',buffer.pc,0);
	goto salida_otro;*/
error_caracter:
	pterror=strbuild_mixed(pterror,'w',S_(Enpunto),'c',nombres.ppio+PM.index,'w',S_(Mientras),'w',TEXTO_lecturaf(cod_error),'w',S_(seencontro),0);
	*pterror++=*buffer.pc; strcpy16(pterror,S_(wasfound));
	nret=ATREAD_CARACTER; goto salida_mala;

//salida_otro: nret=8;
salida_mala:
salida:
	if(dec!=NULL && puntosM->n!=n_prev){
		uint i=(puntosM->n-n_prev+7)>>3;
		PuntoM *ptr=puntosM->ppio+n_prev;
		while(i--){
			s8int sa;
			if((sa=ndecimales_P(ptr->P))>*dec) *dec=sa;
			ptr+=8;
		}
	}
	*nombres.next='\0'; *pnombres=nombres;
	bufreturn(nret);
}

int lee_gruposapr(Bufferti8 *pbuffer,char16_t* pterror, Vector_GrupoGPSINS *grupos, Vector_uint *grupos_giro, Vector_GrupoGPSextras *gextras, char8_t* *pnombresgf, double ccpi){
	Bufferti8 buffer=*pbuffer;
	int nret;
	PuntoXYZ_double P;
	GrupoGPSINS Grupo;
	Growing_char nombresgf;
	GrupoGPSextras gdefault={Я,Я,0,0};
	char8_t cog;
	const char8_t *codigo;
	uint situacion;
	ccpi=1.0/ccpi;
	//Default values not needed for anything. Only the data will be used

	grupos->ppio=NULL;
	grupos->n=grupos_giro->n=gextras->n=0;
	Vsetup(GrupoGPSINS,*grupos,20,goto no_mem0);
	Vsetup(uint,*grupos_giro,20,goto no_mem1);
	Vsetup(GrupoGPSextras,*gextras,20,goto no_mem2);
	GC_initialize(nombresgf,80,goto no_mem3);

	while(*buffer.pc!='\0' && *buffer.pc!='-'){
		string_advance(buffer,codigo);
		if(strcmp8(codigo,"g") && strcmp8(codigo,"f")){
			const char16_t *s;
			pterror=strpcpy16(pterror,S_(Engrupopars));
			switch(idioma){
				case 1:  s=u"\nThe first word of every gps/ins group must be \"f\" or \"g\""; break;
				case 2:  s=u"\nLa prima parola di ogni gruppo gps/ins deve esere \"f\" o \"g\""; break;
				default:s=u"\nLa primera palabra de cada grupo gps/ins tiene que ser \"f\" o \"g\"";
			}
			strcpy16(pterror,s);
			if(codigo[1]=='\0') nret=ATREAD_RANGE;
			else nret=ATREAD_BADFORMAT;
			goto salida_mala;
		}
		cog=codigo[0];
		get_stringGC_advancecare(buffer,nombresgf,Grupo.index);
		Grupo.param=255;
		Grupo.tiempo0=NOTFOUND;
		Grupo.offset.Z=Grupo.offset.Y=Grupo.offset.X=NOTFOUND;
		Grupo.derivains=Grupo.deriva=Grupo.despl=Grupo.offset;
		Grupo.desplins[0][0]=NOTFOUND;
		situacion=0;
		Vadd(*gextras,GrupoGPSextras,gdefault,goto salida_outofmem);

		for(;;){
			int k;
			bint l;
			ifnlpassed(buffer){
				if(*buffer.pc!='\0' && *buffer.pc!='-'){
					if(*buffer.pc!='f' && *buffer.pc!='g') buffer.savedchar=' ';
					else{
						buffer.pc++;
						if(*buffer.pc!=' ' && *buffer.pc!='\t' && *buffer.pc!='\n') buffer.savedchar=' ';
						buffer.pc--;
					}
				}
				if(buffer.savedchar=='\n'){
					Vadd(*grupos,GrupoGPSINS,Grupo,goto salida_outofmem);
					Vadd(*grupos_giro,uint,situacion,goto salida_outofmem);
					break;
				}
			}
			prepare_string(buffer);
			codigo=buffer.pc;
			k=(pdif)(buffer.next-buffer.pc);
			l=0;
			if(k<=5){
				if(strcmp8(buffer.pc,"t0")==0) k=-1;
				elif(strcmp8(buffer.pc,"param")==0) k=-2;
				else k=0;
			}elif(k<=8){
				if(strcmp8(buffer.pc,"gpsdespl")==0) k=2;
				elif(strcmp8(buffer.pc,"insdespl")==0) k=5;
				elif(strcmp8(buffer.pc,"grupogps")==0) k=-4;
				elif(strcmp8(buffer.pc,"grupoins")==0) k=-5;
				else k=0;
			}else{
				if(strcmp8(buffer.pc,"gpsoffset")==0) k=1;
				elif(strcmp8(buffer.pc,"gpsoffsetJ")==0){k=1; l=1;}
				elif(strcmp8(buffer.pc,"gpsderiva")==0) k=3;
				elif(strcmp8(buffer.pc,"insoffset")==0) k=4;
				elif(strcmp8(buffer.pc,"insderiva")==0) k=6;
				elif(strcmp8(buffer.pc,"situacion")==0) k=-3;
				else k=0;
			}
			resume(buffer); advancecare(buffer);
			*buffer.next='\0'; //para código

			if(k==0) continue;
			if(*buffer.pc=='\0'){
eof_in_grupo: pterror=strbuild16(pterror,SS_Eof_in_grupopars,NULL);
				*pterror++=cog; *pterror++=' ';
				{char8_t* pchar; for(pchar=nombresgf.ppio+Grupo.index; *pchar!='0'; *pterror++=*pchar++);}
				 *pterror=u'\0';
				//-=2 is safe because the first name (any name) cannot be empty.
				for(nombresgf.next-=2;nombresgf.next!=nombresgf.ppio && *nombresgf.next;nombresgf.next--);
				nret=ATREAD_EOF; goto salida_mala;
			}
			if(k>0){
				ifnot_get_double(buffer,P.X) goto error_caracter;
				ifnot_get_double(buffer,P.Y) goto error_caracter;
				if(*buffer.pc=='\0') goto eof_in_grupo;
				ifnot_get_advancecare(buffer,P.Z,vfdouble___str8) goto error_caracter;
				if(k>=4 && !(flags0&1)){P_mul(P,ccpi);}
			}elif(k==-1){
				ifnot_get_advancecare(buffer,P.X,vfdouble___str8) goto error_caracter;
			}elif(k==-3){
				char8_t c; const char8_t *s;
				prepare_string(buffer);
				if(buffer.next-buffer.pc<4) goto bad;
				s=buffer.pc;
				situacion=0;
				if((c=s[0])=='+') situacion=0x01;
				elif(c=='-') situacion=0xFF;
				elif(c!='0') goto bad;
				if((c=s[1])=='+') situacion|=0x0100;
				elif(c=='-') situacion|=0xFF00;
				elif(c!='0') goto bad;
				if((c=s[2])=='+') situacion|=0x010000;
				elif(c=='-') situacion|=0xFF0000;
				elif(c!='0') goto bad;
				if((c=s[3])=='+') situacion|=0x01000000;
				elif(c=='-') situacion|=0xFF000000;
				elif(c!='0') goto bad;
				if(0){
				  bad: situacion=0xFFFFFFFF;
				}
				resume(buffer); advancecare(buffer);
			}else{
				uint naux;
				if_get_advancecare(buffer,naux,uint___str8){
					if(k==-2) Grupo.param=(umint)naux;
					elif(k==-4) gextras->ppio[grupos->n].insiemegps=naux;
					elif(k==-5) gextras->ppio[grupos->n].insiemeins=naux;
				}else goto error_caracter;
			}
			switch(k){
				case 1: Grupo.offset=P; if(l) gextras->ppio[grupos->n].calculaoffsetGPS=1; break;
				case 2: Grupo.despl=P; break;
				case 3: Grupo.deriva=P; break;
				case 4: break;
				case 5: if(flags0&1) *(Giro3D_double*)Grupo.desplins[0]=P;
						else MatrizRot_ωφκ(P,Grupo.desplins); break; //*ccpi arriba
				case 6: Grupo.derivains=P; break;
				case -1: Grupo.tiempo0=P.X; break;
				case -3: break;
			}
		}
	}
nret=0; goto salida;

salida_outofmem:
	nret=AT_NOMEM; goto salida_mala;
/*long_name:
	buffer.pc[21]='.'; buffer.pc[22]='.'; buffer.pc[23]='.'; buffer.pc[24]='\0';
	strbuild_mixed(pterror,'w',S_(Nombregpslargo),'c',buffer.pc,0);
	goto salida_otro;*/
error_caracter:
	pterror=strpcpy16(pterror,S_(Engrupopars));
	*pterror++=cog; *pterror++=' ';
	pterror=strbuild_mixed(pterror,'c',nombresgf.ppio+Grupo.index,'w',S_(Mientras_parametro),'c',codigo,'w',S_(seencontro),0);
	*pterror++=*buffer.pc;
	strcpy16(pterror,S_(wasfound));
	for(nombresgf.next-=2;nombresgf.next!=nombresgf.ppio && *nombresgf.next;nombresgf.next--);
	nret=ATREAD_CARACTER; goto salida_mala;

//salida_otro: nret=8;
salida_mala:
salida:
	*nombresgf.next='\0'; *pnombresgf=nombresgf.ppio;
	bufreturn(nret);

no_mem3:
free(gextras->ppio);			no_mem2:
free(grupos_giro->ppio);	no_mem1:
free(grupos->ppio);			no_mem0:
grupos->ppio=NULL;
free_return(AT_NOMEM);
}
int lee_sistema(Bufferti8 *pbuffer,char16_t* pterror, Sistema* sis){
	Bufferti8 buffer=*pbuffer;
	const char8_t* campo;

	if(*buffer.pc=='-') return 0;
	string_advance(buffer,campo);
	if(strcmp8(campo,"Sistema")){
		const char16_t *s;
		switch(idioma){
			case 1:  s=u"The first field in a -sistema element must be the system"; break;
			case 2:  s=u"Il primo campo in un elemento -sistema dev'esere il sistema"; break;
			default:s=u"El primer campo en un elemento -sistema tiene que ser el sistema";
		}
		strcpy16(pterror,s);
		bufreturn(ATREAD_BADFORMAT);
	}
	string_advancecare(buffer,campo);
	if(strcmp8(campo,"Rectangular")==0) sis->sis.proy=SIS_Rectangular;
	elif(strcmp8(campo,"Lambert")==0) sis->sis.proy=SIS_Lambert;
	elif(strcmp8(campo,"Mercator")==0) sis->sis.proy=SIS_Mercator;
	elif(strcmp8(campo,"Estereografica")==0) sis->sis.proy=SIS_Estereográfica;
	elif(strcmp8(campo,"UTM")==0) sis->sis.proy=SIS_Mercator_Transversa;
	elif(strcmp8(campo,"Geograficas")==0) sis->sis.proy=SIS_Geograficas;
	else sis->sis.proy=SIS_Conforme;

	sis->infor.linear_units=1;
	sis->infor.linear_units_abr=NULL;
	sis->infor.datum_and_projection_name=NULL;
	sis->infor.elip=NULL;
	sis->infor.λ0=0;
	sis->sis.Λ0=0;
	sis->sis.a=0;	//es obligatorio que aparezca, salvo en sistema rectangular
	sis->sis.e=0;
	sis->sis.ond=0;
	sis->sis.param1.conv0=0;	//Para otro conforme
	sis->sis.k0=1;
	sis->sis.xO=sis->sis.yS=0;
	for(;;){
		double aux;
		if(*buffer.pc=='\0') break;
		if(*buffer.pc=='-' && buffer.savedchar=='\n') break;

		string_advance(buffer,campo);
		if(strcmp8(campo,"Sistema")==0){
			const char16_t *s;
			switch(idioma){
				case 1:  s=u"Two systems were specified in a -sistema element"; break;
				case 2:  s=u"Comparono due sistemi in un elemento -sistema"; break;
				default:s=u"Aparecen dos sistemas en un elemento -sistema";
			}
			strcpy16(pterror,s);
			bufreturn(8);
		}
		if_get_advancecare(buffer,aux,double___str8){	//Allow E
				if(strcmp8(campo,"a")==0)		sis->sis.a=aux;
			elif(strcmp8(campo,"N")==0)	sis->sis.a=aux;
			elif(strcmp8(campo,"rho")==0)	sis->sis.e=aux;
			elif(strcmp8(campo,"e")==0){
				sis->sis.e=aux;
				if(aux==0) sis->infor.elip="Esfera";
				else sis->infor.elip="Unknown";	//desconocido
			}elif(strcmp8(campo,"ond")==0)	sis->sis.ond=(float)aux;
			elif(strcmp8(campo,"LatLong")==0) sis->sis.param1.orden_λφ=(aux==1.0);   //SIS_Geograficas_φλ
			elif(strcmp8(campo,"par1")==0
				|| strcmp8(campo,"param1")==0)	sis->sis.param1.conv0=aux;
			elif(strcmp8(campo,"k0")==0)	sis->sis.k0=aux;
			elif(strcmp8(campo,"xO")==0 || strcmp8(campo,"xE")==0)	sis->sis.xO=aux;
			elif(strcmp8(campo,"yS")==0)	sis->sis.yS=aux;
		}else{
			pterror=strbuild_mixed(pterror,'w',S_(Ensistema),'w',S_(Mientras_parametro),'c',campo,'w',S_(seencontro),0);
			*pterror++=*buffer.pc;
			strcpy16(pterror,S_(wasfound));
			bufreturn(ATREAD_CARACTER);
		}
	}
	if(sis->sis.proy==SIS_Conforme){
		if(sis->sis.e==0) sis->sis.e=sis->sis.a;
		elif(sis->sis.a==0) sis->sis.a=sis->sis.e;
	}
	bufreturn(0);
}
#undef bufreturn

int lee_ficheroapr(const char16_t* ficheroapr, u8int * _unused(prm), u8int limpio, Vector_CentroProy *centros,char8_t* *pnombresCP,Vector_PesoCP *pesoscp, Vector_PuntoM *puntosM,char8_t* *pnombresM,Vector_PesoP *pesosp, s8int *deccp,s8int *decp, float σcpXY, float σcpZ, float σpXY, float σpZ, float σcpΩΦ, float σcpK){
	int nret=0;
	Bufferti8 buffer;
	char16_t* pterror;
	bint bdatos;
	u8int uni;
	double ccpi;
	uint bytes_read;
	Growing_char nombresCP, nombresM;
	if(centros!=NULL){centros->ppio=NULL; centros->n=0;}
	if(pesoscp!=NULL){pesoscp->ppio=NULL; pesoscp->n=0;}
	if(puntosM!=NULL){puntosM->ppio=NULL; puntosM->n=0;}
	if(pesosp!=NULL){pesosp->ppio=NULL; pesosp->n=0;}

	uni=ATUNIGIROS_Sex;
	ccpi=CCPI[ATUNIGIROS_Sex];
	{const char16_t *pfich;
	path_get_filename16(ficheroapr,pfich);
	nret=tiopen_mixed(&buffer,ficheroapr);
	ifunlike(nret<0){
		ifunlike(nret==AT_NOMEM) return ATREAD_NOOPEN_MEM;
		open_file_err_str16(nret,mensaje,pfich,idioma);
		return ATREAD_NOOPEN;
	}
	pterror=strbuild16(mensaje,pfich,u"\n\n",NULL);
	}

	bytes_read=nret;	nret=0;
	bdatos=0;
	if(deccp!=NULL) *deccp=0;
	if(decp!=NULL) *decp=0;
	advance(buffer);
	for(;;){
	   const char8_t *s;
	   prepare_string(buffer);
	   while(*buffer.pc!='\0' && strcmp8(buffer.pc,"-ccpp") && strcmp8(buffer.pc,"-pp") && strcmp8(buffer.pc,"-uni")){
		resume(buffer);
		finishline_advance(buffer); prepare_string(buffer);
	   }
	   s=buffer.pc;
	   if(*buffer.pc!='\0') buffer.pc=buffer.next+1;
	   advance(buffer);
	   if(*buffer.pc=='\0') break;

	   if(!strcmp8(s,"-uni")){
		prepare_string(buffer);
		if(!strcmp8(buffer.pc,"rad")) uni=0;
		elif(!strcmp8(buffer.pc,"gon")) uni=1;
		elif(!strcmp8(buffer.pc,"sex")) uni=2;
		else{
			strbuild_mixed(pterror,'w',S_(Uniqueser),'w',S_(ensulugar),'c',buffer.pc,0);
			nret=ATREAD_RANGE;
		}
		resume(buffer);
		ccpi=CCPI[uni];
		finishline_advance(buffer);
	   }elif(!strcmp8(s,"-ccpp")){
		uint k=0;
		if(centros==NULL){finishline_advance(buffer); continue;}
		if(centros->ppio==NULL){k=bytes_read-(pdif)(buffer.pc-buffer.B.base); k>>=8;}
		nret=lee_centros(&buffer,pterror,limpio,centros,&nombresCP,pesoscp,k,ccpi,deccp,σcpXY,σcpZ,σcpΩΦ,σcpK);
		*pnombresCP=nombresCP.ppio;
	   }elif(!strcmp8(s,"-pp")){
		uint k=0;
		if(puntosM==NULL){finishline_advance(buffer); continue;}
		if(puntosM->ppio==NULL){k=bytes_read-(pdif)(buffer.pc-buffer.B.base); k=(uint)(k*0.0179F);}
		lee_puntosM(&buffer,pterror,limpio,puntosM,&nombresM,pesosp,k,decp,σpXY,σpZ);
		*pnombresM=nombresM.ppio;
	   }
	   ifunlike(nret){free_return(nret);}
	   bdatos=1;
	   if(*buffer.pc!='-' && *buffer.pc!='\0'){finishline_advance(buffer);}
	}
	if(!bdatos){
		if(centros!=NULL && puntosM!=NULL) strbuild16(pterror,S_(Ningunamarca),u"-ccpp, -pp",S_(queindican),S_(delos_ccpp_pp),NULL);
		elif(centros!=NULL) strbuild16(pterror,S_(Faltamarca),u"-ccpp",S_(queindica),S_(delos_ccpp),NULL);
		elif(puntosM!=NULL) strbuild16(pterror,S_(Faltamarca),u"-pp",S_(queindica),S_(delos_ccpp),NULL);
		else{free_return(0);}
		free_return(ATREAD_NODATOS);
	}
	free_return(0);
}

int lee_ficheroapr_all(const char16_t* ficheroapr, u8int * _unused(prm), u8int limpio, Vector_CentroProy *centros,char8_t* *pnombresCP,Vector_PesoCP *pesoscp, Vector_PuntoM *puntosM,char8_t* *pnombresM,Vector_PesoP *pesosp, Vector_GrupoGPSINS *grupos, Vector_uint *grupos_giro, Vector_GrupoGPSextras *gextras, char8_t* *pnombresgf, float* vv,u8int *tipo, Sistema *sis, char16_t* *fichero_int, u16int *flags, u16int *flags_errors, u16int flags_doonerror, s8int *deccp,s8int *decp, float σcpXY, float σcpZ, float σpXY, float σpZ, float σcpΩΦ, float σcpK){
	int nret=0;
	Bufferti8 buffer;
	char16_t* pterror;
	u8int uni;
	double ccpi;
	uint bytes_read;
	Growing_char nombresCP, nombresM;
	if(centros!=NULL){centros->ppio=NULL; centros->n=0;}
	if(pesoscp!=NULL){pesoscp->ppio=NULL; pesoscp->n=0;}
	if(puntosM!=NULL){puntosM->ppio=NULL; puntosM->n=0;}
	if(pesosp!=NULL){pesosp->ppio=NULL; pesosp->n=0;}
	if(grupos!=NULL){grupos->ppio=NULL; grupos->n=0;}
	if(vv!=NULL) NOTFINITE_f(*vv);
	if(fichero_int!=NULL) *fichero_int=NULL;
	*flags=0;
	*flags_errors=0;

	uni=ATUNIGIROS_Sex;
	ccpi=CCPI[ATUNIGIROS_Sex];

	{const char16_t *pfich;
	path_get_filename16(ficheroapr,pfich);
	nret=tiopen_mixed(&buffer,ficheroapr);
	ifunlike(nret<0){
		ifunlike(nret==AT_NOMEM) return ATREAD_NOOPEN_MEM;
		open_file_err_str16(nret,mensaje,pfich,idioma);
		return ATREAD_NOOPEN;
	}
	pterror=strbuild16(mensaje,pfich,u"\n\n",NULL);
	}

	bytes_read=nret; nret=0;

	if(deccp!=NULL) *deccp=0;
	if(decp!=NULL) *decp=0;

	advance(buffer);
	for(;;){
	   const char8_t *s;
	   while(*buffer.pc!='\0' && (*buffer.pc!='-' || (*(buffer.pc+1)>='0' && *(buffer.pc+1)<='9'))){
		finishline_advance(buffer);
	   }
	   string_advance(buffer,s);
	   if(*buffer.pc=='\0') break;

	   if(!strcmp8(s,"-keyvals")){
		const char8_t* *ptr;
		lee_keyvals(&buffer);
		*flags|=LEEAPRALL_KEYVALS;
		ptr=keyvals;
		while(*ptr!=NULL){
			if(*(ptr+1)==NULL){ptr+=2; continue;}
			if(!strcmp8(*ptr,"vv")){
				if(vv==NULL) goto finkeys;
				if(isfinite(*vv)){
					strbuild16(pterror,S_(Eldato),u"vv",S_(repetido),NULL);
					nret=8; *flags_errors|=LEEAPRALL_KEYVALS;
					goto finkeys;
				}
				ptr++;
				*vv=(float)double___str8(ptr);
				if(**ptr!='\0'){
					char16_t* pterror2=strbuild16(pterror,S_(Mientras),S_(vv),S_(seencontro),NULL);
					*pterror2++=**ptr;
					strcpy16(pterror2,S_(wasfound));
					nret=ATREAD_CARACTER; *flags_errors|=LEEAPRALL_KEYVALS;
				}
				if(*vv<=0){nret=ATREAD_RANGE; *flags_errors|=LEEAPRALL_KEYVALS;}
			}else if(!strcmp8(*ptr,"tipo")){
				if(tipo==NULL) goto finkeys;
				ptr++;
				if(**ptr=='0') *tipo=0;
				elif(**ptr=='2') *tipo=2;
				else *tipo=1;
			}else if(!strcmp8(*ptr,"camara") || !strcmp8(*ptr,"interna")){
				if(fichero_int==NULL) goto finkeys;
				if(*fichero_int!=NULL){
					strbuild16(pterror,S_(Eldato),u"camara",S_(repetido),NULL);
					nret=8; *flags_errors|=LEEAPRALL_KEYVALS;
					goto finkeys;
				}
				ptr++;
				*fichero_int=n_malloc(char16_t,strlen8(*ptr)+1);
				if(fichero_int==NULL) nret=AT_NOMEM;
				else{
					char16_t *ptr_w=*fichero_int;
					{const char8_t *ptr_c=*ptr; while(*ptr_c!='\0') *ptr_w++=*ptr_c++;}
					*ptr_w=u'\0';
				}
			}else{
	finkeys:	   ptr++;
			   }
			   ptr++;
		   }
	   }elif(!strcmp8(s,"-uni")){
		prepare_string(buffer);
		if(!strcmp8(buffer.pc,"rad")) uni=0;
		elif(!strcmp8(buffer.pc,"gon")) uni=1;
		elif(!strcmp8(buffer.pc,"sex")) uni=2;
		else{
			strbuild_mixed(pterror,'w',S_(Uniqueser),'w',S_(ensulugar),'c',buffer.pc,0);
			nret=ATREAD_RANGE; *flags_errors|=LEEAPRALL_UNI;
		}
		resume(buffer);
		ccpi=CCPI[uni];
		finishline_advance(buffer);
	   }elif(!strcmp8(s,"-ccpp")){
		uint k=0;
		if(centros==NULL) goto fincasos;
		if(centros->ppio==NULL){k=bytes_read-(pdif)(buffer.pc-buffer.B.base); k>>=8;}
		nret=lee_centros(&buffer,pterror,limpio,centros,&nombresCP,pesoscp,k,ccpi,deccp,σcpXY,σcpZ,σcpΩΦ,σcpK);
		*pnombresCP=nombresCP.ppio;
		ifunlike(nret) *flags_errors|=LEEAPRALL_CCPP;
		else *flags|=LEEAPRALL_CCPP;
	   }elif(!strcmp8(s,"-pp")){
		uint k=0;
		if(puntosM==NULL)  goto fincasos;
		if(puntosM->ppio==NULL){k=bytes_read-(pdif)(buffer.pc-buffer.B.base); k=(uint)(k*0.0167F);}
		nret=lee_puntosM(&buffer,pterror,limpio,puntosM,&nombresM,pesosp,k,decp,σpXY,σpZ);
		*pnombresM=nombresM.ppio;
		ifunlike(nret) *flags_errors|=LEEAPRALL_PP;
		else *flags|=LEEAPRALL_PP;
	   }elif(!strcmp8(s,"-gruposgi")){
		if(grupos==NULL)  goto fincasos;
		nret=lee_gruposapr(&buffer,pterror,grupos,grupos_giro,gextras,pnombresgf,ccpi);
		ifunlike(nret) *flags_errors|=LEEAPRALL_GRUPOSGI;
		else *flags|=LEEAPRALL_GRUPOSGI;
	   }elif(!strcmp8(s,"-sistema")){
		if(sis==NULL) goto fincasos;
		nret=lee_sistema(&buffer,pterror,sis);
		if(sis->sis.proy==SIS_Conforme){
			if(sis->sis.e==0){if(sis->sis.a!=0) sis->sis.e=sis->sis.a;}
			elif(sis->sis.a==0) sis->sis.a=sis->sis.e;
		}
		ifunlike(nret==0 && sis->sis.a==0 && sis->sis.proy!=SIS_Rectangular){
			const char16_t *s;
			switch(idioma){
				case 1:  s=u"In the -sistema element, the mandatory parameter \"a\" (semi-major axis of the Earth) was not specified"; break;
				case 2:  s=u"Nell'elemento -sistema, non si ha specificato il parametro obbligatorio \"a\" (semiasse maggiore della Terra)"; break;
				default:s=u"En el elemento -sistema, no se ha especificado el parámetro obligatorio \"a\" (semieje mayor de la Tierra)";
			}
			strcpy16(mensaje,s);
			nret=8;
		}
		ifunlike(nret) *flags_errors|=LEEAPRALL_UNI;
		else *flags|=0x20;
	   }
fincasos:
	   ifunlike(nret<0){free_return(nret);}
	   ifunlike(nret){
		   if(*flags_errors&flags_doonerror){free_return(nret);}
		   nret=0;
	   }
	   if(*buffer.pc!='-' && *buffer.pc!='\0'){finishline_advance(buffer);}
	}
	if(!(*flags & 6)){
		if(centros!=NULL && puntosM!=NULL) strbuild16(pterror,S_(Ningunamarca),u"-ccpp, -pp",S_(queindican),S_(delos_ccpp_pp),NULL);
		elif(centros!=NULL) strbuild16(pterror,S_(Faltamarca),u"-ccpp",S_(queindica),S_(delos_ccpp),NULL);
		elif(puntosM!=NULL) strbuild16(pterror,S_(Faltamarca),u"-pp",S_(queindica),S_(delos_ccpp),NULL);
		else{free_return(0);}
		free_return(ATREAD_NODATOS);
	}
	free_return(0);
}

int lee_ficheroapy(const char16_t* ficheroapy, u8int *pym, u8int limpio, Vector_PuntoM *puntosA,char8_t* *pnombres,Vector_PesoP *pesos, float σXY, float σZ, s8int *dec){
	int nret;
	Bufferti8 buffer;
	char16_t* pterror;
	uint k;
	Growing_char nombres;
	Vector_PesoP * _pesos;

	puntosA->ppio=NULL;	puntosA->n=0;
	pesos->ppio=NULL;	pesos->n=0;
	ifunlike(*pym>PUNTOSFORMAT_Aerotri){
		strbuild16(mensaje,S_(Formatodesconocido),S_(deapoyo),S_(file),u": ",ficheroapy,NULL);
		return ATREAD_UNKNOWNFORMAT;
	}

	{const char16_t *pfich;
	path_get_filename16(ficheroapy,pfich);
	nret=tiopen_mixed(&buffer,ficheroapy);
	ifunlike(nret<0){
		ifunlike(nret==AT_NOMEM) return ATREAD_NOOPEN_MEM;
		open_file_err_str16(nret,mensaje,pfich,idioma);
		return ATREAD_NOOPEN;
	}
	pterror=strbuild16(mensaje,pfich,u"\n\n",NULL);
	}

	if(dec!=NULL) *dec=0;
	if(*pym==PUNTOSFORMAT_XYZ){
		advance(buffer);
		if(*buffer.pc=='-'){
			buffer.pc++;
			if(*buffer.pc=='p'){buffer.pc++;
			if(*buffer.pc=='p'){buffer.pc++;
				if(*buffer.pc==' ' || *buffer.pc=='\t' || *buffer.pc=='\n') *pym=PUNTOSFORMAT_Aerotri;
			}}
			finishline_advance(buffer);
		}
		if(*pym==PUNTOSFORMAT_XYZ){
			while(*buffer.pc=='-' || *buffer.pc=='#' || *buffer.pc==';' || *buffer.pc=='%'){finishline_advance(buffer);}
		}
	}else{
		buffer.pc=codigo_advance(buffer.pc,"-pp",3);
		if(*buffer.pc=='\0'){
			strbuild16(pterror,S_(Faltamarca),u"-pp",S_(queindica),S_(delos_pp),NULL);
			free_return(ATREAD_NODATOS);
		}
	}
	if(*buffer.pc=='\0'){
		strbuild16(pterror,S_(Nocontienedatos),NULL);
		return ATREAD_NODATOS;
	}

	k=nret-(pdif)(buffer.pc-buffer.B.base);
	if(*pym==PUNTOSFORMAT_Aerotri){k=(uint)(k*0.017F); _pesos=pesos;}
	else{k=(uint)(k*0.019F); _pesos=NULL;}
	nret=lee_puntosM(&buffer,pterror,limpio,puntosA,&nombres,_pesos,k,dec,σXY,σZ);
	*pnombres=nombres.ppio;
	free_return(nret);
}

#define buffer (*pbuffer)
#undef if_inline_all
#define if_inline_all(x,cod) iflike_moreinl(buffer){ifnot_get_double_inline(buffer,x){cod_error=cod; goto error_caracter;}}
int lee_ficheroccpp_eo(Bufferti8 *pbuffer, int nchars, char16_t* pterror, Vector_CentroProy *centros,Growing_char *nombres){
	uint nguess;
	int cod_error;
	double ccpi_1;
	CentroProy CP;

	ccpi_1=CCPI_1[ATUNIGIROS_Sex];

	advance(buffer);
	while(*buffer.pc=='#' || *buffer.pc==';' || *buffer.pc=='-' || *buffer.pc=='%') finishline_advance(buffer);
	if(*buffer.pc=='\0'){
		strbuild16(pterror,S_(Nocontienedatos),NULL);
		return ATREAD_NODATOS;
	}

	nguess=(nchars-(pdif)(buffer.pc-buffer.B.base))/138; //140
	Vsetup(CentroProy,*centros,nguess,goto no_mem0);
	advance_next(buffer);
	nguess*=(pdif)(buffer.next-buffer.pc)+1;
	nguess&=~31U; nguess+=32;		GC_initialize(*nombres,nguess,goto no_mem3);

	default_values_CP(CP);
	while(*buffer.pc!='\0'){
		Giro3D_double G;
		get_stringGC_advanceinline(buffer,*nombres,CP.index);
		if_inline_all(CP.P.X,T_coorX);	if_inline_all(CP.P.Y,T_coorY);	if_inline_all(CP.P.Z,T_coorZ);
		if_inline_all(G.ω,T_Omega);	if_inline_all(G.φ,T_Phi);		if_inline_all(G.κ,T_Kappa)
		else{strbuild_mixed(pterror,'w',S_(Enpunto),'c',nombres->ppio+CP.index,'w',S_(Faltancampos), 'w',u"X Y Z Ω Φ Kappa",0);
				return ATREAD_LINEA;}
		P_eq(G,=-,G);
		if(flags0&1) *(Giro3D_double*)CP.M[0]=G;
		else{P_mul(G,ccpi_1); MatrizRot_ωφκ(G,CP.M);}
		Vadd(*centros,CentroProy,CP,goto no_mem3);
		finishline_advance(buffer);
	}
	return 0;

error_caracter:
	pterror=strbuild_mixed(pterror,'w',S_(Enccpp),'c',nombres->ppio+CP.index,'w',S_(Mientras),'w',TEXTO_lecturaf(cod_error),'w',S_(seencontro),0);
	*pterror++=*buffer.pc; strcpy16(pterror,S_(wasfound));
	return ATREAD_CARACTER;

	salida_outofmem:
	no_mem3:
free(centros->ppio);		no_mem0:
centros->ppio=NULL;
	return AT_NOMEM;
}

#define ifnot_get_doublechsgn_inline(buffer,x) ifnot_get_advanceinline(buffer,x,-vfdouble___str8)	/*para el .ori de PATB*/
#define if_inline_all_chsgn(x) iflike_moreinl(buffer){ifnot_get_doublechsgn_inline(buffer,x){cod_error=-1; goto error_caracter;}}
int lee_ficheroccpp_patb(Bufferti8 *pbuffer, int nchars, char16_t* pterror, Vector_CentroProy *centros,Growing_char *nombres){
	uint nguess;
	int cod_error;
	CentroProy CP;

	advance(buffer);
	if(*buffer.pc=='\0'){
		strbuild16(pterror,S_(Nocontienedatos),NULL);
		return ATREAD_NODATOS;
	}

	nguess=(nchars-(pdif)(buffer.pc-buffer.B.base))/160;
	Vsetup(CentroProy,*centros,nguess,goto no_mem0);
	advance_next(buffer);
	nguess*=(pdif)(buffer.next-buffer.pc)+1;
	nguess&=~31U; nguess+=32;		GC_initialize(*nombres,nguess,goto no_mem3);

	default_values_CP(CP);

	while(*buffer.pc!='\0'){
		bint modo;
		get_stringGC_advance(buffer,*nombres,CP.index);
		if_moreinl(buffer){if(*buffer.pc=='1') modo=1; else modo=0; ignore_advanceinline(buffer);}
		if_inline_all(CP.P.X,T_coorX);	if_inline_all(CP.P.Y,T_coorY);	if_inline_all(CP.P.Z,T_coorZ) else goto eol_inesperado;
		finishline_advance(buffer);

		if(!modo){
			if_inline_all_chsgn(CP.M[0][0]);	if_inline_all_chsgn(CP.M[1][0]);	if_inline_all(CP.M[2][0],-1);
			if_inline_all_chsgn(CP.M[0][1]);	if_inline_all_chsgn(CP.M[1][1])		else goto eol_inesperado;
			finishline_advance(buffer);
			if_inline_all(CP.M[2][1],-1);				if_inline_all_chsgn(CP.M[0][2]);	if_inline_all_chsgn(CP.M[1][2]);	if_inline_all(CP.M[2][2],-1) else goto eol_inesperado;
		}else{
			double *ptr=CP.M[0];
			if_inline_all(*ptr++,-1);	if_inline_all(*ptr++,-1);	if_inline_all(*ptr++,-1);	if_inline_all(*ptr++,-1);	if_inline_all(*ptr++,-1)	else goto eol_inesperado;
			finishline_advance(buffer);
			if_inline_all(*ptr++,-1);	if_inline_all(*ptr++,-1);	if_inline_all(*ptr++,-1);	if_inline_all(*ptr++,-1) else goto eol_inesperado;
		}

		Vadd(*centros,CentroProy,CP,goto no_mem3);
		finishline_advance(buffer);
	}
	return 0;

eol_inesperado:
	strcpy16(pterror,S_(Finaldelinea_raw));
	return ATREAD_LINEA;
error_caracter:
	pterror=strbuild_mixed(pterror,'w',S_(Enccpp),'c',nombres->ppio+CP.index,'w',S_(Mientras),0);
	if(cod_error>=0) pterror=strpcpy16(pterror,TEXTO_lecturaf(cod_error));
	else pterror=strpcpy16(pterror,S_(unnumero));
	pterror=strpcpy16(pterror,S_(seencontro));
	*pterror++=*buffer.pc; strcpy16(pterror,S_(wasfound));
	return ATREAD_CARACTER;

	salida_outofmem:
	no_mem3:
free(centros->ppio);		no_mem0:
centros->ppio=NULL;
	return AT_NOMEM;
}
#undef ifnot_get_doublechsgn_inline
#undef if_inline_all_chsgn
#undef if_inline_all
#undef buffer

int lee_ficheroccpp(const char16_t* ficheroccpp, u8int *prm, u8int limpio, Vector_CentroProy *centros,char8_t* *pnombres, Vector_PesoCP *pesos, s8int *dec){
	int nret;
	Bufferti8 buffer;
	int nchars;
	char16_t* pterror;
	Growing_char nombres;

	if(*prm==CCPPFORMAT_Aerotriccpp) return lee_ficheroapr(ficheroccpp,prm,limpio,centros,pnombres,pesos,NULL,NULL,NULL,dec,NULL,-1,-1,-1,-1,-1,-1);

	centros->ppio=NULL; centros->n=0;
	nombres.ppio=NULL;

	{const char16_t *pfich;
	path_get_filename16(ficheroccpp,pfich);
	nchars=tiopen_mixed(&buffer,ficheroccpp);
	ifunlike(nchars<0){
		ifunlike(nchars==AT_NOMEM) return ATREAD_NOOPEN_MEM;
		open_file_err_str16(nchars,mensaje,pfich,idioma);
		return ATREAD_NOOPEN;
	}
	pterror=strbuild16(mensaje,pfich,u"\n\n",NULL);
	}

	switch(*prm){
		case CCPPFORMAT_ΩΦΚ: nret=lee_ficheroccpp_eo(&buffer,nchars,pterror,centros,&nombres); break;
		case CCPPFORMAT_PATB: nret=lee_ficheroccpp_patb(&buffer,nchars,pterror,centros,&nombres); break;
		default: strcpy16(pterror,S_(Formatodesconocido)); nret=ATREAD_UNKNOWNFORMAT;
	}
	ticlose(buffer);

	if(centros->ppio!=NULL){
		*nombres.next='\0'; *pnombres=nombres.ppio;
		if(dec!=NULL){
			CentroProy *ptr=centros->ppio;
			dontimes((centros->n+7)>>3,ptr+=8){
				s8int sa;
				if((sa=ndecimales_P(ptr->P))>*dec) *dec=sa;
		}	}
	}
	return nret;
}

void escribe_sis(Bufferto8* fo, Sistema* sis, s8int dec){
	towrite8_string(fo,"-sistema\n"
						"  Sistema ");
	if(sis->sis.proy==SIS_Rectangular){
		towrite8_string(fo,"Rectangular\n");
		return;
	}
	setbuf_absolute(fo);
	if(sis->sis.proy==SIS_Lambert) towrite8_string(fo,"Lambert\n");
	elif(sis->sis.proy==SIS_Mercator) towrite8_string(fo,"Mercator\n");
	elif(sis->sis.proy==SIS_Estereográfica) towrite8_string(fo,"Estereografica\n");
	elif(sis->sis.proy==SIS_Mercator_Transversa) towrite8_string(fo,"UTM\n");
	elif(sis->sis.proy==SIS_Geograficas) towrite8_string(fo,"Geograficas\n");
	else{
		towrite8_string(fo,"OtroConforme");
		fo->prec.absol=0;
		if(sis->sis.a==sis->sis.e){
			towrite8_string(fo,"\n  a "); towrite_double(fo,sis->sis.a);
		}else{
			towrite8_string(fo,"\n  N "); towrite_double(fo,sis->sis.a);
			towrite8_string(fo,"\n  rho "); towrite_double(fo,sis->sis.e);
			fo->prec.absol=1;
			towrite8_string(fo,"\n  param1 "); towrite_double(fo,sis->sis.param1.conv0);
		}
		if(dec-2>0) fo->prec.absol=dec-2;
		else fo->prec.absol=0;	//Do not upse the user by writing a rounded value different from the one he wrote
		towrite8_string(fo,"\n  ond "); towrite_double(fo,sis->sis.ond);
		fo->prec.absol=7;
		towrite8_string(fo,"\n  k0 "); towrite_double(fo,sis->sis.k0); toput_char(fo,'\n');
		return;
	}
	fo->prec.absol=dec;
	towrite8_string(fo,"  a "); towrite_double(fo,sis->sis.a);
	fo->prec.absol=9;
	towrite8_string(fo,"\n  e "); towrite_double(fo,sis->sis.e);
	if(dec-2>0) fo->prec.absol=dec-2;
	else fo->prec.absol=0;
	towrite8_string(fo,"\n  ond "); towrite_double(fo,sis->sis.ond);
	if(sis->sis.proy==SIS_Geograficas) return;

	fo->prec.absol=6;
	towrite8_string(fo,"\n  k0 "); towrite_double(fo,sis->sis.k0);
	if(sis->sis.proy==SIS_Lambert){
		fo->prec.absol=9;
		towrite8_string(fo,"\n  param1 "); towrite_double(fo,sis->sis.param1.φ0);
	}
	fo->prec.absol=dec;
	if(sis->sis.proy!=SIS_Mercator){towrite8_string(fo,"\n  xO "); towrite_double(fo,sis->sis.xO);}
	towrite8_string(fo,"\n  yS "); towrite_double(fo,sis->sis.yS); toput_char(fo,'\n');
}

#define fo (&_fo)
int escribe_prmpym(const char16_t* ficheroprm, CentroProy* centros,uint ncp,PesoCP *pesoscp, PuntoM* puntosM,uint npm,PesoP *pesosp, s8int uni, s8int decf, s8int decp, Sistema* sis, u8int marca, u8int modoccpp, float σcpXY, float σcpZ, float σpXY, float σpZ, float σcpΩΦ, float σcpK){
	int nret;
	Bufferto8 _fo;
	double ccpi;
	s8int decg;
	Giro3D_double G;
	PuntoM* punpm;
	CentroProy* puncp;

	if(uni>=0) ccpi=CCPI[uni];
	else ccpi=-CCPI[-uni];	//negative radians are not available
	if(!(flags0&1)){
		σcpΩΦ*=(float)ccpi;
		σcpK*=(float)ccpi;
	}
	decg=5;
	if(ccpi>50) decg=4;
	elif(ccpi<5) decg=6;

	nret=toopen_mixed(fo,ficheroprm);
	ifunlike(nret){
		char16_t* pc=strbuild16(mensaje,S_Elfichero,ficheroprm,S_no_se_pudo_abrir_para_escribir,NULL);
		strcpy16(pc,TEXTOS_fileopen[nret][idioma]);
		return nret;
	}
	if(marca!=3){
		if(ncp){
			const char8_t *s;
			towrite8_string(fo,"-uni ");
			if(uni<0){toput_char(fo,'-');}
			if(uni==1 || uni==-1) s="gon\n";
			elif(uni==2 || uni==-2) s="sex\n";
			else s="rad\n";
			towrite8_string(fo,s);
		}
		if(sis!=NULL){
			s8int dec;
			toput_char(fo,'\n');
			dec=decf;
			if(decp>dec) dec=decp;
			escribe_sis(fo,sis,dec);
		}
	}
	if(ncp!=0 && marca!=3) towrite8_string(fo,"\n-ccpp\n");
	puncp=centros;
	dontimes(ncp,puncp++){
		if(flags0&1){
			G=*(Giro3D_double*)puncp->M[0];
			if(uni<0) P_eq(G,=-,G);
		}else{
			G=Gmatriz_ωφκ_seg(puncp->M);	P_mul(G,ccpi);
		}
		towrite8_aligned_string(fo,puncp->nom,9); toput_char(fo,' ');
		fo->prec.absol=decf;
		towrite8_aligned_double(fo,puncp->P.X,13); toput_char(fo,' ');
		towrite8_aligned_double(fo,puncp->P.Y,13); toput_char(fo,' ');
		towrite8_aligned_double(fo,puncp->P.Z,13); toput_char(fo,' ');
		fo->prec.absol=decg;
		towrite8_aligned_double(fo,G.ω,10); toput_char(fo,' ');
		towrite8_aligned_double(fo,G.φ,10); toput_char(fo,' ');
		towrite8_aligned_double(fo,G.κ,10); toput_char(fo,' ');
		if(marca!=0 && marca!=3){
			towrite8_string(fo,"  ");
			if(marca==1){
				char8_t c='0'+puncp->b;
				toput_char(fo,c);
			}else{//marca==2
				if(modoccpp==0){
					char8_t c1, c2;
					umint gp, gp2;
					c2=c1='0';
					gp=puncp->gggppp;
					gp2=puncp->gggppp2;
					if((gp&007)==007 && gp2==0) c1='1';	//It could be:	if( ((gp | gp2)&007)==007 ){
					elif( ((gp | gp2)&007)==007 ) c1='2';	//					if(gp2!=0) c1=2;
					if((gp&070)==070 && gp2==0) c2='1';	//					else c1=1;
					elif( ((gp | gp2)&070)==070 ) c2='2';	//				}
					toput_char(fo,c1);							//But the case c1=1 is much more probable
					toput_char(fo,' '); toput_char(fo,c2);
				}else{
					uint naux, nauxb;
					char8_t s[8]="000 000";
					naux=nauxb=0;
					if(puncp->gggppp2&1) s[0]='2';		elif(puncp->gggppp&1) s[0]='1';
					if(puncp->gggppp2&2) s[1]='2';		elif(puncp->gggppp&2) s[1]='1';
					if(puncp->gggppp2&4) s[2]='2';		elif(puncp->gggppp&4) s[2]='1';
					if(puncp->gggppp2&010) s[4]='2';	elif(puncp->gggppp&010) s[4]='1';
					if(puncp->gggppp2&020) s[5]='2';	elif(puncp->gggppp&020) s[5]='1';
					if(puncp->gggppp2&040) s[6]='2';	elif(puncp->gggppp&040) s[6]='1';

					towrite8_string(fo,s);
				}
			}
		}
		if(pesoscp!=NULL && puncp->peso!=0){
			u8int k;
			PesoCP *ppeso;
			setbuf_relative(fo); setbuf_limpio(fo); fo->prec.signi=3;
			ppeso=pesoscp+puncp->peso;
			k=0;
			if(ppeso->p.X!=1 || ppeso->p.Z!=1){
				toput_char(fo,' ');
				if(ppeso->p.X!=1){towrite8_string(fo," ;"); towrite8_float(fo,ppeso->p.X*σcpXY); k=1;}
				if(ppeso->p.Z!=1){
					for(;k<1;k++) towrite8_string(fo," ;");
					towrite8_string(fo," ;"); towrite8_float(fo,ppeso->p.Z*σcpZ);
					k=2;
				}
			}
			if(ppeso->g.X!=1 || ppeso->g.Z!=1){
				toput_char(fo,' ');
				if(ppeso->g.X!=1){
					for(;k<2;k++) towrite8_string(fo," ;");
					towrite8_string(fo," ;"); towrite8_float(fo,ppeso->g.X*σcpΩΦ);
					k=3;
				}
				if(ppeso->g.Z!=1){
					for(;k<3;k++) towrite8_string(fo," ;");
					towrite8_string(fo," ;"); towrite8_float(fo,ppeso->g.Z*σcpK);
				}
			}
			setbuf_absolute(fo); setbuf_nolimpio(fo);
		}
		toput_char(fo,'\n');
	}

	if(npm){
		toput_char(fo,'\n');
		if(marca!=3) towrite8_string(fo,"-pp\n");
	}
	if(marca==3) marca=0;
	punpm=puntosM;
	dontimes(npm,punpm++){
		towrite8_aligned_string(fo,punpm->nom,9); toput_char(fo,' ');
		fo->prec.absol=decp;
		towrite8_aligned_double(fo,punpm->P.X,13); toput_char(fo,' ');
		towrite8_aligned_double(fo,punpm->P.Y,13); toput_char(fo,' ');
		towrite8_aligned_double(fo,punpm->P.Z,13);
		if(marca){
			towrite8_string(fo,"   ");
			if(marca==1){
				char8_t naux='0';
				if((punpm->bbb&7)==7 && (punpm->bbb&070)==0) naux='1';
				elif( ((punpm->bbb | (punpm->bbb>>3))&7)==7 ) naux='2';
				toput_char(fo,naux);
			}else{
				char8_t s[4]="000";
				if(punpm->bbb&010) s[0]='2';		elif(punpm->bbb&1) s[0]='1';
				if(punpm->bbb&020) s[1]='2';		elif(punpm->bbb&2) s[1]='1';
				if(punpm->bbb&040) s[2]='2';		elif(punpm->bbb&4) s[2]='1';
				towrite8_string(fo,s);
			}
		}
		if(pesosp!=NULL && punpm->peso!=0){
			PesoP *ppeso=pesosp+punpm->peso;
			u8int k=0;
			if(ppeso->X!=1 || ppeso->Z!=1){
				setbuf_relative(fo); setbuf_limpio(fo); fo->prec.signi=3;
				toput_char(fo,' ');
				if(ppeso->X!=1){towrite8_string(fo," ;"); towrite8_float(fo,ppeso->X*σpXY); k=1;}
				if(ppeso->Z!=1){
					for(;k<1;k++) towrite8_string(fo," ;");
					towrite8_string(fo," ;"); towrite8_float(fo,ppeso->Z*σpZ);
				}
				setbuf_absolute(fo); setbuf_nolimpio(fo);
			}
		}
		toput_char(fo,'\n');
	}
	toclose(fo);
	ifunlike(fo->error_code){
		strbuild16(mensaje,S_Hubo_un_error_al_escribir_el_fichero,ficheroprm,S_El_fichero_generado_no_es_correcto,NULL);
	}
	return fo->error_code;
}
#undef fo

int escribe_prm(const char16_t* ficheroprm, CentroProy* centros, uint ncp, PuntoM* puntosM, uint npm, s8int uni, s8int deccp, s8int decp, u8int marca){
	return escribe_prmpym(ficheroprm,centros,ncp,NULL,puntosM,npm,NULL,uni,deccp,decp,NULL,(u8int)(marca!=0),2,-1,-1,-1,-1,-1,-1);
}
int escribeccpp_eo(const char16_t* ficheroprm, CentroProy* centros, uint ncp, s8int deccp){
	return escribe_prmpym(ficheroprm,centros,ncp,NULL,NULL,0,NULL,-ATUNIGIROS_Sex,deccp,0,NULL,3,2,-1,-1,-1,-1,-1,-1);
}

#undef COMMENT_CHAR

#define fo (&_fo)
int escribeccpp_patb(const char16_t* ficheroori, CentroProy* centros, uint ncp, u8int modo){
	int nret;
	Bufferto8 _fo;

	nret=toopen_mixed(fo,ficheroori);
	ifunlike(nret){
		char16_t* pc=strbuild16(mensaje,S_Elfichero,ficheroori,S_no_se_pudo_abrir_para_escribir,NULL);
		strcpy16(pc,TEXTOS_fileopen[nret][idioma]);
		return nret;
	}

	dontimes(ncp,centros++){
		PuntoXYZ_double P;
		const char8_t *s;
		double (*M)[3];
		double m;

		P=centros->P;
		towrite8_aligned_string(fo,centros->nom,10);
		if(!modo) s="       0 ";
		else s="       1 ";
		towrite8_string(fo,s);
		fo->prec.absol=3;
		towrite8_aligned_double(fo,P.X,13);
		toput_char(fo,' '); towrite8_aligned_double(fo,P.Y,13);
		toput_char(fo,' '); towrite8_aligned_double(fo,P.Z,13); toput_char(fo,'\n');
		M=centros->M;
		fo->prec.absol=6;
		if(!modo) m=-M[0][0];	else m=M[0][0];	towrite8_aligned_double(fo,m,10); toput_char(fo,' ');
		if(!modo) m=-M[1][0];	else m=M[0][1];	towrite8_aligned_double(fo,m,10); toput_char(fo,' ');
		if(!modo) m=M[2][0];	else m=M[0][2];	towrite8_aligned_double(fo,m,10); toput_char(fo,' ');
		if(!modo) m=-M[0][1];	else m=M[1][0];	towrite8_aligned_double(fo,m,10); toput_char(fo,' ');
		if(!modo) m=-M[1][1];	else m=M[1][1];		towrite8_aligned_double(fo,m,10); toput_char(fo,'\n');
		if(!modo) m=M[2][1];		else m=M[1][2];	towrite8_aligned_double(fo,m,10); toput_char(fo,' ');
		if(!modo) m=-M[0][2];	else m=M[2][0];	towrite8_aligned_double(fo,m,10); toput_char(fo,' ');
		if(!modo) m=-M[1][2];	else m=M[2][1];	towrite8_aligned_double(fo,m,10); toput_char(fo,' ');
		if(!modo) m=M[2][2];		else m=M[2][2];	towrite8_aligned_double(fo,m,10); toput_char(fo,'\n');
	}
	toclose(fo);
	ifunlike(fo->error_code){
		strbuild16(mensaje,S_Hubo_un_error_al_escribir_el_fichero,ficheroori,S_El_fichero_generado_no_es_correcto,NULL);
	}
	return fo->error_code;
}
#undef fo
