﻿#include "lectura_beginend.h"

static char16_t * const rutas_fijas[]={		//These are obviously strings of const chars, but they need to be assigned to non-const char8_t *
	u"",
	STR16_thisdir u"Digi" STR16_pathsep,
	STR16_backdir u"Aerotriangulación" STR16_pathsep,
	STR16_thisdir,
	STR16_thisdir,
};

//Rutas fijas relativas al directorio del ejecutable. No se pueden establecer fijas ya al compilar.
static char16_t	graconfigs_main_0[SHRT_PATH],
					graconfigs_main_1[SHRT_PATH],
					graconfigs_residuos_0[SHRT_PATH],
					graconfigs_residuos_1[SHRT_PATH];

static const char16_t *Graconfigs_main_storage[6],	//Al leer o al rellenar por defecto en set_trabajoAT
						*Graconfigs_residuos_storage[6]; //habrá como máximo 5 configuraciones. El resto se ignorarán.

void set_trabajoAT(TrabajoAerotri *trabajo){
	trabajo->sensor=0;
	trabajo->modos.modo_ajuste=ATMODOAJUSTE_Completo;
	trabajo->modos.modo_toma=ATMODOTOMA_Unknown;
	trabajo->modos.modo_medida=ATMODOMEDIDA_Unknown;

	trabajo->ficheros.fotos=NULL;
	trabajo->ficheros.aproximadas=NULL;
	trabajo->ficheros.apoyo=NULL;
	trabajo->ficheros.gpsins=NULL;
	trabajo->ficheros.camara=NULL;
	trabajo->ficheros.generar=5;	//Fotogramas y apoyo
	trabajo->tiposf.tfot=0;
	trabajo->tiposf.tapr=0;
	trabajo->tiposf.tapy=0;
	trabajo->tiposf.tgps=1;
	trabajo->tiposf.tint=0;
	trabajo->tiposf.tdapr=0;

	trabajo->datosgps.tdgps=1;
	trabajo->datosgps.tdins=1;
	trabajo->datosgps.signoins=1;
	trabajo->conjuntas.xy=1;
	trabajo->conjuntas.XY=1;
	trabajo->conjuntas.planiZ=0;

	trabajo->autocalib.existe=true;
	trabajo->autocalib.selected.distorsion=true;
	trabajo->autocalib.selected.componentes.radsim=true;
	trabajo->autocalib.selected.componentes.tansim=false;
	trabajo->autocalib.selected.componentes.asimetricas=true;
	trabajo->autocalib.selected.f=false;
	trabajo->autocalib.selected.pp=false;
	trabajo->autocalib.config_dist.modelo_poli=CAL_MODPOL_IMPAR;
	trabajo->autocalib.config_dist.modelo_asim=CAL_MODASIM_RADTAN;
	trabajo->autocalib.config_dist.condicion_radsim=CAL_CONDICIONR_ORTO;
	NOTFINITE_f(trabajo->autocalib.config_dist.semidiag);
	trabajo->autocalib.config_dist.param_radsim=0xE;
	trabajo->autocalib.config_dist.param_tansim=0x6;
	trabajo->autocalib.config_dist.param_asim1=0x30;
	trabajo->autocalib.config_dist.param_asim2=0x30;

	trabajo->valoresaproximados.usa_gps=2;
	trabajo->valoresaproximados.force_mmcc=1;		//va al revés. 0 significa force_mmcc
	trabajo->valoresaproximados.hacha=0;
	trabajo->valoresaproximados.maximof=0;
	trabajo->valoresaproximados.mult_contra=0;

	trabajo->opciones.estimador=1;	//Aerotri 2006
	NOTFINITE_f(trabajo->apriori.im);
	trabajo->apriori.pXY=trabajo->apriori.im;
	trabajo->apriori.pZ=trabajo->apriori.im;
	trabajo->apriori.gpsXY=trabajo->apriori.im;
	trabajo->apriori.gpsZ=trabajo->apriori.im;
	trabajo->apriori.insΩΦ=trabajo->apriori.im;
	trabajo->apriori.insK=trabajo->apriori.im;

	trabajo->opciones.unigiros=2;
	trabajo->opciones.escalaresiduos=2;
	NOTFINITE_f(trabajo->opciones.residuos_escala[0]);
	trabajo->opciones.interp_gps=2;
	trabajo->opciones.interp_resgps=0;
	trabajo->opciones.bgirok=ATTrabajo_GiroINS180_Camara;
	trabajo->opciones.fijas=1;
	trabajo->opciones.completo=1;
	trabajo->opciones.reescribe_cpp=0;

	trabajo->sistema.nsistema=SIS_Conforme;
	trabajo->sistema.elipsoide=3;	//GRS80
	trabajo->sistema.ondulacion=0;
	trabajo->sistema.elipsoideotro.a=6378136.6;
	trabajo->sistema.elipsoideotro.ee=0.006694398;
	trabajo->sistema.tierra.N=6376000;
	trabajo->sistema.tierra.rho=6376000;
	trabajo->sistema.tierra.conv=0;
	trabajo->sistema.tierra.k=1;
	trabajo->sistema.valoressistemas.LatLong=SIS_Geograficas_φλ;
	trabajo->sistema.valoressistemas.Phi0Lambert=40*3600*1000;
	trabajo->sistema.valoressistemas.XLambert=600000;
	trabajo->sistema.valoressistemas.YLambert=0;
	trabajo->sistema.valoressistemas.kLambert=1;
	trabajo->sistema.valoressistemas.XUTM=500000;
	trabajo->sistema.valoressistemas.YUTM=0;
	trabajo->sistema.valoressistemas.kUTM=0.9996;

	*(uint*)&trabajo->configsalida.ficheros=0x050F0100;
	{char16_t *ptr;
	ptr=trabajo->configsalida.general.uniim; *ptr++='p'; *ptr++='x'; *ptr='\0'; // ={'p','x','\0'};
	ptr=trabajo->configsalida.general.unif; *ptr++='m'; *ptr++='m'; *ptr='\0';
	ptr=trabajo->configsalida.general.unit; *ptr++='m'; *ptr='\0';}
	trabajo->configsalida.general.idioma=255;
	trabajo->configsalida.general.rel_paths=1;
	trabajo->configsalida.general.decres.im=2;
	trabajo->configsalida.general.decres.p=2;
	trabajo->configsalida.general.decres.gps=2;
	trabajo->configsalida.general.decres.ins=0;
	trabajo->configsalida.general.decajs.im=0;
	trabajo->configsalida.general.decajs.p=0;
	trabajo->configsalida.general.decajs.gps=0;
	trabajo->configsalida.general.decajs.ins=0;
	trabajo->configsalida.general.decrot=-7;	//fixed, 6 decimal places
	trabajo->configsalida.pares_pasadas.nmin=3;
	trabajo->configsalida.pares_pasadas.modo=0;
	trabajo->configsalida.pares_pasadas.brev=1;
	trabajo->configsalida.fich_pdf.xxx=0;	//unused
	trabajo->configsalida.fich_inf.infR=0x1F;
	trabajo->configsalida.fich_inf.infP=0x77;
	trabajo->configsalida.fich_std.stdR=0x07;
	trabajo->configsalida.fich_std.stdP=0x57;
	trabajo->configsalida.fich_Digi.files=5;
	trabajo->configsalida.fich_Digi.px=0;
	trabajo->configsalida.fich_Digi.py=0;
	trabajo->configsalida.fich_Digi.rutarel=rutas_fijas[1];
	trabajo->configsalida.fich_Digi.rutaf=rutas_fijas[2];
	trabajo->configsalida.fich_Imaster.files=7;
	trabajo->configsalida.fich_Imaster.rutarel=rutas_fijas[3];
	trabajo->configsalida.fich_Imaster.rutaf=rutas_fijas[4];
	trabajo->salidatrabajo.muestra_html=0;
	trabajo->salidatrabajo.log_ajuste=0;
	trabajo->salidatrabajo.log_level=0xD;	//1101
	trabajo->salidatrabajo.log_pdfs=0;

	char16_t *pc;
	u16int k;

	makepath_to_exec16(graconfigs_main_0,u"");
	for(pc=graconfigs_main_0;*pc!='\0';pc++);
	pc=strpcpy16(pc,u"Configuraciones" STR16_pathsep u"Grafico" STR16_pathsep);
	k=(pdif)(pc-graconfigs_main_0);
	strcpy16(graconfigs_main_1, graconfigs_main_0);
	strcpy16(graconfigs_residuos_0, graconfigs_main_0);
	strcpy16(graconfigs_residuos_1, graconfigs_residuos_0);

	strpcpy16(pc,u"f-claro.cfg");
	strpcpy16(graconfigs_main_1+k,u"f-negro.cfg");
	strpcpy16(graconfigs_residuos_0+k,u"Calib_claro.cfg");
	strpcpy16(graconfigs_residuos_1+k,u"Calib_negro.cfg");

	trabajo->configsalida.fich_dibujo.configs_main=(char16_t**)&Graconfigs_main_storage[0];
	trabajo->configsalida.fich_dibujo.configs_main[0]=graconfigs_main_0;
	trabajo->configsalida.fich_dibujo.configs_main[1]=graconfigs_main_1;
	trabajo->configsalida.fich_dibujo.configs_main[2]=NULL;
	trabajo->configsalida.fich_dibujo.configs_residuos=(char16_t**)&Graconfigs_residuos_storage[0];
	trabajo->configsalida.fich_dibujo.configs_residuos[0]=graconfigs_residuos_0;
	trabajo->configsalida.fich_dibujo.configs_residuos[1]=graconfigs_residuos_1;
	trabajo->configsalida.fich_dibujo.configs_residuos[2]=NULL;
}

#define buffer (*pbuffer)
void Prepare_line_quotes(Bufferti16 *pbuffer){
	Prepare_line(buffer);
	if(*buffer.pc=='"' && *(buffer.next-1)=='"'){
		*buffer.next--=buffer.savedchar;
		buffer.savedchar=' '; *buffer.next='\0';
		if(buffer.pc!=buffer.next) buffer.pc++;
	}
}
#undef buffer

uint16m str_b16_mask(const char16_t* cifras, uint16m _default){
	uint16m n,l;
	n=0, l=1;
	{dontimes(16,(cifras++,l<<=1)){
		if(*cifras=='-') n|=_default&l;
		else if(*cifras=='1') n|=l;
		else if(*cifras!='0') break;
	}}
	_default&=~(unsigned int)(l-1);	//cursed C promotion rules
	return n|_default;
}

u8int lee_configGeneral(Bufferti16 *pbuffer,TrabajoAerotri *trabajo);
u8int lee_ficheros(Bufferti16 *pbuffer,TrabajoAerotri *trabajo);
u8int lee_tipo_deficheros(Bufferti16 *pbuffer,TrabajoAerotri *trabajo);
u8int lee_tipo_dedatos(Bufferti16 *pbuffer,TrabajoAerotri *trabajo);
u8int lee_tipo_deajuste(Bufferti16 *pbuffer,TrabajoAerotri *trabajo);
u8int lee_fijas(Bufferti16 *pbuffer,TrabajoAerotri *trabajo);
u8int lee_conjuntas(Bufferti16 *pbuffer,TrabajoAerotri *trabajo);
u8int lee_precisiones(Bufferti16 *pbuffer,TrabajoAerotri *trabajo);
u8int lee_sistema(Bufferti16 *pbuffer,TrabajoAerotri *trabajo);
u8int lee_autocalibracion(Bufferti16 *pbuffer,TrabajoAerotri *trabajo);
u8int lee_valoresaproximados(Bufferti16 *pbuffer,TrabajoAerotri *trabajo);
u8int lee_salida(Bufferti16 *pbuffer,TrabajoAerotri *trabajo);
u8int lee_opciones(Bufferti16 *pbuffer,TrabajoAerotri *trabajo);

int lee_trabajoAT(const char16_t* ficherot, TrabajoAerotri *trabajo){
	int nret;
	Bufferti16 buffer;
	u8int flags_errors;
	u8int (*leegrupo)(Bufferti16*,TrabajoAerotri *);

	libera_trabajoAT(trabajo);
	set_trabajoAT(trabajo);
	nret=tiopen16(&buffer,ficherot);
	ifunlike(nret<0) return ATREAD_NOOPEN;

	flags_errors=0;
	while(procesa_toplevel16(&buffer,&flags_errors)){
		leegrupo=NULL;
		if(strcmp16_b(buffer.pc,u"General")==0) leegrupo=&lee_configGeneral;
		elif(strcmp16_b(buffer.pc,u"Ficheros")==0) leegrupo=&lee_ficheros;
		elif(strcmp16_b(buffer.pc,u"Tipo")==0){
			ignore_advanceinline(buffer);
			iflike(*buffer.pc++=='d' && *buffer.pc++=='e' && *buffer.pc==' '){
				advanceinline(buffer);
				iflike_Moreinl(buffer){
					if(strcmp16_b(buffer.pc,u"ficheros")==0) leegrupo=&lee_tipo_deficheros;
					elif(strcmp16_b(buffer.pc,u"datos")==0) leegrupo=&lee_tipo_dedatos;
					eliflike(strcmp16_b(buffer.pc,u"ajuste")==0) leegrupo=&lee_tipo_deajuste;
				}
			}
		}elif(strcmp16_b(buffer.pc,u"Fijas")==0) leegrupo=&lee_fijas;
		elif(strcmp16_b(buffer.pc,u"Conjuntas")==0) leegrupo=&lee_conjuntas;
		elif(strcmp16_b(buffer.pc,u"Precisiones")==0) leegrupo=&lee_precisiones;
		elif(strcmp16_b(buffer.pc,u"Sistema")==0){
			ignore_advanceinline(buffer);
			iflike(*buffer.pc++=='d' && *buffer.pc++=='e' && *buffer.pc==' '){
				advanceinline(buffer);
				iflike(strcmp16_b(buffer.pc,u"coordenadas")==0) leegrupo=&lee_sistema;
			}
		}elif(strcmp16_b(buffer.pc,u"Autocalibracion")==0) leegrupo=&lee_autocalibracion;
		elif(strcmp16_b(buffer.pc,u"Valores")==0){
			ignore_advanceinline(buffer);
			iflike(strcmp16_b(buffer.pc,u"aproximados")==0) leegrupo=&lee_valoresaproximados;
		}elif(strcmp16_b(buffer.pc,u"Informacion")==0){
			ignore_advanceinline(buffer);
			iflike(*buffer.pc++=='d' && *buffer.pc++=='e' && *buffer.pc==' '){
				advanceinline(buffer);
				iflike(strcmp16_b(buffer.pc,u"salida")==0) leegrupo=&lee_salida;
			}
		}elif(strcmp16_b(buffer.pc,u"Opciones")==0) leegrupo=&lee_opciones;

		finishline_Advance(buffer);
		iflike(leegrupo!=NULL) flags_errors|=leegrupo(&buffer,trabajo);
		else flags_errors|=skip_grupo16(&buffer);
	}
	ticlose(buffer);
	return 0;
}


#define std_beginend(buffer) \
	if(*buffer.pc=='\\'){\
		const char16_t *s;\
		string_finishline(buffer,s); Advance(buffer);\
		if(strcmp16(s,u"\\end")==0) return 0;\
		elif(strcmp16(s,u"\\begin")==0) skip_grupo16(&buffer);\
		continue;\
	}

#define buffer (*pbuffer)
u8int lee_configGeneral(Bufferti16 *pbuffer,TrabajoAerotri *trabajo){
	while(*pbuffer->pc!='\0'){
		std_beginend(buffer);
		const char16_t *pnom=pbuffer->pc;
		ignore_advanceinline(buffer);
		ifunlike_nomore(buffer) goto continua;
		if(strcmp16_b(pnom,u"Sensor")==0){
			ifunlike(strcmp16_b(pbuffer->pc,u"Modelo")==0) trabajo->sensor=1;
			else trabajo->sensor=0;
		}elif(strcmp16_b(pnom,u"Ajuste")==0){
			nocheck_get_stay(buffer,trabajo->modos.modo_ajuste,(uint8m)uint___str16);
		}elif(strcmp16_b(pnom,u"Toma")==0){
			if(strcmp16_b(pbuffer->pc,u"Plano")==0) trabajo->modos.modo_toma=ATMODOTOMA_Plano;
			elif(strcmp16_b(pbuffer->pc,u"Plano")==0) trabajo->modos.modo_toma=ATMODOTOMA_Generico;
			else trabajo->modos.modo_toma=ATMODOTOMA_Unknown;
		}elif(strcmp16_b(pnom,u"Medida")==0){
			if(strcmp16_b(pbuffer->pc,u"Manual")==0) trabajo->modos.modo_medida=ATMODOMEDIDA_Manual;
			elif(strcmp16_b(pbuffer->pc,u"Automatico")==0) trabajo->modos.modo_medida=ATMODOTOMA_Generico;
			else trabajo->modos.modo_medida=ATMODOTOMA_Generico;
		}
	continua:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}

u8int lee_ficheros(Bufferti16 *pbuffer,TrabajoAerotri *trabajo){
	while(*pbuffer->pc!='\0'){
		char16_t **ptr;
		std_beginend(buffer);
		if(strcmp16_b(pbuffer->pc,u"generar")==0){
			ignore_advanceinline(buffer);
			ifunlike_Nomore(buffer) continue;
			trabajo->ficheros.generar=(uint8m)str_b16_mask(buffer.pc,5);
			goto continuar;
		}
		ptr=NULL;
		if(strcmp16_b(pbuffer->pc,u"Fotogramas")==0) ptr=&trabajo->ficheros.fotos;
		elif(strcmp16_b(pbuffer->pc,u"Aproximadas")==0) ptr=&trabajo->ficheros.aproximadas;
		elif(strcmp16_b(pbuffer->pc,u"Apoyo")==0) ptr=&trabajo->ficheros.apoyo;
		elif(strcmp16_b(pbuffer->pc,u"GPS/INS")==0) ptr=&trabajo->ficheros.gpsins;
		elif(strcmp16_b(pbuffer->pc,u"Camara")==0) ptr=&trabajo->ficheros.camara;
		elif(strcmp16_b(pbuffer->pc,u"Interna")==0) ptr=&trabajo->ficheros.camara;
		ifunlike(ptr==NULL) goto continuar;
		free_null_if(*ptr);
		ignore_advanceinline(buffer);
		ifunlike_Nomore(buffer) goto continuar;

		Prepare_line_quotes(pbuffer);
		if(buffer.pc!=buffer.next){
			uint n=(pdif)(buffer.next-buffer.pc);
			*ptr=n_malloc(char16_t,n+1);
			iflike(*ptr!=NULL) strcpy16(*ptr,buffer.pc);
		}
		resume(buffer);
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}
u8int lee_tipo_deficheros(Bufferti16 *pbuffer,TrabajoAerotri *trabajo){
	while(*pbuffer->pc!='\0'){
		uint8m *ptr;
		std_beginend(buffer);
		ptr=NULL;
		if(strcmp16_b(pbuffer->pc,u"tffot")==0) ptr=&trabajo->tiposf.tfot;
		elif(strcmp16_b(pbuffer->pc,u"tfapr")==0) ptr=&trabajo->tiposf.tapr;
		elif(strcmp16_b(pbuffer->pc,u"tfapy")==0) ptr=&trabajo->tiposf.tapy;
		elif(strcmp16_b(pbuffer->pc,u"tfgps")==0) ptr=&trabajo->tiposf.tgps;
		elif(strcmp16_b(pbuffer->pc,u"tfint")==0) ptr=&trabajo->tiposf.tint;
		elif(strcmp16_b(pbuffer->pc,u"tdapr")==0) ptr=&trabajo->tiposf.tdapr;
		ifunlike(ptr==NULL) goto continuar;
		ignore_advanceinline(buffer);
		iflike_Moreinl(buffer){
			nocheck_get_stay(buffer,*ptr,(uint8m)uint___str16);
		}
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}

u8int lee_tipo_dedatos(Bufferti16 *pbuffer,TrabajoAerotri *trabajo){
	while(*pbuffer->pc!='\0'){
		uint8m k, *ptr;
		std_beginend(buffer);
		ptr=NULL;
		if(strcmp16_b(pbuffer->pc,u"GPS")==0) ptr=&trabajo->datosgps.tdgps;
		elif(strcmp16_b(pbuffer->pc,u"INS")==0) ptr=&trabajo->datosgps.tdins;
		ifunlike(ptr==NULL) goto continuar;
		ignore_advanceinline(buffer);
		k=10;
		if(*buffer.pc=='O') k=ATTrabajo_TDGPS_Offset;
		elif(*buffer.pc>='0' && *buffer.pc<='2') k=(uint8m)(*buffer.pc-'0');
		iflike(k!=10) *ptr=k;
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}

u8int lee_fijas(Bufferti16 *pbuffer, TrabajoAerotri *trabajo){
	while(*pbuffer->pc!='\0'){
		std_beginend(buffer);
		if(strcmp16_b(pbuffer->pc,u"Apoyo")==0){
			ignore_advance(buffer);
			iflike_Moreinl(buffer){
				trabajo->opciones.fijas=(strcmp16_b(pbuffer->pc,u"0")!=0);
			}
		}
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}

u8int lee_conjuntas(Bufferti16 *pbuffer,TrabajoAerotri *trabajo){
	while(*pbuffer->pc!='\0'){
		bool8 *ptr;
		std_beginend(buffer);
		ptr=NULL;
		if(strcmp16_b(pbuffer->pc,u"xy")==0) ptr=&trabajo->conjuntas.xy;
		elif(strcmp16_b(pbuffer->pc,u"XY")==0) ptr=&trabajo->conjuntas.XY;
		elif(strcmp16_b(pbuffer->pc,u"PlaniZ")==0) ptr=&trabajo->conjuntas.planiZ;
		ifunlike(ptr==NULL) goto continuar;
		ignore_advanceinline(buffer);
		if(*pbuffer->pc=='0') *ptr=0;
		elif(*pbuffer->pc=='1') *ptr=1;
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}

u8int lee_precisiones(Bufferti16 *pbuffer,TrabajoAerotri *trabajo){
	while(*pbuffer->pc!='\0'){
		float f, *ptr;
		std_beginend(buffer);
		ptr=NULL;
		if(strcmp16_b(pbuffer->pc,u"Fotocoordenadas")==0) ptr=&trabajo->apriori.im;
		elif(strcmp16_b(pbuffer->pc,u"ApoyoXY")==0) ptr=&trabajo->apriori.pXY;
		elif(strcmp16_b(pbuffer->pc,u"ApoyoZ")==0) ptr=&trabajo->apriori.pZ;
		elif(strcmp16_b(pbuffer->pc,u"GPSXY")==0) ptr=&trabajo->apriori.gpsXY;
		elif(strcmp16_b(pbuffer->pc,u"GPSZ")==0) ptr=&trabajo->apriori.gpsZ;
		elif(strcmp16_b(pbuffer->pc,u"INSWF")==0) ptr=&trabajo->apriori.insΩΦ;
		elif(strcmp16_b(pbuffer->pc,u"INSK")==0) ptr=&trabajo->apriori.insK;
		ignore_advanceinline(buffer);
		ifunlike(ptr==NULL || NOMORE_INL(buffer)) goto continuar;
		if_get_stay(buffer,f,float___str16) *ptr=f;
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}

u8int leesis_esfera(Bufferti16 *pbuffer, Trabajo_Sistema *sis);
u8int leesis_otro(Bufferti16 *pbuffer, Trabajo_Sistema *sis);
u8int leesis_geograficas(Bufferti16 *pbuffer, Trabajo_Sistema *sis);
u8int leesis_Lambert(Bufferti16 *pbuffer, Trabajo_Sistema *sis);
u8int leesis_UTM(Bufferti16 *pbuffer, Trabajo_Sistema *sis);
u8int lee_sistema(Bufferti16 *pbuffer, TrabajoAerotri *trabajo){
	while(*pbuffer->pc!='\0'){
		u8int k;
		if(*buffer.pc=='\\'){
			if(strcmp16_b(buffer.pc,u"\\end")==0) return 0;
			if(strcmp16_b(buffer.pc,u"\\begin")==0){
				u8int (*leegrupo)(Bufferti16*,Trabajo_Sistema *);
				ignore_advanceinline(buffer);
				leegrupo=NULL;
				if(strcmp16_b(buffer.pc,u"Esfera")==0) leegrupo=&leesis_esfera;
				elif(strcmp16_b(buffer.pc,u"Otro")==0) leegrupo=&leesis_otro;
				elif(strcmp16_b(buffer.pc,u"Geograficas")==0) leegrupo=&leesis_geograficas;
				elif(strcmp16_b(buffer.pc,u"Lambert")==0) leegrupo=&leesis_Lambert;
				elif(strcmp16_b(buffer.pc,u"Mercator")==0) leegrupo=&leesis_Lambert;
				elif(strcmp16_b(buffer.pc,u"Estereografica")==0) leegrupo=&leesis_Lambert;
				elif(strcmp16_b(buffer.pc,u"UTM")==0) leegrupo=&leesis_UTM;
				finishline_Advance(buffer);
				iflike(leegrupo!=NULL) leegrupo(pbuffer,&trabajo->sistema);
				else skip_grupo16(pbuffer);
			}
			continue;
		}
		if(strcmp16_b(pbuffer->pc,u"Sistema")==0) k=1;
		elif(strcmp16_b(pbuffer->pc,u"Elipsoide")==0) k=2;
		elif(strcmp16_b(pbuffer->pc,u"Ondulacion")==0) k=3;
		else goto continuar;
		ignore_advanceinline(buffer);
		ifunlike_Nomore(buffer) goto continuar;
		if(k==1){
			uint *pn=&trabajo->sistema.nsistema;
			if(strcmp16_b(pbuffer->pc,u"Rectangular")==0) *pn=SIS_Rectangular;
			elif(strcmp16_b(pbuffer->pc,u"Conforme genérico")==0) *pn=SIS_Conforme;
			elif(strcmp16_b(pbuffer->pc,u"Lambert")==0) *pn=SIS_Lambert;
			elif(strcmp16_b(pbuffer->pc,u"Mercator")==0) *pn=SIS_Mercator;
			elif(strcmp16_b(pbuffer->pc,u"Estereográfica")==0) *pn=SIS_Estereográfica;
			elif(strcmp16_b(pbuffer->pc,u"UTM")==0) *pn=SIS_Mercator_Transversa;
			elif(strcmp16_b(pbuffer->pc,u"Geográficas")==0) *pn=SIS_Geograficas;
		}elif(k==2){
			u8int n;
			nocheck_get_stay(buffer,n,(u8int)uint___str16);
			if(TIBUF_OK(buffer) && n<N_ElipsoideValores+2) trabajo->sistema.elipsoide=(uint8m)n;
		}else{	/*k==3*/
			float f;
			if_get_stay(buffer,f,float___str16) trabajo->sistema.ondulacion=f;
		}
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}

u8int leesis_esfera(Bufferti16 *pbuffer, Trabajo_Sistema *sis){
	bint br=false;
	while(*pbuffer->pc!='\0'){
		double f, *ptr;
		std_beginend(buffer);
		ptr=NULL;
		if(strcmp16_b(pbuffer->pc,u"r")==0) ptr=&sis->tierra.N;
		elif(strcmp16_b(pbuffer->pc,u"N")==0) ptr=&sis->tierra.N;
		elif(strcmp16_b(pbuffer->pc,u"rho")==0){
			if(!br) ptr=&sis->tierra.N;
			else ptr=&sis->tierra.rho;
		}elif(strcmp16_b(pbuffer->pc,u"conv")==0) ptr=&sis->tierra.conv;
		elif(strcmp16_b(pbuffer->pc,u"k")==0) ptr=&sis->tierra.k;
		ignore_advanceinline(buffer);
		ifunlike(ptr==NULL || NOMORE_INL(buffer)) goto continuar;
		if_get_stay(buffer,f,vfdouble___str16){
			*ptr=f;
			if(!br){sis->tierra.rho=sis->tierra.N; br=true;}
		}
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}
u8int leesis_otro(Bufferti16 *pbuffer, Trabajo_Sistema *sis){
	while(*pbuffer->pc!='\0'){
		double f, *ptr;
		std_beginend(buffer);
		ptr=NULL;
		if(strcmp16_b(pbuffer->pc,u"a")==0) ptr=&sis->elipsoideotro.a;
		elif(strcmp16_b(pbuffer->pc,u"e2")==0) ptr=&sis->elipsoideotro.ee;
		ignore_advanceinline(buffer);
		ifunlike(ptr==NULL || NOMORE_INL(buffer)) goto continuar;
		if_get_stay(buffer,f,vfdouble___str16) *ptr=f;
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}
u8int leesis_geograficas(Bufferti16 *pbuffer, Trabajo_Sistema *sis){
	while(*pbuffer->pc!='\0'){
		std_beginend(buffer);
		if(strcmp16_b(pbuffer->pc,u"orden_latlong")==0){
			ignore_advanceinline(buffer);
			iflike_Moreinl(buffer){
				if(strcmp16_b(pbuffer->pc,u"1")==0) sis->valoressistemas.LatLong=1;
				else sis->valoressistemas.LatLong=0;
			}
		}
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}
u8int leesis_Lambert(Bufferti16 *pbuffer, Trabajo_Sistema *sis){
	while(*pbuffer->pc!='\0'){
		double f, *ptr;
		std_beginend(buffer);
		if(strcmp16_b(pbuffer->pc,u"Phi0")==0){
			char16_t *ppunto;
			bint bmenos;
			uint n;
			ignore_advanceinline(buffer);
			ifunlike_Nomore(buffer) goto continuar;
			bmenos=0;
			if(*pbuffer->pc=='-'){pbuffer->pc++; bmenos=1;}

			prepare_string(buffer);
			for(ppunto=pbuffer->pc;*ppunto!='.' && *ppunto!='\0';ppunto++);
			if(*ppunto=='.') *(char16_t*)ppunto=' ';
			nocheck_get_stay(buffer,n,uint___str16);
			sis->valoressistemas.Phi0Lambert=n*3600*1000;
			if(*ppunto=='\0'){goto check_value_resume;}

			pbuffer->pc=++ppunto;
			while(*ppunto!='.' && *ppunto!='\0') ppunto++;
			if(*ppunto=='.') *(char16_t*)ppunto=' ';
			nocheck_get_stay(buffer,n,uint___str16);
			sis->valoressistemas.Phi0Lambert+=n*60*1000;
			if(*ppunto=='\0'){goto check_value_resume;}

			pbuffer->pc=++ppunto;
			while(*ppunto!='.' && *ppunto!='\0') ppunto++;
			if(*ppunto=='.') *(char16_t*)ppunto=' ';
			nocheck_get_stay(buffer,n,uint___str16);
			sis->valoressistemas.Phi0Lambert+=n*1000;
			if(*ppunto=='\0'){goto check_value_resume;}

			pbuffer->pc=++ppunto;
			while(*ppunto!='.' && *ppunto!='\0') ppunto++;
			if(*ppunto=='.') *(char16_t*)ppunto=' ';
			nocheck_get_stay(buffer,n,uint___str16);
			sis->valoressistemas.Phi0Lambert+=n;
			//if(*ppunto=='\0'){goto check_value_resume;}

		check_value_resume:
			if(sis->valoressistemas.Phi0Lambert>90*3600*1000) sis->valoressistemas.Phi0Lambert=40*3600*1000;
			if(bmenos) sis->valoressistemas.Phi0Lambert=-sis->valoressistemas.Phi0Lambert;
			resume(buffer);
			goto continuar;
		}
		ptr=NULL;
		if(strcmp16_b(pbuffer->pc,u"K0")==0) ptr=&sis->valoressistemas.kLambert;
		elif(strcmp16_b(pbuffer->pc,u"X")==0) ptr=&sis->valoressistemas.XLambert;
		elif(strcmp16_b(pbuffer->pc,u"Y")==0) ptr=&sis->valoressistemas.YLambert;
		ignore_advanceinline(buffer);
		ifunlike(ptr==NULL || NOMORE_INL(buffer)) goto continuar;
		if_get_stay(buffer,f,vfdouble___str16) *ptr=f;
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}
u8int leesis_UTM(Bufferti16 *pbuffer, Trabajo_Sistema *sis){
	while(*pbuffer->pc!='\0'){
		double f, *ptr;
		std_beginend(buffer);
		ptr=NULL;
		if(strcmp16_b(pbuffer->pc,u"K0")==0) ptr=&sis->valoressistemas.kUTM;
		elif(strcmp16_b(pbuffer->pc,u"X")==0) ptr=&sis->valoressistemas.XUTM;
		elif(strcmp16_b(pbuffer->pc,u"Y")==0) ptr=&sis->valoressistemas.YUTM;
		ignore_advanceinline(buffer);
		ifunlike(ptr==NULL || NOMORE_INL(buffer)) goto continuar;
		if_get_stay(buffer,f,vfdouble___str16) *ptr=f;
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}

u8int lee_tipo_deajuste(Bufferti16 *pbuffer, TrabajoAerotri *trabajo){
	while(*pbuffer->pc!='\0'){
		std_beginend(buffer);
		if(strcmp16_b(pbuffer->pc,u"0")==0) trabajo->opciones.estimador=0;
		else trabajo->opciones.estimador=1;
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}

u8int lee_distorsion(Bufferti16 *pbuffer, Trabajo_AutoCalib *autocalib);
u8int lee_autocalibracion(Bufferti16 *pbuffer, TrabajoAerotri *trabajo){
	while(*pbuffer->pc!='\0'){
		bool8 *ptr;
		if(*buffer.pc=='\\'){
			if(strcmp16_b(buffer.pc,u"\\end")==0) return 0;
			if(strcmp16_b(buffer.pc,u"\\begin")==0){
				u8int (*leegrupo)(Bufferti16*,Trabajo_AutoCalib *);
				ignore_advanceinline(buffer);
				leegrupo=NULL;
				if(strcmp16_b(buffer.pc,u"Funcion")==0){
					ignore_advanceinline(buffer);
					if(strcmp16_b(buffer.pc,u"de")==0){
						ignore_advanceinline(buffer);
						if(strcmp16_b(buffer.pc,u"distorsion")==0) leegrupo=&lee_distorsion;
					}
				}
				finishline_Advance(buffer);
				iflike(leegrupo!=NULL) leegrupo(pbuffer,&trabajo->autocalib);
				else skip_grupo16(pbuffer);
			}
			continue;
		}
		if(strcmp16_b(pbuffer->pc,u"presente")==0){
			ignore_advanceinline(buffer);
			iflike_Moreinl(buffer){
				trabajo->autocalib.existe=(strcmp16_b(buffer.pc,u"no")!=0);
			}
			goto continuar;
		}
		ptr=NULL;
		if(strcmp16_b(pbuffer->pc,u"f")==0) ptr=&trabajo->autocalib.selected.f;
		elif(strcmp16_b(pbuffer->pc,u"pp")==0) ptr=&trabajo->autocalib.selected.pp;
		elif(strcmp16_b(pbuffer->pc,u"x")==0) ptr=&trabajo->autocalib.selected.pp; //old
		elif(strcmp16_b(pbuffer->pc,u"y")==0) ptr=&trabajo->autocalib.selected.pp; //old
		ignore_advanceinline(buffer);
		ifunlike(ptr==NULL || NOMORE_INL(buffer)) goto continuar;
		if(*pbuffer->pc=='0') *ptr=0;
		else *ptr=1;
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}

u8int leedist_radial(Bufferti16 *pbuffer, Trabajo_AutoCalib *autocalib);
u8int leedist_tangencial(Bufferti16 *pbuffer, Trabajo_AutoCalib *autocalib);
u8int leedist_asim(Bufferti16 *pbuffer, Trabajo_AutoCalib *autocalib);
u8int lee_distorsion(Bufferti16 *pbuffer, Trabajo_AutoCalib *autocalib){
	while(*pbuffer->pc!='\0'){
		const char16_t *ptr;
		if(*buffer.pc=='\\'){
			if(strcmp16_b(buffer.pc,u"\\end")==0) return 0;
			if(strcmp16_b(buffer.pc,u"\\begin")==0){
				u8int (*leegrupo)(Bufferti16*,Trabajo_AutoCalib *);
				ignore_advanceinline(buffer);
				leegrupo=NULL;
				if(strcmp16_b(buffer.pc,u"Radial")==0) leegrupo=&leedist_radial;
				elif(strcmp16_b(buffer.pc,u"Tangencial")==0) leegrupo=&leedist_tangencial;
				elif(strcmp16_b(buffer.pc,u"Asimetricas")==0) leegrupo=&leedist_asim;
				finishline_Advance(buffer);
				iflike(leegrupo!=NULL) leegrupo(pbuffer,autocalib);
				else skip_grupo16(pbuffer);
			}
			continue;
		}
		ptr=buffer.pc;
		ignore_advanceinline(buffer);
		ifunlike_Nomore(buffer) goto continuar;
		if(strcmp16_b(ptr,u"presente")==0){
			autocalib->selected.distorsion=(strcmp16_b(buffer.pc,u"si")==0);
		}elif(strcmp16_b(ptr,u"modelo")==0){
			ptr=buffer.pc;
			ignore_advanceinline(buffer);
			ifunlike_Nomore(buffer) goto continuar;
			if(strcmp16_b(ptr,u"polinomico")==0){
				if(strcmp16_b(buffer.pc,u"Completo")==0) autocalib->config_dist.modelo_poli=CAL_MODPOL_COMPLETO;
				else autocalib->config_dist.modelo_poli=CAL_MODPOL_IMPAR;
			}elif(strcmp16_b(ptr,u"asimetrico")==0){
				if(strcmp16_b(buffer.pc,u"Vector")==0) autocalib->config_dist.modelo_asim=CAL_MODASIM_VECTOR;
				else autocalib->config_dist.modelo_asim=CAL_MODASIM_RADTAN;
			}
		}
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}

u8int leedist_radial(Bufferti16 *pbuffer, Trabajo_AutoCalib *autocalib){
	while(*pbuffer->pc!='\0'){
		const char16_t *ptr;
		std_beginend(buffer);
		ptr=buffer.pc;
		ignore_advanceinline(buffer);
		ifunlike_Nomore(buffer) goto continuar;
		if(strcmp16_b(ptr,u"presente")==0){
			autocalib->selected.componentes.radsim=(strcmp16_b(buffer.pc,u"si")==0);
		}elif(strcmp16_b(ptr,u"parametros")==0){
			autocalib->config_dist.param_radsim=str_b16_mask(buffer.pc,0x06);
		}
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}
u8int leedist_tangencial(Bufferti16 *pbuffer, Trabajo_AutoCalib *autocalib){
	while(*pbuffer->pc!='\0'){
		const char16_t *ptr;
		std_beginend(buffer);
		ptr=buffer.pc;
		ignore_advanceinline(buffer);
		ifunlike_Nomore(buffer) goto continuar;
		if(strcmp16_b(ptr,u"presente")==0){
			autocalib->selected.componentes.tansim=(strcmp16_b(buffer.pc,u"si")==0);
		}elif(strcmp16_b(ptr,u"parametros")==0){
			autocalib->config_dist.param_tansim=str_b16_mask(buffer.pc,0);
		}
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}
u8int leedist_asim(Bufferti16 *pbuffer, Trabajo_AutoCalib *autocalib){
	while(*pbuffer->pc!='\0'){
		const char16_t *ptr;
		std_beginend(buffer);
		ptr=buffer.pc;
		ignore_advanceinline(buffer);
		ifunlike_Nomore(buffer) goto continuar;
		if(strcmp16_b(ptr,u"presente")==0){
			autocalib->selected.componentes.asimetricas=(strcmp16_b(buffer.pc,u"si")==0);
		}elif(strcmp16_b(ptr,u"serie1")==0){
			autocalib->config_dist.param_asim1=str_b16_mask(buffer.pc,0);
		}elif(strcmp16_b(ptr,u"serie2")==0){
			autocalib->config_dist.param_asim2=str_b16_mask(buffer.pc,0);
		}
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}

u8int lee_valoresaproximados(Bufferti16 *pbuffer, TrabajoAerotri *trabajo){
	while(*pbuffer->pc!='\0'){
		const char16_t *ptr;
		std_beginend(buffer);
		ptr=buffer.pc;
		ignore_advanceinline(buffer);
		ifunlike_Nomore(buffer) goto continuar;
		if(strcmp16_b(ptr,u"Tipo")==0){
			if(strcmp16_b(buffer.pc,u"de")==0){
				ignore_advanceinline(buffer);
				if(strcmp16_b(buffer.pc,u"ajuste")==0){
					ignore_advanceinline(buffer);
					trabajo->valoresaproximados.force_mmcc=(*pbuffer->pc!='0');
				}
			}
		}elif(strcmp16_b(ptr,u"Usa")==0){
			if(strcmp16_b(buffer.pc,u"gps")==0){
				ignore_advanceinline(buffer);
				if(*pbuffer->pc<='0' && *pbuffer->pc>=2) trabajo->valoresaproximados.usa_gps=(uint8m)(*pbuffer->pc-'0');
			}
		}elif(strcmp16_b(ptr,u"Minimo")==0){
			if(strcmp16_b(buffer.pc,u"puntos")==0){
				ignore_advanceinline(buffer);
				iflike_Moreinl(buffer){
					u16int n;
					if_get_stay(buffer,n,(u16int)uint___str16) trabajo->valoresaproximados.hacha=n;
				}
			}
		}elif(strcmp16_b(ptr,u"Parametro")==0){
			if(strcmp16_b(buffer.pc,u"de")==0){
				ignore_advanceinline(buffer);
				if(strcmp16_b(buffer.pc,u"camino")==0){
					ignore_advanceinline(buffer);
					iflike_Moreinl(buffer){
						float f;
						if_get_stay(buffer,f,(float)vfdouble___str16) trabajo->valoresaproximados.mult_contra=(u16int)(f*100.0F);
					}
				}
			}
		}
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}

u8int lee_opciones(Bufferti16 *pbuffer, TrabajoAerotri *trabajo){
	while(*pbuffer->pc!='\0'){
		const char16_t *ptr;
		std_beginend(buffer);
		ptr=buffer.pc;
		ignore_advanceinline(buffer);
		ifunlike_Nomore(buffer) goto continuar;
		if(strcmp16_b(ptr,u"Unidades")==0){
			if(strcmp16_b(buffer.pc,u"giros")==0){
				ignore_advanceinline(buffer);
				if(*pbuffer->pc>='0' && *pbuffer->pc<='2') trabajo->opciones.unigiros=(uint8m)(*pbuffer->pc-'0');
			}
		}elif(strcmp16_b(ptr,u"Escala")==0){
			if(strcmp16_b(buffer.pc,u"residuos")==0){
				ignore_advanceinline(buffer);
				if(strcmp16_b(buffer.pc,u"-1")==0){
					float *ptr=&trabajo->opciones.residuos_escala[0];
					trabajo->opciones.escalaresiduos=-1;
					ignore_advanceinline(buffer);
					zeroset_float(trabajo->opciones.residuos_escala,20);
					NOTFINITE_f(trabajo->opciones.residuos_escala[19]);
					while(MORE_INL(buffer) && isfinite(*ptr)){
						ifnot_get_advanceinline(buffer,*ptr,(float)vfdouble___str16) break;
						ptr++;
					}
					NOTFINITE_f(*ptr);
				}else{
					u8int n;
					nocheck_get_stay(buffer,n,(u8int)uint___str16);
					iflike(TIBUF_OK(buffer) && n<4){
						trabajo->opciones.escalaresiduos=(uint8m)n;
						memcpy_float(trabajo->opciones.residuos_escala,predefined_limites[n],10);
						NOTFINITE_f(trabajo->opciones.residuos_escala[10]);
					}
				}
			}
		}elif(strcmp16_b(ptr,u"Signo")==0){
			if(strcmp16_b(buffer.pc,u"INS")==0){
				ignore_advanceinline(buffer);
				trabajo->datosgps.signoins=(*pbuffer->pc!='+');
			}
		}elif(strcmp16_b(ptr,u"Calcular")==0){
		   if(strcmp16_b(buffer.pc,u"GPS/INS")==0){
			ignore_advanceinline(buffer);
			if(strcmp16_b(buffer.pc,u"intermedios")==0){
				ignore_advanceinline(buffer);
				if(*pbuffer->pc>='0' && *pbuffer->pc<='2') trabajo->opciones.interp_gps=(uint8m)(*pbuffer->pc-'0');
		   }	}
		}elif(strcmp16_b(ptr,u"Interpolar")==0){
		   if(strcmp16_b(buffer.pc,u"residuos")==0){
			ignore_advanceinline(buffer);
			if(strcmp16_b(buffer.pc,u"GPS/INS")==0){
				ignore_advanceinline(buffer);
				trabajo->opciones.interp_resgps=(strcmp16_b(buffer.pc,u"Si")==0);
		   }	}
		}elif(strcmp16_b(ptr,u"GiroINS")==0){
			trabajo->opciones.bgirok=(strcmp16_b(buffer.pc,u"1")==0);
		}
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}

u8int leesalida_general(Bufferti16 *pbuffer,AjbloqueConfigSalida *salida);
u8int leesalida_pares(Bufferti16 *pbuffer,AjbloqueConfigSalida *salida);
u8int leesalida_informacion(Bufferti16 *pbuffer,AjbloqueConfigSalida *salida);
u8int leesalida_estadisticas(Bufferti16 *pbuffer,AjbloqueConfigSalida *salida);
u8int leesalida_Digi(Bufferti16 *pbuffer,AjbloqueConfigSalida *salida);
u8int leesalida_Imaster(Bufferti16 *pbuffer,AjbloqueConfigSalida *salida);
u8int lee_salida(Bufferti16 *pbuffer,TrabajoAerotri *trabajo){
	while(*pbuffer->pc!='\0'){
		if(*buffer.pc=='\\'){
			if(strcmp16_b(buffer.pc,u"\\end")==0) return 0;
			if(strcmp16_b(buffer.pc,u"\\begin")==0){
				u8int (*leegrupo)(Bufferti16*,AjbloqueConfigSalida *);
				ignore_advanceinline(buffer);
				leegrupo=NULL;
				if(strcmp16_b(buffer.pc,u"General")==0) leegrupo=&leesalida_general;
				elif(strcmp16_b(buffer.pc,u"Pares")==0) leegrupo=&leesalida_pares;
				elif(strcmp16_b(buffer.pc,u"Informacion")==0) leegrupo=&leesalida_informacion;
				elif(strcmp16_b(buffer.pc,u"Estadisticas")==0) leegrupo=&leesalida_estadisticas;
				elif(strcmp16_b(buffer.pc,u"Modelos")==0) leegrupo=&leesalida_Digi;
				elif(strcmp16_b(buffer.pc,u"Digi")==0) leegrupo=&leesalida_Digi;
				elif(strcmp16_b(buffer.pc,u"ImageMaster")==0) leegrupo=&leesalida_Imaster;
				finishline_Advance(buffer);
				iflike(leegrupo!=NULL) leegrupo(pbuffer,&trabajo->configsalida);
				else skip_grupo16(pbuffer);
			}
			continue;
		}
		const char16_t *ptr=buffer.pc;
		ignore_advanceinline(buffer);
		ifunlike_Nomore(buffer) goto continuar;
		if(strcmp16_b(ptr,u"Ficheros")==0){
			*(uint*)&trabajo->configsalida.ficheros=str_b16_mask(buffer.pc,0x0100);
			ignore_advanceinline(buffer);
			iflike_Moreinl(buffer){
				*(uint*)&trabajo->configsalida.ficheros|=str_b16_mask(buffer.pc,0x50F)<<16;
			}
		}elif(strcmp16_b(ptr,u"Log_ajuste")==0){
			trabajo->salidatrabajo.log_ajuste=(strcmp16_b(buffer.pc,u"Si")==0);
		}elif(strcmp16_b(ptr,u"Log_level")==0){
			trabajo->salidatrabajo.log_level=(u16int)uint___str16(cast_pc_addr(pbuffer->pc));
		}elif(strcmp16_b(ptr,u"Log_pdfs")==0){
			trabajo->salidatrabajo.log_pdfs=(strcmp16_b(buffer.pc,u"Si")==0);
		}elif(strcmp16_b(ptr,u"Muestra_hrml")==0){
			trabajo->salidatrabajo.muestra_html=(strcmp16_b(buffer.pc,u"Si")==0);
		}
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}

u8int leesalida_general(Bufferti16 *pbuffer, AjbloqueConfigSalida *salida){
	while(*pbuffer->pc!='\0'){
		const char16_t *ptr;
		std_beginend(buffer);
		ptr=buffer.pc;
		ignore_advanceinline(buffer);
		ifunlike_Nomore(buffer) goto continuar;
		if(strcmp16_b(ptr,u"Idioma")==0){
			u8int n;
			if_get_stay(buffer,n,(u8int)uint___str16) salida->general.idioma=n;
		}elif(strcmp16_b(ptr,u"Rutas")==0){
			salida->general.rel_paths=(strcmp16_b(buffer.pc,u"absolutas")!=0);
		}elif(strcmp16_b(ptr,u"Unidades")==0){
			char16_t *ptr=NULL;
			if(strcmp16_b(buffer.pc,u"imagen")==0) ptr=salida->general.uniim;
			elif(strcmp16_b(buffer.pc,u"foto")==0) ptr=salida->general.unif;
			elif(strcmp16_b(buffer.pc,u"terreno")==0) ptr=salida->general.unit;
			ifunlike(ptr==NULL) goto continuar;
			*ptr='\0';
			ignore_advanceinline(buffer);
			ifunlike_Nomore(buffer) goto continuar;
			prepare_string(buffer);
			if((pdif)(buffer.next-buffer.pc)>=6) ((char16_t*)buffer.pc)[6]='\0';	//will be left behind
			strcpy16(ptr,buffer.pc);
			resume(buffer);
		}elif(*ptr++=='D' && *ptr++=='e' && *ptr++=='c'){
			sint8m *pdec=NULL;
			if(strcmp16_b(ptr,u"f")==0 || strcmp16_b(ptr,u"r.f")==0) pdec=&salida->general.decres.im;
			elif(strcmp16_b(ptr,u"p")==0 || strcmp16_b(ptr,u"r.p")==0) pdec=&salida->general.decres.p;
			elif(strcmp16_b(ptr,u"gps")==0 || strcmp16_b(ptr,u"r.gps")==0) pdec=&salida->general.decres.gps;
			elif(strcmp16_b(ptr,u"ins")==0 || strcmp16_b(ptr,u"r.ins")==0) pdec=&salida->general.decres.ins;
			elif(strcmp16_b(ptr,u"j.f")==0) pdec=&salida->general.decajs.im;
			elif(strcmp16_b(ptr,u"j.p")==0) pdec=&salida->general.decajs.p;
			elif(strcmp16_b(ptr,u"j.cp.p")==0) pdec=&salida->general.decajs.gps;
			elif(strcmp16_b(ptr,u"j.cp.g")==0) pdec=&salida->general.decajs.ins;
			elif(strcmp16_b(ptr,u"j.rot")==0) pdec=&salida->general.decrot;
			iflike(pdec!=NULL){
				s8int n; if_get_stay(buffer,n,(s8int)ssint___str16) *pdec=(sint8m)n;
			}
		}
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}
u8int leesalida_pares(Bufferti16 *pbuffer, AjbloqueConfigSalida *salida){
	while(*pbuffer->pc!='\0'){
		uint8m *pn;
		std_beginend(buffer);
		pn=NULL;
		if(strcmp16_b(buffer.pc,u"nmin")==0) pn=&salida->pares_pasadas.nmin;
		elif(strcmp16_b(buffer.pc,u"Modo")==0) pn=&salida->pares_pasadas.modo;
		elif(strcmp16_b(buffer.pc,u"Izda-dcha")==0) pn=(uint8m*)&salida->pares_pasadas.brev;
		ignore_advanceinline(buffer);
		iflike(pn!=NULL && MORE_INL(buffer)){
			u8int n; if_get_stay(buffer,n,(u8int)uint___str16) *pn=(uint8m)n;
		}
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}
u8int leesalida_informacion(Bufferti16 *pbuffer, AjbloqueConfigSalida *salida){
	while(*pbuffer->pc!='\0'){
		u8int k;
		std_beginend(buffer);
		k=0;
		if(strcmp16_b(buffer.pc,u"Residuos")==0) k=1;
		elif(strcmp16_b(buffer.pc,u"Parametros")==0) k=2;
		ignore_advanceinline(buffer);
		iflike(k==0 && MORE_INL(buffer)){
			u16int n;
			if_get_stay(buffer,n,(u8int)uint___str16){
				if(k==1) salida->fich_inf.infR=n;
				else salida->fich_inf.infP=n;
		}	}
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}
u8int leesalida_estadisticas(Bufferti16 *pbuffer, AjbloqueConfigSalida *salida){
	while(*pbuffer->pc!='\0'){
		u8int k;
		std_beginend(buffer);
		k=0;
		if(strcmp16_b(buffer.pc,u"Residuos")==0) k=1;
		elif(strcmp16_b(buffer.pc,u"Parametros")==0) k=2;
		ignore_advanceinline(buffer);
		iflike(k==0 && MORE_INL(buffer)){
			u16int n;
			if_get_stay(buffer,n,(u8int)uint___str16){
				if(k==1) salida->fich_std.stdR=n;
				else salida->fich_std.stdP=n;
		}	}
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}
u8int leesalida_Digi(Bufferti16 *pbuffer, AjbloqueConfigSalida *salida){
	while(*pbuffer->pc!='\0'){
		uint k;
		const char16_t *ptr;
		std_beginend(buffer);
		k=0;
		if(strcmp16_b(buffer.pc,u"Ruta1")==0){
			char16_t *pruta=salida->fich_Digi.rutarel;
			k=1;
			if(pruta!=rutas_fijas[0]){
				if(pruta!=NULL && pruta!=rutas_fijas[1]) free(pruta);
				salida->fich_Digi.rutarel=rutas_fijas[0];
			}
		}elif(strcmp16_b(buffer.pc,u"Ruta2")==0){
			char16_t *pruta=salida->fich_Digi.rutaf;
			k=2;
			if(pruta!=rutas_fijas[0]){
				if(pruta!=NULL && pruta!=rutas_fijas[2]) free(pruta);
				salida->fich_Digi.rutaf=rutas_fijas[0];
			}
		}
		ptr=buffer.pc;
		ignore_advanceinline(buffer);
		ifunlike_Nomore(buffer) goto continuar;
		if(strcmp16_b(ptr,u"Ficheros")==0){
			salida->fich_Digi.files=(uint8m)str_b16_mask(buffer.pc,5);
		}elif(strcmp16_b(ptr,u"p.x")==0){
			salida->fich_Digi.px=(float)vfdouble___str16(cast_pc_addr(pbuffer->pc));
		}elif(strcmp16_b(ptr,u"p.y")==0){
			salida->fich_Digi.py=(float)vfdouble___str16(cast_pc_addr(pbuffer->pc));
		}elif(k!=0){
			char16_t **pruta=NULL;
			Prepare_line_quotes(pbuffer);
			if(k==1){
				if(strcmp16(buffer.pc,rutas_fijas[1])==0) salida->fich_Digi.rutarel=rutas_fijas[1];
				else pruta=&salida->fich_Digi.rutarel;
			}else{
				if(strcmp16(buffer.pc,rutas_fijas[2])==0) salida->fich_Digi.rutaf=rutas_fijas[2];
				else pruta=&salida->fich_Digi.rutaf;
			}
			if(pruta!=NULL){
				uint n=(pdif)(buffer.next-buffer.pc);
				*pruta=n_malloc(char16_t,n+1);
				iflike(*pruta!=NULL){
					char16_t *pw; const char16_t *pc;
					pw=*pruta; pc=buffer.pc; do *pw++=*pc; while(*pc++);
				}else{
					*pruta=rutas_fijas[0];
				}
			}
			resume(buffer);
		}
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}
u8int leesalida_Imaster(Bufferti16 *pbuffer, AjbloqueConfigSalida *salida){
	while(*pbuffer->pc!='\0'){
		uint k;
		const char16_t *ptr;
		std_beginend(buffer);
		k=0;
		if(strcmp16_b(buffer.pc,u"Ruta1")==0){
			char16_t *pruta=salida->fich_Imaster.rutarel;
			k=1;
			if(pruta!=rutas_fijas[0]){
				if(pruta!=NULL && pruta!=rutas_fijas[3]) free(pruta);
				salida->fich_Imaster.rutarel=rutas_fijas[0];
			}
		}elif(strcmp16_b(buffer.pc,u"Ruta2")==0){
			char16_t *pruta=salida->fich_Imaster.rutaf;
			k=2;
			if(pruta!=rutas_fijas[0]){
				if(pruta!=NULL && pruta!=rutas_fijas[4]) free(pruta);
				salida->fich_Imaster.rutaf=rutas_fijas[0];
			}
		}
		ptr=buffer.pc;
		ignore_advanceinline(buffer);
		ifunlike_Nomore(buffer) goto continuar;
		if(strcmp16_b(ptr,u"Ficheros")==0){
			salida->fich_Imaster.files=(uint8m)str_b16_mask(buffer.pc,7);
		}elif(k!=0){
			char16_t **pruta=NULL;
			Prepare_line_quotes(pbuffer);
			if(k==1){
				if(strcmp16(buffer.pc,rutas_fijas[3])==0) salida->fich_Imaster.rutarel=rutas_fijas[3];
				else pruta=&salida->fich_Imaster.rutarel;
			}else{
				if(strcmp16(buffer.pc,rutas_fijas[4])==0) salida->fich_Imaster.rutaf=rutas_fijas[4];
				else pruta=&salida->fich_Imaster.rutaf;
			}
			if(pruta!=NULL){
				uint n=(pdif)(buffer.next-buffer.pc);
				*pruta=n_malloc(char16_t,n+1);
				iflike(*pruta!=NULL){
					char16_t *pw; const char16_t *pc;
					pw=*pruta; pc=buffer.pc; do *pw++=*pc; while(*pc++);
				}else{
					*pruta=rutas_fijas[0];
				}
			}
			resume(buffer);
		}
	continuar:
		finishline_Advance(buffer);
	}
	return FORMATERR_FaltaEnd;
}
