﻿
int escribe_ficherobnf(const char16_t* ficherobnf, const FicheroBnf *datos){
	int nret;
	Buffer_bo fbnf;
	IndiceBnf indice;
	uint ppio_bloque;
	uint* textos8;
	uint* textos16;
	uint nindice_punteros;	//Incluye la entrada vacía del final
	const uint nenteros=N_ENTEROS+1;
	const uint nindice_grandes=N_GRANDES+1;
	const uint npequenos=N_PEQUENOS+1;
	uint nchars_textos8, nchars_textos16;
	struct{
		uint enteros;
		uint indice_punteros;
		uint pequenos;	//Idem
		uint indice_grandes;
		uint textos8;
		uint textos16;
		uint bloque_arrays;
		uint bloque_grandes;
	} tamaños;
	BnfPuntero* indice_punteros;
	BnfEntero* enteros;
	BnfPequeno* pequenos;
	BnfGrande* indice_grandes;
	uint* bloque_arrays;
	uint* bloque_grandes;
	Hash_hStr8Uint reorden_enteros;
	PLIST plist;

	Pchar8 ptexto8;
	Pchar16 ptexto16;

	plist=get_new_plist();

	nchars_textos8=4;
	nchars_textos16=4;

	{NamedPointer *ptr;
	for(ptr=datos->punteros;ptr->name!=NULL;ptr++) nchars_textos8+=strlen8(ptr->name);
	nindice_punteros=(pdif)(ptr-datos->punteros)+1;
	nchars_textos8+=nindice_punteros++;}

	{const Varios_Field *ptr;
	for(ptr=varios_fields;ptr->nom!=NULL;ptr++)  nchars_textos8+=strlen8(ptr->nom);
	nchars_textos8+=(pdif)(ptr-varios_fields);}

	tamaños.enteros=TAMAÑO_ENTERO*nenteros;
	tamaños.indice_punteros=TAMAÑO_ENTRADA_INDICE_PUN*nindice_punteros;
	tamaños.pequenos=TAMAÑO_PEQUENO*npequenos;
	tamaños.indice_grandes=TAMAÑO_ENTRADA_INDICE_G*nindice_grandes;
	tamaños.textos8=NUINTS___NCHARS8(nchars_textos8);
	tamaños.textos16=NUINTS___NCHARS16(nchars_textos16);

	indice.u0=0xA3B4C5D6;	//Marca de fichero bnf
	indice.u1=1;		//Versión
	indice.pos_enteros=TAMAÑO_INDICE_BNF;
	indice.pos_indice_punteros=indice.pos_enteros+tamaños.enteros;
	indice.pos_pequenos=indice.pos_indice_punteros+tamaños.indice_punteros;
	indice.pos_indice_grandes=indice.pos_pequenos+tamaños.pequenos;
	indice.pos_textos8=indice.pos_indice_grandes+tamaños.indice_grandes;
	indice.pos_textos16=indice.pos_textos8+tamaños.textos8;
	ppio_bloque=indice.pos_textos16+tamaños.textos16;

	aj_malloc_add(textos8,uint,tamaños.textos8);
	aj_malloc_add(textos16,uint,tamaños.textos16);
	aj_malloc_add(enteros,BnfEntero,tamaños.enteros);
	aj_malloc_add(indice_punteros,BnfPuntero,tamaños.indice_punteros);
	aj_malloc_add(pequenos,BnfPequeno,tamaños.pequenos);
	aj_malloc_add(indice_grandes,BnfGrande,tamaños.indice_grandes);

	tamaños.bloque_arrays=0;
	{NamedPointer *ptrmem;
	ptrmem=datos->punteros;
	while(ptrmem->name!=NULL){
		if(ptrmem->tipo>TIPOBNF_MAX) continue;
		if(ptrmem->tipo==TIPOBNF_C) tamaños.bloque_arrays+=NUINTS___NCHARS8(ptrmem->n);
		//elif(ptrmem->tipo==TIPOBNF_W) tamaños.bloque_arrays+=NUINTS___NCHARS16(pelem->n);
		else tamaños.bloque_arrays+=FicheroBnfSizeof[ptrmem->tipo]*ptrmem->n;
		ptrmem++;
	}}
	aj_malloc_add(bloque_arrays,uint,tamaños.bloque_arrays);

	tamaños.bloque_grandes=NUINTS___NCHARS16(strlen16(datos->varios->ficherof));
	tamaños.bloque_grandes+=NUINTS___NCHARS16(strlen16(datos->varios->ficheroapr));
	if(datos->varios->ficheroapy!=NULL) tamaños.bloque_grandes+=NUINTS___NCHARS16(strlen16(datos->varios->ficheroapy));
	if(datos->varios->ficherogps!=NULL) tamaños.bloque_grandes+=NUINTS___NCHARS16(strlen16(datos->varios->ficherogps));
	if(datos->varios->ficheroint!=NULL)  tamaños.bloque_grandes+=NUINTS___NCHARS16(strlen16(datos->varios->ficheroint));
	tamaños.bloque_grandes+=usizeof(BnfSistema)/usizeof(uint);
	aj_malloc_add(bloque_grandes,uint,tamaños.bloque_grandes);
	/*Fin reservar memoria*/

#define get_nom(ptr) (*ptr)
	HStdSetupStr8Uint(reorden_enteros,N_ENTEROS);
	rellena_hreorden(reorden_enteros,const char8_t* const,bnf_nombres_enteros,N_ENTEROS,get_nom);
#undef get_nom

	textos8[0]=tamaños.textos8;
	textos16[0]=tamaños.textos16;
	ptexto8.s=textos8+1;	ptexto8.b=0;
	ptexto16.s=textos16+1; ptexto16.b=0;

	/*Rellenar enteros*/
	zeroset_uint(enteros,tamaños.enteros);
	{Namedn *ptrmem;
	ptrmem=datos->enes;
	while(ptrmem->name!=NULL){
		 uint *pelem=geth_data(hStr8Uint,&reorden_enteros,ptrmem->name);
		 if(pelem==NULL || *pelem>=N_ENTEROS) continue;
		enteros[*pelem]=ptrmem++->n;
	}}
	enteros[N_ENTEROS]=Я;

	/*Rellenar el índice de punteros y el bloque_arrays*/
	{NamedPointer *ptrmem;
	BnfPuntero *ptrindex;
	uint *pbloque;
	ptrmem=datos->punteros;
	ptrindex=indice_punteros;
	pbloque=bloque_arrays;
	for(;ptrmem->name!=NULL;ptrmem++){
		if(ptrmem->tipo>TIPOBNF_MAX) continue;
		if(ptrmem->n==0) continue;
		ptrindex->tipo=ptrmem->tipo;
		ptrindex->nom=4*(pdif)(ptexto8.s-textos8-1)+ptexto8.b;
		char8_strpcpy_char(&ptexto8,ptrmem->name,true);
		ptrindex->n=ptrmem->n;
		ptrindex->pos=(pdif)(pbloque-bloque_arrays);
		ptrindex++;

		if(ptrmem->tipo==TIPOBNF_C){IO4char8___str8(pbloque,(char8_t*)ptrmem->p,ptrmem->n); pbloque+=NUINTS___NCHARS8(ptrmem->n);}
		elif(ptrmem->tipo==TIPOBNF_W){IO2char16___str16(pbloque,(char16_t*)ptrmem->p,ptrmem->n); pbloque+=NUINTS___NCHARS16(ptrmem->n);}
		else{
		    uint k=FicheroBnfSizeof[ptrmem->tipo]*ptrmem->n;
		    switch(ptrmem->tipo){
			case TIPOBNF_CP: CentroProy_a_32((CentroProy_32*)pbloque,(CentroProy*)ptrmem->p,ptrmem->n,(char8_t*)datos->punteros[0].p); break;
			case TIPOBNF_PM:{
				PuntoM *punP;
				char8_t* nombres;
				punP=(PuntoM*)ptrmem->p;
				if((pdif)(punP->nom-(char8_t*)datos->punteros[1].p)<(pdif)(punP->nom-(char8_t*)datos->punteros[2].p))
					nombres=(char8_t*)datos->punteros[1].p;	//nombresp
				else
					nombres=(char8_t*)datos->punteros[2].p;	//nombresA
				PuntoM_a_32((PuntoM_32*)pbloque,punP,ptrmem->n,nombres);
				break;
				}
			case TIPOBNF_PI: PuntoGPSINS_a_32((PuntoGPSINS_32*)pbloque,(PuntoGPSINS*)ptrmem->p,ptrmem->n,(char8_t*)datos->punteros[3].p); break;
			case TIPOBNF_GP: GrupoGPSINS_a_32((GrupoGPSINS_32*)pbloque,(GrupoGPSINS*)ptrmem->p,ptrmem->n,(char8_t*)datos->punteros[0].p); break;
			default: memcpy_uint(pbloque,(uint*)ptrmem->p,k);
			}
		    pbloque+=k;
		}
	}
	ptrindex->nom=Я;
	}

	/*Rellenar pequeños*/
#define annade_pequeno(_nom,tipo,_dato) \
	pbnf->nom=4*(pdif)(ptexto8.s-textos8-1)+ptexto8.b;\
	char8_strpcpy_char(&ptexto8,varios_fields[_nom].nom,true);\
	pbnf->dato.tipo=_dato; pbnf++

#define annade_pequeno_fl(_nom,tipo,_dato) \
	pbnf->nom=4*(pdif)(ptexto8.s-textos8-1)+ptexto8.b;\
	char8_strpcpy_char(&ptexto8,varios_fields[_nom].nom,true);\
	IO_SINGLE___float(&pbnf->dato.tipo,_dato); pbnf++

	{BnfPequeno *pbnf;
	pbnf=pequenos;
	annade_pequeno(0,n32,datos->varios->ncalc.ncp);
	annade_pequeno(1,n32,datos->varios->ncalc.npm);
	annade_pequeno(2,n32,datos->varios->ncalc.npy);
	annade_pequeno(3,n32,datos->varios->ncalc.ngruposgps);
	annade_pequeno(4,n32,datos->varios->ncalc.ngruposins);
	annade_pequeno(5,n32,datos->varios->ncalc.ngps);
	annade_pequeno(6,n32,datos->varios->ncalc.nins);
	annade_pequeno(7,n32,datos->varios->ncalc.ngruposcalib);
	annade_pequeno_fl(8,f,datos->varios->apriori.im);
	annade_pequeno_fl(9,f,datos->varios->apriori.pXY);
	annade_pequeno_fl(10,f,datos->varios->apriori.pZ);
	annade_pequeno_fl(11,f,datos->varios->apriori.gpsXY);
	annade_pequeno_fl(12,f,datos->varios->apriori.gpsZ);
	annade_pequeno_fl(13,f,datos->varios->apriori.insΩΦ);
	annade_pequeno_fl(14,f,datos->varios->apriori.insK);
	annade_pequeno_fl(15,f,datos->varios->σ_aposteriori);
	annade_pequeno_fl(16,f,datos->varios->aposteriori.im);
	annade_pequeno_fl(17,f,datos->varios->aposteriori.pXY);
	annade_pequeno_fl(18,f,datos->varios->aposteriori.pZ);
	annade_pequeno_fl(19,f,datos->varios->aposteriori.gpsXY);
	annade_pequeno_fl(20,f,datos->varios->aposteriori.gpsZ);
	annade_pequeno_fl(21,f,datos->varios->aposteriori.insΩΦ);
	annade_pequeno_fl(22,f,datos->varios->aposteriori.insK);
	annade_pequeno_fl(23,f,datos->varios->redun_parciales.foto);
	annade_pequeno_fl(24,f,datos->varios->redun_parciales.apoyo);
	annade_pequeno_fl(25,f,datos->varios->redun_parciales.gps);
	annade_pequeno_fl(26,f,datos->varios->redun_parciales.ins);
	annade_pequeno(27,n32,datos->varios->nobs);
	annade_pequeno(28,n32,datos->varios->nincog);
	annade_pequeno(29,n8,datos->varios->uni);
	annade_pequeno(30,n8,datos->varios->tipos_fich.mar);
	annade_pequeno(31,n8,datos->varios->tipos_fich.prm);
	annade_pequeno(32,n8,datos->varios->tipos_fich.pym);
	annade_pequeno(33,n8,datos->varios->tipos_fich.gpm);
	annade_pequeno(34,n8,datos->varios->tipos_fich.inm);
	annade_pequeno(35,n8,datos->varios->estimador);
	pbnf->nom=Я;
	}
#undef annade_pequeno
#undef annade_pequeno_fl

	/*Rellenar el índice de grandes y el bloque_grandes*/
	{BnfGrande *ptrindex;
	uint *pbloque;
	ptrindex=indice_grandes;
	pbloque=bloque_grandes;

	ptrindex->nom=4*(pdif)(ptexto8.s-textos8-1)+ptexto8.b;
	char8_strpcpy_char(&ptexto8,varios_fields[36].nom,true);
	ptrindex->pos=(pdif)(pbloque-bloque_grandes);
	pbloque=IO2char16_strpcpy_char16(pbloque,datos->varios->ficherof);
	ptrindex++;

	ptrindex->nom=4*(pdif)(ptexto8.s-textos8-1)+ptexto8.b;
	char8_strpcpy_char(&ptexto8,varios_fields[37].nom,true);
	ptrindex->pos=(pdif)(pbloque-bloque_grandes);
	pbloque=IO2char16_strpcpy_char16(pbloque,datos->varios->ficheroapr);
	ptrindex++;

	if(datos->varios->ficheroapy!=NULL){
		ptrindex->nom=4*(pdif)(ptexto8.s-textos8-1)+ptexto8.b;
		char8_strpcpy_char(&ptexto8,varios_fields[38].nom,true);
		ptrindex->pos=(pdif)(pbloque-bloque_grandes);
		pbloque=IO2char16_strpcpy_char16(pbloque,datos->varios->ficheroapy);
		ptrindex++;
	}
	if(datos->varios->ficherogps!=NULL){
		ptrindex->nom=4*(pdif)(ptexto8.s-textos8-1)+ptexto8.b;
		char8_strpcpy_char(&ptexto8,varios_fields[39].nom,true);
		ptrindex->pos=(pdif)(pbloque-bloque_grandes);
		pbloque=IO2char16_strpcpy_char16(pbloque,datos->varios->ficherogps);
		ptrindex++;
	}
	if(datos->varios->ficheroint!=NULL){
		ptrindex->nom=4*(pdif)(ptexto8.s-textos8-1)+ptexto8.b;
		char8_strpcpy_char(&ptexto8,varios_fields[40].nom,true);
		ptrindex->pos=(pdif)(pbloque-bloque_grandes);
		pbloque=IO2char16_strpcpy_char16(pbloque,datos->varios->ficheroint);
		ptrindex++;
	}
	ptrindex->nom=4*(pdif)(ptexto8.s-textos8-1)+ptexto8.b;
	char8_strpcpy_char(&ptexto8,varios_fields[41].nom,true);
	ptrindex->pos=(pdif)(pbloque-bloque_grandes);
	//memcpy_uint(pbloque,(uint*)&datos->varios->sis.infor,uintsizeof(SistemaInformacion));
	memcpy_uint(pbloque,(uint*)&datos->varios->sis.sis,uintsizeof(SistemaDefinicion));
	pbloque+=(usizeof(BnfSistema)+usizeof(uint)-1)/usizeof(uint);
	ptrindex++;

	ptrindex->nom=Я;
	}

	/*Ajustar los valores de pos en el índice de punteros y de grandes*/
	{BnfPuntero *ptri; for(ptri=indice_punteros;ptri->nom!=Я;ptri++) ptri->pos+=ppio_bloque;}
	ppio_bloque+=tamaños.bloque_arrays;
	{BnfGrande *ptri; for(ptri=indice_grandes;ptri->nom!=Я;ptri++) ptri->pos+=ppio_bloque;}
	ppio_bloque+=tamaños.bloque_grandes;

	nret=boopen16(&fbnf,ficherobnf,ATBYTES_LITTLE_ENDIAN);
	ifunlike(nret) return nret;

	bowrite_uints(&fbnf,(uint*)&indice,TAMAÑO_INDICE_BNF);
	bowrite_uints(&fbnf,(uint*)enteros,tamaños.enteros);
	bowrite_uints(&fbnf,(uint*)indice_punteros,tamaños.indice_punteros);
	bowrite_uints(&fbnf,(uint*)pequenos,tamaños.pequenos);
	bowrite_uints(&fbnf,(uint*)indice_grandes,tamaños.indice_grandes);
	bowrite_uints(&fbnf,textos8,tamaños.textos8);
	bowrite_uints(&fbnf,textos16,tamaños.textos16);
	bowrite_uints(&fbnf,(uint*)bloque_arrays,tamaños.bloque_arrays);
	bowrite_uints(&fbnf,(uint*)bloque_grandes,tamaños.bloque_grandes);
	boclose(&fbnf);

	free_plist(plist);
	return fbnf.error_code;

salida_outofmem:
	 free_plist(plist);
	 return AT_NOMEM;
}

#define plist datos->plist
int lee_ficherobnf(char16_t* ficherobnf, FicheroBnf *datos){
	int nret;
	union{int isize; uint size;} S;
	uint* file;
	IndiceBnf indice;
	IO4char8* textos8;
	//uint* textos16;
	char8_t* nombres_elementos;
	char8_t *nombresf, *nombresp, *nombresA, *nombresgps;
	Hash_hStr8Uint reorden_varios;

	plist=PLIST_NULL;
	S.isize=biopen16(&file,ficherobnf);
	ifunlike(S.isize==AT_NOMEM) return AT_NOMEM;
	ifunlike(S.isize<0) return ATREAD_NOOPEN;
	S.size=(uint)S.isize;
	ifunlike(S.size<TAMAÑO_INDICE_BNF+20 || file[0]!=0xA3B4C5D6){
		free(file); return ATREAD_NOFORMAT;
	}
	ifunlike(file[1]>1){
		free(file); return ATREAD_RECIENTE;
	}

	plist=get_new_plist();

	memcpy_uint(&indice,file,TAMAÑO_INDICE_BNF);
	ifunlike(indice.pos_enteros+TAMAÑO_ENTERO>S.size
	|| indice.pos_indice_punteros+TAMAÑO_ENTRADA_INDICE_PUN>S.size
	|| indice.pos_pequenos+TAMAÑO_PEQUENO>S.size
	|| indice.pos_indice_grandes+TAMAÑO_ENTRADA_INDICE_G>S.size
	|| indice.pos_textos8>=S.size
	|| indice.pos_textos16>=S.size){
		 nret=ATREAD_OVERRUN; goto salida_error;
	 }

	textos8=file+indice.pos_textos8;

	aj_malloc_add(datos->enes,Namedn,N_ENTEROS+1);
	aj_malloc_add(nombres_elementos,char8_t,4**textos8);
	str8___IO4char8(nombres_elementos,textos8+1,*textos8-1);

	{BnfEntero *pfile;
	Namedn *pmem;
	const char8_t* const *pnombre;
	pfile=(BnfEntero*)(file+indice.pos_enteros);
	pmem=datos->enes;
	pnombre=bnf_nombres_enteros;
	{dontimes(N_ENTEROS,(pfile++,pmem++)){
		if(*pfile==Я) break;
		pmem->n=*pfile;
		pmem->name=*pnombre++;
	}}
	pmem->name=NULL;
	}

	{BnfPuntero *pfile;
	Growing_NamedPointer punteros;
	pfile=(BnfPuntero*)(file+indice.pos_indice_punteros);
	GStdSetup(NamedPointer,punteros,BNF_N_PUNTEROS+1);
	do{
		NamedPointer pm={pfile->tipo,nombres_elementos+pfile->nom,pfile->n,NULL};
		Gadd(punteros,NamedPointer,pm,goto salida_outofmem);
		if(pfile->nom==Я) break;
		pfile++;
	}while(1);
	(punteros.next-1)->name=NULL;
	datos->punteros=punteros.ppio;
	Remove_from_delete(punteros.ppio);
	Addto_delete(datos->punteros);
	}
	//Primero las cadenas de nombres porque hacen falta para los CentrosProy, etc.
	nombresgps=nombresA=nombresp=nombresf=NULL;
	{NamedPointer *ptri;
	BnfPuntero *pfile;
	pfile=(BnfPuntero*)(file+indice.pos_indice_punteros);
	for(ptri=datos->punteros; ptri->name!=NULL; ptri++, pfile++){
		uint k;
		if(ptri->tipo!=TIPOBNF_C || ptri->n==0) continue;
		k=NUINTS___NCHARS8(ptri->n);
		aj_malloc_add(ptri->p,char8_t,k*usizeof(uint));
		str8___IO4char8(ptri->p,file+pfile->pos,k);
		if(!strcmp8(ptri->name,bnf_nombres_punteros[0])) nombresf=ptri->p;
		elif(!strcmp8(ptri->name,bnf_nombres_punteros[1])) nombresp=ptri->p;
		elif(!strcmp8(ptri->name,bnf_nombres_punteros[2])) nombresA=ptri->p;
		elif(!strcmp8(ptri->name,bnf_nombres_punteros[3])) nombresgps=ptri->p;
	}}
	//Los demás
	{NamedPointer *ptri;
	BnfPuntero *pfile;
	pfile=(BnfPuntero*)(file+indice.pos_indice_punteros);
	for(ptri=datos->punteros; ptri->name!=NULL; ptri++){
		uint *pdatos=file+pfile->pos; pfile++;
		if(ptri->n==0 || ptri->tipo>TIPOBNF_MAX) continue;
		if(ptri->tipo==TIPOBNF_C) continue;
		aj_malloc_add(ptri->p,char8_t,ptri->n*NamedPointersSizeof[ptri->tipo]);
		switch(ptri->tipo){
			case TIPOBNF_U:
			case TIPOBNF_U2:
			case TIPOBNF_U3:
			case TIPOBNF_U4:
				memcpy_uint(ptri->p,pdatos,ptri->n*NamedPointersSizeof[ptri->tipo]/usizeof(uint)); break;
			//case TIPOBNF_W:
			//	{uint k=NUINTS___NCHARS16(ptri->n);
			//	str16___IO2char16(ptri->p,pdatos,k);} break;
			case TIPOBNF_F: float_memcpy_IO_SINGLE(ptri->p,pdatos,ptri->n); break;
			case TIPOBNF_D: double_memcpy_IO_DOUBLE(ptri->p,pdatos,ptri->n); break;
			//The following ones do not cause a problem if the pointer nombres is NULL
			case TIPOBNF_CP: CentroProy32_a_ptr((CentroProy*)ptri->p,(CentroProy_32*)pdatos,ptri->n,nombresf); break;
			case TIPOBNF_PM:
				{char8_t* nombres;
				if(!strcmp8(ptri->name,"PuntosModelo")) nombres=nombresp;
				else nombres=nombresA;
				PuntoM32_a_ptr((PuntoM*)ptri->p,(PuntoM_32*)pdatos,ptri->n,nombres);
				}
				break;
			case TIPOBNF_PI: PuntoGPSINS32_a_ptr((PuntoGPSINS*)ptri->p,(PuntoGPSINS_32*)pdatos,ptri->n,nombresgps); break;
			case TIPOBNF_GP: GrupoGPSINS32_a_ptr((GrupoGPSINS*)ptri->p,(GrupoGPSINS_32*)pdatos,ptri->n,nombresf); break;
		}
	}}

	/*varios*/
	aj_malloc_add(datos->varios,BnfVarios,1);
#define get_nom(ptr) (ptr->nom)
	HStdSetupStr8Uint(reorden_varios,N_VARIOS);
	rellena_hreorden(reorden_varios,const Varios_Field,varios_fields,N_VARIOS,get_nom);
#undef get_nom

	//Pequeños
	{BnfPequeno *pfile;
	pfile=(BnfPequeno*)(file+indice.pos_pequenos);
	while(pfile->nom!=Я){
		const Varios_Field *pfield;
		char* pvario;
		uint *pelem=geth_data(hStr8Uint,&reorden_varios,nombres_elementos+pfile->nom);
		if(pelem==NULL || *pelem>=N_VARIOS) continue;
		pfield=varios_fields+*pelem;
		pvario=(char*)datos->varios+pfield->offset;
		switch(pfield->tipo){
			case TIPOBNFV_U: *(uint*)pvario=pfile->dato.n32; break;
			case TIPOBNFV_U8: *(u8int*)pvario=pfile->dato.n8; break;
			//case TIPOBNFV_U16: *(u8int*)pvario=pfile->dato.n16; break;
			case TIPOBNFV_F: float___IO_SINGLE((float*)pvario,pfile->dato.f); break;
		}
		pfile++;
	}}

	datos->varios->ficherof=NULL;
	datos->varios->ficheroapr=NULL;
	datos->varios->ficheroapy=NULL;
	datos->varios->ficherogps=NULL;
	datos->varios->ficheroint=NULL;
	{BnfGrande *pindex;
	for(pindex=(BnfGrande*)(file+indice.pos_indice_grandes); pindex->nom!=Я; pindex++){
		const Varios_Field *pfield;
		uint *pfile;
		uint *pelem=geth_data(hStr8Uint,&reorden_varios,nombres_elementos+pindex->nom);
		if(pelem==NULL || *pelem>=N_VARIOS) continue;
		pfield=varios_fields+*pelem;
		pfile=file+pindex->pos;
		switch(pfield->tipo){
			case TIPOBNFV_W:
				{char16_t* *pvario;
				uint* s;
				uint k;
				pvario=(char16_t**)((char*)datos->varios+pfield->offset);
				for(s=pfile; get_bytes01(s)!=0 && get_bytes23(s)!=0; s++);
				k=(pdif)(s-pfile)+1;
				aj_malloc_add(*pvario,char16_t,k<<1);
				str16___IO2char16(*pvario,(IO2char16*)pfile,k);}
				break;
			case TIPOBNFV_O:
				if(*pelem==41){
					//memcpy_uint((uint*)&datos->varios->sis.infor,pfile,(usizeof(SistemaInformacion)+usizeof(uint)-1)/usizeof(uint));
					memcpy_uint((uint*)&datos->varios->sis.sis,pfile,(usizeof(SistemaDefinicion)+usizeof(uint)-1)/usizeof(uint));
				}
				break;
		}
	}}

	Free_remove(reorden_varios.ppio);

#undef plist
	plist_to_immediate(datos->plist);
	return 0;

salida_outofmem:
	nret=AT_NOMEM;
salida_error:
	free(file);
	free_plist(datos->plist);
	return nret;
}
