﻿#include "distorsion_textos.h"
typedef struct _Global{
	u8int _idioma;
	char16_t* _mensaje;
	Bufferti8 *_pbuffer;
	char16_t *_pterror;
} Global;
#define idioma global->_idioma
#define mensaje global->_mensaje
#define pterror (global->_pterror)
#define pbuffer (global->_pbuffer)

int lee_ficheroint_Aerotri(Global *global, OrientacionInterna* interna);
int lee_ficheroint_ini(Global *global, OrientacionInterna* interna, bint bfocal, bint bpp);
int lee_ficheroint_Digi(Global *global, OrientacionInterna* interna, bint bfocal, bint bpp);
int lee_ficheroint_IMaster(Global *global, OrientacionInterna* interna, bint bfocal, bint bpp);
int lee_ficheroint_RapidCal(Global *global, OrientacionInterna* interna, bint bfocal, bint bpp);

#define global (&globalL)
int lee_ficheroint_bfpp(const char16_t* ficheroint, u8int inm, OrientacionInterna* interna, bint bfocal, bint bpp, char16_t* _mensaje, u8int _idioma){
	int nret;
	Global globalL;
	Bufferti8 buffer;

	setup_interna(interna);
	idioma=_idioma;
	mensaje=_mensaje;
	pbuffer=&buffer;

	{const char16_t *pfich;
	path_get_filename16(ficheroint,pfich);
	nret=tiopen_mixed(&buffer,ficheroint);
	ifunlike(nret<0){
		ifunlike(nret==AT_NOMEM) return ATREAD_NOOPEN_MEM;
		open_file_err_str16(nret,mensaje,pfich,idioma);
		return ATREAD_NOOPEN;
	}
	pterror=strbuild16(mensaje,S_Error_int,pfich,u"\n\n",NULL);
	}

	switch(inm){
		case CAMFORMAT_Aerotri: nret=lee_ficheroint_Aerotri(global,interna); break;
		case CAMFORMAT_cmr: nret=lee_ficheroint_IMaster(global,interna,bfocal,bpp); break;
		case CAMFORMAT_ini: nret=lee_ficheroint_ini(global,interna,bfocal,bpp); break;
		case CAMFORMAT_Digi: nret=lee_ficheroint_Digi(global,interna,bfocal,bpp); break;
		case CAMFORMAT_RapidCal: nret=lee_ficheroint_RapidCal(global,interna,bfocal,bpp); break;
		default: strcpy16(pterror,S_Formato_desconocido); nret=ATREAD_NOFORMAT;
	}
	ticlose(buffer);
	if(nret==0) *mensaje='\0';
	return nret;
}
#undef global
#define buffer (*pbuffer)

int lee_info(Global* global, KeyVal* *info);
int lee_1(Global* global, Lineal2D_dbl *valores);
int lee_interna(Global* global, Valores_Interna* valores);
int lee_distorsion(Global* global, OrientacionInterna* interna);
int lee_radsim(Global* global, uint *params, float* *pvalores);
int lee_parametros(Global* global, uint *params,float* *pvalores);
#define prepare_onemore(buffer)	resume_advanceinline(buffer); if(*buffer.pc=='\n') goto nomore_continue; prepare_string(buffer)
int lee_ficheroint_Aerotri(Global *global, OrientacionInterna* interna){
	bint bend, binterna;
	u8int bdistorsion;
	s8int mc;	//master counter
	int nret;

	binterna=false;
	bend=0;
	bdistorsion=0;	//Significa correcto
	mc=0;

	nret=0;
	advance(buffer);
	for(;;){
		prepare_string(buffer);
		while(strcmp8(buffer.pc,"\\begin")!=0 && strcmp8(buffer.pc,"\\end")!=0){
			if(*buffer.pc=='\0') break;
			resume(buffer);
			finishline_advance(buffer); prepare_string(buffer);
		}
		if(*buffer.pc=='\0'){
			if(mc>0){
				strcpy16(pterror,S_End);
				nret=ATREAD_EOF;
				goto malasalida;
			}else goto salida;
		}
		if(strcmp8(buffer.pc,"\\begin")==0){
			resume_advanceinline(buffer);
			if(*buffer.pc=='\n'){
				strcpy16(pterror,S_Begin);
				nret=ATREAD_LINEA;
				goto malasalida;
			}
			if(mc>0) goto ignore_continue;
			prepare_string(buffer);
			if(strcmp8(buffer.pc,"Info")==0){
				resume(buffer); finishline_advance(buffer);
				if(interna->info==NULL){
					KeyVal *ptr;
					checked_malloc_n(interna->info,KeyVal,6,nret=AT_NOMEM; goto malasalida);
					ptr=interna->info;
					dontimes(5,){ptr++->key=(uintptr_t)-1;}
					ptr->key=0;
				}
				nret=lee_info(global,&interna->info);
				ifunlike(nret) goto malasalida;
				continue;
			}
			if(strcmp8(buffer.pc,"Coordenadas")==0){
				prepare_onemore(buffer);
				if(strcmp8(buffer.pc,"medidas")==0){
					resume(buffer); finishline_advance(buffer);
					nret=lee_1(global,&interna->afin_1);
					ifunlike(nret!=0) goto malasalida;
					interna->flags|=CAL_FLAG_Transf1;
					continue;
				}
			}elif(strcmp8(buffer.pc,"Orientacion")==0){
				prepare_onemore(buffer);
				if(strcmp8(buffer.pc,"interna")==0){
					prepare_onemore(buffer);
					if(strcmp8(buffer.pc,"media")!=0) goto ignore_continue;
					resume(buffer); finishline_advance(buffer);
					nret=lee_interna(global,&interna->valI);
					ifunlike(nret!=0) goto malasalida;
					binterna=true;
					if(interna->valI.x!=0 || interna->valI.y!=0) interna->flags|=CAL_FLAG_pp;
					continue;
				}
			}elif(strcmp8(buffer.pc,"Funcion")==0){
				prepare_onemore(buffer);
				if(strcmp8(buffer.pc,"de")==0){
					prepare_onemore(buffer);
					if(strcmp8(buffer.pc,"distorsion")!=0) goto ignore_continue;
					resume(buffer); finishline_advance(buffer);
					nret=lee_distorsion(global,interna);
					ifunlike(nret!=0){
						free_null_if(interna->distorsion.valores_radsim);
						free_null_if(interna->distorsion.valores_tansim);
						free_null_if(interna->distorsion.valores_asim1);
						free_null_if(interna->distorsion.valores_asim2);
						interna->flags&=~(CAL_FLAG_Distorsiones|CAL_FLAG_DistorsionesTodas);
						interna->distorsion.config.param_radsim=0;
						interna->distorsion.config.param_tansim=0;
						interna->distorsion.config.param_asim1=0;
						interna->distorsion.config.param_asim2=0;
						goto malasalida;
					}
					if(interna->flags&CAL_FLAG_DistorsionesTodas) interna->flags|=CAL_FLAG_Distorsiones;
					continue;
				}
			}
ignore_continue:
			resume(buffer);
nomore_continue:
			mc++;
			finishline_advance(buffer);
			continue;
		}
		if(strcmp8(buffer.pc,"\\end")==0){
			resume(buffer);
			if(mc==0) bend=1;
			else mc--;
			finishline_advance(buffer);
		}
	}

salida:
	if(!binterna){
		strcpy16(pterror,S_FicheroIncompleto);
		return ATREAD_MISSINGDATA;
	}
	if(bend) strbuild16(pterror,S_Extra_end,NULL);
	return 0;
malasalida:
	return nret;
}

#undef if_inline_all
#define if_inline_all(func,x,cod) iflike_moreinl(buffer){ifnot_get_stay(buffer,x,func){cod_error=cod; goto error_caracter;}}

#define ifmore_else_df(func,x,cod) resume_advanceinline(buffer);\
	if_inline_all(func,x,cod)\
	else{strbuild16(pterror,S_Endondeestamos,S_Finaldelinea,TEXTOInternad(cod),NULL); return ATREAD_LINEA;}
#define ifmore_else_dbl(x,cod) ifmore_else_df(vfdouble___str8,x,cod)
#define ifmore_else_fl(x,cod) ifmore_else_df(float___str8,x,cod)

#define S_Endondeestamos S_EnInfo
int lee_info(Global* global, KeyVal* *info){
	s8int mc;	//master counter
	int cod_error;
	uint info_code;

	mc=1;
	advance(buffer); goto first_entry;
	while(1){
		KeyVal *ptr;
		float fl;
		finishline_advance(buffer);
first_entry:	if(*buffer.pc=='\0') break;
		prepare_string(buffer);
		if(strcmp8(buffer.pc,"\\begin")==0) mc++;
		elif(strcmp8(buffer.pc,"\\end")==0){
			resume(buffer);
			if(mc==1) goto salida;
			mc--; continue;
		}
		if(mc>1){resume(buffer); continue;}

		if(strcmp8(buffer.pc,"minx")==0){info_code=1;			ifmore_else_fl(fl,N_minx);}
		elif(strcmp8(buffer.pc,"maxx")==0){info_code=2;		ifmore_else_fl(fl,N_maxx);}
		elif(strcmp8(buffer.pc,"miny")==0){info_code=3;		ifmore_else_fl(fl,N_miny);}
		elif(strcmp8(buffer.pc,"maxy")==0){info_code=4;	ifmore_else_fl(fl,N_maxy);}
		else{
			continue;
		}
		ptr=*info;
		while(ptr->key!=CAL_KV_EMPTY && ptr->key!=CAL_KV_END && ptr->key!=info_code) ptr++;
		if(ptr->key==info_code) continue;
		if(ptr->key==CAL_KV_END){
			uint N=(pdif)(ptr-*info)+1;
			ptr=(KeyVal*)realloc(*info,(N+(N>>1))*usizeof(KeyVal));
			if(ptr==NULL){return AT_NOMEM;}
			*info=ptr;
			ptr+=N-1;
			N>>=1;
			while(N--){ptr++->key=CAL_KV_EMPTY;}
			ptr->key=CAL_KV_END;
			ptr-=N;
		}
		ptr->key=info_code;
		ptr->val.fl=fl;
	}
strcpy16(pterror,S_End);
	return ATREAD_EOF;
salida:
	finishline_advance(buffer);
	return 0;

error_caracter:
	pterror=strbuild16(pterror,S_Eninterna,S_Mientras,TEXTOInternad(cod_error),S_seencontro,NULL);
	*pterror++=*buffer.pc;
	strcpy16(pterror,S_wasfound);
	return ATREAD_CARACTER;
}

#undef S_Endondeestamos
#define S_Endondeestamos S_En1
int lee_1(Global* global, Lineal2D_dbl* valores){
	bint ba,bb,bc,bd,bx,by;
	s8int mc;	//master counter
	int cod_error;

	by=bx=bd=bc=bb=ba=0;
	valores->a=valores->c=1;
	valores->b=valores->d=0;
	valores->Tx=valores->Ty=0;
	mc=1;
	advance(buffer); goto first_entry;
	while(1){
		finishline_advance(buffer);
first_entry:	if(*buffer.pc=='\0') break;
		prepare_string(buffer);
		if(strcmp8(buffer.pc,"\\begin")==0) mc++;
		elif(strcmp8(buffer.pc,"\\end")==0){
			resume(buffer);
			if(mc==1) goto salida;
			mc--; continue;
		}
		if(mc>1){resume(buffer); continue;}

		if(strcmp8(buffer.pc,"Tx")==0){ifmore_else_fl(valores->Tx,N_Tx);	bx=true; continue;}
		if(strcmp8(buffer.pc,"Ty")==0){ifmore_else_fl(valores->Ty,N_Ty);	by=true; continue;}
		if(strcmp8(buffer.pc,"a")==0){ifmore_else_fl(valores->a,N_param_a);	ba=true; continue;}
		if(strcmp8(buffer.pc,"b")==0){ifmore_else_fl(valores->b,N_param_b); bb=true; continue;}
		if(strcmp8(buffer.pc,"c")==0){ifmore_else_fl(valores->c,N_param_c);	bc=true; continue;}
		if(strcmp8(buffer.pc,"d")==0){ifmore_else_fl(valores->d,N_param_d); bd=true; continue;}
		resume(buffer);
	}
//If we arrived here it is because the eof was found before the closing \end
	strcpy16(pterror,S_End);
	return ATREAD_EOF;
salida:
	finishline_advance(buffer);
	if( ((bx && by) || !(bx || by)) && ((ba && bb && bc && bd) || !(ba || bb || bc || bd)) ) return 0;
	strcpy16(pterror,S_1incompleta);
	return ATREAD_MISSINGDATA;

error_caracter:
	pterror=strbuild16(pterror,S_En1,S_Mientras,TEXTOInternad(cod_error),S_seencontro,NULL);
	*pterror++=*buffer.pc;
	strcpy16(pterror,S_wasfound);
	return ATREAD_CARACTER;
}

#undef S_Endondeestamos
#define S_Endondeestamos S_Eninterna
int lee_interna(Global* global, Valores_Interna* valores){
	bint bf,bx,by;
	s8int mc;	//master counter
	int cod_error;

	by=bx=bf=0;
	mc=1;
	advance(buffer); goto first_entry;
	while(1){
		finishline_advance(buffer);
first_entry:	if(*buffer.pc=='\0') break;
		prepare_string(buffer);
		if(strcmp8(buffer.pc,"\\begin")==0) mc++;
		elif(strcmp8(buffer.pc,"\\end")==0){
			resume(buffer);
			if(mc==1) goto salida;
			mc--; continue;
		}
		if(mc>1){resume(buffer); continue;}

		if(strcmp8(buffer.pc,"f")==0){
			ifmore_else_dbl(valores->f,N_focal);
			if(valores->f==0){
				strbuild16(pterror,S_Eninterna,S_Lafocalno0,NULL);
				return ATREAD_RANGE;
			}
			bf=true; continue;
		}
		if(strcmp8(buffer.pc,"xp")==0){
			ifmore_else_dbl(valores->x,N_ppx);
			bx=true; continue;
		}
		if(strcmp8(buffer.pc,"yp")==0){
			ifmore_else_dbl(valores->y,N_ppy);
			by=true; continue;
		}
		resume(buffer);
	}
	strcpy16(pterror,S_End);
	return ATREAD_EOF;
salida:
	finishline_advance(buffer);
	if(bf && bx && by) return 0;
	strbuild16(pterror,S_Eninterna,S_Faltancampos,u"f, xp, yp",NULL);
	return ATREAD_MISSINGDATA;

error_caracter:
	pterror=strbuild16(pterror,S_Eninterna,S_Mientras,TEXTOInternad(cod_error),S_seencontro,NULL);
	*pterror++=*buffer.pc;
	strcpy16(pterror,S_wasfound);
	return ATREAD_CARACTER;
}

#undef S_Endondeestamos
#define S_Endondeestamos S_Endistorsion
int lee_distorsion(Global* global, OrientacionInterna* interna){
	int nret;
	bint bpoli, basim, bsdiag, brsim;
	s8int mc;	//master counter
	int cod_error;

	bsdiag=0;
	bpoli=basim=0;
	brsim=0;
	mc=1;
	nret=0;
	advance(buffer);
	for(;;){
		if(*pbuffer->pc=='\0'){
			strcpy16(pterror,S_End);
			goto salida_eof;
		}
		prepare_string(buffer);
		if(strcmp8(pbuffer->pc,"\\end")==0){
			resume(buffer);
			if(mc==1) goto salida;
			mc--;
			finishline_advance(buffer); continue;
		}
		if(mc>1){
			if(strcmp8(pbuffer->pc,"\\begin")==0) mc++;
			resume(buffer);
			finishline_advance(buffer);
			continue;
		}
		if(strcmp8(pbuffer->pc,"semidiag")==0){
			ifmore_else_fl(interna->distorsion.config.semidiag,N_semidiag);
			if(interna->distorsion.config.semidiag<0){
				isolate_word(buffer);
				strbuild_mixed(pterror,'w',S_Eninterna,'w',S_Semidiag_positiva,'w',S_ensulugar,'c',pbuffer->pc,'\0');
				resume(buffer);
				return ATREAD_RANGE;
			}
			bsdiag=true;
			finishline_advance(buffer); continue;
		}
		if(strcmp8(pbuffer->pc,"Modelo")==0){
			resume_advanceinline(buffer);
			if(*pbuffer->pc=='\n'){finishline_advance(buffer); continue;}
			prepare_string(buffer);
			if(strcmp8(pbuffer->pc,"polinomico")==0){
				resume_advanceinline(buffer);
				if(*pbuffer->pc=='\n'){
					strbuild16(pterror,S_Endistorsion,S_Finaldelinea,S_modelopoli,NULL);
					return ATREAD_LINEA;
				}
				prepare_string(buffer);
				if(strcmp8(pbuffer->pc,"Impar")==0){
					interna->distorsion.config.modelo_poli=CAL_MODPOL_IMPAR;
				}elif(strcmp8(pbuffer->pc,"Completo")==0){
					interna->distorsion.config.modelo_poli=CAL_MODPOL_COMPLETO;
				}else{
					pterror=strbuild_mixed(pterror,'w',S_Endistorsion,'w',S_Modelopoli_desc,'c',pbuffer->pc,'\0');
					resume(buffer);
					return ATREAD_BADKEYVAL;
				}
				bpoli=true;
			}elif(strcmp8(pbuffer->pc,"asimetrico")==0){
				resume_advanceinline(buffer);
				if(*pbuffer->pc=='\n'){
					strbuild16(pterror,S_Endistorsion,S_Finaldelinea,S_modeloasim,NULL);
					return ATREAD_LINEA;
				}
				prepare_string(buffer);
				if(strcmp8(pbuffer->pc,"rad/tan")==0) interna->distorsion.config.modelo_asim=CAL_MODASIM_RADTAN;
				elif(strcmp8(pbuffer->pc,"u/v")==0) interna->distorsion.config.modelo_asim=CAL_MODASIM_VECTOR;
				else{
					strbuild_mixed(pterror,'w',S_Endistorsion,'w',S_Modeloasim_desc,'c',pbuffer->pc,'\0');
					resume(buffer);
					return ATREAD_BADKEYVAL;
				}
				basim=1;
			}
			resume(buffer);
			finishline_advance(buffer); continue;
		}
		if(strcmp8(pbuffer->pc,"\\begin")==0){
			resume_advanceinline(buffer);
			if(*pbuffer->pc=='\n'){
				strcpy16(pterror,S_Begin);
				nret=ATREAD_LINEA;
			}
			prepare_string(buffer);
			if(strcmp8(pbuffer->pc,"Radial")==0){
				prepare_onemore(buffer);
				if(strcmp8(pbuffer->pc,"simetrica")==0){
					char16_t* pterror2=pterror;
					pterror=strpcpy16(pterror,S_Enradsim);
					resume(buffer); finishline_advance(buffer);
					nret=lee_radsim(global,&interna->distorsion.config.param_radsim,&interna->distorsion.valores_radsim);
					ifunlike(nret!=0) goto malasalida;
					pterror=pterror2;
					iflike(interna->distorsion.config.param_radsim!=0) interna->flags|=CAL_FLAG_RadSim;
					brsim=true;
					continue;
				}
			}elif(strcmp8(pbuffer->pc,"Tangencial")==0){
				prepare_onemore(buffer);
				if(strcmp8(pbuffer->pc,"simetrica")==0){
					char16_t* pterror2=pterror;
					pterror=strpcpy16(pterror,S_Entansim);
					resume(buffer); finishline_advance(buffer);
					nret=lee_parametros(global,&interna->distorsion.config.param_tansim,&interna->distorsion.valores_tansim);
					ifunlike(nret!=0) goto malasalida;
					pterror=pterror2;
					iflike(interna->distorsion.config.param_tansim!=0) interna->flags|=CAL_FLAG_TanSim;
					continue;
				}
			}elif(strcmp8(pbuffer->pc,"Asimetrica")==0){
				prepare_onemore(buffer);
				if(strcmp8(pbuffer->pc,"serie1")==0){
					char16_t* pterror2=pterror;
					pterror=strpcpy16(pterror,S_Enasim1);
					resume(buffer); finishline_advance(buffer);
					nret=lee_parametros(global,&interna->distorsion.config.param_asim1,&interna->distorsion.valores_asim1);
					ifunlike(nret!=0) goto malasalida;
					pterror=pterror2;
					iflike(interna->distorsion.config.param_asim1!=0) interna->flags|=CAL_FLAG_Asim1;
					continue;
				}elif(strcmp8(pbuffer->pc,"serie2")==0){
					char16_t* pterror2=pterror;
					pterror=strpcpy16(pterror,S_Enasim2);
					resume(buffer); finishline_advance(buffer);
					nret=lee_parametros(global,&interna->distorsion.config.param_asim2,&interna->distorsion.valores_asim2);
					ifunlike(nret!=0) goto malasalida;
					pterror=pterror2;
					iflike(interna->distorsion.config.param_asim2!=0) interna->flags|=CAL_FLAG_Asim2;
					continue;
				}
			}
			resume(buffer);
nomore_continue:
			mc++;
			finishline_advance(buffer);
			continue;
		}
		resume(buffer);
		finishline_advance(buffer);
	}
salida:
	if(bsdiag && bpoli){finishline_advance(buffer); return 0;}
	if(!bsdiag) strbuild16(pterror,S_Endistorsion,S_Falta_semidiag,NULL);
	else strbuild16(pterror,S_Endistorsion,S_Falta_modelopoli,NULL);
	return ATREAD_MISSINGDATA;
malasalida:
	pbuffer->next=get_codigo8(pbuffer->pc,"\\end");
	if(*pbuffer->next=='\0') pbuffer->pc=pbuffer->next;
	else{finishline_advance(buffer);}
	return nret;
salida_eof:
	return ATREAD_EOF;
error_caracter:
	pterror=strbuild16(pterror,S_Endistorsion,S_Mientras,TEXTOInternad(cod_error),S_seencontro,NULL);
	*pterror++=*pbuffer->pc;
	strcpy16(pterror,S_wasfound);
	return ATREAD_CARACTER;
}

int lee_radsim(Global* global, uint *params, float* *pvalores){
	s8int mc;
	u8int t;
	char8_t c='\0';

	free_null_if(*pvalores);
	aj_malloc_return(*pvalores,float,16);
	zeroset_float(*pvalores,16);
	*params=0;
	mc=1;
	advance(buffer);
	while(*buffer.pc!='\0'){
		prepare_string(buffer);
		if(*buffer.pc=='\\' || mc>1){
			if(strcmp8(buffer.pc,"\\end")==0){
				resume(buffer);
				if(mc==1){finishline_advance(buffer); return 0;}
				mc--;
			}elif(strcmp8(buffer.pc,"\\begin")==0) mc++;
			resume(buffer);
			finishline_advance(buffer);
			continue;
		}
		if(strcmp8(buffer.pc,"r1")==0 || strcmp8(buffer.pc,"condicion")==0){
			resume(buffer);
			finishline_advance(buffer);
			continue;
		}
		if(c=='\0') c=*buffer.pc;
		elif(*buffer.pc!=c){
			pterror=strbuild_mixed(pterror, 'w',S_Param_novalido, 'w',u": ", 'c',buffer.pc, 'w',u"\n", 'w',S_Todosparams_mismaletra,'\0');
			*pterror++=c;
			pterror=strpcpy16(pterror,S_mientrasqueeste);
			*pterror++=*buffer.pc; *pterror++='\0';
			resume(buffer);
			return ATREAD_BADKEYVAL;
		}
		*buffer.next=buffer.savedchar;
		buffer.pc++;
		ifnot_get_stay(buffer,t,(u8int)uint___str8){
			isolate_word(buffer);
			strbuild_mixed(pterror,'w',S_Param_novalido, 'w',u": ", 'c',buffer.pc,'\0');
			resume(buffer);
			return ATREAD_CARACTER;
		}
		if(t==0 || t>16){
			isolate_word(buffer);
			strbuild_mixed(pterror,'w',S_Param_novalido, 'w',u": ", 'c',buffer.pc,'\0');
			resume(buffer);
			return ATREAD_RANGE;
		}
		advanceinline(buffer);
		if(*buffer.pc=='\n'){
			pterror=strbuild16(pterror,S_Finaldelinea,S_valor_parametro,NULL);
			*pterror++=c;
			str16___uint(pterror,t);
			return ATREAD_LINEA;
		}
		t--;
		if_get_stay(buffer,(*pvalores)[t],float___str8){
			*params|=1<<t;
		}else{
			pterror=strbuild16(pterror,S_Mientras,S_valor_parametro,S_seencontro,NULL);
			*pterror++=*buffer.pc; strcpy16(pterror,S_wasfound);
			return ATREAD_CARACTER;
		}
		finishline_advance(buffer);
	}
	strcpy16(pterror,S_End);
	return ATREAD_EOF;
}

 int lee_parametros(Global* global, uint *params, float* *pvalores){
	s8int mc;
	char8_t c='\0';
	u8int t;

	*params=0;
	free_null_if(*pvalores);
	aj_malloc_return(*pvalores,float,16);
	zeroset_float(*pvalores,16);
	mc=1;
	advance(buffer);
	while(*buffer.pc!='\0'){
		if(*buffer.pc=='\\' || mc>1){
			prepare_string(buffer);
			if(strcmp8(buffer.pc,"\\end")==0){
				resume(buffer);
				if(mc==1){finishline_advance(buffer); return 0;}
				mc--;
			}elif(strcmp8(buffer.pc,"\\begin")==0) mc++;
			resume(buffer);
			finishline_advance(buffer);
			continue;
		}
		if(c=='\0') c=*buffer.pc;
		elif(*buffer.pc!=c){
			pterror=strbuild_mixed(pterror,'w',S_Param_novalido, 'w',u": ", 'c',buffer.pc, 'w',u"\n", 'w',S_Todosparams_mismaletra,'\0');
			*pterror++=c;
			pterror=strpcpy16(pterror,S_mientrasqueeste);
			*pterror++=*buffer.pc; *pterror++=u'\0';
			resume(buffer);
			return ATREAD_BADKEYVAL;
		}
		*buffer.next=buffer.savedchar;
		buffer.pc++;
		ifnot_get_stay(buffer,t,(u8int)uint___str8){
			isolate_word(buffer);
			strbuild_mixed(pterror,'w',S_Param_novalido, 'w',u": ", 'c',buffer.pc,'\0');
			resume(buffer);
			return ATREAD_CARACTER;
		}
		if(t==0 || t>16){
			isolate_word(buffer);
			strbuild_mixed(pterror,'w',S_Param_novalido, 'w',u": ", 'c',buffer.pc,'\0');
			resume(buffer);
			return ATREAD_RANGE;
		}
		advanceinline(buffer);
		if(*buffer.pc=='\n'){
			pterror=strbuild16(pterror,S_Finaldelinea,S_valor_parametro,NULL);
			*pterror++=c;
			str16___uint(pterror,t);
			return ATREAD_LINEA;
		}
		t--;
		if_get_stay(buffer,(*pvalores)[t],float___str8){
			*params|=1<<t;
		}else{
			pterror=strbuild16(pterror,S_Mientras,S_valor_parametro,S_seencontro,NULL);
			*pterror++=*buffer.pc; strcpy16(pterror,S_wasfound);
			return ATREAD_CARACTER;
		}
		finishline_advance(buffer);
	}
	strcpy16(pterror,S_End);
	return ATREAD_EOF;
}

 //Si aparece INC se supone que son coordenadas píxel y hay que cambiar el signo a la coordenada y.
 //Si no aparece, se supone que el sistema ya está orientado con la y hacia arriba.
 int lee_ficheroint_ini(Global *global, OrientacionInterna* interna, bint bfocal, bint bpp){
	InternaKPB mala;

	mala.pixels.cy=mala.pixels.cx=0;
	mala.pixels.px=1.0F;
	mala.pixels.py=-1.0F;	//Para anular el cambio de signo en interna_Aerotri___kpb
	mala.f=0;
	mala.y=mala.x=0;
	zeroset_float(mala.k,5);
	mala.p1=mala.p2=0;
	mala.b1=mala.b2=0;

	advance(buffer);
	while(*buffer.pc!='\0'){
		const char8_t *ptr;
		double val;
		bint b=0;

		if(*buffer.pc==';' || *buffer.pc=='['){finishline_advance(buffer); continue;}
		{char8_t *s=buffer.pc; do s++; while(*s!='=' && *s!='\n'); if(*s=='=') *s=' ';}
		ptr=buffer.pc;
		prepare_string(buffer);
		buffer.pc=buffer.next+1;
		if(buffer.savedchar!='\n') advanceinline(buffer);
		if(buffer.savedchar=='\n' || *buffer.pc=='\0' || *buffer.pc=='\n'){
			advance(buffer); continue;
		}
		ifnot_get_stay(buffer,val,double___str8){
			pterror=strbuild_mixed(pterror,'w',u"Mientras se estaba leyendo el valor de ", 'c',ptr, 'w',u"se encontró el carácter '");
			*pterror++=*buffer.pc; *pterror++=u'\''; *pterror++=u'\0';
			return ATREAD_CARACTER;
		}
		if(!strcmp8(ptr,"INC") || !strcmp8(ptr,"inc")){b=1; mala.pixels.py=mala.pixels.px=(float)val;}
		elif(!strcmp8(ptr,"XPIX") || !strcmp8(ptr,"xpix")) mala.pixels.cx=0.5F*(float)val;
		elif(!strcmp8(ptr,"YPIX") || !strcmp8(ptr,"ypix")) mala.pixels.cy=0.5F*(float)val;
		elif(!strcmp8(ptr,"FOC") || !strcmp8(ptr,"foc")){b=1; mala.f=val;}
		elif(!strcmp8(ptr,"XPP") || !strcmp8(ptr,"xpp")) mala.x=val;
		elif(!strcmp8(ptr,"YPP") || !strcmp8(ptr,"ypp")) mala.y=val;
		elif(!strcmp8(ptr,"K0") || !strcmp8(ptr,"k0")) mala.k[0]=(float)val;
		elif(!strcmp8(ptr,"K1") || !strcmp8(ptr,"k1")) mala.k[1]=(float)val;
		elif(!strcmp8(ptr,"K2") || !strcmp8(ptr,"k2")) mala.k[2]=(float)val;
		elif(!strcmp8(ptr,"K3") || !strcmp8(ptr,"k3")) mala.k[3]=(float)val;
		elif(!strcmp8(ptr,"K4") || !strcmp8(ptr,"k4")) mala.k[4]=(float)val;
		elif(!strcmp8(ptr,"P1") || !strcmp8(ptr,"p1")) mala.p1=(float)val;
		elif(!strcmp8(ptr,"P2") || !strcmp8(ptr,"p2")) mala.p2=(float)val;
		elif(!strcmp8(ptr,"B1") || !strcmp8(ptr,"b1")) mala.b1=(float)val;
		elif(!strcmp8(ptr,"B2") || !strcmp8(ptr,"b2")) mala.b2=(float)val;
		if(b){ifunlike(val==0){
			strcpy16(pterror,u"Ni la focal (FOC) ni el tamaño de píxel (INC) pueden valer 0");
			return ATREAD_RANGE;
		}}
		finishline_advance(buffer);
	}
	ifunlike(mala.f==0){
		strcpy16(pterror,u"El fichero ini está incompleto. Falta el valor de la focal (código FOC)");
		return ATREAD_MISSINGDATA;
	}

	{int nret=interna_Aerotri___kpb(&mala,interna,bfocal,bpp);
	return nret;} //el único valor posible !=0 es AT_NOMEM
}

 int lee_ficheroint_Digi(Global *global, OrientacionInterna* interna, bint bfocal, bint bpp){
	InternaKPB mala;

	mala.pixels.cy=mala.pixels.cx=0;
	mala.pixels.px=1.0F;
	mala.pixels.py=1.0F;
	mala.f=0;
	mala.y=mala.x=0;
	zeroset_float(mala.k,5);
	mala.p1=mala.p2=0;
	mala.b1=mala.b2=0;

	advance(buffer);
	while(*buffer.pc!='\0'){
		const char8_t *ptr;
		double val;
		u8int b=0;

		if(*buffer.pc==';' || *buffer.pc=='['){finishline_advance(buffer); continue;}
		{char8_t *s=buffer.pc; do s++; while(*s!='=' && *s!='\n'); if(*s=='=') *s=' ';}
		ptr=buffer.pc;
		prepare_string(buffer);
		buffer.pc=buffer.next+1;
		if(buffer.savedchar!='\n') advanceinline(buffer);
		if(buffer.savedchar=='\n' || *buffer.pc=='\0' || *buffer.pc=='\n'){
			advance(buffer); continue;
		}
		ifnot_get_stay(buffer,val,double___str8){
			pterror=strbuild_mixed(pterror,'w',u"Mientras se estaba leyendo el valor de ", 'c',ptr, 'w',u"se encontró el carácter '");
			*pterror++=*buffer.pc; *pterror++=u'\''; *pterror++=u'\0';
			return ATREAD_CARACTER;
		}
		if(!strcmp8(ptr,"TamanoPixel")){b=1; mala.pixels.py=mala.pixels.px=(float)val;}
		elif(!strcmp8(ptr,"Focal")) b=1, mala.f=val;
		elif(!strcmp8(ptr,"PuntoPrincipal")) b=2, mala.x=val;
		elif(!strcmp8(ptr,"CentroFiducial")) b=3, mala.pixels.cx=(float)val;
		elif(!strcmp8(ptr,"K0") || !strcmp8(ptr,"k0")) mala.k[0]=(float)val;
		elif(!strcmp8(ptr,"K1") || !strcmp8(ptr,"k1")) mala.k[1]=(float)val;
		elif(!strcmp8(ptr,"K2") || !strcmp8(ptr,"k2")) mala.k[2]=(float)val;
		elif(!strcmp8(ptr,"K3") || !strcmp8(ptr,"k3")) mala.k[3]=(float)val;
		elif(!strcmp8(ptr,"K4") || !strcmp8(ptr,"k4")) mala.k[4]=(float)val;
		elif(!strcmp8(ptr,"P1") || !strcmp8(ptr,"p1")) mala.p1=(float)val;
		elif(!strcmp8(ptr,"P2") || !strcmp8(ptr,"p2")) mala.p2=(float)val;
		elif(!strcmp8(ptr,"B1") || !strcmp8(ptr,"b1")) mala.b1=(float)val;
		elif(!strcmp8(ptr,"B2") || !strcmp8(ptr,"b2")) mala.b2=(float)val;

		if(b==2 || b==3){
			advanceinline(buffer);
			ifunlike_nomore(buffer){
				const char16_t *s;
				if(b==2) s=u"Falta la coordenada 'y' del punto principal";
				else s=u"Falta la coordenada 'y' del centro fiducial";
				pterror=strbuild_mixed(pterror,'w',s);
				return ATREAD_LINEA;
			}
			ifnot_get_stay(buffer,val,double___str8){
				pterror=strbuild_mixed(pterror,'w',u"Mientras se estaba leyendo el valor de ", 'c',ptr, 'w',u"se encontró el carácter '");
				*pterror++=*buffer.pc; *pterror++=u'\''; *pterror++=u'\0';
				return ATREAD_CARACTER;
			}
			if(b==2) mala.y=val;
			else mala.pixels.cy=(float)val;
		}
		elif(b==1){ifunlike(val==0){
			strcpy16(pterror,u"Ni la focal ni el tamaño de píxel pueden valer 0");
			return ATREAD_RANGE;
		}}
		finishline_advance(buffer);
	}
	ifunlike(mala.f==0){
		strcpy16(pterror,u"El fichero cam está incompleto. Falta el valor de la focal (Focal=<valor>)");
		return ATREAD_MISSINGDATA;
	}
	mala.pixels.cx/=mala.pixels.px;
	mala.pixels.cy/=mala.pixels.py;

	{int nret=interna_Aerotri___kpb(&mala,interna,bfocal,bpp);
	return nret;} //el único valor posible !=0 es AT_NOMEM
}

int lee_ficheroint_IMaster(Global *global, OrientacionInterna* interna, bint bfocal, bint bpp){
	InternaKPB mala;
	uint modelo, nparam;

	advance(buffer);
	ifnot_get_stay(buffer,mala.f,double___str8) goto error_file1;	finishline_advance(buffer);
	ifnot_get_stay(buffer,mala.x,double___str8) goto error_file1;	finishline_advance(buffer);
	ifnot_get_stay(buffer,mala.y,-double___str8) goto error_file1;	finishline_advance(buffer);
	ifnot_get_stay(buffer,modelo,uint___str8) goto error_file1;	finishline_advance(buffer);
	ifnot_get_stay(buffer,nparam,uint___str8) goto error_file1;	finishline_advance(buffer);
	ifunlike(modelo>3 && nparam>0){
		strcpy16(pterror,u"El modelo de distorsión no puede ser mayor que 3");
		return ATREAD_RANGE;
	}
	mala.pixels.cy=mala.pixels.cx=0;
	mala.pixels.py=mala.pixels.px=0;
	zeroset_float(mala.k,5);
	mala.p1=mala.p2=0;
	if(modelo){
		if(nparam){ifnot_get_stay(buffer,mala.k[1],float___str8) goto error_file1;	finishline_advance(buffer); nparam--;}
		if(nparam){ifnot_get_stay(buffer,mala.k[2],float___str8) goto error_file1;	finishline_advance(buffer); nparam--;}
		if(nparam){
			float aux;
			ifnot_get_stay(buffer,aux,float___str8) goto error_file1;	finishline_advance(buffer);
			if(modelo!=2) mala.k[3]=aux;		else mala.p1=aux;
			nparam--;
		}
		if(nparam){
			float aux;
			ifnot_get_stay(buffer,aux,float___str8) goto error_file1;	finishline_advance(buffer);
			if(modelo==1) mala.k[4]=aux;
			elif(modelo==2) mala.p2=aux;
			else /*3*/ mala.p1=aux;
			nparam--;
		}
		if(nparam && modelo==3){ifnot_get_stay(buffer,mala.p2,float___str8) goto error_file1;	finishline_advance(buffer); nparam--;}
	}
	while(nparam--) finishline(buffer);
	advance(buffer);
	ifnot_get_stay(buffer,mala.pixels.px,float___str8) goto error_file1;	finishline_advance(buffer);
	ifnot_get_stay(buffer,mala.pixels.py,float___str8) goto error_file1;	finishline_advance(buffer);
	if(*buffer.pc=='\0' && mala.pixels.py==0){	//aquí tiene que estar el número de marcas fiduciales
		strcpy16(pterror,u"El fichero cmr está incompleto");
		return ATREAD_MISSINGDATA;
	}
	ifunlike(mala.f==0 || mala.pixels.px==0 || mala.pixels.py==0){
		strcpy16(pterror,u"Ni la focal ni las resoluciones en x e y (tamaño de píxel)\npueden valer 0");
		return ATREAD_RANGE;
	}

	mala.k[1]=-mala.k[1];
	mala.k[2]=-mala.k[2];
	mala.k[3]=-mala.k[3];
	mala.p1=-mala.p1;
	mala.p2=-mala.p2;
	{int nret=interna_Aerotri___kpb(&mala,interna,bfocal,bpp);
	return nret;} //el único valor posible !=0 es AT_NOMEM

error_file1:
	pterror=strpcpy16(pterror,u"Error en la lectura del fichero cmr:\n Mientras se estaba leyendo un número se encontró en carácter '");
	*pterror++=*buffer.pc; *pterror++=u'\''; *pterror++=u'\0';
	return ATREAD_CARACTER;
 }

 int lee_ficheroint_RapidCal(Global *global, OrientacionInterna* interna, bint bfocal, bint bpp){
	InternaKPB mala;
	float gen_scale, gens, g2;
	float a,bet;
	float sx,sy;

	gen_scale=1.0F;
	bet=a=0;
	sy=sx=0;
	mala.pixels.cy=mala.pixels.cx=0;
	mala.pixels.px=1;
	mala.pixels.py=1;
	mala.f=0;
	mala.y=mala.x=0;
	zeroset_float(mala.k,5);
	mala.p1=mala.p2=0;

	advance(buffer);
	while(*buffer.pc!='\0'){
		const char8_t *ptr;
		double *pdbl; float *pfl;
		double val;
		bint b=0;

		if(*buffer.pc=='%'){finishline_advance(buffer); continue;}
		ptr=buffer.pc;
		prepare_string(buffer);
		buffer.pc=buffer.next+1;
		if(buffer.savedchar!='\n') advanceinline(buffer);
		if(buffer.savedchar=='\n' || *buffer.pc=='\0' || *buffer.pc=='\n'){
			advance(buffer); continue;
		}
		pdbl=NULL;
		pfl=NULL;
		if(!strcmp8(ptr,"Focal_length")){b=1; pdbl=&mala.f;}
		elif(!strcmp8(ptr,"Principal_point_x")) pdbl=&mala.pixels.cx;
		elif(!strcmp8(ptr,"Principal_point_y")) pdbl=&mala.pixels.cy;
		elif(!strcmp8(ptr,"General_scaling")){b=1; pfl=&gen_scale;}
		elif(!strcmp8(ptr,"Radial_k1")) pfl=&mala.k[1];
		elif(!strcmp8(ptr,"Radial_k2")) pfl=&mala.k[2];
		elif(!strcmp8(ptr,"Radial_k3")) pfl=&mala.k[3];
		elif(!strcmp8(ptr,"Tangential_t1")) pfl=&mala.p2;	//right
		elif(!strcmp8(ptr,"Tangential_t2")) pfl=&mala.p1;
		elif(!strcmp8(ptr,"Affinity")) pfl=&a;
		elif(!strcmp8(ptr,"Un-orthogonality")) pfl=&bet;
		elif(!strcmp8(ptr,"Sensor_width")) pfl=&sx;
		elif(!strcmp8(ptr,"Sensor_height")) pfl=&sy;
		if(pdbl==NULL && pfl==NULL){
			finishline_advance(buffer); continue;
		}

		ifnot_get_stay(buffer,val,double___str8){
			pterror=strbuild_mixed(pterror,'w',u"Mientras se estaba leyendo el valor de ", 'c',ptr, 'w',u"se encontró el carácter '", 0);
			*pterror++=*buffer.pc; *pterror++=u'\''; *pterror++=u'\0';
			return ATREAD_CARACTER;
		}
		if(pfl==&sx || pfl==&sy){
			double val2;
			advanceinline(buffer);
			ifunlike_nomore(buffer){
				strbuild_mixed(pterror,'w',u"Son necesarios dos valores para ", 'c',ptr, 'w',u". Falta el segundo", 0);
				return ATREAD_LINEA;
			}
			ifnot_get_stay(buffer,val2,double___str8){
				pterror=strbuild_mixed(pterror,'w',u"Mientras se estaba leyendo el segundo valor de ", 'c',ptr, 'w',u"se encontró el carácter '", 0);
				*pterror++=*buffer.pc; *pterror++=u'\''; *pterror++=u'\0';
				return ATREAD_CARACTER;
			}
			ifunlike(val==0 || val2==0){
				strbuild_mixed(pterror,'w',u"Ninguno de los dos valores de '", 'c',ptr, 'w',u"' pueden valer 0", 0);
				return ATREAD_RANGE;
			}
			val=val2/val;
		}
		if(b){ifunlike(val==0){
			strcpy16(pterror,u"Ni la focal ni 'general_scaling' pueden valer 0");
			return ATREAD_RANGE;
		}}
		if(pdbl!=NULL) *pdbl=val;
		else *pfl=(float)val;
		finishline_advance(buffer);
	}
	ifunlike(mala.f==0){
		strcpy16(pterror,u"El fichero está incompleto. Falta el valor de la focal (código Focal_length)");
		return ATREAD_MISSINGDATA;
	}
	gens=gen_scale;
	g2=gen_scale*gen_scale;
	mala.p1*=g2;		mala.p2*=g2;
	gen_scale*=g2;
	mala.k[1]*=gen_scale;	gen_scale*=g2;
	mala.k[2]*=gen_scale;	gen_scale*=g2;
	mala.k[3]*=gen_scale;

	if(sx!=0 && sy!=0) mala.pixels.py=(float)(sy/sx);
	{int nret=interna_Aerotri___kpb(&mala,interna,false,bpp);
	ifunlike(nret) return nret;} //el único valor posible !=0 es AT_NOMEM

	if(a!=0 || bet!=0){
		if(interna->ASIM1==NULL){
			aj_malloc_return(interna->ASIM1,float,16);
			zeroset_float(interna->ASIM1,16);
		}
		if(interna->ASIM2==NULL){
			aj_malloc_return(interna->ASIM2,float,16);
			zeroset_float(interna->ASIM2,16);
		}
	}
	if(a!=0){
		if(interna->RS==NULL){
			aj_malloc_return(interna->RS,float,8);
			zeroset_float(interna->RS,8);
		}
		interna->distorsion.config.param_radsim|=1;
		a*=0.5F*gens;
		a*=interna->SDIAG;
		interna->RS[0]+=a;
		interna->distorsion.config.param_asim1|=1<<5;
		interna->distorsion.config.param_asim2|=1<<6;
		interna->ASIM2[6]=-(interna->ASIM1[5]=-a);
	}
	if(bet!=0){
		if(interna->TS==NULL){
			aj_malloc_return(interna->TS,float,8);
			zeroset_float(interna->TS,8);
		}
		interna->distorsion.config.param_tansim|=1;
		interna->distorsion.config.param_asim1|=1<<6;
		interna->distorsion.config.param_asim2|=1<<5;
		bet*=0.5F*gens;
		bet*=interna->SDIAG;
		interna->TS[0]=-bet;
		interna->ASIM2[5]=interna->ASIM1[6]=bet;
	}
	if(bfocal) elimina_a1(interna);
	return 0;
}

#undef idioma
#undef mensaje
#undef pterror
#undef pbuffer
