﻿typedef struct _hentry{
	uint pos;
	uint next;
} hentry;

//Si .ppio[k]=n entonces:
//		si nsdata==NULL:	(*data)+pos es la dirección del elemento
//		si nsdata!=NULL:	(*data)+(*nsdata)[pos]
typedef struct _Hashentry{
	char8_t **data;		//bloque con los elementos. Stored elsewhere
	uint **nsdata;
	uint (*func)(const char8_t *elem, uint umbral);	//puntero a la función de hash
	uint n;	//número de entradas ocupadas
	uint N;	//size of hash
	hentry *ppio;
	uint umbral;		//El valor devuelto por funchash() es <umbral
	uint last_full;	//A partir de aquí la tabla está llena
} Hashentry;

//funciones para el usuario
#define gethentry_(type) merge(gethentry_,type)
sinline int addhentry(Hashentry *hash, const void *elem, uint pos_en_data);
sinline void removehentry(Hashentry *hash, hentry *p);
//Si estamos seguros de que hay sitio
void _inserthentry(Hashentry *hash, const void *pelem, uint pos_en_data);

//Si estamos seguros de que hay sitio
void _inserthentry(Hashentry *hash, const void *pelem, uint pos_en_data){
	uint k=hash->func(pelem,hash->umbral);
	while(hash->ppio[k].next!=Я) k=hash->ppio[k].next;
	if(hash->ppio[k].pos==Я){
		hash->ppio[k].pos=pos_en_data;
		hash->ppio[k].next=Я;
	}else{
		hentry *ptrj=hash->ppio+hash->last_full;
		while((--ptrj)->pos!=Я);
		hash->ppio[k].next=hash->last_full=(pdif)(ptrj-hash->ppio);
		ptrj->pos=pos_en_data;
		ptrj->next=Я;
	}
	hash->n++;
}

int rehashentry(Hashentry *hash, uint n){
	uint N;
	hentry *pviejo;

	if(n<hash->n) n=hash->n;
	N=n+(n>>2);
	checked_malloc_n(pviejo,hentry,N,return AT_NOMEM);
	oneset_uint(pviejo,N*uintsizeof(hentry));
	{hentry *paux=hash->ppio; hash->ppio=pviejo; pviejo=paux;}

	cint i=hash->N;
	hash->last_full=hash->N=N;
	hash->umbral=n;
	hash->n=0;
	for(hentry *ptr=pviejo;i--;ptr++){
		uint kpos;
		if(ptr->pos==Я) continue;	kpos=ptr->pos;
		if(hash->nsdata!=NULL) kpos=(*hash->nsdata)[kpos];
		_inserthentry(hash,(*hash->data)+kpos,ptr->pos);
	}
	free(pviejo);
	return 0;
}

sinline int hentryreserve(Hashentry *hash, uint n){
	n+=hash->n;
	if(n>hash->N) return rehashentry(hash,n);
	else return 0;
}

sinline int addhentry(Hashentry *hash, const void *elem, uint pos_en_data){
	if(hash->n==hash->N){
		uint N=hash->n+(hash->umbral>>1);
		int nret=rehashentry(hash,N);
		ifunlike(nret) return nret;
	}
	_inserthentry(hash,elem,pos_en_data);
	return 0;
}

sinline void removehentry(Hashentry *hash, hentry *p){
	if(p->next!=Я){
		hentry *q=hash->ppio+p->next;
		memcpy_uint(p,q,uintsizeof(hentry));
		p=q;
	}
	p->pos=Я;
	hash->n--;
	if((pdif)(p-hash->ppio)==hash->last_full){
		hentry *ptope=hash->ppio+hash->N;
		while(++p!=ptope && p->pos==Я);
		hash->last_full=(pdif)(p-hash->ppio);
	}
}

#define HentryInit(hash,funchash,_data,_nsdata) \
	(hash).data=&(_data); (hash).func=&(funchash);\
	if(_nsdata!=NULL) (hash).nsdata=&(_nsdata); else hash.nsdata=NULL;\
	(hash).ppio=NULL; (hash).umbral=(hash).N=(hash).n=0;

#define HentrySetup(x,funchash,_data,_nsdata, n,bad_code) \
	HentryInit(x,funchash,_data,_nsdata)\
	HsetupЯ(hentry,x,n,bad_code)


#ifndef funchash_reorden	//ya se ha definido funchash_hnom
sinline uint funchash_hnom(const char8_t *nom,uint umbral){
	uint n=0;
	while(*nom!='\0'){n<<=2; n+=*nom++; while(n>=umbral) n-=umbral;}
	return n;
}
#endif

#define type char8_t
#define funchash funchash_hnom
#define Hashentry_isequal(s1,s2) (strcmp8(s1,s2)==0)
#include "hashentry.cod"
#undef type
#undef Hashentry_isequal
#define Hashentry_isequal(p1,p2) (*p1==*p2)
