﻿/*Fotos con las que cada foto tiene puntos en común y el número de éstos.
Es necesario poder acceder rápido aleatoriamente y secuencialmente por fotos.
Esta solución es una mezcla de LinkedList y Hash. GrupoFotoscomun es una LinkedList
que crece como un vector. En principio se reserva un GrupoFotoscomun para cada foto.
Dentro de cada GrupoFotoscomun se accede a la foto que se busca mediante una
entrada Hash. Si la posición está ocupada se mira en una segunda posición, y si también
'siguiente', que es el offset a otro GrupoFotoscomun, en el cual la posición que corresponde
a la foto buscada es la misma que en el primer grupo. Si aquí también están ocupadas
ambas se pasa al grupo siguiente, y así sucesivamente. 
siguiente=0 indica que no hay más grupos. */
typedef struct{
	uint ncp2;	//un -1 indica ausencia de foto
	uint npuntos;
} Fotocomun;

typedef struct{
	uint siguiente;
	Fotocomun fotos[16];
} GrupoFotoscomun;

//No incluye el 1 del principio
#define funchash_Fotocomun(ncp1,ncp2) (ncp2&0xF)

defineVector(GrupoFotoscomun)
//Si no está devuelve NULL;
Fotocomun* get_Fotocomun(GrupoFotoscomun *pares, uint ncp1, uint ncp2){
	GrupoFotoscomun *ppares;
	uint npos;

	npos=funchash_Fotocomun(ncp1,ncp2);
	ppares=pares+ncp1;
	do{
		Fotocomun *ppar=ppares->fotos+npos;
		if(ppar->ncp2==ncp2) return ppar;
		if(ppar->ncp2==Я) return NULL;
		ppar=ppares->fotos+(npos^0x8);
		if(ppar->ncp2==ncp2) return ppar;
		if(ppar->ncp2==Я) return NULL;

		if(ppares->siguiente==0) return NULL;
		ppares+=ppares->siguiente;
	}while(1);
}

//Añade 1. Si la entrada no existe la crea y pone un valor 1. Reserva memoria si es necesario.
//Devuelve un puntero al par. Devuelve NULL si no hay memoria
Fotocomun* Fotocomun_adduno(Vector_GrupoFotoscomun *vpares, uint ncp1, uint ncp2){
	GrupoFotoscomun *ppares;
	uint npos;

	npos=funchash_Fotocomun(ncp1,ncp2);
	ppares=vpares->ppio+ncp1;
	do{
		Fotocomun *ppar=ppares->fotos+npos;
		if(ppar->ncp2!=ncp2 && ppar->ncp2!=Я){
			ppar=ppares->fotos+(npos^0x8);
		}
		if(ppar->ncp2==ncp2){
			ppar->npuntos++;
			return ppar;
		}
		if(ppar->ncp2==Я){
			ppar->ncp2=ncp2;
			ppar->npuntos=1;
			return ppar;
		}
		if(ppares->siguiente==0){
			GrupoFotoscomun *psiguiente;
			uint nppar=(pdif)(ppares-vpares->ppio);
			Venlarge_one(*vpares,GrupoFotoscomun,psiguiente,return NULL);
			ppares=vpares->ppio+nppar;
			ppares->siguiente=(pdif)(psiguiente-ppares);
			oneset_uint(psiguiente,uintsizeof(GrupoFotoscomun));
			psiguiente->siguiente=0;
		}
		ppares+=ppares->siguiente;
	}while(1);
}
