#include "Clasesgenericas.h"
#include <ATcrt/ATarrays.h>
#include <AT2D3D/Estructuras2d3d.h>
#include "Clases_grafico_memoria.h"
#include "configgra.h"
#include <AT2D3D/rotacion.h>
#include "gra_vista.h"

IMP_EXP void merge_pixel(color *ppixel, float f, color col);

struct InformaciondeElemento{
	uint Tipo;		//tipo y subtipo
	const char16_t* nombre_tipo;
	const char16_t* nombre_subtipo;
	char8_t* nombre;
	double extremos[6];
	char8_t* descripcion;	//To be changed to char16_t cuando se elimine la implementación antigua
	uint* adicional;	//Se copia literalmente
};

IMP_EXP s8int retrive_precisionZ(Gra_GraficoenMemoria *pfichero);
IMP_EXP s8int retrive_precisionX(Gra_GraficoenMemoria *pfichero);
IMP_EXP s8int retrive_precisionY(Gra_GraficoenMemoria *pfichero);
IMP_EXP int get_tipos_presentes(Gra_GraficoenMemoria *pfichero, uint* *ptipos);

/*Reservan espacio para lienzo y situa la ventana centrada en él, de acuerdo a los valores de nrows_v y ncols_v.
Llena el lienzo con el valor NO_COLOR. Reserva espacio para InfoVista y sus elementos, y lo rellena.
Devuelve AT_NOMEM si no hay memoria y libera todo lo que haya reservado
La estructura Gra_Vista hay que liberarla con libera_GraVista.*/
IMP_EXP int setup_vista_identity(Gra_Vista *vista, int nrows_v, int ncols_v, Gra_GraficoenMemoria *pfichero);
IMP_EXP  int setup_vista(Gra_Vista *vista, double M[][3], int nrows_v, int ncols_v, Gra_GraficoenMemoria *pfichero);
IMP_EXP void free_vista(Gra_Vista *vista);
/*obtiene el mínimo rectangulo que contiene a todos los píxeles sin color de rect
El área fuera del lienzo también se incluye en invalido*/
IMP_EXP void obtiene_invalido(Gra_Vista *vista, RectVentana rect, RectVentana *invalido);
//Calcula minmaxV y sis_lienzo a partir de los valores de ventana, margen y sis_vista.extremosV
IMP_EXP void calcula_sis_lienzo_ajustado(Gra_Vista *vista, float margen);

IMP_EXP void terreno___interno(PuntoXYZ_double *P, const Gra_GraficoenMemoria *pfichero);

//Valores de reason:
#define GraDibujar_RectIn			0	//se pinta el rectángulo rect_in.
#define GraDibujar_AllUnkown	1	//se pinta en toda la ventana, y fuera de ella se anula
#define GraDibujar_AllKnown		2	//se pinta en toda la ventana, y fuera de ella se pone el color de fondo
#define GraDibujar_Especiales		3	//se dibujan sólo los elementos que aparecen en CE
//return 0, AT_NOMEM,
//		1: En alguna de las estructuras de _grafico falta información
//		2: El rectángulo a pintar está demasiado lejos de la ventana
IMP_EXP int dibuja_nuevo(Gra_GraficoCompleto grafico, Gra_Vista *_vista, u8int reason, RectVentana rect_in, u8int _subpixel, Gra_LinkedOpcionE *OEhead);
IMP_EXP void obtiene_elementos_entorno(Gra_GraficoCompleto _grafico, Gra_Vista* vista, ssint x,ssint y,float radio, uint** pelementos,uint* ne, Gra_LinkedOpcionE *OEhead);
IMP_EXP void situa_en_elemento(uint* base, KeyVal* otherdata,uint tamanno,Gra_Vista* _vista, uint n);
IMP_EXP void devuelve_informacion(Gra_GraficoCompleto grafico, uint n, InformaciondeElemento* infor, u8int _idioma);

/*** Exportación a otros formatos ***/

struct Gra_Opcionesps{
	float escala;	//pasa de las unidades del fichero a metros
	float margen_iz, margen_de;	//en cm
	float margen_ab, margen_ar;
	float grueso_lineas;	//píxel/punto 0.4 está bien
	float size_formas;	//píxel_forma/punto 1.5 está bien
};
struct Gra_Opcionesdxf{
	uint nada;
};

/*Códigos de return comunes: 0, AT_NOMEM,
	1: _grafico no está bien
	2: El fichero no se puede abrir para escribir 
*/
/*gra_a_dgn
	3: El fichero no se puede guardar en ese formato y con las opciones especificadas
	(por ejemplo, porque las coordenadas son demasiado grandes)
	4: El archivo de semilla no existe o no se puede abrir para leer
	5: El archivo de semilla no es válido (como fichero de su formato en general o como fichero de semilla en particular)
	6: otro error

	obtiene_valores_fsemilla
	1: el fichero no existe o no se puede abrir para leer
	10: no se reconoce la cabecera
	11: el fichero es 2D y se ha pedido 3D, o viceversa
	12: el elemento 9 está mal
*/
//gra_a_dgn
//gra_a_bin
IMP_EXP int gra_a_ps(char16_t* ficherops,bint eps, Gra_GraficoCompleto _grafico, Gra_Vista *vista, Gra_LinkedOpcionE *OEhead, Gra_Opcionesps *opciones_ps, char16_t* mensaje,u8int idioma);
IMP_EXP int gra_a_dxf(char16_t* ficherops, Gra_GraficoCompleto _grafico, Gra_LinkedOpcionE *OEhead, Gra_Opcionesdxf *opciones_dxf, char16_t* mensaje,u8int idioma);

IMP_EXP void graficos_free(void* p);
IMP_EXP void selecciona_elemento(uint** pelementos,uint i);
IMP_EXP uint* busca_portipo(KeyVal* otherdata, u8int tipom, u8int tipoM, char8_t busqueda, u8int subtipom, u8int subtipoM);
IMP_EXP int busca_portipo_e_indice(KeyVal* otherdata, u8int tipom, u8int tipoM, char8_t busqueda, u8int subtipom, u8int subtipoM, uint i);
