﻿#include <ATcrt/ATsystem.h>
#include <ATcrt/ATarrays.h>
#include <AT2D3D/Estructuras2d3d.h>
#include "grafico_memoria_public.h"
#define GRAFICOS

#define CARGAGRA_ERRINDICE 7 //El índice no está, o no tiene todas las entradas que tiene que tener,
											//o hay alguna entrada repetida o para alguna de las entradas,
											//en la posición indicada no se encuentra el elemento

//extern int transforma_fichero(char16_t* ficherof, char16_t* fichero_n);

/*Las funciones que reciben un puntero a estructura para llenarla: carga_fichero y carga_cfg
si devuelven distinto de 0 liberan toda la memoria que hayan reservado y dejan el puntero
a NULL, salvo en los casos que se documenten.
Siempre que no haya memoria suficiente devuelven AT_NOMEM
La estructura GraficoenMemoria hay que liberarla con libera_FicheroGrafico.
    "		  "		Gra_GraficoOtherData hay que liberarla con libera_GraficoOtherdata.
*/

#ifdef __cplusplus
extern "C"{
#endif

/*Tras cargar el fichero llama a carga_configuración para cada una de las configuraciones
insertadas. Si es esta función la que da error se devuelve:
	AT_NOMEM en su caso.
	100+cod_error;
	100 si hubo algún error pero la función devolvió 0.

Además, la función puede devolver:
	0: Todo bien
	AT_NOMEM
	Uno de los valores ATREAD_... o uno de los CARGAGRA_...

La memoria se libera en todos los casos salvo que el valor devuelo sea 0 o >=100.
Los nombres de las configuraciones nunca se dejan a NULL.
*/
extern int carga_fichero(const char16_t* ficherof, Gra_GraficoCompleto *grafico);
/*Equivale a llamar a
free_fgrafico, free_Configgra, free(grafico->configs.ppio),
y poner a NULL todos los punteros dentro de grafico*/
extern void free_all(Gra_GraficoCompleto *grafico);
//La propia estructura pfichero se libera además de su contenido.
extern void free_fgrafico(Gra_GraficoenMemoria *pfichero);
extern void free_Configgra(Gra_Configuracion *config);

#ifdef __cplusplus
}
#endif
