//Todas las coordenadas que se manejan en este fichero están en el sistema lienzo

static inline void pure_merge_pixel(color *ppixel, float f, color col){
	float g=1-f;
	color col2;
	set_byte0(ppixel,(umint)(get_byte0(ppixel)*g));
	set_byte1(ppixel,(umint)(get_byte1(ppixel)*g));
	set_byte2(ppixel,(umint)(get_byte2(ppixel)*g));
	set_byte0(&col2,(umint)(get_byte0(&col)*f));
	set_byte1(&col2,(umint)(get_byte1(&col)*f));
	set_byte2(&col2,(umint)(get_byte2(&col)*f));
	set_byte0(ppixel,get_byte0(ppixel)+get_byte0(&col2));
	set_byte1(ppixel,get_byte1(ppixel)+get_byte1(&col2));
	set_byte2(ppixel,get_byte2(ppixel)+get_byte2(&col2));
}

void merge_pixel(color *ppixel, float f, color col){
	bint bb;
	float ff;

	if(*ppixel==0) bb=1;
	elif(*ppixel==0x00FFFFFF) bb=0;
	else bb=((u16int)get_byte0(ppixel)+get_byte1(ppixel)+get_byte2(ppixel) <= (u16int)get_byte0(&col)+get_byte1(&col)+get_byte2(&col));

	if(bb) ff=f*(2.0F-f);
	else ff=0.5F*(f+f*f);
	pure_merge_pixel(ppixel,ff,col);
}

#define ifdentro(marco,x,y) if((x)<(marco)->MX && (x)>=(marco)->mx && (y)<(marco)->MY && (y)>=(marco)->my)

/*	              |          |
	         1   |    2   |   3			0+ 1,2,3
	======|====|======
	        5    |    6   |   7			4+ 1,2,3
	======|====|======
	         9   |  10   |  11			8+ 1,2,3
	              |          |
*/
u8int region(Extremos2D_int *marco,float x, float y){
	u8int r;
	ssint xn,yn;
	yn=(ssint)floorf(y);
	xn=(ssint)floorf(x);
	if(yn<marco->my) r=1;
	elif(yn<marco->MY) r=5;
	else r=9;
	if(xn>=marco->MX) r+=2;
	elif(xn>=marco->mx) r++;
	return r;
}
u8int region_dbl(Extremos2D_dbl *marco,double x, double y){
	u8int r;
	if(y<marco->my) r=1;
	elif(y<marco->MY) r=5;
	else r=9;
	if(x>=marco->MX) r+=2;
	elif(x>=marco->mx) r++;
	return r;
}
sinline bint puede_cortar(u8int reg_p1, u8int reg_p2){
	if(reg_p1==6 || reg_p2==6) return true;
	if(reg_p1==reg_p2) return false;
	if(!(reg_p1&4) && ((reg_p1&12)==(reg_p2&12))) return false;
	if((reg_p1&1) && ((reg_p1&3)==(reg_p2&3))) return false;
	return true;
}

//devuelve falso si no corta. Los bordes se incluyen en la región >=
bint corte_con_marco(Extremos2D_int *marco, Puntoxy_float p1,Puntoxy_float p2, Puntoxy_float *q1, Puntoxy_float *q2){
	float dx,dy, _dx,_dy;
	Extremos2D_fl fmarco;
	u8int rc1, rc2;

	rc1=region(marco,p1.x,p1.y);
	rc2=region(marco,p2.x,p2.y);
	if(!puede_cortar(rc1,rc2)) return false;
	if(rc1==6 && rc2==6){
		*q1=p1; *q2=p2;
		return true;
	}

	fmarco.mx=(float)marco->mx;
	fmarco.MX=(float)marco->MX;
	fmarco.my=(float)marco->my;
	fmarco.MY=(float)marco->MY;
	dx=p2.x-p1.x;
	dy=p2.y-p1.y;
	_dx=1.0F/dx;
	_dy=1.0F/dy;

	if(dy==0 || !isfinite(_dy)){
		q2->y=q1->y=p1.y;
		if(rc1==5) q1->x=fmarco.mx;
		elif(rc1==6) q1->x=p1.x;
		else q1->x=fmarco.MX;
		if(rc2==5) q2->x=fmarco.mx;
		elif(rc2==6) q2->x=p2.x;
		else q2->x=fmarco.MX;
		return true;
	}
	if(dx==0 || !isfinite(_dx)){
		q2->x=q1->x=p1.x;
		if(rc1==2) q1->y=fmarco.my;
		elif(rc1==6) q1->y=p1.y;
		else q1->y=fmarco.MY;
		if(rc2==2) q2->y=fmarco.my;
		elif(rc2==6) q2->y=p2.y;
		else q2->y=fmarco.MY;
		return true;
	}

	float t1,t2;
	bint bswitch=0;
	if(fabsf(dy)<fabsf(dx)){
		float faux;
		faux=p1.x;	p1.x=p1.y;	p1.y=faux;
		faux=p2.x;	p2.x=p2.y;	p2.y=faux;
		faux=dx;		dx=dy;		dy=faux;
		faux=_dx;		_dx=_dy;		_dy=faux;
		faux=fmarco.mx;	fmarco.mx=fmarco.my;	fmarco.my=faux;
		faux=fmarco.MX;	fmarco.MX=fmarco.MY;	fmarco.MY=faux;
		bswitch=1;
	}
	//dy>=dx Probar primero la intersección con los lados verticales
	t1=_dx*(fmarco.mx-p1.x);		q1->y=p1.y+t1*dy;		q1->x=fmarco.mx;
	t2=_dx*(fmarco.MX-p1.x);	q2->y=p1.y+t2*dy;		q2->x=fmarco.MX;
	if(q1->y<fmarco.my || q2->y<fmarco.my){
		float t, qx;
		if(q1->y<fmarco.my && q2->y<fmarco.my) return false;	// 0/0
		t=_dy*(fmarco.my-p1.y);		qx=p1.x+t*dx;
		if(q1->y<fmarco.my){q1->x=qx; q1->y=fmarco.my; t1=t;}	//Llevar el 0 a my
		else{q2->x=qx; q2->y=fmarco.my; t2=t;}
		if(q1->y>fmarco.MY || q2->y>fmarco.MY){	// 0/8, 8/0
			t=_dy*(fmarco.MY-p1.y);		qx=p1.x+t*dx;
			if(q1->y>fmarco.MY){q1->x=qx; q1->y=fmarco.MY; t1=t;} //Llevar el 8 a MY
			else{q2->x=qx; q2->y=fmarco.MY; t2=t;}
		}
	}elif(q1->y>fmarco.MY || q2->y>fmarco.MY){
		float t, qx;
		if(q1->y>=fmarco.MY && q2->y>=fmarco.MY) return false;	// 8/8
		t=_dy*(fmarco.MY-p1.y);		qx=p1.x+t*dx;					// 8/4, 4/8
		if(q1->y>=fmarco.MY){q1->x=qx; q1->y=fmarco.MY; t1=t;} //Llevar el 8 a MY
		else{q2->x=qx; q2->y=fmarco.MY; t2=t;}
	}
	//else, 4/4. No hay que hacer nada

	if(t1<0) *q1=p1;		elif(t1>1) *q1=p2;
	if(t2<0) *q2=p1;		elif(t2>1) *q2=p2;
	if(bswitch){
		float faux;
		faux=q1->x;	q1->x=q1->y;	q1->y=faux;
		faux=q2->x;	q2->x=q2->y;	q2->y=faux;
	}
	return true;
}

sinline void set_maxmin_forma(const FormaPunto* fpunto, float *dif){
	uint a,b;
	float d;
	float aux;
	a=get_bytes23(&fpunto->dim);
	b=get_bytes01(&fpunto->dim);

	d=fpunto->cx+0.5F;	//coordenada of left edge. d>=0, b-d>=0
	//*dif++=d;
	//*dif++=(float)b-d;
	*dif=d;
	aux=(float)b-d; if(aux>*dif) *dif=aux;

	d=fpunto->cy+0.5F;
	//*dif++=d;
	//*dif=(float)a-d;
	aux=d; if(aux>*dif) *dif=aux;
	aux=(float)b-d; if(aux>*dif) *dif=aux;
}
void dibuja_forma(Lienzo *lienzo, Extremos2D_int *marco, bint subpixel,const FormaPunto* fpunto,float px,float py,color col){
	uint a,b;
	ssint xv,yv;
	if(px<-MAX_LIENZO || px>MAX_LIENZO || py<-MAX_LIENZO || py>MAX_LIENZO) return;

	a=fpunto->dim>>16;
	b=fpunto->dim&0xFFFF;

	if(!subpixel){
		const umint *pb=fpunto->matrix;
		float faux=py-fpunto->cy;
		if(faux<marco->my){
			faux+=a;	if(faux<=marco->my) return;
			yv=a-((ssint)faux-marco->my);
			a-=yv;		pb+=yv*b;
			yv=marco->my;
		}else{
			yv=(ssint)faux;
		}
		if(yv>=marco->MY) return;
		if(yv+a>(uint)marco->MY) a=(uint)marco->MY-yv;

		uint k1=0;
		faux=px-fpunto->cx;
		if(faux<marco->mx){
			faux+=b;	if(faux<=marco->mx) return;
			k1=b-((ssint)faux-marco->mx);
			b-=k1;	pb+=k1;
			xv=marco->mx;
		}else{
			xv=(ssint)(faux);
		}
		if(xv>=marco->MX) return;
		{ssint k2=xv+(ssint)b-marco->MX;
		if(k2>0){k1+=k2; b-=k2;}}

		uint k=lienzo->ncols-b;
		color* ppixel=lienzo->matriz+lienzo->ncols*yv+xv;
		dontimes(a,(ppixel+=k,pb+=k1)){
			dontimes(b,ppixel++){
				if(*pb++) *ppixel=col;
		}}
		return;
	}

	float x,y;
	x=px-fpunto->cx-0.5F;	//coordenadas of corner of top-left pixel
	y=py-fpunto->cy-0.5F;
	xv=(ssint)floorf(x);
	yv=(ssint)floorf(y);
	if(xv>=(ssint)marco->MX || yv>=(ssint)marco->MY) return;
	if(xv+(ssint)b<marco->mx || yv+(ssint)a<marco->my) return;

	a++, b++;
	x-=xv; y-=yv;
	float f00,f01,f10,f11;
	float *matrizf=(float*)malloc(a*b*usizeof(float));
	if(matrizf==NULL) return;
		f01=x*(1-y);
	f10=(1-x)*y;	f11=x*y;
	f00=1-(f10+f11+f01);

	a--, b--;
	{const umint *pb=fpunto->matrix;
	 float *ptr=matrizf;
	 dontimes(a,ptr++){
		*ptr=0;
		dontimes(b,){
			if(*pb++){(*ptr++)+=f00; *ptr=f01;}
			else{ptr++; *ptr=0;}
	 }	}
	 pb=fpunto->matrix;
	 ptr=matrizf+b+1;
	 zeroset_float(matrizf+a*(b+1),b+1);
	 dontimes(a,ptr++){
		dontimes(b,){
			if(*pb++){(*ptr++)+=f10; *ptr+=f11;}
			else ptr++;
	 }	}
	}

	a++; b++;
	float *ptr=matrizf;
	float faux=py-fpunto->cy-0.5F;
	if(faux<marco->my){
		faux+=a;	yv=a-((ssint)faux-marco->my);
		a-=yv;		ptr+=yv*b;
		yv=marco->my;
	}else{
		yv=(ssint)faux;
	}
	if(yv+(ssint)a>marco->MY) a=marco->MY-yv;

	uint k1=0;
	faux=px-fpunto->cx-0.5F;
	if(faux<marco->mx){
		faux+=b;	k1=b-((ssint)faux-marco->mx);
		b-=k1;	ptr+=k1;
		xv=marco->mx;
	}else{
		xv=(ssint)(faux);
	}
	{ssint k2=xv+b-marco->MX;
	if(k2>0){k1+=k2; b-=k2;}}

	uint k=lienzo->ncols-b;
	color* ppixel=lienzo->matriz+lienzo->ncols*yv+xv;
	dontimes(a,(ppixel+=k,ptr+=k1)){
		dontimes(b,(ppixel++,ptr++)){
			if(*ptr==0) continue;
			if(*ptr==1.0F) *ppixel=col;
			else{merge_pixel(ppixel,*ptr,col);}
	}}
	free(matrizf);
}
void dibuja_segmento_pixel(Lienzo *lienzo, Extremos2D_int *marco, Puntoxy_float p1, Puntoxy_float p2, bint afina, color col){
	float dx,dy;

	dx=p2.x-p1.x;
	dy=p2.y-p1.y;
	if(!afina){
		ifdentro(marco,p1.x,p1.y) lienzo->matriz[lienzo->ncols*(uint)floorf(p1.y)+(uint)floorf(p1.x)]=col;
		ifdentro(marco,p2.x,p2.y) lienzo->matriz[lienzo->ncols*(uint)floorf(p2.y)+(uint)floorf(p2.x)]=col;
		if(fabsf(dx)<=1 && fabsf(dy)<=1) return;
	}

	if(!corte_con_marco(marco,p1,p2,&p1,&p2)) return;
	dx=p2.x-p1.x;
	dy=p2.y-p1.y;
	float r;
	if(fabsf(dx)>=fabsf(dy)){
		if(dx<0){
			float faux;
			faux=p1.x; p1.x=p2.x; p2.x=faux;
			faux=p1.y; p1.y=p2.y; p2.y=faux;
		}
		if(dy!=0) r=dx/dy;
		float faux=1.5F*r;
		if(dy==0 || !isfinite(faux) || (r-1.0F==r)){
			uint i=(ssint)floorf(p1.x);
			color *ptr=lienzo->matriz+lienzo->ncols*(uint)floorf(p1.y)+i;
			i=(uint)(ssint)ceilf(p2.x)-i;
			if(floorf(p1.y)==floorf(p2.y)){
				while(i--) *ptr++=col;
			}else{	//ya es mala suerte
				if(p2.y>p1.y){
					r=floorf(p2.y); r=(r-p1.y)/(p2.y-p1.y);
				}else{
					r=floorf(p1.y); r=(p1.y-r)/(p2.y-p1.y);
				}
				uint j=(uint)(r*(float)i);
				while(i>=j){*ptr++=col; i--;}
				if(p2.y>p1.y) ptr+=lienzo->ncols;
				else ptr-=lienzo->ncols;
				while(i--) *ptr++=col;
			}
			return;
		}
	}else{
		if(dy<0){
			float faux;
			faux=p1.x; p1.x=p2.x; p2.x=faux;
			faux=p1.y; p1.y=p2.y; p2.y=faux;
		}
		if(dx!=0) r=dy/dx;
		float faux=1.5F*r;
		if(dx==0 || !isfinite(faux) || (r-1.0F==r)){
			uint i=(ssint)floorf(p1.y);
			color *ptr=lienzo->matriz+(uint)floorf(p1.x)+lienzo->ncols*i;
			i=(uint)(ssint)ceilf(p2.y)-i;
			if(floorf(p1.x)==floorf(p2.x)){
				while(i--){*ptr=col;  ptr+=lienzo->ncols;}
			}else{	//ya es mala suerte
				if(p2.x>p1.x){
					r=floorf(p2.x); r=(r-p1.x)/(p2.x-p1.x);
				}else{
					r=floorf(p1.x); r=(p1.x-r)/(p2.x-p1.x);
				}
				uint j=(uint)(r*(float)i);
				while(i>=j){*ptr=col; ptr+=lienzo->ncols; i--;}
				if(p2.x>p1.x) ptr++;
				else ptr--;
				while(i--){*ptr=col;  ptr+=lienzo->ncols;}
			}
			return;
		}
	}
	//dx y dy ya no se usan más que para esto
	ssint incremento, nsalto;
	if(fabsf(dx)<fabsf(dy)){
		float faux;
		faux=p1.x; p1.x=p1.y; p1.y=faux;
		faux=p2.x; p2.x=p2.y; p2.y=faux;
		incremento=lienzo->ncols;		nsalto=1;
	}else{
		nsalto=lienzo->ncols;	incremento=1;
	}

	float s, y2, smax;	//s es lo que queda desde la parte izqda. del píxel (xn) hasta el final de la línea (y=y2)
	color* ptr;
	float xn;
	float _r=1.0F/r;
	float borde_y;
	xn=floorf(p1.x);
	y2=p1.y-(p1.x-xn)*_r;
	{bint test=0;
	if(r>0) test= floorf(y2)!=floorf(p1.y);
	else test=ceilf(y2)!=ceilf(p1.y);
	if(test){ //cambio de píxel entre el extremo izdo. y p1
		float f;
		if(r>0) f=floorf(p1.y);
		else f=floorf(y2);
		if(r*(f-y2)>0.5F){
			y2+=_r;
			xn+=1;
		}
	}}
	if(r<0) borde_y=ceilf(p1.y)-1;
	else borde_y=floorf(p1.y)+1;
	s=r*(borde_y-y2);	//r*(<1.5) => s es finito y <1.5r.
	if(r>0) borde_y-=1;
	ptr=lienzo->matriz+nsalto*(uint)(ssint)borde_y+incremento*(uint)(ssint)xn;

	xn=ceilf(p2.x);
	y2=p2.y+(xn-p2.x)*_r;
	{bint test=0;
	if(r>0) test= ceilf(y2)!=ceilf(p2.y);
	else test= floorf(y2)!=floorf(p2.y);
	if(test){ //cambio de píxel entre el extremo dcho. y p2
		test=0;
		float f;
		if(r>0) f=floorf(y2);
		else f=floorf(p2.y);
		if(r*(y2-f)>=0.5F) test=1;
	}
	y2=p2.y;
	if(test) y2-=0.7F*_r;	//0.7 un número cualquiera en (0.5,1]
	elif(xn-p2.x<0.1F){
		p2.y-=0.1F*_r;
		y2-=0.1F*_r;	//para evitar problemas de redondeo en la comparación de s>smax
	}}
	if(r<0){
		smax=-r*(y2-floorf(y2));	//lo mismo
		y2=ceilf(p1.y)-1;
		nsalto=-nsalto;
	}else{
		smax=r*(ceilf(y2)-y2);
		y2=floorf(p1.y)+1;
	}
	for(;;){
		float slim;
		bint test;
		if(r<0){test=(y2>p2.y); y2-=1;}
		else{test=(y2<p2.y); y2+=1;}
		if(test) slim=0.5F;
		else slim=smax;
		while(s>=slim){ s-=1;
			*ptr=col;
			ptr+=incremento;
		}
		s=fabsf(r)+s;
		ptr+=nsalto;
		if(!test) break;
	}
}
void dibuja_poligonal_pixel(Lienzo *lienzo, Extremos2D_int *marco, Puntoxy_float* Pcs,uint n, color col, float grosor/*,float estilo*/){
	if(n<2) return;
	durchlaufei(Puntoxy_float,Pcs+1,n-1){
		dibuja_segmento_pixel(lienzo,marco,*(ptri-1),*ptri,true,col);
	}
}
void dibuja_poligonal(Lienzo *lienzo, Extremos2D_int *marco, Puntoxy_float* Pcs,uint n, bint subpixel, color col/*,float grosor,estilo*/){
	if(n<2) return;
	float grosor=1.F;
	float grosor_2=grosor*0.5F;
	if(!subpixel){
		dibuja_poligonal_pixel(lienzo,marco,Pcs,n,col,grosor);
		return;
	}

	Extremos2D_fl fmarco;
	fmarco.mx=(float)marco->mx;
	fmarco.MX=(float)marco->MX;
	fmarco.my=(float)marco->my;
	fmarco.MY=(float)marco->MY;

	Puntoxy_float prev,next,dif;
	next=*Pcs;
	Puntoxy_float *pf=Pcs+1;
	dontimes(n-1,pf++){
		prev=next;
		next=*pf;
		if(!isfinite(prev.x) || !isfinite(prev.y) || !isfinite(next.x) || !isfinite(next.y)) continue;
		dif.x=next.x-prev.x;
		dif.y=next.y-prev.y;
		if(!isfinite(dif.x) || !isfinite(dif.y)) continue;
		if(prev.x==next.x && prev.y==next.y){
			ifdentro(marco,prev.x,prev.y) lienzo->matriz[(uint)prev.y*lienzo->ncols+(uint)prev.x]=col;
			continue;
		}

		float ratio,l,l_2;
		Puntoxy_float P0, P1;
		ssint left,top;
		uint a,b;
		if(fabsf(dif.x)>=fabsf(dif.y)){
			ratio=dif.y/dif.x;
			l_2=sqrtf(1+ratio*ratio)*grosor_2;		l=2*l_2;
			if(prev.x<next.x) P0=prev, P1=next;
			else P0=next, P1=prev;
			if(P1.x+grosor_2<fmarco.mx || P0.x-grosor_2>=fmarco.MX) continue;

			Puntoxy_float q0, q1;
			if(P0.x-grosor_2<fmarco.mx){
				q0.x=fmarco.mx;
				if(fmarco.mx-P0.x < P1.x-fmarco.mx) q0.y=P0.y+(fmarco.mx-P0.x)*ratio;
				else q0.y=P1.y+(fmarco.mx-P1.x)*ratio;
			}else{
				q0.x=P0.x-grosor_2;
				q0.y=P0.y-grosor_2*ratio;
			}
			if(P1.x+grosor_2>=fmarco.MX){
				q1.x=fmarco.MX;
				if(fmarco.MX-P0.x < P1.x-fmarco.MX) q1.y=P0.y+(fmarco.MX-P0.x)*ratio;
				else q1.y=P1.y+(fmarco.MX-P1.x)*ratio;
			}else{
				q1.x=P1.x+grosor_2;
				q1.y=P1.y+grosor_2*ratio;
			}

			if(q0.y<=q1.y) P0=q0, P1=q1;
			else{P0=q1; P1=q0;}
			if(P1.y+l_2<=fmarco.my || P0.y-l_2>=fmarco.MY) continue;
			if(P0.y+l_2<fmarco.my){
				float aux=P0.y;	P0.y=fmarco.my-l_2;
				P0.x+=(P0.y-aux)/ratio;
			}
			if(P1.y-l_2>fmarco.MY){
				float aux=P1.y;	P1.y=fmarco.MY+l_2;
				P1.x+=(P1.y-aux)/ratio;
			}
			if(P0.x<P1.x){left=(ssint)floorf(P0.x);		b=(ssint)ceilf(P1.x)-left;}	//changed floor+1 to ceil. Be strict
						else{left=(ssint)floorf(P1.x);		b=(ssint)ceilf(P0.x)-left;}
			top=(ssint)floorf(P0.y-l_2);		a=(ssint)floorf(P1.y+l_2)-top+1;
		}else{
			ratio=dif.x/dif.y;
			l_2=sqrtf(1+ratio*ratio)*grosor_2;		l=2*l_2;
			if(prev.y<next.y) P0=prev, P1=next;
			else P0=next, P1=prev;
			if(P1.y+grosor_2<fmarco.my || P0.y-grosor_2>=fmarco.MY) continue;
			Puntoxy_float q0, q1;
			if(P0.y-grosor_2<fmarco.my){
				q0.y=fmarco.my;
				if(fmarco.my-P0.y < P1.y-fmarco.my) q0.x=P0.x+(fmarco.my-P0.y)*ratio;
				else q0.x=P1.x+(fmarco.my-P1.y)*ratio;
			}else{
				q0.y=P0.y-grosor_2;
				q0.x=P0.x-grosor_2*ratio;
			}
			if(P1.y+grosor_2>=fmarco.MY){
				q1.y=fmarco.MY;
				if(fmarco.my-P0.y < P1.y-fmarco.MY) q1.x=P0.x+(fmarco.MY-P0.y)*ratio;
				else q1.x=P1.x+(fmarco.MY-P1.y)*ratio;
			}else{
				q1.y=P1.y+grosor_2;
				q1.x=P1.x+grosor_2*ratio;
			}

			if(q0.x<=q1.x) P0=q0, P1=q1;
			else{P0=q1; P1=q0;}
			if(P1.x+l_2<=fmarco.mx || P0.x-l_2>=fmarco.MX) continue;
			if(P0.x+l_2<fmarco.mx){
				float aux=P0.x;	P0.x=fmarco.mx-l_2;
				P0.y+=(P0.x-aux)/ratio;
			}
			if(P1.x-l_2>fmarco.MX){
				float aux=P1.x;	P1.x=fmarco.MX+l_2;
				P1.y+=(P1.x-aux)/ratio;
			}
			if(P0.y<P1.y){top=(ssint)floorf(P0.y);		a=(ssint)ceilf(P1.y)-top;}
						else{top=(ssint)floorf(P1.y);	a=(ssint)ceilf(P0.y)-top;}
			left=(ssint)floorf(P0.x-l_2);		b=(ssint)floorf(P1.x+l_2)-left+1;
		}
		dif.x=P1.x-P0.x;	//avoids ifs (two: one for zero and another for <0)
		dif.y=P1.y-P0.y;

		color* pmatriz=lienzo->matriz;
		uint _cols_=lienzo->ncols;
		if(fabsf(dif.x)>=fabsf(dif.y)){
			if(top<marco->my || top+(ssint)a>marco->MY) pmatriz=NULL;
		}else{
			if(left<marco->mx || left+(ssint)b>marco->MX) pmatriz=NULL;
		}
		if(pmatriz==NULL){
			pmatriz=(color*)malloc(a*b*usizeof(color));
			if(pmatriz==NULL) return;
			_cols_=b;
			if(fabsf(dif.x)>=fabsf(dif.y)){
				color*org=lienzo->matriz+marco->my*lienzo->ncols+left;
				color *ptr=pmatriz;
				uint lineas=a;
				if(top<marco->my){
					ptr+=(marco->my-top)*b;
					lineas-=marco->my-top;
				}
				else org+=(top-marco->my)*lienzo->ncols;
				if(top+a>(uint)marco->MY) lineas-=top+a-marco->MY;
				uint inc=lienzo->ncols-b;
				dontimes(lineas,org+=inc){
					dontimes(b,) *ptr++=*org++;
				}
			}else{
				color*org=lienzo->matriz+top*lienzo->ncols+marco->mx;
				color *ptr=pmatriz;
				uint columnas=b;
				if(left<marco->mx){
					ptr+=(marco->mx-left);
					columnas-=marco->mx-left;
				}
				else org+=(left-marco->mx);
				if(left+b>(uint)marco->MX) columnas-=left+b-marco->MX;
				uint inc=lienzo->ncols-columnas;
				uint inc2=b-columnas;
				dontimes(a,(org+=inc,ptr+=inc2)){
					dontimes(columnas,) *ptr++=*org++;
				}
			}
		}

		float y0,y1,y2,y3;
		color *p0,*p1,*p2,*p3;
		ratio=fabsf(ratio);	//original ratio not needed
		uint b_left;
		if(fabsf(dif.x)>=fabsf(dif.y)){
			float w_0;
			y0=P0.y-l_2;
			if(pmatriz!=lienzo->matriz) y0-=top;
			if(b==1){w_0=fabsf(P1.x-P0.x);}
			else{
				w_0=P0.x-floorf(P0.x);
				if(dif.x>0) w_0=1.F-w_0;
				if(w_0==1) w_0=0;
			}
			y1=y0+w_0*ratio;
			y2=y0+l;
			y3=y1+l;
			{uint t=(uint)y0;	p0=pmatriz+t*_cols_;	y0-=t;
			 t=(uint)y1;	p1=pmatriz+t*_cols_;		y1-=t;
			 t=(uint)y2;	p2=pmatriz+t*_cols_;		y2-=t;
			 t=(uint)y3;	p3=pmatriz+t*_cols_;		y3-=t;}
			{uint k=0;
			 if(pmatriz==lienzo->matriz) k=left;
			 if(P0.x>P1.x) k+=b-1;
			 if(k){p0+=k; p1+=k; p2+=k; p3+=k;}}

			float r_2,_r2;
			r_2=ratio*0.5F;	_r2=0.5F/ratio;
			b_left=b;
			//Always leave p0, p2 pointing to the next pixel and with the adequate values of y0, y2;
			//and p1=p0, p3=p2, y1=y0, y3=y2.
			//The first point, if present, also has p1,p3,y1,y3 right (because they are different than for other points)
			if(w_0!=0){//first point
				b_left--;
				float f0,f1,f2,f3;
				float w_2=w_0*w_0;
				if(p2==p3) f2=r_2*w_2;
				else{f3=y3*y3*_r2; f2=r_2*w_2-f3;}
				if(p1==p2){f2+=(y2-y1)*w_0; f1=0;}
				else{f2+=y2*w_0; f1=(1-y1)*w_0;}
				if(p0==p1) f1+=r_2*w_2;
				else{
					float faux=(1-y0);
					f0=faux*faux*_r2; f1+=r_2*w_2-f0;
					merge_pixel(p0,f0,col);
				}
				if(p1==p2){f2+=f1;}
				else{merge_pixel(p1,f1,col);}
				merge_pixel(p2,f2,col);
				if(p3!=p2)	{merge_pixel(p3,f3,col);}

				if(dif.x>0){p1++;p3++;}
				else{p1--;p3--;}
				p2=p3; p0=p1;
				y2=y3; y0=y1;
			}
			if(b_left){for(;;){
				if(!--b_left) break;
				y3+=ratio; y1+=ratio;
				if(y3>=1.F){y3-=1.F; p3+=_cols_;}
				if(y1>=1.F){y1-=1.F; p1+=_cols_;}

				float f0,f1,f2,f3;
				if(p2==p3) f2=r_2;
				else{f3=y3*y3*_r2; f2=r_2-f3;}
				if(p1==p2){f2+=y2-y1; f1=0;}
				else{f2+=y2; f1=(1-y1);}
				if(p0==p1) f1+=r_2;
				else{
					float faux=(1-y0);
					f0=faux*faux*_r2; f1+=r_2-f0;
					merge_pixel(p0,f0,col);
				}
				if(p1==p2){f2+=f1;}
				else{merge_pixel(p1,f1,col);}
				merge_pixel(p2,f2,col);
				if(p3!=p2)	{merge_pixel(p3,f3,col);}

				if(dif.x>0){p1++;p3++;}
				else{p1--;p3--;}
				p2=p3; p0=p1;
				y2=y3; y0=y1;
			  }
			  b_left=1;
			}
			if(b_left){ //last point
				w_0=P1.x-floorf(P1.x);
				if(dif.x<0) w_0=1.F-w_0;
				if(w_0==0) w_0=1;
				y1+=ratio*w_0;		y3+=ratio*w_0;
				if(y1>=1.F){y1-=1.F; p1+=_cols_;}
				if(y3>=1.F){y3-=1.F; p3+=_cols_;}
				if(pmatriz==lienzo->matriz){if(p3>=pmatriz+(top+a-1)*lienzo->ncols+left+b) p3-=_cols_;}	//if(rounding error)
				else{if(p3>=pmatriz+a*b) p3-=_cols_;}
				float f0,f1,f2,f3;
				float w_2=w_0*w_0;
				if(p2==p3) f2=r_2*w_2;
				else{f3=y3*y3*_r2; f2=r_2*w_2-f3;}
				if(p1==p2){f2+=(y2-y1)*w_0; f1=0;}
				else{f2+=y2*w_0; f1=(1-y1)*w_0;}
				if(p0==p1) f1+=r_2*w_2;
				else{
					float faux=(1-y0);
					f0=faux*faux*_r2; f1+=r_2*w_2-f0;
					merge_pixel(p0,f0,col);
				}
				if(p1==p2){f2+=f1;}
				else{merge_pixel(p1,f1,col);}
				merge_pixel(p2,f2,col);
				if(p3!=p2)	{merge_pixel(p3,f3,col);}
			}
		}else{
			float w_0;
			y0=P0.x-l_2;
			if(pmatriz!=lienzo->matriz) y0-=left;
			if(a==1){w_0=fabsf(P1.y-P0.y);}
			else{
				w_0=P0.y-floorf(P0.y);
				if(dif.y>0) w_0=1.F-w_0;
				if(w_0==1) w_0=0;
			}
			y1=y0+w_0*ratio;
			y2=y0+l;
			y3=y1+l;
			{uint t=(uint)y0;	p0=pmatriz+t;	y0-=t;
			 t=(uint)y1;	p1=pmatriz+t;	y1-=t;
			 t=(uint)y2;	p2=pmatriz+t;	y2-=t;
			 t=(uint)y3;	p3=pmatriz+t;	y3-=t;}
			{uint k=0;
			 if(pmatriz==lienzo->matriz) k=top;
			 if(P0.y>P1.y) k+=a-1;
			 if(k){k*=_cols_;	p0+=k; p1+=k; p2+=k; p3+=k;}}

			float r_2,_r2;
			r_2=ratio*0.5F;	_r2=0.5F/ratio;
			ssint bb=_cols_;	if(dif.y<0) bb=-bb;
			b_left=a;
			if(w_0!=0){//first point
				b_left--;
				float f0,f1,f2,f3;
				float w_2=w_0*w_0;
				if(p2==p3) f2=r_2*w_2;
				else{f3=y3*y3*_r2; f2=r_2*w_2-f3;}
				if(p1==p2){f2+=(y2-y1)*w_0; f1=0;}
				else{f2+=y2*w_0; f1=(1-y1)*w_0;}
				if(p0==p1) f1+=r_2*w_2;
				else{
					float faux=(1-y0);
					f0=faux*faux*_r2; f1+=r_2*w_2-f0;
					merge_pixel(p0,f0,col);
				}
				if(p1==p2){f2+=f1;}
				else{merge_pixel(p1,f1,col);}
				merge_pixel(p2,f2,col);
				if(p3!=p2)	{merge_pixel(p3,f3,col);}

				p0=p1+=bb;
				p2=p3+=bb;
				y2=y3; y0=y1;
			}
			if(b_left){for(;;){
				if(!--b_left) break;
				y3+=ratio; y1+=ratio;
				if(y3>=1.F){y3-=1.F; p3++;}
				if(y1>=1.F){y1-=1.F; p1++;}

				float f0,f1,f2,f3;
				if(p2==p3) f2=r_2;
				else{f3=y3*y3*_r2; f2=r_2-f3;}
				if(p1==p2){f2+=y2-y1; f1=0;}
				else{f2+=y2; f1=(1-y1);}
				if(p0==p1) f1+=r_2;
				else{
					float faux=(1-y0);
					f0=faux*faux*_r2; f1+=r_2-f0;
					merge_pixel(p0,f0,col);
				}
				if(p1==p2){f2+=f1;}
				else{merge_pixel(p1,f1,col);}
				merge_pixel(p2,f2,col);
				if(p3!=p2)	{merge_pixel(p3,f3,col);}

				p0=p1+=bb;
				p2=p3+=bb;
				y2=y3; y0=y1;
			  }
			  b_left=1;
			}
			if(b_left){ //last point
				w_0=P1.y-floorf(P1.y);
				if(dif.y<0) w_0=1-w_0;
				if(w_0==0) w_0=1;
				y1+=ratio*w_0;		y3+=ratio*w_0;
				if(y1>=1.F){y1-=1.F; p1++;}
				if(y3>=1.F){y3-=1.F; p3++;}
				if(pmatriz==lienzo->matriz){if(p3>=pmatriz+(top+a-1)*lienzo->ncols+left+b) p3--;}	//if(rounding error)
				else{if(p3>=pmatriz+a*b) p3--;}
				float f0,f1,f2,f3;
				float w_2=w_0*w_0;
				if(p2==p3) f2=r_2*w_2;
				else{f3=y3*y3*_r2; f2=r_2*w_2-f3;}
				if(p1==p2){f2+=(y2-y1)*w_0; f1=0;}
				else{f2+=y2*w_0; f1=(1-y1)*w_0;}
				if(p0==p1) f1+=r_2*w_2;
				else{
					float faux=(1-y0);
					f0=faux*faux*_r2; f1+=r_2*w_2-f0;
					merge_pixel(p0,f0,col);
				}
				if(p1==p2){f2+=f1;}
				else{merge_pixel(p1,f1,col);}
				merge_pixel(p2,f2,col);
				if(p3!=p2)	{merge_pixel(p3,f3,col);}
			}
		}
		if(pmatriz!=lienzo->matriz){
			if(fabsf(dif.x)>=fabsf(dif.y)){
				color*org=lienzo->matriz+marco->my*lienzo->ncols+left;
				color *ptr=pmatriz;
				uint lineas=a;
				if(top<marco->my){
					ptr+=(marco->my-top)*b;
					lineas-=marco->my-top; top=marco->my;
				}
				else org+=(top-marco->my)*lienzo->ncols;
				if(top+lineas>(uint)marco->MY) lineas=marco->MY-top;
				uint inc=lienzo->ncols-b;
				dontimes(lineas,org+=inc){
					dontimes(b,) *org++=*ptr++;
				}
			}else{
				color*org=lienzo->matriz+top*lienzo->ncols+marco->mx;
				color *ptr=pmatriz;
				uint columnas=b;
				if(left<marco->mx){
					ptr+=marco->mx-left;
					columnas-=marco->mx-left; left=marco->mx;
				}
				else org+=left-marco->mx;
				if(left+columnas>(uint)marco->MX) columnas=marco->MX-left;
				uint inc=lienzo->ncols-columnas;
				uint inc2=b-columnas;
				dontimes(a,(ptr+=inc2,org+=inc)){
					dontimes(columnas,) *org++=*ptr++;
				}
			}
			free(pmatriz);
		}
	}
}
