typedef struct{
 double Tx,Ty,l;
} TransEscala;

typedef struct{
	ssint mx,MX, my,MY;
} Extremos2D_int;

typedef struct{
	ssint x0,y0;
	ssint alto,ancho;
} RectVentana;

//En el sistema vista, teniendo en cuenta las opciones de visualización
//Si max_pixel_width.mx es INF o NAN, indica que los valores no están actualizados.
typedef struct{
	float escala_minmax; //Escala con la que se calcularon los valores minmax actuales
	bint minmax_opt;	//Si los valores que hay almacenados en minmax son los óptimos
	Extremos3D_dbl minmax; //o los que se derivan del elipsoide contenedor
	float max_pixel_width;
	Puntoxy_double texto_pos;
	Extremos2D_fl texto_pixel_widths;
} ElementoenVista;

defineGrowing(ElementoenVista)

//Si los punteros no son NULL hay que liberarlos
typedef struct Gra_InfoVista{
	Growing_ElementoenVista info_elems;
} InfoVista;

//Un color a 0xFFFFFFFF indica que el píxel está sin pintar
typedef uint color;
#define NO_COLOR AT_NODATA
#define colorset_none(x,n) oneset_uint(x,n)
#define colorset_black(x,n) zeroset_uint(x,n)
#define colorset_color(x,col,n) memset_uint(x,col,n)

typedef struct _Lienzo{
	color *matriz;
	uint nrows, ncols;
}Lienzo;
/*Esta estructura se usa para pasar de interno a ventana
El sistema interno no depende de la vista, solamente del sistema de coordenadas (y por ello no se almacena aquí)
El sistema vista es un sistema XYZ local para la vista, paralelo a la ventana. Es independiente del zoom y del desplazamiento.
El sistema ventana son coordenadas píxel con el (0,0) en la esquina del píxel superior izquierdo.
El rectángulo de la ventana está contenido en el rectángulo del lienzo. La cadena de transformaciones es
	interno --> vista --> lienzo
El paso de lienzo a ventana, que es restar, no se efectúa aquí. La librería que pinte se encargará de extraer la ventana
de lienzo y pintarla. Sin embargo ventana --> vista sí se hace, porque al llamar a las funciones se pasan coordenadas
ventana de lo que se quiere hacer. El recuadro de la ventana en esta clase también sirve para calcular minmaxV.
*/
class Gra_Vista{
public:
	struct{		//Interno a vista
		bint identity;	//si está a true no hay que hacer nada
		double M[3][3];	//With respect to canonical internal, i.e., view 0
		double active_depth;	//valor de Z por defecto en el sistema vista
		Extremos3D_dbl ExtremosV;	//Absolutos de esta vista, en el sistema de la vista
	} sis_vista;
	TransEscala sis_lienzo;	//vista a lienzo
	bint square;
	Extremos2D_dbl minmaxV;	//de lo que se ve en cada momento (vista_a_lienzo(minmaxV)=ventana)
	Extremos2D_int ventana;		//ventana con respecto al lienzo
	bint updated;	//values of ventana and minmaxV
	struct Gra_InfoVista graphic_elems;	//Información gráfica almacenada para cada vista.

	Lienzo lienzo;//Matriz de píxeles, system independent. En cada momento se ve una ventana de este lienzo, limitada por ventana.

	 void default_values_identity();
	IMP_EXP_CLASS void default_values_other(double _M[3][3]);
	IMP_EXP_CLASS void recalcula_ExtremosV();
	//Calcula sis_lienzo a partir de los valores de ventana y minmaxV
	//Si se rechaza (valores demasiado grandes o pequeños) se devuelve 1 y sis_lienzo no se cambia
	IMP_EXP_CLASS int calcula_sis_lienzo();
	//Calcula minmaxV a partir de ventana y sis_lienzo. return 1 si se rechaza
	IMP_EXP_CLASS int calcula_minmaxV();

	IMP_EXP_CLASS inline void interno_a_vista(PuntoXYZ_double *P);
	IMP_EXP_CLASS inline void vista_a_interno(PuntoXYZ_double *P);
	IMP_EXP_CLASS inline Puntoxy_float vista_a_lienzo(PuntoXYZ_double P);
	IMP_EXP_CLASS inline Puntoxy_float vista_a_lienzo(PuntoXYZ_double *P);
	IMP_EXP_CLASS inline void vista_a_lienzo_array(PuntoXYZ_double* P,uint n, Puntoxy_float *ppunto);
	IMP_EXP_CLASS inline PuntoXYZ_double lienzo_a_vista(float x, float y);
	IMP_EXP_CLASS inline PuntoXYZ_double lienzo_a_vista(Puntoxy_float p);
	IMP_EXP_CLASS inline Puntoxy_float interno_a_lienzo(PuntoXYZ_double P);
	IMP_EXP_CLASS inline void interno_a_lienzo_array(PuntoXYZ_double* P,uint n, Puntoxy_float *ppunto);
	IMP_EXP_CLASS inline PuntoXYZ_double lienzo_a_interno(float x, float y);
	IMP_EXP_CLASS inline Puntoxy_float ventana_a_lienzo(float x, float y);
	IMP_EXP_CLASS inline PuntoXYZ_double ventana_a_interno(float x, float y);

	//Devuelven 1 si se rechaza.
	IMP_EXP_CLASS inline int desplaza_ventana(ssint dx, ssint dy);
	//dx, dy: variación de la esquina superior izda. DX, DY: variación de la esquina inferior dcha.
	IMP_EXP_CLASS inline int cambia_tamanno_ventana(ssint dx, ssint dy, ssint DX, ssint DY);
	//los valores son en el sistema ventana. Actualiza los límites de vista y calcula la transformación.
	IMP_EXP_CLASS inline int zoom(float x, float y, float X, float Y);
	//mueve todo el lienzo, con lo que también se mueven Tx,Ty y ventana. Se generan huecos que
	//se rellenan con NO_COLOR
	IMP_EXP_CLASS int desplaza_lienzo(ssint offset_x, ssint offset_y);
	IMP_EXP_CLASS inline void  invalida_lienzo();
};

//Funciones para llamar desde código que no es C++
PuntoXYZ_double V_ventana_a_interno(Gra_Vista *vista, float x,float y);
int V_calcula_sis_lienzo(Gra_Vista *vista);
int V_desplaza_ventana(Gra_Vista *vista, ssint dx, ssint dy);
int V_cambia_tamanno_ventana(Gra_Vista *vista, ssint dx, ssint dy, ssint DX, ssint DY);
int V_zoom(Gra_Vista *vista, float x, float y, float X, float Y);
void V_invalida_lienzo(Gra_Vista *vista);
