//Los códigos de cada clase están en Clases_grafico_independiente.h
//Las códigos de cada cualidad están en ClasesGraficocfg.h

#define Qualities_Punto (1<<Q_FormaP) | (1<<Q_ColorP)
#define Qualities_Linea (1<<Q_Color) | (1<<Q_Estilol) | (1<<Q_Grosor)
#define Qualities_Linea2 (1<<Q_Color2) | (1<<Q_Estilol2) | (1<<Q_Grosor2)
#define Qualities_Poligonal /*(1<<Q_Esquinas)*/0 | Qualities_Linea
#ifndef __cplusplus
static const uint QualitiesPerClase[]={
	[CGRA_Punto]=Qualities_Punto,
	[CGRA_Poligonal]=Qualities_Poligonal,
	[CGRA_Poligono]=(1<<Q_Escala) | Qualities_Punto | Qualities_Poligonal, //Polígono
	[CGRA_Vector]=(1<<Q_Escala) | Qualities_Punto | Qualities_Linea, //Vector
	[CGRA_Rayos]=(1<<Q_Escala) | Qualities_Punto | Qualities_Linea | Qualities_Linea2 | (1<<Q_ModoRadios), //Rayos
	[CGRA_Poligonal_escalable]=(1<<Q_Escala) | Qualities_Poligonal | (1<<Q_ModoRadios), //Poligonal escalable
	[CGRA_Elipse]=(1<<Q_Escala) | Qualities_Linea, //Elipse
	[CGRA_Elipsoide]=(1<<Q_Escala) | Qualities_Punto | Qualities_Linea | Qualities_Linea2, //Elipsoide
	[CGRA_Spline]=(1<<Q_Color), //Spline
	[CGRA_Texto2D]=(1<<Q_Color), //Texto2D
	[CGRA_Texto3D]=(1<<Q_Color), //Texto3D
};
#else
static const uint QualitiesPerClase[]={
	Qualities_Punto,
	Qualities_Poligonal,
	(1<<Q_Escala) | Qualities_Punto | Qualities_Poligonal, //Polígono
	(1<<Q_Escala) | Qualities_Punto | Qualities_Linea, //Vector
	(1<<Q_Escala) | Qualities_Punto | Qualities_Linea | Qualities_Linea2, //Rayos
	(1<<Q_Escala) | Qualities_Poligonal, //Poligonal escalable
	(1<<Q_Escala) | Qualities_Linea, //Elipse
	(1<<Q_Escala) | Qualities_Punto | Qualities_Linea | Qualities_Linea2, //Elipsoide
	(1<<Q_Color), //Spline
	(1<<Q_Color), //Texto2D
	(1<<Q_Color), //Texto3D
};
#endif

#define Clase_is_escalable(clase) ((QualitiesPerClase[clase]&(1<<Q_Escala))!=0)
