﻿LinkedSubtipos* match_Lsubtipo(LinkedSubtipos* psubtipo,u16int s){
	if(s>SUBTIPO_MAX) return NULL;
	while(psubtipo!=NULL){
		uint valor=psubtipo->criterio.valor.number;
		switch(psubtipo->criterio.kind){
			case CriterioSub_Numero:	if(s==valor) return psubtipo; break;
			case CriterioSub_Rango:		if(s>=(valor&SUBTIPO_MAX) && s<=((valor>>16)&SUBTIPO_MAX)) return psubtipo; break;
			case CriterioSub_Ormask:	if((s&valor)!=0) return psubtipo; break;
			case CriterioSub_Andmask:	if((s&valor)==valor) return psubtipo; break;
			case CriterioSub_Array:		if( psubtipo->criterio.valor.array[s>>5]&(1<<(s&31)) ) return psubtipo; break;
		}
		psubtipo=psubtipo->next;
	}
	return NULL;
}
sinline LinkedConfigSubtipo* match_LCsubtipo(LinkedConfigSubtipo *psubtipos,u16int subtipo){
	return (LinkedConfigSubtipo*)match_Lsubtipo((LinkedSubtipos*)psubtipos,subtipo);
}
ConfigSubtipo* match_Csubtipo(LinkedConfigSubtipo *psubtipos,u16int subtipo){
	LinkedConfigSubtipo *psubtipo=match_LCsubtipo(psubtipos,subtipo);
	if(psubtipo==NULL) return NULL;
	return &psubtipo->S;
}
sinline LinkedSolvedSubtipo* match_LSsubtipo(LinkedSolvedSubtipo *psubtipos,u16int subtipo){
	return (LinkedSolvedSubtipo*)match_Lsubtipo((LinkedSubtipos*)psubtipos,subtipo);
}
SolvedSubtipo* match_Ssubtipo(LinkedSolvedSubtipo *psubtipos,u16int subtipo){
	LinkedSolvedSubtipo *psubtipo=match_LSsubtipo(psubtipos,subtipo);
	if(psubtipo==NULL) return NULL;
	return &psubtipo->sub;
}

LinkedConfigSubtipo* long_match_Lsubtipo(ConfigTipo* ctipo,u16int subtipo, Hash_hConfigTipo *tipos, uint *tipo_found){
	uint _tipo_found;
	u8int nrecursion;
	LinkedConfigSubtipo* psubtipo;
	LinkedQuality* quality;

	if(tipo_found==NULL) tipo_found=&_tipo_found;
	nrecursion=0;
	*tipo_found=Я;
retry:
	if(ctipo==NULL) return NULL;
	psubtipo=match_LCsubtipo(ctipo->subtipos,subtipo);
	if(psubtipo!=NULL) return psubtipo;
	if(nrecursion==19) return NULL;
	nrecursion++;

	quality=ctipo->cualidades;
	while(quality!=NULL && quality->q.nqual!=Q_All) quality=quality->next;
	if(quality==NULL || quality->q.fromQ!=QFrom_Tipo) return NULL;
	*tipo_found=mask_tipo(quality->q.from.Tipo);
	ctipo=gethdata_hConfigTipo(tipos,*tipo_found);
	goto retry;
}
ConfigSubtipo* long_match_subtipo(ConfigTipo* ctipo,u16int subtipo, Hash_hConfigTipo *tipos, uint *tipo_found){
	LinkedConfigSubtipo *psubtipo=long_match_Lsubtipo(ctipo,subtipo,tipos,tipo_found);
	if(psubtipo==NULL) return NULL;
	return &psubtipo->S;
}

//Devuelve NULL si no hay memoria
SolvedTipo* annade_solved_tipo(Hash_hSolvedTipo *tipos_solved,uint tipo){
	SolvedTipo st, *sctipo;
	setnull_SolvedTipo(&st);
	addh_keydata(hSolvedTipo,tipos_solved,tipo,st,return NULL);
	sctipo=gethdata_hSolvedTipo(tipos_solved,tipo);
	return sctipo;
}
//devuelve .where=0 si no hay memoria
Subtipo_en_SolvedTipo annade_solved_subtipo(SolvedTipo *cstipo, uint Tipo, Hash_hConfigTipo *tipos){
	Subtipo_en_SolvedTipo ssubtipo;
	ConfigTipo *ctipo_org;
	u16int subtipo;
	LinkedConfigSubtipo *psubtipo;
	ssubtipo.where=SSubtipo_NoWhere;
	ctipo_org=gethdata_hConfigTipo(tipos,mask_tipo(Tipo));
	if(cstipo==NULL || ctipo_org==NULL) return ssubtipo;

	subtipo=mask_subtipo(Tipo);
	psubtipo=long_match_Lsubtipo(ctipo_org,subtipo,tipos,NULL);
	if(psubtipo!=NULL){
		ssubtipo.psolved=n_malloc(LinkedSolvedSubtipo,1);
		if(ssubtipo.psolved==NULL) return ssubtipo;
		ssubtipo.where=SSubtipo_AtSolved;
		ssubtipo.psolved->next=cstipo->subtipos;
		cstipo->subtipos=ssubtipo.psolved;
		ssubtipo.psolved->criterio=psubtipo->criterio;
		setnull_SolvedSubtipo(&ssubtipo.psolved->sub);
		return ssubtipo;
	}else{
		ssubtipo.where=SSubtipo_AtOrphan;
		ssubtipo.puint=NULL;
		if(cstipo->orphan_subtipos.ppio==NULL){
			Vsetup(u16int,cstipo->orphan_subtipos,4,return ssubtipo);
		}
		{durchVectori(u16int,cstipo->orphan_subtipos){if(*ptri==subtipo) break;}
		ssubtipo.puint=ptri;
		if((pdif)(ptri-cstipo->orphan_subtipos.ppio)==cstipo->orphan_subtipos.n){
			ssubtipo.puint=NULL;
			Vadd(cstipo->orphan_subtipos,u16int,subtipo,goto salida_outofmem);
			ssubtipo.puint=cstipo->orphan_subtipos.ppio+cstipo->orphan_subtipos.n-1;
		}}
	salida_outofmem:
		return ssubtipo;
	}
}

/*
tipos_depend	Añadirá los tipos de los cuales depende esta cualidad que aún no estén aquí.
pvalue			El valor resuelto. Lo que se devuelve
q					La cualidad a resolver
ntipo				El tipo al cual pertenece la cualidad que se está resolviendo. Es necesario si  indica
					from Subtipo x, porque entonces necesitamos saber en qué tipo estamos.
dotfrom			Para from .
dottextfrom		Para from . text
return:
	0: Todo bien;
	1: Demasiadas iteraciones;
	2: From objective not found;
	3: from.kind desconocido;
	4: From objective incompatible
*/
int resuelve_cualidad(uint* *tipos_depend,ValorQuality* pvalue,Quality* q,uint ntipo, LinkedQuality* dotfrom, LinkedQuality* dottextfrom, Hash_hConfigTipo *tipos){
	u8int nrecursion=0;
	uint nqual;
	LinkedQuality *cualidades;
retry:
	if(q->from.kind==QFrom_None){
		*pvalue=q->value;
		return 0;
	}
	if(nrecursion==19) return 1;
	nrecursion++;

	if(q->fromQ==Q_None) nqual=q->nqual;
	else{
		nqual=q->fromQ;
		if(QualityInfos[nqual].category!=QualityInfos[q->nqual].category) return 4;
	}

	//cualidad not needed anymore. Make it point to the beginning of the list
	//and redirect dot(text)from if needed
	ifunlike(q->from.kind>QFrom_MAX) return 3;
	if(q->from.kind==QFrom_this) cualidades=dotfrom;
	else if(q->from.kind==QFrom_this) cualidades=dottextfrom;
	else{
		uint tipo;
		ConfigTipo *ptipo;
		bint bfromtexto=QFrom_istexto(q->from.kind);

		if(!QFrom_hasTipo(q->from.kind)) tipo=ntipo;
		else tipo=mask_tipo(q->from.Tipo);
		ptipo=gethdata_hConfigTipo(tipos,tipo);
		if(ptipo==NULL) return 2;
		if(!QFrom_hasSubtipo(q->from.kind)){
get_from_tipo:
			if(!bfromtexto) cualidades=ptipo->cualidades;
			else cualidades=ptipo->cualid_texto;
			dotfrom=ptipo->cualidades;
			dottextfrom=ptipo->cualid_texto;
		}else{
			ConfigSubtipo* subtipo=match_Csubtipo(ptipo->subtipos,mask_subtipo(q->from.Tipo));
			if(subtipo==NULL) goto get_from_tipo;
			if(!bfromtexto) cualidades=subtipo->cualidades;
			else cualidades=subtipo->cualid_texto;
			dotfrom=subtipo->cualidades;
			dottextfrom=subtipo->cualid_texto;
		}
		if(tipo!=ntipo){
			if(*tipos_depend==NULL){
				*tipos_depend=n_malloc(uint,4);
				ifunlike(*tipos_depend==NULL) return AT_NOMEM;
				**tipos_depend=tipo;
				*(*tipos_depend+1)=Я;
			}else{
				uint* ptr=*tipos_depend;
				while(*ptr!=Я && *ptr!=tipo) ptr++;
				if(*ptr==Я){
					uint k;
					*ptr++=tipo;
					k=(pdif)(ptr-*tipos_depend);
					if(!(k&3)){ //Cada múltiplo de cuatro reservamos otros 4.
						void* old=*tipos_depend;
						*tipos_depend=(uint*)realloc(*tipos_depend,(k+4)*usizeof(uint));
						ifunlike(*tipos_depend==NULL){
							*tipos_depend=(uint*)old;
							*(ptr-1)=Я;
							return AT_NOMEM;
						}
						ptr=*tipos_depend+k;
					}
					*ptr=Я;
				}
			}
			ntipo=tipo;
		}
	}

	while(1){
		if(cualidades==NULL) return 2;	//not found
		if(cualidades->q.nqual==nqual) break;
		cualidades=cualidades->next;
	}
	q=&cualidades->q;
	goto retry;
}

/*Devuelve 1 si la cláusual from es from . o una combinación de tipo y subtipo equivalente.
	bsubtipo:		Si estamos solamente en mask_tipo(tipo) (false) o en tipo+subtipo (true)
	subtipo:		Los subtipos de este tipo. Se emplea sólo si !bsubtipo Puede ser NULL.
También devueve uno si estamos en un tipo (bsubtipo=false), subtipos!=NULL
y la cláusula from apunta a este tipo y a un subtipo de este tipo que no existe.
*/
bint isfromdot(FromClause fclause,uint Tipo,bint bsubtipo, LinkedConfigSubtipo *subtipos){
	if(fclause.kind==QFrom_None) return 0;
	if(fclause.kind==QFrom_this || fclause.kind==QFrom_this_text) return 1;

	uint tipo;
	if(!QFrom_hasTipo(fclause.kind)) tipo=mask_tipo(Tipo);
	else tipo=mask_tipo(fclause.Tipo);
	if(!bsubtipo){
		if(!QFrom_hasSubtipo(fclause.kind)){
			if(tipo==mask_tipo(Tipo)) return 1;
		}else if(tipo==mask_tipo(Tipo) && subtipos!=NULL){
			if(match_Csubtipo(subtipos,tipo)==NULL) return 1;
		}
		return 0;
	}else{
		if(QFrom_hasSubtipo(fclause.kind)){
			if(tipo==mask_tipo(Tipo) && mask_subtipo(fclause.Tipo)==mask_subtipo(Tipo)) return 1;
		}
		return 0;
	}
}

/*Resuelve la configuración de ctipo_org o de csubtipo_orgy y la copia al final de C.
	Uno de ellos será distinto de NULL y el otro igual a NULL
mask_tipo(Tipo) es el tipo que se está resolviendo, y si csubtipo_org!=NULL
	mask_subtipo(Tipo) es el subtipo.
Usa needs_update en todos los tipos
ctipo_org y csubtipo_org será uno distinto de NULL y el otro igual a NULL
bcopiar: Flags. 1: Copiar cualidades. 2: Copiar cualid_texto
Si bstipo!=0 hereda en C todas las cualidades de tiporesolviendo (normalmente con csubtipo_org!=NULL)
*/
void copia_config(SolvedTipo *tiporesolviendo,bint bstipo,uint Tipo,Hash_hConfigTipo *tipos, SolvedQualities *C,ConfigTipo *ctipo_org,ConfigSubtipo *csubtipo_org, bint iterating, u8int bcopiar){
	LinkedSolvedQuality** pquality;
	LinkedQuality* org_quality;

	if(!(bcopiar&1)) goto copia_texto;
	//from.
	//form . and equivalent no se resuelve ahora, solo se copia, y se deja marcado con ~.
	if(ctipo_org!=NULL) org_quality=ctipo_org->cualidades;
	else org_quality=csubtipo_org->cualidades;
	pquality=&C->cualidades;
	while(*pquality!=NULL) pquality=&(*pquality)->next;
	for(;org_quality!=NULL;org_quality=org_quality->next){
		bint fromdot;
		u8int fkind=org_quality->q.from.kind;
		if(fkind==QFrom_None || org_quality->q.nqual==Q_All) continue;

		{LinkedConfigSubtipo *subs;
		if(ctipo_org==NULL) subs=NULL;
		else subs=ctipo_org->subtipos;
		fromdot=isfromdot(org_quality->q.from,Tipo,csubtipo_org!=NULL,subs);}
		if(!fromdot && QFrom_hasTipo(fkind)){
			uint tipo=mask_tipo(org_quality->q.from.Tipo);
			if(tipo!=mask_tipo(Tipo)){
				if(gethdata_hConfigTipo(tipos,tipo)==NULL) continue;
			}
		}
		{LinkedSolvedQuality* ptr=C->cualidades;
		 while(ptr!=NULL && ptr->nqual!=org_quality->q.nqual) ptr=ptr->next;
		 if(ptr!=NULL) continue;
		}
		*pquality=(LinkedSolvedQuality*)malloc(usizeof(LinkedSolvedQuality));
		if(*pquality==NULL) break;
		(*pquality)->nqual=org_quality->q.nqual;

		int nret=0;
		if(fromdot){
			bint btexto=QFrom_istexto(fkind);
			(*pquality)->nqual=~(org_quality->q.nqual);
			if(org_quality->q.fromQ==Q_None){
				if(!btexto) (*pquality)->value.n=org_quality->q.nqual;
				else (*pquality)->value.n=~(org_quality->q.nqual);	//take from texto
			}else{
				if(!btexto) (*pquality)->value.n=org_quality->q.fromQ;
				else(*pquality)->value.n=~(org_quality->q.fromQ);	//take from texto
			}
		}
		else nret=resuelve_cualidad(&tiporesolviendo->statusQ.tipos_depend,&(*pquality)->value,&org_quality->q,mask_tipo(Tipo),NULL,NULL,tipos);
		ifunlike(nret!=0) free(*pquality);
		else pquality=&(*pquality)->next;
		*pquality=NULL;
	}

	//not_from
	if(ctipo_org!=NULL) org_quality=ctipo_org->cualidades;
	else org_quality=csubtipo_org->cualidades;
	for(;org_quality!=NULL;org_quality=org_quality->next){
		if(org_quality->q.from.kind!=QFrom_None) continue;
		{LinkedSolvedQuality* ptr=C->cualidades;
		 while(ptr!=NULL && ptr->nqual!=org_quality->q.nqual) ptr=ptr->next;
		 if(ptr!=NULL) continue;
		}
		*pquality=(LinkedSolvedQuality*)malloc(usizeof(LinkedSolvedQuality));
		if(*pquality==NULL) break;
		(*pquality)->nqual=org_quality->q.nqual;
		(*pquality)->value=org_quality->q.value;
		pquality=&(*pquality)->next; *pquality=NULL;
	}

	//Cláusula All within Representación
	if(ctipo_org!=NULL) org_quality=ctipo_org->cualidades;
	else org_quality=csubtipo_org->cualidades;
	while(org_quality!=NULL && (org_quality->q.nqual!=Q_All || org_quality->q.fromQ!=fromQAll_OnlyQualities)) org_quality=org_quality->next;
	if(org_quality!=NULL){
		ConfigTipo *ptipo;
		ConfigSubtipo *psubtipo;
		Tipo=org_quality->q.from.Tipo;
		ptipo=gethdata_hConfigTipo(tipos,mask_tipo(Tipo));
		if(ptipo==NULL) goto copia_texto;
		if(!QFrom_hasSubtipo(org_quality->q.from.kind)) psubtipo=NULL;
		else{
			psubtipo=long_match_subtipo(ctipo_org,mask_subtipo(Tipo),tipos,NULL);
			if(psubtipo==NULL) goto copia_texto;
			ptipo=NULL;
		}
		copia_config(tiporesolviendo,false,Tipo,tipos,C,ptipo,psubtipo,1,1);
	}

	//TEXTO
copia_texto:
	if(!(bcopiar&2)) goto fin_All_texto;
	//from
	if(ctipo_org!=NULL) org_quality=ctipo_org->cualid_texto;
	else org_quality=csubtipo_org->cualid_texto;
	pquality=&C->cualid_texto;
	while(*pquality!=NULL) pquality=&(*pquality)->next;
	for(;org_quality!=NULL;org_quality=org_quality->next){
		bint fromdot;
		u8int fkind=org_quality->q.from.kind;
		if(fkind==QFrom_None || org_quality->q.nqual==Q_All) continue;

		{LinkedConfigSubtipo *subs;
		if(ctipo_org==NULL) subs=NULL;
		else subs=ctipo_org->subtipos;
		fromdot=isfromdot(org_quality->q.from,Tipo,csubtipo_org!=NULL,subs);}
		if(!fromdot && QFrom_hasTipo(fkind)){
			uint tipo=mask_tipo(org_quality->q.from.Tipo);
			if(tipo!=mask_tipo(Tipo)){
				if(gethdata_hConfigTipo(tipos,tipo)==NULL) continue;
			}
		}
		{LinkedSolvedQuality* ptr=C->cualid_texto;
		 while(ptr!=NULL && ptr->nqual!=org_quality->q.nqual) ptr=ptr->next;
		 if(ptr!=NULL) continue;
		}
		*pquality=(LinkedSolvedQuality*)malloc(usizeof(LinkedSolvedQuality));
		if(*pquality==NULL) break;
		(*pquality)->nqual=org_quality->q.nqual;

		int nret=0;
		if(fromdot){
			bint btexto=QFrom_istexto(fkind);
			(*pquality)->nqual=~(org_quality->q.nqual);
			if(org_quality->q.fromQ==Q_None){
				if(!btexto) (*pquality)->value.n=org_quality->q.nqual;
				else (*pquality)->value.n=~(org_quality->q.nqual);	//take from texto
			}else{
				if(!btexto) (*pquality)->value.n=org_quality->q.fromQ;
				else(*pquality)->value.n=~(org_quality->q.fromQ);	//take from texto
			}
		}
		else nret=resuelve_cualidad(&tiporesolviendo->statusQ.tipos_depend,&(*pquality)->value,&org_quality->q,Tipo,NULL,NULL,tipos);
		ifunlike(nret!=0) free(*pquality);
		else pquality=&(*pquality)->next;
		*pquality=NULL;
	}

	//not_from
	if(ctipo_org!=NULL) org_quality=ctipo_org->cualid_texto;
	else org_quality=csubtipo_org->cualid_texto;
	for(;org_quality!=NULL;org_quality=org_quality->next){
		if(org_quality->q.from.kind!=QFrom_None) continue;
		{LinkedSolvedQuality* ptr=C->cualid_texto;
		 while(ptr!=NULL && ptr->nqual!=org_quality->q.nqual) ptr=ptr->next;
		 if(ptr!=NULL) continue;
		}
		*pquality=(LinkedSolvedQuality*)malloc(usizeof(LinkedSolvedQuality));
		if(*pquality==NULL) break;
		(*pquality)->nqual=org_quality->q.nqual;
		(*pquality)->value=org_quality->q.value;
		pquality=&(*pquality)->next; *pquality=NULL;
	}

	//Cláusula All within Texto
	if(ctipo_org!=NULL) org_quality=ctipo_org->cualid_texto;
	else org_quality=csubtipo_org->cualid_texto;
	while(org_quality!=NULL && org_quality->q.nqual!=Q_All) org_quality=org_quality->next;
	if(org_quality!=NULL){
		ConfigTipo *ptipo;
		ConfigSubtipo *psubtipo;
		Tipo=org_quality->q.from.Tipo;
		ptipo=gethdata_hConfigTipo(tipos,mask_tipo(Tipo));
		if(ptipo==NULL) goto fin_All_texto;
		if(org_quality->q.from.kind&1) psubtipo=NULL;
		else{
			psubtipo=long_match_subtipo(ptipo,mask_subtipo(Tipo),tipos,NULL);
			if(psubtipo==NULL) goto fin_All_texto;
			ptipo=NULL;
		}
		copia_config(tiporesolviendo,false,Tipo,tipos,C,ptipo,psubtipo,1,2);
	}
 fin_All_texto:

	//Cláusula All Externa
	if(ctipo_org!=NULL) org_quality=ctipo_org->cualidades;
	else org_quality=csubtipo_org->cualidades;
	while(org_quality!=NULL && (org_quality->q.nqual!=Q_All || org_quality->q.fromQ==fromQAll_OnlyQualities)) org_quality=org_quality->next;
	if(org_quality!=NULL){
		ConfigTipo *ptipo;
		ConfigSubtipo *psubtipo;
		Tipo=org_quality->q.from.Tipo;
		ptipo=gethdata_hConfigTipo(tipos,mask_tipo(Tipo));
		if(ptipo==NULL) goto fin_All;
		if(org_quality->q.from.kind&1) psubtipo=NULL;
		else{
			psubtipo=long_match_subtipo(ptipo,mask_subtipo(Tipo),tipos,NULL);
			if(psubtipo==NULL) goto fin_All;
			ptipo=NULL;
		}
		copia_config(tiporesolviendo,false,Tipo,tipos,C,ptipo,psubtipo,1,bcopiar);
	}
fin_All:

	if(iterating) return;

	//resolver from . and equiv, for both text and .
	{bint k;
	do{
		LinkedSolvedQuality *q;
		k=0;
		for(q=C->cualidades;q!=NULL;q=q->next){
			LinkedSolvedQuality *ptr;
			uint nqual;
			if(ispos(q->nqual)) continue;
			if(ispos(q->value.n)){ptr=C->cualidades; nqual=q->value.n;}
			else{ptr=C->cualid_texto; nqual=~(q->value.n);}
			while(ptr!=NULL && ptr->nqual!=nqual) ptr=ptr->next;
			if(ptr!=NULL){
				q->nqual=~(q->nqual);
				q->value=ptr->value;
				k=1;
			}
		}
		for(q=C->cualid_texto;q!=NULL;q=q->next){
			LinkedSolvedQuality *ptr;
			uint nqual;
			if(ispos(q->nqual)) continue;
			if(ispos(q->value.n)){ptr=C->cualidades; nqual=q->value.n;}
			else{ptr=C->cualid_texto; nqual=~(q->value.n);}
			while(ptr!=NULL && ptr->nqual!=nqual) ptr=ptr->next;
			if(ptr!=NULL){
				q->nqual=~(q->nqual);
				q->value=ptr->value;
				k=1;
			}
		}
	}while(k);}

	{LinkedSolvedQuality **q; for(q=&C->cualidades;*q!=NULL;){
		if(isneg((*q)->nqual)){
			LinkedSolvedQuality* next=(*q)->next;
			free(*q); *q=next;
		}else{q=&(*q)->next;}
	}}
	{LinkedSolvedQuality **q; for(q=&C->cualid_texto;*q!=NULL;){
		if(isneg((*q)->nqual)){
			LinkedSolvedQuality* next=(*q)->next;
			free(*q); *q=next;
		}else{q=&(*q)->next;}
	}}

	//heredar del tipo
	if(bstipo){
		LinkedSolvedQuality* ptr;
		for(ptr=tiporesolviendo->Q.cualidades;ptr!=NULL;ptr=ptr->next){
			LinkedSolvedQuality *q;
			for(q=C->cualidades; q!=NULL && q->nqual!=ptr->nqual; q=q->next);
			if(q!=NULL) continue;
			q=(LinkedSolvedQuality*)malloc(usizeof(LinkedSolvedQuality));
			if(q==NULL) break;
			q->nqual=ptr->nqual;
			q->value=ptr->value;
			q->next=C->cualidades;
			C->cualidades=q;
		}
		for(ptr=tiporesolviendo->Q.cualid_texto;ptr!=NULL;ptr=ptr->next){
			LinkedSolvedQuality *q;
			for(q=C->cualid_texto; q!=NULL && q->nqual!=ptr->nqual; q=q->next);
			if(q!=NULL) continue;
			q=(LinkedSolvedQuality*)malloc(usizeof(LinkedSolvedQuality));
			if(q==NULL) break;
			q->nqual=ptr->nqual;
			q->value=ptr->value;
			q->next=C->cualid_texto;
			C->cualid_texto=q;
		}
	}
	if(C->cualidades==NULL) C->cualidades=&No_solved_quality;
	if(C->cualid_texto==NULL) C->cualid_texto=&No_solved_quality;
}

//Resuelve incondicionalmente (ignora needs_update para el tipo en cuestión)
void resuelve_configtipo(SolvedTipo* resuelto,uint tipo,Hash_hConfigTipo *tipos){
	bint upcopia;
	ConfigTipo *tipo_org=gethdata_hConfigTipo(tipos,tipo);
	if(tipo_org==NULL) return;

	resuelto->Q.cualidades=NULL;
	resuelto->Q.cualid_texto=NULL;
	upcopia=resuelto->statusQ.needs_update;
	resuelto->statusQ.needs_update=true;
	copia_config(resuelto,false,MASK_TIPO(tipo),tipos,&resuelto->Q,tipo_org,NULL,false,3);
	resuelto->statusQ.needs_update=upcopia;
}
//Resuelve incondicionalmente, pero si no está no lo añade.
void resuelve_configsubtipo(SolvedTipo* resuelto,uint Tipo,Hash_hConfigTipo *tipos){
	LinkedSolvedSubtipo *csub;
	LinkedConfigSubtipo *psubtipo;
	bint upcopia;
	u16int subtipo=mask_subtipo(Tipo);
	ConfigTipo *tipo_org=gethdata_hConfigTipo(tipos,mask_tipo(Tipo));
	if(tipo_org==NULL) return;

	csub=match_LSsubtipo(resuelto->subtipos,subtipo);
	psubtipo=long_match_Lsubtipo(tipo_org,subtipo,tipos,NULL);
	if(csub==NULL || psubtipo==NULL) return;

	csub->sub.Q.cualidades=NULL;
	csub->sub.Q.cualid_texto=NULL;
	upcopia=resuelto->statusQ.needs_update;
	resuelto->statusQ.needs_update=true;
	copia_config(resuelto,true,Tipo,tipos,&csub->sub.Q,NULL,&psubtipo->S,false,3);
	resuelto->statusQ.needs_update=upcopia;
}

//Computes if needed. Si ya está lo deja como está. (e.d., asume statusQ.needs_update =false).
//Devuelve NULL si no hay memoria
SolvedTipo* compute_resuelta(uint Tipo,bint bstipo,Hash_hSolvedTipo *tipos_solved,Hash_hConfigTipo *tipos){
	SolvedSubtipo* scsubtipo;
	u16int subtipo;
	uint tipo=mask_tipo(Tipo);
	SolvedTipo *sctipo=gethdata_hSolvedTipo(tipos_solved,tipo);
	if(sctipo==NULL) sctipo=annade_solved_tipo(tipos_solved,tipo);
	if(sctipo==NULL) return NULL;
	if(sctipo->Q.cualidades==NULL) resuelve_configtipo(sctipo,tipo,tipos);
	if(!bstipo) return sctipo;

	subtipo=mask_subtipo(Tipo);
	scsubtipo=match_Ssubtipo(sctipo->subtipos,subtipo);
	if(scsubtipo==NULL){
		Subtipo_en_SolvedTipo ssubtipo;
		durchVectori(u16int,sctipo->orphan_subtipos){if(*ptri==subtipo) return sctipo;}
		ssubtipo=annade_solved_subtipo(sctipo,Tipo,tipos);
		if(ssubtipo.where!=SSubtipo_AtSolved) return sctipo;
		scsubtipo=&ssubtipo.psolved->sub;
	}
	if(scsubtipo->Q.cualidades==NULL) resuelve_configsubtipo(sctipo,Tipo,tipos);
	return sctipo;
}

//Devuelve lo que haya. Si subtipo es -1 (o cualquier valor inválido) devuelve la configuración del tipo
SolvedQualities* get_resuelta(u16int subtipo,SolvedTipo *sctipo){
	SolvedSubtipo* scsubtipo;
	if(sctipo==NULL) return NULL;
	if(subtipo>SUBTIPO_MAX) return &sctipo->Q;
	scsubtipo=match_Ssubtipo(sctipo->subtipos,subtipo);
	if(scsubtipo!=NULL) return &scsubtipo->Q;
	return &sctipo->Q;
}

//usa needs_update en todos los tipos
int copia_significados(SolvedTipo* tipores,Hash_hSolvedTipo* tipos_solved,Hash_hConfigTipo *tipos, SolvedSignificados *S,ConfigTipo *ctipo_org,ConfigSubtipo *csubtipo_org){
	LinkedQuality *org_quality;
	uint Tipo,tipo;
	u8int nrecursion=0;
retry:
	if(nrecursion==19){
		S->SignificadoR=S->Significado=cadena_vacia;
		return 1;
	}
	nrecursion++;

	if(ctipo_org!=NULL){
		S->Significado=ctipo_org->Significado.string;	//S=&tipores->S
		S->SignificadoR=ctipo_org->SignificadoR.string;
		org_quality=ctipo_org->cualidades;
	}else{
		S->Significado=csubtipo_org->Significado.string;
		S->SignificadoR=csubtipo_org->SignificadoR.string;
		org_quality=csubtipo_org->cualidades;
	}
	if(S->Significado!=NULL || S->SignificadoR!=NULL){
		if(S->Significado==NULL) S->Significado=cadena_vacia;
		if(S->SignificadoR==NULL) S->SignificadoR=cadena_vacia;
		return 0;
	}

	//Cláusula All Externa
	while(org_quality!=NULL && (org_quality->q.nqual!=Q_All || org_quality->q.fromQ==fromQAll_OnlyQualities)) org_quality=org_quality->next;
	if(org_quality==NULL){
		S->SignificadoR=S->Significado=cadena_vacia;
		return 0;
	}

	Tipo=org_quality->q.from.Tipo;
	if(org_quality->q.from.kind&1){
		if(ctipo_org==NULL) goto fin_All;
		ctipo_org=gethdata_hConfigTipo(tipos,mask_tipo(Tipo));
		if(ctipo_org==NULL) goto fin_All;
		csubtipo_org=NULL;
	}else{
		uint tipo_;
		if(csubtipo_org==NULL) goto fin_All;
		tipo_=mask_tipo(Tipo);
		ctipo_org=gethdata_hConfigTipo(tipos,tipo_);
		csubtipo_org=long_match_subtipo(ctipo_org,mask_subtipo(Tipo),tipos,&tipo_);
		if(csubtipo_org==NULL) goto fin_All;
		ctipo_org=NULL;
		Tipo|=MASK_TIPO(0);
		Tipo|=MASK_TIPO(tipo_);
	}
	tipo=mask_tipo(Tipo);
	if(tipores->statusS.tipos_depend==NULL){
		tipores->statusS.tipos_depend=(uint*)malloc(4*usizeof(uint*));
		ifunlike(tipores->statusS.tipos_depend==NULL) return AT_NOMEM;
		*tipores->statusS.tipos_depend=tipo;
		*(tipores->statusS.tipos_depend+1)=Я;
	}else{
		uint* ptr=tipores->statusS.tipos_depend;
		while(*ptr!=Я && *ptr!=tipo) ptr++;
		if(*ptr==Я){
			uint k;
			*ptr++=tipo;
			k=(pdif)(ptr-tipores->statusS.tipos_depend);
			if(!(k&3)){
				void* old=tipores->statusS.tipos_depend;
				tipores->statusS.tipos_depend=(uint*)realloc(tipores->statusS.tipos_depend,(k+4)*usizeof(uint));
				ifunlike(tipores->statusS.tipos_depend==NULL){
					tipores->statusS.tipos_depend=(uint*)old;
					*(ptr-1)=Я;
					return AT_NOMEM;
				}
				ptr=tipores->statusS.tipos_depend+k;
			}
			*ptr=Я;
		}
	}
	{SolvedTipo *current=gethdata_hSolvedTipo(tipos_solved,tipo);
	if(current==NULL || current->S.Significado==NULL) goto retry;
	S->Significado=current->S.Significado;
	S->SignificadoR=current->S.SignificadoR;}

fin_All:
	return 0;
}

//Resuelve incondicionalmente (ignora needs_update para el tipo en cuestión)
void resuelve_significados_tipo(SolvedTipo *resuelto,uint tipo, Hash_hSolvedTipo* tipos_solved,Hash_hConfigTipo *tipos){
	bint upcopia;
	ConfigTipo *tipo_org=gethdata_hConfigTipo(tipos,tipo);
	if(tipo_org==NULL){
		resuelto->S.SignificadoR=resuelto->S.Significado=cadena_vacia;
		return;
	}

	resuelto->S.Significado=NULL;
	resuelto->S.SignificadoR=NULL;
	upcopia=resuelto->statusS.needs_update;
	resuelto->statusS.needs_update=true;
	copia_significados(resuelto,tipos_solved,tipos,&resuelto->S,tipo_org,NULL);
	resuelto->statusS.needs_update=upcopia;
}
//Resuelve incondicionalmente, pero si no está no lo añade
void resuelve_significados_subtipo(SolvedTipo *resuelto,uint Tipo, Hash_hSolvedTipo* tipos_solved,Hash_hConfigTipo *tipos){
	ConfigTipo *tipo_org;
	u16int subtipo;
	LinkedSolvedSubtipo *csub;
	LinkedConfigSubtipo *psubtipo;
	bint upcopia;

	tipo_org=gethdata_hConfigTipo(tipos,mask_tipo(Tipo));
	if(tipo_org==NULL) return;
	subtipo=mask_subtipo(Tipo);
	csub=match_LSsubtipo(resuelto->subtipos,subtipo);
	psubtipo=long_match_Lsubtipo(tipo_org,subtipo,tipos,NULL);
	if(csub==NULL || psubtipo==NULL) return;

	csub->sub.S.Significado=NULL;
	csub->sub.S.SignificadoR=NULL;
	upcopia=resuelto->statusS.needs_update;
	resuelto->statusS.needs_update=true;
	copia_significados(resuelto,tipos_solved,tipos,&csub->sub.S,NULL,&psubtipo->S);
	resuelto->statusS.needs_update=upcopia;
}

//Computes if needed, otherwise lo deja como está.
//Devuelve NULL si no hay memoria
SolvedTipo* compute_Significados(uint Tipo,bint bstipo,Hash_hSolvedTipo* tipos_solved,Hash_hConfigTipo *tipos){
	uint tipo;
	SolvedTipo *sctipo;
	u16int subtipo;
	SolvedSubtipo *scsubtipo;

	tipo=mask_tipo(Tipo);
	sctipo=gethdata_hSolvedTipo(tipos_solved,tipo);
	if(sctipo==NULL) sctipo=annade_solved_tipo(tipos_solved,tipo);
	if(sctipo==NULL) return NULL;
	if(sctipo->S.Significado==NULL) resuelve_significados_tipo(sctipo,tipo,tipos_solved,tipos);
	if(!bstipo) return sctipo;

	subtipo=mask_subtipo(Tipo);
	scsubtipo=match_Ssubtipo(sctipo->subtipos,mask_subtipo(Tipo));
	if(scsubtipo==NULL){
		Subtipo_en_SolvedTipo ssubtipo;
		durchVectori(u16int,sctipo->orphan_subtipos){if(*ptri==subtipo) return sctipo;}
		ssubtipo=annade_solved_subtipo(sctipo,Tipo,tipos);
		if(ssubtipo.where!=SSubtipo_AtSolved) return sctipo;
		scsubtipo=&ssubtipo.psolved->sub;
	}
	if(scsubtipo->S.Significado==NULL) resuelve_significados_subtipo(sctipo,Tipo,tipos_solved,tipos);
	return sctipo;
}

//Devuelve lo que haya. Si subtipo es -1 (o cualquier valor inválido) devuelve la configuración del tipo
SolvedSignificados* get_solved_significados(u16int subtipo,SolvedTipo *sctipo){
	SolvedSubtipo* scsubtipo;
	if(sctipo==NULL) return NULL;
	if(subtipo>SUBTIPO_MAX) return &sctipo->S;
	scsubtipo=match_Ssubtipo(sctipo->subtipos,subtipo);
	if(scsubtipo!=NULL) return &scsubtipo->S;
	return &sctipo->S;
}

char16_t* make_Significado_string(SolvedSignificados *S){
	uint k;
	char16_t* Sstring;

	if(S->SignificadoR[0]==u'\0') k=strlen16(S->Significado);
	elif(S->Significado[0]==u'\0') k=strlen16(S->SignificadoR);
	else k=strlen16(S->Significado)+strlen16(u". ")+strlen16(S->SignificadoR);
	k++;

	Sstring=n_malloc(char16_t,k);
	if(Sstring==NULL) return NULL;
	if(S->SignificadoR[0]==u'\0') strcpy16(Sstring,S->Significado);
	elif(S->Significado[0]==u'\0') strcpy16(Sstring,S->SignificadoR);
	else strbuild16(Sstring,S->Significado,u". ",S->SignificadoR,NULL);
	return Sstring;
}

//Devuelve AT_NOMEM si no hay memoria
//El array elems se cierra con un elemento con .pos = 0
int solveall_present(const EntradaTablaElems* elems,const uint *bloque_elems, Gra_Configuracion *pconfig){
	while(elems->pos!=0){
		if(elems->pos==Gra_NODATA){elems++; continue;}
		GraElementoGenerico *pelem=(GraElementoGenerico*)(bloque_elems+elems->pos);
		ifunlike(NULL==compute_resuelta(pelem->H.Tipo,true,&pconfig->solved,&pconfig->fconfig->tipos)) return AT_NOMEM;
		ifunlike(NULL==compute_Significados(pelem->H.Tipo,true,&pconfig->solved,&pconfig->fconfig->tipos)) return AT_NOMEM;
		elems++;
	}
	return 0;
}

int reset_Hhuint(Hash_huint *hash,uint *nums){
	durchHashi(huint,*hash){
		removeh_huint(hash,ptri);
	}
	while(*nums!=Я){
		addh_huint(hash,*nums,return AT_NOMEM);
		nums++;
	}
	return 0;
}

int Set_Ver_offs(VerInfo *ver,uint *nums){
	if(ver->ver.ppio==NULL) return 0;
	return reset_Hhuint(&ver->ver,nums);
}
int Set_VerT_ons(VerInfo *ver,uint *nums){
	if(ver->ver.ppio==NULL) return 0;
	return reset_Hhuint(&ver->verT,nums);
}
