﻿#define PPMM (72.0/25.4)	//puntos por mm
typedef struct Gra_Opcionesps Opcionesps;

//Valores para pasar de interno a coordenadas ps
struct Geometria_ps{
	double escala_papel;	//pasa a puntos
	double offset_x, offset_y;
};

struct Opcionesps_interno{
	//s8int dec;	//no hace falta porque siempre se trata de puntos.
	float factor_pixel;
	float grueso_formas; // =size_formas*factor_pixel
};
struct Estado_ps{
	u8int linecap;
	u8int linejoin;
	float mitterlimit;
	float linewidth;
	uint _color;
	float dash[8];	//El primer elemento es el dash_offfset. Un NAN indica el final
	float Tx, Ty;
};

struct Global_ps{
	Geometria_ps geometria;
	LinkedGrupoFormas* formas;
	Opcionesps_interno *O;
	Estado_ps *estadops;
	u16int* formas_definidas;		//Las funciones lo modifican
};

sinline Puntoxy_float interno_a_ps(Geometria_ps *trans, PuntoXYZ_double *P){
	Puntoxy_float Pc={(float)(trans->offset_x+P->X*trans->escala_papel),
							(float)(trans->offset_y+P->Y*trans->escala_papel)};
	return Pc;
}

#define point_order(x,y,order) towrite_float(buf,x); toput_char(buf,' '); towrite_float(buf,y); toput_char(buf,' '); towrite_string(buf,order)
#define pswrite_color(col) \
	{buf->prec.absol=3;\
	towrite_float(buf,(float)((col>>16)&0xFF)/255.0F); toput_char(buf,' ');\
	towrite_float(buf,(float)((col>>8)&0xFF)/255.0F); toput_char(buf,' ');\
	towrite_float(buf,(float)(col&0xFF)/255.0F); towrite_string(buf," setrgbcolor\n");\
	buf->prec.absol=2;}

#define pswrite_Forman(numero) \
	do{bint b=0;\
	towrite_string(buf,"Forma0");\
	if( numero&0100000){b=1; toput_char(buf,'1');}\
	if((numero&0070000) || b){b=1; toput_char(buf,'0'+((numero>>12)&7));}\
	if((numero&0007000) || b){b=1; toput_char(buf,'0'+((numero>>9)&7));}\
	if((numero&0000700) || b){b=1; toput_char(buf,'0'+((numero>>6)&7));}\
	if(b || (numero&0000070)){b=1; toput_char(buf,'0'+((numero>>3)&7));}\
	if(b || (numero &07)){toput_char(buf,'0'+(numero&7));}\
	}while(0)

sinline void ps_checkwrite_col(Bufferto8 *buf, Global_ps *gb,uint col){
	if(col!=gb->estadops->_color){
		pswrite_color(col);
		gb->estadops->_color=col;
	}
}

void ps_checkwrite_col_width(Bufferto8 *buf, Global_ps *gb,uint col, float width){
	if(col!=gb->estadops->_color){
		pswrite_color(col);
		gb->estadops->_color=col;
	}
	if(width!=gb->estadops->linewidth){
		towrite_float(buf,width); towrite_string(buf," setlinewidth\n");
		gb->estadops->linewidth=width;
	}
}

void ps_define_forma(Bufferto8* buf, FormaPunto* pforma){
	toput_char(buf,'/');
	pswrite_Forman(pforma->id);
	toput_char(buf,'{');	toput_char(buf,'\n');
	if(pforma->matrix==NULL){
		towrite_string(buf,"}def\n");
		return;
	}
	buf->prec.absol=1;
	//REVISAR Además de programarlo usar un string object en vez de un array
	towrite_string(buf,"  [-0.5 1.5 1 1  -1.5 0.5 3 1  -0.5 -0.5 1 1] rectfill}def\n");
	buf->prec.absol=2;
}

#define ps_checkdefine_forma(formas_definidas,pforma) \
if(pforma->id!=0200){\
	u16int *ptr=formas_definidas;\
	while(*ptr!=0200 && *ptr!=pforma->id) ptr++;\
	if(*ptr==0200){\
		if(*(ptr+1)==0){\
			u16int *prov=(u16int*)realloc(formas_definidas,ptr-formas_definidas+17);\
			if(prov==NULL) return;\
			ptr=prov+(ptr-formas_definidas);\
			formas_definidas=prov;\
			ptr++; dontimes(16,*ptr++=0200); *ptr=0;\
			ptr-=17;\
		}\
		ps_define_forma(buf,pforma);\
		*ptr++=pforma->id;\
	}\
}

//el sistema de coordenadas ya está en posición
//este código se escribirá tras un gsave.
void ps_escribe_forma(Bufferto8 *buf,Global_ps *gb,FormaPunto *pforma, uint col){
	ps_checkdefine_forma(gb->formas_definidas,pforma);
	if(gb->estadops->_color!=col){pswrite_color(col);}
	towrite_string(buf,"fscale\n");
	pswrite_Forman(pforma->id);
	towrite_string(buf,"\nGR\n");
}
#define ps_escribe_forma_at(gb,pforma,col,x,y) \
	towrite_string(buf,"GS\n");\
	towrite_float(buf,x); toput_char(buf,' ');\
	towrite_float(buf,y); towrite_string(buf," TR\n");\
	ps_escribe_forma(buf,gb,pforma,col)

void ps_escribe_poligonal(Bufferto8 *buf, Puntoxy_float* Pcs,uint n,bint close){
	if(n<2) return;
	towrite_string(buf,"newpath\n");
	towrite_float(buf,Pcs->x); toput_char(buf,' ');
	towrite_float(buf,Pcs->y); towrite_string(buf," moveto\n");
	n--; Pcs++;
	while(n--){
		towrite_float(buf,Pcs->x); toput_char(buf,' ');
		towrite_float(buf,Pcs->y); towrite_string(buf," lineto\n");
		Pcs++;
	}
	if(close) towrite_string(buf,"closepath\n");
	towrite_string(buf,"stroke\n");
}

sinline void ps_escribe_poligonal_I(Bufferto8 *buf, PuntoXYZ_double* PInt,uint n,bint close, Geometria_ps *trans){
	Puntoxy_float* Pcs=(Puntoxy_float*)malloc(n*usizeof(Puntoxy_float));
	if(Pcs==NULL) return;
	durchlaufe2(Puntoxy_float,Pcs,n,PuntoXYZ_double,PInt) *ptr=interno_a_ps(trans,ptr_b);
	ps_escribe_poligonal(buf,Pcs,n,close);
	free(Pcs);
}

/********  Principio de los elementos del dibujo ***********/
#define escribe_ps_ARGS Bufferto8 *buf, Global_ps *gb,GraElementoGenerico *_pelem,ElementoenVista *pvista,SolvedQualities* concreta,bint bver,bint bvert
void escribe_ps_poligono(escribe_ps_ARGS){
	GraPoligono* pelem;
	ConfigPoligono config;
	Puntoxy_float Pc;

	pelem=(GraPoligono*)_pelem;
	GetVars_poligono(_pelem,&config,concreta,grafico.pconfig->pformas);
	Pc=interno_a_ps(&gb->geometria,&pelem->centro);
	if(bver){
		if(config.escala!=0 && pelem->n>=3){
			ps_checkwrite_col_width(buf,gb,config.poligonal.linea._color,config.poligonal.linea.grosor*gb->O->factor_pixel);
			ps_escribe_poligonal_I(buf,&pelem->P1,pelem->n-1,true,&gb->geometria);
		}
		ps_escribe_forma_at(gb,&config.centro.forma,config.centro._color,Pc.x,Pc.y);
	}

	/*if(bvert){
		LinkedSolvedQuality *ptr;
		if(concreta==NULL) ptr=NULL;
		else ptr=concreta->cualid_texto;
		Pc.x-=rect.left;
		Pc.y-=rect.top;
		Pc.y-=1.F;
		previo_nombre(bb);
		dibuja_nombre(hdc,&rect, pmin,pd,Pc,pnombre,ptr,col,0.5,1);
	}*/
}

void escribe_ps_vector(escribe_ps_ARGS){
	GraVector *pelem;
	ConfigVector config;
	Puntoxy_float Pv;

	pelem=(GraVector*)_pelem;
	GetVars_vector(_pelem,&config,concreta,gb->formas);
	if(pelem->H.nombre==Gra_NODATA) bvert=0;
	Pv=interno_a_ps(&gb->geometria,&pelem->P);

	ps_checkwrite_col_width(buf,gb,config.linea._color,config.linea.grosor*gb->O->factor_pixel);
	towrite_string(buf,"GS\n");
	point_order(Pv.x,Pv.y,"TR\n");
	if(bver){
		if(config.escala!=0){
			config.escala*=(float)gb->geometria.escala_papel;
			point_order(pelem->δp.X*config.escala,pelem->δp.Y*config.escala,"sl\n");
		}
		ps_escribe_forma(buf,gb,&config.origen.forma,config.origen._color);
	}
}

void escribe_ps_elipse(escribe_ps_ARGS){
	GraElipse *pelem;
	ConfigElipse config;
	Puntoxy_float Pv;

	pelem=(GraElipse*)_pelem;
	GetVars_elipse(_pelem,&config,concreta,gb->formas);
	if(pelem->H.nombre==Gra_NODATA) bvert=0;
	Pv=interno_a_ps(&gb->geometria,&pelem->P);

	ps_checkwrite_col(buf,gb,config.linea._color);
	towrite_string(buf,"GS\n");
	point_order(Pv.x,Pv.y,"TR\n");
	if(bver && config.escala!=0){
		config.escala*=(float)gb->geometria.escala_papel;
		towrite(buf,'c','[', 'f',pelem->δa.X,' ', 'f',pelem->δa.Y,' ', 'f',pelem->δb.X,' ', 'f',pelem->δb.Y,' ', 's'," 0 0] concat\n",0);
		float det=pelem->δa.X*pelem->δb.Y-pelem->δb.X*pelem->δa.Y;
		if(det==0) det=1;
		towrite_float(buf,config.linea.grosor*gb->O->factor_pixel/sqrtf(det)); towrite_string(buf," setlinewidth\n");
		towrite(buf,'s',"0 0 ", 'f',config.escala, 's'," 0 360 ARCe\n",0);
	}
	towrite_string(buf,"GR\n");
}

void escribe_ps_elipsoide(escribe_ps_ARGS){
	GraElipsoide *pelem;
	ConfigElipsoide config;
	Puntoxy_float Pv;

	pelem=(GraElipsoide*)_pelem;
	GetVars_elipsoide(_pelem,&config,concreta,gb->formas);
	if(pelem->H.nombre==Gra_NODATA) bvert=0;
	Pv=interno_a_ps(&gb->geometria,&pelem->P);

	ps_checkwrite_col(buf,gb,config.linea._color);
	towrite_string(buf,"GS\n");
	point_order(Pv.x,Pv.y,"TR\n");
	if(bver && config.escala!=0){
		float a,b, cosα, sinα;
		varianzas_a_alpha(pelem->σxx,pelem->σxy,pelem->σyy,&a,&b,&cosα,&sinα);
		config.escala*=(float)gb->geometria.escala_papel;
		towrite(buf,'c','[', 'f',a*cosα,' ', 'f',a*sinα,' ', 'f',-b*sinα,' ', 'f',b*cosα,' ', 's'," 0 0] concat\n",0);
		float det=a*b;
		if(det==0) det=1;
		towrite_float(buf,config.linea.grosor*gb->O->factor_pixel/sqrtf(det)); towrite_string(buf," setlinewidth\n");
		towrite(buf,'s',"0 0 ", 'f',config.escala, 's'," 0 360 ARC\n",0);
	}
	towrite_string(buf,"GR\n");
}

#define gb (&globaL)
int gra_a_ps(char16_t* ficherops,bint eps, GraficoCompleto _grafico,Vista *vista, Gra_LinkedOpcionE* OEhead, Opcionesps *opciones_ps, char16_t* mensaje,u8int idioma){
	int nret;
	Bufferto8 feps;
	Global_ps globaL;
	Opcionesps_interno opciones;
	Estado_ps estado_ps;
	if(idioma>2) idioma=0;

	nret=comprueba_y_abre_fichero((Buffer_bo*)&feps,'t',ficherops,_grafico,vista,mensaje,idioma);
	ifunlike(nret) return nret;
	feps.prec.absol=2;

	grafico=_grafico;

	gb->O=&opciones;
	gb->estadops=&estado_ps;
	gb->formas=grafico.pconfig->pformas;
	gb->formas_definidas=(u16int*)malloc(16*usizeof(u16int));
	{durchlaufei(u16int,gb->formas_definidas,15) *ptri=0200; *ptri=0;}	//siempre habrá un 0200, 000 al final

	gb->O->factor_pixel=opciones_ps->grueso_lineas;
	gb->O->grueso_formas=opciones_ps->size_formas;
	{double aux;
	gb->geometria.escala_papel=aux=opciones_ps->escala*1000*PPMM;
	gb->geometria.offset_x=opciones_ps->margen_iz*10*PPMM-aux*vista->minmaxV.mx;
	gb->geometria.offset_y=opciones_ps->margen_ab*10*PPMM-aux*vista->minmaxV.my;}

	if(eps){towrite_string(&feps,"%!PS-Adobe-3.0 EPSF-3.0\n");}
	else{towrite_string(&feps,"%!PS-Adobe-3.0\n");}
	towrite_string(&feps,"%%Creator: Aerotri\n");
	towrite_string(&feps,"%%BoundingBox: 0 0 ");
	{uint k=(uint)(gb->geometria.offset_x+vista->minmaxV.MX*gb->geometria.escala_papel);
	k+=(uint)(opciones_ps->margen_de*10*PPMM)+1;
	towrite_uint(&feps,k);	toput_char(&feps,' ');
	k=(uint)(gb->geometria.offset_y+vista->minmaxV.MY*gb->geometria.escala_papel);
	k+=(uint)(opciones_ps->margen_ar*10*PPMM)+1;
	towrite_uint(&feps,k);	toput_char(&feps,'\n');
	}
	towrite_string(&feps,"%%Pages: 1\n");
	towrite_string(&feps,"%%Page: 1 1\n");
	if(eps){towrite_string(&feps,"gsave\n");}
	towrite_string(&feps,
		"2 setlinecap\n"
		"0 setlinejoin\n"
		"2.0 setmiterlimit\n"
	);
	towrite_float(&feps, gb->O->factor_pixel);	towrite_string(&feps," setlinewidth\n");
	towrite_string(&feps,"0 0 0 setrgbcolor\n");

	gb->estadops->linecap=2;	//extensión cuadrada
	gb->estadops->linejoin=0;	//prolongar hasta cortar
	gb->estadops->mitterlimit=2.0F;	//Trunca a partir de 60º
	gb->estadops->linewidth=opciones_ps->grueso_lineas;
	gb->estadops->_color=0;
	gb->estadops->dash[0]=0;	NOTFINITE_f(gb->estadops->dash[1]);
	gb->estadops->Tx=gb->estadops->Ty=0;

	towrite_string(&feps,"/GS{gsave}bind def\n"
							"/GR{grestore}bind def\n"
							"/TR{translate}bind def\n");
	towrite_string(&feps,"/esc_formas{");
	towrite_float(&feps,gb->O->grueso_formas);
	towrite_string(&feps,"}def\n");
	towrite_string(&feps,"/fscale{esc_formas esc_formas scale}def\n");
	towrite_string(&feps,"/Forma0200{}def\n");
	towrite_string(&feps,"/sl{0 0 moveto lineto stroke}bind def\n");
	towrite_string(&feps,"/ARC{arc stroke}bind def\n");

#undef gb
	void (*escribe_ps)(escribe_ps_ARGS);
#define gb (&globaL)
	EntradaTablaElems* pinfoelem=grafico.fgrafico->tabla_elementos.ppio;
	for(uint n=1;pinfoelem->pos!=0;pinfoelem++,n++){
		GraElementoGenerico *pelem;
		ElementoenVista *pelemv;
		bint bver, bvert;
		Gra_LinkedOpcionE *pOE;

		if(pinfoelem->pos==Gra_NODATA) continue;
		pelem=(GraElementoGenerico*)(grafico.fgrafico->bloque_grafico.pos+pinfoelem->pos);
		if(mask_apagado(pelem->H.Clase)) continue;
		pelemv=vista->graphic_elems.info_elems.ppio+(n-1);

		pOE=OEhead;
		while(pOE!=NULL && pOE->oe.elem!=n) pOE=pOE->next;

		bver=resuelve_ver(pelem,&grafico.pconfig->fconfig->ver_info,pOE,n);
		bvert=resuelve_vert(pelem,&grafico.pconfig->fconfig->ver_info,pOE,n);
		if(!bver && !bvert) continue;
		escribe_ps=NULL;
		switch(mask_clase(pelem->H.Clase)){
			//case CGRA_Punto:		escribe_ps=escribe_ps_punto; break;
			//case CGRA_Poligonal:	escribe_ps=escribe_ps_poligonal; break;
			case CGRA_Poligono:	escribe_ps=escribe_ps_poligono; break;
			case CGRA_Vector:		escribe_ps=escribe_ps_vector; break;
			//case CGRA_Poligonal_escalable: escribe_ps=escribe_ps_poligonal_escalable; break;
			case CGRA_Elipse:		escribe_ps=escribe_ps_elipse; break;
			case CGRA_Elipsoide:	escribe_ps=escribe_ps_elipsoide; break;
		}
		if(escribe_ps==NULL) continue;
		SolvedQualities *resuelta, *concreta;
		get_resuelta_y_concreta(&resuelta,&concreta,pelem,&grafico.pconfig->solved,grafico.pconfig->fconfig,pOE,n);
		escribe_ps(&feps,gb,pelem,pelemv,concreta,bver,bvert);
		libera_resuelta_y_concreta(resuelta,concreta);
	}

//salirprov:
	if(eps){towrite_string(&feps,"grestore\n");}
	toclose(&feps);
	return 0;
}

#undef gb
