﻿typedef struct Gra_Opcionesdxf Opcionesdxf;

struct Global_dxf{
	s8int decX, decY, decZ;
	s8int dec;	//max(decX,decY,decZ)
	uint handle;
	Hash_hUintStr8 layer_names;
	double ptsize;	//in graphic file units
};

#define towrite_dxfuint(buf,code,n) towrite(buf,'s',code"\n",'u',n,'c','\n', 0)
#define towrite_dxfdouble(buf,code,x) towrite(buf, 's',code"\n",'f',(double)(x),'c','\n', 0)
#define towrite_dxfpunto(buf,x,y,z) towrite(buf, 's',"  10\n",'f',(double)(x), 's',"\n  20\n",'f',(double)(y), 's',"\n  30\n",'f',(double)(z), 'c','\n', 0)
#define towrite_dxfpuntootro(buf,x,y,z) towrite(buf, 's',"  11\n",'f',(double)(x), 's',"\n  21\n",'f',(double)(y), 's',"\n  31\n",'f',(double)(z), 'c','\n', 0)

#define towrite_handle(buf) \
	{uint k=(gb->handle<<4)+1;	/*+1 to signal the end*/ \
	while(!(k&0xF0000000)) k<<=4;\
	towrite_string(buf,"  5\n");\
	while(k!=0x10000000){char8_t c=(k&0xF0000000)>>28;\
	if(c<10) c+='0'; else c+='A'-10; toput_char(buf,c); k<<=4;}\
	toput_char(buf,'\n');} gb->handle++

int make_layernames(Hash_hUintStr8 *layernames, GraficoCompleto _grafico){
	HsetupUintStr8(*layernames,8,return AT_NOMEM);
	durchHashi(hSolvedTipo, _grafico.pconfig->solved){
		if(ptri->key==Я) continue;
		char16_t* Sstring=make_Significado_string(&ptri->data.S);
		ifunlike(Sstring==NULL) return AT_NOMEM;
		char8_t *prov=n_malloc(char8_t,strlen16(Sstring)+1);
		ifunlike(prov==NULL){free(Sstring); return AT_NOMEM;}
		chars___chars16(prov,Sstring);
		{char8_t *s; for(s=prov; *s!='\0'; s++){if(*s==' ') *s='_';} *s='\0';}

		addh_keydata(hUintStr8,layernames,ptri->key,prov, free(prov); free(Sstring); return AT_NOMEM);
		free(Sstring);
	}
	return 0;
}

void free_layernames(Hash_hUintStr8 *layernames){
	durchHashi(hUintStr8,*layernames){
		if(ptri->key==Я) continue;
		free(ptri->data);
	}
	free(layernames->ppio);
}

void dxf_cabecera(Bufferto8 *buf, Global_dxf *gb,Extremos2D_dbl mM){
	towrite_string(buf,
"  0\n"	"SECTION\n"
"  2\n"		"HEADER\n"
"  9\n"	"$ACADVER\n"
"  1\n"		"AC1009\n"
"  9\n"	"$DWGCODEPAGE\n"
"  3\n"		"ANSI_1252\n"
"  9\n"	"$HANDSEED\n");
	gb->handle=0x40000;
	towrite_handle(buf);
	gb->handle=0x76;

	buf->prec.absol=gb->dec;
	towrite_string(buf,"  9\n$EXTMIN\n");
	towrite_dxfpunto(buf,mM.mx,mM.my,grafico.fgrafico->minmaxI.mz);
	towrite_string(buf,"  9\n$EXTMAX\n");
	towrite_dxfpunto(buf,mM.MX,mM.MY,grafico.fgrafico->minmaxI.MZ);
	towrite(buf,'s',"  9\n$LIMMIN\n"" 10\n", 'f',mM.mx,
					's',"\n 20\n", 'f',mM.my,
					's',"\n  9\n$LIMMAX\n"" 10\n", 'f',mM.MX,
					's',"\n 20\n", 'f',mM.MY,
					'c','\n',0);
	towrite(buf,'s',"  9\n"	"$PDMODE\n"
					" 70\n"	"2\n"
					"  9\n"	"$PDSIZE\n"
					" 40\n", 'f', gb->ptsize, 'c','\n', 0);

	towrite_string(buf, "  0\n"	"ENDSEC\n");
}
void dxf_write_emptytable(Bufferto8 *buf, const char8_t* tname){
	towrite_many_strings(buf,
	"  0\n"	"TABLE\n"
	"  2\n"		,tname,"\n"
	" 70\n"	"0\n"
	"  0\n"	"ENDTAB\n", NULL);
}
void dxf_tables(Bufferto8 *buf, Global_dxf *gb,Extremos2D_dbl mM){
	towrite_string(buf,
"  0\n"	"SECTION\n"
"  2\n"		"TABLES\n");

	towrite_string(buf,
"  0\n"	"TABLE\n"
"  2\n"		"APPID\n"
" 70\n"	"3\n");	//>= entries that follow
	towrite_string(buf,
	"  0\n"	"APPID\n"
	"  2\n"		"ACAD\n"
	" 70\n"	"0\n"
	"  0\n"	"APPID\n"
	"  2\n"		"ACADANNOTATIVE\n"
	" 70\n"	"0\n"
	"  0\n"	"APPID\n"
	"  2\n"		"ACAD_MLEADERVER\n"
	" 70\n"	"0\n"
	"  0\n"	"ENDTAB\n");

	towrite_string(buf,
"  0\n"	"TABLE\n"
"  2\n"		"LTYPE\n"
" 70\n"	"1\n");	//>= number of entries in table
	//
	towrite_string(buf,
	"  0\n"	"LTYPE\n"
	"  2\n"		"continuous\n"
	"  3\n"		"Unbroken line\n"
	" 70\n"	"0\n"	//flags
	" 72\n"	"65\n"	//alignment type. Documentation states it must be 65
	" 73\n"	"0\n"		//number of line elements
	" 40\n"	"0.0\n");	//Total pattern length
	//
	towrite_string(buf,"  0\n"	"ENDTAB\n");

	towrite_string(buf,
"  0\n"	"TABLE\n"
"  2\n"		"LAYER\n");
	towrite_dxfuint(buf," 70",grafico.pconfig->solved.n+1);	//>= stuff that follows

	bint blayer0=false;
	durchHashi(hSolvedTipo,grafico.pconfig->solved){
		if(ptri->key==Я) continue;

		towrite_string(buf,"  0\n"	"LAYER\n");
		towrite_string(buf,"  2\n");
		char8_t* *pnombre=geth_data(hUintStr8,&gb->layer_names,ptri->key);
		towrite_string(buf,*pnombre); toput_char(buf,'\n');
		if((*pnombre)[0]=='0' && (*pnombre)[1]=='\0') blayer0=true;
		towrite_string(buf," 70\n"	"0\n");		//flags
		towrite_string(buf," 62\n");	//color
		towrite_uint(buf,1+(ptri->key*7&0x1FF)); toput_char(buf,'\n');
		towrite_string(buf,"  6\n"	"continuous\n");	//linetype
		/*towrite_string(buf,
		"370\n"	"    -3\n"	//linewidth. -3=special ACAD value
		"390\n"	"F\n"	//Plot style. Don't know what does 'F' stand for
		//"347\n"	"21\n"
		);*/
	}
	if(!blayer0){
		towrite_string(buf,
			"  0\n"	"LAYER\n"
			"  2\n"		"0\n"		//layer name
			" 70\n"	"0\n"		//flags
			" 62\n"	"1\n"		//color
			"  6\n"	"continuous\n"	//linetype
			//"370\n"	"    -3\n"	//linewidth. -3=special ACAD value
			//"390\n"	"F\n"	//Plot style. Don't know what does 'F' stand for
			//"347\n"	"21\n"
		);
	}
	towrite_string(buf,"  0\n"	"ENDTAB\n");

	dxf_write_emptytable(buf,"VIEW");
	dxf_write_emptytable(buf,"UCS");

	towrite_string(buf,
"  0\n"	"TABLE\n"
"  2\n"		"VPORT\n"
 "70\n"	"1\n");
	towrite_string(buf,
"  0\n"	"VPORT\n"
"  2\n"		"*ACTIVE\n"
" 70\n"	"0\n");
	towrite_string(buf,
" 10\n"	"0.0\n"
" 20\n"	"0.0\n"
" 11\n"		"1.0\n"
" 21\n"	"1.0\n"
" 13\n"	"0.0\n"
" 23\n"	"0.0\n"
" 14\n"	"1.0\n"
" 24\n"	"1.0\n"
" 15\n"	"0.0\n"
" 25\n"	"0.0\n"
" 16\n"	"0.0\n"
" 26\n"	"0.0\n"
" 36\n"	"1.0\n"
" 17\n"	"0.0\n"
" 27\n"	"0.0\n"
" 37\n"	"0.0\n");
	towrite(buf,
		's'," 12\n", 'f',0.5*(mM.mx+mM.MX),
		's',"\n 22\n", 'f',0.5*(mM.my+mM.MY),
		's',"\n 40\n", 'f',(mM.MY-mM.my)*1.1,
	'c','\n', 0);
	towrite_string(buf,
" 41\n"	"1.7\n"	//ancho/alto
" 42\n"	"50.0\n"
" 43\n"	"0.0\n"
" 44\n"	"0.0\n"
" 50\n"	"0.0\n"
" 51\n"	"0.0\n"
" 71\n"	"0\n"
" 72\n"	"100\n"
" 73\n"	"1\n"
" 74\n"	"1\n"
" 75\n"	"0\n"
" 76\n"	"0\n"
" 77\n"	"0\n"
" 78\n"	"0\n");
	towrite_string(buf,"  0\n"	"ENDTAB\n");

	towrite_string(buf,
"  0\n"	"TABLE\n"
"  2\n"		"DIMSTYLE\n"
 "70\n"	"1\n");
	towrite_string(buf,
"  0\n"	"DIMSTYLE\n"
"  2\n"		"Standard\n"
" 70\n"	"0\n");
	towrite_string(buf,
"  3\n"		"\n"
"  4\n"	"\n"
"  5\n"		"\n"
"  6\n"	"\n"
"  7\n"		"\n"
" 40\n"	"1.0\n"
" 41\n"	"0.18\n"
" 42\n"	"0.0625\n"
" 43\n"	"0.38\n"
" 44\n"	"0.18\n"
" 45\n"	"0.0\n"
" 46\n"	"0.0\n"
" 47\n"	"0.0\n"
" 48\n"	"0.0\n"
"140\n"	"0.18\n"
"141\n"	"0.09\n"
"142\n"	"0.0\n"
"143\n"	"25.4\n"
"144\n"	"1.0\n"
"145\n"	"0.0\n"
"146\n"	"1.0\n"
"147\n"	"0.09\n"
" 71\n"	"     0\n"
" 72\n"	"     0\n"
" 73\n"	"     1\n"
" 74\n"	"     1\n"
" 75\n"	"     0\n"
" 76\n"	"     0\n"
" 77\n"	"     0\n"
" 78\n"	"     0\n"
"170\n"	"     0\n"
"171\n"	"     2\n"
"172\n"	"     0\n"
"173\n"	"     0\n"
"174\n"	"     0\n"
"175\n"	"     0\n"
"176\n"	"     0\n"
"177\n"	"     0\n"
"178\n"	"     0\n"
"  0\n"	"ENDTAB\n");

	towrite_string(buf,
"  0\n"	"TABLE\n"
"  2\n"		"STYLE\n"
" 70\n"	"1\n");
	towrite_string(buf,
"  0\n"	"STYLE\n"
"  2\n"		"Standard\n"
" 70\n"	"0\n"
" 40\n"	"0.0\n"
" 41\n"	"1.0\n"
" 50\n"	"0.0\n"
" 71\n"	"0\n"
" 42\n"	"0.2\n"
"  3\n"		"txt\n"
"  4\n"	"\n"
"  0\n"	"ENDTAB\n");

	towrite_string(buf,"  0\n"	"ENDSEC\n");
}
void dxf_blocks(Bufferto8 *buf, Global_dxf *gb){
	towrite_string(buf,
"  0\n"	"SECTION\n"
"  2\n"		"BLOCKS\n");

	towrite_string(buf,
"  0\n"	"BLOCK\n"
"  8\n"	"0\n"
"  2\n"		"$MODEL_SPACE\n"
" 70\n"	"0\n"
" 10\n"	"0.0\n"
" 20\n"	"0.0\n"
" 30\n"	"0.0\n"
"  3\n"		"$MODEL_SPACE\n"
"  1\n"		"\n"
"  0\n"	"ENDBLK\n");
	towrite_handle(buf);
	towrite_string(buf,"  8\n"	"0\n");
	towrite_string(buf,
"  0\n"	"BLOCK\n"
" 67\n"	"1\n"
"  8\n"	"0\n"
"  2\n"		"$PAPER_SPACE\n"
" 70\n"	"0\n"
" 10\n"	"0.0\n"
" 20\n"	"0.0\n"
" 30\n"	"0.0\n"
"  3\n"		"$PAPER_SPACE\n"
"  1\n"		"\n"
"  0\n"	"ENDBLK\n");
	towrite_handle(buf);
	towrite_string(buf,
" 67\n"	"1\n"
"  8\n"	"0\n");

	towrite_string(buf,"  0\n"	"ENDSEC\n");
}

void dxf_nombre(Bufferto8 *buf, Global_dxf *gb, GraElementoGenerico *pelem, char8_t *layername, PuntoXYZ_double *pos){
	if(pelem->H.nombre==NULL) return;
	uint *Texto;
	char8_t* texto;
	Texto=get_texto(grafico.fgrafico,pelem->H.nombre);
	texto=(char8_t*)get_cadenatexto(Texto);
	towrite_string(buf,"  0\n"	"TEXT\n");
	towrite_handle(buf);
	towrite_many_strings(buf,"  8\n",layername,"\n", NULL);
	towrite_dxfpunto(buf,pos->X+gb->ptsize,pos->Y+gb->ptsize,pos->Z+gb->ptsize);
	towrite_dxfdouble(buf,"40",2*gb->ptsize);
	towrite_string(buf,"  1\n");
	while(*texto!='\0'){toput_char(buf,*texto); texto++;} toput_char(buf,'\n');
}

/********  Principio de los elementos del dibujo ***********/
#define escribe_dxf_ARGS Bufferto8 *buf, Global_dxf *gb,GraElementoGenerico *_pelem,SolvedQualities* concreta,bint bver,bint bvert
void escribe_dxf_punto(escribe_dxf_ARGS){
	GraPunto *pelem;
	char8_t* *pnombre;

	pelem=(GraPunto*)_pelem;
	hSolvedTipo *htipo=geth_hSolvedTipo(&grafico.pconfig->solved,mask_tipo(_pelem->H.Tipo));
	pnombre=geth_data(hUintStr8,&gb->layer_names,htipo->key);

	towrite_string(buf,"  0\n"	"POINT\n");
	towrite_handle(buf);
	towrite_many_strings(buf,"  8\n",*pnombre,"\n", NULL);
	towrite_dxfpunto(buf,pelem->P.X,pelem->P.Y,pelem->P.Z);
	dxf_nombre(buf,gb,_pelem,*pnombre,&pelem->P);
}
void escribe_dxf_poligono(escribe_dxf_ARGS){
	GraPoligono *pelem;
	ConfigPoligono config;
	char8_t* *pnombre;

	pelem=(GraPoligono*)_pelem;
	if(pelem->n<3) return; //y aun estos son degenerados

	GetVars_poligono(_pelem,&config,concreta,NULL);
	hSolvedTipo *htipo=geth_hSolvedTipo(&grafico.pconfig->solved,mask_tipo(pelem->H.Tipo));
	
	pnombre=geth_data(hUintStr8,&gb->layer_names,htipo->key);

	towrite_string(buf,"  0\n"	"POINT\n");
	towrite_handle(buf);
	towrite_many_strings(buf,"  8\n",*pnombre,"\n", NULL);
	towrite_dxfpunto(buf,pelem->centro.X,pelem->centro.Y,pelem->centro.Z);

	towrite_string(buf,"  0\n"	"POLYLINE\n");
	towrite_handle(buf);
	towrite_many_strings(buf,"  8\n",*pnombre,"\n", NULL);
	towrite_string(buf,
" 66\n"	"1\n"
" 10\n"	"0.000000\n"
" 20\n"	"0.000000\n"
" 30\n"	"0.000000\n");
	towrite_string(buf," 70\n"	"9\n");	//1:closed + 8:3D polyline

	Durchlaufei(double,&pelem->P1.X,pelem->n-1){
		towrite_many_strings(buf,"  0\n""VERTEX\n""  8\n",*pnombre,"\n", NULL);
		towrite_handle(buf);
		towrite_dxfdouble(buf,"  10",*ptri); ptri++;
		towrite_dxfdouble(buf,"  20",*ptri); ptri++;
		towrite_dxfdouble(buf,"  30",*ptri); ptri++;
		towrite_string(buf," 70\n"	"32\n");	//vertex type
	}
	towrite_many_strings(buf,"  0\n""SEQEND\n""  8\n",*pnombre,"\n", NULL);
	towrite_handle(buf);

	dxf_nombre(buf,gb,_pelem,*pnombre,&pelem->centro);
	return;
}

void escribe_dxf_vector(escribe_dxf_ARGS){
	GraVector *pelem;
	ConfigVector config;
	char8_t* *pnombre;
	PuntoXYZ_double P2;

	pelem=(GraVector*)_pelem;
	GetVars_vector(_pelem,&config,concreta,NULL);
	hSolvedTipo *htipo=geth_hSolvedTipo(&grafico.pconfig->solved,mask_tipo(pelem->H.Tipo));
	
	pnombre=geth_data(hUintStr8,&gb->layer_names,htipo->key);
	P_op(P2,=,pelem->P,+config.escala*,pelem->δp);

	if(config.origen.forma.matrix!=NULL){
		towrite_string(buf,"  0\n"	"POINT\n");
		towrite_handle(buf);
		towrite_many_strings(buf,"  8\n",*pnombre,"\n", NULL);
		towrite_dxfpunto(buf,pelem->P.X,pelem->P.Y,pelem->P.Z);
	}

	towrite_string(buf,"  0\n"	"POLYLINE\n");
	towrite_handle(buf);
	towrite_many_strings(buf,"  8\n",*pnombre,"\n", NULL);
	towrite_string(buf,
" 66\n"	"1\n"
" 10\n"	"0.000000\n"
" 20\n"	"0.000000\n"
" 30\n"	"0.000000\n");
	towrite_string(buf," 70\n"	"8\n");	//8:3D polyline

	towrite_many_strings(buf,"  0\n""VERTEX\n""  8\n",*pnombre,"\n", NULL);
	towrite_handle(buf);
	towrite_dxfpunto(buf,pelem->P.X,pelem->P.Y,pelem->P.Z);
	towrite_string(buf," 70\n"	"32\n");	//vertex type

	towrite_many_strings(buf,"  0\n""VERTEX\n""  8\n",*pnombre,"\n", NULL);
	towrite_handle(buf);
	towrite_dxfpunto(buf,P2.X,P2.Y,P2.Z);
	towrite_string(buf," 70\n"	"32\n");	//vertex type

	towrite_many_strings(buf,"  0\n""SEQEND\n""  8\n",*pnombre,"\n", NULL);
	towrite_handle(buf);

	//dxf_nombre(buf,gb,_pelem,*pnombre,&pelem->P);
	return;
}

void escribe_dxf_elipsoide(escribe_dxf_ARGS){
	GraElipsoide *pelem;
	ConfigElipsoide config;
	char8_t* *pnombre;
	float a,b,sinα,cosα;

	pelem=(GraElipsoide*)_pelem;
	GetVars_elipsoide(_pelem,&config,concreta,NULL);
	hSolvedTipo *htipo=geth_hSolvedTipo(&grafico.pconfig->solved,mask_tipo(pelem->H.Tipo));
	pnombre=geth_data(hUintStr8,&gb->layer_names,htipo->key);
	
	varianzas_a_alpha(pelem->σxx,pelem->σxy,pelem->σyy,&a,&b,&cosα,&sinα);
	iflike(a!=0){
		towrite_string(buf,"  0\n"	"ELLIPSE\n");
		towrite_handle(buf);
		towrite_many_strings(buf,"  8\n",*pnombre,"\n", NULL);
		towrite_dxfpunto(buf,pelem->P.X,pelem->P.Y,pelem->P.Z);
		towrite_dxfpuntootro(buf,a*cosα,a*sinα,0);
		towrite_string(buf,"  210\n0\n" "  220\n0\n" "  230\n1\n"); //Vector perpendicular al plano
		towrite_dxfdouble(buf," 40",b/a);
		towrite_dxfdouble(buf," 41",0);
		towrite_dxfdouble(buf," 42",PI2);
	}
	varianzas_a_alpha(pelem->σyy,pelem->σyz,pelem->σzz,&a,&b,&cosα,&sinα);
	iflike(a!=0){
		towrite_string(buf,"  0\n"	"ELLIPSE\n");
		towrite_handle(buf);
		towrite_many_strings(buf,"  8\n",*pnombre,"\n", NULL);
		towrite_dxfpunto(buf,pelem->P.X,pelem->P.Y,pelem->P.Z);
		towrite_dxfpuntootro(buf,0,a*cosα,a*sinα);
		towrite_string(buf,"  210\n1\n" "  220\n0\n" "  230\n0\n"); //Vector perpendicular al plano
		towrite_dxfdouble(buf," 40",b/a);
		towrite_dxfdouble(buf," 41",0);
		towrite_dxfdouble(buf," 42",PI2);
	}
	varianzas_a_alpha(pelem->σzz,pelem->σxz,pelem->σxx,&a,&b,&cosα,&sinα);
	iflike(a!=0){
		towrite_string(buf,"  0\n"	"ELLIPSE\n");
		towrite_handle(buf);
		towrite_many_strings(buf,"  8\n",*pnombre,"\n", NULL);
		towrite_dxfpunto(buf,pelem->P.X,pelem->P.Y,pelem->P.Z);
		towrite_dxfpuntootro(buf,a*sinα,0,a*cosα);
		towrite_string(buf,"  210\n0\n" "  220\n1\n" "  230\n0\n"); //Vector perpendicular al plano
		towrite_dxfdouble(buf," 40",b/a);
		towrite_dxfdouble(buf," 41",0);
		towrite_dxfdouble(buf," 42",PI2);
	}
}

#define gb (&globaL)
int gra_a_dxf(char16_t* ficherops, GraficoCompleto _grafico, Gra_LinkedOpcionE* OEhead, Opcionesdxf *opciones_dxf, char16_t* mensaje,u8int idioma){
	int nret;
	Bufferto8 feps;
	Global_dxf globaL;
	Extremos2D_dbl mM;
	//Opcionesps_interno opciones;

	if(idioma>2) idioma=0;
	grafico=_grafico;
	nret=comprueba_y_abre_fichero((Buffer_bo*)&feps,'t',ficherops,grafico,NULL,mensaje,idioma);
	ifunlike(nret) return nret;

	ifunlike(AT_NOMEM==solveall_present(grafico.fgrafico->tabla_elementos.ppio,grafico.fgrafico->bloque_grafico.pos,grafico.pconfig)){
		toclose(&feps); return AT_NOMEM;
	}
	ifunlike(AT_NOMEM==make_layernames(&gb->layer_names,grafico)){
		if(gb->layer_names.ppio!=NULL) free_layernames(&gb->layer_names);
		toclose(&feps);
		return AT_NOMEM;
	}

	mM=terreno___interno_rect(&grafico.fgrafico->sis_interno,grafico.fgrafico->minmaxI.mx,grafico.fgrafico->minmaxI.my,grafico.fgrafico->minmaxI.MX,grafico.fgrafico->minmaxI.MY);
	gb->decX=retrive_precisionX(grafico.fgrafico);
	gb->decY=retrive_precisionY(grafico.fgrafico);
	gb->decZ=retrive_precisionZ(grafico.fgrafico);
	if(gb->decX>gb->decY) gb->dec=gb->decX;	else gb->dec=gb->decY;
	if(gb->dec>gb->dec) gb->dec=gb->decZ;
	gb->ptsize=obtiene_altotexto();
	gb->handle=180;

	setbuf_noscientific(&feps);
	setbuf_absolute(&feps);
	setbuf_nolimpio(&feps);

	dxf_cabecera(&feps,gb,mM);
	dxf_tables(&feps,gb,mM);
	dxf_blocks(&feps,gb);

	towrite_string(&feps,
	"  0\n"	"SECTION\n"
	"  2\n"		"ENTITIES\n");

#undef gb
	void (*escribe_dxf)(escribe_dxf_ARGS);
#define gb (&globaL)
	EntradaTablaElems* pinfoelem=grafico.fgrafico->tabla_elementos.ppio;
	for(uint n=1;pinfoelem->pos!=0;pinfoelem++,n++){
		GraElementoGenerico *pelem;
		bint bver, bvert;
		Gra_LinkedOpcionE *pOE;

		if(pinfoelem->pos==Gra_NODATA) continue;
		pelem=(GraElementoGenerico*)(grafico.fgrafico->bloque_grafico.pos+pinfoelem->pos);
		if(mask_apagado(pelem->H.Clase)) continue;

		pOE=OEhead;
		while(pOE!=NULL && pOE->oe.elem!=n) pOE=pOE->next;

		bver=resuelve_ver(pelem,&grafico.pconfig->fconfig->ver_info,pOE,n);
		bvert=resuelve_vert(pelem,&grafico.pconfig->fconfig->ver_info,pOE,n);
		if(!bver && !bvert) continue;
		escribe_dxf=NULL;
		switch(mask_clase(pelem->H.Clase)){
			case CGRA_Punto:		escribe_dxf=escribe_dxf_punto; break;
			//case CGRA_Poligonal:	escribe_dxf=escribe_dxf_poligonal; break;
			case CGRA_Poligono:	escribe_dxf=escribe_dxf_poligono; break;
			case CGRA_Vector:		escribe_dxf=escribe_dxf_vector; break;
			//case CGRA_Poligonal_escalable: escribe_dxf=escribe_dxf_poligonal_escalable; break;
			//case CGRA_Elipse:		escribe_dxf=escribe_dxf_elipse; break;
			case CGRA_Elipsoide:	escribe_dxf=escribe_dxf_elipsoide; break;
		}
		if(escribe_dxf==NULL) continue;
		SolvedQualities *resuelta, *concreta;
		get_resuelta_y_concreta(&resuelta,&concreta,pelem,&grafico.pconfig->solved,grafico.pconfig->fconfig,pOE,n);
		escribe_dxf(&feps,gb,pelem,concreta,bver,bvert);
		libera_resuelta_y_concreta(resuelta,concreta);
	}

	towrite_string(&feps,
	"  0\n"	"ENDSEC\n"
	"  0\n"	"EOF\n");
	toclose(&feps);
	return 0;

/*salida_outofmem:
	towrite_string(&feps,"  0\nEOF\n");
	toclose(&feps);
	free_layernames(&gb->layer_names);
	return AT_NOMEM;*/
}
#undef gb
