﻿//Compile with /J
typedef struct{
	char16_t *fsemilla;
} OpcionesDgn;

#include "dgn_semilla.h"

#define boput_rev(n) boput_1616(fdgn,n&0xFFFF,n>>16)
#define fputceros(n) dontimes(n,) boput_32(fdgn,0)

uint16m ngrupograf=0;

void Elemento9(Buffer_bo *fdgn,bint d3, double xmin,double xmax,double ymin,double ymax,double zmin,double zmax,transf_dgn* dgn,double* ddX=0){
	uint Xlow,Ylow,Xhigh,Yhigh,Zlow,Zhigh;
	uint dX,dY,dZ;
	Vista_dgn vista;
	uint kuor=dgn->kuor;

	Xlow=(uint)double_a_uor_x(xmin,dgn);
	Xhigh=(uint)double_a_uor_x(xmax,dgn);
	Ylow=(uint)double_a_uor_y(ymin,dgn);
	Yhigh=(uint)double_a_uor_y(ymax,dgn);

	dX=(Xhigh-Xlow)/20;
	dY=(Yhigh-Ylow)/20;
	if((uint)(Xhigh+dX)>Xhigh) Xhigh+=dX;	//(uint) needed because of $#%! rules of C automatic promotions
	else	Xhigh=0x7FFFFFFF;
	if((uint)(Xlow-dX)<Xlow) Xlow-=dX;
	else	Xlow=0x80000000;
	if((uint)(Yhigh+dY)>Yhigh) Yhigh+=dY;
	else	Yhigh=0x7FFFFFFF;
	if((uint)(Ylow-dY)<Ylow) Ylow-=dY;
	else	Ylow=0x80000000;
	dX=Xhigh-Xlow;
	dY=Yhigh-Ylow;
	if(d3){
		Zlow=(uint)double_a_uor_z(zmin,dgn);
		Zhigh=(uint)double_a_uor_z(zmax,dgn);
		dZ=(Zhigh-Zlow)/20;
		if((uint)(Zhigh+dZ)>Zhigh) Zhigh+=dZ;
		else	Zhigh=0x7FFFFFFF;
		if((uint)(Zlow-dZ)<Zlow) Zlow-=dZ;
		else	Zlow=0x80000000;
	}
	if((uint)(dY*1.58)>dX){
		dX=(uint)(dY*1.58);
		if((uint)(Xhigh-dX)<Xlow) Xlow=Xlow/2+Xhigh/2-dX/2;
	}else{
		dY=(uint)(dX/1.58);
		if((uint)(Yhigh-dY)<Ylow) Ylow=Ylow/2+Yhigh/2-dY/2;
	}
	dY=(uint)(dX/1.29);
	if(ddX!=NULL) *ddX=(double)dX/dgn->kuor;
	if(d3) dZ=Zhigh-Zlow;

	if(!d3) boput_32(fdgn,0x02fe0908);
	else boput_32(fdgn,0x02fe09c8);

	boput_32(fdgn,0x00000801);
	fputceros(5);
	if(d3) boput_32(fdgn,0x457a0400);
	else boput_32(fdgn,0x457a0020);	//flags
	boput_32(fdgn,0);
	boput_32(fdgn,0);
	boput_32(fdgn,0x000a03e8);
	//aun falta medio uint de flags

	if(!d3) vista.flags=0xb2fc;
	else vista.flags=0xb0fc;
	vista.levels[3]=vista.levels[2]=vista.levels[1]=vista.levels[0]=0xFFFF;

	boput_1616(fdgn,vista.flags,0x0004); //Fin flags
	boput_1616(fdgn,vista.levels[1],vista.levels[0]);
	boput_1616(fdgn,vista.levels[3],vista.levels[2]);

	vista.Xlow=long_a_middle2(Xlow);
	vista.Ylow=long_a_middle2(Ylow);
	vista.Xwidth=long_a_middle2(dX);
	vista.Ywidth=long_a_middle2(dY);
	if(d3){
	  vista.Zlow=long_a_middle2(Zlow);
	  vista.Zwidth=long_a_middle2(dZ);
	}else{
	  vista.Zlow=0;
	  vista.Zwidth=0;
	}
	boput_32(fdgn,vista.Xlow);	boput_32(fdgn,vista.Ylow);	boput_32(fdgn,vista.Zlow);
	boput_32(fdgn,vista.Xwidth);	boput_32(fdgn,vista.Ywidth);	boput_32(fdgn,vista.Zwidth);

	zeroset_uint((uint*)vista.matriz,18);
	if(!d3){
		vista.matriz[3]=vista.matriz[0]=double_a_vax2(1.0);
	}else{
		vista.matriz[4]=vista.matriz[0]=double_a_vax2(1.0);
		vista.matriz[8]=double_a_vax2(1.0);
	}
	/*if(!d3)*/ vista.penultima=double_a_vax2(639.5/dX);	//Lo que ocupa cada píxel
	//else vista.penultima=double_a_vax(310/dX);
	if(!d3) vista.ultima=0;
	else vista.ultima=0;	//Altura actual medida desde el fondo de la vista

	{durchlaufei(Vax_dfloat2,vista.matriz,9){
		boput_1616(fdgn,ptri->m4.m1, ptri->m4.m0);
		boput_1616(fdgn,ptri->m4.m3, ptri->m4.m2);
	}}
	boput_1616(fdgn,vista.penultima.m4.m1,vista.penultima.m4.m0);
	boput_1616(fdgn,vista.penultima.m4.m3,vista.penultima.m4.m2);
	boput_32(fdgn,vista.ultima);

	if(!d3) vista.flags=0xb27c;
	else vista.flags=0xb07c;
	vista.Xlow=0xe703FFFF;
	vista.Ylow=0xdccfFFFF;
	vista.Zlow=0x00018000;
	vista.Xwidth=0xdce90002;
	vista.Ywidth=0x37fb0002;
	vista.Zwidth=0x04100000;
	vista.penultima.m4.m0=0x3c5f;
	vista.penultima.m4.m1=0x862e;
	vista.penultima.m4.m2=0x6287;
	vista.penultima.m4.m3=0xb8f0;
	dontimes(3,){
		boput_1616(fdgn,vista.levels[0],vista.flags);
		boput_1616(fdgn,vista.levels[2],vista.levels[1]);
		boput_1616(fdgn,bytes01(vista.Xlow),vista.levels[3]);
		boput_1616(fdgn,bytes01(vista.Ylow),bytes23(vista.Xlow));
		boput_1616(fdgn,bytes01(vista.Zlow),bytes23(vista.Ylow));
		boput_1616(fdgn,bytes01(vista.Xwidth),bytes23(vista.Zlow));
		boput_1616(fdgn,bytes01(vista.Ywidth),bytes23(vista.Xwidth));
		boput_1616(fdgn,bytes01(vista.Zwidth),bytes23(vista.Ywidth));
		{Vax_dfloat2 *pvax=vista.matriz;
		boput_1616(fdgn,pvax->m4.m0,bytes23(vista.Zwidth));
		dontimes(8,){
			boput_1616(fdgn,pvax->m4.m2, pvax->m4.m1);
			boput_1616(fdgn,(pvax+1)->m4.m0, pvax->m4.m3);
			pvax++;
		}
		boput_1616(fdgn,pvax->m4.m2, pvax->m4.m1);
		boput_1616(fdgn,vista.penultima.m4.m0, pvax->m4.m3);
		}
		boput_1616(fdgn,vista.penultima.m4.m2,vista.penultima.m4.m1);
		boput_1616(fdgn,bytes01(vista.ultima),vista.penultima.m4.m3);

		boput_1616(fdgn,vista.flags,bytes23(vista.ultima));

		boput_1616(fdgn,vista.levels[1],vista.levels[0]);
		boput_1616(fdgn,vista.levels[3],vista.levels[2]);
		boput_32(fdgn,vista.Xlow);	boput_32(fdgn,vista.Ylow);	boput_32(fdgn,vista.Zlow);
		boput_32(fdgn,vista.Xwidth);	boput_32(fdgn,vista.Ywidth);	boput_32(fdgn,vista.Zwidth);
		{durchlaufei(Vax_dfloat2,vista.matriz,9){
			boput_1616(fdgn,ptri->m4.m1, ptri->m4.m0);
			boput_1616(fdgn,ptri->m4.m3, ptri->m4.m2);
		}}
		boput_1616(fdgn,vista.penultima.m4.m1,vista.penultima.m4.m0);
		boput_1616(fdgn,vista.penultima.m4.m3,vista.penultima.m4.m2);
		boput_32(fdgn,vista.ultima);
	}
	boput_1616(fdgn,vista.levels[0],vista.flags);
	boput_1616(fdgn,vista.levels[2],vista.levels[1]);
	boput_1616(fdgn,bytes01(vista.Xlow),vista.levels[3]);
	boput_1616(fdgn,bytes01(vista.Ylow),bytes23(vista.Xlow));
	boput_1616(fdgn,bytes01(vista.Zlow),bytes23(vista.Ylow));
	boput_1616(fdgn,bytes01(vista.Xwidth),bytes23(vista.Zlow));
	boput_1616(fdgn,bytes01(vista.Ywidth),bytes23(vista.Xwidth));
	boput_1616(fdgn,bytes01(vista.Zwidth),bytes23(vista.Ywidth));
	{Vax_dfloat2 *pvax=vista.matriz;
	boput_1616(fdgn,pvax->m4.m0,bytes23(vista.Zwidth));
	dontimes(8,){
		boput_1616(fdgn,pvax->m4.m2, pvax->m4.m1);
		boput_1616(fdgn,(pvax+1)->m4.m0, pvax->m4.m3);
		pvax++;
	}
	boput_1616(fdgn,pvax->m4.m2, pvax->m4.m1);
	boput_1616(fdgn,vista.penultima.m4.m0, pvax->m4.m3);
	}
	boput_1616(fdgn,vista.penultima.m4.m2,vista.penultima.m4.m1);
	boput_1616(fdgn,bytes01(vista.ultima),vista.penultima.m4.m3);

	vista.flags=0xb1f9;
	boput_1616(fdgn,vista.flags,bytes23(vista.ultima));

	vista.levels[0]=1;
	vista.levels[2]=vista.levels[1]=0;
	vista.levels[3]=0x8000;
	vista.Ylow=vista.Xlow=0x00008000;
	vista.Zlow=0x00000000;
	vista.Ywidth=vista.Xwidth=0xffff7fff;
	vista.Zwidth=0xffffffff;
	vista.matriz[8]=vista.matriz[4]=double_a_vax2(1.0);
	*(uint*)&vista.penultima=0;

	boput_1616(fdgn,vista.levels[1],vista.levels[0]);
	boput_1616(fdgn,vista.levels[3],vista.levels[2]);
	boput_32(fdgn,vista.Xlow);	boput_32(fdgn,vista.Ylow);	boput_32(fdgn,vista.Zlow);
	boput_32(fdgn,vista.Xwidth);	boput_32(fdgn,vista.Ywidth);	boput_32(fdgn,vista.Zwidth);
	{Vax_dfloat2 *pvax=vista.matriz;
	dontimes(9,){
		boput_1616(fdgn,pvax->m4.m1, pvax->m4.m0);
		boput_1616(fdgn,(pvax+1)->m4.m3, pvax->m4.m2);
		pvax++;
	}}
	boput_32(fdgn,0); boput_32(fdgn,0);	//penultima
	boput_32(fdgn,vista.ultima);

	uint mu_en_disenno=0xFFFFFFFFUL/kuor;
	uint su_por_mu;
	uint uor_por_su;

	su_por_mu=kuor;
	uor_por_su=1;

	boput_rev(mu_en_disenno);
	boput_rev(su_por_mu);
	boput_rev(uor_por_su);

	boput_8888(fdgn,'u','s','u','m');

	boput_32(fdgn,0); boput_32(fdgn,0); //desconocido
	dontimes(5,){
		boput_32(fdgn,0x00004080);
		boput_32(fdgn,0);
	}
	if(!d3){
		boput_32(fdgn,0x27100000);
		boput_32(fdgn,0x27100000);
	}else{
		boput_32(fdgn,0x04e20000);
		boput_32(fdgn,0x04e20000);
	}
	boput_32(fdgn,0x13880000);
	boput_32(fdgn,0x000307ff);
	if(!d3) boput_32(fdgn,0x00070001);
	else boput_32(fdgn,0x00070003);
	boput_32(fdgn,0); boput_32(fdgn,0);
	boput_32(fdgn,0x88880000);
	if(!d3)	boput_32(fdgn,0x0001d800);	//Nivel actvo=1, fin desconocido
	else	boput_32(fdgn,0x0001d000);
	boput_32(fdgn,0x00003900); //Color=0,?
	if(!d3) boput_32(fdgn,0x00100000);	//?,grosor=0
	else	boput_32(fdgn,0x04500000);	//?

	Xlow=(uint)double_a_uor_x(xmin,dgn);					//Valores mínimo y máximo
	Xhigh=(uint)double_a_uor_x(xmax,dgn);
	Ylow=(uint)double_a_uor_y(ymin,dgn);
	Yhigh=(uint)double_a_uor_y(ymax,dgn);
	if(d3){
		Zlow=(uint)double_a_uor_z(zmin,dgn);
		Zhigh=(uint)double_a_uor_z(zmax,dgn);
	}else{
		Zlow= 0x80000000;
		Zhigh=0x7FFFffff;
	}
	boput_rev(Xlow);	boput_rev(Ylow);	boput_rev(Zlow);
	boput_rev(Xhigh);	boput_rev(Yhigh);	boput_rev(Zhigh);

	Vax_dfloat4 vaux[3];
	vaux[0]=double_a_vax4(-dgn->origenXuor);			//Origen global
	vaux[1]=double_a_vax4(-dgn->origenYuor);
	vaux[2]=double_a_vax4(-dgn->origenZuor);
	bowrite_uints(fdgn,(uint*)vaux,6);

	boput_32(fdgn,0); boput_32(fdgn,0);	//Desconocido
	boput_32(fdgn,0x6d570101);		//..Wm
	boput_32(fdgn,0x00000000);
	boput_32(fdgn,0x00010000); //Estos dos valores varían
	boput_32(fdgn,0);	//A veces este vale 1, o 2
	boput_32(fdgn,0);
	boput_32(fdgn,0);
	boput_32(fdgn,0);
	if(!d3) boput_32(fdgn,0x00010000);
	else boput_32(fdgn,0x00000000);
	boput_32(fdgn,0x7a0b0000);
	boput_32(fdgn,0x58385140);
	boput_32(fdgn,0x1b9e0d40);
	boput_32(fdgn,0x00000002);
	if(!d3) boput_32(fdgn,0x00000000);
	else boput_32(fdgn,0x00000f0f);
	fputceros(8);
	boput_32(fdgn,0x80800000);
	boput_32(fdgn,0x00007ac6);
	fputceros(0x12);
	boput_32(fdgn,0x00050000);
	boput_32(fdgn,0x00660066);
	boput_32(fdgn,0x00660066);
	fputceros(0x15);
	if(!d3) boput_32(fdgn,0x00000004);
	else boput_32(fdgn,0x00000046);	//Fin desconocido
}

void Elemento8(Buffer_bo *fdgn,bint d3){
	if(!d3) boput_32(fdgn,0x00b00800);
	else boput_32(fdgn,0x00b00801);
	fputceros(6);
	if(!d3){
		boput_32(fdgn,0x00010000);
		boput_32(fdgn,0x00010000);
		boput_32(fdgn,0);	boput_32(fdgn,0);
		boput_32(fdgn,0x00008000);
		boput_32(fdgn,0x00008000);
		boput_32(fdgn,0x00008000);
		fputceros(6);
		boput_32(fdgn,2);
		boput_32(fdgn,0);	boput_32(fdgn,0);
		boput_32(fdgn,0x7fffea60);
		boput_32(fdgn,0x0000ffff);
		fputceros(29);
		boput_32(fdgn,0x00020000);
		boput_32(fdgn,0);	boput_32(fdgn,0);
		boput_32(fdgn,0xea600000);
		boput_32(fdgn,0xffff7fff);
	}else{
		boput_32(fdgn,0x0e030003);
		boput_32(fdgn,0x00010000);
		fputceros(5);
		boput_32(fdgn,0x00004220);
		fputceros(5);
		boput_32(fdgn,0x00004220);
		fputceros(0x21);
		boput_32(fdgn,0x00020000);
		boput_32(fdgn,0);	boput_32(fdgn,0);
		boput_32(fdgn,0x0000ea60);
		boput_32(fdgn,0x7fffffff);
	}
	fputceros(30);
}

void Elemento10(Buffer_bo *fdgn){
	boput_32(fdgn,0x004c0a00);
	fputceros(0x26);
}

void Elemento9bis(Buffer_bo *fdgn,bint d3){
	boput_32(fdgn,0x02fe0901);
	fputceros(6);
	boput_32(fdgn,0x00000001);
	boput_32(fdgn,0);	boput_32(fdgn,0);
	boput_32(fdgn,0x40800000);
	if(!d3){
		fputceros(5);		boput_32(fdgn,0x40800000);
		fputceros(16);	boput_32(fdgn,0x00004080);
		fputceros(0x15e);
	}else{
		fputceros(7);	boput_32(fdgn,0x40800000);
		fputceros(7);	boput_32(fdgn,0x40800000);
		fputceros(0x165);
	}
}

void Elemento5_2(Buffer_bo *fdgn,bint d3){
	boput_32(fdgn,0x00700502);
	boput_32(fdgn,0);		boput_32(fdgn,0);
	boput_32(fdgn,0); 		boput_32(fdgn,Я);
	boput_32(fdgn,Я);		boput_32(fdgn,Я);
	boput_32(fdgn,0x00620000);
	boput_32(fdgn,0);
	bowrite_chars(fdgn,"HPT_DD_IGDS:FONTLIB\x2e",20);
	boput_32(fdgn,0x00000020);
	fputceros(10);
	if(!d3) boput_32(fdgn,0x7f7f7f7f);	else boput_32(fdgn,0x7f7f17f);
	dontimes(30,) boput_32(fdgn,0x7f7f7f7f);
	if(!d3) boput_32(fdgn,0x7f7e7f7f);	else boput_32(fdgn,0x7f7f7f7f);
}

void Elemento42_17(Buffer_bo *fdgn){
	boput_32(fdgn,0x02f64217);
	fputceros(8);
	boput_32(fdgn,Я);	boput_32(fdgn,Я);	boput_32(fdgn,Я);
	boput_32(fdgn,0x02e80001);
	boput_32(fdgn,0x00000300);
	boput_32(fdgn,0x00150000);
	boput_32(fdgn,0xFFFFfffb);
	bowrite_chars(fdgn,"{ Cable / Tele }",16);
	fputceros(0x0168);
}

#define fputheader	{uint *ptr=(uint*)pehdr; dontimes(7,ptr++) boput_32(fdgn,*ptr);}\
						boput_32(fdgn,pdhdr->prologo); boput_32(fdgn,pdhdr->props.n)

void Elemento5(Buffer_bo *fdgn,bint d3,Elm_hdr* pehdr,Disp_hdr* pdhdr){
	//The unamed field must be placed in the highest bit.
	struct{ unsigned R: 8;
			unsigned G: 8;
			unsigned B: 8;
			unsigned :8;
	}l;

	pehdr->type=5;
	pehdr->level=1;
	pehdr->xlow=0; pehdr->xhigh=0xFFFFFFFF;
	pehdr->ylow=0; pehdr->yhigh=0xFFFFFFFF;
	if(d3){pehdr->zlow=0; pehdr->zhigh=0xFFFFFFFF;}
	pehdr->words=0x01b2;
	set_bytes23(&pdhdr->prologo,0x01a4);
	pdhdr->props.str.a=0;

	fputheader;
	boput_32(fdgn,0x00000000);	//R, G del fondo, screen flag

	uint C;
	u8int it=0;
#define set_byten(n,x) {if(n==0) l.R=x; elif(n==1) l.G=x; else l.B=x;}
#define addtoC(R) {uint kk=0xFF, rr=R; if(it&2){kk<<=16; rr<<=16;} if(it&1){kk<<=8; rr<<=8;} C&=~kk; C|=rr;}\
		if(++it==4){boput_32(fdgn,C); it=0;}

	addtoC(0);	//B del fondo

	//Colores con algún 0
	for(u8int i=0;i<3;i++){
		u8int b3=i;
		u8int valor=0xFF;
		set_byten(b3,0xFF);
		if(++b3==3) b3=0; set_byten(b3,0);
		if(++b3==3) b3=0; set_byten(b3,0);
		dontimes(3,){
			addtoC(l.R); addtoC(l.G); addtoC(l.B);
			valor-=80;
			set_byten(i,valor)
		}
	}
	for(u8int i=0;i<3;i++){
		u8int k1,k2;
		u8int valor=0xFF;
		set_byten(i,0);
		k1=i+1;	if(k1==3) k1=0;
		k2=k1+1; if(k2==3) k2=0;
		set_byten(k1,0xFF);
		dontimes(3,){
			u8int valor2=0xFF;
			set_byten(k2,0xFF);
			dontimes(3,){
				addtoC(l.R); addtoC(l.G); addtoC(l.B);
				valor2-=80;
				set_byten(k2,valor2)
			}
			valor-=80;
			set_byten(k1,valor)
		}
	}
#undef set_byten
	//Resto de colores
	l.R=0xFF;
	dontimes(5,l.R-=40){
		l.G=0xFF;
		dontimes(5,l.G-=40){
			l.B=0xFF;
			dontimes(5,l.B-=40){
				addtoC(l.R); addtoC(l.G); addtoC(l.B);
	}	}	}
	//Quedan 94
	addtoC(255);
	dontimes(60,) boput_32(fdgn,Я);	//162 a 241
	addtoC(255); addtoC(255);				//242
	ssint* pl=(ssint*)&l;
	*pl=colorsegmento;
	addtoC(l.R); addtoC(l.G); addtoC(l.B);	//243
	addtoC(l.R); addtoC(l.G); addtoC(l.B);	//244
	addtoC(l.R); addtoC(l.G); addtoC(l.B);	//245
	*pl=colorelipse;
	addtoC(l.R); addtoC(l.G); addtoC(l.B);	//246
	addtoC(l.R); addtoC(l.G); addtoC(l.B);	//247
	addtoC(l.R); addtoC(l.G); addtoC(l.B);	//248
	*pl=colorpCi;
	addtoC(l.R); addtoC(l.G); addtoC(l.B);	//249
	*pl=colorpCc;
	addtoC(l.R); addtoC(l.G); addtoC(l.B);	//250
	*pl=colorpAi;
	addtoC(l.R); addtoC(l.G); addtoC(l.B);	//251
	*pl=colorpAc;
	addtoC(l.R); addtoC(l.G); addtoC(l.B);	//252
	*pl=colorpM;
	addtoC(l.R); addtoC(l.G); addtoC(l.B);	//253
	*pl=colorcp;
	addtoC(l.R); addtoC(l.G); addtoC(l.B);	//254
	*pl=colorf;
	addtoC(l.R); addtoC(l.G); addtoC(l.B);	//255

	addtoC(0x23); addtoC(0);
#undef addtoC
	bowrite_chars(fdgn,"tabla de color de Aerotri                                       ",64);
}
/*-----------  Fin de elementos de cabecera ----------*/

uint16m reminder;
bint estado;
struct Globales_dgn{
	transf_dgn* _dgn;
	Elm_hdr* _pehdr;
	Disp_hdr* _pdhdr;
	ConfiguracionDibujo* _C;
};
#define Global Globales_dgn
#define dgn global->_dgn
#define pehdr	global->_pehdr
#define pdhdr	global->_pdhdr
#define C global->_C

#define fputwc(n) {u16int valor=(u16int)n; if(estado) boput_1616(fdgn,valor,reminder); else reminder=valor; estado=!estado;}
#define fputint32s(x,n) {uint *ptr=(uint*)x; dontimes(n,ptr++){fputwc((*ptr)&0x0000FFFF); fputwc((*ptr)>>16);}}
#define fput_revt(n) fputwc((n)>>16); fputwc((n)&0x0000FFFF);

#undef fputheader
#define fputheader	fputint32s(pehdr,7); fputint32s(pdhdr,2)

//return como obtiene_valores_fsemilla
int copy_file_not9(Buffer_bo *fdgn,FILE *fgraf){
	uint obligatorios;
	uint tipo;

	obligatorios=1;
	fread(&tipo,usizeof(uint),1,fgraf);
	while(bytes01(tipo)!=0xFFFF && !feof(fgraf)){
		uint t=bytes23(tipo);
		if(t&1 && usizeof(uint)==1){
			if(obligatorios!=7) return 10;
			else break;
		}
		if(byte1(tipo)==8) obligatorios|=2;
		elif(byte1(tipo)==10) obligatorios|=4;
		//elif(byte1(tipo)==9) obligatorios|=1;
		fputwc(bytes01(tipo)); fputwc(bytes23(tipo));
		if(usizeof(uint)==1){
			t>>=1;
			while(t--){
				int nret=(int)fread(&tipo,usizeof(uint),1,fgraf);
				if(nret!=1) return 9;
				fputwc(bytes01(tipo)); fputwc(bytes23(tipo));
			}
		}else{
			while(t--){
				int nret=(int)fread(&tipo,usizeof(uint)>>1,1,fgraf);
				if(nret!=1) return 9;
				fputwc(bytes01(tipo));
			}
		}
		fread(&tipo,usizeof(uint),1,fgraf);
	}
	if(obligatorios!=7) return 10;
	return 0;
}

/********  Principio de los elementos del dibujo ***********/
void dgn_foto(Buffer_bo *fdgn,uint* pbase,bint d3,Global* global){
	pUFD pufd;
	double minx,maxx,miny,maxy,minz,maxz, aux;
	ssint l;
	double xc,yc,zc,xc_e,yc_e,zc_e;
	double xesc[36];
	double escala=C->Cfotogramas.escala;

	pint=pbase+2;
	minx=*pdbl++; maxx=*pdbl++;
	miny=*pdbl++; maxy=*pdbl++;
	minz=*pdbl++; maxz=*pdbl++;
	skip_nombre(pint);
	pbase=pint;

	xc=*pdbl++;
	yc=*pdbl++;
	zc=*pdbl++;
	uint n=get_bytes01(pint); pint++;

	pehdr->type=6;
	pehdr->level=1;
	pehdr->words=HDR_SIZE+1;
	{u16int naux=DHR_SIZE+1;
	if(!d3){pehdr->words+=4*(n+1);	naux+=20;}
	else{	pehdr->words+=6*(n+1);	naux+=30;}
	set_bytes23(&pdhdr->prologo,naux);}
	pdhdr->props.str.a=0;
	pdhdr->props.str.color=254;

	zc_e=yc_e=xc_e=0;
	for(uint j=0;j<3*n;){
		xc_e+=*pdbl;		xesc[j++]=*pdbl++;
		yc_e+=*pdbl;		xesc[j++]=*pdbl++;
		zc_e+=*pdbl;		xesc[j++]=*pdbl++;
	}
	xc_e/=n;
	yc_e/=n;
	zc_e/=n;
	xc_e*=(1-escala);
	yc_e*=(1-escala);
	zc_e*=(1-escala);
	for(uint j=0;j<3*n;){
		xesc[j++]=escala*xesc[j]+xc_e;
		xesc[j++]=escala*xesc[j]+yc_e;
		xesc[j++]=escala*xesc[j]+zc_e;
	}

	if(minx==xc || maxx==xc){
		pdbl=(double*)(pbase+1)+3;
		maxx=minx=*pdbl;
		dontimes(n-1,){
			pdbl+=3;
			aux=*pdbl;
			if(aux<minx) minx=aux;
			if(aux>maxx) maxx=aux;
		}
	}
	if(miny==yc || maxy==yc){
		pdbl=(double*)(pbase+1)+4;
		maxy=miny=*pdbl;
		dontimes(n-1,){
			pdbl+=3;
			aux=*pdbl;
			if(aux<miny) miny=aux;
			if(aux>maxy) maxy=aux;
		}
	}

	minx=escala*minx+xc_e;
	maxx=escala*maxx+xc_e;
	miny=escala*miny+yc_e;
	maxy=escala*maxy+yc_e;
	pehdr->xlow=long_a_middle2((uint)double_a_uor_x(minx,dgn) ^ 0x80000000U);
	pehdr->ylow=long_a_middle2((uint)double_a_uor_y(miny,dgn) ^ 0x80000000U);
	pehdr->xhigh=long_a_middle2((uint)double_a_uor_x(maxx,dgn) ^ 0x80000000U);
	pehdr->yhigh=long_a_middle2((uint)double_a_uor_y(maxy,dgn) ^ 0x80000000U);
	if(d3){
		minz=escala*minz+zc_e;
		maxz=escala*maxz+zc_e;
		pehdr->zlow=long_a_middle2((uint)double_a_uor_z(minz,dgn) ^ 0x80000000U);
		pehdr->zhigh=long_a_middle2((uint)double_a_uor_z(maxz,dgn) ^ 0x80000000U);
	}
	fputheader;

	fputwc(n+1);	//número de vértices

	pdbl=xesc;
	fordown(i,n+1,){
		if(i==0) pdbl-=3*n;
		l=double_a_uor_x(*pdbl,dgn);		fput_revt(l);	pdbl++;
		l=double_a_uor_y(*pdbl,dgn);	fput_revt(l);	pdbl++;
		if(d3){
			l=double_a_uor_z(*pdbl,dgn);		fput_revt(l);
		}
		pdbl++;
	}

	//Centro
	double dlm;
	ssint lm,mx,my,mz;
	ssint laux;

	pehdr->type=3;
	pehdr->words=HDR_SIZE;
	{u16int naux=DHR_SIZE;
	if(!d3){pehdr->words+=8;		naux+=8;}
	else{	pehdr->words+=12;	naux+=12;}
	set_bytes23(&pdhdr->prologo,naux);}
	pdhdr->props.str.a=0;
	pdhdr->props.str.color=253;

	dlm=maxx-minx;
	aux=maxy-miny;
	if(aux<dlm) dlm=aux;
	dlm*=0.025;
	pdbl=(double*)pbase;
	mx=double_a_uor_x(*pdbl,dgn);
	my=double_a_uor_y(*(pdbl+1),dgn);
	if(d3) mz=double_a_uor_z(*(pdbl+2),dgn);
	lm=(ssint)(dlm*dgn->kuor);

	//Raya x-x
	pehdr->xlow=long_a_middle2((mx-lm) ^ 0x80000000);
	pehdr->ylow=long_a_middle2(my ^ 0x80000000);
	pehdr->xhigh=long_a_middle2((mx+lm) ^ 0x80000000);
	pehdr->yhigh=long_a_middle2(my ^ 0x80000000);
	if(d3){
		pehdr->zlow=long_a_middle2(mz ^ 0x80000000);
		pehdr->zhigh=long_a_middle2(mz ^ 0x80000000);
	}
	fputheader;

	laux=mx-lm;
	fput_revt(laux);	fput_revt(my);	if(d3){ fput_revt(mz);}
	laux=mx+lm;
	fput_revt(laux);	fput_revt(my);	if(d3){  fput_revt(mz);}

	//Raya y-y
	pehdr->xlow=long_a_middle2(mx ^ 0x80000000);
	pehdr->ylow=long_a_middle2((my-lm) ^ 0x80000000);
	pehdr->xhigh=long_a_middle2(mx ^ 0x80000000);
	pehdr->yhigh=long_a_middle2((my-lm) ^ 0x80000000);

	fputheader;

	laux=my-lm;
	fput_revt(mx);	fput_revt(laux);	if(d3){ fput_revt(mz);}
	laux=my+lm;
	fput_revt(mx);	fput_revt(laux);	if(d3){ fput_revt(mz);}

	//Raya vertical
	if(d3){
		pehdr->ylow=long_a_middle2(my ^ 0x80000000);
		pehdr->yhigh=long_a_middle2(my ^ 0x80000000);
		pehdr->zlow=long_a_middle2((mz-lm) ^ 0x80000000);
		pehdr->zhigh=long_a_middle2((mz+lm) ^ 0x80000000);

		fputheader;

		laux=mz-lm;
		fput_revt(mx);	fput_revt(my);	fput_revt(laux);
		laux=mz+lm;
		fput_revt(mx);	fput_revt(my);	fput_revt(laux);
	}
}

void dgn_punto(Buffer_bo *fdgn,pUFD pufd,Global* global, u8int level,u8int color){
	double dx,dy;
	ssint x,y;
	ssint verts[4];

	pehdr->type=3;
	pehdr->level=level;
	pehdr->words=HDR_SIZE+8;
	set_bytes23(&pdhdr->prologo,DHR_SIZE+8);
	pdhdr->props.str.a=0;
	pdhdr->props.str.color=color;

	pint+=2;
	dx=*pdbl; pdbl+=2;
	dy=*pdbl;

	x=double_a_uor_x(dx,dgn);
	y=double_a_uor_y(dy,dgn);

	pehdr->xlow=long_a_middle2(x ^ 0x80000000);
	pehdr->ylow=long_a_middle2(y ^ 0x80000000);
	pehdr->xhigh=long_a_middle2(x ^ 0x80000000);
	pehdr->yhigh=long_a_middle2(y ^ 0x80000000);
	fputheader;

	verts[0]=long_a_middle2(x);
	verts[1]=long_a_middle2(y);

	verts[2]=verts[0]; verts[3]=verts[1];
	fputint32s(verts,4);
}
void dgn_triangulo(Buffer_bo *fdgn,pUFD pufd,Global* global,double lT, u8int level,u8int color){
	double x,y,aux;
	ssint minx,maxx,miny,maxy;
	ssint verts[8];

	pehdr->type=6;
	pehdr->level=level;
	pehdr->words=HDR_SIZE+1+16+8;
	set_bytes23(&pdhdr->prologo,DHR_SIZE+1+16);
	pdhdr->props.str.a=1;
	pdhdr->props.str.color=color;

	pint+=2;
	x=*pdbl; pdbl+=2;
	y=*pdbl;

	lT*=0.5;
	minx=double_a_uor_x(x-lT,dgn);
	maxx=double_a_uor_x(x+lT,dgn);
	aux=lT*0.5773502692;	//sqrt(3)/3
	miny=double_a_uor_y(y-aux,dgn);
	maxy=double_a_uor_y(y+2*aux,dgn);

	pehdr->xlow=long_a_middle2(minx ^ 0x80000000);
	pehdr->ylow=long_a_middle2(miny ^ 0x80000000);
	pehdr->xhigh=long_a_middle2(maxx ^ 0x80000000);
	pehdr->yhigh=long_a_middle2(maxy ^ 0x80000000);
	fputheader;

	fputwc(4);	//número de vértices

	minx=long_a_middle2(minx);
	miny=long_a_middle2(miny);
	maxx=long_a_middle2(maxx);
	maxy=long_a_middle2(maxy);

	verts[6]=verts[0]=minx;
	verts[2]=maxx;
	verts[7]=verts[3]=verts[1]=miny;
	verts[4]=long_a_middle2(double_a_uor_x(x,dgn));
	verts[5]=maxy;
	fputint32s(verts,8);
	//Relleno
	fputwc(0x1007);	fputwc(0x0041);
	fputwc(0x0802);	fputwc(0x0001);
	fputwc(color);		fputwc(0x0000);
	fputwc(0x0000);	fputwc(0x0000);
}

void dgn_cuadrado(Buffer_bo *fdgn,pUFD pufd,Global* global,double slC,u8int level,u8int color){
	double x,y;
	ssint minx,maxx,miny,maxy;
	ssint verts[10];

	pehdr->type=6;
	pehdr->level=level;
	pehdr->words=HDR_SIZE+1+20+8;
	set_bytes23(&pdhdr->prologo,DHR_SIZE+1+20);
	pdhdr->props.str.a=1;
	pdhdr->props.str.color=color;

	pint+=2;
	x=*pdbl; pdbl+=2;
	y=*pdbl;

	minx=double_a_uor_x(x-slC,dgn);
	maxx=double_a_uor_x(x+slC,dgn);
	miny=double_a_uor_y(y-slC,dgn);
	maxy=double_a_uor_y(y+slC,dgn);

	pehdr->xlow=long_a_middle2(minx ^ 0x80000000);
	pehdr->ylow=long_a_middle2(miny ^ 0x80000000);
	pehdr->xhigh=long_a_middle2(maxx ^ 0x80000000);
	pehdr->yhigh=long_a_middle2(maxy ^ 0x80000000);
	fputheader;

	fputwc(5);	//número de vértices

	minx=long_a_middle2(minx);
	miny=long_a_middle2(miny);
	maxx=long_a_middle2(maxx);
	maxy=long_a_middle2(maxy);

	verts[8]=verts[6]=verts[0]=minx;
	verts[4]=verts[2]=maxx;
	verts[9]=verts[3]=verts[1]=miny;
	verts[7]=verts[5]=maxy;
	fputint32s(verts,10);
	//Relleno
	fputwc(0x1007);	fputwc(0x0041);
	fputwc(0x0802);	fputwc(0x0001);
	fputwc(color);		fputwc(0x0000);
	fputwc(0x0000);	fputwc(0x0000);
}

#define fput_middle4(x) {Middle_4 m4=x;  fputwc(m4.m0); fputwc(m4.m1); fputwc(m4.m2); fputwc(m4.m3);}
#define fput_double(x) fput_middle4(double_a_vax2(x).m4)

void dgn_circulo(Buffer_bo *fdgn,pUFD pufd,Global* global,double rC,u8int level,u8int color){
	ssint xl,yl,rCl,minx,maxx,miny,maxy;

	pehdr->type=15;
	pehdr->level=level;
	pehdr->words=HDR_SIZE+18+8;
	set_bytes23(&pdhdr->prologo,DHR_SIZE+18);
	pdhdr->props.str.a=1;
	pdhdr->props.str.color=color;

	pint+=2;
	xl=double_a_uor_x(*pdbl,dgn); pdbl+=2;
	yl=double_a_uor_y(*pdbl,dgn);
	rC*=dgn->kuor;
	rCl=(ssint)rC;
	minx=xl-rCl;
	maxx=xl+rCl;
	miny=yl-rCl;
	maxy=yl+rCl;

	pehdr->xlow=long_a_middle2(minx ^ 0x80000000);
	pehdr->ylow=long_a_middle2(miny ^ 0x80000000);
	pehdr->xhigh=long_a_middle2(maxx ^ 0x80000000);
	pehdr->yhigh=long_a_middle2(maxy ^ 0x80000000);
	fputheader;

	{Middle_4 r=double_a_vax2(rC).m4;
	fput_middle4(r);
	fput_middle4(r);}

	fputwc(0x0000); fputwc(0x0000);	//Rotación
	fput_double((double)xl);
	fput_double((double)yl);
	//Relleno
	fputwc(0x1007);	fputwc(0x0041);
	fputwc(0x0802);	fputwc(0x0001);
	fputwc(color);		fputwc(0x0000);
	fputwc(0x0000);	fputwc(0x0000);
}

void dgn_punto3d(Buffer_bo *fdgn,pUFD pufd,Global* global, u8int level,u8int color){
	double dx,dy,dz;
	ssint x,y,z;
	ssint verts[6];

	pehdr->type=3;
	pehdr->level=level;
	pehdr->words=HDR_SIZE+12;
	set_bytes23(&pdhdr->prologo,DHR_SIZE+12);
	pdhdr->props.str.a=0;
	pdhdr->props.str.color=color;

	pint+=2;
	dx=*pdbl; pdbl+=2;
	dy=*pdbl; pdbl+=2;
	dz=*pdbl;

	x=double_a_uor_x(dx,dgn);
	y=double_a_uor_y(dy,dgn);
	z=double_a_uor_z(dz,dgn);

	pehdr->xlow=long_a_middle2(x ^ 0x80000000);
	pehdr->ylow=long_a_middle2(y ^ 0x80000000);
	pehdr->zlow=long_a_middle2(z ^ 0x80000000);
	pehdr->xhigh=long_a_middle2(x ^ 0x80000000);
	pehdr->yhigh=long_a_middle2(y ^ 0x80000000);
	pehdr->zhigh=long_a_middle2(z ^ 0x80000000);
	fputheader;

	verts[0]=long_a_middle2(x);
	verts[1]=long_a_middle2(y);
	verts[2]=long_a_middle2(z);

	verts[3]=verts[0]; verts[4]=verts[1]; verts[5]=verts[2];
	fputint32s(verts,6);
}
void dgn_piramide(Buffer_bo *fdgn,pUFD pufd,Global* global,double lT, u8int level,u8int color){
	double dx,dy,dz;
	ssint x,y,z;
	ssint lTl,laux;
	ssint minx,maxx,miny,maxy,minz,maxz;
	ssint verts[12];

	pint+=2;
	dx=*pdbl; pdbl+=2;
	dy=*pdbl; pdbl+=2;
	dz=*pdbl;

	lTl=(ssint)(lT*dgn->kuor);
	lTl>>=1;
	x=double_a_uor_x(dx,dgn);
	y=double_a_uor_y(dy,dgn);
	z=double_a_uor_z(dz,dgn);
	minx=x-lTl;
	maxx=x+lTl;
	laux=(ssint)(lTl*0.5773502692);	//sqrt(3)/3
	miny=y-laux;
	maxy=y+2*laux;
	laux=(ssint)(lTl*0.4082482905);	//1/sqrt(6)
	minz=z-laux;
	maxz=z+3*laux;

	x=long_a_middle2(x);
	y=long_a_middle2(y);
	//z=long_a_middle2(z);
	minx=long_a_middle2(minx);
	miny=long_a_middle2(miny);
	maxx=long_a_middle2(maxx);
	maxy=long_a_middle2(maxy);
	minz=long_a_middle2(minz);
	maxz=long_a_middle2(maxz);

	//Cabecera
	pehdr->type=19;
	pehdr->level=level;
	pehdr->words=HDR_SIZE+7;
	set_bytes23(&pdhdr->prologo,DHR_SIZE+3);
	pdhdr->props.str.a=1;
	pdhdr->props.str.color=color;
	pdhdr->props.str.p=1;
	pdhdr->props.str.s=1;

	pehdr->xlow=minx ^ 0x00008000L;
	pehdr->ylow=miny ^ 0x00008000L;
	pehdr->zlow=minz ^ 0x00008000L;
	pehdr->xhigh=maxx ^ 0x00008000L;
	pehdr->yhigh=maxy ^ 0x00008000L;
	pehdr->zhigh=maxz ^ 0x00008000L;
	fputheader;

	fputwc(6+51+27+90); //longitud total
	fputwc(5);	//nº de elementos
	fputwc(0x0102);	//1=nº de superficies - 1, 2=tipo de superficie
	fputwc(0); fputwc(0);
	fputwc(0); fputwc(0);
	//Fin Cabecera*/

	pehdr->type=6;
	pehdr->level=level;
	pehdr->complex=1;
	set_bytes01(&pdhdr->prologo,ngrupograf); ngrupograf++;
	pehdr->words=HDR_SIZE+1+24+8;
	set_bytes23(&pdhdr->prologo,DHR_SIZE+1+24);
	pdhdr->props.str.a=1;
	pdhdr->props.str.color=color;
	pdhdr->props.str.p=0;
	pdhdr->props.str.s=0;

	//Triángulo de abajo;
	pehdr->zhigh=minz ^ 0x00008000L;
	fputheader;

	fputwc(4);	//número de vértices

	verts[9]=verts[0]=minx;
	verts[3]=maxx;
	verts[6]=x;
	verts[10]=verts[4]=verts[1]=miny;
	verts[7]=maxy;
	verts[11]=verts[8]=verts[5]=verts[2]=minz;
	fputint32s(verts,12);
	//Relleno
	fputwc(0x1007);	fputwc(0x0041);
	fputwc(0x0802);	fputwc(0x0001);
	fputwc(color);		fputwc(0x0000);
	fputwc(0x0000);	fputwc(0x0000);

	//vértice
	pehdr->words=HDR_SIZE+1+12;
	pdhdr->props.str.a=0;
	set_bytes23(&pdhdr->prologo,DHR_SIZE+1+12);
	pehdr->xlow=x ^ 0x00008000L;
	pehdr->ylow=y ^ 0x00008000L;
	pehdr->zlow=maxz ^ 0x00008000L;
	pehdr->xhigh=x ^ 0x00008000L;
	pehdr->yhigh=y ^ 0x00008000L;
	pehdr->zhigh=maxz ^ 0x00008000L;
	fputheader;

	fputwc(2);	//número de vértices
	verts[0]=x; verts[1]=y; verts[2]=maxz;
	verts[3]=x; verts[4]=y; verts[5]=maxz;
	//verts[6]=x; verts[7]=y; verts[8]=maxz;
	//verts[9]=x; verts[10]=y; verts[11]=maxz;
	fputint32s(verts,6);
	//línea 1
	pehdr->type=3;
	pehdr->words=HDR_SIZE+12;
	set_bytes23(&pdhdr->prologo,DHR_SIZE+12);
	pdhdr->props.str.clase=4;
	fputheader;

	verts[0]=minx; verts[1]=miny; verts[2]=minz;
	verts[3]=x; verts[4]=y; verts[5]=maxz;
	fputint32s(verts,6);
	//línea 2
	fputheader;
	verts[0]=maxx;
	fputint32s(verts,6);
	//línea 3
	fputheader;
	verts[0]=x; verts[1]=maxy;
	fputint32s(verts,6);

	/*//Triángulo 1;
	pehdr->xhigh=maxx ^ 0x00008000;
	pehdr->yhigh=y ^ 0x00008000;
	pehdr->zhigh=maxz ^ 0x00008000;
	fputheader;

	fputwc(4);	//número de vértices

	verts[7]=y;
	verts[8]=maxz;
	fputint32s(verts,12);
	//Relleno
	fputwc(0x1007);	fputwc(0x0041);
	fputwc(0x0802);	fputwc(0x0001);
	fputwc(color);		fputwc(0x0000);
	fputwc(0x0000);	fputwc(0x0000);

	//Triangulo 2;
	pehdr->xhigh=x ^ 0x00008000;
	pehdr->yhigh=maxy ^ 0x00008000;
	fputheader;

	fputwc(4);	//número de vértices

	verts[3]=x;
	verts[4]=maxy;
	fputint32s(verts,12);
	//Relleno
	fputwc(0x1007);	fputwc(0x0041);
	fputwc(0x0802);	fputwc(0x0001);
	fputwc(color);		fputwc(0x0000);
	fputwc(0x0000);	fputwc(0x0000);

	//Triángulo 3;
	pehdr->xlow=x ^ 0x00008000;
	pehdr->xhigh=maxx ^ 0x00008000;
	fputheader;

	fputwc(4);	//número de vértices

	verts[9]=verts[0]=maxx;
	verts[10]=verts[1]=miny;
	fputint32s(verts,12);
	//Relleno
	fputwc(0x1007);	fputwc(0x0041);
	fputwc(0x0802);	fputwc(0x0001);
	fputwc(color);		fputwc(0x0000);
	fputwc(0x0000);	fputwc(0x0000);*/

	pdhdr->props.str.clase=0;
	pehdr->complex=0;
	set_bytes01(&pdhdr->prologo,0);
}
void dgn_cubo(Buffer_bo *fdgn,pUFD pufd,Global* global,double slC, u8int level,u8int color){
	double dx,dy,dz;
	ssint x,y,z;
	ssint lTl;
	ssint minx,maxx,miny,maxy,minz,maxz;
	ssint verts[15];

	pint+=2;
	dx=*pdbl; pdbl+=2;
	dy=*pdbl; pdbl+=2;
	dz=*pdbl;

	lTl=(ssint)(slC*dgn->kuor);
	x=double_a_uor_x(dx,dgn);
	y=double_a_uor_y(dy,dgn);
	z=double_a_uor_z(dz,dgn);
	minx=x-lTl;
	maxx=x+lTl;
	miny=y-lTl;
	maxy=y+lTl;
	minz=z-lTl;
	maxz=z+lTl;

	minx=long_a_middle2(minx);
	miny=long_a_middle2(miny);
	minz=long_a_middle2(minz);
	maxx=long_a_middle2(maxx);
	maxy=long_a_middle2(maxy);
	maxz=long_a_middle2(maxz);

	//Cabecera
	pehdr->type=19;
	pehdr->level=level;
	pehdr->words=HDR_SIZE+7;
	set_bytes23(&pdhdr->prologo,DHR_SIZE+3);
	pdhdr->props.str.a=1;
	pdhdr->props.str.color=color;
	pdhdr->props.str.p=1;
	pdhdr->props.str.s=1;

	pehdr->xlow=minx ^ 0x00008000L;
	pehdr->ylow=miny ^ 0x00008000L;
	pehdr->zlow=minz ^ 0x00008000L;
	pehdr->xhigh=maxx ^ 0x00008000L;
	pehdr->yhigh=maxy ^ 0x00008000L;
	pehdr->zhigh=maxz ^ 0x00008000L;
	fputheader;

	fputwc(6+57+49+120); //longitud total
	fputwc(6);	//nº de elementos
	fputwc(0x0000);	//0=nº de superficies - 1, 0=tipo de superficie
	fputwc(0); fputwc(0);
	fputwc(0); fputwc(0);
	//Fin Cabecera*/

	//Base
	pehdr->type=6;
	pehdr->complex=1;
	set_bytes01(&pdhdr->prologo,ngrupograf); ngrupograf++;
	pehdr->words=HDR_SIZE+1+30+8;
	set_bytes23(&pdhdr->prologo,DHR_SIZE+1+30);
	pdhdr->props.str.a=1;
	pdhdr->props.str.color=color;
	pdhdr->props.str.p=0;
	pdhdr->props.str.s=0;

	pehdr->zhigh=minz ^ 0x00008000L;
	fputheader;

	fputwc(5);	//número de vértices

	verts[12]=verts[9]=verts[0]=minx;
	verts[6]=verts[3]=maxx;
	verts[13]=verts[4]=verts[1]=miny;
	verts[10]=verts[7]=maxy;
	verts[14]=verts[11]=verts[8]=verts[5]=verts[2]=minz;
	fputint32s(verts,15);
	//Relleno
	fputwc(0x1007);	fputwc(0x0041);
	fputwc(0x0802);	fputwc(0x0001);
	fputwc(color);		fputwc(0x0000);
	fputwc(0x0000);	fputwc(0x0000);
	//Top
	pehdr->words=HDR_SIZE+1+30;
	pdhdr->props.str.a=0;

	pehdr->zlow=maxz ^ 0x00008000;
	pehdr->zhigh=maxz ^ 0x00008000;
	fputheader;

	fputwc(5);	//número de vértices
	verts[14]=verts[11]=verts[8]=verts[5]=verts[2]=maxz;
	fputint32s(verts,15);
	//línea 1
	pehdr->type=3;
	pehdr->words=HDR_SIZE+12;
	set_bytes23(&pdhdr->prologo,DHR_SIZE+12);
	pdhdr->props.str.clase=4;
	pdhdr->props.str.a=0;

	pehdr->xhigh=minx ^ 0x00008000;
	pehdr->yhigh=miny ^ 0x00008000;
	pehdr->zlow=minz ^ 0x00008000;

	fputheader;

	verts[3]=verts[0]=minx;
	verts[4]=verts[1]=miny;
	verts[2]=minz; verts[5]=maxz;
	fputint32s(verts,6);
	//línea 2
	pehdr->xhigh=pehdr->xlow=maxx ^ 0x00008000L;
	fputheader;
	verts[3]=verts[0]=maxx;
	fputint32s(verts,6);
	//línea 3
	pehdr->yhigh=pehdr->ylow=maxy ^ 0x00008000L;
	fputheader;
	verts[4]=verts[1]=maxy;
	fputint32s(verts,6);
	//línea 4
	pehdr->xlow=pehdr->xhigh=minx ^ 0x00008000L;
	fputheader;
	verts[3]=verts[0]=minx;
	fputint32s(verts,6);

	pdhdr->props.str.clase=0;
	pehdr->complex=0;
	set_bytes01(&pdhdr->prologo,0);
}

#define fput_centro(centro) \
	fput_middle4(centro[0]);	fput_middle4(centro[1]); fput_middle4(centro[2])
void dgn_esfera(Buffer_bo *fdgn,pUFD pufd,Global* global,double rC,u8int level,u8int color){
	double dx,dy,dz;
	ssint x,y,z;
	ssint lTl;
	ssint minx,maxx,miny,maxy,minz,maxz;
	Middle_4 radio;
	Middle_4 centro[3];

	pint+=2;
	dx=*pdbl; pdbl+=2;
	dy=*pdbl; pdbl+=2;
	dz=*pdbl;

	x=double_a_uor_x(dx,dgn);
	y=double_a_uor_y(dy,dgn);
	z=double_a_uor_z(dz,dgn);

	centro[0]=double_a_vax2((double)x).m4;
	centro[1]=double_a_vax2((double)y).m4;
	centro[2]=double_a_vax2((double)z).m4;
	radio=double_a_vax2(rC*dgn->kuor).m4;

	lTl=(ssint)(rC*dgn->kuor);
	minx=x-lTl;
	maxx=x+lTl;
	miny=y-lTl;
	maxy=y+lTl;
	minz=z-lTl;
	maxz=z+lTl;

	x=long_a_middle2(x);
	y=long_a_middle2(y);
	z=long_a_middle2(z);
	minx=long_a_middle2(minx);
	miny=long_a_middle2(miny);
	minz=long_a_middle2(minz);
	maxx=long_a_middle2(maxx);
	maxy=long_a_middle2(maxy);
	maxz=long_a_middle2(maxz);

	//Cabecera
	pehdr->type=18;
	pehdr->level=level;
	pehdr->words=HDR_SIZE+7;
	set_bytes23(&pdhdr->prologo,DHR_SIZE+3);
	pdhdr->props.str.a=1;
	pdhdr->props.str.color=color;
	pdhdr->props.str.p=1;
	pdhdr->props.str.s=1;

	pehdr->xlow=minx ^ 0x00008000;
	pehdr->ylow=miny ^ 0x00008000;
	pehdr->zlow=minz ^ 0x00008000;
	pehdr->xhigh=maxx ^ 0x00008000;
	pehdr->yhigh=maxy ^ 0x00008000;
	pehdr->zhigh=maxz ^ 0x00008000;

	fputheader;

	fputwc(6+9*0x32); //longitud total
	fputwc(9);	//nº de elementos
	fputwc(0x0008);	//0=nº de superficies - 1, 8=tipo de superficie
	fputwc(0); fputwc(0);
	fputwc(0); fputwc(0);
	//Fin Cabecera*/

	pehdr->type=16;
	pehdr->complex=1;
	pehdr->words=0x30;
	set_bytes01(&pdhdr->prologo,ngrupograf); ngrupograf++;
	set_bytes23(&pdhdr->prologo,DHR_SIZE+0x20);
	pdhdr->props.str.a=0;
	pdhdr->props.str.p=0;
	pdhdr->props.str.s=0;
	//Arco 1
	pehdr->ylow=y ^ 0x00008000;
	pehdr->zlow=z ^ 0x00008000;
	pehdr->zhigh=z ^ 0x00008000;
	fputheader;

	fputwc(0x01ee); fputwc(0x6280);	//start angle
	fputwc(0x83dc); fputwc(0xc500);	//ángulo de barrido
	fput_middle4(radio);
	fput_middle4(radio);
	//Cuaternión
	fputwc(0); fputwc(0);
	fputwc(0x5a82); fputwc(0x7999);	//1/sqrt(2)
	fputwc(0x5a82); fputwc(0x7999);
	fputwc(0); fputwc(0);
	fput_centro(centro);
	//Arco 2
	pehdr->yhigh=y ^ 0x00008000;
	pehdr->zhigh=maxz ^ 0x00008000;
	fputheader;

	fputwc(0x01ee); fputwc(0x6280);	//start angle
	fputwc(0x83dc); fputwc(0xc500);	//ángulo de barrido
	fput_middle4(radio);
	fput_middle4(radio);
	//Cuaternión
	fputwc(0x4000); fputwc(0);	//1/2
	fputwc(0x4000); fputwc(0);
	fputwc(0x4000); fputwc(0);
	fputwc(0x4000); fputwc(0);
	fput_centro(centro);
	//Arco 3
	pdhdr->props.str.clase=4;
	pehdr->xlow=x ^ 0x00008000;
	pehdr->xhigh=x ^ 0x00008000;
	pehdr->yhigh=maxy ^ 0x00008000;
	fputheader;

	fputwc(0); fputwc(0);	//start angle
	fputwc(0x01ee); fputwc(0x6280);	//ángulo de barrido
	fput_middle4(radio);
	fput_middle4(radio);
	//Cuaternión
	fputwc(0xc000); fputwc(0);	//-1/2
	fputwc(0x4000); fputwc(0);
	fputwc(0x4000); fputwc(0);
	fputwc(0x4000); fputwc(0);
	fput_centro(centro);
	//Arco 4
	pdhdr->props.str.clase=0;
	pehdr->xlow=minx ^ 0x00008000;
	pehdr->ylow=miny ^ 0x00008000;
	pehdr->xhigh=maxx ^ 0x00008000;
	pehdr->yhigh=y ^ 0x00008000;
	pehdr->zhigh=z ^ 0x00008000;
	fputheader;

	fputwc(0x01ee); fputwc(0x6280);	//start angle
	fputwc(0x83dc); fputwc(0xc500);	//ángulo de barrido
	fput_middle4(radio);
	fput_middle4(radio);
	//Cuaternión
	fputwc(0x5a82); fputwc(0x7999);
	fputwc(0); fputwc(0);
	fputwc(0); fputwc(0);
	fputwc(0x5a82); fputwc(0x7999);
	fput_centro(centro);
	//Arco 5
	pdhdr->props.str.clase=4;
	pehdr->xlow=x ^ 0x00008000;
	pehdr->xhigh=x ^ 0x00008000;
	pehdr->zhigh=maxz ^ 0x00008000;
	fputheader;

	fputwc(0); fputwc(0);	//start angle
	fputwc(0x01ee); fputwc(0x6280);	//ángulo de barrido
	fput_middle4(radio);
	fput_middle4(radio);
	//Cuaternión
	fputwc(0); fputwc(0);
	fputwc(0x5a82); fputwc(0x7999);
	fputwc(0); fputwc(0);
	fputwc(0x5a82); fputwc(0x7999);
	fput_centro(centro);
	//Arco 6
	pdhdr->props.str.clase=0;
	pehdr->xlow=minx ^ 0x00008000;
	pehdr->ylow=y ^ 0x00008000;
	pehdr->zlow=minz ^ 0x00008000;
	pehdr->xhigh=maxx ^ 0x00008000;
	pehdr->zhigh=z ^ 0x00008000;
	fputheader;

	fputwc(0x01ee); fputwc(0x6280);	//start angle
	fputwc(0x83dc); fputwc(0xc500);	//ángulo de barrido
	fput_middle4(radio);
	fput_middle4(radio);
	//Cuaternión
	fputwc(0x4000); fputwc(0);
	fputwc(0xc000); fputwc(0);
	fputwc(0xc000); fputwc(0);
	fputwc(0x4000); fputwc(0);
	fput_centro(centro);
	//Arco 7
	pdhdr->props.str.clase=4;
	pehdr->xlow=x ^ 0x00008000;
	pehdr->ylow=miny ^ 0x00008000;
	pehdr->xhigh=x ^ 0x00008000;
	fputheader;

	fputwc(0); fputwc(0);	//start angle
	fputwc(0x01ee); fputwc(0x6280);	//ángulo de barrido
	fput_middle4(radio);
	fput_middle4(radio);
	//Cuaternión
	fputwc(0x4000); fputwc(0);
	fputwc(0x4000); fputwc(0);
	fputwc(0xc000); fputwc(0);
	fputwc(0x4000); fputwc(0);
	fput_centro(centro);
	//Arco 8
	pdhdr->props.str.clase=0;
	pehdr->xlow=minx ^ 0x00008000;
	pehdr->ylow=y ^ 0x00008000;
	pehdr->zlow=z ^ 0x00008000;
	pehdr->xhigh=maxx ^ 0x00008000;
	pehdr->yhigh=maxy ^ 0x00008000;
	fputheader;

	fputwc(0x01ee); fputwc(0x6280);	//start angle
	fputwc(0x83dc); fputwc(0xc500);	//ángulo de barrido
	fput_middle4(radio);
	fput_middle4(radio);
	//Cuaternión
	fputwc(0); fputwc(0);
	fputwc(0x5a82); fputwc(0x7999);
	fputwc(0x5a82); fputwc(0x7999);
	fputwc(0); fputwc(0);
	fput_centro(centro);
	//Arco 9
	pdhdr->props.str.clase=4;
	pehdr->xlow=x ^ 0x00008000;
	pehdr->zlow=minz ^ 0x00008000;
	pehdr->xhigh=x ^ 0x00008000;
	fputheader;

	fputwc(0); fputwc(0);	//start angle
	fputwc(0x01ee); fputwc(0x6280);	//ángulo de barrido
	fput_middle4(radio);
	fput_middle4(radio);
	//Cuaternión
	fputwc(0xa57d); fputwc(0x8667);	//-1/sqrt(2)
	fputwc(0); fputwc(0);
	fputwc(0x5a82); fputwc(0x7999);
	fputwc(0); fputwc(0);
	fput_centro(centro);

	pdhdr->props.str.clase=0;
	pehdr->complex=0;
	set_bytes01(&pdhdr->prologo,0);
}

void dgn_trianguloycentro(Buffer_bo *fdgn,pUFD pufd,Global* global,double lT, u8int level,u8int color){
	dgn_triangulo(fdgn,pufd,global,lT,level,color);
	dgn_punto(fdgn,pufd,global,level,color);
}
void dgn_cuadradoycentro(Buffer_bo *fdgn,pUFD pufd,Global* global,double slC, u8int level,u8int color){
	dgn_cuadrado(fdgn,pufd,global,slC,level,color);
	dgn_punto(fdgn,pufd,global,level,color);
}
void dgn_piramideycentro(Buffer_bo *fdgn,pUFD pufd,Global* global,double lT, u8int level,u8int color){
	dgn_piramide(fdgn,pufd,global,lT,level,color);
	dgn_punto3d(fdgn,pufd,global,level,color);
}
void dgn_cuboycentro(Buffer_bo *fdgn,pUFD pufd,Global* global,double slC, u8int level,u8int color){
	dgn_cubo(fdgn,pufd,global,slC,level,color);
	dgn_punto3d(fdgn,pufd,global,level,color);
}

void dgn_puntoAc(Buffer_bo *fdgn,pUFD pufd,bint d3,Global* global,double lT){
	if(!d3) dgn_trianguloycentro(fdgn,pufd,global,lT,3,251);
	else dgn_piramideycentro(fdgn,pufd,global,lT,3,251);
}
void dgn_puntoAi(Buffer_bo *fdgn,pUFD pufd,bint d3,Global* global,double lT){
	if(!d3) dgn_trianguloycentro(fdgn,pufd,global,lT,3,250);
	else dgn_piramideycentro(fdgn,pufd,global,lT,3,250);
}
void dgn_puntoCc(Buffer_bo *fdgn,pUFD pufd,bint d3,Global* global,double slC){
	if(!d3) dgn_cuadradoycentro(fdgn,pufd,global,slC,4,249);
	else dgn_cuboycentro(fdgn,pufd,global,slC,4,249);
}
void dgn_puntoCi(Buffer_bo *fdgn,pUFD pufd,bint d3,Global* global,double slC){
	if(!d3) dgn_cuadradoycentro(fdgn,pufd,global,slC,4,248);
	else dgn_cuboycentro(fdgn,pufd,global,slC,4,248);
}

void dgn_puntoA(Buffer_bo *fdgn,pUFD pufd,bint d3,Global* global,double lT,double slC){
	u8int subtipo,l;
	subtipo=get_byte1(pint);

	if((l=subtipo&007)!=0){
		if(l==7) dgn_puntoAc(fdgn,pufd,d3,global,lT);
		else dgn_puntoAi(fdgn,pufd,d3,global,lT);
	}elif((l=(subtipo&070)>>3)){
		if(l==7) dgn_puntoCc(fdgn,pufd,d3,global,slC);
		else dgn_puntoCi(fdgn,pufd,d3,global,slC);
	}
}

void dgn_puntoM(Buffer_bo *fdgn,pUFD pufd,bint d3,Global* global,double rC){
	if(!d3) dgn_circulo(fdgn,pufd,global,rC,2,252);
	else dgn_esfera(fdgn,pufd,global,rC,2,252);
}

void dgn_elipse(Buffer_bo *fdgn,pUFD pufd,bint d3,Global* global){
	u8int subtipo,orientacion;
	double minx,maxx,miny,maxy,minz,maxz;
	double xc,yc,zc;
	float escala;
	float sx,sxy,sy,dx,dy;
	double a,b, cosa,sina;
	uint l;

	subtipo=get_byte1(pint);
	if(subtipo==0) escala=C->Cprecisionescp.Celipse.escala;
	else escala=C->CprecisionespM.Celipse.escala;
	escala*=escala;

	pehdr->type=15;
	if(subtipo==0) pehdr->level=5;
	else pehdr->level=6;
	pehdr->words=HDR_SIZE;
	{u16int naux=DHR_SIZE;
	if(!d3){pehdr->words+=18;	naux+=18;}
	else{	pehdr->words+=28;	naux+=28;}
	set_bytes23(&pdhdr->prologo,naux);}
	pdhdr->props.str.a=0;
//	pdhdr->props.str.color=254;	//más adelante

	pint+=14;
	skip_nombre(pint);
	xc=*pdbl++;
	yc=*pdbl++;
	zc=*pdbl++;
	orientacion=get_byte0(pint); pint++;
	if(!d3 && orientacion!=0) return;

	sx=*psingle++;
	sxy=*psingle++;
	sy=*psingle++;
	sx*=escala; sxy*=escala;
	sy*=escala;
	dx=sqrt(sx); dy=sqrt(sy);
	switch(orientacion){
	  case 0:
		minx=xc-dx;
		maxx=xc+dx;
		miny=yc-dy;
		maxy=yc+dy;
		maxz=minz=zc;
		break;
	  case 1:
		miny=yc-dx;
		maxy=yc+dx;
		minz=zc-dy;
		maxz=zc+dy;
		maxx=minx=xc;
		break;
	  case 2:
		minz=zc-dx;
		maxz=zc+dx;
		minx=xc-dy;
		maxx=xc+dy;
		maxy=miny=yc;
		break;
	}
	varianzas_a_alpha_dbl((double)sx,(double)sxy,(double)sy,&a,&b,&cosa,&sina);

	switch(orientacion){
		case 0: pdhdr->props.str.color=247; break;
		case 1: pdhdr->props.str.color=246; break;
		case 2: pdhdr->props.str.color=245; break;
	}

	pehdr->xlow=long_a_middle2(double_a_uor_x(minx,dgn) ^ 0x80000000);
	pehdr->ylow=long_a_middle2(double_a_uor_y(miny,dgn) ^ 0x80000000);
	pehdr->xhigh=long_a_middle2(double_a_uor_x(maxx,dgn) ^ 0x80000000);
	pehdr->yhigh=long_a_middle2(double_a_uor_y(maxy,dgn) ^ 0x80000000);
	if(d3){
	  pehdr->zlow=long_a_middle2(double_a_uor_z(maxz,dgn) ^ 0x80000000);
	  pehdr->zhigh=long_a_middle2(double_a_uor_z(maxz,dgn) ^ 0x80000000);
	}
	fputheader;

	fput_double((double)double_a_uor_x(a,dgn));
	fput_double((double)double_a_uor_x(b,dgn));
	if(!d3){
		double alpha=atan2(sina,cosa)*180.0/PI;
		if(alpha<0) alpha+=180;
		if(alpha<0) alpha+=180;
		alpha*=360000.0;
		l=(uint)(ssint)alpha;
		fput_revt(l);
	}else{
		double q1,q2,q3,q4;
		if(cosa<0){cosa=-cosa; sina=-sina;}//para los casos 1 y 2; que el coseno sea positivo
		switch(orientacion){
		case 0:
			q1=sqrt(0.5*(1+cosa));
			q2=0;
			q3=0;
			q4=-sqrt(0.5*(1-cosa));
			break;
		case 1:
			q2=sqrt(1.0+sina)*0.5;
			q4=q2;
			q3=sqrt(1.0-sina)*0.5;
			q1=-q3;
			break;
		case 2:
			q1=sqrt(1.0F+sina)*0.5;
			q2=q1;
			q3=sqrt(1.0F-sina)*0.5;
			q4=q3;
			break;
		}
		l=(uint)(ssint)(q1*0x80000000);	fput_revt(l);
		l=(uint)(ssint)(q2*0x80000000);	fput_revt(l);
		l=(uint)(ssint)(q3*0x80000000);	fput_revt(l);
		l=(uint)(ssint)(q4*0x80000000);	fput_revt(l);
	}

	fput_double((double)double_a_uor_x(xc,dgn));
	fput_double((double)double_a_uor_y(yc,dgn));
	if(d3){
		fput_double((double)double_a_uor_z(zc,dgn));
	}
}
void dgn_segmento(Buffer_bo *fdgn,pUFD pufd,bint d3,Global* global){
	u8int subtipo;
	ssint minx,maxx,miny,maxy,minz,maxz;
	double xc,yc,zc;
	float escala;
	float dx,dy,dz;
	ssint x,y,z,dnx,dny,dnz;

	subtipo=get_byte1(pint);
	if(subtipo==0) escala=C->Cprecisionescp.Csegmento.escala;
	else escala=C->CprecisionespM.Csegmento.escala;

	pehdr->type=3;
	if(subtipo==0) pehdr->level=7;
	else pehdr->level=8;
	pehdr->words=HDR_SIZE;
	{u16int naux=DHR_SIZE;
	if(!d3){pehdr->words+=8;		naux+=8;}
	else{	pehdr->words+=12;	naux+=12;}
	set_bytes23(&pdhdr->prologo,naux);}
	pdhdr->props.str.a=0;
//	pdhdr->props.str.color=244;	//más adelante

	pint+=14;
	skip_nombre(pint);
	xc=*pdbl++;
	yc=*pdbl++;
	zc=*pdbl++;

	x=double_a_uor_x(xc,dgn);
	y=double_a_uor_y(yc,dgn);
	z=double_a_uor_z(zc,dgn);
	dx=*psingle++;	dnx=(ssint)(dx*escala*dgn->kuor);
	dy=*psingle++;	dny=(ssint)(dx*escala*dgn->kuor);
	dz=*psingle++;	dnz=(ssint)(dx*escala*dgn->kuor);

	if(dnz!=0) pdhdr->props.str.color=244;
	elif(dnx!=0) pdhdr->props.str.color=243;
	else pdhdr->props.str.color=242;
	if(!d3){
		if(dnz==0) return;
		dny=dnz; dnz=0;
	}
	minx=x-dnx;		maxx=x+dnx;
	miny=y-dny;		maxy=y+dny;
	minz=z-dnz;		maxz=z+dnz;

	minx=long_a_middle2(minx);
	miny=long_a_middle2(miny);
	maxx=long_a_middle2(maxx);
	maxy=long_a_middle2(maxy);
	pehdr->xlow= minx ^ 0x00008000L;
	pehdr->ylow= miny ^ 0x00008000L;
	pehdr->xhigh=maxx ^ 0x00008000L;
	pehdr->yhigh=maxy ^ 0x00008000L;
	if(d3){
	  minz=long_a_middle2(minz);
	  maxz=long_a_middle2(maxz);
	  pehdr->zlow= minz ^ 0x00008000L;
	  pehdr->zhigh=maxz ^ 0x00008000L;
	}
	fputheader;

	fputwc(minx&0xFFFF);	fputwc(minx>>16);
	fputwc(miny&0xFFFF);	fputwc(miny>>16);
	if(d3){
	  fputwc(minz&0xFFFF);	fputwc(minz>>16);
	}
	fputwc(maxx&0xFFFF);	fputwc(maxx>>16);
	fputwc(maxy&0xFFFF);	fputwc(maxy>>16);
	if(d3){
	  fputwc(maxz&0xFFFF);	fputwc(maxz>>16);
	}
}

void dgn__elipsoide(Buffer_bo *fdgn,u8int subtipo,double xc,double yc, double zc, float sx,float sy,float sz, float *sejes,float escala,Global* global);
void dgn_elipsoide(Buffer_bo *fdgn,pUFD pufd,bint d3,Global* global){
	u8int subtipo;
	double minx,maxx,miny,maxy;
	ssint l;
	double xc,yc,zc;
	float escala;
	float sx,sxy,sy,sz,dx,dy;
	double a,b,alpha,sina,cosa;
	ssint x,dz;
	ssint lminy,lmaxy;

	subtipo=get_byte1(pint);
	if(subtipo==0){
		escala=C->Cprecisionescp.Celipse.escala;
	}else{
		escala=C->CprecisionespM.Celipse.escala;
	}

	pint+=14;
	skip_nombre(pint);
	xc=*pdbl++;
	yc=*pdbl++;
	zc=*pdbl++;

	if(d3){
		float sejes[9];
		float sm1,sm2,sm3;
		sm3=sm2=sm1=0;
		semiejes3_fl(psingle,&sm1,&sm2,&sm3,sejes);
		if(sm1==0 || sm2==0 || sm3==0) return;
		sx=sqrtf(*psingle); psingle+=2;
		sy=sqrtf(*psingle); psingle+=3;
		sz=sqrtf(*psingle);
		return dgn__elipsoide(fdgn,subtipo,xc,yc,zc,sx,sy,sz,sejes,escala,global);
	}

	pehdr->type=15;
	if(subtipo==0) pehdr->level=5;
	else pehdr->level=6;
	pehdr->words=HDR_SIZE+18;
	set_bytes23(&pdhdr->prologo,DHR_SIZE+18);
	pdhdr->props.str.a=0;
	pdhdr->props.str.color=247;

	escala*=escala;

	sx=*psingle++;
	sxy=*psingle++;
	sy=*psingle; psingle+=3;
	sz=*psingle++;
	sx*=escala; sxy*=escala;
	sy*=escala;
	sz*=escala;
	dx=sqrt(sx); dy=sqrt(sy);
	sz=sqrt(sz);

	minx=xc-dx;
	maxx=xc+dx;
	miny=yc-dy;
	maxy=yc+dy;

	varianzas_a_alpha_dbl((double)sx,(double)sxy,(double)sy,&a,&b,&cosa,&sina);

	pehdr->xlow=long_a_middle2(double_a_uor_x(minx,dgn) ^ 0x80000000);
	pehdr->ylow=long_a_middle2(double_a_uor_y(miny,dgn) ^ 0x80000000);
	pehdr->xhigh=long_a_middle2(double_a_uor_x(maxx,dgn) ^ 0x80000000);
	pehdr->yhigh=long_a_middle2(double_a_uor_y(maxy,dgn) ^ 0x80000000);

	fputheader;

	fput_double(a*dgn->kuor);
	fput_double(b*dgn->kuor);

	alpha=atan2(sina,cosa); 
	alpha*=180.0/PI;
	if(alpha<0) alpha+=180;
	if(alpha<0) alpha+=180;
	alpha*=360000.0;
	l=(ssint)alpha;	fput_revt(l);

	fput_double((double)double_a_uor_x(xc,dgn));
	fput_double((double)double_a_uor_y(yc,dgn));

	//segmento
	pehdr->type=3;
	if(subtipo==0) pehdr->level=7;
	else pehdr->level=8;
	pehdr->words=HDR_SIZE+8;
	set_bytes23(&pdhdr->prologo,DHR_SIZE+8);
	pdhdr->props.str.a=0;
	pdhdr->props.str.color=244;

	dz=(ssint)(sz*dgn->kuor);

	{ssint y=double_a_uor_y(yc,dgn);
	lminy=y-dz;
	lmaxy=y+dz;}

	x=long_a_middle2(double_a_uor_x(xc,dgn));
	lminy=long_a_middle2(lminy);
	lmaxy=long_a_middle2(lmaxy);
	pehdr->xlow= x ^ 0x00008000L;
	pehdr->ylow= lminy ^ 0x00008000L;
	pehdr->xhigh=x ^ 0x00008000L;
	pehdr->yhigh=lmaxy ^ 0x00008000L;

	fputheader;

	fputwc(x&0xFFFF);			fputwc(x>>16);
	fputwc(lminy&0xFFFF);	fputwc(lminy>>16);
	fputwc(x&0xFFFF);			fputwc(x>>16);
	fputwc(lmaxy&0xFFFF);	fputwc(lmaxy>>16);
}

/*void dgn_ejes(Buffer_bo *fdgn,pUFD pufd,bint d3,Global* global){
	if(!d3) return;
	u8int subtipo;
	float escala;
	double xc,yc,zc;

	subtipo=get_byte1(pint);
	if(subtipo==0) escala=C->Cprecisionescp.Celipse.escala;
	else escala=C->CprecisionespM.Celipse.escala;

	pint+=14;
	skip_nombre(pint);
	xc=*pdbl++;
	yc=*pdbl++;
	zc=*pdbl++;
	return dgn__ejes(fdgn,subtipo,xc,yc,zc,psingle,escala,global);
}*/
void dgn__elipsoide(Buffer_bo *fdgn,u8int subtipo,double xc,double yc,double zc, float sx,float sy,float sz, float *sejes,float escala,Global* global){
	float x1,y1,z1,x2,y2,z2,x3,y3,z3;
	float sm1,sm2,sm3;
	float p1,p2,p3,p4,q1,q2,q3,q4,r1,r2,r3,r4;
	float faux;
	ssint x,y,z;
	ssint minx,maxx,miny,maxy,minz,maxz;
	Middle_4 smuor1,smuor2,smuor3;
	Middle_4 centro[3];
	ssint quat1[4], quat2[4], quat3[4];
	ssint l;

	sx*=escala*dgn->kuor;
	sy*=escala*dgn->kuor;
	sz*=escala*dgn->kuor;
	x1=*sejes++*escala;		y1=*sejes++*escala;	z1=*sejes++*escala;
	x2=*sejes++*escala;		y2=*sejes++*escala;	z2=*sejes++*escala;
	x3=*sejes++*escala;		y3=*sejes++*escala;	z3=*sejes++*escala;

	sm1=x1*x1+y1*y1+z1*z1; if(sm1==0) return;
	sm1=sqrt(sm1);
	sm2=x2*x2+y2*y2+z2*z2; if(sm2==0) return;
	sm2=sqrt(sm2);
	sm3=x3*x3+y3*y3+z3*z3; if(sm3==0) return;
	sm3=sqrt(sm3);

	x1/=sm1; y1/=sm1; z1/=sm1;
	x2/=sm2; y2/=sm2; z2/=sm2;
	x3/=sm3; y3/=sm3; z3/=sm3;

	p1=(1+x1+y2+z3)*0.25F;
	p1=sqrt(p1);
	faux=0.25F/p1;
	p4=(x2-y1)*faux;
	p2=(y3-z2)*faux;
	p3=(z1-x3)*faux;

	q1=(1+x1+y3-z2)*0.25F;
	q1=sqrt(q1);
	faux=0.25F/q1;
	q4=(x3-y1)*faux;
	q2=(-y2-z3)*faux;
	q3=(z1+x2)*faux;

	r1=(1+x2+y3+z1)*0.25F;
	r1=sqrt(r1);
	faux=0.25F/r1;
	r4=(x3-y2)*faux;
	r2=(y1-z3)*faux;
	r3=(z2-x1)*faux;

	l=(ssint)(p1*0x80000000); quat1[0]=long_a_middle2(l);
	l=(ssint)(p2*0x80000000); quat1[1]=long_a_middle2(l);
	l=(ssint)(p3*0x80000000); quat1[2]=long_a_middle2(l);
	l=(ssint)(p4*0x80000000); quat1[3]=long_a_middle2(l);

	l=(ssint)(q1*0x80000000); quat2[0]=long_a_middle2(l);
	l=(ssint)(q2*0x80000000); quat2[1]=long_a_middle2(l);
	l=(ssint)(q3*0x80000000); quat2[2]=long_a_middle2(l);
	l=(ssint)(q4*0x80000000); quat2[3]=long_a_middle2(l);

	l=(ssint)(r1*0x80000000); quat3[0]=long_a_middle2(l);
	l=(ssint)(r2*0x80000000); quat3[1]=long_a_middle2(l);
	l=(ssint)(r3*0x80000000); quat3[2]=long_a_middle2(l);
	l=(ssint)(r4*0x80000000); quat3[3]=long_a_middle2(l);

	x=double_a_uor_x(xc,dgn);
	y=double_a_uor_y(yc,dgn);
	z=double_a_uor_z(zc,dgn);
	centro[0]=double_a_vax2((double)x).m4;
	centro[1]=double_a_vax2((double)y).m4;
	centro[2]=double_a_vax2((double)z).m4;
	smuor1=double_a_vax2(sm1*dgn->kuor).m4;
	smuor2=double_a_vax2(sm2*dgn->kuor).m4;
	smuor3=double_a_vax2(sm3*dgn->kuor).m4;

	minx=x-sx;	maxx=x+sx;
	miny=y-sy;	maxy=y+sy;
	minz=z-sz;	maxz=z+sz;

	x=long_a_middle2(x);
	y=long_a_middle2(y);
	z=long_a_middle2(z);
	minx=long_a_middle2(minx);
	miny=long_a_middle2(miny);
	minz=long_a_middle2(minz);
	maxx=long_a_middle2(maxx);
	maxy=long_a_middle2(maxy);
	maxz=long_a_middle2(maxz);

	//Cabecera
	pehdr->type=18;
	if(subtipo==0) pehdr->level=5;
	else pehdr->level=6;
	pehdr->words=HDR_SIZE+7;
	set_bytes23(&pdhdr->prologo,DHR_SIZE+3);
	pdhdr->props.str.a=1;
	pdhdr->props.str.color=247;
	pdhdr->props.str.p=1;
	pdhdr->props.str.s=1;

	pehdr->xlow=minx ^ 0x00008000;
	pehdr->ylow=miny ^ 0x00008000;
	pehdr->zlow=minz ^ 0x00008000;
	pehdr->xhigh=maxx ^ 0x00008000;
	pehdr->yhigh=maxy ^ 0x00008000;
	pehdr->zhigh=maxz ^ 0x00008000;

	fputheader;

	fputwc(6+9*0x32); //longitud total
	fputwc(9);	//nº de elementos
	fputwc(0x0008);	//0=nº de superficies - 1, 8=tipo de superficie
	fputwc(0); fputwc(0);
	fputwc(0); fputwc(0);
	//Fin Cabecera*/

	pehdr->type=16;
	pehdr->complex=1;
	pehdr->words=0x30;
	set_bytes01(&pdhdr->prologo,ngrupograf); ngrupograf++;
	set_bytes23(&pdhdr->prologo,DHR_SIZE+0x20);
	pdhdr->props.str.a=0;
	pdhdr->props.str.p=0;
	pdhdr->props.str.s=0;
	//Arco 1
	//Eliminadas las coordenadas extremas particulares,
	//tal vez algún día las calcule
	fputheader;

	fputwc(0); fputwc(0);			//start angle
	fputwc(0x03dc); fputwc(0xc500);	//ángulo de barrido (180)
	fput_middle4(smuor1);
	fput_middle4(smuor2);
	fputint32s(&quat1,4); //cuaternión
	fput_centro(centro);
	//Arco 2
	fputheader;

	fputwc(0); fputwc(0);	//start angle
	fputwc(0x03dc); fputwc(0xc500);	//ángulo de barrido (180)
	fput_middle4(smuor1);
	fput_middle4(smuor3);
	fputint32s(&quat2,4); //cuaternión
	fput_centro(centro);
	//Arco 3
	pdhdr->props.str.clase=4;
	fputheader;

	fputwc(0); fputwc(0);	//start angle
	fputwc(0x01ee); fputwc(0x6280);	//ángulo de barrido (90)
	fput_middle4(smuor2);
	fput_middle4(smuor3);
	fputint32s(&quat3,4); //cuaternión
	fput_centro(centro);
	//Arco 4
	pdhdr->props.str.clase=0;
	fputheader;

	fputwc(0); fputwc(0);	//start angle
	fputwc(0x83dc); fputwc(0xc500);	//ángulo de barrido (-180)
	fput_middle4(smuor1);
	fput_middle4(smuor2);
	fputint32s(&quat1,4); //cuaternión
	fput_centro(centro);
	//Arco 5
	pdhdr->props.str.clase=4;
	fputheader;

	fputwc(0x01ee); fputwc(0x6280);	//start angle (90)
	fputwc(0x01ee); fputwc(0x6280);	//ángulo de barrido
	fput_middle4(smuor2);
	fput_middle4(smuor3);
	fputint32s(&quat3,4); //cuaternión
	fput_centro(centro);
	//Arco 6
	pdhdr->props.str.clase=0;
	fputheader;

	fputwc(0); fputwc(0);	//start angle
	fputwc(0x83dc); fputwc(0xc500);	//ángulo de barrido (-180)
	fput_middle4(smuor1);
	fput_middle4(smuor3);
	fputint32s(&quat2,4); //cuaternión
	fput_centro(centro);
	//Arco 7
	pdhdr->props.str.clase=4;
	fputheader;

	fputwc(0x03dc); fputwc(0xc500);	//start angle (180)
	fputwc(0x01ee); fputwc(0x6280);	//ángulo de barrido
	fput_middle4(smuor2);
	fput_middle4(smuor3);
	fputint32s(&quat3,4); //cuaternión
	fput_centro(centro);
	//Arco 8
	pdhdr->props.str.clase=0;
	fputheader;

	fputwc(0); fputwc(0);			//start angle
	fputwc(0x03dc); fputwc(0xc500);	//ángulo de barrido (180)
	fput_middle4(smuor1);
	fput_middle4(smuor2);
	fputint32s(&quat1,4); //cuaternión
	fput_centro(centro);
	//Arco 9
	pdhdr->props.str.clase=4;
	fputheader;

	fputwc(0x05cb); fputwc(0x2780);	//start angle (270)
	fputwc(0x01ee); fputwc(0x6280);	//ángulo de barrido
	fput_middle4(smuor2);
	fput_middle4(smuor3);
	fputint32s(&quat3,4); //cuaternión
	fput_centro(centro);

	pdhdr->props.str.clase=0;
	pehdr->complex=0;
	set_bytes01(&pdhdr->prologo,0);
}

#undef dgn
#undef pehdr
#undef pdher
int gra_a_dgn(uint* base,uint tamanno,char16_t* ficherodgn,bint d3,ConfiguracionDibujo* _C,OpcionesDgn *_O,char16_t* mensaje,u8int idioma){
	if(base==NULL || tamanno==0) return 0;
	if(idioma>2) idioma=0;

	Global globaL;
	Global* global=&globaL;
	C=_C;

	int nret;
	Buffer_bo fdgn;
	pUFD pufd;
	u8int tipo;
	double minX[6],max,maxuor,maxdgn,redondo,origenaux;
	double absx;
	bint signo;
	s8int dec;
	double ddX,lT,rC,slC;
	bint bsemilla;

	nret=comprueba_y_abre_fichero(&fdgn,'b',ficherodgn,base,mensaje,idioma);
	if(nret) return nret;

	transf_dgn dgn;
	global->_dgn=&dgn;
	pint=base;

	if(_O->fsemilla!=NULL && _O->fsemilla[0]!='\0') bsemilla=true;
	else bsemilla=false;
	if(bsemilla){
		nret=obtiene_valores_fsemilla(_O->fsemilla,d3,&dgn);
		if(nret){
error_semilla:
			boclose(&fdgn);
			if(nret==1){
				nret=4; wcscpy(mensaje,u"El fichero semilla no existe o no se puede abrir para leer.\n\nProbablemente esté abierto por otra aplicación que no permite su apertura por otros programas");
			}else{
				if(nret<10 || nret>12){
					wcscpy(mensaje,u"Error desconocido en el archivo semilla");
					nret=6;
				}else{
					if(nret==10 || nret==12) wcscpy(mensaje,u"El fichero semilla no es un fichero de Dgn válido");
					elif(nret==11){
						if(d3) wcscpy(mensaje,u"Se iba a exportar a 3D pero el fichero semilla es 2D");
						else wcscpy(mensaje,u"Se iba a exportar a 2D pero el fichero semilla es 3D");
					}
					nret=5;
				}
			}
			return nret;
		}
	}else{
		dec=get_byte0(base)>>5;
		dgn.kuor=1; dontimes(dec,) dgn.kuor*=10;
	}

	pint++;
	{double *ptr=minX; dontimes(6,) *ptr++=*pdbl++;}

	max=minX[1]-minX[0];
	{double aux=minX[3]-minX[2]; if(aux>max) max=aux;}
	if(d3){
	  double aux=minX[5]-minX[4];
	  if(aux>max) max=aux;
	}
	maxdgn=2.0*0x7ffffff0;		//Pequeño margen de seguridad
	if(max>maxdgn){
		switch(idioma){
			case 1:  wcscpy(mensaje,u"The coordinates range is too large for dgn files"); break;
			case 2:  wcscpy(mensaje,u"L'intervalo di coordinate è troppo esteso per un file dgn"); break;
			default:wcscpy(mensaje,u"El intervalo de coordenadas es demasiado amplio\n           para un fichero dgn");
		}
		return 3;
	}

	if(bsemilla){
		double aux;
		max=minX[0]-dgn.origenXuor;
		aux=minX[1]-dgn.origenXuor;	if(aux>max) max=aux;
		aux=minX[2]-dgn.origenYuor;	if(aux>max) max=aux;
		aux=minX[3]-dgn.origenYuor;	if(aux>max) max=aux;
		if(d3){
			aux=minX[4]-dgn.origenZuor;	if(aux>max) max=aux;
			aux=minX[5]-dgn.origenZuor;	if(aux>max) max=aux;
		}
		maxuor=max*dgn.kuor;
		if(maxuor>=0x80000000UL){
			do{dgn.kuor=(uint)(dgn.kuor*0.1); maxuor=max*dgn.kuor;
			}while(maxuor>=0x80000000UL);
			if(dgn.kuor==0) dgn.kuor=1;
			dgn.origenXuor=dgn.origenX*dgn.kuor;
			dgn.origenYuor=dgn.origenY*dgn.kuor;
			dgn.origenZuor=dgn.origenZ*dgn.kuor;
		}
		dec=2;	//just a value !=7
	}elif(dec==7){
		if(max==0) max=1;
		double aux=maxdgn/max;
		s8int decO=log10n(aux);
		dgn.kuor=1;	dontimes(decO,) dgn.kuor*=10;
	}else{
		double aux=minX[1];
		if(minX[3]>aux) aux=minX[3];
		if(-minX[0]>aux) aux=-minX[0];
		if(-minX[2]>aux) aux=-minX[2];
		if(d3){
		  if(minX[5]>aux) aux=minX[5];
		  if(-minX[4]>aux) aux=-minX[4];
		}
		maxuor=aux*dgn.kuor;
		if(maxuor<0x80000000UL){
			dgn.origenXuor=dgn.origenX=0;
			dgn.origenYuor=dgn.origenY=0;
			dgn.origenZuor=dgn.origenZ=0;
		}else{
			max*=dgn.kuor;
			if(max>maxdgn){
				double aux=max/maxdgn;
				s8int decO=log10n(aux)+1;
				dec-=decO;
				dgn.kuor=1; dontimes(dec,) dgn.kuor*=10;
		}	}//fin podemos poner el origen en 0 (maxuor<)
	}//Fin dec<7
	if(dec==7 || maxuor>=0x80000000UL){	//Hay que buscar un origen
		double aux;
		maxdgn/=2;
		dgn.origenXuor=0.5*(minX[0]+minX[1])*dgn.kuor;
		dgn.origenYuor=0.5*(minX[2]+minX[3])*dgn.kuor;
		if(d3) dgn.origenZuor=0.5*(minX[4]+minX[5])*dgn.kuor;

		aux=minX[1];
		if(-minX[0]>aux) aux=-minX[0];
		maxuor=aux*dgn.kuor;
		if(maxuor<0x80000000UL){
			dgn.origenXuor=dgn.origenX=0;
		}else{
			//Buscamos un origen redondo para la X
			s8int decO=(s8int)log10n(dgn.origenXuor);
			if(decO<0) decO=0;
			absx=dgn.origenXuor; if(absx<0) absx=-absx;
			if(dgn.origenXuor<0) signo=1; else signo=0;
			for(;decO;decO--){
				double aux;
				redondo=1; dontimes(decO,) redondo*=10;	//Hacemos esto en cada iteración en lugar de ir dividiendo por 10 para conservar la redondez
				origenaux=0;
				for(;origenaux<absx;origenaux+=redondo);
				aux=origenaux-dgn.origenXuor;
				if(redondo-aux<aux) origenaux-=redondo;
				//combrobación
				if(signo) origenaux=-origenaux;
				max=minX[1]*dgn.kuor-origenaux;
				aux=origenaux-minX[0]*dgn.kuor;
				if(aux>max) max=aux;
				if(max<maxdgn) break;
			}
			if(decO==0) origenaux=0;	//garantizado por el margen de seguridad (aunque ya sería mala suerte)
			dgn.origenXuor=origenaux;
			dgn.origenX=origenaux/dgn.kuor;
		}

		aux=minX[3];
		if(-minX[2]>aux) aux=-minX[2];
		maxuor=aux*dgn.kuor;
		if(maxuor<0x80000000UL){
			dgn.origenYuor=dgn.origenY=0;
		}else{
			//Buscamos un origen redondo para la Y
			s8int decO=log10n(dgn.origenYuor);
			if(decO<0) decO=0;
			absx=dgn.origenYuor; if(absx<0) absx=-absx;
			if(dgn.origenYuor<0) signo=1; else signo=0;
			for(;decO;decO--){
				double aux;
				redondo=1; dontimes(decO,) redondo*=10;	//Hacemos esto en cada iteración en lugar de ir dividiendo por 10 para conservar la redondez
				origenaux=0;
				for(;origenaux<absx;origenaux+=redondo);
				aux=origenaux-dgn.origenYuor;
				if(redondo-aux<aux) origenaux-=redondo;
				//combrobación
				if(signo) origenaux=-origenaux;
				max=minX[3]*dgn.kuor-origenaux;
				aux=origenaux-minX[2]*dgn.kuor;
				if(aux>max) max=aux;
				if(max<maxdgn) break;
			}
			if(decO==0) origenaux=0;	//garantizado por el margen de seguridad (aunque ya sería mala suerte)
			dgn.origenYuor=origenaux;
			dgn.origenY=origenaux/dgn.kuor;
		}

		aux=minX[5];
		if(-minX[4]>aux) aux=-minX[4];
		maxuor=aux*dgn.kuor;
		if(!d3 || maxuor<0x80000000UL){
			dgn.origenZuor=dgn.origenZ=0;
		}else{
			//Buscamos un origen redondo para la Z
			s8int decO=(s8int)log10n(dgn.origenZuor);
			if(decO<0) decO=0;
			absx=dgn.origenZuor; if(absx<0) absx=-absx;
			if(dgn.origenZuor<0) signo=1; else signo=0;
			for(;decO;decO--){
				double aux;
				redondo=1;
				dontimes(decO,) redondo*=10;	//Hacemos esto en cada iteración en lugar de ir dividiendo por 10 para conservar la redondez
				origenaux=0;
				for(;origenaux<absx;origenaux+=redondo);
				aux=origenaux-dgn.origenZuor;
				if(redondo-aux<aux) origenaux-=redondo;
				//combrobación
				if(signo) origenaux=-origenaux;
				max=minX[5]*dgn.kuor-origenaux;
				aux=origenaux-minX[4]*dgn.kuor;
				if(aux>max) max=aux;
				if(max<maxdgn) break;
			}
			if(decO==0) origenaux=0;	//garantizado por el margen de seguridad (aunque ya sería mala suerte)
			dgn.origenZuor=origenaux;
			dgn.origenZ=origenaux/dgn.kuor;
		}
	}

	estado=0;
	if(bsemilla){
		uint obligatorios=0;	//flags con los elementos necesarios que ya están escritos:	9,8,10
		uint tipo;
		FILE *fgraf=NULL;
		fgraf=_wfopen(_O->fsemilla,u"rb");
		if(fgraf==NULL){nret=1; goto error_semilla;}
		fread(&tipo,usizeof(uint),1,fgraf);
		tipo>>=16;	//palabras que siguen
		if(tipo&1){
			fclose(fgraf); nret=9; goto error_semilla;
		}
		tipo>>=1;
		Elemento9(&fdgn,d3,minX[0],minX[1],minX[2],minX[3],minX[4],minX[5],&dgn,&ddX);
		obligatorios=1;
		nret=fseek(fgraf,tipo*usizeof(uint),SEEK_CUR);
		if(nret){fclose(fgraf); nret=12; goto error_semilla;}

		nret=copy_file_not9(&fdgn,fgraf);
		fclose(fgraf);
		if(nret) goto error_semilla;
	}else{
		Elemento9(&fdgn,d3,minX[0],minX[1],minX[2],minX[3],minX[4],minX[5],&dgn,&ddX);
		Elemento8(&fdgn,d3);
		Elemento10(&fdgn);
		if(!d3){
		  Elemento9bis(&fdgn,d3);
		  Elemento5_2(&fdgn,d3);
		}else{
		  Elemento5_2(&fdgn,d3);
		  Elemento9bis(&fdgn,d3);
		}
		Elemento42_17(&fdgn);
	}

	Elm_hdr ehdr;
	global->_pehdr=&ehdr;
	  set_bytes01((uint*)&ehdr,0);	//Así también ponemos a cero el bit reservado
	  if(!d3){
		  ehdr.zlow=0;
		  ehdr.zhigh=0xFFFFFFFF;
	  }

	Disp_hdr dhdr;
	global->_pdhdr=&dhdr;
	  dhdr.prologo=0;
	  *(uint*)&dhdr.props.str=0;
	  dhdr.props.str.n=1;
	  //dhdr.props.str.style=0;
	  //dhdr.props.str.weight=0;
	  //dhdr.props.str.color=0;

	  if(!bsemilla) Elemento5(&fdgn,d3,&ehdr,&dhdr);

	//Buscamos un polígono para ver cuánto mide, para deducir
	aux=ddX;//el tamaño de exportación de los elementos puntuales
	for(EntradaTablaElems *pinfoelem=grafico.fgrafico->tabla_elementos.ppio;pinfoelem->pos!=0;pinfoelem++){
		if(pinfoelem->pos==Gra_NODATA) continue;
		GraElementoGenerico *pelem=(GraElementoGenerico*)(grafico.otherdata->bloque_grafico_interno+pinfoelem->pos);
		if(mask_tipo(pelem->H.Tipo)==CGRA_Poligono){
			aux=pelem->H.bound.Σ[0][0]+pelem->H.bound.Σ[1][1]+pelem->H.bound.Σ[2][2];
			aux=sqrtf((float)(aux/3.0));
			break;
		}
	}
	aux/=16;
	lT=ddX/149.0;
	if(aux<lT) lT=aux;
	else if(aux<0.1*lT) aux=0.1*lT;
	rC=lT/3.5;
	slC=lT/2.8;

	pint=base+13;
	for(tipo=get_byte0(pint);tipo!=255;tipo=get_byte0(pint)){
		if(tamanno<=(pdif)(pint-base)) break;
		switch(tipo){
			case 8: dgn_foto(&fdgn,pint,d3,global); break;
			case 0: dgn_puntoM(&fdgn,pufd,d3,global,rC); break;
			case 1: dgn_puntoA(&fdgn,pufd,d3,global,lT,slC); break;
			case 2: dgn_elipse(&fdgn,pufd,d3,global); break;
			case 3: dgn_segmento(&fdgn,pufd,d3,global); break;
			case 4: dgn_elipsoide(&fdgn,pufd,d3,global); break;
		}
//continuaprov:
		pint+=1+get_bytes23(pint);
	}

//salirprov:
	if(estado) boput_1616((&fdgn),0xFFFF,reminder);
	boput_32((&fdgn),Я);
	//Completar hasta medio Kb (2^7 uints)
	u8int resto=(u8int)((fdgn.ptr-fdgn.base)&0x7F);
	if(resto!=0){
		resto=0x80-resto;
		oneset_uint(fdgn.ptr,resto);
		fdgn.ptr+=resto;
	}
	boclose(&fdgn);
	return 0;
}

#undef C
#undef Global
