﻿//Compile with /J
#include "elemento_digi.c"

typedef struct{
	uint kunidad;
	u16int puntoselipse;
	float altura_textos;
}OpcionesDigi;
struct CoordInfo : TerrenoaInterno{
	Puntoxy_double Offset;
};

struct Global_bin{
	LinkedGrupoFormas* formas;
	OpcionesDigi* _O;
};

/********  Principio de los elementos del dibujo ***********/
void bin_texto(Buffer_bo* fbin, double x, double y, double z, char8_t* texto, u8int nmax, OpcionesDigi* O, TIPO_DAT* cabecera, u8int pos=0, float escala=1){
	TIPO_MINMAX max;
	ATR* atr=0;
	union{
		LPOINT3D* pcoor;
		char8_t* coor_y_t;
	}coorT;
	char8_t* ptexto;
	ssint offsetx, offsety;

	coorT.pcoor=new LPOINT3D[nmax/usizeof(LPOINT3D) + DESP_TEXT + 1];
	ptexto=(char8_t*)(coorT.pcoor+DESP_TEXT);

	cabecera->tipo[0]='T';
	cabecera->tipo[1]='=';
	cabecera->natr=0;
	cabecera->npuntos=1;

	max.xlib=(ssint)(O->altura_textos*O->kunidad*escala);
	if(max.xlib<2) max.xlib=2;
	max.ylib=pos;
	max.zlib=max.xlib>>1;

	if(pos<3) offsetx=max.zlib;
	elif(pos>=4 && pos<7) offsetx=-max.zlib;
	else offsetx=0;
	if(pos>=2 && pos<5) offsety=-max.zlib;
	elif(pos==1 || pos==5 || pos==8) offsety=0;
	else offsety=max.zlib;
	max.zlib=0;

	if(offsetx==0) offsety+=(offsety>>2)+(offsety>>3);
	elif(offsety==0) offsetx+=(offsetx>>2)+(offsetx>>3);

	coorT.pcoor->x=(ssint)(x*O->kunidad)+offsetx;
	coorT.pcoor->y=(ssint)(y*O->kunidad)+offsety;
	coorT.pcoor->z=(ssint)(z*O->kunidad);

	strncpy(ptexto,texto,nmax);
	ptexto[nmax-1]='\0';

	guarda_entidad(fbin,cabecera,&max,coorT.pcoor,atr);
	delete[] coorT.pcoor;
}
#define pTc global->_pTc
#define C global->_C
#define O global->_O

void bin_foto(Buffer_bo* fbin,pUFD pufd,Global* global){
	TIPO_DAT cabecera;
	TIPO_MINMAX max;
	LPOINT3D coor[13];
	ATR* atr=0;
	uint* pbase;

	Puntoxy_double p;
	double xc,yc,zc,xc_e,yc_e,zc_e;
	double xesc[36];
	double escala=C->Cfotogramas.escala;

	cabecera.tipo[0]='C';
	cabecera.tipo[1]='=';
	*(int*)((char8_t*)&cabecera.cod+3)=0;
	memcpy(cabecera.cod,"foto\0\0",7);
	cabecera.natr=0;
	zeroset(&max,usizeof(TIPO_MINMAX));

	pbase=pint;
	pint+=14;
	skip_nombre(pint);
	p.x=*pdbl++;
	p.y=*pdbl++;
	zc=*pdbl++;
	if(pTc!=NULL) p=terreno_a_interno(p.x,p.y,pTc)+pTc->Offset;
	xc=p.x;
	yc=p.y;
	uint n=get_bytes01(pint); pint++;
	cabecera.npuntos=n+1;
	zc_e=yc_e=xc_e=0;
	for(uint j=0;j<3*n;){
		p.x=*pdbl++;
		p.y=*pdbl++;
		if(pTc!=NULL) p=terreno_a_interno(p.x,p.y,pTc)+pTc->Offset;
		xc_e+=p.x;	xesc[j++]=p.x;
		yc_e+=p.y;	xesc[j++]=p.y;
		zc_e+=*pdbl;
		xesc[j++]=*pdbl++;
	}
	xc_e/=n;
	yc_e/=n;
	zc_e/=n;
	xc_e*=(1-escala);
	yc_e*=(1-escala);
	zc_e*=(1-escala);
	for(uint j=0;j<3*n;){
		xesc[j++]=escala*xesc[j]+xc_e;
		xesc[j++]=escala*xesc[j]+yc_e;
		xesc[j++]=escala*xesc[j]+zc_e;
	}

	pdbl=xesc;
	fordowni(n+1,){
		if(i==0) pdbl-=3*n;
		coor[i].x=(ssint)(*pdbl*O->kunidad); pdbl++;
		coor[i].y=(ssint)(*pdbl*O->kunidad); pdbl++;
		coor[i].z=(ssint)(*pdbl*O->kunidad); pdbl++;
	}

	guarda_entidad(fbin,&cabecera,&max,coor,atr);

	//centro
	cabecera.cod[0]='c'; cabecera.cod[1]='p';
	cabecera.cod[2]='\0'; cabecera.cod[3]='\0';
	cabecera.natr=0;
	cabecera.npuntos=1;
	zeroset(&max,usizeof(TIPO_MINMAX));
	coor[0].x=(ssint)(xc*O->kunidad);
	coor[0].y=(ssint)(yc*O->kunidad);
	coor[0].z=(ssint)(zc*O->kunidad);
	guarda_entidad(fbin,&cabecera,&max,coor,atr);

	//texto
	cabecera.cod[0]='T';
	cabecera.cod[1]='f'; cabecera.cod[2]='o';
	cabecera.cod[3]='t'; cabecera.cod[4]='o';
	pint=pbase+14;
	bin_texto(fbin,xc,yc,zc,(char8_t*)(pint+1),set_byte0(pint)<<2,O,&cabecera,7);
	return;
}

void bin_unpunto(Buffer_bo* fbin,pUFD pufd,Global* global,TIPO_DAT* cabecera){	//Cabecera con el código relleno
	TIPO_MINMAX max;
	LPOINT3D coor;
	ATR* atr=0;
	Puntoxy_double p;

	cabecera->tipo[0]='C'; cabecera->tipo[1]='=';
	cabecera->natr=0;
	cabecera->npuntos=1;
	zeroset(&max,usizeof(TIPO_MINMAX));

	pint+=2;
	p.x=*pdbl; pdbl+=2;
	p.y=*pdbl; pdbl+=2;
	if(pTc!=NULL) p=terreno_a_interno(p.x,p.y,pTc)+pTc->Offset;
	coor.x=(ssint)(p.x*O->kunidad);
	coor.y=(ssint)(p.y*O->kunidad);
	coor.z=(ssint)(*pdbl*O->kunidad);

	guarda_entidad(fbin,cabecera,&max,&coor,atr);
}
void bin_textopunto(Buffer_bo* fbin,pUFD pufd,Global* global,TIPO_DAT* cabecera, u8int pos=0, float escala=1){	//Cabecera con el código relleno
	double z;
	Puntoxy_double p;

	pint+=2;
	p.x=*pdbl;	pdbl+=2;
	p.y=*pdbl;	pdbl+=2;
	z=*pdbl;		pdbl+=2;
	if(pTc!=NULL) p=terreno_a_interno(p.x,p.y,pTc)+pTc->Offset;
	bin_texto(fbin,p.x,p.y,z,(char8_t*)(pint+1),set_byte0(pint)<<2,O,cabecera,pos,escala);
}

void bin_puntoAc(Buffer_bo* fbin,pUFD pufd,Global* global){
	TIPO_DAT cabecera;

	memcpy(cabecera.cod,"pAc\0\0\0",7);
	bin_unpunto(fbin,pufd,global,&cabecera);

	cabecera.cod[0]='T';
	cabecera.cod[1]='p'; cabecera.cod[2]='A';
	cabecera.cod[3]='c';
	bin_textopunto(fbin,pufd,global,&cabecera);
}
void bin_puntoAi(Buffer_bo* fbin,pUFD pufd,Global* global){
	TIPO_DAT cabecera;

	memcpy(cabecera.cod,"pAi\0\0\0",7);
	bin_unpunto(fbin,pufd,global,&cabecera);

	cabecera.cod[0]='T';
	cabecera.cod[1]='p'; cabecera.cod[2]='A';
	cabecera.cod[3]='i';
	bin_textopunto(fbin,pufd,global,&cabecera);
}
void bin_puntoCc(Buffer_bo* fbin,pUFD pufd,Global* global){
	TIPO_DAT cabecera;

	memcpy(cabecera.cod,"pCc\0\0\0",7);
	bin_unpunto(fbin,pufd,global,&cabecera);

	cabecera.cod[0]='T';
	cabecera.cod[1]='p'; cabecera.cod[2]='C';
	cabecera.cod[3]='c';
	bin_textopunto(fbin,pufd,global,&cabecera);
}
void bin_puntoCi(Buffer_bo* fbin,pUFD pufd,Global* global){
	TIPO_DAT cabecera;

	memcpy(cabecera.cod,"pCi\0\0\0",7);
	bin_unpunto(fbin,pufd,global,&cabecera);

	cabecera.cod[0]='T';
	cabecera.cod[1]='p'; cabecera.cod[2]='C';
	cabecera.cod[3]='i';
	bin_textopunto(fbin,pufd,global,&cabecera);
}

void bin_puntoA(Buffer_bo* fbin,pUFD pufd,Global* global){
	u8int subtipo,l;

	subtipo=set_byte1(pint);
	if((l=subtipo&007)!=0){
		if(l==7) bin_puntoAc(fbin,pufd,global);
		else bin_puntoAi(fbin,pufd,global);
	}elif((l=(subtipo&070)>>3)){
		if(l==7) bin_puntoCc(fbin,pufd,global);
		else bin_puntoCi(fbin,pufd,global);
	}
}

void bin_puntoM(Buffer_bo* fbin,pUFD pufd,Global* global){
	TIPO_DAT cabecera;

	memcpy(cabecera.cod,"p\0\0\0\0\0",7);
	bin_unpunto(fbin,pufd,global,&cabecera);

	cabecera.cod[0]='T';
	cabecera.cod[1]='p';
	bin_textopunto(fbin,pufd,global,&cabecera,0,0.8F);
}

void bin__elipse(ssint x,ssint y,ssint z,float sx,float sxy,float sy,u8int orientacion,u16int npuntos,LPOINT3D* coor){
	float a,b,c,d;
	float tt,delta;
	float cost,sint;
	ssint qx,qy;
	LPOINT3D* pcoor;

	//Está programada de manera que para t=0 se obtiene el semieje
	varianzas_a_matriz(sx,sxy,sy,&a,&b,&c,&d);

	tt=0;
	delta=PI2_FL/npuntos;
	pcoor=coor;
	cint i;
	for(i=npuntos;i--;tt+=delta,pcoor++){
		cost=cos(tt);
		sint=sin(tt);
		qx=(ssint)(a*cost+b*sint);
		qy=(ssint)(c*cost+d*sint);
t0:		switch(orientacion){
		 case 1:
			pcoor->x=x;
			pcoor->y=x+qx;
			pcoor->z=y+qy;
		 case 2:
			pcoor->y=y;
			pcoor->z=x+qx;
			pcoor->x=y+qy;
		 default:
			pcoor->z=z;
			pcoor->x=x+qx;
			pcoor->y=y+qy;
		}
	}
	if(npuntos){
		qx=(ssint)a; qy=(ssint)c;
		i=0;
		npuntos=0;
		goto t0;
	}
}
void bin_elipse(Buffer_bo* fbin,pUFD pufd,Global* global){
	TIPO_DAT cabecera;
	TIPO_MINMAX max;
	LPOINT3D* coor;
	ATR* atr=0;

	u8int subtipo,orientacion;
	Puntoxy_double p;
	ssint x,y,z;
	float escala;
	float sx,sxy,sy;

	cabecera.tipo[0]='C'; cabecera.tipo[1]='=';
	zeroset(cabecera.cod,7);
	cabecera.cod[0]='e';
	cabecera.natr=0;
	cabecera.npuntos=O->puntoselipse+1;
	zeroset(&max,usizeof(TIPO_MINMAX));
	coor=new LPOINT3D[cabecera.npuntos];

	subtipo=set_byte1(pint);
	if(subtipo==0){
		cabecera.cod[1]='c';
		escala=C->Cprecisionescp.Celipse.escala;
	}else{
		cabecera.cod[1]='p';
		escala=C->CprecisionespM.Celipse.escala;
	}

	pint+=14;
	skip_nombre(pint);

	p.x=*pdbl++;
	p.y=*pdbl++;
	if(pTc!=NULL) p=terreno_a_interno(p.x,p.y,pTc)+pTc->Offset;
	x=(ssint)(p.x*O->kunidad);
	y=(ssint)(p.y*O->kunidad);
	z=(ssint)(*pdbl*O->kunidad); pdbl++;
	orientacion=set_byte0(pint); pint++;
	switch(orientacion){
	 case 1:
		cabecera.cod[2]='Y';
		cabecera.cod[3]='Z';
		break;
	 case 2:
		cabecera.cod[2]='Z';
		cabecera.cod[3]='X';
		break;
	 default:
		cabecera.cod[2]='X';
		cabecera.cod[3]='Y';
	}

	sx=*psingle++;
	sxy=*psingle++;
	sy=*psingle++;
	escala*=(float)O->kunidad;
	escala*=escala;
	sx*=escala; sxy*=escala; sy*=escala;

	bin__elipse(x,y,z,sx,sxy,sy,orientacion,cabecera.npuntos-1,coor);
	guarda_entidad(fbin,&cabecera,&max,coor,atr);
	delete[] coor;
}
void bin_segmento(Buffer_bo* fbin,pUFD pufd,Global* global){
	TIPO_DAT cabecera;
	TIPO_MINMAX max;
	LPOINT3D coor[2];
	ATR* atr=0;

	u8int subtipo;
	Puntoxy_double p;
	float escala;
	float dx,dy,dz;
	ssint x,y,z,dnx,dny,dnz;

	cabecera.tipo[0]='C'; cabecera.tipo[1]='=';
	zeroset(cabecera.cod,7);
	cabecera.cod[0]='s';
	cabecera.natr=0;
	cabecera.npuntos=2;
	zeroset(&max,usizeof(TIPO_MINMAX));

	subtipo=set_byte1(pint);
	if(subtipo==0){
		cabecera.cod[1]='c';
		escala=C->Cprecisionescp.Csegmento.escala;
	}else{
		cabecera.cod[1]='p';
		escala=C->CprecisionespM.Csegmento.escala;
	}

	pint+=14;
	skip_nombre(pint);

	p.x=*pdbl++;
	p.y=*pdbl++;
	if(pTc!=NULL) p=terreno_a_interno(p.x,p.y,pTc)+pTc->Offset;
	x=(ssint)(p.x*O->kunidad);
	y=(ssint)(p.y*O->kunidad);
	z=(ssint)(*pdbl*O->kunidad); pdbl++;

	dx=*psingle++;	dnx=(ssint)(dx*escala*O->kunidad);
	dy=*psingle++;	dny=(ssint)(dy*escala*O->kunidad);
	dz=*psingle++;	dnz=(ssint)(dz*escala*O->kunidad);
	if(dnz!=0) cabecera.cod[2]='Z';
	elif(dnx!=0) cabecera.cod[2]='X';
	else cabecera.cod[2]='Y';

	coor[0].x=x-dnx;
	coor[0].y=y-dny;
	coor[0].z=z-dnz;
	coor[1].x=x+dnx;
	coor[1].y=y+dny;
	coor[1].z=z+dnz;
	guarda_entidad(fbin,&cabecera,&max,coor,atr);
}

void bin_elipsoide(Buffer_bo* fbin,pUFD pufd,Global* global){
	TIPO_DAT cabecera;
	TIPO_MINMAX max;
	LPOINT3D* coor;
	ATR* atr=0;

	u8int subtipo;
	Puntoxy_double p;
	float escala;
	float sx,sxy,sy,sz;
	ssint x,y,z,dz;

	cabecera.tipo[0]='C'; cabecera.tipo[1]='=';
	zeroset(cabecera.cod,7);
	cabecera.natr=0;
	cabecera.npuntos=2;

	subtipo=set_byte1(pint);
	if(subtipo==0){
		cabecera.cod[1]='c';
		escala=C->Cprecisionescp.Csegmento.escala;
	}else{
		cabecera.cod[1]='p';
		escala=C->CprecisionespM.Csegmento.escala;
	}

	pint+=14;
	skip_nombre(pint);

	p.x=*pdbl++;
	p.y=*pdbl++;
	if(pTc!=NULL) p=terreno_a_interno(p.x,p.y,pTc)+pTc->Offset;
	x=(ssint)(p.x*O->kunidad);
	y=(ssint)(p.y*O->kunidad);
	z=(ssint)(*pdbl*O->kunidad); pdbl++;

	sx=*psingle++;
	sxy=*psingle++;
	sy=*psingle; psingle+=3;
	sz=*psingle++;
	escala*=(float)O->kunidad;

	//segmento
	cabecera.cod[0]='s';
	cabecera.cod[2]='Z'; cabecera.cod[3]=0;
	cabecera.npuntos=2;
	zeroset(&max,usizeof(TIPO_MINMAX));

	sz=sqrt(sz);
	dz=(ssint)(sz*escala);
	coor[0].x=x;
	coor[0].y=y;
	coor[0].z=z-dz;
	coor[1].x=x;
	coor[1].y=y;
	coor[1].z=z+dz;

	guarda_entidad(fbin,&cabecera,&max,coor,atr);

	//elipse
	escala*=escala;
	sx*=escala; sxy*=escala; sy*=escala;

	cabecera.cod[0]='e';
	cabecera.cod[2]='X'; cabecera.cod[3]='Y';
	cabecera.npuntos=O->puntoselipse+1;
	zeroset(&max,usizeof(TIPO_MINMAX));
	coor=new LPOINT3D[cabecera.npuntos];

	bin__elipse(x,y,z,sx,sxy,sy,0,cabecera.npuntos-1,coor);
	guarda_entidad(fbin,&cabecera,&max,coor,atr);

	delete[] coor;
}

void bin_residuoxy(Buffer_bo* fbin,pUFD pufd,Global* global){
	TIPO_DAT cabecera;
	TIPO_MINMAX max;
	LPOINT3D coor[2];
	ATR* atr=0;

	u8int subtipo;
	Puntoxy_double p;
	float escala;

	cabecera.tipo[0]='C'; cabecera.tipo[1]='=';
	memcpy(cabecera.cod,"res\0\0\0",7);
	cabecera.natr=0;
	cabecera.npuntos=2;

	subtipo=set_byte1(pint);
	pint+=2;
	coor[1].z=coor[0].z=(ssint)(*(pdbl+4)*O->kunidad);

	if(subtipo==1){
		memcpy(cabecera.cod,"dist\0\0",7);
		escala=C->Cdistorsion.segmento.escala;
	}else{
		cabecera.cod[3]='f';
		escala=C->Cresiduof.segmento.escala;
	}
	escala*=O->kunidad;
	zeroset(&max,usizeof(TIPO_MINMAX));

	pint+=12;
	skip_nombre(pint);

	p.x=*pdbl++;
	p.y=*pdbl; pdbl+=2;
	if(pTc!=NULL) p=terreno_a_interno(p.x,p.y,pTc)+pTc->Offset;
	coor[0].x=(ssint)(p.x*O->kunidad);
	coor[0].y=(ssint)(p.y*O->kunidad);

	coor[1].x=coor[0].x+(ssint)(*psingle*escala); psingle++;
	coor[1].y=coor[0].y+(ssint)(*psingle*escala);

	guarda_entidad(fbin,&cabecera,&max,coor,atr);
}
void bin_residuoXYZ(Buffer_bo* fbin,pUFD pufd,Global* global){
	TIPO_DAT cabecera;
	TIPO_MINMAX max;
	LPOINT3D coor[2];
	ATR* atr=0;

	u8int subtipo;
	Puntoxy_double p;
	float escala;

	cabecera.tipo[0]='C'; cabecera.tipo[1]='=';
	memcpy(cabecera.cod,"res\0\0\0",7);
	cabecera.natr=0;
	cabecera.npuntos=2;

	subtipo=set_byte1(pint);

	if(subtipo==0){
		cabecera.cod[3]='c';
		cabecera.cod[4]='P';
		escala=C->CresiduocpP.segmento.escala;
	}elif(subtipo==1){
		cabecera.cod[3]='c';
		cabecera.cod[4]='G';
		escala=C->CresiduocpG.escala;
	}elif(subtipo==2){
		cabecera.cod[3]='p';
		cabecera.cod[4]='A';
		escala=C->CresiduopA.segmento.escala;
	}else{
		cabecera.cod[3]='p';
		if(subtipo==3) cabecera.cod[4]='C';
		escala=C->CresiduopC.segmento.escala;
	}
	escala*=O->kunidad;
	zeroset(&max,usizeof(TIPO_MINMAX));

	pint+=14;
	skip_nombre(pint);

	p.x=*pdbl++;
	p.y=*pdbl++;
	if(pTc!=NULL) p=terreno_a_interno(p.x,p.y,pTc)+pTc->Offset;
	coor[0].x=(ssint)(p.x*O->kunidad);
	coor[0].y=(ssint)(p.y*O->kunidad);
	coor[0].z=(ssint)(*pdbl*O->kunidad); pdbl++;
	coor[1].x=coor[0].x+(ssint)(*psingle*escala); psingle++;
	coor[1].y=coor[0].y+(ssint)(*psingle*escala); psingle++;
	coor[1].z=coor[0].z+(ssint)(*psingle*escala);

	guarda_entidad(fbin,&cabecera,&max,coor,atr);
}

#undef pTc
int gra_a_bin(char16_t* ficherobin, GraficoCompleto _grafico,OpcionesDigi* _O,char16_t* mensaje,u8int idioma){
	if(base==NULL || tamanno==0) return 0;
	if(idioma>2) idioma=0;

	Global_bin globaL;
	Global_bin* global=&globaL;
	C=_C;		O=_O;

	int nret;
	Buffer_bo fbin;
	pUFD pufd;
	u8int tipo;
	CoordInfo CInf;

	nret=comprueba_y_abre_fichero(&fbin,'b',ficherobin,base,mensaje,idioma);
	ifunlike(nret) return nret;
	grafico=_grafico;

	pint=base;
	pint++;
	CInf.Offset.x=grafico.fgrafico->minmaxI.MX-2*grafico.fgrafico->minmaxI.mx;
	CInf.Offset.y=grafico.fgrafico->minmaxI.MY-2*grafico.fgrafico->minmaxI.my;

	if(!isfinite(O->altura_textos)) O->altura_textos=(float)aux*1.0F;
	if(O->puntoselipse==0 || O->puntoselipse>8000) O->puntoselipse=8000;
	elif(O->puntoselipse<2) O->puntoselipse=2;

	void (*bin_el)(Buffer_bo* fbin,pUFD pufd, Global_bin*);
	pint=base+13;
	for(tipo=set_byte0(pint);tipo!=255;tipo=set_byte0(pint)){
		if(tamanno<=(pdif)(pint-base)) break;
		bin_el=NULL;
		switch(tipo){
			case 8: bin_el=bin_foto; break;
			case 0: bin_el=bin_puntoM; break;
			case 1: bin_el=bin_puntoA; break;
			case 2: bin_el=bin_elipse; break;
			case 3: bin_el=bin_segmento; break;
			case 4: bin_el=bin_elipsoide; break;
			case 6: bin_el=bin_residuoxy; break;
			case 7: bin_el=bin_residuoXYZ; break;
		}
		if(bin_el!=NULL) bin_el(&fbin,pufd,global);
//continuaprov:
		pint+=1+get_bytes23(pint);
	}

//salirprov:
	boflush(&fbin);
	boclose(&fbin);
	return 0;
}

#undef pTc
#undef C
#undef O
