﻿void escribe_info(Bufferto16* b,FConfiguracion *config,const char16_t *configname);
void escribe_ver(Bufferto16* b,FConfiguracion *config);
int escribe_Tipo(Bufferto16*,ConfigTipo *tipo,uint ntipo);
int escribe_Subtipo(Bufferto16* pbuffer, ConfigSubtipo *subtipo, CriterioSubtipo criterio);
void escribe_cualidades(Bufferto16* pbuffer, LinkedQuality *cualidades, u8int ntabs);
static const char16_t* const MarginTabs[]={
	u"",u"\t", u"\t\t",u"\t\t\t", u"\t\t\t\t", u"\t\t\t\t"
};

int escribe_configuracion(const char16_t *filename, FConfiguracion *mconfig, const char16_t *configname){
	int nret;
	Bufferto16 buffer;

	nret=toopen16(&buffer,filename);
	ifunlike(nret) return nret;

	setbuf_relative(&buffer);
	setbuf_limpio(&buffer);
	setbuf_noscientific(&buffer);
	buffer.prec.signi=6;

	escribe_info(&buffer,mconfig,configname);
	escribe_ver(&buffer,mconfig);
	durchHashi(hConfigTipo,mconfig->tipos){
		if(ptri->key==Я) continue;
		toput_char(&buffer,'\n');
		escribe_Tipo(&buffer,&ptri->data,ptri->key);
	}
	toclose(&buffer);
	return buffer.error_code;
}

void escribe_info(Bufferto16* pbuffer,FConfiguracion *config,const char16_t *configname){
	towrite_string(pbuffer,u"\\begin Info\n" u"\tVersion 00");
	if(configname!=NULL){
		towrite_many_strings(pbuffer,u"\n\tNombreConfig ",configname,NULL);
	}
	towrite_string(pbuffer,u"\n\tFondo ");	towrite_aligned_hex(pbuffer,config->fondo,6);
	towrite_string(pbuffer,u"\n\tResalte ");	towrite_aligned_hex(pbuffer,config->resalte,6);
	towrite_string(pbuffer,u"\n\\end\n");
}
void escribe_ver(Bufferto16* pbuffer,FConfiguracion *config){
	bint b;
	towrite_string(pbuffer,u"\\begin Ver\n");
	b=0;
	{durchHashi(huint,config->ver_info.ver){
		if(ptri->val==Я) continue;
		if(!b){towrite_string(pbuffer,u"\tOFF"); b=1;}
		toput_char(pbuffer,' '); towrite_uint(pbuffer,ptri->val);
	}}
	if(b) toput_char(pbuffer,'\n');
	b=0;
	durchHashi(huint,config->ver_info.verT){
		if(ptri->val==Я) continue;
		if(!b){towrite_string(pbuffer,u"\tTON"); b=1;}
		toput_char(pbuffer,' '); towrite_uint(pbuffer,ptri->val);
	}
	if(b) toput_char(pbuffer,'\n');
	towrite_string(pbuffer,u"\\end\n");
}

void escribe_from_clause(Bufferto16 *pbuffer, Quality *q){
	u8int fkind=q->from.kind;

	towrite_string(pbuffer,u"from");
	ifunlike(fkind>=QFrom_MAX) towrite_string(pbuffer,u" Desconocido ");
	else if(fkind==QFrom_this || fkind==QFrom_this_text) towrite_string(pbuffer,u" .");
	else{
		if(QFrom_hasTipo(fkind)){
			uint tipo=mask_tipo(q->from.Tipo);
			if(!tipo_is_especial(tipo)) towrite(pbuffer,'s',u" tipo ", 'u',tipo, 0);
			else{towrite_string(pbuffer,u" tipo 0h"); towrite_hex(pbuffer,tipo);}
		}
		if(QFrom_hasSubtipo(fkind)){towrite(pbuffer,'s',u" subtipo ", 'u',mask_subtipo(q->from.Tipo), 0);}
	}
	if(QFrom_istexto(q->from.kind)) towrite_string(pbuffer,u" texto");
	if(q->nqual!=Q_All && q->fromQ!=Q_None){toput_char(pbuffer,' '); towrite_string(pbuffer,QualityInfos[q->fromQ].name);}
}

void escribe_cualidad_value(Bufferto16 *pbuffer, Quality *q){
	switch(QualityInfos[q->nqual].val_type){
		case QValtype_dec: towrite_uint(pbuffer,q->value.n); break;
		case QValtype_hex: towrite_aligned_hex(pbuffer,q->value.n,6); break;
		case QValtype_float: towrite_float(pbuffer,q->value.fl); break;
		case QValtype_flags:
		{uint n=q->value.n; do{toput_char(pbuffer,'0'+(n&1)); n>>=1;}while(n);}
		break;
		case QValtype_string: towrite_string(pbuffer,(char16_t*)q->value.ptr); break; //value.ptr cannot be NULL
		default: toput_char(pbuffer,'0'); //This should not happen
	}
}

void escribe_cualidad_value_or_from(Bufferto16 *pbuffer, Quality *q){
	if(q->from.kind==QFrom_None) escribe_cualidad_value(pbuffer,q);
	else escribe_from_clause(pbuffer,q);
	toput_char(pbuffer,'\n');
}

static inline void escribe_línea_cualidad(Bufferto16 *pbuffer, Quality *q){
	towrite_stringl(pbuffer,QualityInfos[q->nqual].name,' ');
	escribe_cualidad_value_or_from(pbuffer,q);
}

int escribe_Tipo(Bufferto16* pbuffer, ConfigTipo *tipo, uint ntipo){
	if(!tipo_is_especial(ntipo)) towrite(pbuffer,'s',u"\\begin Tipo ", 'u',ntipo, 0);
	else{towrite_string(pbuffer,u"\\begin Tipo 0h"); towrite_hex(pbuffer,ntipo);}
	toput_char(pbuffer,'\n');

	if(tipo->Significado.string!=NULL){towrite_string(pbuffer,u"Significado "); towrite_stringl(pbuffer,tipo->Significado.string,'\n');}
	if(tipo->SignificadoR.string!=NULL){towrite_string(pbuffer,u"SignificadoR "); towrite_stringl(pbuffer,tipo->SignificadoR.string,'\n');}
	escribe_cualidades(pbuffer,tipo->cualidades,0);

	if(tipo->cualid_texto!=NULL){
		towrite_string(pbuffer,u"\\begin Texto\n");
		escribe_cualidades(pbuffer,tipo->cualid_texto,1);
		towrite_string(pbuffer,u"\\end Texto\n");
	}
	for(LinkedConfigSubtipo *subtipo=tipo->subtipos;subtipo!=NULL;subtipo=subtipo->next){
		escribe_Subtipo(pbuffer,&subtipo->S,subtipo->criterio);
	}
	towrite_string(pbuffer,u"\\end\n");
	return 0;
}

int escribe_Subtipo(Bufferto16* pbuffer, ConfigSubtipo *subtipo, CriterioSubtipo criterio){
	towrite_string(pbuffer,u"\\begin Subtipo ");
	switch(criterio.kind){
		case CriterioSub_Numero:  towrite_uint(pbuffer,criterio.valor.number); break;
		case CriterioSub_Rango: towrite(pbuffer,'s',u"min ", 'u',criterio.valor.number&0xFFFF, 's',u" max ", 'u',criterio.valor.number>>16, 0); break;
		case CriterioSub_Array:
			{durchlaufei(uint,criterio.valor.array,CriterioSub_ArrayLength){
				iflike(*ptri==0) continue;
				uint flags=*ptri;
				uint n=(pdif)(ptri-criterio.valor.array)<<5;
				do{
					if(flags&1) towrite(pbuffer,' ', 'u',n,',', 0);
					flags>>=1, n++;
				}while(flags);
			}}
		case CriterioSub_Ormask: towrite_string(pbuffer,u"mask 0c"); goto write_mask;
		case CriterioSub_Andmask: towrite_string(pbuffer,u"Mask 0c");
		write_mask: towrite(pbuffer, '0'+((criterio.valor.number>>9)&07),'0'+((criterio.valor.number>>6)&07),'0'+((criterio.valor.number>>3)&07),'0'+((criterio.valor.number)&07), 0);
			break;
		default: towrite_uint(pbuffer,criterio.valor.number);
	}
	toput_char(pbuffer,'\n');

	if(subtipo->Significado.string!=NULL){towrite_string(pbuffer,u"\tSignificado "); towrite_stringl(pbuffer,subtipo->Significado.string,'\n');}
	if(subtipo->SignificadoR.string!=NULL){towrite_string(pbuffer,u"\tSignificadoR "); towrite_stringl(pbuffer,subtipo->SignificadoR.string,'\n');}
	escribe_cualidades(pbuffer,subtipo->cualidades,1);
	if(subtipo->cualid_texto!=NULL){
		towrite_string(pbuffer,u"\\begin Texto\n");
		escribe_cualidades(pbuffer,subtipo->cualid_texto,2);
		towrite_string(pbuffer,u"\\end Texto\n");
	}
	towrite_string(pbuffer,u"\\end\n");
	return 0;
}

void escribe_cualidades(Bufferto16* pbuffer, LinkedQuality *cualidades, u8int ntabs){
	u8int Allkind;  //0 no All; 1, All externo; 2, All interno;
	bint escribe_repre;
	const char16_t *tabs=MarginTabs[ntabs++];

	//All externo
	Allkind=0;
	for(LinkedQuality *q=cualidades; q!=NULL; q=q->next){
		iflike(q->q.nqual!=Q_All) continue;
		if(q->q.from.kind!=QFrom_None && q->q.fromQ!=fromQAll_OnlyQualities){
			towrite_many_strings(pbuffer,tabs,u"All ",NULL);
			escribe_from_clause(pbuffer,&q->q); toput_char(pbuffer,'\n');
			Allkind=1;
		}else{
			Allkind=0;
		}
		break;
	}

	if(Allkind==0 || (Allkind==1 && cualidades->next==NULL)) escribe_repre=0;
	else escribe_repre=1; //Solamente se escribe si hay cláusula All y, en caso de que sea externa, hay alguna cualidad más

	if(Allkind==2) Allkind=0; //Sólo se permite una cláusa All. Si hay más que la primera se ignoran
	if(escribe_repre) towrite_many_strings(pbuffer,tabs,u"\\begin Representacion\n",NULL);
	tabs=MarginTabs[ntabs];
	for(LinkedQuality *q=cualidades; q!=NULL; q=q->next){
		ifunlike(q->q.nqual==Q_All){
			ifunlike(Allkind!=0) continue; //Hence, no es 1 porque Allkind=1 arriba no se vuelve a poner a cero.
			Allkind=2;
		}
		towrite_string(pbuffer,tabs); escribe_línea_cualidad(pbuffer,&q->q);
	}
	if(escribe_repre) towrite_many_strings(pbuffer,MarginTabs[ntabs-1],u"\\end Representacion\n",NULL);
}
