bint entra_en_vista(ElementoenVista *pelemv, Vista *vista){
	PuntoXYZ_double P;
	Puntoxy_float p,q;
	P.X=pelemv->minmax.mx;
	P.Y=pelemv->minmax.MY;
	P.Z=pelemv->minmax.MZ;
	p=vista->vista_a_lienzo(P);
	P.X=pelemv->minmax.MX;
	P.Y=pelemv->minmax.my;
	q=vista->vista_a_lienzo(P);
	p.x-=pelemv->max_pixel_width;		p.y-=pelemv->max_pixel_width;
	q.x+=pelemv->max_pixel_width;		q.y+=pelemv->max_pixel_width;
	if(p.x>=vista->ventana.MX || q.x<vista->ventana.mx || p.y>=vista->ventana.MY || q.y<vista->ventana.my) return 0;
	return 1;
}
bint entra_en_vista_texto(ElementoenVista *pelemv, Vista *vista){
	PuntoXYZ_double P;
	Puntoxy_float p,q;
	P.X=pelemv->texto_pos.x;
	P.Y=pelemv->texto_pos.y;
	P.Z=0;
	q=p=vista->vista_a_lienzo(P);
	q=vista->vista_a_lienzo(P);
	p.x-=pelemv->texto_pixel_widths.mx;		p.y-=pelemv->texto_pixel_widths.my;
	q.x+=pelemv->texto_pixel_widths.MX;		q.y+=pelemv->texto_pixel_widths.MY;
	if(p.x>=vista->ventana.MX || q.x<vista->ventana.mx || p.y>=vista->ventana.MY || q.y<vista->ventana.my) return 0;
	return 1;
}

int reajusta_lienzo(Vista *vista, RectVentana *rect){
	ssint offset, offset_y, offset_x;
	Extremos2D_int enlienzo;
	if((uint)rect->ancho>vista->lienzo.ncols || (uint)rect->alto>vista->lienzo.nrows){
		color *nuevo;
		uint ncols, nrows;
		ncols=max((uint)rect->ancho,vista->lienzo.ncols);
		nrows=max((uint)rect->alto,vista->lienzo.nrows);
		nuevo=(color*)realloc(vista->lienzo.matriz,nrows*ncols*usizeof(color));
		if(nuevo==NULL) return AT_NOMEM;
		vista->lienzo.matriz=nuevo;
		if((uint)rect->ancho>vista->lienzo.ncols && vista->lienzo.nrows>1){
			color *ptrb, *ptr;
			offset=rect->ancho-vista->lienzo.ncols;
			ptr=vista->lienzo.matriz+vista->lienzo.nrows*vista->lienzo.ncols-1;
			ptrb=vista->lienzo.matriz+vista->lienzo.nrows*rect->ancho-1;
			dontimes(vista->lienzo.nrows-1,){
				dontimes(offset,*ptrb--=NO_COLOR);
				dontimes(vista->lienzo.ncols,) *ptrb--=*ptr--;
			}
		}
		vista->lienzo.ncols=rect->ancho;
		if((uint)rect->alto>vista->lienzo.nrows){
			colorset_none(vista->lienzo.matriz+vista->lienzo.nrows*rect->ancho,(rect->alto-vista->lienzo.nrows)*rect->ancho);
			vista->lienzo.nrows=rect->alto;
		}
	}
	enlienzo.mx=vista->ventana.mx+rect->x0;
	enlienzo.MX=enlienzo.mx+rect->ancho;
	enlienzo.my=vista->ventana.my+rect->y0;
	enlienzo.MY=enlienzo.my+rect->alto;
	if(enlienzo.my<0) offset_y=-enlienzo.my;
	elif((uint)enlienzo.MY>vista->lienzo.nrows) offset_y=-(ssint)(enlienzo.MY-vista->lienzo.nrows);
	else offset_y=0;
	if(enlienzo.mx<0) offset_x=-enlienzo.mx;
	elif((uint)enlienzo.MX>vista->lienzo.ncols) offset_x=-(ssint)(enlienzo.MX-vista->lienzo.ncols);
	else offset_x=0;

	if(offset_x==0 && offset_y==0) return 0;
	if(vista->desplaza_lienzo(offset_x,offset_y)==0) return 0;
	//Mover la ventana lo mínimo posible a dentro del lienzo
	return vista->desplaza_ventana(-offset_x,-offset_y);
}

struct Globales_dib{
	Extremos2D_int _marco;	//en el sistema lienzo
	Vista *_vista;
	u8int _subpixel;
};
#define Global	Globales_dib
#define marco	gb->_marco
#define vista		gb->_vista
#define Subpixel	gb->_subpixel

#undef Index
#include <windows.h>
struct{
	HDC hdc;
	HBITMAP bitmap;
	BITMAPINFO bitsinfo;
	color *system_matriz;
	LOGFONT font_times;
	HFONT AT_Font_times;
} strWinTexto;
#include "dibuja_texto.h"
#include "Dibuja_genericos.h"

void dibuja_elemento_n(Global *gb, uint n, Gra_LinkedOpcionE *pOE);
#define gb (&globalL)
int dibuja_nuevo(GraficoCompleto _grafico, Vista* _vista, u8int reason, RectVentana rect_in, u8int _subpixel, Gra_LinkedOpcionE *OEhead){
	int nret;

	if(combrueba_grafico(_grafico)) return 1;
	if(_vista==NULL || _vista->graphic_elems.info_elems.ppio==NULL) return 1;
	if(reason==GraDibujar_Especiales && OEhead==NULL) return 0;

	if(reason!=GraDibujar_Especiales){
		if(reason!=GraDibujar_RectIn){
			rect_in.x0=0;	rect_in.ancho=_vista->ventana.MX-_vista->ventana.mx;
			rect_in.y0=0;	rect_in.alto=_vista->ventana.MY-_vista->ventana.my;
		}
		if(rect_in.ancho<=0 || rect_in.alto<=0) return 0;
		nret=reajusta_lienzo(_vista,&rect_in);
		ifunlike(nret==AT_NOMEM) return AT_NOMEM;
		ifunlike(nret==1) return 2;
	}else{
		rect_in.x0=-_vista->ventana.mx;		rect_in.ancho=_vista->lienzo.ncols;
		rect_in.y0=-_vista->ventana.my;		rect_in.alto=_vista->lienzo.nrows;
	}

#pragma region WinTexto
	{strWinTexto.hdc=CreateCompatibleDC(NULL);
	strWinTexto.bitsinfo.bmiHeader.biSize=usizeof(BITMAPINFOHEADER);
	strWinTexto.bitsinfo.bmiHeader.biWidth=100;
	strWinTexto.bitsinfo.bmiHeader.biHeight=-20;
	strWinTexto.bitsinfo.bmiHeader.biPlanes=1;
	strWinTexto.bitsinfo.bmiHeader.biBitCount=CHAR_BIT*usizeof(color);
	strWinTexto.bitsinfo.bmiHeader.biCompression=BI_RGB;
	strWinTexto.bitsinfo.bmiHeader.biSizeImage=20*100*usizeof(color);
	strWinTexto.bitmap=CreateDIBSection(strWinTexto.hdc, &strWinTexto.bitsinfo, DIB_RGB_COLORS, (void**)&strWinTexto.system_matriz, NULL, 0x0);
	ifunlike(strWinTexto.bitmap==NULL) return AT_NOMEM;
	SelectObject(strWinTexto.hdc,strWinTexto.bitmap);

	zeroset_uint(&strWinTexto.font_times,uintsizeof(LOGFONT));
	strWinTexto.font_times.lfHeight=14;
	strWinTexto.font_times.lfWeight=400;
	strWinTexto.font_times.lfOutPrecision=8;
	strWinTexto.font_times.lfQuality=4;
	strWinTexto.font_times.lfCharSet=ANSI_CHARSET;
	strWinTexto.font_times.lfPitchAndFamily=FF_ROMAN;
	strcpy8(strWinTexto.font_times.lfFaceName,"Times New Roman");
	strWinTexto.font_times.lfFaceName[31]='\0';
	strWinTexto.AT_Font_times=CreateFontIndirect(&strWinTexto.font_times);
	SetBkMode(strWinTexto.hdc,TRANSPARENT);
	SetTextAlign(strWinTexto.hdc,TA_BOTTOM | TA_LEFT);}
#pragma endregion

	Global globalL;
	grafico=_grafico;
	vista=_vista;
	Subpixel=_subpixel;
	marco.mx=vista->ventana.mx+rect_in.x0;
	marco.MX=marco.mx+rect_in.ancho;
	marco.my=vista->ventana.my+rect_in.y0;
	marco.MY=marco.my+rect_in.alto;

	if(reason==GraDibujar_AllUnkown){
		color *ptr;
		uint k=vista->lienzo.ncols-vista->ventana.MX;
		colorset_none(vista->lienzo.matriz,vista->ventana.my*vista->lienzo.ncols);
		ptr=vista->lienzo.matriz+vista->ventana.my*vista->lienzo.ncols;
		dontimes(rect_in.alto,ptr+=vista->lienzo.ncols){
			colorset_none(ptr,vista->ventana.mx);
			colorset_color(ptr+vista->ventana.mx,grafico.pconfig->fconfig->fondo,rect_in.ancho);
			colorset_none(ptr+vista->ventana.MX,k);
		}
		k=(vista->lienzo.nrows-vista->ventana.MY)*vista->lienzo.ncols;
		colorset_none(vista->lienzo.matriz+vista->ventana.MY*vista->lienzo.ncols, k);
	}elif(reason==GraDibujar_AllKnown){
		colorset_color(vista->lienzo.matriz,grafico.pconfig->fconfig->fondo,vista->lienzo.ncols*vista->lienzo.nrows);
	}elif(reason==GraDibujar_RectIn){
		color *ptr=vista->lienzo.matriz+marco.my*vista->lienzo.ncols+marco.mx;
		dontimes(rect_in.alto,ptr+=vista->lienzo.ncols)
			colorset_color(ptr,grafico.pconfig->fconfig->fondo,rect_in.ancho);
	}

	if(reason==GraDibujar_Especiales){
		Gra_LinkedOpcionE *pOE=OEhead;
		do{
			dibuja_elemento_n(gb,pOE->oe.elem,pOE);
			uint n=pOE->oe.elem;
			do pOE=pOE->next; while(pOE!=NULL && pOE->oe.elem==n);
		}while(pOE!=NULL);
	}else{
		for(uint *porden=grafico.fgrafico->orden_elementos.ppio;*porden!=0;){
			uint n=*porden++;
			if(n==Gra_NODATA) continue;
			Gra_LinkedOpcionE *pOE=OEhead;
			while(pOE!=NULL && pOE->oe.elem!=n) pOE=pOE->next;
			dibuja_elemento_n(gb,n,pOE);
		}
	}

	DeleteObject(strWinTexto.bitmap);
	DeleteDC(strWinTexto.hdc);
	return 0;
}
#undef gb

void dibuja_elemento_n(Global *gb, uint n, Gra_LinkedOpcionE *pOE){
	EntradaTablaElems* pinfoelem;
	GraElementoGenerico *pelem;
	ElementoenVista *pelemv;
	u8int clase;
	bint bver, bvert;
	void (*dibuja_gen)(Global* ,GraElementoGenerico *pelem,ElementoenVista *pvista, SolvedQualities* concreta,bint bver,bint bvert);

	pinfoelem=grafico.fgrafico->tabla_elementos.ppio+(n-1);
	pelem=(GraElementoGenerico*)(grafico.fgrafico->bloque_grafico.pos+pinfoelem->pos);
	if(mask_apagado(pelem->H.Clase)) return;
	pelemv=vista->graphic_elems.info_elems.ppio+(n-1);

	clase=(u8int)mask_clase(pelem->H.Clase);
	bver=bvert=1;
	if(!Clase_is_escalable(clase) && isfinite(pelemv->max_pixel_width)){
		if(!entra_en_vista(pelemv,vista)) bver=0;
	}
	if(isfinite(pelemv->texto_pos.x) && isfinite(pelemv->texto_pixel_widths.mx)){
		if(!entra_en_vista_texto(pelemv,vista)) bvert=0;
	}
	if(bver) bver=resuelve_ver(pelem,&grafico.pconfig->fconfig->ver_info,pOE,n);
	if(bvert) bvert=resuelve_vert(pelem,&grafico.pconfig->fconfig->ver_info,pOE,n);
	if(!bver && !bvert) return;
	dibuja_gen=NULL;
	switch(mask_clase(pelem->H.Clase)){
		case CGRA_Punto:		dibuja_gen=dibuja_gen_punto; break;
		case CGRA_Poligonal:	dibuja_gen=dibuja_gen_poligonal; break;
		case CGRA_Poligono:	dibuja_gen=dibuja_gen_poligono; break;
		case CGRA_Vector:		dibuja_gen=dibuja_gen_vector; break;
		case CGRA_Poligonal_escalable: dibuja_gen=dibuja_gen_poligonal_escalable; break;
		//case CGRA_Elipse:		dibuja_gen=dibuja_gen_elipse; break;
		case CGRA_Elipsoide:	dibuja_gen=dibuja_gen_elipsoide; break;
	}
	if(dibuja_gen==NULL) return;
	////for the writing of the cfg file
	//{hConfigTipo *pm=geth_hConfigTipo(grafico.pconfig->fconfig.tipos,mask_tipo(pelem->H.Tipo));
	//if(pm==NULL) make_cfg_default(&pm->elem,mask_tipo(pelem->H.Tipo));
	//}
	SolvedQualities *resuelta, *concreta;		//concreta depende de la configuración especial
	get_resuelta_y_concreta(&resuelta,&concreta,pelem,&grafico.pconfig->solved,grafico.pconfig->fconfig,pOE,n);
	if(Clase_is_escalable(clase) && isfinite(pelemv->max_pixel_width)){
		if(GetVar_escala(concreta)==pelemv->escala_minmax){
			if(!entra_en_vista(pelemv,vista)) bver=0;
		}
	}
	dibuja_gen(gb,pelem,pelemv,concreta,bver,bvert);
	libera_resuelta_y_concreta(resuelta,concreta);
}

#undef Global
#undef marco
#undef vista
