﻿//#include <wchar.h>
static const char16_t* const TEXTOSFormas[][3]={
	{u"de definición de formas",u"formas definition",u"di definizione di forme"}, //0
	{u"Error en el fichero de definición de formas: ",u"Error in the formas definition file: ",u"Errore nel file di definizione di forme: "}, //1
	{u"Se esperaba la palabra formas tras \\begin. Se encontró ",u"The word formas was expected behind \\begin, but it was found: ",u"Si apetaba la parola formas dopo \\begin. Si trovò "},//2
	{u"Error mientras se leía la línea encabezada por '",u"Error while reading the line beginning with '",u"Errore mentre si stava a legere la linea che comincia da '"},//3
	{u"Falta información en la cabecera del grupo. Vea la definición del formato del fichero",
	 u"There is missing information in the group header. See the definition of the file format",
	 u"Manca informazione nell'header dell'insieme. Vedi la definizione del formato del file"},//4
	{u"Error en la forma número ",u"Error in the 'forma' number ",u"Errore nella forma numero "},//5
};
static const char8_t* const NombresLineas[]={"numero","limites","centro","uno"};

#define TEXTOf(n)		TEXTOSFormas[n][idioma]

#define S_formas			TEXTOf(0)
#define S_Error_formas	TEXTOf(1)
#define S_Seesperaba_formas		TEXTOf(2)
#define S_Errorenlalinea_de		TEXTOf(3)
#define S_Faltainfo			TEXTOf(4)
#define S_Errorenforma	TEXTOf(5)

int carga_formas(char16_t* fichero_formas, LinkedGrupoFormas **p_list, char16_t* _mensaje, u8int idioma){
	int nret;
	Bufferti8 buffer;

	s8int mc;
	char16_t* pterror;
	char16_t c;
	uint error_n, num;
	*p_list=NULL;

	path_get_filename16(fichero_formas,pterror);
	nret=tiopen_mixed(&buffer,fichero_formas);
	ifunlike(nret<0){
		ifunlike(nret==AT_NOMEM){
			nomemopen_errstr(_mensaje,S_Error_formas,pterror,S_formas,idioma);
			return AT_NOMEM;
		}
		char16_t *pmens=strpcpy16(_mensaje,S_Error_formas);
		open_file_err_str16(nret,pmens,pterror,idioma);
		return ATREAD_NOOPEN;
	}
	pterror=strbuild16(_mensaje,S_Error_formas,pterror,"\n\n",NULL);
	c=_mensaje[0];	*_mensaje='\0';

	nret=0;
	mc=0;
	Advance(buffer);
	for(;;){
		u8int flags;
		char8_t uno;
		uint a,b;
		uint N, n;
		umint *ptr, *pmax;

		prepare_string(buffer);
		while(strcmp8(buffer.pc,"\\begin")!=0){
			if(*buffer.pc=='\0') break;	//this is...
			resume(buffer);
			finishline_advance(buffer); prepare_string(buffer);
		}
		if(*buffer.pc=='\0') break;		//...the only regular way out
		resume_advanceinline(buffer);
		ifunlike_Nomore(buffer){
			strcpy16(pterror,S_Begin);
			nret=ATREAD_LINEA; goto malasalida;
		}
		prepare_string(buffer);
		if(strcmp8(buffer.pc,"formas")!=0){
			const char8_t* pchar;
			pterror=strpcpy16(pterror,S_Seesperaba_formas);
			pchar=buffer.pc;
			while(*pchar!='\0') *pterror++=(char16_t)(*pchar++);
			nret=ATREAD_BADKEYVAL; goto malasalida;
		}
		resume(buffer);
		finishline_Advance(buffer);
		if(*buffer.pc=='\0') break;
		aj_malloc_n((*p_list),LinkedGrupoFormas,usizeof(LinkedGrupoFormas));
		flags=0;
		(*p_list)->cx=(*p_list)->cy=0;	//es set en dos tiempos
		while(*buffer.pc!='\n'){
			prepare_string(buffer);
			if(strcmp8(buffer.pc,"numero")==0){
				const char8_t *pcsaved;
				flags|=1;
				resume_advanceinline(buffer);
				ifunlike_Nomore(buffer){error_n=1; goto salida_errorlinea;}
				pcsaved=buffer.pc;
				nocheck_get_stay(buffer,(*p_list)->rango,basedinteger___str8);
				if(NOT_TIBUF_OK(buffer) && buffer.pc-pcsaved<=1){
					buffer.next--;
					nocheck_get_stay(buffer,(*p_list)->rango,uint___str8);
				}
				if(NOT_TIBUF_OK(buffer)){error_n=1; goto salida_errorcaracter;}
				if((*p_list)->rango>0xFFFF){error_n=1; goto salida_errorrango;}
			}elif(strcmp8(buffer.pc,"limites")==0){
				ssint m,M;
				flags|=2;
				resume_advanceinline(buffer);
				iflike_moreinl(buffer){ifnot_get_advanceinline(buffer,m,ssint___str8){error_n=2; goto salida_errorcaracter;}}
				iflike_moreinl(buffer){ifnot_get_advanceinline(buffer,M,ssint___str8){error_n=2; goto salida_errorcaracter;}}
				else{error_n=2; goto salida_errorlinea;}
				if(M-m>2000){error_n=2; goto salida_errorrango;}
				(*p_list)->cx-=m;
				(*p_list)->dim=M-m+1;
				iflike_moreinl(buffer){ifnot_get_advanceinline(buffer,m,ssint___str8){error_n=2; goto salida_errorcaracter;}}
				iflike_moreinl(buffer){ifnot_get_stay(buffer,M,ssint___str8){error_n=2; goto salida_errorcaracter;}}
				else{error_n=2;goto  salida_errorlinea;}
				if(M-m>2000){error_n=2; goto salida_errorrango;}
				(*p_list)->cy+=M;
				(*p_list)->dim|=(M-m+1)<<16;
			}elif(strcmp8(buffer.pc,"centro")==0){
				float fx,fy;
				flags|=4;
				resume_advanceinline(buffer);
				iflike_moreinl(buffer){ifnot_get_advanceinline(buffer,fx,float___str8){error_n=3; goto salida_errorcaracter;}}
				iflike_moreinl(buffer){ifnot_get_stay(buffer,fy,float___str8){error_n=3; goto salida_errorcaracter;}}
				else{error_n=3; goto salida_errorlinea;}
				(*p_list)->cx+=fx;
				(*p_list)->cy-=fy;
			}elif(strcmp8(buffer.pc,"uno")==0){
				flags|=8;
				resume_advanceinline(buffer);
				uno=*buffer.pc;
				if(uno=='\n'){error_n=4; goto salida_errorrango;}
			}
			finishline(buffer);
			advanceinline(buffer);
			if(*buffer.pc=='\0') break;
		}
		if((flags&0xF)!=0xF){
			strcpy16(pterror,S_Faltainfo);
			nret=ATREAD_MISSINGDATA; goto malasalida;
		}
		(*p_list)->next=NULL;
		a=get_bytes23(&(*p_list)->dim);
		b=get_bytes01(&(*p_list)->dim);
		N=a*b;
		checked_malloc_n((*p_list)->matrices,umint,N,
			free(*p_list); *p_list=NULL; goto salida_outofmem)
		n=1;
		ptr=(*p_list)->matrices;
		pmax=(*p_list)->matrices+N;
		num=(*p_list)->rango-1;
		advance(buffer);
		while(1){
			if(*buffer.pc=='\0') break;
			if(*buffer.pc=='\\' && *(buffer.pc+1)=='e' && *(buffer.pc+2)=='n'){
				finishline_Advance(buffer);
				break;
			}
			if(ptr==pmax){
				n+=(n+1)>>1;
				ptr=(umint*)realloc((*p_list)->matrices,n*N*usizeof(umint));
				ifunlike(ptr==NULL){
					(*p_list)->rango|=num<<16;
					goto salida_outofmem;
				}
				pmax=ptr+(pmax-(*p_list)->matrices);	//ptr nuevo
				(*p_list)->matrices=ptr;
				ptr=pmax;
				pmax=(*p_list)->matrices+n*N;
			}
			num++;
			{dontimes(a,){
				ifunlike(*buffer.pc=='\n'){nret=ATREAD_BADFORMAT; goto salida_error_enforma;}
				ifunlike(*buffer.pc=='\0'){nret=ATREAD_EOF; goto salida_error_enforma;}
				{dontimes(b,buffer.pc++) *ptr++=!(*buffer.pc^uno);}
				ifunlike(*buffer.pc!='\n'){nret=ATREAD_BADFORMAT; goto salida_error_enforma;}
				buffer.pc++;
			}}
			advance(buffer);
		}
		(*p_list)->rango|=num<<16;
		if(ptr!=pmax) (*p_list)->matrices=(umint*)realloc((*p_list)->matrices,ptr-(*p_list)->matrices);
		p_list=&(*p_list)->next;
	}

salida:
	ticlose(buffer);
	return nret;

salida_outofmem:
	{const char16_t *s;
	switch(idioma){
		 case Id_Eng: s=u"Not enough memory"; break;
		 case Id_It:	s=u"Memoria insuficente"; break;
		 default:		s=u"Memoria insuficiente";
	}
	strcpy16(pterror,s);}
	nret=AT_NOMEM; goto malasalida;

salida_errorcaracter: nret=ATREAD_CARACTER; goto salida_malvalor;
salida_errorlinea: nret=ATREAD_LINEA; goto salida_malvalor;
salida_errorrango: nret=ATREAD_RANGE; goto salida_malvalor;
salida_malvalor:
	free(*p_list); *p_list=NULL;
	strbuild16(pterror,S_Errorenlalinea_de,NombresLineas[error_n],NULL);
	*pterror++='\''; *pterror='\0';
	nret=ATREAD_CARACTER; goto malasalida;

salida_error_enforma:
	pterror=strpcpy16(pterror,S_Errorenforma);
	str16___uint(pterror,num);
	if(num==(*p_list)->rango){
		free((*p_list)->matrices);
		free(*p_list);
		*p_list=NULL;
	}else{
		uint dim;
		num--;
		dim=(*p_list)->dim;
		(*p_list)->matrices=(umint*)realloc((*p_list)->matrices,(num-(*p_list)->rango)*bytes01(dim)*bytes23(dim));
		(*p_list)->rango|=num<<16;
	}
	//goto malasalida;

malasalida:
	*_mensaje=c; goto salida;
}
