﻿
typedef struct{
	u8int _idioma;
	uint _current_tipo;	//tipo being read
	Linkedstring** _perror_next;
} Globalesa;
#define Global Globalesa
#define perror_next global->_perror_next
#define idioma global->_idioma

#define new_errorstring(ptr,k) \
	aj_malloc_n(ptr,Linkedstring,usizeof(Linkedstring));\
	(ptr)->next=NULL;\
	checked_malloc_n((ptr)->s,char16_t,k,  free(ptr); goto salida_outofmem)

#define add_perror_text(ss) \
	{uint k=strlen16(ss)+1;\
	new_errorstring(*perror_next,k);\
	strcpy16((*perror_next)->s,ss);}\
	perror_next=&(*perror_next)->next

typedef unsigned int (*_wtibuf_func)(const char16_t **);

unsigned int FFFFFF___str16(const char16_t **pc){
	const char16_t* s1=*pc;
	unsigned int x=0;
	unsigned int c;
	if(*s1=='0' && *(s1+1)=='h') s1+=2;
	dontimes(6,){
		c=*s1;
		if(c>='0' && c<='9') c-='0';
		elif(c>='A' && c<='F') c-='A'-10;
		else break;
		x<<=4; x|=c;
		s1++;
	}
	*pc=(char16_t*)s1;
	return x;
}
u8int FF___str16(const char16_t **pc){
	const char16_t* s1=*pc;
	u8int x=0;
	char16_t c;
	if((c=*s1)>='0' && c<='9') x=(u8int)(c-'0');
	elif(c>='A' && c<='F') x=(u8int)(c-'A'+10);
	else goto _return;
	s1++;

	if((c=*s1)>='0' && c<='9'){x<<=4; x|=(u8int)(c-'0');}
	elif(c>='A' && c<='F'){x<<=4; x|=(u8int)(c-'A'+10);}
	else goto _return;
	s1++;

_return:
	*pc=s1;
	return x;
}

void nocheck_get_default10(Bufferti16 *pbuffer, uint *valor){
	const char16_t *pcsaved=pbuffer->pc;
	nocheck_get_stay((*pbuffer),*valor,basedinteger___str16);
	if(NOT_TIBUF_OK((*pbuffer)) && (pdif)(pbuffer->pc-pcsaved)<=1){
		pbuffer->next--;
		nocheck_get_stay((*pbuffer),*valor,uint___str16);
	}
}

int set_nullfconfig(FConfiguracion *fconfig){
	fconfig->files_depend=NULL;
	fconfig->ficheros.fformas=NULL;
	fconfig->fondo=0;
	fconfig->resalte=0x00FFFFFF;
	//fconfig->qualityinfos=NULL;
	fconfig->tipos.ppio=NULL;
	fconfig->agrupaciones=NULL;
	fconfig->jerarquias=NULL;
	fconfig->ver_info.ver.ppio=NULL;
	fconfig->ver_info.verT.ppio=NULL;
	fconfig->ver_info.criterios=NULL;

	HsetupЯ(hConfigTipo,fconfig->tipos,64,goto nomem0);
	HsetupUint(fconfig->ver_info.ver,64,goto nomem1);
	HsetupUint(fconfig->ver_info.verT,64,goto nomem2);
	return 0;

/*free_null(fconfig->ver_info.verT.ppio);*/		nomem2:
free_null(fconfig->ver_info.ver.ppio);		nomem1:
free_null(fconfig->tipos.ppio);		nomem0:
	return AT_NOMEM;
}
int set_nullconfig(Gra_Configuracion *config){
	int nret;

	config->vbyte0=0;
	config->nombre=(char16_t*)NULLNAME;
	aj_malloc_return(config->fconfig,FConfiguracion,1);
	nret=set_nullfconfig(config->fconfig);
	ifunlike(nret) return nret;
	config->pformas=NULL;
	HsetupЯ(hSolvedTipo,config->solved,64,return AT_NOMEM);
	return 0;
}

#define buffer (*pbuffer)
int numero_tipo_erroneo(Bufferti16 *pbuffer, Global *global){
	uint k;
	isolate_word(buffer);
	k=(pdif)(buffer.next-buffer.pc)+strlen16(S_Tipoerroneo)+strlen16(S_Tipo0254)+1;
	new_errorstring(*perror_next,k);
	strbuild16((*perror_next)->s,S_Tipoerroneo,buffer.pc,S_Tipo0254,NULL);
	perror_next=&(*perror_next)->next;
	resume(buffer);
	return 0;
salida_outofmem: return AT_NOMEM;
}

int lee_info(Bufferti16*,Global*l, char16_t* *nombre, u8int* pversion,uint* fondo,uint* resalte,char16_t* *fichero_formas);
int lee_ver(Bufferti16*,Global*, VerInfo* pver);
int lee_Tipo(Bufferti16*,Global*, ConfigTipo *tipo);
//En mensaje sólo se guardará un mensaje de error que haga que se detenga la lectura del fichero.
//Los demás en *perror_first
int lee_configuracion(Bufferti16 *pbuffer, FConfiguracion **config, char16_t* *nombre, Linkedstring* *perror_first, char16_t* _mensaje, u8int _idioma){
	Global globaL;
	Global* global=&globaL;
	s8int mc;
	u8int version;
	uint tipo;
	ConfigTipo tipo_vacio;
	int nret;
	PLIST plist;
	plist=get_new_plist();

	idioma=_idioma;
	*perror_first=NULL;
	aj_malloc_add(*config,FConfiguracion,1);
	nret=set_nullfconfig(*config);
	ifunlike(nret) goto salida_outofmem;
	Addto_delete_ind((*config)->tipos.ppio);
	Addto_delete_ind((*config)->ver_info.ver.ppio);
	Addto_delete_ind((*config)->ver_info.verT.ppio);

	global->_current_tipo=Я;
	perror_next=perror_first;
	NULL_set((void**)&tipo_vacio,usizeof(ConfigTipo)/usizeof(void*));
	version=255;	//not yet read

	nret=0;
	mc=0;
	Advance(buffer);
	for(;;){
		prepare_string(buffer);
		while(strcmp16(buffer.pc,u"\\begin")!=0 && strcmp16(buffer.pc,u"\\end")!=0){
			if(*buffer.pc=='\0') break;	//this is...
			resume(buffer);
			finishline_advance(buffer); prepare_string(buffer);
		}
		if(*buffer.pc=='\0'){
			if(mc>0) goto salida_faltaEnd;
			break;			//...the only regular way out
		}
		if(strcmp16(buffer.pc,u"\\end")==0){
			resume(buffer);
			if(mc==0){
				add_perror_text(S_Extra_end);
				mc=1;
			}
			mc--;
			finishline_Advance(buffer);
			continue;
		}
		//so it must be \begin
		if(mc>0) goto ignore_continue;
		resume_advanceinline(buffer);
		ifunlike_Nomore(buffer) goto salida_loneBegin;
		prepare_string(buffer);
		if(strcmp16(buffer.pc,u"Info")==0){
			resume(buffer); finishline_Advance(buffer);
			nret=lee_info(pbuffer,global,nombre,&version,&(*config)->fondo,&(*config)->resalte,&(*config)->ficheros.fformas);
		}elif(strcmp16(buffer.pc,u"Ver")==0){
			resume(buffer); finishline_Advance(buffer);
			nret=lee_ver(pbuffer,global,&(*config)->ver_info);
		}elif(strcmp16(buffer.pc,u"Tipo")==0){
			resume_advanceinline(buffer);
			ifunlike_Nomore(buffer){
				strcpy16(_mensaje,S_FaltaTipo);
				nret=ATREAD_LINEA;
				goto malasalida;
			}
			nocheck_get_default10(pbuffer,&tipo);
			if(NOT_TIBUF_OK(buffer) || isneg(tipo) || tipo>=TIPO_MAX){
				if(numero_tipo_erroneo(pbuffer,global)) nret=AT_NOMEM;
				goto ignore_continue;
			}
			finishline_Advance(buffer);
			global->_current_tipo=tipo;
			addh_keydata(hConfigTipo,&(*config)->tipos,tipo,tipo_vacio,nret=AT_NOMEM);
			iflike(nret!=AT_NOMEM) nret=lee_Tipo(pbuffer,global,gethdata_hConfigTipo(&(*config)->tipos,tipo));
		}else{
			goto ignore_continue;
		}
	//Control falls here for every known begin case, even if an error was returned
		ifunlike(nret==AT_NOMEM) goto salida_outofmem;
		ifunlike(nret==ATREAD_EOF) goto salida_faltaEnd;
		nret=0;
		continue;

ignore_continue:
		resume(buffer);
		mc++;
		finishline_Advance(buffer);
	}

	goto salida;

salida_faltaEnd:
	add_perror_text(S_End);
	nret=ATREAD_EOF;
	goto salida;

salida_outofmem:
	{const char16_t *s;
	switch(idioma){
		 case Id_Eng: s=u"Not enough memory"; break;
		 case Id_It:	s=u"Memoria insuficente"; break;
		 default:		s=u"Memoria insuficiente";
	}
	strcpy16(_mensaje,s);}
	nret=AT_NOMEM; goto malasalida;

salida_loneBegin:
	strcpy16(_mensaje,S_Begin);
	nret=ATREAD_LINEA; goto malasalida;

malasalida:
	free_plist(plist);
	*config=NULL;
salida:
	//if(*config!=NULL) (*config)->qualityinfos=QualityInfos;
	return nret;
}

int lee_info(Bufferti16* pbuffer,Global* global, char16_t* *nombre, u8int* pversion, uint* fondo,uint* resalte, char16_t* *fichero_formas){
	int nret=ATREAD_MISSINGDATA;

	s8int mc=1;
	while(1){
		if(*pbuffer->pc==u'\0') break;
		prepare_string(buffer);
		if(*pbuffer->pc==u'\\'){
			if(strcmp16(pbuffer->pc,u"\\end")==0) mc--;
			else{nret=ATREAD_BADKEYVAL;
				if(strcmp16(pbuffer->pc,u"\\begin")==0) mc++;
			}
			resume(buffer); finishline_Advance(buffer);
			if(!mc) return nret;
			continue;
		}
		if(mc>1) goto ignore;
		u8int l;
		if(strcmp16(pbuffer->pc,u"Version")==0) l='V';
		elif(strcmp16(pbuffer->pc,u"NombreConfig")==0) l='N';
		elif(strcmp16(pbuffer->pc,u"Fondo")==0) l='B';
		elif(strcmp16(pbuffer->pc,u"Resalte")==0) l='R';
		elif(strcmp16(pbuffer->pc,u"Formas")==0) l='F';

		resume_advanceinline(buffer);
		ifunlike_Nomore(buffer) goto nomore_inline;
		switch(l){
			case 'V': ifnot_get_stay(buffer,*pversion,FF___str16){nret=ATREAD_CARACTER; resume(buffer);}
				break;
			case 'N': if(nombre==NULL) goto ignore;
				Prepare_line(buffer);
				{u16int k=strlen16(pbuffer->pc)+1;
				aj_malloc_n(*nombre,char16_t,k);
				strcpy16(*nombre,pbuffer->pc);}
				resume(buffer);
				break;
			case 'B': ifnot_get_stay(buffer,*fondo,hex___str16){nret=ATREAD_CARACTER; resume(buffer);}
				break;
			case 'R': ifnot_get_stay(buffer,*resalte,hex___str16){nret=ATREAD_CARACTER; resume(buffer);}
				break;
			case 'F':
				{char16_t c;
				c=*pbuffer->pc;
				for(pbuffer->next=(char16_t*)pbuffer->pc+1;*pbuffer->next!=u'\n';pbuffer->next++);
				for(pbuffer->next--;*pbuffer->next!=c;pbuffer->next--); pbuffer->next++;
				if(pbuffer->next-pbuffer->pc>=SHRT_PATH) pbuffer->next=(char16_t*)pbuffer->pc+SHRT_PATH-1;
				aj_malloc_n(*fichero_formas,char16_t,pbuffer->next-pbuffer->pc+1);
				pbuffer->savedchar=*pbuffer->next, *pbuffer->next=u'\0';
				strcpy16(*fichero_formas,pbuffer->pc);}
				resume(buffer);
				break;
		}
ignore: finishline_Advance(buffer);
		continue;

	nomore_inline:
		add_perror_text(S_Info_faltavalor);
		nret=ATREAD_LINEA;
		continue;
	}
	return ATREAD_EOF;

salida_outofmem: return AT_NOMEM;
}

int lee_ver(Bufferti16* pbuffer,Global* global, VerInfo* pver){
	uint nret;
	s8int mc;

	nret=0;
	mc=1;
	for(;;){
		uint l,tipo;
		huint *htipo;
		if(*pbuffer->pc==u'\0'){
			return ATREAD_EOF;
		}
		prepare_string(buffer);
		if(strcmp16(pbuffer->pc,u"\\end")==0){
			resume(buffer); finishline_Advance(buffer);
			if(mc==1) break;	//regular way out
			mc--;
			continue;
		}
		if(strcmp16(pbuffer->pc,u"\\begin")==0){
			mc++;
			resume(buffer); finishline_Advance(buffer);
			continue;
		}

		l=0;
		if(strcmp16(pbuffer->pc,u"ON")==0) l=1;
		elif(strcmp16(pbuffer->pc,u"OFF")==0) l=2;
		elif(strcmp16(pbuffer->pc,u"TON")==0) l=3;
		elif(strcmp16(pbuffer->pc,u"TOFF")==0) l=4;
		else{
			resume(buffer); finishline_Advance(buffer);
			continue;
		}
		resume_advanceinline(buffer);
		ifunlike_Nomore(buffer){
			add_perror_text(S_FaltaelValor);
			nret=ATREAD_LINEA; continue;
		}
		nocheck_get_stay(buffer,tipo,uint___str16);
		ifunlike(NOT_TIBUF_OK(buffer) || isneg(tipo) || tipo>=TIPO_MAX){
			ifunlike(numero_tipo_erroneo(pbuffer,global)) goto salida_outofmem;
			finishline_Advance(buffer); continue;
		}
		if(l==1 || l==2){
			htipo=geth_huint(&pver->ver,tipo);
			//ON cannot be ignored because it can override an existing OFF
			if(l==1){if(htipo!=NULL) removeh_huint(&pver->ver,htipo);} //ON
			else{if(htipo==NULL) addh_huint(&pver->ver,tipo,goto salida_outofmem);} //OFF
		}else{	//l==3, 4
			htipo=geth_huint(&pver->verT,tipo);
			if(l==3){if(htipo==NULL) addh_huint(&pver->verT,tipo,goto salida_outofmem);} //ON
			else{if(htipo!=NULL) removeh_huint(&pver->verT,htipo);} //OFF
		}
		finishline_Advance(buffer);
	}
	return nret;

salida_outofmem:
	return AT_NOMEM;
}

uint find_qname(const char16_t* c){
	for(GraphicQualityInfo *ptri=QualityInfos;ptri->name!=NULL;ptri++){
		if(strcmp16(c,ptri->name)==0) return (pdif)(ptri-QualityInfos);
	}
	return Gra_NODATA;
}
uint add_qname(const char16_t* c){
	GraphicQualityInfo *plibre;
	uint k;
	for(plibre=QualityInfos;plibre->name!=NULL;plibre++);
	k=(pdif)(plibre-QualityInfos);
	if(k==Q_Total-1) return k-1;

	char16_t *qnombre=n_malloc(char16_t,strlen16(c)+1);
	ifunlike(qnombre==NULL) return (uint)AT_NOMEM;
	strcpy16(qnombre,c);
	plibre->name=qnombre;
	return k;
}

void free_linkedQuality(LinkedQuality* plist);

int lee_cualidad(Bufferti16* pbuffer,Global* global, LinkedQuality** p_quality){	//the string must be already prepared
	int nret;
	Quality* q;

	aj_malloc_n(*p_quality,LinkedQuality,usizeof(LinkedQuality));
	(*p_quality)->next=NULL;
	q=&(*p_quality)->q;

	nret=0;
	q->nqual=find_qname(pbuffer->pc);
	if(q->nqual==Gra_NODATA){
		q->nqual=add_qname(pbuffer->pc);
		ifunlike(q->nqual==(uint)AT_NOMEM) goto salida_outofmem;
	}
	resume_advanceinline(buffer);
	q->value.ptr=NULL;
	q->from.kind=QFrom_None;

	ifunlike_Nomore(buffer){
		uint k=strlen16(s_Tipon)+strlen16(S_Faltaelvalor_cualidad)+strlen16(QualityInfos[q->nqual].name)+strlen16(S_ismissing)+1;
		new_errorstring(*perror_next,k);
		strbuild16((*perror_next)->s,s_Tipon,S_Faltaelvalor_cualidad,QualityInfos[q->nqual].name,S_ismissing,NULL);
		perror_next=&(*perror_next)->next;
		nret=ATREAD_LINEA;
		goto salida_finishline;
	}
	prepare_string(buffer);
	if(strcmp16(pbuffer->pc,u"from")==0){
		resume_advanceinline(buffer);
		ifunlike_Nomore(buffer){
			uint k=strlen16(s_Tipon)+strlen16(S_Traslacualidad)+strlen16(QualityInfos[q->nqual].name)+strlen16(S_indicacionfromvacia)+1;
			new_errorstring(*perror_next,k);
			strbuild16((*perror_next)->s,s_Tipon,S_Traslacualidad,QualityInfos[q->nqual].name,S_indicacionfromvacia,NULL);
			perror_next=&(*perror_next)->next;
			nret=ATREAD_LINEA;
			goto salida_finishline;
		}
		prepare_string(buffer);
		q->fromQ=Q_None;
		if(strcmp16(pbuffer->pc,u".")==0){
			if(q->nqual==Q_All){
				uint k=strlen16(s_Tipon)+strlen16(S_fromdot_novalido)+1;
				new_errorstring(*perror_next,k);
				strbuild16((*perror_next)->s,s_Tipon,S_fromdot_novalido,NULL);
				perror_next=&(*perror_next)->next;
				nret=ATREAD_RANGE;
				goto salida_resume;
			}
			q->from.kind=QFrom_this;
			resume_advanceinline(buffer);
		}else{
			uint naux;
			if(strcmp16(pbuffer->pc,u"tipo")==0){q->from.kind=QFrom_Tipo;}
			elif(strcmp16(pbuffer->pc,u"subtipo")==0){
				q->from.kind=QFrom_Subtipo;
				q->from.Tipo=MASK_TIPO(global->_current_tipo);
			}else{
				uint k=strlen16(s_Tipon)+strlen16(S_Traslacualidad)+strlen16(QualityInfos[q->nqual].name)+strlen16(S_indicacionfromdesconocida)+1;
				new_errorstring(*perror_next,k);
				strbuild16((*perror_next)->s,s_Tipon,S_Traslacualidad,QualityInfos[q->nqual].name,S_indicacionfromdesconocida,NULL);
				perror_next=&(*perror_next)->next;
				nret=ATREAD_BADKEYVAL;
				goto salida_resume;
			}
			resume_advanceinline(buffer);
re_read:	ifunlike_Nomore(buffer){
				uint k=strlen16(s_Tipon)+strlen16(S_Traslacualidad)+strlen16(QualityInfos[q->nqual].name)+strlen16(S_indicacionfromincompleta)+1;
				new_errorstring(*perror_next,k);
				strbuild16((*perror_next)->s,s_Tipon,S_Traslacualidad,QualityInfos[q->nqual].name,S_indicacionfromincompleta,NULL);
				perror_next=&(*perror_next)->next;
				nret=ATREAD_LINEA;
				goto salida_finishline;
			}
			nocheck_get_default10(pbuffer,&naux);
			if_tibuf_ok(buffer){
				if(q->from.kind==QFrom_Tipo){
					if(naux>=TIPO_MAX) goto error_on_naux;
					q->from.Tipo=MASK_TIPO(naux);
				}else{
					if(naux>SUBTIPO_MAX) goto error_on_naux;
					q->from.Tipo|=MASK_SUBTIPO(naux);
				}
				if(0){
					uint k1,k2,k;
				error_on_naux:
					nret=ATREAD_RANGE;
					isolate_word(buffer);
					if(q->from.kind==QFrom_Tipo){k1=N_tipoerroneo; k2=N_Tipo0254;}
					else{k1=N_subtipoerroneo; k2=N_Subtipo0255;}
					k=strlen16(s_Tipon)+strlen16(S_Traslacualidad)+strlen16(QualityInfos[q->nqual].name)+strlen16(TEXTOcfg(k1))+(pdif)(buffer.next-buffer.pc)+strlen16(TEXTOcfg(k2))+1;
					new_errorstring(*perror_next,k);
					strbuild16((*perror_next)->s,s_Tipon,S_Traslacualidad,QualityInfos[q->nqual].name,TEXTOcfg(k1),buffer.pc,TEXTOcfg(k2),NULL);
					perror_next=&(*perror_next)->next;
					goto salida_resume;
				}
			}else{
				uint k1,k;
				nret=ATREAD_CARACTER;
				isolate_word(buffer);
				if(q->from.kind==QFrom_Tipo) k1=N_tipoerroneo;
				else k1=N_subtipoerroneo;
				k=strlen16(s_Tipon)+strlen16(S_Traslacualidad)+strlen16(QualityInfos[q->nqual].name)+strlen16(TEXTOcfg(k1))+(pdif)(buffer.next-buffer.pc)+1;
				new_errorstring(*perror_next,k);
				strbuild16((*perror_next)->s,s_Tipon,S_Traslacualidad,QualityInfos[q->nqual].name,TEXTOcfg(k1),buffer.pc,NULL);
				perror_next=&(*perror_next)->next;
				goto salida_resume;
			}
			advanceinline(buffer);
			if(q->from.kind==QFrom_Tipo){
				if_Moreinl(buffer){
					prepare_string(buffer);
					if(strcmp16(pbuffer->pc,u"subtipo")==0){
						q->from.kind=QFrom_TipoSubtipo;
						resume_advanceinline(buffer);
						goto re_read;
					}else{
						*pbuffer->next=pbuffer->savedchar;
					}
				}
			}
		}
		if_Nomore(buffer){
			finishline_Advance(buffer);
			return 0;
		}
		prepare_string(buffer);
		if(strcmp16(pbuffer->pc,u"tipo")==0 || strcmp16(pbuffer->pc,u"subtipo")==0){
			uint k=strlen16(s_Tipon)+strlen16(S_Traslacualidad)+strlen16(QualityInfos[q->nqual].name)+strlen16(S_extra)+(pdif)(pbuffer->next-pbuffer->pc)+1;
			new_errorstring(*perror_next,k);
			strbuild16((*perror_next)->s,s_Tipon,S_Traslacualidad,QualityInfos[q->nqual].name,S_extra,pbuffer->pc,NULL);
			perror_next=&(*perror_next)->next;
			nret=ATREAD_BADFORMAT;
			goto salida_resume;
		}
		if(strcmp16(pbuffer->pc,u"texto")==0){
			q->from.kind++;
			resume_advanceinline(buffer);
			if_Nomore(buffer){
				finishline_Advance(buffer);
				return 0;
			}
			prepare_string(buffer);
		}
		q->fromQ=find_qname(pbuffer->pc);
		if(q->fromQ==Gra_NODATA){
			q->fromQ=add_qname(pbuffer->pc);
			ifunlike(q->fromQ==(uint)AT_NOMEM) goto salida_outofmem;
		}
		goto salida_resume;
	}

	*pbuffer->next=pbuffer->savedchar;
	if(q->nqual==Q_All){	//All
		uint k=strlen16(s_Tipon)+strlen16(S_Allfollowedbyfrom)+1;
		new_errorstring(*perror_next,k);
		strbuild16((*perror_next)->s,s_Tipon,S_Allfollowedbyfrom,NULL);
		nret=ATREAD_MISSINGDATA;
		goto salida_finishline;
	}
	switch(QualityInfos[q->nqual].val_type){
		case QValtype_dec:
			nocheck_get_default10(pbuffer,&q->value.n);
			//uint___str16
			break;
		case QValtype_hex:
			nocheck_get_stay(buffer,q->value.n,hex___str16);
			break;
		case QValtype_float:
			nocheck_get_stay(buffer,q->value.fl,(float)vfdouble___str16);
			break;
		case QValtype_flags:
			break;
		case QValtype_string:
			{uint k;
			Prepare_line(buffer);
			k=(pdif)(pbuffer->next-pbuffer->pc)+1;
			q->value.ptr=malloc(k*usizeof(char16_t));
			ifunlike(q->value.ptr==NULL) goto salida_outofmem;
			strcpy16((char16_t*)q->value.ptr,pbuffer->pc);
			goto salida_resume;}
			break;
	}
	if_tibuf_ok(buffer) goto salida_finishline;
	else goto error_in_value;

error_in_value:
	isolate_word(buffer);
	{uint k=strlen16(s_Tipon)+strlen16(S_Alleerlacualidad)+strlen16(QualityInfos[q->nqual].name)+strlen16(S_seencontro)+(pdif)(pbuffer->next-pbuffer->pc)+strlen16(S_quenoesvalido)+1;
	new_errorstring(*perror_next,k);}
	strbuild16((*perror_next)->s,s_Tipon,S_Alleerlacualidad,QualityInfos[q->nqual].name,S_seencontro,pbuffer->pc,S_quenoesvalido,NULL);
	perror_next=&(*perror_next)->next;
	nret=ATREAD_CARACTER;

salida_resume:
	resume(buffer);
salida_finishline:
	finishline_Advance(buffer);
	return nret;

salida_outofmem:
	resume(buffer);	//we may go backwards here, but the behavour is always right
	nret=AT_NOMEM; goto salida_finishline;
}

void apply_mask0(u8int mask, uint* flags){
	u8int s=0;
	dontimes(8,flags++){
		uint l=1;
		while(l){
			if((s&mask)!=0) *flags&=~l;
			s++, l<<=1;
		}
	}
}
void apply_maskF(u8int mask, uint* flags){
	u8int s=0;
	dontimes(8,flags++){
		uint l=1;
		while(l){
			if((s&mask)!=mask) *flags&=~l;
			s++, l<<=1;
		}
	}
}
void apply_mask1(u8int mask, uint* flags){
	u8int s=0;
	dontimes(8,flags++){
		uint l=1;
		while(l){
			if((s&mask)==0) *flags&=~l;
			s++, l<<=1;
		}
	}
}
void apply_maskE(u8int mask, uint* flags){
	u8int s=0;
	dontimes(8,flags++){
		uint l=1;
		while(l){
			if((s&mask)==mask) *flags&=~l;
			s++, l<<=1;
		}
	}
}

#define buffer (*pbuffer)
int lee_Subtipo(Bufferti16* pbuffer,Global* global, LinkedConfigSubtipo** p_cfgsubtipo);

int lee_Tipo(Bufferti16* pbuffer,Global* global, ConfigTipo *tipo){
	int nret;
	s8int mc;
	s8int state;
#define STATE_IGNORING		-1
#define STATE_NORMAL		0
#define STATE_INREPRE		1
#define STATE_INTEXTO		2
	LinkedConfigSubtipo** pnext_subt;
	LinkedQuality** pnext_cual;
	LinkedQuality** pnext_cual_texto;

	tipo->Significado.string=NULL;
	tipo->SignificadoR.string=NULL;
	tipo->cualidades=NULL;
	tipo->cualid_texto=NULL;
	tipo->subtipos=NULL;

	pnext_subt=&tipo->subtipos;
	pnext_cual=&tipo->cualidades;
	pnext_cual_texto=&tipo->cualid_texto;

	//REVISAR
	{uint naux=global->_current_tipo;
	s_Tipon[7]=(umint)(naux%10)+u'0';
	naux/=10;
	if(naux==0){
		s_Tipon[6]=u' ';
	}else{
		s_Tipon[6]=(umint)(naux%10)+u'0';
		naux/=10;
	}
	if(naux==0){s_Tipon[5]=u' ';}
	else s_Tipon[5]=(umint)naux+u'0';
	}

	nret=0;
	state=STATE_NORMAL;
	mc=1;
	for(;;){
		u8int l;
		LinkedQuality** pnext_cual_x;
		if(*pbuffer->pc==u'\0'){
			return ATREAD_EOF;
		}
		prepare_string(buffer);
		if(strcmp16(pbuffer->pc,u"\\end")==0){
			resume(buffer); finishline_Advance(buffer);
			if(mc==1) break;	//regular way out
			mc--;
			if(mc==1) state=STATE_NORMAL;
			continue;
		}
		if(state==STATE_IGNORING){
			if(strcmp16(pbuffer->pc,u"\\begin")==0) mc++;
			resume(buffer); finishline_Advance(buffer);
			continue;
		}
		l=0;
		if(strcmp16(pbuffer->pc,u"Significado")==0) l=1;
		elif(strcmp16(pbuffer->pc,u"SignificadoR")==0) l=2;
		if(l){
			if(state!=STATE_NORMAL){
				const char16_t* pcom;
				uint k;
				if(state==STATE_INTEXTO) pcom=u"\\Texto";
				else pcom=u"\\Representacion";
				k=strlen16(s_Tipon)+(pdif)(pbuffer->next-pbuffer->pc)+strlen16(S_dentrode)+strlen16(pcom)+strlen16(S_noesvalido)+1;
				new_errorstring(*perror_next,k);
				strbuild16((*perror_next)->s,s_Tipon,pbuffer->pc,S_dentrode,pcom,S_noesvalido,NULL);
				perror_next=&(*perror_next)->next;
				nret=ATREAD_WRONGPLACE;
				goto resume_continue;
			}
			if((l==1 && tipo->Significado.string!=NULL) || (tipo->SignificadoR.string!=NULL)){
				const char16_t* s;
				uint k;
				if(l==1) s=S_Significado_solounavez;
				else s=S_SignificadoR_solounavez;
				k=strlen16(s_Tipon)+strlen16(s)+1;
				new_errorstring(*perror_next,k);
				strbuild16((*perror_next)->s,s_Tipon,s,NULL);
				perror_next=&(*perror_next)->next;
				nret=ATREAD_BADFORMAT;
				goto resume_continue;
			}
			resume_advanceinline(buffer);
			Prepare_line(buffer);
			{uint k=(pdif)(pbuffer->next-pbuffer->pc);//+1
			k=(k+4)&~3U;
			{aj_decl_alloc_n(char16_t,name,k);
			strcpy16(name,pbuffer->pc);
			if(l==1) tipo->Significado.string=name;
			else tipo->SignificadoR.string=name;}}
			goto resume_continue;
		}
		if(strcmp16(pbuffer->pc,u"\\begin")==0){
			if(state!=STATE_NORMAL){
				const char16_t* pcom;
				uint k;
				if(state==STATE_INTEXTO) pcom=u"\\Texto";
				else pcom=u"\\Representacion";
				k=strlen16(s_Tipon)+strlen16(S_Dentrode_unbloque)+strlen16(pcom)+strlen16(S_NopuedeBegin)+1;
				new_errorstring(*perror_next,k);
				strbuild16((*perror_next)->s,s_Tipon,S_Dentrode_unbloque,pcom,S_NopuedeBegin,NULL);
				perror_next=&(*perror_next)->next;
				nret=ATREAD_WRONGPLACE;
				goto unknown_in_begin;
			}
			resume_advanceinline(buffer);
			ifunlike_Nomore(buffer){
				nret=ATREAD_LINEA; goto unexpected_eol;
			}
			prepare_string(buffer);
			if(strcmp16(pbuffer->pc,u"Subtipo")==0){
				CriterioSubtipo criterio;
				resume_advanceinline(buffer);
				ifunlike_Nomore(buffer){
					uint k=strlen16(s_Tipon)+strlen16(S_FaltaSubtipo)+1;
					new_errorstring(*perror_next,k);
					strbuild16((*perror_next)->s,s_Tipon,S_FaltaSubtipo);
					perror_next=&(*perror_next)->next;
					nret=ATREAD_LINEA;
					goto unexpected_eol;
				}
				if(*pbuffer->pc>='0' && *pbuffer->pc<='9'){
					criterio.kind=CriterioSub_Numero;
					nocheck_get_default10(pbuffer,&criterio.valor.number);
					ifnot_tibuf_ok(buffer){if(*buffer.next==u',') buffer.pc=buffer.next--;}
					if(NOT_TIBUF_OK(buffer) || criterio.valor.number>SUBTIPO_MAX){
error_on_subtipo:	isolate_word(buffer);
						uint k=strlen16(s_Tipon)+strlen16(S_Subtipoerroneo)+(pdif)(pbuffer->next-pbuffer->pc)+strlen16(S_Subtipo0255)+1;
						new_errorstring(*perror_next,k);
						strbuild16((*perror_next)->s,s_Tipon,S_Subtipoerroneo,pbuffer->pc,S_Subtipo0255,NULL);
						perror_next=&(*perror_next)->next;
						nret=ATREAD_BADKEYVAL;
						goto unknown_in_begin;
					}
					Advanceinline(buffer);
					if(*buffer.pc==u','){
						criterio.kind=CriterioSub_Array;
						uint valor=criterio.valor.number;
						aj_malloc_return(criterio.valor.array,uint,CriterioSub_ArrayLength);
						criterio.valor.array[valor>>5] |= 1<<(valor&31);
						do{
							buffer.pc++; Advanceinline(buffer);
							if_Nomore(buffer) break;	//A trailing comma is allowed
							nocheck_get_default10(pbuffer,&valor);
							ifnot_tibuf_ok(buffer){if(*buffer.next==u',') buffer.pc=buffer.next--;}
							if(NOT_TIBUF_OK(buffer) || valor>SUBTIPO_MAX) goto error_on_subtipo;
							criterio.valor.array[valor>>5] |= 1<<(valor&31);
							Advanceinline(buffer);
						}while(*buffer.pc==u',');
					}
					if_Moreinl(buffer){
						uint k;
indicacion_desconocida: k=strlen16(s_Tipon)+strlen16(S_Criteriodesconocido)+1;
						new_errorstring(*perror_next,k);
						strbuild16((*perror_next)->s,s_Tipon,S_Criteriodesconocido,NULL);
						perror_next=&(*perror_next)->next;
						nret=ATREAD_LINEA;
						goto unexpected_eol;
					}
				}elif(*pbuffer->pc=='('){
					//provisional
					criterio.kind=CriterioSub_Expression;
					prepare_string(buffer);
					goto prov;
				}else{
					prepare_string(buffer);
					if(strcmp16(pbuffer->pc,u"min")==0){
						criterio.kind=CriterioSub_Rango;
						resume_advanceinline(buffer);
						ifunlike_Nomore(buffer){
							uint k;
faltan_numeros:		k=strlen16(s_Tipon)+strlen16(S_Faltan_numeros_en_criterio)+1;
							new_errorstring(*perror_next,k);
							strbuild16((*perror_next)->s,s_Tipon,S_Faltan_numeros_en_criterio,NULL);
							perror_next=&(*perror_next)->next;
							nret=ATREAD_LINEA;
							goto unexpected_eol;
						}
						nocheck_get_default10(pbuffer,&criterio.valor.number);
						if(NOT_TIBUF_OK(buffer) || criterio.valor.number>SUBTIPO_MAX) goto error_on_subtipo;
						advanceinline(buffer);
						if_Moreinl(buffer){
							prepare_string(buffer);
							if(strcmp16(pbuffer->pc,u"max")==0) goto lee_max;
							else goto indicacion_desconocida;
						}else{
							criterio.valor.number|=SUBTIPO_MAX<<16;
						}
					}elif(strcmp16(pbuffer->pc,u"max")==0){
						uint max;
						criterio.kind=CriterioSub_Rango;
			lee_max:	resume_advanceinline(buffer);
						ifunlike_Nomore(buffer) goto faltan_numeros;
						nocheck_get_default10(pbuffer,&max);
						if(NOT_TIBUF_OK(buffer) || max>SUBTIPO_MAX) goto error_on_subtipo;
						criterio.valor.number|=max<<16;
						if_Moreinl(buffer) goto indicacion_desconocida;
					}elif(strcmp16(pbuffer->pc,u"mask")==0){
						criterio.kind=CriterioSub_Ormask;
		lee_mascara:	resume_advanceinline(buffer);
						ifunlike_Nomore(buffer) goto faltan_numeros;
						nocheck_get_default10(pbuffer,&criterio.valor.number);
						if(NOT_TIBUF_OK(buffer) || criterio.valor.number>SUBTIPO_MAX) goto error_on_subtipo;
					}elif(strcmp16(pbuffer->pc,u"Mask")==0){
						criterio.kind=CriterioSub_Andmask;
						goto lee_mascara;
					}else{
						uint k;
				prov:	k=strlen16(s_Tipon)+strlen16(S_EspecificacionSubtipodesconocida)+(pdif)(pbuffer->next-pbuffer->pc)+1;
						new_errorstring(*perror_next,k);
						strbuild16((*perror_next)->s,s_Tipon,S_EspecificacionSubtipodesconocida,pbuffer->pc,NULL);
						perror_next=&(*perror_next)->next;
						nret=ATREAD_BADKEYVAL;
						goto unknown_in_begin;
					}
				}
				finishline_Advance(buffer);
				nret=lee_Subtipo(pbuffer,global,pnext_subt);
				if(*pnext_subt!=NULL) (*pnext_subt)->criterio=criterio;
				ifunlike(nret==AT_NOMEM){return AT_NOMEM;}
				ifunlike(nret==ATREAD_EOF){return ATREAD_EOF;}
				pnext_subt=&(*pnext_subt)->next;
				//otros valores de nret son ignorados
				continue;
			}elif(strcmp16(pbuffer->pc,u"Representacion")==0){
				mc++; state=STATE_INREPRE;
				goto resume_continue;
			}elif(strcmp16(pbuffer->pc,u"Texto")==0){
				mc++; state=STATE_INTEXTO;
				goto resume_continue;
			}
		unknown_in_begin:
			resume(buffer);
		unexpected_eol:
			mc++; state=STATE_IGNORING;
			finishline_Advance(buffer);
			continue;
		}
		if(*pbuffer->pc==u'\\') goto resume_continue;	//unknown

		//Quality
		//LinkedQuality** pnext_cual_x;
		if(state==STATE_INTEXTO) pnext_cual_x=pnext_cual_texto;
		else pnext_cual_x=pnext_cual;

		nret=lee_cualidad(pbuffer,global,pnext_cual_x);
		ifunlike(nret==AT_NOMEM){return AT_NOMEM;}
		ifunlike(nret){
wrong_quality:
			free_linkedQuality(*pnext_cual_x);
			*pnext_cual_x=NULL;
		}else{
			if((*pnext_cual_x)->q.nqual==Q_All){
				u8int f;
				if(state==STATE_NORMAL) (*pnext_cual_x)->q.fromQ=fromQAll_Texto;
				else (*pnext_cual_x)->q.fromQ=fromQAll_OnlyQualities;
				f=(*pnext_cual_x)->q.from.kind;
				if(state!=STATE_INTEXTO && QFrom_istexto(f)){
					uint k=strlen16(s_Tipon)+strlen16(S_Allfromtexto)+1;
					new_errorstring(*perror_next,k);
					strbuild16((*perror_next)->s,s_Tipon,S_Allfromtexto,NULL);
					perror_next=&(*perror_next)->next;
					nret=ATREAD_WRONGPLACE;
					goto wrong_quality;
				}
				if(state==STATE_NORMAL && f==QFrom_Tipo) (*pnext_cual_x)->q.fromQ|=fromQAll_Subtipos;
			}
			if(state==STATE_INTEXTO) pnext_cual_texto=&(*pnext_cual_x)->next;
			else pnext_cual=&(*pnext_cual_x)->next;
		}
		continue;

resume_continue:
		resume(buffer);
		finishline_Advance(buffer);
	}
	return nret;

salida_outofmem:
	return AT_NOMEM;
}

int lee_Subtipo(Bufferti16* pbuffer,Global* global, LinkedConfigSubtipo** p_cfgsubtipo){
	ConfigSubtipo* subtipo;
	int nret;
	s8int mc;
	s8int state; //see lee_Tipo
	LinkedQuality** pnext_cual;
	LinkedQuality** pnext_cual_texto;

	aj_malloc_return(*p_cfgsubtipo,LinkedConfigSubtipo,usizeof(LinkedConfigSubtipo));
	(*p_cfgsubtipo)->next=NULL;
	subtipo=&(*p_cfgsubtipo)->S;
	subtipo->Significado.string=NULL;
	subtipo->SignificadoR.string=NULL;
	subtipo->cualidades=NULL;
	subtipo->cualid_texto=NULL;

	pnext_cual=&subtipo->cualidades;
	pnext_cual_texto=&subtipo->cualid_texto;

	nret=0;
	state=STATE_NORMAL;
	mc=1;
	for(;;){
		u8int l;
		LinkedQuality** pnext_cual_x;
		if(*pbuffer->pc==u'\0'){
			return ATREAD_EOF;
		}
		prepare_string(buffer);
		if(strcmp16(pbuffer->pc,u"\\end")==0){
			resume(buffer); finishline_Advance(buffer);
			if(mc==1) break;	//regular way out
			mc--;
			if(mc==1) state=STATE_NORMAL;
			continue;
		}
		if(state==STATE_IGNORING){
			if(strcmp16(pbuffer->pc,u"\\begin")==0) mc++;
			resume(buffer); finishline_Advance(buffer);
			continue;
		}
		l=0;
		if(strcmp16(pbuffer->pc,u"Significado")==0) l=1;
		elif(strcmp16(pbuffer->pc,u"SignificadoR")==0) l=2;
		if(l){
			if(state!=STATE_NORMAL){
				const char16_t *pcom;
				uint k;
				if(state==STATE_INTEXTO) pcom=u"\\Texto";
				pcom=u"\\Representacion";
				k=strlen16(s_Tipon)+(pdif)(pbuffer->next-pbuffer->pc)+strlen16(S_dentrode)+strlen16(pcom)+strlen16(S_noesvalido)+1;
				new_errorstring(*perror_next,k);
				strbuild16((*perror_next)->s,s_Tipon,pbuffer->pc,S_dentrode,pcom,S_noesvalido,NULL);
				perror_next=&(*perror_next)->next;
				nret=ATREAD_WRONGPLACE;
				goto resume_continue;
			}
			if((l==1 && subtipo->Significado.string!=NULL) || (subtipo->SignificadoR.string!=NULL)){
				const char16_t* s;
				uint k;
				if(l==1) s=S_Significado_solounavez;
				else s=S_SignificadoR_solounavez;
				k=strlen16(s_Tipon)+strlen16(s)+1;
				new_errorstring(*perror_next,k);
				strbuild16((*perror_next)->s,s_Tipon,s,NULL);
				perror_next=&(*perror_next)->next;
				nret=ATREAD_BADFORMAT;
				goto resume_continue;
			}
			resume_advanceinline(buffer);
			Prepare_line(buffer);
			{uint k=(pdif)(pbuffer->next-pbuffer->pc);//+1
			k=(k+4)&~3U;
			{aj_decl_alloc_n(char16_t,name,k);
			strcpy16(name,pbuffer->pc);
			if(l==1) subtipo->Significado.string=name;
			else subtipo->SignificadoR.string=name;}}
			goto resume_continue;
		}
		if(strcmp16(pbuffer->pc,u"\\begin")==0){
			if(state!=STATE_NORMAL){
				const char16_t* pcom;
				uint k;
				if(state==STATE_INTEXTO) pcom=u"\\Texto";
				else pcom=u"\\Representacion";
				k=strlen16(s_Tipon)+strlen16(S_Dentrode_unbloque)+strlen16(pcom)+strlen16(S_NopuedeBegin)+1;
				new_errorstring(*perror_next,k);
				strbuild16((*perror_next)->s,s_Tipon,S_Dentrode_unbloque,pcom,S_NopuedeBegin,NULL);
				perror_next=&(*perror_next)->next;
				nret=ATREAD_WRONGPLACE;
				goto unknown_in_begin;
			}
			resume_advanceinline(buffer);
			ifunlike_Nomore(buffer){
				nret=ATREAD_LINEA; goto unexpected_eol;
			}
			prepare_string(buffer);
			if(strcmp16(pbuffer->pc,u"Representacion")==0){
				mc++; state=STATE_INREPRE;
				goto resume_continue;
			}elif(strcmp16(pbuffer->pc,u"Texto")==0){
				mc++; state=STATE_INTEXTO;
				goto resume_continue;
			}
		unknown_in_begin:
			resume(buffer);
		unexpected_eol:
			mc++; state=STATE_IGNORING;
			finishline_Advance(buffer);
			continue;
		}
		if(*pbuffer->pc==u'\\') goto resume_continue;	//unknown

		//Quality name, value
		//LinkedQuality** pnext_cual_x;
		if(state==STATE_INTEXTO) pnext_cual_x=pnext_cual_texto;
		else pnext_cual_x=pnext_cual;

		nret=lee_cualidad(pbuffer,global,pnext_cual_x);
		ifunlike(nret==AT_NOMEM){return AT_NOMEM;}
		ifunlike(nret){
wrong_quality:
			free_linkedQuality(*pnext_cual_x);
			*pnext_cual_x=NULL;
		}else{
			if((*pnext_cual_x)->q.nqual==Q_All){
				u8int f;
				if(state==STATE_NORMAL) (*pnext_cual_x)->q.fromQ=fromQAll_Texto;
				else (*pnext_cual_x)->q.fromQ=fromQAll_OnlyQualities;
				f=(*pnext_cual_x)->q.from.kind;
				if(state!=STATE_INTEXTO && QFrom_istexto(f)){
					uint k=strlen16(s_Tipon)+strlen16(S_Allfromtexto)+1;
					new_errorstring(*perror_next,k);
					strbuild16((*perror_next)->s,s_Tipon,S_Allfromtexto,NULL);
					perror_next=&(*perror_next)->next;
					nret=ATREAD_WRONGPLACE;
					goto wrong_quality;
				}
				if(state==STATE_NORMAL && f==QFrom_Tipo) (*pnext_cual_x)->q.fromQ|=fromQAll_Significado;
			}
			if(state==STATE_INTEXTO) pnext_cual_texto=&(*pnext_cual_x)->next;
			else pnext_cual=&(*pnext_cual_x)->next;
		}
		continue;

	resume_continue:
		resume(buffer);
		finishline_Advance(buffer);
	}
	return nret;

salida_outofmem:
	return AT_NOMEM;
}
#undef STATE_IGNORING
#undef STATE_NORMAL
#undef STATE_INREPRE
#undef STATE_INTEXTO

#undef perror_next
#undef buffer
#undef Global

//recursive calling is an appealing solution but keeps adding stuff to the stack,
//and this list may be long
void free_linkedStrings(Linkedstring* first_next){
	while(first_next!=NULL){
		Linkedstring* next;
		freeif(first_next->s);
		next=first_next->next;
		free(first_next);
		first_next=next;
	}
}

#undef idioma
int carga_ficheros_de_recursos(Gra_Configuracion *config, char16_t* _mensaje, u8int _idioma);
int carga_ficheros_de_recursos_pordefecto(Gra_Configuracion *config, char16_t* _mensaje, u8int _idioma);
int carga_config_postlectura(Gra_Configuracion *config, char16_t* _mensaje, u8int _idioma);
int carga_fichero_configuracion(char16_t* ficherocfg, Gra_Configuracion *config, Linkedstring* *perror_first, char16_t* _mensaje, u8int idioma){
	int nret;
	config->nombre=NULL;
	config->fconfig=NULL;
	config->pformas=NULL;
	config->solved.ppio=NULL; config->solved.n=config->solved.N=0;

	Bufferti16 buffer;
	char16_t* pterror;
	char16_t c;

	*perror_first=NULL;
	path_get_filename16(ficherocfg,pterror);
	nret=tiopen16(&buffer,ficherocfg);
	ifunlike(nret<0){
		ifunlike(nret==AT_NOMEM){
			nomemopen_errstr(_mensaje,S_Error_cfg,pterror,S_cfg,idioma);
			return AT_NOMEM;
		}
		char16_t *pmens=strpcpy16(_mensaje,S_Error_cfg);
		open_file_err_str16(nret,pmens,pterror,idioma);
		return ATREAD_NOOPEN;
	}
	pterror=strbuild16(_mensaje,S_Error_cfg,pterror,u"\n\n",NULL);
	c=_mensaje[0];	*_mensaje=u'\0';
	nret=lee_configuracion(&buffer,&config->fconfig,&config->nombre,perror_first,pterror,idioma);
	ticlose(buffer);
	if(*pterror!='\0') *_mensaje=c;
	ifunlike(nret) return nret;
	nret=carga_config_postlectura(config,_mensaje,idioma);
	return nret;
}
int carga_configuracion_inmem(Bufferti16 *pbuffer, Gra_Configuracion *config, Linkedstring* *perror_first, char16_t* _mensaje, u8int _idioma){
	int nret;
	config->nombre=NULL;
	config->fconfig=NULL;
	config->pformas=NULL;
	config->solved.ppio=NULL; config->solved.n=config->solved.N=0;
	nret=lee_configuracion(pbuffer,&config->fconfig,&config->nombre,perror_first,_mensaje,_idioma); ifunlike(nret) return nret;
	nret=carga_config_postlectura(config,_mensaje,_idioma);
	return nret;
}
int carga_config_postlectura(Gra_Configuracion *config, char16_t* _mensaje, u8int _idioma){
	int nret;
	nret=carga_ficheros_de_recursos(config,_mensaje,_idioma); ifunlike(nret) return nret;
	nret=carga_ficheros_de_recursos_pordefecto(config,_mensaje,_idioma);
	ifunlike(nret==AT_NOMEM) return nret;
	nret=0;
	HsetupЯ(hSolvedTipo,config->solved,64,return AT_NOMEM);
	return nret;
}

int carga_ficheros_de_recursos(Gra_Configuracion *config, char16_t* _mensaje, u8int _idioma){
	int nret;
	if(config->fconfig->ficheros.fformas!=NULL){
		nret=carga_formas(config->fconfig->ficheros.fformas,&config->pformas,_mensaje,_idioma);
		ifunlike(nret) return nret;
	}
	return 0;
}

//Carga aquellos ficheros que están a null, en una ruta predeterminada para cada uno
int carga_ficheros_de_recursos_pordefecto(Gra_Configuracion *config, char16_t* _mensaje, u8int _idioma){
	int nret;
	char16_t path[SHRT_PATH];
	if(config->fconfig->ficheros.fformas==NULL){
		const char16_t *s=u"Configuraciones" STR16_pathsep u"Grafico" STR16_pathsep u"formas.fdf";
		makepath_to_exec16(path,s);
		nret=carga_formas(path,&config->pformas,_mensaje,_idioma);
		ifunlike(nret) return nret;
	}
	return 0;
}

int annade_one_config(Vector_Gra_Configuracion *configs){
	Gra_Configuracion *ptr;
	Venlarge_one(*configs,Gra_Configuracion,ptr,return AT_NOMEM);
	ptr->fconfig=NULL;
	ptr->pformas=NULL;
	ptr->solved.ppio=NULL; ptr->solved.n=ptr->solved.N=0;
	return 0;
}
