﻿#include "g_cargar_elementos.h"
int carga_fichero_(const char16_t* ficherof, GraficoLeido *leido){
	int nret=0;
	PLIST plist=PLIST_NULL;
	uint *ccl13;
	uint telem, *base, *tope, *tope_parcial;

	nret=biopen16(&base,ficherof);
	ifunlike(nret==AT_NOMEM) return AT_NOMEM;
	ifunlike(nret<0) return ATREAD_NOOPEN;
	ifunlike(nret<TAMAÑO_CABECERA+4){
		nret=ATREAD_NOFORMAT;
		goto error_fichero;
	}
	tope=base+nret;
	nret=0;

	leido->cabecera=(FGraCabecera*)base;
	ifunlike(get_byte3(&leido->cabecera->uint0)!=0xBA){
		nret=ATREAD_NOFORMAT;
		goto error_fichero;
	}
	if(get_byte2(&leido->cabecera->uint0)>5){
		nret=ATREAD_RECIENTE;
		goto error_fichero;
	}elif(get_byte2(&leido->cabecera->uint0)<5){
		nret=ATREAD_MUYANTIGUA;
		goto error_fichero;
	}

	ccl13=base+TAMAÑO_CABECERA;
	if(ccl13[POS_TIPO]!=CODIGO_INDICEGENERAL){
		nret=CARGAGRA_ERRINDICE;
		goto salida_error;
	}
	telem=ccl13[POS_TAMAÑO];
	tope_parcial=ccl13+telem;
	if(!isaligned_n(indicegeneral,telem)){nret=CARGAGRA_ERRINDICE; goto salida_error;}
	if(tope_parcial>tope || ((FGraEntradaIndice*)(tope_parcial-tamaño_entrada_indicegeneral))->Cod!=0){
		nret=ATREAD_OVERRUN;
		goto salida_error;
	}
	for(FGraEntradaIndice *ptri=(FGraEntradaIndice*)(ccl13+POS1); ptri->Cod!=0;ptri++){
		uint cod;
		uint *pos, **pelem;
		LGraTabla *ptabla;

		if(ptri->Cod==0) ptri->Cod=Gra_NODATA; /*error corregible*/
		if(ptri->Cod==Gra_NODATA || ptri->pos==Gra_NODATA) continue;
		pos=base+ptri->pos;
		if(ptri->Cod==1){ //indica el final del fichero
			if(pos>tope || pos<tope_parcial) pos=tope;	//error corregible
			else tope=pos;
			continue;
		}
		if(pos<tope_parcial){nret=CARGAGRA_ERRINDICE; goto salida_error;}
		//Comprobación de tamaño y de que el elemento que se encuentra en pos
		//es efectivamente el indicado en el índice
		cod=ptri->Cod;
		ptabla=NULL;
		pelem=NULL;
		if(ptri->Cod&0x80000000){	//es un elemento
			if(pos+POS_TIPO>=tope){
				nret=ATREAD_OVERRUN; goto salida_error;
			}
			uint Tipo=pos[POS_TIPO];
			if((cod&CODIGO_CCL_SISTEMA)==CODIGO_CCL_SISTEMA){
				cod=CODIGO_CCL_SISTEMA;
				Tipo&=CODIGO_CCL_SISTEMA;
			}
			if(Tipo!=cod){
				nret=ATREAD_BADFORMAT;
				goto salida_error;
			}
			if(pos+pos[POS_TAMAÑO]>tope){
				nret=ATREAD_OVERRUN; goto salida_error;
			}
			switch(cod){
				case CODIGO_CCL_KEYVALS: pelem=&leido->keyvals; break;
				case CODIGO_CCL_FCONFIG:
					{GraFConfig **pfconfig;
					pfconfig=&leido->fichero_config[0];
					while(*pfconfig!=NULL) pfconfig++;
					if(pfconfig-&leido->fichero_config[0]==15) pfconfig--;	//provocar el error
					pelem=(uint**)pfconfig;}
					break;
				case CODIGO_CCL_SISTEMA: pelem=(uint**)&leido->sistema; break;
				case CODIGO_CCL_ORDEN_ELEMENTOS: ptabla=&leido->orden_elementos; break;
				case CODIGO_CCL_TABLA_ELEMENTOS: ptabla=&leido->tabla_elementos; break;
				case CODIGO_CCL_TABLA_COMPUESTOS: ptabla=&leido->tabla_compuestos; break;
				case CODIGO_CCL_TABLA_TEXTOS: ptabla=&leido->tabla_textos; break;
			}
			if(ptabla!=NULL) pelem=&ptabla->registros;
		}else{		//es un bloque
			if(pos+ptri->tamaño_bloque>tope){
				nret=ATREAD_OVERRUN;
				goto salida_error;
			}
			switch(cod){
				case CODIGO_BLOQUE_GRAFICO: pelem=&leido->bloque_grafico.pos; break;
				case CODIGO_BLOQUE_COMPUESTOS: pelem=&leido->bloque_compuestos.pos; break;
				case CODIGO_BLOQUE_TEXTOS: pelem=&leido->bloque_textos.pos; break;
			}
		}
		if(pelem==NULL) continue;
		ifunlike(*pelem!=NULL){
			nret=CARGAGRA_ERRINDICE;
			goto salida_error;
		}
		if(ptabla==NULL){
			*pelem=pos;
			if(!(cod&0x80000000)) ((GraBloque*)pelem)->tamaño=ptri->tamaño_bloque;
		}else{
			ptabla->tamaño=pos[POS_TAMAÑO]-POS1;
			ptabla->registros=pos+POS1;
		}
	}
	if(leido->tabla_elementos.registros==NULL
		|| leido->tabla_textos.registros==NULL
		|| leido->orden_elementos.registros==NULL
		|| leido->bloque_grafico.pos==NULL
		|| leido->bloque_textos.pos==NULL){
			nret=CARGAGRA_ERRINDICE;
			goto salida_error;
	}

#define comprueba_cierre(tabla,tabla_nombre) \
	telem=tabla.tamaño+POS1;\
	if(!isaligned_n(tabla_nombre,telem) || tabla.registros[tabla.tamaño-merge(tamaño_entrada_,tabla_nombre)]!=0){\
		nret=ATREAD_BADFORMAT; goto salida_error;\
	}

	comprueba_cierre(leido->orden_elementos,orden_elementos);
	comprueba_cierre(leido->tabla_elementos,tabla_elems);
	comprueba_cierre(leido->tabla_textos,tabla_textos);
	if(leido->tabla_compuestos.registros!=NULL){
		comprueba_cierre(leido->tabla_compuestos,tabla_compuestos);
	}
	{GraFConfig **ptr; for(ptr=leido->fichero_config; *ptr!=NULL; ptr++){
		uint *final, *ptri;
		if((*ptr)->tamaño<(pdif)(offsetof(GraFConfig,ARRAY_fichero)/sizeof(uint))){
			nret=ATREAD_BADFORMAT; goto salida_error;
		}
		final=(uint*)(*ptr)+(*ptr)->tamaño;
		for(ptri=&(*ptr)->ARRAY_fichero; ptri<final; ptri++){if(get_bytes23(ptri)==00) break;}
		if(ptri==final){nret=ATREAD_OVERRUN; goto salida_error;}
		if(get_bytes01(ptri)!=00){
			set_bytes01(ptri,u'\n');	//Si aquí no había un '\n', o bien es algo que se ignora o bien es la 'd'
										//de la palabra \end, que se queda en \en. La función que lee detectará que
										//falta un \end al final, pero se leerá bien
		}else{ /*La provisión ptri!=... es porque si el primer carácter ya es 00 no hace falta un salto de línea*/
			if(get_bytes23(ptri-1)!=u'\n' && ptri!=&(*ptr)->ARRAY_fichero) set_bytes01(ptri,u'\n');
		}
	}}

#undef comprueba_tamaño
#undef comprueba_cierre

	//Hasta aquí no se ha reservado memoria para nada más que para el propio
	//elemento GraficoenMemoria (*pfichero) y para el fichero en sí en memoria (base)
	//Separar el fichero en distintas unidades en memoria.
	plist=get_new_plist();
	ifunlike(plist==PLIST_OUT_OF_MEM){plist=PLIST_NULL; goto salida_outofmem;}

	{aj_decl_alloc_n(uint,pelem,uintsizeof(FGraCabecera));
	addto_delete(plist,pelem);
	memcpy_uint(pelem,leido->cabecera,TAMAÑO_CABECERA);
	leido->cabecera=(FGraCabecera*)pelem;}

#define realoja_uintarray(elem,tamaño) \
	if(elem!=NULL){\
		aj_decl_alloc_n(uint,pelem,tamaño);\
		addto_delete(plist,pelem);\
		memcpy_uint(pelem,(uint*)(elem),tamaño);\
		*(uint**)(&(elem))=pelem;\
	}
#define realoja_elemento(elem) realoja_uintarray(elem,((uint*)(elem))[POS_TAMAÑO])
#define realoja_tabla(tabla) realoja_uintarray(tabla.registros,tabla.tamaño)
#define realoja_bloque(bloque) realoja_uintarray(bloque.pos,bloque.tamaño)

	if(leido->keyvals!=NULL){
		//Hay que comprobar que los keyvals están bien enlazados hasta el final del elemento
		//De momento, esto
		telem=leido->keyvals[POS_TAMAÑO];
		if(leido->keyvals[telem-1]==0){
			realoja_uintarray(leido->keyvals,telem);
		}else{
			aj_decl_alloc_n(uint,pelem,telem+1); addto_delete(plist,pelem);
			memcpy_uint(pelem,leido->keyvals,telem);
			pelem[telem]=0;
			leido->keyvals=pelem;
		}
	}
	for(GraFConfig **pfich=&leido->fichero_config[0]; *pfich!=NULL; pfich++){
		realoja_elemento(*pfich);
	}
	realoja_elemento(leido->sistema);
	realoja_tabla(leido->orden_elementos);
	realoja_tabla(leido->tabla_elementos);
	realoja_tabla(leido->tabla_compuestos);
	realoja_tabla(leido->tabla_textos);
	realoja_bloque(leido->bloque_grafico);
	realoja_bloque(leido->bloque_compuestos);
	realoja_bloque(leido->bloque_textos);

	release_plist(plist);
	free(base);
	return 0;

salida_outofmem:
	nret=AT_NOMEM;
error_fichero:
salida_error:
	if(plist!=PLIST_NULL) free_plist(plist);
	free(base);
	NULL_set((void**)leido,usizeof(GraficoLeido)/usizeof(void*));
	return nret;
}

void calcula_sisinterno(FGraSistema *sis_fichero, TerrenoaInterno *sis_interno, double X0, double Y0){
	uint subtipo;
	sis_interno->X0=X0;
	sis_interno->Y0=Y0;
	if(sis_fichero==NULL){
		sis_interno->btipo=0;
		return;
	}
	subtipo=mask_subtipo(sis_fichero->Rectangular.Tipo);
	if(subtipo<SubTIPO_SISTEMA_Geográficas){
		sis_interno->btipo=0;
		return;
	}
	if(subtipo==SubTIPO_SISTEMA_Geográficas){
		double a,e;
		double φ, sinφ, cosφ, sinφ2;
		if(!(sis_fichero->Geográficas.orden&1)){
			sis_interno->btipo=2;
			φ=sis_interno->X0;
		}else{
			sis_interno->btipo=1;
			φ=sis_interno->Y0;
		}
		double___IO_DOUBLE(&a,sis_fichero->Geográficas.a);
		double___IO_DOUBLE(&e,sis_fichero->Geográficas.e);
		φ*=PI_180;

		sis_interno->cos_conv0=1;
		sis_interno->sin_conv0=0;
		sinφ=sin(φ);
		cosφ=cos(φ);
		sinφ2=sinφ*sinφ;
		sis_interno->k0x=1/(PI_180*radN(a,e,sinφ));
		sis_interno->k0y=sis_interno->k0x/ρ_by_N(e,sinφ);
		sis_interno->k0x/=cosφ;
		sis_interno->kxδx=sis_interno->kxδy=0;
		sis_interno->kyδx=0;
		sis_interno->kyδy=1/cosφ+2*e*cosφ/(1-e*sinφ2);
		sis_interno->kyδy*=sis_interno->k0y*sinφ*PI_180;
	}elif(subtipo==SubTIPO_SISTEMA_OrtogonalG){
		double___IO_DOUBLE(&sis_interno->X0,sis_fichero->OrtogonalG.X0);
		double___IO_DOUBLE(&sis_interno->Y0,sis_fichero->OrtogonalG.Y0);
		double___IO_DOUBLE(&sis_interno->cos_conv0,sis_fichero->OrtogonalG.cosγ0);
		double___IO_DOUBLE(&sis_interno->sin_conv0,sis_fichero->OrtogonalG.sinγ0);
		double___IO_DOUBLE(&sis_interno->k0x,sis_fichero->OrtogonalG.k0x);
		double___IO_DOUBLE(&sis_interno->k0y,sis_fichero->OrtogonalG.k0y);
		double___IO_DOUBLE(&sis_interno->kxδy,sis_fichero->OrtogonalG.k[0]);
		double___IO_DOUBLE(&sis_interno->kyδy,sis_fichero->OrtogonalG.k[1]);
		sis_interno->kxδx=sis_interno->kxδy*sis_interno->sin_conv0;
		sis_interno->kxδy*=sis_interno->cos_conv0;
		sis_interno->kyδx=sis_interno->kyδy*sis_interno->sin_conv0;
		sis_interno->kyδy*=sis_interno->cos_conv0;
	}else{//Desconocido
		sis_interno->btipo=0;
	}
}

//Se crea el último duplicado para los polígonos se es necesario, y los de 0 vértices se
//descartan, de modo que como mínimo tendrán 2 vértices, el último igual al primero. (degenerados)
//Las líneas poligonales de menos de 2 vértices también se descartan
int crea_graficoenmemoria(GraficoLeido *leido, GraficoenMemoria *pgrafico){
	double X0,Y0;
	uint tamaño_blogra;

#define EXT leido->cabecera->extremos
	double___IO_DOUBLE(&X0,EXT.mx);
	{double x; double___IO_DOUBLE(&x,EXT.MX);		if(isfinite(x)) X0=0.5*(X0+x);}
	double___IO_DOUBLE(&Y0,EXT.my);
	{double y; double___IO_DOUBLE(&y,EXT.MY);		if(isfinite(y)) Y0=0.5*(Y0+y);}
#undef EXT
	calcula_sisinterno(leido->sistema,&pgrafico->sis_interno,X0,Y0);

	pgrafico->file.cabecera=(uint*)leido->cabecera;	leido->cabecera=NULL;
	pgrafico->file.keyvals=leido->keyvals;				leido->keyvals=NULL;
	pgrafico->file.sistema=(uint*)leido->sistema;		leido->sistema=NULL;

#define copia_tabla_ppio(nombretabla,Type) \
	pgrafico->nombretabla.ppio=(Type*)(leido->nombretabla.registros);\
	pgrafico->nombretabla.end=(Type*)(leido->nombretabla.registros+leido->nombretabla.tamaño);\
	pgrafico->nombretabla.next=pgrafico->nombretabla.end-1;\
	leido->nombretabla.registros=NULL

	copia_tabla_ppio(orden_elementos,uint);
	copia_tabla_ppio(tabla_compuestos,EntradaTablaCompuestos);
	copia_tabla_ppio(tabla_textos,EntradaTablaTextos);
#undef copia_tabla_ppio
	pgrafico->bloque_textos.pos=leido->bloque_textos.pos;
	leido->bloque_textos.pos=NULL;

	{uint nelems=leido->tabla_elementos.tamaño/tamaño_entrada_tabla_elems;
	Growing_setup(EntradaTablaElems,pgrafico->tabla_elementos,nelems,return AT_NOMEM);}

	tamaño_blogra=1; //4-byte inaccesible al principio
	for(EntradaTablaElems *pinfoelem=(EntradaTablaElems*)leido->tabla_elementos.registros; pinfoelem->pos!=0;){
		ifunlike(pinfoelem->pos==Gra_NODATA){pinfoelem++; continue;}

		GraElementoGenerico *pfelem=(GraElementoGenerico*)(leido->bloque_grafico.pos+pinfoelem->pos);
		pinfoelem++;
		tamaño_blogra+=pfelem->H.tamaño;
		 switch(mask_clase(pfelem->H.Clase)){
			uint n;
			case CGRA_Punto:		tamaño_blogra+=TAMAÑOmemPUNTO-TAMAÑOPUNTO; break;
			case CGRA_Poligonal: n=((FGraPoligonal*)pfelem)->n;
										tamaño_blogra+=TAMAÑOmempoligonal(n)-TAMAÑOpoligonal(n);
										break;
			case CGRA_Poligono:	n=((FGraPoligono*)pfelem)->n;
										tamaño_blogra+=TAMAÑOmempoligono(n+1)-TAMAÑOpoligono(n); //Puede ser necesario duplicar el último punto
										break;
			case CGRA_Vector:		tamaño_blogra+=TAMAÑOmemVECTOR-TAMAÑOVECTOR; break;
			case CGRA_Poligonal_escalable: n=((FGraPoligonalEscalable*)pfelem)->n;
										tamaño_blogra+=TAMAÑOmempoligonalesc(n)-TAMAÑOpoligonalesc(n);
										break;
			case CGRA_Elipse:		tamaño_blogra+=TAMAÑOmemELIPSE-TAMAÑOELIPSE_F;				break;
			case CGRA_Elipsoide:	tamaño_blogra+=TAMAÑOmemELIPSOIDE-TAMAÑOELIPSOIDE_F;	break;
			default:					tamaño_blogra+=uintsizeof(ElemenCabecera)-uintsizeof(FGraElemenCabecera);
		}
	}
	checked_malloc_n(pgrafico->bloque_grafico.pos,uint,tamaño_blogra,return AT_NOMEM);

	uint *inbloque=pgrafico->bloque_grafico.pos+1;
	for(EntradaTablaElems *pinfoelem=(EntradaTablaElems*)leido->tabla_elementos.registros; pinfoelem->pos!=0;pinfoelem++,pgrafico->tabla_elementos.next++){
		ifunlike(pinfoelem->pos==Gra_NODATA){ //files are usually compressed (ifunlike)
			pgrafico->tabla_elementos.next->pos=Gra_NODATA;
			continue;
		}
		pgrafico->tabla_elementos.next->pos=(pdif)(inbloque-pgrafico->bloque_grafico.pos);
		pgrafico->tabla_elementos.next->compuesto=pinfoelem->compuesto;

		uint* (*mem___fich)(TerrenoaInterno_ARGS);
		FGraElementoGenerico *pfelem=(FGraElementoGenerico*)(leido->bloque_grafico.pos+pinfoelem->pos);
		switch(mask_clase(pfelem->H.Clase)){
			case CGRA_Punto:		mem___fich=mem___fich_punto; break;
			case CGRA_Poligonal:	mem___fich=mem___fich_poligonal; break;
			case CGRA_Poligono:	mem___fich=mem___fich_poligono; break;
			case CGRA_Vector:		mem___fich=mem___fich_vector; break;
			case CGRA_Poligonal_escalable: mem___fich=mem___fich_poligonal_esc; break;
			case CGRA_Elipse:		mem___fich=mem___fich_elipse; break;
			case CGRA_Elipsoide:	mem___fich=mem___fich_elipsoide; break;
			default: mem___fich=mem___fich_desconocido;
		}
		uint *ret=mem___fich(&pgrafico->sis_interno,(GraElementoGenerico*)inbloque,pfelem);
		ifunlike(ret==NULL){ //Bad element, discarded
			pgrafico->tabla_elementos.next->pos=Gra_NODATA;
		}else{
			inbloque=ret;
		}
	}
	pgrafico->tabla_elementos.next->pos=0; //Closing element

	EntradaTablaElems *ptr=pgrafico->tabla_elementos.ppio;
	while(ptr->pos==Gra_NODATA) continue;
	if(ptr->pos==0){ //The file does not contain any valid element
		zeroset_double(&pgrafico->minmaxI.mx,6);
		return 0;
	}

	setup_extremos3D(pgrafico->minmaxI);
	for(;ptr->pos!=0;ptr++){
		if(ptr->pos==Gra_NODATA) continue;
		ConvexEllipsoide *pE=&((GraElementoGenerico*)(pgrafico->bloque_grafico.pos+ptr->pos))->H.bound;
		double aux;
		aux=sqrtf((float)pE->Σ[0][0]);
		if(pE->P.X-aux<pgrafico->minmaxI.mx) pgrafico->minmaxI.mx=pE->P.X-aux;
		if(pE->P.X+aux>pgrafico->minmaxI.MX) pgrafico->minmaxI.MX=pE->P.X+aux;
		aux=sqrtf((float)pE->Σ[1][1]);
		if(pE->P.Y-aux<pgrafico->minmaxI.my) pgrafico->minmaxI.my=pE->P.Y-aux;
		if(pE->P.Y+aux>pgrafico->minmaxI.MY) pgrafico->minmaxI.MY=pE->P.Y+aux;
		aux=sqrtf((float)pE->Σ[2][2]);
		if(pE->P.Z-aux<pgrafico->minmaxI.mz) pgrafico->minmaxI.mz=pE->P.Z-aux;
		if(pE->P.Z+aux>pgrafico->minmaxI.MZ) pgrafico->minmaxI.MZ=pE->P.Z+aux;
	}
	return 0;
}

void free_leido(GraficoLeido *leido){
	free_null_if(leido->cabecera);
	free_null_if(leido->keyvals);
	free_null_if(leido->sistema);
	for(GraFConfig **ptr=&leido->fichero_config[0];*ptr!=NULL;ptr++){free_null(*ptr);}
	free_null_if(leido->bloque_textos.pos);
	free_null_if(leido->bloque_compuestos.pos);
	free_null_if(leido->bloque_grafico.pos);
	free_null_if(leido->tabla_textos.registros);
	free_null_if(leido->tabla_compuestos.registros);
	free_null_if(leido->tabla_elementos.registros);
	free_null_if(leido->orden_elementos.registros);
}

void free_fgrafico(GraficoenMemoria *pfichero){
	free_null_if(pfichero->bloque_textos.pos);
	free_null_if(pfichero->bloque_compuestos.pos);
	free_null_if(pfichero->bloque_grafico.pos);
	free_null_if(pfichero->tabla_textos.ppio);
	free_null_if(pfichero->tabla_compuestos.ppio);
	free_null_if(pfichero->tabla_elementos.ppio);
	free_null_if(pfichero->orden_elementos.ppio);
	free_null_if(pfichero->file.sistema);
	free_null_if(pfichero->file.keyvals);
	free_null_if(pfichero->file.cabecera);
	free(pfichero);
}
