﻿#define SQRT3 1.73205080756888
#define SQRT_3 0.5773502691896

#define carga_punto(pP,pDUBL) \
	double___IO_DOUBLE(&(pP)->X,(pDUBL)[0]); /*pDUBL may not be incrementable*/ \
	double___IO_DOUBLE(&(pP)->Y,(pDUBL)[1]);\
	double___IO_DOUBLE(&(pP)->Z,(pDUBL)[2])
#define carga_puntof(pP,pFLOAT) \
	float___IO_SINGLE(&(pP)->X,(pFLOAT)[0]);\
	float___IO_SINGLE(&(pP)->Y,(pFLOAT)[1]);\
	float___IO_SINGLE(&(pP)->Z,(pFLOAT)[2])

//Las funciones devuelven la nueva posición del puntero.
//If the element is bat it is discarded and the function returns NULL
#define TerrenoaInterno_ARGS TerrenoaInterno *sis, GraElementoGenerico *pelem, const FGraElementoGenerico *pfelem

#define mem___fich_cabecera(H, fH, tamaño_nuevo) \
	H.Tipo=fH.Tipo; H.Clase=fH.Clase; H.nombre=fH.nombre;\
	H.pos_info=tamaño_nuevo;\
	H.tamaño=tamaño_nuevo+(fH.tamaño-fH.pos_info)

sinline void elipsoide_dosinc(double (*Σ)[3], double *δ){
	double *σ=&Σ[0][0];
	*σ++=*δ**δ;
	*(σ+2)=*σ=*δ*δ[1]; σ++;
	*(σ+4)=*σ=*δ*δ[2]; δ++, σ+=2;
	*σ++=*δ**δ;
	*(σ+2)=*σ=*δ*δ[1]; δ++, σ+=3;
	*σ=*δ**δ;
}
sinline void elipsoide_sobre_segmento(ConvexEllipsoide *elip, PuntoXYZ_double P1,PuntoXYZ_double P2){
	P_eq(P2,-=,P1);
	P_mul(P2,0.5);
	P_op(elip->P,=,P1,+,P2);
	elipsoide_dosinc(elip->Σ,&P2.X);
}

void elipsoide_tresinc(double (*Σ)[3],PuntoXYZ_double P1,PuntoXYZ_double P2,PuntoXYZ_double P3){
	double a,b,c, bc3;
	a=(P2.X-P3.X); //Multiplicando a, b y c por SQRT_3 se eliminan
	b=(P2.Y-P3.Y); //b/3 y c/3, pero puede ser peor para el redondeo
	c=(P2.Z-P3.Z);
	Σ[0][0]=P1.X*P1.X+a*a/3; // =2/3 Σ xx =4/3(x2x2+x3x3-x2x3), etc.
	bc3=b/3;
	Σ[1][0]=Σ[0][1]=a*bc3+P1.X*P1.Y; // =2/3 Σ xy
	Σ[1][1]=b*bc3+P1.Y*P1.Y;
	bc3=c/3;
	Σ[2][0]=Σ[0][2]=a*bc3+P1.X*P1.Z;
	Σ[2][1]=Σ[1][2]=b*bc3+P1.Y*P1.Z;
	Σ[2][2]=c*bc3+P1.Z*P1.Z;
}
sinline void elipsoide_sobre_triangulo(ConvexEllipsoide *elip, PuntoXYZ_double P1,PuntoXYZ_double P2,PuntoXYZ_double P3){
	elip->P.X=(P1.X+P2.X+P3.X)/3;
	elip->P.Y=(P1.Y+P2.Y+P3.Y)/3;
	elip->P.Z=(P1.Z+P2.Z+P3.Z)/3;
	P_eq(P1,-=,elip->P);
	P_eq(P2,-=,elip->P);
	P_eq(P3,-=,elip->P);
	elipsoide_tresinc(elip->Σ,P1,P2,P3);
}

void elipsoide_cuatroinc(double (*Σ)[3],PuntoXYZ_double P1,PuntoXYZ_double P2,PuntoXYZ_double P3,PuntoXYZ_double P4){
	double a,b,c,d,e,f;
	a=P1.X-P2.X;		b=3*P3.X+P4.X;
	c=P1.Y-P2.Y;		d=3*P3.Y+P4.Y;
	e=P1.Z-P2.Z;		f=3*P3.Z+P4.Z;
	double a3=3*a;
			   Σ[0][0]=(a3*a+b*b)/8+P4.X*P4.X; // =3/4 Σ xx
	Σ[1][0]=Σ[0][1]=(a3*c+b*d)/8+P4.X*P4.Y; // =3/4 Σ xy
	Σ[0][2]=Σ[0][2]=(a3*e+b*f)/8+P4.X*P4.Z; // =3/4 Σ xz
			    Σ[1][1]=(3*c*c+d*d)/8+P4.Y*P4.Y;
	Σ[1][2]=Σ[1][2]=(3*c*e+b*f)/8+P4.Y*P4.Z;
			   Σ[2][2]=(3*e*e+f*f)/8+P4.Z*P4.Z;
}
sinline void elipsoide_sobre_tetraedro(ConvexEllipsoide *elip, PuntoXYZ_double P1,PuntoXYZ_double P2, PuntoXYZ_double P3,PuntoXYZ_double P4){
	elip->P.X=(P1.X+P2.X+P3.X+P4.X)/4;
	elip->P.Y=(P1.Y+P2.Y+P3.Y+P4.Y)/4;
	elip->P.Z=(P1.Z+P2.Z+P3.Z+P4.Z)/4;
	P_eq(P1,-=,elip->P);
	P_eq(P2,-=,elip->P);
	P_eq(P3,-=,elip->P);
	P_eq(P4,-=,elip->P);
	elipsoide_cuatroinc(elip->Σ,P1,P2,P3,P4);
}

void elipsoide_sobre_caja(ConvexEllipsoide *elip, Extremos3D_dbl *caja){
	PuntoXYZ_double δ;
	δ.X=0.5*(caja->MX-caja->mx);
	δ.Y=0.5*(caja->MY-caja->my);
	δ.Z=0.5*(caja->MZ-caja->mz);

	elip->P.X=caja->mx+δ.X;
	elip->P.Y=caja->my+δ.Y;
	elip->P.Z=caja->mz+δ.Z;
	P_mul(δ,SQRT3);
	double *pσ=&elip->Σ[0][0];
	*pσ++=δ.X*δ.X;	*pσ++=δ.X*δ.Y;	*pσ++=δ.X*δ.Z;
	*pσ++=δ.Y*δ.X;	*pσ++=δ.Y*δ.Y;		*pσ++=δ.Y*δ.Z;
	*pσ++=δ.Z*δ.X;	*pσ++=δ.Z*δ.Y;		*pσ=δ.Z*δ.Z;
}

uint* mem___fich_punto(TerrenoaInterno_ARGS){
	GraPunto *p2=(GraPunto*)pelem;
	FGraPunto *p1=(FGraPunto*)pfelem;
	mem___fich_cabecera(pelem->H,pfelem->H,TAMAÑOmemPUNTO);

	carga_punto(&p2->P,&p1->X);
	interno___terreno(sis,&p2->P);
	pelem->H.escala=1.0F;
	pelem->H.bound.P=p2->P;
	zeroset_double(&pelem->H.bound.Σ[0][0],9);
	
	return (uint*)pelem+pelem->H.tamaño;
}

uint* mem___fich_poligonal(TerrenoaInterno_ARGS){
	GraPoligonal *p2=(GraPoligonal*)pelem;
	FGraPoligonal *p1=(FGraPoligonal*)pfelem;
	Extremos3D_dbl mM;

	if(p1->n==0) return NULL;
	mem___fich_cabecera(pelem->H,pfelem->H,TAMAÑOmempoligonal(p1->n));

	PuntoXYZ_double *pP;
	IO_DOUBLE *pDUBL;
	pP=&p2->P1;
	pDUBL=&p1->X1;

	p2->n=p1->n;
	carga_punto(pP,pDUBL);
	interno___terreno(sis,pP);
	extremos3D_setonpoint(mM,*pP);
	pP++, pDUBL+=3;
	dontimes(p1->n-1,(pP++,pDUBL+=3)){
		carga_punto(pP,pDUBL);
		interno___terreno(sis,pP);
		extremos3D_updateonpoint(mM,*pP);
	}

	p2->H.escala=1.0;
	pP=&p2->P1;
	if(p2->n>=4){
		if(p2->n==4) elipsoide_sobre_tetraedro(&p2->H.bound,pP[0],pP[1],pP[2],pP[3]);
		else elipsoide_sobre_caja(&p2->H.bound,&mM);
	}else{
		if(p2->n==3) elipsoide_sobre_triangulo(&p2->H.bound,pP[0],pP[1],pP[2]);
		else iflike(p2->n==2) elipsoide_sobre_segmento(&p2->H.bound,pP[0],pP[1]);
		else{ //1
			p2->H.bound.P=p2->P1;
			zeroset_double(&p2->H.bound.Σ[0][0],9);
		}
	}
	return (uint*)pelem+pelem->H.tamaño;
}

uint* mem___fich_poligono(TerrenoaInterno_ARGS){
	GraPoligono *p2=(GraPoligono*)pelem;
	FGraPoligono *p1=(FGraPoligono*)pfelem;
	Extremos3D_dbl mM;
	PuntoXYZ_double *pP;
	IO_DOUBLE *pDUBL;

	if(p1->n==0) return NULL;
	mem___fich_cabecera(pelem->H,pfelem->H,TAMAÑOmempoligono(p1->n));
	p2->n=p1->n;

	pDUBL=&p1->cX;
	carga_punto(&p2->centro,pDUBL);
	interno___terreno(sis,&p2->centro);
	extremos3D_setonpoint(mM,p2->centro);

	pP=&p2->P1;
	pDUBL=&p1->X1;
	dontimes(p1->n,(pP++,pDUBL+=3)){
		carga_punto(pP,pDUBL);
		interno___terreno(sis,pP);
		extremos3D_updateonpoint(mM,*pP);
	}
	if(p2->n==1 || !(p2->P1.X==pP[-1].X && p2->P1.Y==pP[-1].Y && p2->P1.Z==pP[-1].Z)){
		uint naux=TAMAÑOmempoligono(p2->n+1);
		p2->n++;
		p2->H.tamaño+=naux-p2->H.pos_info;
		p2->H.pos_info=naux;
		*pP=p2->P1;
	}

	p2->H.escala=1.0F;
	pP=&p2->P1;
	if(p2->n>=3){
		if(p2->n==3) elipsoide_sobre_tetraedro(&p2->H.bound,p2->centro,pP[0],pP[1],pP[2]);
		else elipsoide_sobre_caja(&p2->H.bound,&mM);
	}else{
		iflike(p2->n==2) elipsoide_sobre_triangulo(&p2->H.bound,p2->centro,pP[0],pP[1]);
		else elipsoide_sobre_segmento(&p2->H.bound,p2->centro,pP[0]);
	}
	return (uint*)pelem+pelem->H.tamaño;
}

uint* mem___fich_vector(TerrenoaInterno_ARGS){
	GraVector *p2=(GraVector*)pelem;
	FGraVector *p1=(FGraVector*)pfelem;
	mem___fich_cabecera(pelem->H,pfelem->H,TAMAÑOmemVECTOR);

	carga_punto(&p2->P,&p1->X);
	carga_puntof(&p2->δp,&p1->δx);
	interno___terreno(sis,&p2->P);

	p2->H.escala=1.0F;
	p2->H.bound.P=p2->P;
	PuntoXYZ_double δP;
	P_eq(δP,=(double),p2->δp);
	elipsoide_dosinc(p2->H.bound.Σ,&δP.X);
	return (uint*)pelem+pelem->H.tamaño;
}

uint* mem___fich_poligonal_esc(TerrenoaInterno_ARGS){
	GraPoligonalEscalable *p2=(GraPoligonalEscalable*)pelem;
	FGraPoligonalEscalable *p1=(FGraPoligonalEscalable*)pfelem;
	Extremos3D_dbl mM;
	union{
		PuntoXYZ_double *pP;
		PuntoXYZ_float *pδ;
	} mem;
	pUFD fich;

	if(p1->n<=1) return NULL;
	mem___fich_cabecera(pelem->H,pfelem->H,TAMAÑOmempoligonalesc(p1->n));
	p2->n=p1->n;

	setup_extremos3D(mM);

	mem.pP=&p2->P1;
	fich.pdbl2=&p1->X1;
	dontimes(p1->n,){
		PuntoXYZ_double Q;
		carga_punto(mem.pP,fich.pdbl2);
		interno___terreno(sis,mem.pP);
		Q=*mem.pP;
		mem.pP++; fich.pdbl2+=3;

		carga_puntof(mem.pδ,fich.pfloat1);
		P_eq(Q,+=(double),*mem.pδ);
		mem.pδ++; fich.pfloat1+=3;

		extremos3D_updateonpoint(mM,Q);
	}

	p2->H.escala=1.0F;
	elipsoide_sobre_caja(&p2->H.bound,&mM);
	/*pP=&p2->P1;
	if(p2->n>=3){
		if(p2->n==3) elipsoide_sobre_tetraedro(&p2->H.bound,p2->centro,pP[0],pP[1],pP[2]);
		else elipsoide_sobre_caja(&p2->H.bound,&mM);
	}else{
		iflike(p2->n==2) elipsoide_sobre_triangulo(&p2->H.bound,p2->centro,pP[0],pP[1]);
	else elipsoide_sobre_segmento(&p2->H.bound,p2->centro,pP[0]);
	}*/
	return (uint*)pelem+pelem->H.tamaño;
}

uint* mem___fich_elipse(TerrenoaInterno_ARGS){
	GraElipse *p2=(GraElipse*)pelem;
	FGraElipse_f *p1=(FGraElipse_f*)pfelem;
	mem___fich_cabecera(pelem->H,pfelem->H,TAMAÑOmemELIPSE);
	carga_punto(&p2->P,&p1->X);
	float_memcpy_IO_SINGLE(&p2->δa.X,&p1->ax,6);
	interno___terreno(sis,&p2->P);

	p2->H.escala=1.0F;
	p2->H.bound.P=p2->P;
	p2->H.bound.Σ[0][0]=p2->δa.X*p2->δa.X+p2->δb.X*p2->δb.X;
	p2->H.bound.Σ[1][0]=p2->H.bound.Σ[0][1]=p2->δa.X*p2->δa.Y+p2->δb.X*p2->δb.Y;
	p2->H.bound.Σ[2][0]=p2->H.bound.Σ[0][2]=p2->δa.X*p2->δa.Z+p2->δb.X*p2->δb.Z;
	p2->H.bound.Σ[1][1]=p2->δa.Y*p2->δa.Y+p2->δb.Y*p2->δb.Y;
	p2->H.bound.Σ[2][1]=p2->H.bound.Σ[1][2]=p2->δa.Y*p2->δa.Z+p2->δb.Y*p2->δb.Z;
	p2->H.bound.Σ[2][2]=p2->δa.Z*p2->δa.Z+p2->δb.Z*p2->δb.Z;

	return (uint*)pelem+pelem->H.tamaño;
}

uint* mem___fich_elipsoide(TerrenoaInterno_ARGS){
	GraElipsoide *p2=(GraElipsoide*)pelem;
	FGraElipsoide_f *p1=(FGraElipsoide_f*)pfelem;
	mem___fich_cabecera(pelem->H,pfelem->H,TAMAÑOmemELIPSOIDE);

	carga_punto(&p2->P,&p1->X);
	float_memcpy_IO_SINGLE(&p2->σxx,&p1->σxx,6);
	interno___terreno(sis,&p2->P);

	p2->H.escala=1.0F;
	p2->H.bound.P=p2->P;
	p2->H.bound.Σ[0][0]=p2->σxx;
	p2->H.bound.Σ[1][0]=p2->H.bound.Σ[0][1]=p2->σxy;
	p2->H.bound.Σ[1][1]=p2->σyy;
	p2->H.bound.Σ[2][0]=p2->H.bound.Σ[0][2]=p2->σxz;
	p2->H.bound.Σ[2][1]=p2->H.bound.Σ[1][2]=p2->σyz;
	p2->H.bound.Σ[2][2]=p2->σzz;

	return (uint*)pelem+pelem->H.tamaño;
}

uint* mem___fich_desconocido(TerrenoaInterno_ARGS){
	uint t=pfelem->H.tamaño+uintsizeof(ElemenCabecera)-uintsizeof(FGraElemenCabecera);
	mem___fich_cabecera(pelem->H,pfelem->H,t);
	pelem->H.escala=1.0F;
	oneset_uint(&pelem->H.bound,uintsizeof(pelem->H.bound));
	return (uint*)pelem+pelem->H.tamaño;
}
