﻿void Vista::default_values_identity(){
	sis_vista.identity=true;
	zeroset_double(&sis_vista.M[0][0],9);
	sis_vista.M[0][0]=sis_vista.M[1][1]=sis_vista.M[2][2]=1;
	sis_vista.active_depth=0;
	square=1;
	lienzo.matriz=NULL;
	graphic_elems.info_elems.ppio=NULL;
}
void Vista::default_values_other(double _M[3][3]){
	sis_vista.identity=false;
	memcpy_double(&sis_vista.M[0][0],&_M[0][0],9);
	sis_vista.active_depth=0;
	square=1;
	lienzo.matriz=NULL;
	graphic_elems.info_elems.ppio=NULL;
}
inline void Vista::recalcula_ExtremosV(){
	setup_extremos3D(sis_vista.ExtremosV);
	for(ElementoenVista *pelem=graphic_elems.info_elems.ppio;pelem!=graphic_elems.info_elems.next;pelem++){
		extremos3D_updateonext(sis_vista.ExtremosV,pelem->minmax);
	}
}

int Vista::calcula_sis_lienzo(){
	float ancho, alto;
	struct{double Tx,Ty,lx,ly;} aux;

	ancho=(float)(ventana.MX-ventana.mx);
	alto=(float)(ventana.MY-ventana.my);
	if(minmaxV.mx==minmaxV.MX) aux.lx=0;
	else aux.lx=ancho/(minmaxV.MX-minmaxV.mx);
	if(minmaxV.my==minmaxV.MY) aux.ly=0;
	else aux.ly=alto/(minmaxV.MY-minmaxV.my);
	if(aux.lx>Gra_VALUE_MAX || aux.ly>Gra_VALUE_MAX) return 1;
	double fx,fy;
	fx=ancho*(minmaxV.MY-minmaxV.my);
	fy=alto*(minmaxV.MX-minmaxV.mx);
	if(fx>fy && alto!=0){
		double dif;
		dif=0.5F*(fx-fy)/alto;
		minmaxV.mx-=dif;
		minmaxV.MX+=dif;
		aux.lx=aux.ly;
	}
	aux.ly=-aux.ly;		//El sistema de coodenadas de la ventana va al revés
	aux.Tx=ventana.mx-aux.lx*minmaxV.mx;
	aux.Ty=ventana.my-aux.ly*minmaxV.MY;	//Lo mismo
	if(aux.Tx<-MAX_ZOOM || aux.Tx>MAX_ZOOM || aux.Ty<-MAX_ZOOM || aux.Ty>MAX_ZOOM) return 1;
	sis_lienzo.Tx=aux.Tx;
	sis_lienzo.Ty=aux.Ty;
	sis_lienzo.l=aux.lx;
	return 0;
}
int Vista::calcula_minmaxV(){
	Extremos2D_dbl aux2D;
	aux2D.mx=(ventana.mx-sis_lienzo.Tx)/sis_lienzo.l;
	aux2D.MX=(ventana.MX-sis_lienzo.Tx)/sis_lienzo.l;
	aux2D.my=-(ventana.MY-sis_lienzo.Ty)/sis_lienzo.l;
	aux2D.MY=-(ventana.my-sis_lienzo.Ty)/sis_lienzo.l;
	if(aux2D.mx<-Gra_VALUE_MAX || aux2D.MX>Gra_VALUE_MAX || aux2D.my<-Gra_VALUE_MAX || aux2D.MY>Gra_VALUE_MAX)
		return 1;
	return 0;
}

inline void Vista::interno_a_vista(PuntoXYZ_double *P){
	if(sis_vista.identity) return;
	AutoGiraPunto_dbl(P,sis_vista.M);
}
inline void Vista::vista_a_interno(PuntoXYZ_double *P){
	if(sis_vista.identity) return;
	AutoGiraPunto_inv_dbl(P,sis_vista.M);
}
inline Puntoxy_float Vista::vista_a_lienzo(PuntoXYZ_double P){
	Puntoxy_float p;
	p.x=(float)(P.X*sis_lienzo.l+sis_lienzo.Tx);
	p.y=(float)(-P.Y*sis_lienzo.l+sis_lienzo.Ty);
	return p;
}
inline Puntoxy_float Vista::vista_a_lienzo(PuntoXYZ_double *P){
	Puntoxy_float p;
	p.x=(float)(P->X*sis_lienzo.l+sis_lienzo.Tx);
	p.y=(float)(-P->Y*sis_lienzo.l+sis_lienzo.Ty);
	return p;
}
inline void Vista::vista_a_lienzo_array(PuntoXYZ_double* P,uint n, Puntoxy_float *ppunto){
	dontimes(n,(P++,ppunto++)) *ppunto=vista_a_lienzo(P);
}
inline PuntoXYZ_double Vista::lienzo_a_vista(float x, float y){
	PuntoXYZ_double P;
	P.X=(x-sis_lienzo.Tx)/sis_lienzo.l;
	P.Y=-(y-sis_lienzo.Ty)/sis_lienzo.l;
	P.Z=sis_vista.active_depth;
	return P;
}
inline PuntoXYZ_double Vista::lienzo_a_vista(Puntoxy_float p){
	return Vista::lienzo_a_vista(p.x,p.y);
}
inline Puntoxy_float Vista::interno_a_lienzo(PuntoXYZ_double P){
	interno_a_vista(&P);
	return vista_a_lienzo(P);
}
inline void Vista::interno_a_lienzo_array(PuntoXYZ_double* P,uint n, Puntoxy_float *ppunto){
	durchlaufei(PuntoXYZ_double,P,n) interno_a_vista(ptri);
	vista_a_lienzo_array(P,n,ppunto);
}
inline PuntoXYZ_double Vista::lienzo_a_interno(float x, float y){
	PuntoXYZ_double P=lienzo_a_vista(x,y);
	vista_a_interno(&P);
	return P;
}
inline Puntoxy_float Vista::ventana_a_lienzo(float x,float y){
	Puntoxy_float p;
	p.x=x+ventana.mx;
	p.y=y+ventana.my;
	return p;
}
inline PuntoXYZ_double Vista::ventana_a_interno(float x,float y){
	Puntoxy_float q;
	q=ventana_a_lienzo(x,y);
	return lienzo_a_interno(q.x,q.y);
}

inline int Vista::desplaza_ventana(ssint dx, ssint dy){
	return cambia_tamanno_ventana(dx,dy,dx,dy);
}
inline int Vista::cambia_tamanno_ventana(ssint dx, ssint dy, ssint DX, ssint DY){
	ventana.mx+=dx;	ventana.MX+=DX;
	ventana.my+=dy;	ventana.MY+=DY;
	if(ventana.mx<-MAX_LIENZO || ventana.MX>MAX_LIENZO || ventana.my<-MAX_LIENZO || ventana.MY>MAX_LIENZO){
		ventana.mx-=dx;	ventana.MX-=DX;
		ventana.my-=dy;	ventana.MY-=DY;
		return 1;
	}
	return 0;
}
inline int Vista::zoom(float x, float y, float X, float Y){
	if(x==X || y==Y) return 1;
	if(ventana.mx==ventana.MX || ventana.my==ventana.MY) return 1;
	if(x>=X){float aux=x; x=X; X=aux;}
	if(y>=Y){float aux=y; y=Y; Y=aux;}

	PuntoXYZ_double P, Q;
	P=lienzo_a_vista(ventana_a_lienzo(x,y));
	Q=lienzo_a_vista(ventana_a_lienzo(X,Y));
	if(P.X<-Gra_VALUE_MAX || P.Y>Gra_VALUE_MAX || Q.X>Gra_VALUE_MAX || Q.Y<-Gra_VALUE_MAX) return 1;
	minmaxV.mx=P.X;
	minmaxV.my=Q.Y;
	minmaxV.MX=Q.X;
	minmaxV.MY=P.Y;
	return calcula_sis_lienzo();
}
inline void Vista::invalida_lienzo(){
	colorset_none(lienzo.matriz,lienzo.nrows*lienzo.ncols);
}

int Vista::desplaza_lienzo(ssint offset_x, ssint offset_y){
	int offset;
	offset=offset_y*lienzo.ncols+offset_x;

	if(offset==0) return 0;
	{double tx,ty;
	tx=fabs(sis_lienzo.Tx+offset_x);
	ty=fabs(sis_lienzo.Ty+offset_y);
	if(tx>MAX_ZOOM || ty>MAX_ZOOM) return 1;}

	ventana.mx+=offset_x;		ventana.MX+=offset_x;
	ventana.my+=offset_y;		ventana.MY+=offset_y;
	if(ventana.mx<-MAX_LIENZO || ventana.MX>MAX_LIENZO || ventana.my<-MAX_LIENZO || ventana.MY>MAX_LIENZO){
		ventana.mx-=offset_x;		ventana.MX-=offset_x;
		ventana.my-=offset_y;		ventana.MY-=offset_y;
		return 1;
	}
	sis_lienzo.Tx+=offset_x;
	sis_lienzo.Ty+=offset_y;

	{uint ofx, ofy;
	if(offset_x>=0) ofx=offset_x; else ofx=-offset_x;
	if(offset_y>=0) ofy=offset_y; else ofy=-offset_y;
	if(ofx>=lienzo.ncols || ofy>=lienzo.nrows){
		colorset_none(lienzo.matriz,lienzo.nrows*lienzo.ncols);
		return 0;
	}}

	if(offset>0){
		color *ptrb, *ptr;
		ptrb=lienzo.matriz+lienzo.ncols*lienzo.nrows-1;
		ptr=ptrb-offset;
		if(offset_x>=0){
			uint k=lienzo.ncols-offset_x;
			dontimes(lienzo.nrows-offset_y,){
				dontimes(k,*ptrb--=*ptr--);
				dontimes(offset_x,*ptrb--=NO_COLOR);
				ptr-=offset_x;
			}
		}else{
			offset_x=-offset_x;
			uint k=lienzo.ncols-offset_x;
			dontimes(lienzo.nrows-offset_y,){
				ptr-=offset_x;
				dontimes(offset_x,*ptrb--=NO_COLOR);
				dontimes(k,*ptrb--=*ptr--);
			}
		}
		if(offset_y)
			colorset_none(lienzo.matriz,lienzo.ncols*offset_y);
	}else{
		offset_y=-offset_y;
		color *ptrb, *ptr;
		ptrb=lienzo.matriz;
		ptr=ptrb-offset;
		if(offset_x>=0){
			uint k=lienzo.ncols-offset_x;
			dontimes(lienzo.nrows-offset_y,){
				ptr+=offset_x;
				dontimes(offset_x,*ptrb++=NO_COLOR);
				dontimes(k,*ptrb++=*ptr++);
			}
		}else{
			offset_x=-offset_x;
			uint k=lienzo.ncols-offset_x;
			dontimes(lienzo.nrows-offset_y,){
				dontimes(k,*ptrb++=*ptr++);
				dontimes(offset_x,*ptrb++=NO_COLOR);
				ptr+=offset_x;
			}
		}
		if(offset_y)
			colorset_none(lienzo.matriz+lienzo.ncols*(lienzo.nrows-offset_y),lienzo.ncols*offset_y);
	}
	return 0;
}

//Funciones para llamar desde código que no es C++
PuntoXYZ_double V_ventana_a_interno(Vista *vista, float x,float y){
	return vista->ventana_a_interno(x,y);
}
int V_calcula_sis_lienzo(Vista *vista){
	return vista->calcula_sis_lienzo();
}
int V_desplaza_ventana(Vista *vista, ssint dx, ssint dy){
	return vista->desplaza_ventana(dx,dy);
}
int V_cambia_tamanno_ventana(Vista *vista, ssint dx, ssint dy, ssint DX, ssint DY){
	return vista->cambia_tamanno_ventana(dx,dy,DX,DY);
}
int V_zoom(Vista *vista, float x, float y, float X, float Y){
	return vista->zoom(x,y,X,Y);
}
void V_invalida_lienzo(Vista *vista){
	vista->invalida_lienzo();
}

void obtiene_invalido(Vista *vista, RectVentana rect, RectVentana *invalido){
	rect.x0+=vista->ventana.mx;
	rect.y0+=vista->ventana.my;
	if((rect.x0<0 || (uint)(rect.x0+rect.ancho)>vista->lienzo.ncols)
	  && (rect.y0<0 || (uint)(rect.y0+rect.alto)>vista->lienzo.nrows)){
		   goto return_todo;
	}
	if(rect.x0<0){
		ssint tope=rect.x0+rect.ancho;
		if(tope<=0 || (uint)tope>vista->lienzo.ncols) goto return_todo;

		invalido->x0=rect.x0-vista->ventana.mx;
		invalido->ancho=-rect.x0;
		invalido->y0=rect.y0-vista->ventana.my;
		invalido->alto=rect.alto;

		color *ptri=vista->lienzo.matriz+rect.y0*vista->lienzo.ncols;
		dontimes((uint)rect.alto,ptri+=vista->lienzo.ncols){
			color *ptrj=ptri+rect.ancho-invalido->ancho;
			while(ptrj!=ptri){
				if(*--ptrj==NO_COLOR){ ++ptrj;
					invalido->ancho+=(pdif)(ptrj-ptri);
					ptri=ptrj;
					break;
			}	}
		}
		return;
	}elif((uint)(rect.x0+rect.ancho)>vista->lienzo.ncols){
		if((uint)rect.x0>=vista->lienzo.ncols) goto return_todo;

		invalido->x0=vista->lienzo.ncols-vista->ventana.mx;
		invalido->ancho=(uint)(rect.x0+rect.ancho)-vista->lienzo.ncols;
		invalido->y0=rect.y0-vista->ventana.my;
		invalido->alto=rect.alto;

		color *ptri=vista->lienzo.matriz+rect.y0*vista->lienzo.ncols+vista->lienzo.ncols;
		dontimes((uint)rect.alto,ptri+=vista->lienzo.ncols){
			color *ptrj=ptri-(rect.ancho-invalido->ancho);
			while(ptrj!=ptri){
				if(*ptrj++==NO_COLOR){ ptrj--;
					invalido->x0-=(pdif)(ptri-ptrj);
					invalido->ancho+=(pdif)(ptri-ptrj);
					ptri=ptrj;
					break;
			}	}
		}
		return;
	}
	if(rect.y0<0){
		ssint tope=rect.y0+rect.alto;
		if(tope<=0 || (uint)tope>vista->lienzo.nrows) goto return_todo;

		invalido->x0=rect.x0-vista->ventana.mx;
		invalido->ancho=rect.ancho;
		invalido->y0=rect.y0-vista->ventana.my;
		invalido->alto=-rect.y0;

		color *ptri=vista->lienzo.matriz+tope*vista->lienzo.ncols+rect.x0;
		fordown(i,(uint)tope,ptri-=vista->lienzo.ncols){
			color *ptrj=ptri;
			dontimes(rect.ancho,ptrj++){
				if(*ptrj==NO_COLOR){invalido->alto+=i+1; return;}
			}
		}
		return;
	}elif((uint)(rect.y0+rect.alto)>vista->lienzo.nrows){
		if((uint)rect.y0>=vista->lienzo.nrows) goto return_todo;

		invalido->x0=rect.x0-vista->ventana.mx;
		invalido->ancho=rect.ancho;
		invalido->y0=vista->lienzo.nrows-vista->ventana.my;
		invalido->alto=(uint)(rect.y0+rect.alto)-vista->lienzo.nrows;

		color *ptri=vista->lienzo.matriz+rect.y0*vista->lienzo.ncols+rect.x0;
		fordown(i,vista->lienzo.nrows-(uint)rect.y0,ptri+=vista->lienzo.ncols){
			color *ptrj=ptri;
			dontimes(rect.ancho,ptrj++){
				if(*ptrj==NO_COLOR){ ++i;
					invalido->y0-=i;
					invalido->alto+=i;
					return;
				}
			}
		}
		return;
	}
	if(0){
return_todo:
		rect.x0-=vista->ventana.mx;
		rect.y0-=vista->ventana.my;
		*invalido=rect;
		return;
	}

	color *ptr=vista->lienzo.matriz+rect.y0*vista->lienzo.ncols+rect.x0;
	uint salto=vista->lienzo.ncols-rect.ancho;
	uint xmax, ymax;	//el primero que _no_ es NO_COLOR
	uint i;
	for(i=0;i<(uint)rect.alto;i++,ptr+=salto){
		fallvar(j,(uint)rect.ancho,ptr++){if(*ptr==NO_COLOR) break;}
		if(++j!=0){
			invalido->x0=rect.ancho-j;
			color *ptrk=ptr+j;
			while(--ptrk!=ptr && *ptrk!=NO_COLOR);
			xmax=invalido->x0+(pdif)(ptrk+1-ptr);
			ptr+=j+salto;	//principio de la fila siguiente
			break;
		}
	}
	if(i==(uint)rect.alto){
		invalido->x0=invalido->y0=0;
		invalido->ancho=invalido->alto=0;
		return;
	}
	invalido->y0=i++;
	ymax=i;
	for(;i<(uint)rect.alto;ptr+=vista->lienzo.ncols){
		color *ptrtope;

		ptrtope=ptr+invalido->x0;
		color *ptrj=ptr;
		while(ptrj!=ptrtope && *ptrj!=NO_COLOR) ptrj++;
		invalido->x0=(pdif)(ptrj-ptr);	//vuelve a asignar el mismo valor si no se ha encontrado uno NO_COLOR

		ptrtope=ptr+xmax;
		color *ptrk=ptr+rect.ancho;
		while(ptrk--!=ptrtope && *ptrk!=NO_COLOR);
		xmax=(pdif)(ptrk+1-ptr);

		if(*ptrk==NO_COLOR) ptrj=ptrk;
		while(ptrj!=ptrk){
			if(*ptrj==NO_COLOR) break;
			ptrj++;
		}
		i++;
		if(*ptrj==NO_COLOR) ymax=i;
	}
	invalido->ancho=xmax-invalido->x0;
	invalido->alto=ymax-invalido->y0;
	invalido->x0+=rect.x0-vista->ventana.mx;
	invalido->y0+=rect.y0-vista->ventana.my;
}

/*Calcula los valores máximos y mínimos en el sistema vista.
Reserva espacio para lienzo y situa la ventana centrada en él, de acuerdo a los valores
de nrows y ncols, que pueden ser negativos. Llena el lienzo con el valor NO_COLOR;
Reserva espacio para InfoVista y sus elementos, y lo rellena.
Devuelve AT_NOMEM si no hay memoria*/
int _setup_vista(Vista *vista, int nrows_v, int ncols_v, GraficoenMemoria *pfichero){
	vista->lienzo.nrows=1440;
	vista->lienzo.ncols=1080;
	{uint naux=nrows_v; if(nrows_v<0) naux=-nrows_v;
	if(naux>vista->lienzo.nrows) vista->lienzo.nrows=naux;}
	{uint naux=ncols_v; if(ncols_v<0) naux=-ncols_v;
	if(naux>vista->lienzo.ncols) vista->lienzo.ncols=naux;}
	aj_malloc_return(vista->lienzo.matriz,color,vista->lienzo.nrows*vista->lienzo.ncols);
	vista->ventana.mx=(vista->lienzo.ncols-(uint)ncols_v)>>1;
	vista->ventana.MX=vista->ventana.mx+(uint)ncols_v;
	vista->ventana.my=(vista->lienzo.nrows-(uint)nrows_v)>>1;
	vista->ventana.MY=vista->ventana.my+(uint)nrows_v;
	colorset_none(vista->lienzo.matriz,vista->lienzo.ncols*vista->lienzo.nrows);

	uint nelems;
	nelems=(pdif)(pfichero->tabla_elementos.next-pfichero->tabla_elementos.ppio);
	aj_malloc_return(vista->graphic_elems.info_elems.ppio,ElementoenVista,nelems);
	vista->graphic_elems.info_elems.end=vista->graphic_elems.info_elems.ppio+nelems;
	oneset_uint(vista->graphic_elems.info_elems.ppio,nelems*uintsizeof(ElementoenVista));

#define PTRnext vista->graphic_elems.info_elems.next
	PTRnext=vista->graphic_elems.info_elems.ppio;
	setup_extremos3D(vista->sis_vista.ExtremosV);
	for(EntradaTablaElems *pinfoelem=pfichero->tabla_elementos.ppio;pinfoelem->pos!=0;pinfoelem++,PTRnext++){
		GraElementoGenerico *pelem;
		PuntoXYZ_double P;
		double E[3][3], aux;

		if(pinfoelem->pos==Gra_NODATA) continue;
		pelem=(GraElementoGenerico*)(pfichero->bloque_grafico.pos+pinfoelem->pos);
		P=pelem->H.bound.P;
		vista->interno_a_vista(&P);
		PTRnext->escala_minmax=pelem->H.escala;
		if(vista->sis_vista.identity){
			E[0][0]=pelem->H.bound.Σ[0][0];
			E[1][1]=pelem->H.bound.Σ[1][1];
			E[2][2]=pelem->H.bound.Σ[2][2];
		}else{
			//gira_elipsoide(E,vista->sis_vista.M,pelem->H.bound);
		}
		aux=sqrtf((float)E[0][0]);	PTRnext->minmax.mx=P.X-aux;	PTRnext->minmax.MX=P.X+aux;
		aux=sqrtf((float)E[1][1]);		PTRnext->minmax.my=P.Y-aux;	PTRnext->minmax.MY=P.Y+aux;
		aux=sqrtf((float)E[2][2]);	PTRnext->minmax.mz=P.Z-aux;	PTRnext->minmax.MZ=P.Z+aux;
		extremos3D_updateonext(vista->sis_vista.ExtremosV,PTRnext->minmax);
		switch(mask_clase(pelem->H.Clase)){
			case CGRA_Punto: case CGRA_Vector:
			case CGRA_Elipse: case CGRA_Elipsoide:
				PTRnext->minmax_opt=1; break;
			default: PTRnext->minmax_opt=0;
		}
	}
#undef PTRnext
	return 0;
}
int setup_vista_identity(Vista *vista, int nrows_v, int ncols_v, GraficoenMemoria *pfichero){
	vista->default_values_identity();
	return _setup_vista(vista,nrows_v,ncols_v, pfichero);
}
int setup_vista(Vista *vista, double M[3][3], int nrows_v, int ncols_v, GraficoenMemoria *pfichero){
	vista->default_values_other(M);
	return _setup_vista(vista,nrows_v,ncols_v, pfichero);
}
void free_vista(Vista *vista){
	free_null_if(vista->graphic_elems.info_elems.ppio);
	free_null_if(vista->lienzo.matriz);
}

void calcula_sis_lienzo_ajustado(Vista *vista, float margen){
	double d;
	vista->recalcula_ExtremosV();
	d=margen*(vista->sis_vista.ExtremosV.MX-vista->sis_vista.ExtremosV.mx);
	vista->minmaxV.mx=vista->sis_vista.ExtremosV.mx-d;
	vista->minmaxV.MX=vista->sis_vista.ExtremosV.MX+d;

	d=margen*(vista->sis_vista.ExtremosV.MY-vista->sis_vista.ExtremosV.my);
	vista->minmaxV.my=vista->sis_vista.ExtremosV.my-d;
	vista->minmaxV.MY=vista->sis_vista.ExtremosV.MY+d;
	vista->calcula_sis_lienzo();
};
