﻿#define Q_Total (Q_unknown+10)
/*extern*/ GraphicQualityInfo QualityInfos[]={
	[Q_All]={u"All",QValtype_None,QCat_All},			//special
	[Q_Color]={u"Color",QValtype_hex,QCat_Color},
	[Q_ColorP]={u"ColorP",QValtype_hex,QCat_Color},
	[Q_Color2]={u"Color2",QValtype_hex,QCat_Color},
	[Q_FormaP]={u"FormaP",QValtype_dec,QCat_FormaP},	
	[Q_Grosor]={u"Grosor",QValtype_float,QCat_Size},
	[Q_Grosor2]={u"Grosor",QValtype_float,QCat_Size},
	[Q_GrosorT]={u"GrosorT",QValtype_float,QCat_SizeT},
	[Q_GrosorT2]={u"GrosorT",QValtype_float,QCat_SizeT},
	[Q_Escala]={u"Escala",QValtype_float,QCat_Escala},
	[Q_Estilol]={u"Estilol",QValtype_dec,QCat_Estilol},
	[Q_Estilol2]={u"Estilol",QValtype_dec,QCat_Estilol},
	[Q_EstiloV]={u"EstiloV",QValtype_dec,QCat_EstiloV},
	[Q_ModoRadios]={u"ModoRadios",QValtype_flags,QCat_ModoRadios},  //00 ... 11
	[Q_ModoBR]={u"ModoBR",QValtype_flags,QCat_ModoBR},  //00 ... 11
	[Q_SizeT]={u"SizeT",QValtype_float,QCat_SizeT},
	[Q_Font]={u"Font",QValtype_string,QCat_FontName},
	[Q_Size]={u"Size",QValtype_float,QCat_Size},
	[Q_unknown]={NULL,QValtype_string,QCat_Desconocido},
	[Q_unknown+1]={NULL,QValtype_string,QCat_Desconocido},
	[Q_unknown+2]={NULL,QValtype_string,QCat_Desconocido},
	[Q_unknown+3]={NULL,QValtype_string,QCat_Desconocido},
	[Q_unknown+4]={NULL,QValtype_string,QCat_Desconocido},
	[Q_unknown+5]={NULL,QValtype_string,QCat_Desconocido},
	[Q_unknown+6]={NULL,QValtype_string,QCat_Desconocido},
	[Q_unknown+7]={NULL,QValtype_string,QCat_Desconocido},
	[Q_unknown+8]={u"Desconocido",QValtype_string,QCat_Desconocido},
	[Q_unknown+9]={NULL,QValtype_string,QCat_Desconocido}
};

//Libera una hash uintdata. La función que libera tiene que llamarse free_<elemtype>
#define freehash_if(hash,elemtype) \
	if(hash.ppio!=NULL){\
		durchHashi(merge(h,elemtype),hash){ if(ptri->key!=Я) merge(free_,elemtype)(&ptri->data);}\
		free(hash.ppio);\
	}

//this will not be a long list
void free_linkedQuality(LinkedQuality *plist){
	functionfree_if(plist->next, free_linkedQuality);
	if(plist->q.from.kind==QFrom_None && QualityInfos[plist->q.nqual].val_type==QValtype_string
		&& plist->q.value.ptr!=NULL) free(plist->q.value.ptr);
	free(plist);
}

void free_linkedSubtipos(LinkedConfigSubtipo *plist){
	functionfree_if(plist->next, free_linkedSubtipos);
	functionfree_if(plist->S.cualid_texto, free_linkedQuality);
	functionfree_if(plist->S.cualidades, free_linkedQuality);
	freeif(plist->S.SignificadoR.string);
	freeif(plist->S.Significado.string);
	if(plist->criterio.kind>=CriterioSub_Array) free((void*)plist->criterio.valor.array);
	free(plist);
}

void free_ConfigTipo(ConfigTipo *ctipo){
	functionfree_if(ctipo->subtipos, free_linkedSubtipos);
	functionfree_if(ctipo->cualid_texto, free_linkedQuality);
	functionfree_if(ctipo->cualidades, free_linkedQuality);
	freeif(ctipo->SignificadoR.string);
	freeif(ctipo->Significado.string);
}
void free_Agrupacion(Agrupacion *ctipo){
	/*to be defined*/
	freeif(ctipo->Significado);
	free(ctipo);
}

void free_seleccion(Seleccion *seleccion){	//free the contents, not itself
	return;
}

void free_LinkedJerarquia(LinkedJerarquia *plist){
	while(plist!=NULL){
		LinkedJerarquia *next;
		free_seleccion(&plist->criterio);
		next=plist->next;
		free(plist);
		plist=next;
	}
}

//this in the future podrá poder ser largo, too
void free_LinkedSeleccionVer(LinkedSeleccionVer *plist){
	functionfree_if(plist->next,free_LinkedSeleccionVer);
	free_seleccion(&plist->criterio);
	free(plist);
}

void free_LinkedGrupoFormas(LinkedGrupoFormas *plist){
	while(plist!=NULL){
		LinkedGrupoFormas *next;
		freeif(plist->matrices);
		next=plist->next;
		free(plist);
		plist=next;
	}
}

void free_fconfiguracion(FConfiguracion *fconfig){
	freeif(fconfig->files_depend);
	freeif(fconfig->ficheros.fformas);
	freehash_if(fconfig->tipos,ConfigTipo);
	if(fconfig->agrupaciones!=NULL){
		durchlaufei(Agrupacion*,*fconfig->agrupaciones,256){
			functionfree_if(*ptri,free_Agrupacion);
		}
		free(fconfig->agrupaciones);
	}
	functionfree_if(fconfig->jerarquias,free_LinkedJerarquia);
	freeif(fconfig->ver_info.ver.ppio);
	freeif(fconfig->ver_info.verT.ppio);
	free_null(fconfig);
}

/** Solved **/
void free_linkedSolvedQuality(LinkedSolvedQuality *plist){
	functionfree_if(plist->next, free_linkedSolvedQuality);
	free(plist);
}

#define linkedSolvedQuality_freeif(plist) \
	if(plist!=NULL && (plist)->nqual!=Q_All) free_linkedSolvedQuality(plist)

void free_linkedSolvedSubtipos(LinkedSolvedSubtipo *plist){
	functionfree_if(plist->next, free_linkedSolvedSubtipos);
	linkedSolvedQuality_freeif(plist->sub.Q.cualid_texto);
	linkedSolvedQuality_freeif(plist->sub.Q.cualidades);
	free(plist);
}
void free_SolvedTipo(SolvedTipo *psolved){
	functionfree_if(psolved->subtipos, free_linkedSolvedSubtipos);
	freeif(psolved->orphan_subtipos.ppio);
	linkedSolvedQuality_freeif(psolved->Q.cualidades);
	linkedSolvedQuality_freeif(psolved->Q.cualid_texto);
	freeif(psolved->statusS.tipos_depend);
	freeif(psolved->statusQ.tipos_depend);
}

static const char16_t NULLNAME[2]=u"";
void free_Configgra(Gra_Configuracion *config){
	if(config->nombre!=NULLNAME){free_null_if(config->nombre);}
	functionfree_if(config->fconfig,free_fconfiguracion);	config->fconfig=NULL;
	functionfree_if(config->pformas,free_LinkedGrupoFormas); config->pformas=NULL;
	freehash_if(config->solved,SolvedTipo);
}
