﻿#include "polinomio3.h"

//assumed n>=2 y seleccionados tiene espacio para n.
void selecciona_puntos_separados_n(Puntoxy_double* puntos, uint npuntos, uint n, uint *seleccionados){
	double* sumd;
	int2 kk=selecciona_extremos_rapido(puntos,npuntos,2*usizeof(Puntoxy_double));
	seleccionados[0]=kk.n1;
	seleccionados[1]=kk.n2;

	sumd=n_malloc(double,npuntos);
	ifunlike(sumd==NULL){
		for(uint i=2; i<n;i++) seleccionados[i]=i;
		if(seleccionados[0]<n && seleccionados[0]>=2){
			if(seleccionados[1]==0) seleccionados[seleccionados[0]]=1;
			else seleccionados[seleccionados[0]]=0;
		}
		if(seleccionados[1]<n && seleccionados[1]>=2){
			if(seleccionados[0]==1) seleccionados[seleccionados[1]]=0;
			else seleccionados[seleccionados[1]]=1;
		}
		return;
	}
	zeroset_double(sumd,npuntos);

	sumd[seleccionados[0]]=-1.0;
	sumd[seleccionados[1]]=-1.0;
	{Puntoxy_double p=puntos[2*seleccionados[0]];
	Puntoxy_double *ptri=puntos;
	double *psum=sumd;
	dontimes(n,(ptri+=2,psum++)){
		if(*psum<0) continue;
		double aux=ptri->x-p.x; aux*=aux;
		aux+=(ptri->y-p.y)*(ptri->y-p.y);
		*psum=1/aux;
	}}
	for(uint k=2;k<n;k++){
		Puntoxy_double p=puntos[2*seleccionados[k-1]];
		Puntoxy_double *ptri=puntos;
		double *psum=sumd;
		dontimes(n,(ptri+=2,psum++)){
			if(*psum<0) continue;
			double aux=ptri->x-p.x; aux*=aux;
			aux+=(ptri->y-p.y)*(ptri->y-p.y);
			*psum+=1/aux;
		}
		double *pmax=sumd;
		double smin=1.0E+34F;
		{durchlaufei(double,sumd,n){
			if(*ptri>=0 && *ptri<smin){pmax=ptri; smin=*ptri;}
		}}
		seleccionados[k]=(pdif)(pmax-sumd);
		sumd[seleccionados[k]]=-1.0;
	}
}

void obtenerP_fotfot(PuntoXYZM_double *c, Puntoxy_double* puntos, uint n);
//void obtenerP_fotfot_l(PuntoXYZM_double *c, Puntoxy_double* puntos, uint n);
double sum_vv(PuntoXYZM_double *c2, Puntoxy_double* puntos, uint n);
void aproxima_κ(double (*M)[3]);

//la Z de CG1 siempre es -1;  la de c->P es 1/lambda
//Las coordenadas de c en el sistema de la foto1 son CG1+c->M^(-1)*c->P
int aproxfot_2D_old(Puntoxy_double* puntos, uint n, PuntoXYZ_double *CG1, PuntoXYZM_double *c2){
	Hel2Dg_dbl T;
	Puntoxy_double *ptr, *ptrb;
	double rr1,rr2, c,s, invn;
	Puntoxy_double *puntosG;
	checked_malloc_n(puntosG,Puntoxy_double,n<<1,return AT_NOMEM);

	invn=1.0/n;
	T.cg1.y=T.cg1.x=0;
	T.cg2.y=T.cg2.x=0;
	ptr=puntos;
	dontimes(n,){
		T.cg1.x+=ptr->x;	T.cg1.y+=ptr->y;	ptr++;
		T.cg2.x+=ptr->x;	T.cg2.y+=ptr->y;	ptr++;
	}
	T.cg1.x*=invn;	T.cg1.y*=invn;
	T.cg2.x*=invn;	T.cg2.y*=invn;

	rr2=rr1=0;
	s=c=0;
	ptr=puntos;
	ptrb=puntosG;
	dontimes(n,){
		double x1,y1,x2,y2;
		ptrb->x=x1=ptr->x-T.cg1.x;	ptrb->y=y1=ptr->y-T.cg1.y;		ptr++, ptrb++;
		ptrb->x=x2=ptr->x-T.cg2.x;	ptrb->y=y2=ptr->y-T.cg2.y;		ptr++, ptrb++;
		rr1+=x1*x1+y1*y1;
		rr2+=x2*x2+y2*y2;
		c+=x1*x2+y1*y2;
		s+=x1*y2-y1*x2;
	}
	T.esc=sqrt(rr1/rr2);	//el inverso
	{double r=1/sqrt(c*c+s*s);
	T.cosg=c*r;
	T.sing=s*r;}

	Giro3D_double G;
	G.κ=0;
	double XY,XX,YY,RR,Rxy,Rxx,Ryy,bw,bf;
	RR=YY=XX=XY=0;
	Ryy=Rxx=Rxy=0;
	bf=bw=0;
	ptrb=puntosG;
	dontimes(n,){
		double x1,y1,dx,dy,xy,xx,yy,rr;
		x1=ptrb->x;		y1=ptrb->y;			ptrb++;
		dx=T.cosg*ptrb->x+T.sing*ptrb->y;
		dy=-T.sing*ptrb->x+T.cosg*ptrb->y;
		ptrb->x=T.esc*dx;		ptrb->y=T.esc*dy;
		dx=x1*(ptrb->x-x1);		dy=y1*(ptrb->y-y1);	ptrb++;
		dx+=dy;
		bw+=dx*y1;
		bf+=dx*x1;
		//
		xx=x1*x1;		xy=x1*y1;	yy=y1*y1;
		XY+=xy;	XX+=xx;	YY+=yy;
		rr=xx+yy;
		RR+=rr;
		Rxy+=rr*xy;	Rxx+=rr*xx;	Ryy+=rr*yy;
	}

	{double m1,m2,m4,aux;
	m2=Rxy-invn*XY*RR;
	m1=Ryy-invn*(XY*XY+YY*YY);
	m4=Rxx-invn*(XY*XY+XX*XX);
	aux=1/(m1*m4-m2*m2);
	m1*=aux; m2*=-aux; m4*=aux;
	G.ω=m4*bw+m2*bf;
	G.φ=m2*bw+m1*bf;}

	c=-invn*(XY*G.ω+XX*G.φ);
	s=-invn*(YY*G.ω+XY*G.φ);
	G.φ=-G.φ;

	if(fabs(G.ω)>0.1) G.ω*=0.9;
	if(fabs(G.φ)>0.1) G.φ*=0.9;
	if(n==6){G.ω*=0.95; G.φ*=0.95;}

	MatrizDelta_dbl(G,c2->M);
	{double aux=c2->M[0][0]*T.cosg-c2->M[1][0]*T.sing;		c2->M[1][0]=c2->M[0][0]*T.sing+c2->M[1][0]*T.cosg;	c2->M[0][0]=aux;}
	{double aux=c2->M[0][1]*T.cosg-c2->M[1][1]*T.sing;		c2->M[1][1]=c2->M[0][1]*T.sing+c2->M[1][1]*T.cosg;	c2->M[0][1]=aux;}
	{double aux=c2->M[0][2]*T.cosg-c2->M[1][2]*T.sing;		c2->M[1][2]=c2->M[0][2]*T.sing+c2->M[1][2]*T.cosg;	c2->M[0][2]=aux;}
	{double aux=c*T.cosg+s*T.sing;	s=-c*T.sing+s*T.cosg;	c=aux;}
	c2->P.X=-T.cg2.x*T.esc+c;
	c2->P.Y=-T.cg2.y*T.esc+s;
	c2->P.Z=T.esc;

	CG1->X=T.cg1.x;
	CG1->Y=T.cg1.y;
	CG1->Z=-1.0;

	free(puntosG);
	return 0;
}

int aproxfot_2D(Puntoxy_double* puntos, uint n, PuntoXYZM_double *c2, float *vv, float vvmin){
	int nret;
	PuntoXYZ_double CG;
	nret=aproxfot_2D_old(puntos,n,&CG,c2);
	ifunlike(nret) return nret;
	if(c2->P.Z>.968 && c2->P.Z<1.032 && n<=6 /* && !(fabs(trans.Tx)<0.06 && fabs(trans.Ty)<0.06)*/) c2->P.Z=1;
	AutoGiraPunto_dbl(&CG,c2->M);
	P_eq(c2->P,+=,CG);

	*vv=(float)sum_vv(c2,puntos,n);
	if(*vv>100*vvmin*(float)(n-5)){
		PuntoXYZM_double cc;
		float v;
		cc=*c2;
		aproxima_κ(cc.M);
		obtenerP_fotfot(&cc,puntos,n);
		v=(float)sum_vv(&cc,puntos,n);
		if(v<*vv && fabs(cc.P.Z)<=0.5){*vv=v; *c2=cc;}	//<=0.5: this is supposed to be flat
	}
	return 0;
}

#define n 9
void resuelve_homogeneo1(double N[45], double *L){
	//double s;
	u8int vars[n];
	for(u8int i=0;i<n;i++) vars[i]=i;

	//s=N[0]+N[9]+N[17]+N[24]+N[30]+N[35]+N[39]+N[42]+N[44];
	//s*=0.001;
	double *pN=N;
	for(cint i=n-1;i;){
		cint j=i++;
		double  *pB=pN+i;
		{double aux=*pN;// *pC=pN;
		//	cint k=i;
			while(j){
				if(*pB>aux) break; //{k=j; pC=pB; aux=*pB;}
				pB+=j--;
			}
			//j=k, pB=pC;
		}
		if(j!=0/*i*/){
			u8int naux=vars[n-i]; vars[n-i]=vars[n-j]; vars[n-j]=naux;
			double *pC=pN+i-j--;
			for(cint k=j;k;){pC++, pB++; k--; double aux=*pC; *pC=*pB; *pB=aux;}	//fila. vars posteriores
			pC-=j; pB-=j++; {double aux=*pN; *pN=*pB; *pB=aux;}
			pC--; pB-=j++;
			while(j!=i){double aux=*pC; *pC--=*pB; *pB=aux; pB-=j++;} //vars intermedias
			while(j!=n){pC-=j, pB-=j++; double aux=*pC; *pC=*pB; *pB=aux;} //vars anteriores
		}
		i--;

		*pN=1/ *pN;
		double aux=-*pN++;
		double *pNb=pN+i;
		for(j=i--;j;){
			double auxb=aux**pN;
			double *pB=pN;
			inner_loopn(j--,*pNb+++=auxb**pB++);
			*pN++=auxb;
		}
	}
	double *pL=L+(n-1);
	*pL=1;
	for(cint i=1;i<n;){
		pN--;
		double aux=0;
		inner_loopn(i,aux+=*pN--**pL--);
		*pL=aux; pL+=i++;
	}
	u8int *pvars=vars;
	for(u8int i=0;i<n;i++,pvars++){
		while(*pvars!=i){
			u8int k=*pvars;
			double aux=L[i]; L[i]=L[k]; L[k]=aux;
			*pvars=vars[k]; vars[k]=k;
		}
	}
	return;
}
void resuelve_homogeneo2(double N[45], double λ[n], double μ[n]){
	u8int vars[n];
	for(u8int i=0;i<n;i++) vars[i]=i;

	double *pN=N;
	for(cint i=n-1;i>=2;){
		cint j=i++;
		double  *pB=pN+i;
		{double aux=*pN, *pC=pN;
			cint k=i;
			while(j){
				if(*pB>aux){k=j; pC=pB; aux=*pB;}
				pB+=j--;
			}
			j=k, pB=pC;
		}
		if(j!=i){
			u8int naux=vars[n-i]; vars[n-i]=vars[n-j]; vars[n-j]=naux;
			double *pC=pN+i-j--;
			for(cint k=j;k;){pC++, pB++; k--; double aux=*pC; *pC=*pB; *pB=aux;}	//fila. vars posteriores
			pC-=j; pB-=j++; {double aux=*pN; *pN=*pB; *pB=aux;}
			pC--; pB-=j++;
			while(j!=i){double aux=*pC; *pC--=*pB; *pB=aux; pB-=j++;} //vars intermedias
			while(j!=n){pC-=j, pB-=j++; double aux=*pC; *pC=*pB; *pB=aux;} //vars anteriores
		}
		i--;

		*pN=1/ *pN;
		double aux=-*pN++;
		double *pNb=pN+i;
		for(j=i--;j;){
			double auxb=aux**pN;
			double *pB=pN;
			inner_loopn(j--,*pNb+++=auxb**pB++);
			*pN++=auxb;
		}
	}
	double *pλ=λ+(n-1),
			   *pμ=μ+(n-1);
	*pλ=1; *(pλ-1)=0;
	*pμ=0; *(pμ-1)=1;
	for(cint i=2;i<n;){
		pN--;
		double aux=0;
		{inner_loopn(i,aux+=*pN--**pλ--);}
		*pλ=aux; pλ+=i;

		pN+=i, aux=0;
		{inner_loopn(i,aux+=*pN--**pμ--);}
		*pμ=aux; pμ+=i++;
	}
	u8int *pvars=vars;
	for(u8int i=0;i<n;i++,pvars++){
		while(*pvars!=i){
			u8int k=*pvars;
			double aux=λ[i]; λ[i]=λ[k]; λ[k]=aux;
			aux=μ[i]; μ[i]=μ[k]; μ[k]=aux;
			*pvars=vars[k]; vars[k]=k;
		}
	}
	return;
}
#undef n

void aproxima_κ(double (*M)[3]){
	double c,s,xy;
	c=M[0][0]+M[1][1];
	s=M[1][0]-M[0][1];
	xy=c*c+s*s;

	xy=1.0/sqrt(xy);
	s*=xy; c*=xy;
	M[0][0]=c; M[0][1]=-s; M[0][2]=0;
	M[1][0]=s; M[1][1]=c; M[1][2]=0;
	M[2][0]=0; M[2][1]=0; M[2][2]=1;
}

/*El método de minimizar Σ(Det^2) favorece soluciones en las que una foto está
encima de la otra. Más exactamente, según la dirección de los rayos proyectivos
de los puntos comunes, que suelen restringirse a una zona de la foto, ya que entonces
dichos rayos son casi colineares con el vector base con lo que es muy fácil que el
producto mixto sea pequeño, aun cuando corresponde a residuos en fotocoordenadas
muy grandes.*/

int M9_obtenerdeL(double L[9], PuntoXYZM_double *c2, Puntoxy_double* puntos, uint n);
//0: bien
//1: puntos negativos
int aproxfot_M9(Puntoxy_double* puntos, uint n, PuntoXYZM_double *c2){
	double N[45];
	double L[9];
	double l[9];	//adjuntos

	zeroset_double(N,45);
	Puntoxy_double *punp=puntos;
	dontimes(n,){
		Puntoxy_double p,q;
		double A[9];
		p.x=punp->x; p.y=punp->y;	punp++;
		q.x=punp->x; q.y=punp->y;	punp++;

		{double *pA=A;
		*pA++=q.x*p.x;	*pA++=q.x*p.y;	*pA++=-q.x;
		*pA++=q.y*p.x;	*pA++=q.y*p.y;	*pA++=-q.y;
		*pA++=-p.x;		*pA++=-p.y;		*pA=1.0;}

		{double *pA=A, *pN=N;
		double aux;
		aux=*pA++;	*pN+++=aux*aux;	{durchlaufej(double,pA,8) *pN+++=aux**ptrj;}
		aux=*pA++;	*pN+++=aux*aux;	{durchlaufej(double,pA,7) *pN+++=aux**ptrj;}
		aux=*pA++;	*pN+++=aux*aux;	{durchlaufej(double,pA,6) *pN+++=aux**ptrj;}
		aux=*pA++;	*pN+++=aux*aux;	{durchlaufej(double,pA,5) *pN+++=aux**ptrj;}
		aux=*pA++;	*pN+++=aux*aux;	*pN+++=aux*pA[0];		*pN+++=aux*pA[1];		*pN+++=aux*pA[2];		*pN+++=aux*pA[3];
		aux=*pA++;	*pN+++=aux*aux;	*pN+++=aux*pA[0];		*pN+++=aux*pA[1];		*pN+++=aux*pA[2];
		aux=*pA++;	*pN+++=aux*aux;	*pN+++=aux*pA[0];		*pN+++=aux*pA[1];
		aux=*pA++;	*pN+++=aux*aux;	*pN+++=aux*pA[0];
		*pN+=*pA**pA;}
	}
	if(n>=8){
		resuelve_homogeneo1(N,L);
	#ifdef _DEBUG
		double vv=0;
		punp=puntos;
		dontimes(n,){
			Puntoxy_double p,q;
			p.x=punp->x; p.y=punp->y;	punp++;
			q.x=punp->x; q.y=punp->y;	punp++;
			double vaux;
			vaux=L[0]*q.x*p.x;	vaux+=L[1]*q.x*p.y;		vaux+=-L[2]*q.x;
			vaux+=L[3]*q.y*p.x;	vaux+=L[4]*q.y*p.y;	vaux+=-L[5]*q.y;
			vaux+=-L[6]*p.x;	vaux+=-L[7]*p.y;		vaux+=L[8];
			vv+=vaux*vaux;
		}
		vv*=0.5;
	#endif
		//Hacer el determinante =0
		{double D,e;
		l[0]=L[4]*L[8]-L[5]*L[7];		l[1]=L[5]*L[6]-L[3]*L[8];		l[2]=L[3]*L[7]-L[4]*L[6];
		l[3]=L[7]*L[2]-L[8]*L[1];		l[4]=L[8]*L[0]-L[6]*L[2];		l[5]=L[6]*L[1]-L[7]*L[0];
		l[6]=L[1]*L[5]-L[2]*L[4];		l[7]=L[2]*L[3]-L[0]*L[5];		l[8]=L[0]*L[4]-L[1]*L[3];
		{D=0, e=0;
		durchlaufe2(double,L,9,double,l){e+=*ptr_b**ptr_b; D+=*ptr**ptr_b;}}
		e=-D/(3.0*e);	//corrección unitaria
		{durchlaufe2(double,L,9,double,l) *ptr+=e**ptr_b;}}
	#ifdef _DEBUG
		vv=0;
		punp=puntos;
		dontimes(n,){
			Puntoxy_double p,q;
			p.x=punp->x; p.y=punp->y;	punp++;
			q.x=punp->x; q.y=punp->y;	punp++;
			double vaux;
			vaux=L[0]*q.x*p.x;	vaux+=L[1]*q.x*p.y;		vaux+=-L[2]*q.x;
			vaux+=L[3]*q.y*p.x;	vaux+=L[4]*q.y*p.y;	vaux+=-L[5]*q.y;
			vaux+=-L[6]*p.x;	vaux+=-L[7]*p.y;		vaux+=L[8];
			vv+=vaux*vaux;
		}
		vv*=0.5;
		vv/=L[5]*L[5];
	#endif
		/*//Buscar los valores que hacen la suma de residuos mínima entre los que cumplen que el determinante es cero
		//dontimes(6,){
		l[0]=L[4]*L[8]-L[5]*L[7];		l[1]=L[5]*L[6]-L[3]*L[8];		l[2]=L[3]*L[7]-L[4]*L[6];
		l[3]=L[7]*L[2]-L[8]*L[1];		l[4]=L[8]*L[0]-L[6]*L[2];		l[5]=L[6]*L[1]-L[7]*L[0];
		l[6]=L[1]*L[5]-L[2]*L[4];		l[7]=L[2]*L[3]-L[0]*L[5];		l[8]=L[0]*L[4]-L[1]*L[3];
		u8int jl;
		double l_l[9];
		double DX[9];

		{double xmax=0;
		double *pL=L;
		for(u8int i=0; i<9; i++,pL++){
			if(fabs(*pL)>xmax){xmax=fabs(*pL); il=i;}
		}}
		{double xmax=0;
		double *pL=l;
		for(u8int i=0; i<9; i++,pL++){
			if(i==il) continue;
			if(fabs(*pL)>xmax){xmax=fabs(*pL); jl=i;}
		}}
		{double aux=1/l[jl];
		durchlaufe2(double,l_l,9,double,l) *ptr=aux**ptr_b;}

		zeroset_double(N,45);
		zeroset_double(DX,9);
		punp=puntos;
		dontimes(n,){
			Puntoxy_double p,q;
			double A[9];
			double v;
			p.x=punp->x; p.y=punp->y;	punp++;
			q.x=punp->x; q.y=punp->y;	punp++;

			v=0;
			{double *pA=A, *pL=L;
			*pA=q.x*p.x;		v-=*pA++**pL++;
			*pA=q.x*p.y;		v-=*pA++**pL++;
			*pA=-q.x;			v-=*pA++**pL++;
			*pA=q.y*p.x;		v-=*pA++**pL++;
			*pA=q.y*p.y;		v-=*pA++**pL++;
			*pA=-q.y;			v-=*pA++**pL++;
			*pA=-p.x;			v-=*pA++**pL++;
			*pA=-p.y;			v-=*pA++**pL++;
			*pA=1.0;			v-=*pA++**pL++;}
			{double aux=A[jl];
			durchlaufe2(double,A,9,double,l_l) *ptr-=aux**ptr_b;}
			A[il]=0;	A[jl]=0;	//A[jl] should already be zero

			{double *pA=A, *pN=N;
			double aux;
			aux=*pA++;	*pN+++=aux*aux;	{durchlaufej(double,pA,8) *pN+++=aux**ptrj;}
			aux=*pA++;	*pN+++=aux*aux;	{durchlaufej(double,pA,7) *pN+++=aux**ptrj;}
			aux=*pA++;	*pN+++=aux*aux;	{durchlaufej(double,pA,6) *pN+++=aux**ptrj;}
			aux=*pA++;	*pN+++=aux*aux;	{durchlaufej(double,pA,5) *pN+++=aux**ptrj;}
			aux=*pA++;	*pN+++=aux*aux;	*pN+++=aux*pA[0];		*pN+++=aux*pA[1];		*pN+++=aux*pA[2];		*pN+++=aux*pA[3];
			aux=*pA++;	*pN+++=aux*aux;	*pN+++=aux*pA[0];		*pN+++=aux*pA[1];		*pN+++=aux*pA[2];
			aux=*pA++;	*pN+++=aux*aux;	*pN+++=aux*pA[0];		*pN+++=aux*pA[1];
			aux=*pA++;	*pN+++=aux*aux;	*pN+++=aux*pA[0];
			*pN+=*pA**pA;}
			{durchlaufe2(double,A,9,double,DX) *ptr_b+=*ptr*v;}
		}
		N[(il*(19-il))>>1]=1;
		N[(jl*(19-jl))>>1]=1;
		resuelve_sistema_sim_t(N,DX,9);
		{durchlaufe2(double,L,9,double,DX) *ptr+=*ptr_b;}
		{double aux=0;
		durchlaufe2(double,l_l,9,double,DX) aux+=*ptr**ptr_b;
		L[jl]-=aux;
	#ifdef _DEBUG
		double vv=0;
		punp=puntos;
		dontimes(n,){
			Puntoxy_double p,q;
			p.x=punp->x; p.y=punp->y;	punp++;
			q.x=punp->x; q.y=punp->y;	punp++;
			double vaux;
			vaux=L[0]*q.x*p.x;	vaux+=L[1]*q.x*p.y;		vaux+=-L[2]*q.x;
			vaux+=L[3]*q.y*p.x;	vaux+=L[4]*q.y*p.y;	vaux+=-L[5]*q.y;
			vaux+=-L[6]*p.x;	vaux+=-L[7]*p.y;		vaux+=L[8];
			vv+=vaux*vaux;
		}
		vv*=0.5;
		vv/=L[5]*L[5];
	#endif
		//}*/
	#ifdef _DEBUG
		int nret=M9_obtenerdeL(L,c2,puntos,n);
		vv=sum_vv(c2,puntos,n);
		return nret;
	#else
		return M9_obtenerdeL(L,c2,puntos,n);
	#endif
	}elif(n==7){
		double λ[9],μ[9];
		double λλλ,λλμ,λμμ,μμμ;
		double λ1,λ2,λ3,μ1,μ2,μ3;
		resuelve_homogeneo2(N,λ,μ);
		λλλ=λ[0]*(λ[4]*λ[8]-λ[5]*λ[7])+λ[1]*(λ[5]*λ[6]-λ[3]*λ[8])+λ[2]*(λ[3]*λ[7]-λ[4]*λ[6]);
		λλμ=μ[0]*(λ[4]*λ[8]-λ[5]*λ[7])+μ[1]*(λ[5]*λ[6]-λ[3]*λ[8])+μ[2]*(λ[3]*λ[7]-λ[4]*λ[6]);
		λλμ+=λ[0]*(μ[4]*λ[8]-μ[5]*λ[7])+λ[1]*(μ[5]*λ[6]-μ[3]*λ[8])+λ[2]*(μ[3]*λ[7]-μ[4]*λ[6]);
		λλμ+=λ[0]*(λ[4]*μ[8]-λ[5]*μ[7])+λ[1]*(λ[5]*μ[6]-λ[3]*μ[8])+λ[2]*(λ[3]*μ[7]-λ[4]*μ[6]);
		λμμ=λ[0]*(μ[4]*μ[8]-μ[5]*μ[7])+λ[1]*(μ[5]*μ[6]-μ[3]*μ[8])+λ[2]*(μ[3]*μ[7]-μ[4]*μ[6]);
		λμμ+=μ[0]*(μ[4]*λ[8]-μ[5]*λ[7])+μ[1]*(μ[5]*λ[6]-μ[3]*λ[8])+μ[2]*(μ[3]*λ[7]-μ[4]*λ[6]);
		λμμ+=μ[0]*(λ[4]*μ[8]-λ[5]*μ[7])+μ[1]*(λ[5]*μ[6]-λ[3]*μ[8])+μ[2]*(λ[3]*μ[7]-λ[4]*μ[6]);
		μμμ=μ[0]*(μ[4]*μ[8]-μ[5]*μ[7])+μ[1]*(μ[5]*μ[6]-μ[3]*μ[8])+μ[2]*(μ[3]*μ[7]-μ[4]*μ[6]);
		if(fabs(λλλ)>=fabs(μμμ)){	//Se resuelve λ en función de μ
			λλλ=1/λλλ;
			λλμ*=λλλ;
			λμμ*=λλλ;
			μμμ*=λλλ;
			polinomio3_dbl(λλμ,λμμ,μμμ,&λ1,&λ2,&λ3);
			μ3=μ2=μ1=1;
		}else{
			μμμ=1/μμμ;
			λμμ*=μμμ;
			λλμ*=μμμ;
			λλλ*=μμμ;
			polinomio3_dbl(λμμ,λλμ,λλλ,&μ1,&μ2,&μ3);
			λ3=λ2=λ1=1;
		}
		PuntoXYZM_double cc1,cc2,cc3;
		double vv1,vv2,vv3;
		int nret1,nret2,nret3;
		{double *pL=L, *pλ=λ, *pμ=μ;	dontimes(9,) *pL++=λ1**pλ++ +μ1**pμ++;}
		nret1=M9_obtenerdeL(L,&cc1,puntos,n);
		vv1=sum_vv(&cc1,puntos,n);
		{double *pL=L, *pλ=λ, *pμ=μ;	dontimes(9,) *pL++=λ2**pλ++ +μ2**pμ++;}
		nret2=M9_obtenerdeL(L,&cc2,puntos,n);
		vv2=sum_vv(&cc2,puntos,n);
		{double *pL=L, *pλ=λ, *pμ=μ;	dontimes(9,) *pL++=λ3**pλ++ +μ3**pμ++;}
		nret3=M9_obtenerdeL(L,&cc3,puntos,n);
		vv3=sum_vv(&cc3,puntos,n);
		if(vv1>4.0E-7F && vv2>4.0E-7F && vv3>4.0E-7F){
		#ifdef TRACING
			//double vv_antes=vv1; if(vv2<vv1) vv_antes=vv2;
			//if(vv3<vv_antes) vv_antes=vv3;
		#endif
	#define criterio_vvv(vv,vvn,ccn)	(vv<vvn || (fabs(ccn.P.Z)>=0.5 && fabs(cc.P.Z)<0.8 && (vv<2*vvn && vv<1.0E-4F) || (vv<6*vvn && vv<2.0E-5F)))
			if(cc1.M[2][2]>0.5){
				PuntoXYZM_double cc=cc1;
				aproxima_κ(cc.M);
				obtenerP_fotfot(&cc,puntos,n);
				double vv=sum_vv(&cc,puntos,n);
				if(criterio_vvv(vv,vv1,cc1)){vv1=vv; cc1=cc;}
			}
			if(cc2.M[2][2]>0.5){
				PuntoXYZM_double cc=cc2;
				aproxima_κ(cc.M);
				obtenerP_fotfot(&cc,puntos,n);
				double vv=sum_vv(&cc,puntos,n);
				if(criterio_vvv(vv,vv2,cc2)){vv2=vv; cc2=cc;}
			}
			if(cc2.M[2][2]>0.5){
				PuntoXYZM_double cc=cc3;
				aproxima_κ(cc.M);
				obtenerP_fotfot(&cc,puntos,n);
				double vv=sum_vv(&cc,puntos,n);
				if(criterio_vvv(vv,vv3,cc3)){vv3=vv; cc3=cc;}
			}
	#undef criterio_vvv
		#ifdef TRACING
			//towrite(&fp,'s',"Entra en mejora. vv= ", 'f',vv_antes*1e6, 0);
			//{const char8_t* s; if(vv1<vv_antes || vv2<vv_antes || vv3<vv_antes) s=" SI    ";
			//else s=" NO    ";
			//towrite_string(&fp,s);}
		#endif
		}
		{double s=vv1+vv2+vv3;
		if(nret1) vv1+=s;
		if(nret2) vv2+=s;
		if(nret3) vv3+=s;}
		if(vv1<vv2 && vv1<vv3){*c2=cc1; return nret1;}
		if(vv2<vv3){*c2=cc2; return nret2;}
		*c2=cc3; return nret3;
	}
	return 0;
}

void Nhomogeneo3(double N[6], PuntoXYZ_double *P){
	u8int il;
	if(N[0]<N[3] && N[0]<N[5]) il=0;
	elif(N[3]<N[5]) il=1;
	else il=2;

	if(il==0){
		double aux=N[3];
		double det=N[3]*N[5]-N[4]*N[4];
		det=1/det;
		N[3]=det*N[5];	N[5]=det*aux;
		N[4]*=-det;
		P->X=1;
		P->Y=-(N[3]*N[1]+N[4]*N[2]);
		P->Z=-(N[4]*N[1]+N[5]*N[2]);
	}elif(il==1){
		double aux=N[0];
		double det=N[0]*N[5]-N[2]*N[2];
		det=1/det;
		N[0]=det*N[5];	N[5]=det*aux;
		N[2]*=-det;
		P->Y=1;
		P->X=-(N[0]*N[1]+N[2]*N[4]);
		P->Z=-(N[2]*N[1]+N[5]*N[4]);
	}else{
		double aux=N[0];
		double det=N[0]*N[3]-N[1]*N[1];
		det=1/det;
		N[0]=det*N[3];	N[3]=det*aux;
		N[1]*=-det;
		P->Z=1;
		P->X=-(N[0]*N[2]+N[1]*N[4]);
		P->Y=-(N[1]*N[2]+N[3]*N[4]);
	}
}
//Una vez obtenida M, obtener los valores de X',Y',Z' que hacen mínimo Sum(res)
//The following two functions yield almost the same result and serve to check each other
//Coplanaridad
void obtenerP_fotfot(PuntoXYZM_double *c, Puntoxy_double* puntos, uint n){
	double N[6];
	zeroset_double(N,6);
	Puntoxy_double *punp=puntos;
	dontimes(n,){
		PuntoXYZ_double p;
		Puntoxy_double q;
		double A[3];
		p.X=punp->x; p.Y=punp->y;	p.Z=-1.0;	punp++;
		q.x=punp->x; q.y=punp->y;	punp++;
		AutoGiraPunto_dbl(&p,c->M);

		A[0]=-p.Y-p.Z*q.y;
		A[1]=p.Z*q.x+p.X;
		A[2]=p.X*q.y-p.Y*q.x;
		{double *pA=A, *pN=N;
		double aux;
		aux=*pA++;	*pN+++=aux*aux;	*pN+++=aux*pA[0];		*pN+++=aux*pA[1];
		aux=*pA++;	*pN+++=aux*aux;	*pN+++=aux*pA[0];
		*pN+=*pA**pA;}
	}
	Nhomogeneo3(N,&c->P);
}

#if 0
//Colinealidad escalada
void obtenerP_fotfot_l(PuntoXYZM_double *cc, Puntoxy_double* puntos, uint n){
	double N[6];
	zeroset_double(N,6);
	Puntoxy_double *punp=puntos;
	dontimes(n,){
		Puntoxy_float q;
		float A[6];
		float Np[9];
		float a,b,c;
		
		a=(float)(cc->M[0][0]+punp->x*cc->M[0][2]);
		b=(float)(cc->M[1][0]+punp->x*cc->M[1][2]);
		c=(float)(cc->M[2][0]+punp->x*cc->M[2][2]);
		Np[0]=a*a;		Np[1]=a*b;		Np[2]=a*c;
							Np[4]=b*b;		Np[5]=b*c;
												Np[8]=c*c;
		A[0]=a; A[1]=b; A[2]=c;

		a=(float)(cc->M[0][1]+punp->y*cc->M[0][2]);
		b=(float)(cc->M[1][1]+punp->y*cc->M[1][2]);
		c=(float)(cc->M[2][1]+punp->y*cc->M[2][2]);
		Np[0]+=a*a;		Np[1]+=a*b;		Np[2]+=a*c;
							Np[4]+=b*b;		Np[5]+=b*c;
												Np[8]+=c*c;
		A[3]=a; A[4]=b; A[5]=c;
		punp++;
		q.x=(float)punp->x; q.y=(float)punp->y;	punp++;

		/*A[6]=1; A[7]=0; A[8]=q.x;
		  A[9]=0; A[10]=1; A[11]=q.y; */
		c=q.x*q.x+q.y*q.y;
		Np[0]+=1;		Np[2]+=q.x;
		Np[4]+=1;		Np[5]+=q.y;	Np[8]+=c;
		/*		   X1		/ 1,		0,	q.x \  X'
			Np* Y1	=	| 0,	1,	q.y |  Y'
				   Z1		\ q.x, q.y,	  c  /  Z'
		*/
		ATinvsim3(Np);
		Np[2]=q.x*Np[0]+q.y*Np[1]+c*Np[2];
		Np[0]+=q.x*Np[6];
		Np[1]+=q.y*Np[6];
		Np[5]=q.x*Np[3]+q.y*Np[4]+c*Np[5];
		Np[3]+=q.x*Np[7];
		Np[4]+=q.y*Np[7];
		c=q.x*Np[6]+q.y*Np[7]+c*Np[8];
		Np[6]+=q.x*Np[8];
		Np[7]+=q.y*Np[8];
		Np[8]=c;
		/*(X1,Y1,Z1)=Np(X',Y',Z')*/

		float *pA=A;
		//res x_1
		{float *pN=Np,
		aux=*pA++;		a=aux**pN++; b=aux**pN++; c=aux**pN++;
		aux=*pA++;		a+=aux**pN++; b+=aux**pN++; c+=aux**pN++;
		aux=*pA++;		a+=aux**pN++; b+=aux**pN++; c+=aux**pN++;
		{double da=a, db=b, dc=c;
		double *iN=N;
		*iN+++=da*da;	*iN+++=da*db;	*iN+++=da*dc;
							*iN+++=db*db;	*iN+++=db*dc;
												*iN+++=dc*dc;}}
		//res y_1
		{float *pN=Np,
		aux=*pA++;		a=aux**pN++; b=aux**pN++; c=aux**pN++;
		aux=*pA++;		a+=aux**pN++; b+=aux**pN++; c+=aux**pN++;
		aux=*pA++;		a+=aux**pN++; b+=aux**pN++; c+=aux**pN++;
		{double da=a, db=b, dc=c;
		double *iN=N;
		*iN+++=da*da;	*iN+++=da*db;	*iN+++=da*dc;
							*iN+++=db*db;	*iN+++=db*dc;
												*iN+++=dc*dc;}}
		//res x_2
		{float *pN=Np;
		a=-1.0F+*pN++;	b=*pN++;	c=-q.x+*pN++;	//A[6]=1;  (-1,0,-q.x) son los coef. orig.
		pN+=3;												//A[7]=0;
		a+=q.x**pN++; b+=q.x**pN++; c+=q.x**pN++;	//A[8]=q.x;
		{double da=a, db=b, dc=c;
		double *iN=N;
		*iN+++=da*da;	*iN+++=da*db;	*iN+++=da*dc;
							*iN+++=db*db;	*iN+++=db*dc;
												*iN+++=dc*dc;}}
		//res y_2
		{float *pN=Np+3;									//A[9]=0;
		a=*pN++;	b=-1.0F+*pN++;	c=-q.y+*pN++;	//A[10]=1;  (0,-1,-q.y) son los coef. orig.
		a+=q.y**pN++; b+=q.y**pN++; c+=q.y**pN++;	//A[11]=q.y;
		{double da=a, db=b, dc=c;
		double *iN=N;
		*iN+++=da*da;	*iN+++=da*db;	*iN+++=da*dc;
							*iN+++=db*db;	*iN+++=db*dc;
												*iN+++=dc*dc;}}
	}
	Nhomogeneo3(N,&cc->P);
}
#endif

//0: bien
//1: puntos negativos
//Los valores de L ya cumplen det(L)=0
int M9_obtenerdeL(double L[9], PuntoXYZM_double *c2, Puntoxy_double *puntos, uint n){
	double l[9];
	PuntoXYZ_double P;
	//Hacer la suma de los cuadrados de los adjuntos =1
	l[0]=L[4]*L[8]-L[5]*L[7];		l[1]=L[5]*L[6]-L[3]*L[8];		l[2]=L[3]*L[7]-L[4]*L[6];
	l[3]=L[7]*L[2]-L[8]*L[1];		l[4]=L[8]*L[0]-L[6]*L[2];		l[5]=L[6]*L[1]-L[7]*L[0];
	l[6]=L[1]*L[5]-L[2]*L[4];		l[7]=L[2]*L[3]-L[0]*L[5];		l[8]=L[0]*L[4]-L[1]*L[3];
	{double s, *pl=l;
	P.X=*pl**pl, pl++; P.X+=*pl**pl, pl++; P.X+=*pl**pl, pl++; //X'X'
	P.Y=*pl**pl, pl++; P.Y+=*pl**pl, pl++; P.Y+=*pl**pl, pl++; //Y'Y'
	P.Z=*pl**pl, pl++; P.Z+=*pl**pl, pl++; P.Z+=*pl**pl, pl++; //Z'Z'
	s=1.0/(P.X+P.Y+P.Z);
	s=sqrt(s);	{durchlaufei(double,l,9) *ptri*=s;}
	s=sqrt(s);	{durchlaufei(double,L,9) *ptri*=s;}
	}

	u8int il;
	{double a1,a2,a3, s;
	a1=fabs(l[0])+fabs(l[3])+fabs(l[6]);
	a2=fabs(l[1])+fabs(l[4])+fabs(l[7]);
	a3=fabs(l[2])+fabs(l[5])+fabs(l[8]);
	if(a1>a3){if(a1>a2) il=0;	else il=1;}
	else{if(a2>a3) il=1;	else il=2;}
	if(il==0){		P.X=l[0]; P.Y=l[3]; P.Z=l[6];} //X'X, Y'X, Z'X
	elif(il==1){P.X=l[1]; P.Y=l[4]; P.Z=l[7];} //X'Y, Y'Y, Z'Y
	else{			P.X=l[2]; P.Y=l[5]; P.Z=l[8];} //X'Z, Y'Z, Z'Z
	s=P_mod(P);
	s=1/sqrt(s);	P_mul(P,s);}

	PuntoXYZ_double Q;
	double Mb[3][3];
	if(fabs(P.X)>fabs(P.Z)){
		if(fabs(P.X)>fabs(P.Y)) il=0;	else il=1;
	}else{
		if(fabs(P.Y)>fabs(P.Z)) il=1;	else il=2;
	}
	if(il==0){
		Q=P;
		c2->P.X=l[0];	c2->P.Y=l[1];		c2->P.Z=l[2];
	}elif(il==1){
		Q.X=P.Y; Q.Y=P.Z; Q.Z=P.X;
		double aux;
		aux=L[0]; L[0]=L[3]; L[3]=L[6]; L[6]=aux;
		aux=L[1]; L[1]=L[4]; L[4]=L[7]; L[7]=aux;
		aux=L[2]; L[2]=L[5]; L[5]=L[8]; L[8]=aux;
		c2->P.X=l[3];	c2->P.Y=l[4];	c2->P.Z=l[5];
	}else{
		Q.X=P.Z; Q.Y=P.X; Q.Z=P.Y;
		double aux;
		aux=L[0]; L[0]=L[6]; L[6]=L[3]; L[3]=aux;
		aux=L[1]; L[1]=L[7]; L[7]=L[4]; L[4]=aux;
		aux=L[2]; L[2]=L[8]; L[8]=L[5]; L[5]=aux;
		c2->P.X=l[6];	c2->P.Y=l[7];		c2->P.Z=l[8];
	}

	{double aux, m, xx, d;
	aux=1/Q.X;
	xx=Q.X*Q.X;

	m=Q.Z*L[3]-Q.Y*L[6];
	//d=m*m+xx-L[3]*L[3]-L[6]*L[6]; if(d<0) d=0; d=sqrt(d); if(c2->P.X<0) d=-d;
	d=c2->P.X;
	m+=d;
	c2->M[0][0]=m;
	c2->M[1][0]=aux*(Q.Y*m+L[6]);
	c2->M[2][0]=aux*(Q.Z*m-L[3]);
	//
	m-=2*d;
	Mb[0][0]=-m;
	Mb[1][0]=-aux*(Q.Y*m+L[6]);
	Mb[2][0]=-aux*(Q.Z*m-L[3]);

	m=Q.Z*L[4]-Q.Y*L[7];
	//d=m*m+xx-L[4]*L[4]-L[7]*L[7]; if(d<0) d=0; d=sqrt(d); if(c2->P.Y<0) d=-d;
	d=c2->P.Y;
	m+=d;
	c2->M[0][1]=m;
	c2->M[1][1]=aux*(Q.Y*m+L[7]);
	c2->M[2][1]=aux*(Q.Z*m-L[4]);
	//
	m-=2*d;
	Mb[0][1]=-m;
	Mb[1][1]=-aux*(Q.Y*m+L[7]);
	Mb[2][1]=-aux*(Q.Z*m-L[4]);

	m=Q.Z*L[5]-Q.Y*L[8];
	//d=m*m+xx-L[5]*L[5]-L[8]*L[8]; if(d<0) d=0; d=sqrt(d); if(c2->P.Z<0) d=-d;
	d=c2->P.Z;
	m+=d;
	c2->M[0][2]=m;
	c2->M[1][2]=aux*(Q.Y*m+L[8]);
	c2->M[2][2]=aux*(Q.Z*m-L[5]);
	//
	m-=2*d;
	Mb[0][2]=-m;
	Mb[1][2]=-aux*(Q.Y*m+L[8]);
	Mb[2][2]=-aux*(Q.Z*m-L[5]);

	P_mul(c2->P,aux);}

	if(il==1){
		double aux, *v;
		v=c2->M[0];	aux=v[0]; v[0]=v[6]; v[6]=v[3]; v[3]=aux;
		v++;			aux=v[0]; v[0]=v[6]; v[6]=v[3]; v[3]=aux;
		v++;			aux=v[0]; v[0]=v[6]; v[6]=v[3]; v[3]=aux;
		v=Mb[0];		aux=v[0]; v[0]=v[6]; v[6]=v[3]; v[3]=aux;
		v++;			aux=v[0]; v[0]=v[6]; v[6]=v[3]; v[3]=aux;
		v++;			aux=v[0]; v[0]=v[6]; v[6]=v[3]; v[3]=aux;
	}elif(il==2){
		double aux, *v;
		v=c2->M[0];	aux=v[0]; v[0]=v[3]; v[3]=v[6]; v[6]=aux;
		v++;			aux=v[0]; v[0]=v[3]; v[3]=v[6]; v[6]=aux;
		v++;			aux=v[0]; v[0]=v[3]; v[3]=v[6]; v[6]=aux;
		v=Mb[0];		aux=v[0]; v[0]=v[3]; v[3]=v[6]; v[6]=aux;
		v++;			aux=v[0]; v[0]=v[3]; v[3]=v[6]; v[6]=aux;
		v++;			aux=v[0]; v[0]=v[3]; v[3]=v[6]; v[6]=aux;
	}

	int nret=0;
	bint b=0;
	if(fabs(P.Z)<0.5 && fabs(c2->P.Z)<0.5){
		if(c2->M[2][2]<0) b=1;
	}else{
		uint nmalos=0;
		uint nn, salto;
		if(n<10){nn=n; salto=1;}
		else{nn=10; salto=n/10;}
		salto<<=1;
		Puntoxy_double *punp=puntos;
		dontimes(nn,punp+=salto){
			u8int bb=secrr3_ap_signo(*punp,c2->P,c2->M,*(punp+1));
			if(bb&1) nmalos++;
		}
		if(nmalos<<1>nn) b=1;
		if(nmalos>=2 && nmalos+1<nn) nret=1;
	}
	if(b){memcpy_double(c2->M[0],Mb[0],9);}
	convierte_en_R_dbl(c2->M);
	obtenerP_fotfot(c2,puntos,n);

	return nret;
}

//Obtiene vv normalizado a Sum(L)=2, equiv. mod(c2.P)=1
//c2->P *no* es lo que dice, sino en el sistema de c2, e.d., M*c2->P.
double sum_vv(PuntoXYZM_double *c2, Puntoxy_double* puntos, uint n){
	double L[9];
	{double *pL=L;
	*pL++=c2->M[2][0]*c2->P.Y-c2->M[1][0]*c2->P.Z;
	*pL++=c2->M[2][1]*c2->P.Y-c2->M[1][1]*c2->P.Z;
	*pL++=c2->M[2][2]*c2->P.Y-c2->M[1][2]*c2->P.Z;
	*pL++=c2->M[0][0]*c2->P.Z-c2->M[2][0]*c2->P.X;
	*pL++=c2->M[0][1]*c2->P.Z-c2->M[2][1]*c2->P.X;
	*pL++=c2->M[0][2]*c2->P.Z-c2->M[2][2]*c2->P.X;
	*pL++=c2->M[1][0]*c2->P.X-c2->M[0][0]*c2->P.Y;
	*pL++=c2->M[1][1]*c2->P.X-c2->M[0][1]*c2->P.Y;
	*pL=c2->M[1][2]*c2->P.X-c2->M[0][2]*c2->P.Y;}

	double vv=0;
	Puntoxy_double *punp=puntos;
	dontimes(n,){
		Puntoxy_double p,q;
		p.x=punp->x; p.y=punp->y;	punp++;
		q.x=punp->x; q.y=punp->y;	punp++;
		double vaux;
		vaux=L[0]*q.x*p.x;	vaux+=L[1]*q.x*p.y;		vaux+=-L[2]*q.x;
		vaux+=L[3]*q.y*p.x;	vaux+=L[4]*q.y*p.y;	vaux+=-L[5]*q.y;
		vaux+=-L[6]*p.x;	vaux+=-L[7]*p.y;		vaux+=L[8];
		vv+=vaux*vaux;
	}
	vv/=P_mod(c2->P);
	return 0.5*vv;
}

//Calcula sum(vv^2) normalizado a media(Z)=-1.
//Devuelve 0 si todos los puntos están del mismo lado de la foto,
//1 si hay algún punto negaivo.
bint sumvv_exacto(PuntoXYZM_double *c, Puntoxy_double* puntos, uint n, float *vv){
	bint bret=0;
	float (*psec_rr)(Puntoxy_double b,PuntoXYZ_double P,double M[][3],Puntoxy_double d,PuntoXYZ_double *,float *);
	if(fabs(c->M[2][2])>0.8) psec_rr=secrr3_ap_foto_vv;
	else psec_rr=secrr3_foto_vv;

	double media=0;
	*vv=0;
	Puntoxy_double *ptr=puntos;
	dontimes(n,){
		PuntoXYZ_double P;
		Puntoxy_double b,d;
		b=*ptr++; d=*ptr++;
		psec_rr(b,c->P,c->M,d,&P,vv);
		if(fabs(media+P.Z)<fabs(media-P.Z)) bret=1;
		media+=P.Z;
	}
	float fmedia=(float)n/(float)media;
	*vv*=fmedia*fmedia;
	return bret;
}

void analiza_vv(Resultado *result, float _unused(vvmin),uint ntot,uint nn, float vv,float* L, int4 *mfp,bint bint3,PuntoMrel* puntosM){
	uint k,k1,k2;
	float max,max2;
	int3 *mfp3;

	if(2*ntot<=nn){
		result->vv=0;
		result->vvmax=0;
		result->prop_peor=0;
		result->p_peor=puntosM[0].index;
		return;
	}
	k=2*ntot-nn;
	//faux=vvmin*k;
	//if(vv>faux) faux=vv;
	result->vv=sqrtf(vv/k);
	//faux/=ntot;		//En lugar de ntot2, porque la redundancia
	//faux=sqrt(faux);	//se suele ir toda a una coordenada
	//faux*=3;

	//result->n_vmal=0;
	max=0;	k1=Я;
	max2=0;	k2=Я;
	float *pL=L;
	if(bint3) mfp3=(int3*)mfp;
	for(uint i=0;i<ntot;i++){
		Puntoxy_float fcalc;
		fcalc.x=fabsf(*pL); pL++;
		fcalc.y=fabsf(*pL); pL++;
		//if(fcalc.x>faux) result->n_vmal++;
		//if(fcalc.y>faux) result->n_vmal++;
		if(fcalc.y>fcalc.x) fcalc.x=fcalc.y;
		if(fcalc.x>max2){
			uint j;
			if(!bint3) j=mfp[i].n1;
			else j=mfp3[i].n1;
			if(fcalc.x>max){
				if(j!=k1){max2=max; k2=k1;}
				max=fcalc.x;
				k1=j;
			}elif(j!=k1){
				max2=fcalc.x;
				k2=j;
			}
		}
	}
	result->vvmax=max;
	result->prop_peor=max/max2;
	result->p_peor=puntosM[k1].index;
}

//devuelve el número de iteraciones. Si se sale por error se devuelve ~iter
uint iterate_fotfot(PuntoXYZM_double *c, Puntoxy_double* comun12, uint n){
	u8int esx;
	{double X,Y,Z;
	X=fabs(c->P.X);		Y=fabs(c->P.Y);	Z=fabs(c->P.Z);
	if(X>Y){if(X>Z) esx=0;	else esx=2;}
	else{	  if(Y>Z) esx=1;	else esx=2;}
	}
	float N[15];
	float LX[5];
	uint iter=0;
	for(;;){
		//Matrices N y LX;
		zeroset_float(N,15);
		zeroset_float(LX,5);
		{PuntoXYZ_float Pf;
		Puntoxy_double *punp=comun12;
		float fM[3][3];
		for(uint j=0;j<9;j++) fM[0][j]=(float)c->M[0][j];
	#define Pg c->P
		P_eq(Pf,=(float),Pg);

		dontimes(n,){
			Puntoxy_double p,q;
			PuntoXYZ_float rf;
			Puntoxy_float qf;
			float parciales[6];
			float A[6];	//el sexto es L

			p.x=punp->x; p.y=punp->y;	punp++;
			q.x=punp->x; q.y=punp->y;	punp++;

			{double x,y,z;
			PuntoXYZ_double Q;
			x=c->M[0][0]*p.x+c->M[0][1]*p.y-c->M[0][2];	rf.X=(float)x;
			y=c->M[1][0]*p.x+c->M[1][1]*p.y-c->M[1][2];	rf.Y=(float)y;
			z=c->M[2][0]*p.x+c->M[2][1]*p.y-c->M[2][2];	rf.Z=(float)z;
			Q.X=Pg.Y*z-Pg.Z*y;
			Q.Y=Pg.Z*x-Pg.X*z;
			Q.Z=Pg.X*y-Pg.Y*x;
			A[5]=-(float)(Q.X*q.x+Q.Y*q.y-Q.Z);}

			qf.x=(float)q.x;
			qf.y=(float)q.y;
		#undef Pg

			parciales[0]=-(rf.Y	+rf.Z*qf.y);
			parciales[1]=rf.Z*qf.x	+rf.X;
			parciales[2]=rf.X*qf.y	-rf.Y*qf.x;
			parciales[3]=Pf.Z*qf.y	+Pf.Y;
			parciales[4]=-(Pf.X	+Pf.Z*qf.x);
			parciales[5]=Pf.Y*qf.x	-Pf.X*qf.y;

			if(esx>0) A[0]=parciales[0];	else A[0]=parciales[1];
			if(esx>1) A[1]=parciales[1];	else A[1]=parciales[2];
			A[2]=-rf.Z*parciales[4]+rf.Y*parciales[5];
			A[3]=+rf.Z*parciales[3]-rf.X*parciales[5];
			A[4]=-rf.Y*parciales[3]+rf.X*parciales[4];

			{float *pA=A, *pN=N;
			float aux;
			aux=*pA++;	*pN+++=aux*aux;	*pN+++=aux*pA[0];		*pN+++=aux*pA[1];		*pN+++=aux*pA[2];		*pN+++=aux*pA[3];
			aux=*pA++;	*pN+++=aux*aux;	*pN+++=aux*pA[0];		*pN+++=aux*pA[1];		*pN+++=aux*pA[2];
			aux=*pA++;	*pN+++=aux*aux;	*pN+++=aux*pA[0];		*pN+++=aux*pA[1];
			aux=*pA++;	*pN+++=aux*aux;	*pN+++=aux*pA[0];
			*pN+=*pA**pA;	pA++;
			aux=*pA;	LX[0]+=aux*A[0];	LX[1]+=aux*A[1];	LX[2]+=aux*A[2];	LX[3]+=aux*A[3];	LX[4]+=aux*A[4];
			}
		}}
		//Matrices, suma de incrementos y criterio de convergencia
		resuelve_sistema_t_float(N,LX,5);
		if(esx>0) c->P.X+=LX[0];	else c->P.Y+=LX[0];
		if(esx>1) c->P.Y+=LX[1];	else c->P.Z+=LX[1];
		{double MD[3][3], MT[3][3];
		MatrizDeltafl_dbl(*(PuntoXYZ_float*)(LX+2),MD);
		mmulrot(MD,c->M,MT);
		memcpy_double(&c->M[0][0],&MT[0][0],9);}
		if(iter++){
			if(iter==10) break;	//una vez entré en un ciclo de periodo 4.
			float vv=LX[0]*LX[0]+LX[1]*LX[1]+LX[2]*LX[2]+LX[3]*LX[3]+LX[4]*LX[4];
			if(!isfinite(vv)) return ~iter;
			if(vv<5.0E-8F) break;
		}
	}
	return iter;
}

#define FUNC_2D 0
#define FUNC_8p 1
#define FUNC_7p 2
#define FUNC_6p 3
//#define BRUTE_FORCE 4
//float testM_against_result(Resultado *result, PuntoXYZM_double *c,Puntoxy_double* comun12,uint n);
Modelo fotfot(Resultado *result,Fotograma *fot1, Fotograma *fot2, u8int modo_toma, u16int  n_force, float vmin, uint n){
	u8int modo_medida;
	Modelo mod;
	float tol_intersec;
	u8int func_apr;	//funcion de valores aproximados empleada.
						//FUNC_2D ... FUNC_6p
						//si modo=1, se prueba primero _2D. Si modo=2, _2D se deja como último recurso
	uint seleccionados[7];
	Puntoxy_double puntos_sel[14];
	struct{
		int nret;	// =100 will mean not yet tried
		PuntoXYZM_double c;
		float vv;
	} cc[4]; //para cada método
 	float (*psec_rr)(Puntoxy_double b,PuntoXYZ_double P,double M[][3],Puntoxy_double d,PuntoXYZ_double *,float *);
	PLIST plist=get_new_plist();

	Hash_Seleccionado hpuntos_foto2;
	HStdSetupЯ(Seleccionado,hpuntos_foto2,fot2->puntos.n);
	{durchlaufei_fwd(Puntof,fot2->puntos.ppio,fot2->puntos.n){
		inserth_Seleccionado(&hpuntos_foto2,ptri->index,i);
	}}
	if(n==0){
		durchVectori(Puntof,fot1->puntos){
			if(geth_Seleccionado(&hpuntos_foto2,ptri->index)!=NULL) n++;
	}	}
	if(n>=20) modo_medida=ATMODOMEDIDA_Automatico;
	else modo_medida=ATMODOMEDIDA_Manual; //De momento todo el código está pensado para "manual".
	aj_decl_alloc_add(Puntoxy_double,comun12,n<<1);
	aj_decl_alloc_add(uint,ind_com,n);
	aj_decl_alloc_add(uint,ind_com2,n);
	aj_decl_alloc_add(bint,bcom2,fot2->puntos.n);
	zeroset(bcom2,fot2->puntos.n*usizeof(bint));
	SetupModelo(mod,fot1->puntos.n+fot2->puntos.n,n);
	mod.centros.n=2;

	Puntoff pfv;
	pfv.f=0;
	n=0;
	{Puntoxy_double *ptr=comun12;
	Puntof *punpf1=fot1->puntos.ppio;
	for(uint i=0;i<fot1->puntos.n;i++,punpf1++){
		Seleccionado *sel=geth_Seleccionado(&hpuntos_foto2,punpf1->index);
		if(sel!=NULL){
			*ptr++=punpf1->p;
			*ptr++=fot2->puntos.ppio[sel->i].p;
			ind_com[n]=i;
			ind_com2[n]=sel->i;
			bcom2[sel->i]=1;
			n++;
		}else{
			Addh_puntom(&mod.hpuntos,punpf1->index,mod.fpuntosf.n,at_fpuntosf);
			pfv.nom=punpf1->index;
			pfv.p=i;
			Vadd(mod.fpuntosf,Puntoff,pfv,goto salida_outofmem);
		}
	}}

	pfv.f=1;
	for(uint j=0;j<fot2->puntos.n;j++){
		if(!bcom2[j]){
			uint nom=fot2->puntos.ppio[j].index;
			Addh_puntom(&mod.hpuntos,nom,mod.fpuntosf.n,at_fpuntosf);
			pfv.nom=nom;
			pfv.p=j;
			Vadd(mod.fpuntosf,Puntoff,pfv,goto salida_outofmem);
		}
	}

	//comun12 es una copia, no hace falta restaurar al final
	if(fot1->focal!=1.0 || fot2->focal!=1.0){
		double aux=1/fot1->focal,
				 auxb=1/fot2->focal;
		vmin*=(float)aux;
		Durchlaufei(Puntoxy_double,comun12,n){
			ptri->x*=aux; ptri->y*=aux; ptri++;
			ptri->x*=auxb; ptri->y*=auxb; ptri++;
		}
	}
	vmin*=vmin;
	tol_intersec=TOL_FF*vmin*1.0E6F;

	CentroProy *c;
	c=mod.centros.ppio;
	default_values_CP(*c);
	c->fot=fot1;
	c->P.X=c->P.Y=c->P.Z=0;
	zeroset_double(&c->M[0][0],9);
	c->M[0][0]=c->M[1][1]=c->M[2][2]=1;
	c++;
	default_values_CP(*c);
	c->fot=fot2;

	seleccionados[0]=Я;
	cc[3].nret=cc[2].nret=cc[1].nret=cc[0].nret=100;

	if(n<7) modo_toma=ATMODOTOMA_Plano;
	elif(modo_toma==ATMODOTOMA_Unknown){
		if(n>=12) modo_toma=ATMODOTOMA_Generico;
		else{
		aj_decl_alloc_add(PuntoXYZ_double,comun_tri, n<<1);
		Extremos3D_dbl mm1, mm2;	//X guardará y; Y, -0.866x-0.5Y; Z, 0.866x-0.5Y
		uint zonas1[21], zonas2[21];	//(6+1)*3
		u8int b1,b2;	//flags con las direcciones con todas las zonas completas
		{PuntoXYZ_double *ptr=comun_tri;
		Puntoxy_double *ptr_b=comun12;
		mm1.MX=mm1.mx=ptr->X= ptr_b->y;
		mm1.MY=mm1.my=ptr->Y= -0.866*ptr_b->x-0.5*ptr_b->y;
		mm1.MZ=mm1.mz=ptr->Z= 0.866*ptr_b->x-0.5*ptr_b->y;
		ptr++, ptr_b++;
		mm2.MX=mm2.mx=ptr->X= ptr_b->y;
		mm2.MY=mm2.my=ptr->Y= -0.866*ptr_b->x-0.5*ptr_b->y;
		mm2.MZ=mm2.mz=ptr->Z= 0.866*ptr_b->x-0.5*ptr_b->y;
		ptr++, ptr_b++;
		dontimes(n-1,){
			ptr->X=ptr_b->y;
			double aux=0.866*ptr_b->x;
			ptr->Y=-aux-0.5*ptr_b->y;
			ptr->Z=aux-0.5*ptr_b->y;
			ptr_b++;
			extremos3D_updateonpoint(mm1,*ptr);
			ptr++;
			//
			ptr->X=ptr_b->y;
			aux=0.866*ptr_b->x;
			ptr->Y=-aux-0.5*ptr_b->y;
			ptr->Z=aux-0.5*ptr_b->y;
			ptr_b++;
			extremos3D_updateonpoint(mm2,*ptr);
			ptr++;
		}}
		//Cuanto más grandes son las zonas más exigente es el criterio
		double _ancho1, _ancho2;
		_ancho1=mm1.MX-mm1.mx;
		{double aux=mm1.MY-mm1.my; if(aux>_ancho1) _ancho1=aux;}
		{double aux=mm1.MZ-mm1.mz; if(aux>_ancho1) _ancho1=aux;}
		_ancho2=mm2.MX-mm2.mx;
		{double aux=mm2.MY-mm2.my; if(aux>_ancho2) _ancho2=aux;}
		{double aux=mm2.MZ-mm2.mz; if(aux>_ancho2) _ancho2=aux;}
		_ancho1=5/_ancho1;	//división en 5 zonas según cada dirección
		_ancho2=5/_ancho2;
		//cada uint de cada elemento de zona1 o zona2 es: byte0: X; byte 1: Y; byte2: Z; byte 3 a cero.
		//El sétimo elemento, distinto de ~0, marca el final. Se exigen 6 zonas ocupadas según cada partición
		oneset_uint(zonas1,21);
		oneset_uint(zonas2,21);
		zonas1[6]--; zonas1[13]--; zonas1[20]--;
		zonas2[6]--; zonas2[13]--; zonas2[20]--;
		b2=b1=0;
		modo_toma=ATMODOTOMA_Plano;
#define _3 0.333333333333
#define _6 0.666666666666
#define zonas_a zonasx
#define zonas_b (zonasx+7)
#define zonas_c (zonasx+14)
		bint bpar=0;	//Punto de la foto izquierda o de la foto derecha
		Durchlaufei(PuntoXYZ_double,comun_tri,n<<1){
			u8int bx;
			uint *zonasx;
			double _anchox;
			if(bpar==0){
				bx=b1; zonasx=zonas1; _anchox=_ancho1;
			}else{
				bx=b2; zonasx=zonas2; _anchox=_ancho2;
			}
			if(bx==7){bpar=!bpar; ptri++; continue;}

			uint zona;
			double x1,x2,x3;
			u8int z1,z2,z3;
			x1=(ptri->X-mm1.mx)*_anchox;
			x2=(ptri->Y-mm1.my)*_anchox;
			x3=(ptri->Z-mm1.mz)*_anchox;
			ptri++;
			if(!(bx&1)){
				z1=(u8int)(ssint)x1;
				z2=(u8int)(ssint)x2;
				z3=(u8int)(ssint)x3;
				zona=(z3<<16) | (z2<<8) | z1;
				uint *ptrj;
				for(ptrj=zonas_a; !(*ptrj&0xFF000000U) && *ptrj!=zona; ptrj++);	//también vale *ptrj!=~0U
				if(*ptrj==~0U){
					*ptrj++=zona;
					if(*ptrj!=~0U) bx|=1;
				}
			}
			if(!(bx&2)){
				z1=(u8int)(ssint)(x1+_3);
				z2=(u8int)(ssint)(x2+_3);
				z3=(u8int)(ssint)(x3+_3);
				zona=(z3<<16) | (z2<<8) | z1;
				uint *ptrj;
				for(ptrj=zonas_b; !(*ptrj&0xFF000000U) && *ptrj!=zona; ptrj++);	//también vale *ptrj!=~0U
				if(*ptrj==~0U){
					*ptrj++=zona;
					if(*ptrj!=~0U) bx|=2;
				}
			}
			if(!(bx&4)){
				z1=(u8int)(ssint)(x1+_6);
				z2=(u8int)(ssint)(x2+_6);
				z3=(u8int)(ssint)(x3+_6);
				zona=(z3<<16) | (z2<<8) | z1;
				uint *ptrj;
				for(ptrj=zonas_c; !(*ptrj&0xFF000000U) && *ptrj!=zona; ptrj++);	//también vale *ptrj!=~0U
				if(*ptrj==~0U){
					*ptrj++=zona;
					if(*ptrj!=~0U) bx|=4;
				}
			}
			if(!bpar) b1=bx;
			else b2=bx;
			bpar=!bpar;
			if(b1==7 && b2==7) break;
		}
		if(b1==7 && b2==7) modo_toma=ATMODOTOMA_Generico;
		Free_remove(comun_tri);
		}
#undef zonas_a
#undef zonas_b
#undef zonas_c
#undef _3
#undef _6
	}

	//TRACE(towrite(&fp,'s',"modo: ",'c','0'+modo, 's',"    ",0);)
	if(modo_toma==ATMODOTOMA_Plano){
		result->nret=aproxfot_2D(comun12,n,(PuntoXYZM_double*)&c->P,&result->vv,vmin);
		ifunlike(result->nret){return_ATplist mod;}	//out-of-mem
		func_apr=FUNC_2D;
	}else{
		result->nret=aproxfot_M9(comun12,n,(PuntoXYZM_double*)&c->P);
		if(result->nret==0) result->vv=(float)sum_vv((PuntoXYZM_double*)&c->P,comun12,n);

		if(n>=8) func_apr=FUNC_8p;
		elif(n==7) func_apr=FUNC_7p;
		else func_apr=FUNC_6p;
		cc[func_apr].nret=result->nret;
		cc[func_apr].c=*(PuntoXYZM_double*)&c->P;
	#ifdef _DEBUG
		if(result->nret==0)
	#endif
		cc[func_apr].vv=result->vv;

		if(result->nret || result->vv>4*vmin*(float)(n-5)){
			selecciona_puntos_separados_n(comun12,n,7,seleccionados);
			Puntoxy_double *pP=puntos_sel;
			durchlaufei(uint,seleccionados,7){
				Puntoxy_double *pcomun=comun12+(*ptri<<1);
				*pP++=*pcomun++;
				*pP++=*pcomun;
			}
			if(n>=8){
				//TRACE(towrite_string(&fp,"7p-");)
				cc[FUNC_7p].nret=aproxfot_M9(puntos_sel,7,&cc[FUNC_7p].c);
				if(cc[FUNC_7p].nret==0){
					cc[FUNC_7p].vv=(float)sum_vv(&cc[FUNC_7p].c,comun12,n);
					if(result->nret || cc[FUNC_7p].vv<result->vv){
						//TRACE(towrite_string(&fp,"SI    ");)
						result->nret=0; *(PuntoXYZM_double*)&c->P=cc[FUNC_7p].c;
						result->vv=cc[FUNC_7p].vv;
						func_apr=FUNC_7p;
					}
					//TRACE(else{towrite_string(&fp,"NO    ");})
				}
				//TRACE(else{towrite_string(&fp,"BAD   ");})
			}
			/*if((result->nret || result->vv>10*vmin*(float)(n-5)) && n>=7){
				//TRACE(towrite_string(&fp,"6p-");)
				cc[FUNC_6p].nret=aproxfot_M9(puntos_sel,6,&cc[FUNC_6p].c);
				if(cc[FUNC_6p].nret==0){
					cc[FUNC_6p].vv=(float)sum_vv(&cc[FUNC_6p].c,comun12,n);
					if(result->nret || cc[FUNC_6p].vv<result->vv){
						//TRACE(towrite_string(&fp,"SI    ");)
						result->nret=0; *(PuntoXYZM_double*)&c->P=cc[FUNC_6p].c;
						result->vv=cc[FUNC_6p].vv;
						func_apr=FUNC_6p;
					}
					//TRACE(else{towrite_string(&fp,"NO    ");})
				}
				//TRACE(else{towrite_string(&fp,"BAD   ");})
			}*/
			if(result->nret || result->vv>100*vmin*(float)(n-5)){
				//TRACE(towrite_string(&fp,"2D-");)
				cc[FUNC_2D].nret=aproxfot_2D(comun12,n,&cc[FUNC_2D].c,&cc[FUNC_2D].vv,vmin);
				ifunlike(cc[FUNC_2D].nret){return_ATplist mod;}	//can only be out-of-mem
				if(result->nret || cc[FUNC_2D].vv<result->vv){
					//TRACE(\
						if(result->nret) towrite_string(&fp,"SI    ");\
						else towrite(&fp,'s',"SI(", 'f',result->vv/vmin,'/', 'f',result->vv/cc[FUNC_2D].vv, 's',")    ", 0);\
					)
					result->nret=0; *(PuntoXYZM_double*)&c->P=cc[FUNC_2D].c;
					result->vv=cc[FUNC_2D].vv;
					func_apr=FUNC_2D;
				}
				//TRACE(else{towrite_string(&fp,"NO    ");})
			}
		}
		if(result->nret==1 && n_force<N_FORCE_NEG){result->nret=FOTFOT_Negativos; return_ATplist mod;}
	}

	Venlarge_n(mod.puntos,PuntoMrel,n,goto salida_outofmem);
	{PuntoMrel *punpm=mod.puntos.ppio;
	uint *pind_com=ind_com;
	dontimes(n,punpm++){
		punpm->index=fot1->puntos.ppio[*pind_com].index;	pind_com++;
	}}
	//Ver los valores de den
	if(ispos_u16(n_force) && fabs(c->M[2][2])>0.8 && result->vv<30*vmin){	//else, dejarlo para más adelante
		uint nbien=n;
		PuntoMrel *punpm=mod.puntos.ppio;
		Puntoxy_double *ptr=comun12;
		dontimes(n,punpm++){
			//El valor de den es provisional
			Puntoxy_double b,d;
			b=*ptr++;
			d=*ptr++;
			punpm->den=secrr3_ap_den(b,c->M,d);
			if(modo_toma==ATMODOTOMA_Generico && n>=8) punpm->den*=0.5F;
			if(punpm->den<TOL_ACEPTAR){	//Por si hay un recubrimiento muy grande,
				nbien--;		//para que en vez de orientar cada foto con la siguiente haga pares con una de cada dos, o cada 3, ...
				//TRACE(if(punpm->den<tol_intersec || nbien<n_force) towrite_string(&fp,"antes-");)
				if(punpm->den<tol_intersec){result->nret=FOTFOT_Agudo_1; return_ATplist mod;}
				if(nbien<n_force){result->nret=FOTFOT_Agudo_n; return_ATplist mod;}
			}
		}
	}

	double Mk[3][3];
	memcpy_double(Mk[0],c->M[0],9);
	aproxima_κ(Mk);

	result->iter=iterate_fotfot((PuntoXYZM_double*)&c->P,comun12,n);
	AutoGiraPunto_inv_dbl(&c->P,c->M);
	result->nret=sumvv_exacto((PuntoXYZM_double*)&c->P,comun12,n,&result->vv);
	ifunlike(isneg_u16(result->iter) || result->nret || result->vv>10*vmin*(float)(n-5)){
		if(func_apr!=FUNC_2D){
			if(cc[FUNC_2D].nret==100){
				cc[FUNC_2D].nret=aproxfot_2D(comun12,n,&cc[FUNC_2D].c,&cc[FUNC_2D].vv,vmin);
				ifunlike(cc[FUNC_2D].nret){return_ATplist mod;}
			}
			u16int iter=iterate_fotfot(&cc[FUNC_2D].c,comun12,n);
			AutoGiraPunto_inv_dbl(&cc[FUNC_2D].c.P,cc[FUNC_2D].c.M);
			cc[FUNC_2D].nret=sumvv_exacto(&cc[FUNC_2D].c,comun12,n,&cc[FUNC_2D].vv);
			if(ispos_u16(iter) && (isneg_u16(result->iter) ||
				((!cc[FUNC_2D].nret || result->nret) && cc[FUNC_2D].vv<result->vv) )){
				result->nret=cc[FUNC_2D].nret;
				result->iter=iter; *(PuntoXYZM_double*)&c->P=cc[FUNC_2D].c;
				result->vv=cc[FUNC_2D].vv;
				func_apr=FUNC_2D;
			}
		}
		/*if(isneg_u16(result->iter) || result->nret || result->vv>15*vmin*(float)(n-5)){
			TRACE(towrite(&fp,'s',"brute-force: (",'f',result->vv/(vmin*(float)(n-5)),0);)
			const double paso=0.08,
							limite=7*paso;
			Giro3DTrig_dbl G;
			G.cosk=Mk[0][0];
			G.sink=-Mk[0][1];
			for(G.sinfi=0;G.sinfi<limite+0.01;G.sinfi+=paso){
				G.cosfi=sqrt(1-G.sinfi*G.sinfi);
				for(G.sinw=-limite;G.sinw<limite+0.01;G.sinw+=paso){
					PuntoXYZM_double cbr;
					float vv;
					G.cosw=sqrt(1-G.cosw*G.cosw);
					MatrizRotGT_ωφκ(G,cbr.M);
					vv=testM_against_result(result,&cbr,comun12,n);
					if(vv>=0){
						TRACE(towrite(&fp,'s'," si:",'f',result->vv/(vmin*(float)(n-5)),0);)
						*(PuntoXYZM_double*)&c->P=cbr;
						if(!result->nret && vv<4*vmin*(float)(n-5)) goto fin_fuerzabruta;
					}
				}
				if(G.sinfi==0) continue;
				G.sinfi=-G.sinfi;
				for(G.sinw=-limite;G.sinw<limite+0.01;G.sinw+=paso){
					PuntoXYZM_double cbr;
					float vv;
					G.cosw=sqrt(1-G.cosw*G.cosw);
					MatrizRotGT_ωφκ(G,cbr.M);
					vv=testM_against_result(result,&cbr,comun12,n);
					if(vv>=0){
						TRACE(towrite(&fp,'s'," si:",'f',result->vv/(vmin*(float)(n-5)),0);)
						*(PuntoXYZM_double*)&c->P=cbr;
						if(!result->nret && vv<4*vmin*(float)(n-5)) goto fin_fuerzabruta;
					}
				}
				G.sinfi=-G.sinfi;
			}
	fin_fuerzabruta:
			TRACE(towrite_string(&fp," ) "););
		}*/
	}

	if(ispos_u16(result->iter)) result->nret=0;
	else{result->iter=~result->iter; result->nret=1;}

	//AutoGiraPunto_inv_dbl(&c->P,c->M);
	result->vv=0;
	//Cálculo de las coordenadas de los puntos y vv; fpuntosm
	{result->p_peor=0;	//just in case there are only five points
	result->vvmax=0;
	uint nbien=n, nneg=0;
	Puntofx pmv;
	if(fabs(c->M[2][2])>0.8) psec_rr=secrr3_ap_foto_vv;
	else psec_rr=secrr3_foto_vv;
	//pmv.nfotos=2;
	pmv.fp[0].f=0;
	pmv.fp[1].f=1;
	PuntoMrel *punpm=mod.puntos.ppio;
	Puntoxy_double *ptr=comun12;
	for(uint i=0;i<n;i++,punpm++){
		Puntoxy_double b,d;
		b=*ptr++;
		d=*ptr++;
		punpm->vv=0;
		punpm->den=psec_rr(b,c->P,c->M,d,&punpm->P,&punpm->vv);
		if(ispos_u16(n_force)){
			if(punpm->P.Z>=0) nneg++;
			if(punpm->den<TOL_ACEPTAR){
				nbien--;
				//TRACE(if(punpm->den<tol_intersec || nbien<n_force) towrite_string(&fp,"después-");)
				if(punpm->den<tol_intersec){result->nret=FOTFOT_Agudo_1; return_ATplist mod;}
				if(nbien<n_force){result->nret=FOTFOT_Agudo_n; return_ATplist mod;}
			}
		}
		result->vv+=punpm->vv;
		if(punpm->vv>result->vvmax){result->vvmax=punpm->vv; result->p_peor=i;}
	}
	double bneg=1.0;
	if(nneg+nneg>n){nneg=n-nneg; bneg=-1.0;}
	if(n_force<N_FORCE_NEG && nneg>1 && nneg>(n+3)>>3){result->nret=FOTFOT_Negativos; return_ATplist mod;}

	punpm=mod.puntos.ppio;
	for(uint i=0;i<n;i++,punpm++){
		if((bneg*punpm->P.Z)>=0 || punpm->den<tol_intersec){
			if(punpm->den>0.9F*tol_intersec) punpm->den=tol_intersec;	//in case the comparision is carried in another machine
			pmv.nom=punpm->index;												//(the model is returned and may be used elsewhere)
			pmv.n_puntom=i;
			pmv.fp[0].p=ind_com[i];
			pmv.fp[1].p=ind_com2[i];
			if(mod.fpuntosm.N==0){
				aj_malloc_n(mod.fpuntosm.ppio,Puntofx,4);
				mod.fpuntosm.N=4;
			}
			Addh_puntom(&mod.hpuntos,punpm->index, mod.fpuntosm.n,at_fpuntosm);
			Vadd(mod.fpuntosm,Puntofx,pmv,goto salida_outofmem);
		}else{
			Addh_puntom(&mod.hpuntos,punpm->index, i,at_puntos);
		}
	}
	PuntoMrel pm=mediana_PuntoMrel(mod.puntos.ppio,mod.puntos.n);
	float _vminZ;
	pm.P.Z=-1.0/pm.P.Z;
	P_mul(c->P,pm.P.Z);
	result->vv*=(float)(pm.P.Z*pm.P.Z);
	_vminZ=(float)(pm.P.Z*pm.P.Z)/vmin;
	durchVectori(PuntoMrel,mod.puntos){
		P_mul(ptri->P,pm.P.Z); ptri->vv*=_vminZ;
	}
	}

	if(result->nret==0){
		uint k=n-5;
		if(k){
			result->vv=sqrtf(result->vv/(float)k);
			result->vvmax=sqrtf(result->vvmax*(1.0F+5.0F/k));
		}
		else result->vv=0;
	}
	result->p_peor=mod.puntos.ppio[result->p_peor].index;
	remove_from_delete_Modelo(&mod);
	return_ATplist mod;

salida_outofmem:
	result->nret=AT_NOMEM; return_ATplist mod;
}

/*float testM_against_result(Resultado *result, PuntoXYZM_double *c,Puntoxy_double* comun12,uint n){
	float vv;
	u16int iter;

	obtenerP_fotfot(c,comun12,n);
	iter=iterate_fotfot(c,comun12,n);
	AutoGiraPunto_inv_dbl(&c->P,c->M);
	int nret=sumvv_exacto(c,comun12,n,&vv);
	if(ispos_u16(iter) && (isneg_u16(result->iter) || ((!nret || result->nret) && vv<result->vv) )){
		result->nret=nret;
		result->iter=iter;
		result->vv=vv;
		//func_apr=BRUTE_FORCE;
		return vv;
	}
	return -vv;
}*/
