﻿#define N_ESTIMADORES 2
static const char16_t* const nombres_estimadores[]={
	u"Mínimo cuadrático",
	u"Aerotri 2006",
};
static const char8_t* const sEsfera="Esfera";

#define write_bits_masked(buf,n,mask)\
	do{char16_t c;	if(!(mask&1)) c='-'; else c=(n&1)+'0';\
		toput_char(buf,c);\
		mask>>=1, n>>=1;\
	}while(mask)

void escribe_trabajo_sistema(Bufferto16 *buf, Trabajo_Sistema *sis);
void escribe_salida_opciones(Bufferto16 *buf,AjbloqueConfigSalida *salida);

int escribe_trabajoAT(const char16_t* ficherot, TrabajoAerotri *trabajo,bint modo){
	Bufferto16 buf;
	int nret;
	const char16_t * const presentesi=u"presente\tsi\n";
	const char16_t * const presenteno=u"presente\tno\n";

	nret=toopen16(&buf,ficherot);
	ifunlike(nret){
		toclose(&buf); return nret;
	}
	setbuf_limpio(&buf);
	setbuf_relative(&buf);

	{const char16_t *s1, *s2, *s3;
	const char16_t desconocido[]=u"Desconocido";
	if(trabajo->sensor==0) s1=u"Conico";	else s1=u"Modelo";
	if(trabajo->modos.modo_toma==ATMODOTOMA_Plano) s2=u"Plano";
	else if(trabajo->modos.modo_toma==ATMODOTOMA_Generico) s2=u"Generico";
	else s2=desconocido;
	if(trabajo->modos.modo_medida==ATMODOMEDIDA_Manual) s3=u"Manual";
	else if(trabajo->modos.modo_medida==ATMODOMEDIDA_Automatico) s3=u"Automatico";
	else s3=desconocido;
	towrite16_many_strings(&buf,u"%Aerotri\n\n\\begin General\nSensor ",s1,
											u"\nToma ",s2,u"\nMedida ",s3,NULL);
	towrite16_string(&buf,u"\nAjuste ");
	towrite16_uint(&buf,trabajo->modos.modo_ajuste);
	towrite16_string(&buf,u"\n\\end\n");
	}
	if(modo){
	#define writeif(filename) if(filename!=NULL) towrite16_string(&buf,filename)
		towrite16_string(&buf,u"\n\\begin Ficheros\n");
		towrite16_string(&buf,u"Fotogramas \""); writeif(trabajo->ficheros.fotos); towrite16_string(&buf,u"\"\n");
		towrite16_string(&buf,u"Aproximadas \""); writeif(trabajo->ficheros.aproximadas); towrite16_string(&buf,u"\"\n");
		towrite16_string(&buf,u"Apoyo \""); writeif(trabajo->ficheros.apoyo); towrite16_string(&buf,u"\"\n");
		towrite16_string(&buf,u"GPS/INS \""); writeif(trabajo->ficheros.gpsins); towrite16_string(&buf,u"\"\n");
		towrite16_string(&buf,u"Camara \""); writeif(trabajo->ficheros.camara); towrite16_string(&buf,u"\"\n");
		towrite16_string(&buf,u"generar ");
			{u8int n; uint mask;
			n=trabajo->ficheros.generar; mask=0x1F;
			write_bits_masked(&buf,n,mask);}
			toput_char(&buf,'\n');
	towrite16_string(&buf,u"\\end\n");
	#undef writeif
	}
	towrite16_string(&buf,u"\n\\begin Tipo de ficheros\n");
	{u8int tf=trabajo->tiposf.tfot;
	towrite16_string(&buf,u"tffot ");
	if(isneg(tf)){toput_char(&buf,'-'); tf=~tf;} towrite16_uint(&buf,tf); toput_char(&buf,'\n');}
	towrite(&buf,
		's',   u"tfapr ", 'u',trabajo->tiposf.tapr,
		's',u"\ntfapy ", 'u',trabajo->tiposf.tapy,
		's',u"\ntfgps ", 'u',trabajo->tiposf.tgps,
		's',u"\ntfint ", 'u',trabajo->tiposf.tint,
		's',u"\ntdapr ", 'u',trabajo->tiposf.tdapr,
		's',u"\n\\end\n",0);
	towrite(&buf,'s',u"\n\\begin Fijas\n"
		u"Apoyo\t",'c','0'+trabajo->opciones.fijas, 's',u" %0 fijas, 1 variables\n"
		u"\\end\n",0);
	{char16_t tdgps, tdins;
	if(trabajo->datosgps.tdgps<10) tdgps='0'+trabajo->datosgps.tdgps; else tdgps='O';
	if(trabajo->datosgps.tdins<10) tdins='0'+trabajo->datosgps.tdins; else tdins='O';
	towrite(&buf,'s',u"\\begin Tipo de datos\n"
			  "GPS\t",'c',tdgps,
		's',u"\nINS\t",'c',tdins,
		's',u"\n\\end\n",0);}
	{char16_t ss[32]=u"xy\t?\n" "XY\t?\n" "PlaniZ\t?\n" "\\end\n";
	if(trabajo->conjuntas.xy) ss[3]='1'; else ss[3]='0';
	if(trabajo->conjuntas.XY) ss[8]='1'; else ss[8]='0';
	if(trabajo->conjuntas.planiZ) ss[17]='1'; else ss[17]='0';
	towrite16_string(&buf,u"\\begin Conjuntas\n"); towrite16_string(&buf,ss);}

	{const char16_t *ssino;
	char16_t ss[]=u"f\t?\npp\t?\n";
	if(trabajo->autocalib.existe) ssino=presentesi; else ssino=presenteno;
	if(trabajo->autocalib.selected.f) ss[2]='1'; else ss[2]='0';
	if(trabajo->autocalib.selected.pp) ss[7]='1'; else ss[7]='0';
	towrite16_many_strings(&buf,u"\n\\begin Autocalibracion\n",ssino,ss,NULL);}

	{const char16_t *ssino, *modelopoli, *modeloasim;
	if(trabajo->autocalib.selected.distorsion) ssino=presentesi; else ssino=presenteno;
	if(trabajo->autocalib.config_dist.modelo_poli<=1) modelopoli=u"Impar\n"; else modelopoli=u"Completo\n";
	if(trabajo->autocalib.config_dist.modelo_asim<=1) modeloasim=u"Radial / tangencial\n"; else modeloasim=u"Vector giratorio\n";
	towrite16_many_strings(&buf,u"\n\\begin Funcion de distorsion\n",ssino,
		u"modelo polinomico\t",modelopoli,
		u"modelo asimetrico\t",modeloasim,NULL);}

	{const char16_t *ssino;
	u16int n=trabajo->autocalib.config_dist.param_radsim;
	if(trabajo->autocalib.selected.componentes.radsim) ssino=presentesi; else ssino=presenteno;
	towrite16_many_strings(&buf,u"\n\\begin Radial simetrica\n",ssino,u"parametros\t",NULL);
	do{toput_char(&buf,'0'+(n&1)); n>>=1;}while(n);
	towrite16_string(&buf,u"\n\\end\n");}

	{const char16_t *ssino;
	u16int n=trabajo->autocalib.config_dist.param_tansim;
	if(trabajo->autocalib.selected.componentes.tansim) ssino=presentesi; else ssino=presenteno;
	towrite16_many_strings(&buf,u"\n\\begin Tangencial simetrica\n",ssino,u"parametros\t",NULL);
	do{toput_char(&buf,'0'+(n&1)); n>>=1;}while(n);
	towrite16_string(&buf,u"\n\\end\n");}

	{const char16_t *ssino;
	u16int n1, n2;
	n1=trabajo->autocalib.config_dist.param_asim1;
	n2=trabajo->autocalib.config_dist.param_asim2;
	if(trabajo->autocalib.selected.componentes.asimetricas) ssino=presentesi; else ssino=presenteno;
	towrite16_many_strings(&buf,u"\n\\begin Asimetricas\n",ssino,u"serie1\t",NULL);
	do{toput_char(&buf,'0'+(n1&1)); n1>>=1;}while(n1);
	towrite16_string(&buf,u"\nserie2\t");
	do{toput_char(&buf,'0'+(n2&1)); n2>>=1;}while(n2);
	towrite16_string(&buf,u"\n\\end\n");}

	towrite16_string(&buf,u"\n\\end\tFuncion de distorsion\n\n"
							u"\\end\tAutocalibracion\n\n");

	buf.prec.signi=5;
	#define towrite_precision(buf,nombre,f) towrite16_string(buf,nombre); if(isfinite(f)) towrite_float(buf,f); toput_char(buf,'\n');
	towrite16_string(&buf,u"\\begin Precisiones\n");
	towrite_precision(&buf,u"Fotocoordenadas ",trabajo->apriori.im);
	towrite_precision(&buf,u"ApoyoXY\t",trabajo->apriori.pXY);
	towrite_precision(&buf,u"ApoyoZ\t",trabajo->apriori.pZ);
	towrite_precision(&buf,u"GPSXY\t",trabajo->apriori.gpsXY);
	towrite_precision(&buf,u"GPSZ\t",trabajo->apriori.gpsZ);
	towrite_precision(&buf,u"INSWF\t",trabajo->apriori.insΩΦ);
	towrite_precision(&buf,u"INSK\t",trabajo->apriori.insK);
	towrite16_string(&buf,u"\\end\n");
	#undef towrite_precision

	buf.prec.signi=9;
	toput_char(&buf,'\n');
	escribe_trabajo_sistema(&buf,&trabajo->sistema);

	towrite16_string(&buf,u"\n\\begin Tipo de ajuste\n");
	{u8int n=trabajo->opciones.estimador;
	if(n>=N_ESTIMADORES) n=0;
	if(n==0) towrite16_string(&buf,u"0\t%");
	towrite16_string(&buf,nombres_estimadores[n]);}
	towrite16_string(&buf,u"\n\\end\n");

	towrite(&buf,'s',u"\\begin Valores aproximados\n"
			u"Tipo de ajuste\t",'u',trabajo->valoresaproximados.force_mmcc,
		's',u"\nUsa gps ",'u',trabajo->valoresaproximados.usa_gps,
		's',u"\nMinimo puntos\t",'u',trabajo->valoresaproximados.hacha,0);
	if(trabajo->valoresaproximados.hacha==0) towrite16_string(&buf,u"\t%Deducir");
	towrite(&buf,'s',u"\nParametro de camino\t",'f',(float)trabajo->valoresaproximados.mult_contra/100.0F,0);
	if(trabajo->valoresaproximados.mult_contra==0) towrite16_string(&buf,u"\t%Deducir");
	towrite16_string(&buf,u"\n\\end\n");

	{const char16_t *s1, *s2;
	if(trabajo->salidatrabajo.log_ajuste) s1=u"Si"; else s1=u"No";
	if(trabajo->salidatrabajo.log_pdfs) s2=u"Si"; else s2=u"No";
	towrite(&buf,'s',u"\n\\begin Informacion de salida\n"
			u"Log_ajuste ",'s',s1,
		's',u"\nLog_level ",'u',trabajo->salidatrabajo.log_level,
		's',u"\nLog_pdfs ",'s',s2,
		's',u"\nFicheros ",0);}
	{uint n,mask;
	n=*(uint*)&trabajo->configsalida.ficheros&0xFFFF;
	mask=MASK_SalidaAjbloque_F1;
	write_bits_masked(&buf,n,mask);}
	toput_char(&buf,' ');
	{uint n,mask;
	n=*(uint*)&trabajo->configsalida.ficheros>>16;
	mask=MASK_SalidaAjbloque_F2;
	write_bits_masked(&buf,n,mask);}
	towrite16_string(&buf,u"\nMuestra_html ");
	{const char16_t *s; if(trabajo->salidatrabajo.muestra_html) s=u"Si\n"; else s=u"No\n"; towrite16_string(&buf,s);}

	escribe_salida_opciones(&buf,&trabajo->configsalida);
	towrite16_string(&buf,u"\\end Informacion de salida\n");

	towrite(&buf,'s',u"\n\\begin Opciones\n"
		u"Unidades giros ",'u',trabajo->opciones.unigiros, 's',u"\t%0 radianes, 1 gon, 2 sexa\n"
		u"Escala residuos ",0);
	if(trabajo->opciones.escalaresiduos<4) toput_char(&buf,'0'+trabajo->opciones.escalaresiduos);
	else{
		const float *pf;
		buf.prec.signi=4;
		towrite16_string(&buf,u"-1\t");
		pf=trabajo->opciones.residuos_escala;
		while(isfinite(*pf)) {towrite_float(&buf,*pf++); toput_char(&buf,' ');}
	}
	towrite16_string(&buf,u"\t%0, 1, 2, 3\n"
		u"Signo INS ");
	{char16_t c; if(trabajo->datosgps.signoins==0) c='+'; else c='-'; toput_char(&buf,c);}
	{const char16_t *s2;
	if(trabajo->opciones.interp_resgps) s2=u"Si"; else s2=u"No";
	towrite16_string(&buf,u"\nCalcular GPS/INS intermedios "); toput_char(&buf,'0'+trabajo->opciones.interp_gps);
	towrite16_many_strings(&buf,	u"\nInterpolar residuos GPS/INS ",s2,
							u"\nGiroINS ",NULL);}
	{char16_t c; if(trabajo->opciones.bgirok) c='1'; else c='0'; toput_char(&buf,c);}
	towrite16_string(&buf,u"\n\\end\n");

	toclose(&buf);
	return buf.error_code;
}

void escribe_trabajo_sistema(Bufferto16 *buf, Trabajo_Sistema *sis){
	const char16_t * const nombres[]={
		u"Rectangular", //0
		u"Conforme genérico", //1
		u"Lambert", //2
		u"Mercator", //3
		u"Estereográfica", //4
		u"UTM", //5
		u"",u"",u"",u"", //6-9
		u"Geográficas" //10
	};
	towrite(buf,'s',u"\\begin Sistema de coordenadas\n"
			u"Sistema ",'s',nombres[sis->nsistema],
		's',u"\nElipsoide ",'u',sis->elipsoide,'s',u" %0 Esfera, 1 Otro, 2 Hayford, 3 GRS80 / WGS8 / CGSC2000, 4 Bessel 1841, 5 Krassovsky, 6 Sudamérica 1969",
		's',u"\nOndulacion\t",'f',sis->ondulacion,0);

	towrite(buf,'s',u"\n\\begin Esfera\n"
			u"N\t",'f',sis->tierra.N,
		's',u"\nrho\t",'f',sis->tierra.rho,
		's',u"\nconv\t",'f',sis->tierra.conv,
		's',u"\nk\t",'f',sis->tierra.k,
		's',u"\n\\end\n"
		u"\\begin Otro\n"
			u"a\t",'f',sis->elipsoideotro.a,
		's',u"\ne2\t",'f',sis->elipsoideotro.ee,
		's',u"\n\\end\n",0);

	towrite(buf,'s',u"\n\\begin Geograficas\n"
			u"orden_latlong\t",'u',sis->valoressistemas.LatLong,
			's',u"\n\\end\n",0);
	{uint g,r,f,ii,i;
	g=(uint)sis->valoressistemas.Phi0Lambert;
	towrite16_string(buf,u"\\begin Lambert\n" "Phi0\t");
	if(isneg(g)){toput_char(buf,'-'); g=-g;}
	r=g/1000; f=g-1000*r; g=r;
	r=g/60; ii=g-60*r; g=r;
	r=g/60; i=g-60*r; g=r;
	towrite(buf,'u',g,'.','u',i,'.','u',ii,0);
	if(f!=0){toput_char(buf,'.'); towrite16_uint(buf,f);}}
	towrite(buf,
		's',u"\nK0\t",'f',sis->valoressistemas.kLambert,
		's',u"\nX\t",'f',sis->valoressistemas.XLambert,
		's',u"\nY\t",'f',sis->valoressistemas.YLambert,
		's',u"\n\\end\n",0);
	towrite(buf,'s',u"\\begin UTM\n"
			u"K0\t",'f',sis->valoressistemas.kUTM,
		's',u"\nX\t",'f',sis->valoressistemas.XUTM,
		's',u"\nY\t",'f',sis->valoressistemas.YUTM,
		's',u"\n\\end\n",0);
	towrite16_string(buf,u"\\end Sistema de coordenadas\n");
}

void escribe_salida_opciones(Bufferto16 *buf,AjbloqueConfigSalida *salida){
	towrite(buf,'s',u"\\begin General\n" "Idioma ",'u',salida->general.idioma,'\n',0);
	{const char16_t *s; if(salida->general.rel_paths) s=u"Rutas relativas\n"; else s=u"Rutas absolutas\n";
	towrite16_string(buf,s);}
	towrite16_many_strings(buf,u"Unidades imagen ",salida->general.uniim,
									u"\nUnidades foto ",salida->general.unif,
									u"\nUnidades terreno ",salida->general.unit,NULL);
	towrite16_string(buf,u"\nDecr.f "); {ssint n=salida->general.decres.im; if(n<0){toput_char(buf,'-'); n=-n;} towrite16_uint(buf,n);}
	towrite16_string(buf,u"\nDecr.p "); {ssint n=salida->general.decres.p; if(n<0){toput_char(buf,'-'); n=-n;} towrite16_uint(buf,n);}
	towrite16_string(buf,u"\nDecr.gps "); {ssint n=salida->general.decres.gps; if(n<0){toput_char(buf,'-'); n=-n;} towrite16_uint(buf,n);}
	towrite16_string(buf,u"\nDecr.ins "); {ssint n=salida->general.decres.ins; if(n<0){toput_char(buf,'-'); n=-n;} towrite16_uint(buf,n);}
	towrite16_string(buf,u"\nDecj.f "); {ssint n=salida->general.decajs.im; if(n<0){toput_char(buf,'-'); n=-n;} towrite16_uint(buf,n);}
	towrite16_string(buf,u"\nDecj.p "); {ssint n=salida->general.decajs.p; if(n<0){toput_char(buf,'-'); n=-n;} towrite16_uint(buf,n);}
	towrite16_string(buf,u"\nDecj.cp.p "); {ssint n=salida->general.decajs.gps; if(n<0){toput_char(buf,'-'); n=-n;} towrite16_uint(buf,n);}
	towrite16_string(buf,u"\nDecj.cp.g "); {ssint n=salida->general.decajs.ins; if(n<0){toput_char(buf,'-'); n=-n;} towrite16_uint(buf,n);}
	towrite16_string(buf,u"\nDecj.rot "); {ssint n=salida->general.decrot; if(n<0){toput_char(buf,'-'); n=-n;} towrite16_uint(buf,n);}
	towrite16_string(buf,u"\n\\end\n");

	towrite(buf,'s',u"\\begin Pares\n"
			u"nmin ",'u',salida->pares_pasadas.nmin,
		's',u"\nModo ",'c','0'+salida->pares_pasadas.modo,
		's',u"\nIzda-dcha ",'c','0'+salida->pares_pasadas.brev,
		's',u"\n\\end\n",0);

	towrite16_string(buf,u"\\begin Digi\n");
	towrite16_many_strings(buf,u"Ruta1\t",salida->fich_Digi.rutarel,NULL);
	towrite16_many_strings(buf,u"\nRuta2\t",salida->fich_Digi.rutaf,NULL);
	towrite16_string(buf,u"\nFicheros ");
	{uint n,mask;
	buf->prec.signi=6;
	n=salida->fich_Digi.files;
	mask=MASK_SalidaAjbloque_FDigi;
	write_bits_masked(buf,n,mask);}
	towrite(buf,
		's',u"\np.x ",'f',salida->fich_Digi.px,
		's',u"\np.y ",'f',salida->fich_Digi.py,
		's',u"\n\\end\n"
		u"\\begin ImageMaster\n",0);
	towrite16_many_strings(buf,u"Ruta1\t",salida->fich_Imaster.rutarel,NULL);
	towrite16_many_strings(buf,u"\nRuta2\t",salida->fich_Imaster.rutaf,NULL);
	towrite16_string(buf,u"\nFicheros ");
	{uint n,mask;
	n=salida->fich_Imaster.files;
	mask=MASK_SalidaAjbloque_FIMaster;
	write_bits_masked(buf,n,mask);}
	towrite16_string(buf,u"\n\\end\n");

	towrite16_string(buf,u"\\begin Informacion\n" "Residuos ");
	{uint n,mask;
	n=salida->fich_inf.infR;
	mask=MASK_SalidaAjbloque_InfR;
	write_bits_masked(buf,n,mask);}
	towrite16_string(buf,u"\nParametros ");
	{uint n,mask;
	n=salida->fich_inf.infP;
	mask=MASK_SalidaAjbloque_InfP;
	write_bits_masked(buf,n,mask);}
	towrite16_string(buf,u"\n\\end\n");

	towrite16_string(buf,u"\\begin Estadisticas\n"
		u"Residuos ");
	{uint n,mask;
	n=salida->fich_std.stdR;
	mask=MASK_SalidaAjbloque_StdR;
	write_bits_masked(buf,n,mask);}
	towrite16_string(buf,u"\n\\end\n"
				u"Precisiones ");
	{uint n,mask;
	n=salida->fich_std.stdP;
	mask=MASK_SalidaAjbloque_StdP;
	write_bits_masked(buf,n,mask);}
	towrite16_string(buf,u"\n\\end\n");
}
