void escribe_tex_modelo_poli(Bufferto8 *finf,u8int c){
	const char8_t* s;
	switch(c){
	    case CAL_MODPOL_IMPAR: switch(gb.idioma){
		  case Id_Eng:s="odd"; break;
		  case Id_It:	s="impare"; break;
		  case Id_Bra:s="impar"; break;
		  default:		s="impar";
	    }break;
	    case CAL_MODPOL_COMPLETO: switch(gb.idioma){
		  case Id_Eng:s="complete"; break;
		  case Id_It:	s="completo"; break;
		  case Id_Bra:s="completo"; break;
		  default:		s="completo";
	    }break;
	}
	towrite8_string(finf,s);
}
void escribe_tex_modelo_asim(Bufferto8 *finf,u8int c){
	const char8_t* s;
	switch(c){
	    case CAL_MODASIM_RADTAN: s="\\radialtangencial"; break;
	    case CAL_MODASIM_VECTOR: s="\\vectorgiratorio"; break;
	    default: return;
	}
	towrite8_string(finf,s);
}

void escribe_formulac_asims_rt_tex(Bufferto8 *finf,char8_t modelo,float* Xradasim,s8int decf){
	float a[ASIM_N],f;
	char8_t poli[4];

	colapsa_asimetrica_rt(modelo,Xradasim,a);
	poli[0]='s'; poli[3]='\0';

	setbuf_absolutep(finf,decf);
	for(u8int i=0;i<ASIM_N;){
		u8int j; s8int k;
		if((f=a[i])==0){i++; continue;}
		i++;
		towrite8_float(finf,f);

		j=poli_asim[i];
		if(modelo==CAL_MODPOL_COMPLETO) j=(j>>1)+1;
		if(j==1) poli[1]='\0';
		else{poli[1]='^'; poli[2]=(char8_t)(j+'0');}

		towrite8_string(finf,poli);

		const char8_t* trig;
		k=S_asim[i];
		if(k>0) trig="\\cos";
		else{trig="\\sen"; k=-k;}
		towrite8_string(finf,trig);
		if(k>1) toput_char(finf,(char8_t)(k+'0'));
		towrite8_string(finf,"\\theta");

		finf->maschar='+';
	}
	finf->maschar='\0';
}
void escribe_formulac_radasims_uv_tex(Bufferto8 *finf,char8_t modelo,float* Xserie1,float* Xserie2,s8int decf){
	float a1[ASIM_N],b1[ASIM_N],f,g;
	char8_t poli[4];

	if(Xserie1!=NULL) colapsa_asimetrica_uv(modelo,Xserie1,a1);	else{zeroset_float(a1,ASIM_N);}
	if(Xserie2!=NULL) colapsa_asimetrica_uv(modelo,Xserie2,b1);	else{zeroset_float(b1,ASIM_N);}
	poli[0]='s'; poli[3]='\0';

	setbuf_absolutep(finf,decf);
	if(Xserie1!=NULL){
		a1[0]+=Xserie1[0];
		a1[1]+=Xserie1[1];
	}
	for(u8int i=0;i<ASIM_N;){
		u8int j; u8int k;
		f=a1[i]+b1[i]; i++;
		g=a1[i]-b1[i];
		if(f==0 && g==0){i++; continue;}

		j=poli_asim[i];
		if(modelo==CAL_MODPOL_COMPLETO) j=(j>>1)+1;
		if(j==1) poli[1]='\0';
		else{poli[1]='^'; poli[2]=(char8_t)(j+'0');}

		k=(u8int)S_asim[i];	//i impar -> k>0
		if(f!=0){
			towrite8_float(finf,f);
			towrite8_string(finf,poli);
			towrite8_string(finf,"\\cos");
			if(k>1) toput_char(finf,(char8_t)(k+'0'));
			towrite8_string(finf,"\\theta");
			finf->maschar='+';
		}
		i++;
		if(g!=0){
			towrite8_float(finf,g);
			towrite8_string(finf,poli);
			towrite8_string(finf,"\\sen");
			if(k>1) toput_char(finf,(char8_t)(k+'0'));
			towrite8_string(finf,"\\theta");
			finf->maschar='+';
		}
	}
	finf->maschar='\0';
}
void escribe_formulac_tanasims_uv_tex(Bufferto8 *finf,char8_t modelo,float* Xserie1,float* Xserie2,s8int decf){
	float a1[ASIM_N],b1[ASIM_N],f,g;
	char8_t poli[4];

	if(Xserie1!=NULL) colapsa_asimetrica_uv(modelo,Xserie1,a1);	else{zeroset_float(a1,ASIM_N);}
	if(Xserie2!=NULL) colapsa_asimetrica_uv(modelo,Xserie2,b1);	else{zeroset_float(b1,ASIM_N);}
	poli[0]='s'; poli[3]='\0';

	setbuf_absolutep(finf,decf);
	if(Xserie2!=NULL){
		b1[1]+=Xserie2[0];
		b1[0]+=Xserie2[1];
	}
	for(u8int i=0;i<ASIM_N;){
		u8int j; u8int k;
		g=b1[i]-a1[i]; i++;
		f=a1[i]+b1[i];
		if(f==0 && g==0){i++; continue;}

		j=poli_asim[i];
		if(modelo==CAL_MODPOL_COMPLETO) j=(j>>1)+1;
		if(j==1) poli[1]='\0';
		else{poli[1]='^'; poli[2]=(char8_t)(j+'0');}

		k=(u8int)S_asim[i];	//i impar, k>0
		if(f!=0){
			towrite8_float(finf,f);
			towrite8_string(finf,poli);
			towrite8_string(finf,"\\cos");
			if(k>1) toput_char(finf,(char8_t)(k+'0'));
			towrite8_string(finf,"\\theta");
			finf->maschar='+';
		}
		i++;
		if(g!=0){
			towrite8_float(finf,g);
			towrite8_string(finf,poli);
			towrite8_string(finf,"\\sen");
			if(k>1) toput_char(finf,(char8_t)(k+'0'));
			towrite8_string(finf,"\\theta");
			finf->maschar='+';
		}
	}
	finf->maschar='\0';
}


void escribe_tex_afind(Bufferto8 *finf, float a,float b){
	float D,c;
	D=sqrtf(1-a*a-b*b);

	c=a-(1-D);	a+=1-D;
	D=1/D;
	a*=D;	b*=D;	c*=D;

	setbuf_absolutep(finf,6);
	towrite8(finf,'s',"\\def\\Afinda{", 'f',a, 's',"}\n\\def\\Afindb{", 'f',b, 's',"}\n\\def\\Afindc{", 'f',c, 's',"}\n",0);
}

int escribe_informe_calibracion(const char16_t* ficherotex, u8int idioma, OrientacionInterna *interna, const char16_t* nombretrabajo, const char16_t *uniim, const char16_t *unif, s8int decp, s8int decf, uint ntot, float vv){
	Bufferto8 finf;
	toopen_mixed(&finf,ficherotex);

	towrite8_string(&finf,"\\input InformeCalibracionpre\n");
	if(interna->flags&CAL_FLAG_Transf1) towrite8_string(&finf,"\\let\\ifprevia\\iftrue\n");
	if(interna->flags&CAL_FLAG_Distorsiones) towrite8_string(&finf,"\\let\\ifdistorsion\\iftrue\n");
	towrite8_string(&finf,"\\literal\n"
								"\\newtoks\\nombretrabajo \\nombretrabajo={");
	towrite_string16_charred(&finf,nombretrabajo);
	towrite8_string(&finf,"}\n\\restorecatcodes\n");

	towrite8_string(&finf,"\n\\def\\unip{");	towrite8_string16_charred(&finf,uniim);
	towrite8_string(&finf,"}\\def\\unif{");		towrite8_string16_charred(&finf,unif);
	towrite8_string(&finf,"}\n\\def\\npuntos{");
	towrite_uint(&finf,ntot); towrite8_string(&finf,"}\n");
	setbuf_relativep(&finf,2);
	towrite8_string(&finf,"\\def\\desvfoto{");
	tex_float(&finf,sqrtf(vv)); towrite8_string(&finf,"}\n");
	if(interna->flags&CAL_FLAG_Transf1){
		if(interna->afin_1.a!=1 || interna->afin_1.b!=0 || interna->afin_1.c!=0 || interna->afin_1.d!=1){
			s8int k;
			if(fabs(interna->afin_1.a)>fabs(interna->afin_1.b)) k=6;
			else{k=6-log10n_d(interna->afin_1.b)+log10n_d(interna->afin_1.a); if(k<1) k=1;}
			finf.prec.signi=(u8int)k;
			towrite8_string(&finf,"\\def\\matriza{"); towrite8_double(&finf,interna->afin_1.a);

			if(k==6){k=6-log10n_d(interna->afin_1.a)+log10n_d(interna->afin_1.b); if(k<1) k=1;}	else k=6;
			finf.prec.signi=(u8int)k;
			towrite8_string(&finf,"}\\def\\matrizb{"); towrite8_double(&finf,interna->afin_1.b);

			if(fabs(interna->afin_1.c)>fabs(interna->afin_1.d)) k=6;
			else{k=6-log10n_d(interna->afin_1.d)+log10n_d(interna->afin_1.c); if(k<1) k=1;}
			finf.prec.signi=(u8int)k;
			towrite8_string(&finf,"}\\def\\matrizc{"); towrite8_double(&finf,interna->afin_1.c);

			if(k==6){k=6-log10n_d(interna->afin_1.c)+log10n_d(interna->afin_1.d); if(k<1) k=1;}		else k=6;
			finf.prec.signi=(u8int)k;
			towrite8_string(&finf,"}\\def\\matrizd{"); towrite8_double(&finf,interna->afin_1.d);
			towrite8_string(&finf,"}\n");
		}
		if(interna->afin_1.Tx!=0 || interna->afin_1.Ty!=0){
			setbuf_absolutep(&finf,decp);
			towrite8(&finf,'s',"\\def\\Tx{", 'f',interna->afin_1.Tx, 's',"}\n\\def\\Ty{", 'f',interna->afin_1.Ty, 's',"}\n",NULL);
		}
	}
	setbuf_absolutep(&finf,decf);
	towrite8(&finf,'s',"\\def\\thefocal{", 'f',interna->valI.f, 's',"}\n",0);
	if(interna->valI.x==0 && interna->valI.y==0){
		towrite8_string(&finf,"\\def\\xp{0}\n\\def\\yp{0}\n");
	}else{
		towrite8(&finf,'s',"\\def\\xp{", 'f',interna->valI.x, 's',"}\n\\def\\yp{", 'f',interna->valI.y, 's',"}\n",NULL);
	}
	if(interna->flags&CAL_FLAG_Distorsiones && interna->distorsion.config.modelo_poli){
		setbuf_relativep(&finf,6); setbuf_limpio(&finf);
		towrite8(&finf,'s',"\\def\\semidiag{", 'f',interna->distorsion.config.semidiag, 's',"}\n"
			"\\def\\modeloPoli{",0);
		escribe_tex_modelo_poli(&finf,interna->distorsion.config.modelo_poli);
		towrite8_string(&finf,"}\n");
		setbuf_absolutep(&finf,decf); setbuf_nolimpio(&finf);
		if(interna->distorsion.config.param_radsim!=0){
			towrite8_string(&finf,"\n\\parsRadsim{");
			u16int l=interna->distorsion.config.param_radsim;
			for(u8int i=0;i<SIM_N;i++,l>>=1){
				if(l&1) towrite8(&finf,'s',"\\\\{a_", 'c',(char8_t)(i+'1'), 's',"}{", 'f',interna->distorsion.valores_radsim[i],'}',0);
			}
			towrite8_string(&finf,"\\enddata}\n""\\def\\formulaRadsim{");
			crea_formulac_simetricas(&finf,false,interna->distorsion.config.modelo_poli,interna->distorsion.valores_radsim,decf);
			towrite8_string(&finf,"}\n");
		}
		if(interna->distorsion.config.param_tansim!=0){
			towrite8_string(&finf,"\n\\parsTansim{");
			u16int l=interna->distorsion.config.param_tansim;
			for(u8int i=0;i<SIM_N;i++,l>>=1){
				if(l&1) towrite8(&finf,'s',"\\\\{b_", 'c',(char8_t)(i+'1'), 's',"}{", 'f',interna->distorsion.valores_tansim[i],'}',0);
			}
			towrite8_string(&finf,"\\enddata}\n""\\def\\formulaTansim{");
			crea_formulac_simetricas(&finf,false,interna->distorsion.config.modelo_poli,interna->distorsion.valores_tansim,decf);
			towrite8_string(&finf,"}\n");
		 }
	 if(interna->distorsion.config.modelo_asim){
		 towrite8(&finf,'s',"\\numAsim=", 'c',(char8_t)(interna->distorsion.config.modelo_asim+'0'), 's',"\n\\def\\modeloAsim{",0);
		 escribe_tex_modelo_asim(&finf,interna->distorsion.config.modelo_asim);
		 towrite8_string(&finf,"}\n\n");
	 }
	 if(interna->distorsion.config.param_asim1!=0){
		 towrite8_string(&finf,"\\parsAsimI{");
		 uint l=interna->distorsion.config.param_asim1;
		 for(u8int i=0;i<ASIM_N;i++,l>>=1){
			 if(l&1) towrite8(&finf,'s',"\\\\{c_{", 'u',i+1, 's',"}}{", 'f',interna->distorsion.valores_asim1[i],'}',0);
		 }
		 towrite8_string(&finf,"\\enddata}\n");
	 }
	 if(interna->distorsion.config.param_asim2!=0){
		towrite8_string(&finf,"\\parsAsimII{");
		 uint l=interna->distorsion.config.param_asim2;
		 for(u8int i=0;i<ASIM_N;i++,l>>=1){
			 if(l&1) towrite8(&finf,'s',"\\\\{d_{", 'u',i+1, 's',"}}{", 'f',interna->distorsion.valores_asim2[i],'}',0);
		 }
		 towrite8_string(&finf,"\\enddata}\n");
	 }
	 if(interna->distorsion.config.param_asim1!=0 || interna->distorsion.config.param_asim2!=0){
		 if(interna->distorsion.config.modelo_asim==1){
			 if(interna->distorsion.config.param_asim1!=0){
				 towrite8_string(&finf,"\\def\\formulaRadasim{");
				 escribe_formulac_asims_rt_tex(&finf,interna->distorsion.config.modelo_poli,interna->distorsion.valores_asim1,decf);
				 towrite8_string(&finf,"}\n");
			 }
			 if(interna->distorsion.config.param_asim2!=0){
				 towrite8_string(&finf,"\\def\\formulaTanasim{");
				 escribe_formulac_asims_rt_tex(&finf,interna->distorsion.config.modelo_poli,interna->distorsion.valores_asim2,decf);
				 towrite8_string(&finf,"}\n");
			 }
		 }elif(interna->distorsion.config.modelo_asim==2){
			 towrite8_string(&finf,"\\def\\formulaRadasim{");
			 escribe_formulac_radasims_uv_tex(&finf,interna->distorsion.config.modelo_poli,interna->distorsion.valores_asim1,interna->distorsion.valores_asim2,decf);
			 towrite8_string(&finf,"}\n\\def\\formulaTanasim{");
			 escribe_formulac_tanasims_uv_tex(&finf,interna->distorsion.config.modelo_poli,interna->distorsion.valores_asim1,interna->distorsion.valores_asim2,decf);
			 towrite8_string(&finf,"}\n");
		 }
	 }
 }
	const char8_t *s;
	switch(idioma){
		case Id_Eng:	s="eng"; break;
		case Id_It:	s="it"; break;
		case Id_Bra:	s="bra"; break;
		default:		s="esp";
	}
	towrite8_many_strings(&finf,"\n\\input Calibracion_",s,".tex\n\\input InformeCalibracion\n",NULL);
	toclose(&finf);
	return finf.error_code;
}
