﻿#include"escritura_tex.h"
void fPrecGirocgtex(Bufferto8 *finf, float fl, const char8_t* cg, const char8_t* unig){
	bint fixed=isbuf_absolute(finf);
	s8int prec=finf->prec.absol;
	s8int d;
	uint n;
	bint added;

	if(fl==0) d=0;
	else d=log10n(fl);
	if(fl<0){toput_char(finf,'-'); fl=-fl;}
	if(d-finf->prec.signi>=4 || -d>3){
		setbuf_absolute(finf);
		if(d>=0){dontimes(d,fl*=0.1F);}
		else{dontimes(-d,fl*=10.0F);}
		finf->prec.absol=(s8int)finf->prec.signi;
		if(finf->prec.signi>0) finf->prec.absol--;
		towrite8(finf,'s',"$\\diez{", 'f',fl, 's',"}{",0);
		if(d<0){toput_char(finf,'-'); d=-d;}
		towrite8_uint(finf,d); towrite8_string(finf,"}$");
		if(unig!=NULL){
			toput_char(finf,' '); towrite8_string(finf,unig);
		}
	}else{
		d=finf->prec.signi-d-1;
		if(d<=0){
			towrite(finf,'c','$', 'u',(uint)(fl+0.5F), 's',cg, 'c','$',0);
		}else{
			n=(uint)fl;
			if(d==1 || fl-n>=.9F){
				fl+=0.5F*pow10f(-d);
				n=(int)fl;
				added=true;
			}else added=false;
			towrite(finf,'c','$', 'u',n, 's',cg,0);
			fl-=n;
			fl*=pow10f(d); if(!added) fl+=0.5F;
			n=(uint)fl;
			if(isbuf_limpio(finf)){
				while(n!=0 && n%10==0) n/=10, d--;
				if(n==0) d=0;
			}
			if(d>0){
				finf->fillchar='0';
				towrite_aligned_uint(finf,n,d);
				toput_char(finf,' ');
			}
			toput_char(finf,'$');
		}
	}
	finf->prec.absol=prec;
	if(fixed) setbuf_absolute(finf);
}
void fPrecGirotex(Bufferto8 *finf,float fl, const char8_t* cg, const char8_t* unig, void (*equiv)(Bufferto8*,double), bint solo){
	if(equiv!=NULL && solo){
		toput_char(finf,'$');
		equiv(finf,fl);
		toput_char(finf,'$');
		return;
	}
	if(cg!=NULL) fPrecGirocgtex(finf,fl,cg,unig);
	else{
		toput_char(finf,'$');
		tex_float(finf,fl);
		toput_char(finf,'$'); toput_char(finf,' '); towrite8_string(finf,unig);
	}
	if(equiv!=NULL){
		towrite8_string(finf," $=$ $");
		equiv(finf,fl);
		toput_char(finf,'$');
	}
}

void escribe_tex_rescontrol(Bufferto8 *finf, PuntoM* puntosC, uint npc, uint* pC_a_pM, float* Lpc){
	PuntoM *punpm=puntosC;
	float *pL=Lpc;
	for(uint i=0;i<npc;i++,punpm++){
		uint k=pC_a_pM[i];
		if(k==Я) k=0;
		else k=punpm->bbb;

		towrite8_many_strings(finf,"\\\\{",punpm->nom,"}{",NULL);
		if(k&1) tex_float(finf,*pL);	else toput_char(finf,'-');		pL++;
		towrite8_string(finf,"}{");
		if(k&2) tex_float(finf,*pL);	else toput_char(finf,'-');		pL++;
		towrite8_string(finf,"}{");
		if(k&4) tex_float(finf,*pL);	else toput_char(finf,'-');		pL++;
		toput_char(finf,'}');
	}
}

void escribe_tex_resapoyo(Bufferto8 *finf, PuntoM* puntosA, float* Lp, uint* ind_Lp, uint l){
	if(l>20) l=20;
	Durchlaufei(uint,ind_Lp,l){
		uint kk=*ptri++;
		uint k=puntosA[kk].bbb;

		towrite8_many_strings(finf,"\\\\{",puntosA[kk].nom,"}{",NULL);
		float *pL=Lp+3*kk;
		if(k&1) tex_float(finf,*pL);	else toput_char(finf,'-');		pL++;
		towrite8_string(finf,"}{");
		if(k&2) tex_float(finf,*pL);	else toput_char(finf,'-');		pL++;
		towrite8_string(finf,"}{");
		if(k&4) tex_float(finf,*pL);	else toput_char(finf,'-');
		toput_char(finf,'}');
	}
}

void escribe_tex_reselevados(Bufferto8 *fajs, CentroProy* centros, int2* p_en_cp, uint* pm_ppios, uint npm, uint* orden_L, float* L_max, PuntoM* puntosM, float* L, float* L_norm, uint* pM_a_pA, PuntoM* puntosA, float* limites, u8int nasterisco, s8int decf, u8int idioma){
	const char8_t *s, *s2;
	u8int n;
	float levels[6]= {1E15F,10,5,4,3.08F,0};
	uint current_level;
	float level;

	if(npm==0){
		switch(idioma){
			case 1:  s="\\section{There aren't points with a high residual}\n"; break;
			case 2:  s="\\section{Non ci sono punti con residui elevati}\n"; break;
			case 3:  s="\\section{Não há pontos con resíduo elevado}\n"; break;
			default:s="\\section{No hay puntos con residuo elevado}\n";
		}
		towrite8_string(fajs,s);
		return;
	}

	if(L_max[orden_L[0]]>=10.F){
		switch(idioma){
			case 1:  s="\\section{Points with a residual greater than $10.0\\sigma$}\n"; break;
			case 2:  s="\\section{Punti con residuo maggiore di $10.0\\sigma$}\n"; break;
			case 3:  s="\\section{Pontos con resíduo maior que $10.0\\sigma$}\n"; break;
			default:s="\\section{Puntos con residuo mayor que $10.0\\sigma$}\n";
		}
		towrite8_string(fajs,s);
		if(decf>0) setbuf_relativep(fajs,(u8int)decf);
		else setbuf_absolutep(fajs,-decf);
	}
	current_level=1;
	level=10;
	for(uint ib=0;ib<npm;ib++){
		uint i,l,ll,pa;
		i=orden_L[ib];
		l=pm_ppios[i];
		ll=pm_ppios[i+1]-1;
		if(L_max[i]<level){
			current_level++;
			while(L_max[i]<levels[current_level]) current_level++;
			level=levels[current_level];
			switch(idioma){
				case 1:  s="\n\\section{Points with a residual between $"; s2="\\sigma$ and $"; break;
				case 2:  s="\n\\section{Punti con residuo fra $"; s2="\\sigma$ e $"; break;
				case 3:  s="\n\\section{Pontos con resíduo entre $"; s2="\\sigma$ e $"; break;
				default:s="\n\\section{Puntos con residuo entre $"; s2="\\sigma$ y $";
			}
			setbuf_absolutep(fajs,2);
			towrite(fajs,'s',s, 'f',level, 's',s2, 'f',levels[current_level-1], 's',"\\sigma$}\n",0);
			if(decf>0) setbuf_relativep(fajs,(u8int)decf);
			else setbuf_absolutep(fajs,-decf);
		}
		towrite8_many_strings(fajs,"\n\\punto{",puntosM[i].nom,"}{{",NULL);
		//Marca XYZ
		if((pa=pM_a_pA[i])!=Я){
			pa=puntosA[pa].bbb;
			if(pa&1) toput_char(fajs,'X');	else towrite8_string(fajs,"\\phantom{X}");
			if(pa&2) toput_char(fajs,'Y');	else towrite8_string(fajs,"\\phantom{Y}");
			if(pa&4) toput_char(fajs,'Z');	else towrite8_string(fajs,"\\phantom{Z}");
		}
		if(ll==l+2 && (pa==Я || pa==1 || pa==2 || pa==4)) s="}{!}}\n";
		elif(ll==l+1) s="}{!!}}\n";
		else s="}{}}\n";
		towrite8_string(fajs,s);

		int2 *pcp_j=p_en_cp+l;
		while(pcp_j->n1!=Я){
			uint k1=pcp_j->n1<<1;
			towrite8_many_strings(fajs,"\\respunto{",centros[pcp_j->n2].fot->nom,"}{{",NULL);
			pcp_j++;
			tex_float(fajs,L[k1]); towrite8_string(fajs,"}{");
			tex_float(fajs,L[k1+1]); towrite8_string(fajs,"}{");

			n=numero(L_norm[k1],limites);
			if(n==0) towrite8_string(fajs,"$\\cdot$");
			elif(n<nasterisco) towrite8_uint(fajs,n);
			else toput_char(fajs,'*');
			towrite8_string(fajs,"}{");
			n=numero(L_norm[k1+1],limites);
			if(n==0) towrite8_string(fajs,"$\\cdot$");
			elif(n<nasterisco) towrite8_uint(fajs,n);
			else toput_char(fajs,'*');
			towrite8_string(fajs,"}}\n");
		}
		towrite8_string(fajs,"\\enddata\n");
	}
}
