﻿int escribe_ficheroint(const char16_t* ficheroori, const OrientacionInterna *interna, s8int decim, s8int decf, char16_t* mensaje, u8int idioma){
	int nret;
	Bufferto8 fo;

	nret=toopen_mixed(&fo,ficheroori);
	ifunlike(nret){
		if(mensaje!=NULL){
			char16_t* pc=strbuild16(mensaje,S_Elfichero,ficheroori,S_no_se_pudo_abrir_para_escribir,NULL);
			strcpy16(pc,TEXTOS_fileopen[nret][idioma]);
		}
		return nret;
	}
	fo.maschar=' ';

	if(interna->info!=NULL){
		KeyVal *ptr=interna->info;
		setbuf_absolutep(&fo,decim);
		towrite8_string(&fo,"\\begin Info\n");
		while(ptr->key!=0){
			const char8_t *s=NULL;
			switch(ptr->key){
				case 1: s="minx \t"; break;
				case 2: s="maxx \t"; break;
				case 3: s="miny \t"; break;
				case 4: s="maxy \t"; break;
			}
			if(s!=NULL){
				towrite8_string(&fo,s);
				if(ptr->key<=4) towrite8_float(&fo,ptr->val.fl);
				toput_char(&fo,'\n');
			}
			ptr++;
		}
		towrite8_string(&fo,"\\end\n");
	}

	fo.prec.signi=6;
	if(interna->flags &1){
		towrite8_string(&fo,"\n\\begin Coordenadas medidas --> fotocoordenadas\n\n");
		setbuf_limpio(&fo);
		if(interna->afin_1.Tx!=0 || interna->afin_1.Ty!=0){
			setbuf_absolutep(&fo,decim);
			towrite8(&fo,'s',"Tx\t", 'f',interna->afin_1.Tx, 's',"\nTy\t", 'f',interna->afin_1.Ty, '\n', 0);
		}
		if(interna->afin_1.a!=1 || interna->afin_1.b!=0 || interna->afin_1.c!=0 || interna->afin_1.d!=1){
			setbuf_relative(&fo);
			towrite8(&fo,'s',"a \t", 'f',interna->afin_1.a, '\n',
							's',"b \t", 'f',interna->afin_1.b, '\n',
							's',"c \t", 'f',interna->afin_1.c, '\n',
							's',"d \t", 'f',interna->afin_1.d, '\n',0);
		}
		towrite8_string(&fo,"\n\\end\n\n");
	}
	setbuf_nolimpio(&fo);

	towrite8_string(&fo,"\n\\begin Orientacion interna media\n\n");
	setbuf_absolutep(&fo,decf);
	fo.maschar='\0'; towrite8_string(&fo,"f \t");	towrite8_double(&fo,interna->valI.f);
	fo.maschar=' ';
	towrite8_string(&fo,"\nxp\t");
	if(interna->valI.x!=0)	towrite8_double(&fo,interna->valI.x);	else toput_char(&fo,'0');
	towrite8_string(&fo,"\nyp\t");
	if(interna->valI.y!=0)	towrite8_double(&fo,interna->valI.y);	else toput_char(&fo,'0');
	towrite8_string(&fo,"\n\n\\end\n");

	if(interna->flags&4 && interna->distorsion.config.modelo_poli!=0){
		const char8_t *s;
		uint lshort;	//<= 1<<SIM_N - 1.

		towrite8_string(&fo,"\n\\begin Funcion de distorsion\n\n");
		setbuf_relative(&fo);
		fo.maschar='\0'; towrite8_string(&fo,"semidiag \t"); towrite8_float(&fo,interna->distorsion.config.semidiag);
		fo.maschar=' ';
		towrite8_string(&fo,"\nModelo polinomico \t");
		switch(interna->distorsion.config.modelo_poli){
			case CAL_MODPOL_IMPAR: s="Impar\n"; break;
			case CAL_MODPOL_COMPLETO: s="Completo\n"; break;
		}
		towrite8_string(&fo,s);
		if(interna->flags&96 && interna->distorsion.config.modelo_asim!=0){
			towrite8_string(&fo,"Modelo asimetrico \t");
			switch(interna->distorsion.config.modelo_asim){
				case CAL_MODASIM_RADTAN: s="rad/tan\n"; break;
				case CAL_MODASIM_VECTOR: s="u/v\n"; break;
			}
			towrite8_string(&fo,s);
		}
		setbuf_absolute(&fo);
		lshort=interna->distorsion.config.param_radsim;
		if(lshort!=0){
			towrite8_string(&fo,"\n\\begin Radial simetrica\n");
			{u8int i; for(i=0;lshort!=0;lshort>>=1,i++){
				if(!(lshort&1)) continue;
				towrite8(&fo,'c','a', 'u',(uint)(i+1),'\t', 'f',interna->distorsion.valores_radsim[i], '\n',0);
			}}
			towrite8_string(&fo,"\\end\n");
		}
		lshort=interna->distorsion.config.param_tansim;
		if(lshort!=0){
			towrite8_string(&fo,"\n\\begin Tangencial simetrica\n");
			{u8int i; for(i=0;lshort!=0;lshort>>=1,i++){
				if(!(lshort&1)) continue;
				towrite8(&fo,'c','b', 'u',(uint)(i+1),'\t', 'f',interna->distorsion.valores_tansim[i], '\n',0);
			}}
			towrite8_string(&fo,"\\end\n");
		}
		lshort=interna->distorsion.config.param_asim1;
		if(lshort!=0){
			towrite8_string(&fo,"\n\\begin Asimetrica serie1\n");
			{u8int i; for(i=0;lshort!=0;lshort>>=1,i++){
				if(!(lshort&1)) continue;
				towrite8(&fo,'c','c', 'u',(uint)(i+1),'\t', 'f',interna->distorsion.valores_asim1[i], '\n',0);
			}}
			towrite8_string(&fo,"\\end\n");
		}
		lshort=interna->distorsion.config.param_asim2;
		if(lshort!=0){
			towrite8_string(&fo,"\n\\begin Asimetrica serie2\n");
			{u8int i; for(i=0;lshort!=0;lshort>>=1,i++){
				if(!(lshort&1)) continue;
				towrite8(&fo,'c','d', 'u',(uint)(i+1),'\t', 'f',interna->distorsion.valores_asim2[i], '\n',0);
			}}
			towrite8_string(&fo,"\\end\n");
		}
		towrite8_string(&fo,"\n\\end Funcion de distorsion\n");
	}

	toclose(&fo);
	ifunlike(fo.error_code){
		if(mensaje!=NULL) strbuild16(mensaje,S_Hubo_un_error_al_escribir_el_fichero,ficheroori,S_El_fichero_generado_no_es_correcto,NULL);
	}
	return fo.error_code;
}

int escribe_ficheroint_cmr(const char16_t* ficheroori, const InternaKPB *mala, char16_t* mensaje, u8int idioma){
	int nret;
	Bufferto8 fo;
	u8int modelo;

	nret=toopen_mixed(&fo,ficheroori);
	ifunlike(nret){
		if(mensaje!=NULL){
			char16_t* pc=strbuild16(mensaje,S_Elfichero,ficheroori,S_no_se_pudo_abrir_para_escribir,NULL);
			strcpy16(pc,TEXTOS_fileopen[nret][idioma]);
		}
		return nret;
	}

	if(mala->p1==0 && mala->p2==0) modelo=1;
	elif(mala->k[3]==0) modelo=2;
	else modelo=3;

	setbuf_relativep(&fo,6);
	towrite8(&fo,'f',mala->f, 's'," // Focal Length\n", 'f',mala->pixels.px*mala->pixels.cx+mala->x, 's'," // Xp\n", 'f',mala->pixels.py*mala->pixels.cy-mala->y, 's'," // Yp\n", 0);
	{const char8_t *s;
	if(modelo==1) s="1 // Distortion Model\n"
						"3 // Number of Distortion Parameters\n";
	elif(modelo==2) s="2 // Distortion Model\n"
							 "4 // Number of Distortion Parameters\n";
	else /*3*/ s="3 // Distortion Model\n"
				 "5 // Number of Distortion Parameters\n";
	towrite8_string(&fo,s);
	}

	setbuf_scientific(&fo);
	towrite8(&fo,'f',-mala->k[1], 's'," // k1\n", 'f',-mala->k[2], 's'," // k2\n", 0);
	if(modelo!=2) towrite8(&fo,'f',-mala->k[3], 's'," // k3\n", 0);
	if(modelo!=1) towrite8(&fo,'f',-mala->p1, 's'," // p1\n", 'f',-mala->p2, 's'," // p2\n", 0);

	if(mala->pixels.px==1.0 && mala->pixels.py==1.0){
		towrite8_string(&fo,"1.000000 // X Resolution\n1.000000 // Y Resolution\n");
	}else{
		setbuf_absolutep(&fo,6);
		setbuf_noscientific(&fo);
		towrite8(&fo,'f',mala->pixels.px, 's'," // X Resolution\n", 'f',mala->pixels.py, 's'," // Y Resolution\n", 0);
	}
	towrite8_string(&fo,"0 // Number of Fiducial Marks\n");

	toclose(&fo);
	ifunlike(fo.error_code){
		if(mensaje!=NULL) strbuild16(mensaje,S_Hubo_un_error_al_escribir_el_fichero,ficheroori,S_El_fichero_generado_no_es_correcto,NULL);
	}
	return fo.error_code;
}

int escribe_ficheroint_Digi(const char16_t* ficheroori, const InternaKPB *mala, char16_t* mensaje, u8int idioma){
	int nret;
	Bufferto8 fajs;
	float b1;

	nret=toopen_mixed(&fajs,ficheroori);
	ifunlike(nret){
		if(mensaje!=NULL){
			char16_t* pc=strbuild16(mensaje,S_Elfichero,ficheroori,S_no_se_pudo_abrir_para_escribir,NULL);
			strcpy16(pc,TEXTOS_fileopen[nret][idioma]);
		}
		return nret;
	}

	setbuf_relativep(&fajs,6);
	setbuf_limpio(&fajs);
	towrite8_string(&fajs,"[Camara]\n");
	//Ignoro los valores de cx y cy.  px!=py (pero parecido, e. d., píxeles aprox. cuadrados) se tiene en cuenta más abajo
	towrite8(&fajs,'s',"Focal=", 'f',mala->f,'\n',
					's',"TamanoPixel= ", 'f',mala->pixels.py,'\n',0);
	if(mala->pixels.cx!=0 || mala->pixels.cy!=0){
		towrite8(&fajs,'s',"CentroFiducial= ", 'f',mala->pixels.px*mala->pixels.cx,' ', 'f',mala->pixels.py*mala->pixels.cy, '\n',0);
	}
	towrite8(&fajs,'s',"PuntoPrincipal= ", 'f',mala->x,' ', 'f',mala->y, '\n',0);
	setbuf_scientific(&fajs);
	towrite8(&fajs,'s',"k0= ", 'f',mala->k[0], 's',"\nk1= ", 'f',mala->k[1], 's',"\nk2= ", 'f',mala->k[2], 's',"\nk3= ", 'f',mala->k[3], '\n',0);
	if(mala->k[4]!=0) towrite8(&fajs,'s',"k4= ", 'f',mala->k[4], '\n',0);
	towrite8(&fajs,'s',"p1= ", 'f',mala->p1, 's',"\np2= ", 'f',mala->p2,'\n', 0);

	b1=mala->b1;
	if(mala->pixels.px!=mala->pixels.py && mala->pixels.px*1.1>mala->pixels.py && mala->pixels.py*1.1>mala->pixels.px) /*otherwise ignore it; it is not the distortion*/
		b1+=(float)(mala->pixels.px-mala->pixels.py)/(float)mala->pixels.py;
	if(b1!=0 || mala->b2!=0){
		towrite8(&fajs,'s',"b1= ", 'f',b1, 's',"\nb2= ", 'f',mala->b2,'\n', 0);
	}
	toclose(&fajs);
	ifunlike(fajs.error_code){
		if(mensaje!=NULL) strbuild16(mensaje,S_Hubo_un_error_al_escribir_el_fichero,ficheroori,S_El_fichero_generado_no_es_correcto,NULL);
	}
	return fajs.error_code;
}

//Si mala.py es 1.0 se supone que la y está almacenada hacia arriba e INC no se escribe
int escribe_ficheroint_ini(const char16_t* ficheroori, const InternaKPB *mala, const double desplins[3][3], char16_t* mensaje, u8int idioma){
	int nret;
	Bufferto8 fajs;
	u8int c;
	Giro3D_double G;
	float b1;

	nret=toopen_mixed(&fajs,ficheroori);
	ifunlike(nret){
		if(mensaje!=NULL){
			char16_t* pc=strbuild16(mensaje,S_Elfichero,ficheroori,S_no_se_pudo_abrir_para_escribir,NULL);
			strcpy16(pc,TEXTOS_fileopen[nret][idioma]);
		}
		return nret;
	}

	setbuf_relativep(&fajs,6);
	setbuf_limpio(&fajs);
	towrite8_string(&fajs,"[CAMERA_1]");
	if(desplins!=NULL) towrite8_string(&fajs,"                 ; offset values IMU => Camera | Camera parameter");
	toput_char(&fajs,'\n');
	c=16;	//none
	if(desplins!=NULL){
		//Since these values are expected to be very small, the order of the rotations is not very important. Furthermore,
		//I suspect the software reading the offsets does not actually build a rotation matrix properly. If it did,
		//the function to be used should be Gmatriz_FOK (so that imu->foto were KOF). These as well was the current
		//implementation below suppose the aircraft Y axis to follow the longitudinal direction (tail - nose) of it.
		G=Getoffset_matriz(desplins,&Gmatriz_ωφκ_seg,(u8int*)&c);
		if(c&1) c-=2;	//4-c (mod 4), absolute least residue
		P_mul(G,-180/PI);	//imu->foto. K,Φ,Ω + K(90c), criterio Aerotri
	}
	if(mala->pixels.py!=1.0F) towrite8(&fajs,'s',"INC         = ", 'f',mala->pixels.py,'\n',0);
	if(mala->pixels.cx!=0 || mala->pixels.cy!=0){
		towrite8(&fajs,'s',"XPIX        = ", 'f',2*mala->pixels.cx, 's',"\nYPIX        = " ,'f',2*mala->pixels.cy, '\n',0);
	}
	towrite8(&fajs,'s',"FOC          = ", 'f',mala->f, '\n',0);
	fajs.maschar='+';
	{double x, y;
	if(!(c&1)){x=mala->x; y=mala->y;}
	else{x=-mala->y; y=mala->x;}
	if(c&2){x=-x; y=-y;}
	towrite8(&fajs,'s',"XPP          = ", 'f',x, 's',"\nYPP          = ", 'f',y, '\n',0);
	}
	setbuf_scientific(&fajs);
	if(mala->k[0]!=0) towrite8(&fajs,'s',"K0          = ", 'f',mala->k[0], '\n',0);
	towrite8(&fajs,'s',"K1          = ", 'f',mala->k[1], 's',"\nK2          = ", 'f',mala->k[2], 's',"\nK3          = ", 'f',mala->k[3], '\n',0);
	if(mala->k[4]!=0) towrite8(&fajs,'s',"K4          = ", 'f',mala->k[4], '\n',0);
	if(mala->p1!=0 || mala->p2!=0){
		towrite8(&fajs,'s',"P1          = ", 'f',mala->p1, 's',"\nP2          = ", 'f',mala->p2,'\n', 0);
	}

	b1=mala->b1;
	if(mala->pixels.px!=mala->pixels.py && mala->pixels.px*1.1>mala->pixels.py && mala->pixels.py*1.1>mala->pixels.px) /*otherwise ignore it; it is not the distortion*/
		b1+=(float)(mala->pixels.px-mala->pixels.py)/(float)mala->pixels.py;
	if(b1!=0 || mala->b2!=0){
		towrite8(&fajs,'s',"b1= ", 'f',b1, 's',"\nb2= ", 'f',mala->b2,'\n', 0);
	}
	toput_char(&fajs,'\n');
	if(c!=16){
		towrite8(&fajs,'s',"ROLL        = ", 'f',-G.φ, 's'," \t;degrees\nPITCH       = ", 'f',-G.ω, 's',"\nHEAD      = ", 'f',G.κ, 0);
		towrite8(&fajs,'s',"\nORIENTATION = ", 'f',(float)c*90.0F, '\n',0);
	}
	toclose(&fajs);
	ifunlike(fajs.error_code){
		if(mensaje!=NULL) strbuild16(mensaje,S_Hubo_un_error_al_escribir_el_fichero,ficheroori,S_El_fichero_generado_no_es_correcto,NULL);
	}
	return fajs.error_code;
}
